{
  "EXPTSYS.PAS"  ( UNIT : EXPORT )  Q[gEFCVXe
}

unit exptsys;

{----------------------------------------------------------------------}
interface

Uses JmpCall,
   header, rsdriver, timer, kernel, filmangr, monitor, io, chatsys;

procedure export;

{----------------------------------------------------------------------}
implementation

(* ς炸ł :-)  *)

const
  transint=16;      { 16 bytes max rate }
  inportlimit=10;   { 10 sec }
  outportlimit=5;   {  5 sec }
  exportendwait=3;  {  3 sec }

function small(s:string):string;
  const
    smaller:set of char=[#$60..#$7f];
  var
    i:byte;
  begin
    for i:=1 to length(s) do
      if s[i] in smaller then s[i]:=char(byte(s[i])-$20);
    small:=s;
  end;

procedure printchar(och:char);
  begin
    if (cn=0) or (hoststat=cn) then begin
      if int29call then asm
        mov al,&och
        int 29h
      end
      else write(och);
    end;
    if cn>0 then xmitchar(och);
  end;

function inputchar:char;
  begin
    if cn=0 then inputchar:=readkey
    else inputchar:=recvchar;
  end;

function inport(chn:byte):char;
  var
    bkup:shortint;
  begin
    transok:=false;
    bkup:=cn;
    cn:=chn;
    if inready then inport:=recvchar;
    cn:=bkup;
    transok:=true;
  end;

procedure outport(chn:byte;inch:char);
  var
    bkup:shortint;
  begin
    transok:=false;
    bkup:=cn;
    cn:=chn;
    if outready then xmitchar(inch);
    cn:=bkup;
    transok:=true;
  end;

function inportready(chn:byte):boolean;
  var
    bkup:shortint;
  begin
    transok:=false;
    bkup:=cn;
    cn:=chn;
    inportready:=inready;
    cn:=bkup;
    transok:=true;
  end;

function outportready(chn:byte):boolean;
  var
    bkup:shortint;
  begin
    transok:=false;
    bkup:=cn;
    cn:=chn;
    outportready:=outready;
    cn:=bkup;
    transok:=true;
  end;

function ctsport(chn:byte):boolean;
  var
    bkup:shortint;
  begin
    transok:=false;
    bkup:=cn;
    cn:=chn;
    ctsport:=(cts or not cnarg[chn]^.enablest) and cnarg[chn]^.intime;
    cn:=bkup;
    transok:=true;
  end;

procedure flowport(chn:byte;flow:boolean);
  var
    bkup:shortint;
  begin
    transok:=false;
    bkup:=cn;
    cn:=chn;
    flowctrl(flow);
    cn:=bkup;
    transok:=true;
  end;

procedure flushport(chn:byte);
  var
    bkup:shortint;
  begin
    transok:=false;
    bkup:=cn;
    cn:=chn;
    flushed;
    cn:=bkup;
    transok:=true;
  end;

procedure endport(chn:byte);
  var
    bkup:shortint;
  begin
    transok:=false;
    bkup:=cn;
    cn:=chn;
    linecut;
    cn:=bkup;
    transok:=true;
    waiting(seccnt*exportendwait);
    transok:=false;
    cn:=chn;
    raiserts;
    cn:=bkup;
    transok:=true;
  end;

function inportstr(chn:byte;istr:string):boolean;
  var
    temp:string;
    cnt :word;
    inch:char;
    tmov:boolean;
  begin
    temp:='';
    tmov:=false;
    cnt:=gettcount;
    repeat
      if inportready(chn) then begin
        inch:=inport(chn);
        temp:=temp+inch;
        cnt:=gettcount;
        if pos(temp,istr)<>1 then begin
          if pos(inch,istr)=1 then temp:=inch
          else temp:='';
        end;
      end;
      tmov:=calctcount(cnt)>(seccnt*inportlimit);
      if inready and (inputchar=#03) then tmov:=true;
    until (temp=istr) or tmov;
    inportstr:=tmov;
  end;

procedure outportstr(chn:byte;ostr:string;var error:boolean);
  var
    cnt :word;
    loop:byte;
  begin
    loop:=1;
    error:=false;
    cnt:=gettcount;
    while not error and (loop<=length(ostr)) do begin
      waiting(seccnt div 40);
      if outportready(chn) then begin
        outport(chn,ostr[loop]);
        inc(loop);
        cnt:=gettcount;
      end;
      if calctcount(cnt)>(seccnt*outportlimit) then error:=true;
    end;
  end;

function outselfready:boolean;
  begin
    if cn=0 then outselfready:=true
    else outselfready:=outready;
  end;

procedure getcpltport(chn:byte;modemcode:string);
  var
    temp:string;
    cnt :word;
    err :boolean;
  begin
    repeat
      flushport(chn);
      outport(chn,#$0D);
      outportstr(chn,modemcode,err);
      temp:='';
      cnt:=gettcount;
      repeat
        transfernext;
        if inportready(chn) then temp:=temp+inport(chn);
      until (calctcount(cnt)>seccnt*5) or
        (pos('OK',temp)>0) or (pos('0',temp)>0);
    until (pos('OK',temp)>0) or (pos('0',temp)>0);
  end;

{------------------------------------------------}

function enterexport(chn:byte):boolean;
  begin
    enterexport:=(cnarg[chn]^.lineexport<>lnormal) and
      ((cnarg[chn]^.linelevel<=cnarg[cn]^.access) and
      ((cnarg[chn]^.linegroup=0) or ((cnarg[chn]^.linegroup>0) and
      cnarg[cn]^.groups[cnarg[chn]^.linegroup])));
   {  and (cnarg[loop]^.cnstat in [zawait,zclose,zewait]) and
      ((not cnarg[loop]^.lineotime) or cnarg[loop]^.opencn[hours]);  }
  end;

procedure exportlist;
  var
    loop:shortint;
    cnt :byte;
    temp:string;
    dumy:word;
    hours:word;
    prt :boolean;
  begin
    lineout('');
    lineout('[32mNo. H Export system                    Service[m');
    lineout('[33m--- - -------------------------------- -------[m');
    cnt:=0;
    prt:=false;
    for loop:=1 to MaxCnNum do begin
      if enterexport(loop) then begin
        inc(cnt);
        str(cnt:2,temp);
        if cnarg[loop]^.linehelp='' then temp:=temp+'  [33m. '
        else temp:=temp+'  [33mo ';
        stringout('[32m'+temp+'[m'+copy(cnarg[loop]^.linename+
          '                                 ',1,33));
        clock(dumy,dumy,dumy,hours,dumy,dumy);
        if cnarg[loop]^.linelock then temp:='[33mgp'
        else if (not (cnarg[loop]^.cnstat in [zawait,zclose,zewait])) or
          (cnarg[loop]^.lineotime and (not cnarg[loop]^.opencn[hours])) then
          temp:='[31m~'
        else temp:='[36mgp';
        lineout(temp+'[m');
        prt:=true;
      end;
    end;
    if cnarg[cn]^.cancelled then cnarg[cn]^.cancelled:=false;
    if not prt then lineout('[31m*** T[rX܂[m');
    lineout('[33m--- - -------------------------------- -------[m');
  end;

function checknumber(select:byte;mess:boolean):byte;
  procedure lineoutwith(s:string);
    begin
      if mess then lineout(s);
    end;
  var
    loop :byte;
    num  :byte;
    hours:word;
    dumy :word;
  begin
    checknumber:=0;
    lineout('');
    loop:=1;
    num:=0;
    repeat
      if enterexport(loop) then inc(num);
      inc(loop);
    until (num=select) or (loop>MaxCnNum);
    dec(loop);
    if num<>select then begin
      lineout('[31mw̃T[rX͂܂B[m');
      exit;
    end;
    if cnarg[loop]^.linelock then begin
      lineoutwith('[33mw̃T[rX͌ݎgpłB[m');
      exit;
    end;
    clock(dumy,dumy,dumy,hours,dumy,dumy);
    if (not (cnarg[loop]^.cnstat in [zawait,zclose,zewait])) or
      (cnarg[loop]^.lineotime and (not cnarg[loop]^.opencn[hours])) then begin
      lineoutwith('[33mw̃T[rX͌ݒ~ɂȂĂ܂B[m');
      exit;
    end;
  { if (cnarg[loop]^.linelevel>cnarg[cn]^.access) or
      ((cnarg[loop]^.linegroup>0) and
      not cnarg[cn]^.groups[cnarg[loop]^.linegroup]) then begin
      lineout('[31mw̃T[rX𗘗p邱Ƃ͏o܂B[m');
      exit;
    end; }
    checknumber:=loop;
  end;

procedure exportlookhelp;
  var
    temp:string;
    num:byte;
    dumy:integer;
  begin
    repeat
      exportlist;
      lineoutifneed;
      cnarg[cn]^.prompt:='[36mwvǂރT[rXw肵ĉ[m ([33m0:quit[m) >';
      temp:=getinput(cnarg[cn]^.prompt,10,echo);
      val(temp,num,dumy);
      if (num=0) or (dumy>0) then exit;
      num:=checknumber(num,false);
      if num=0 then exit;
      lineout('');
      if cnarg[num]^.linehelp<>'' then begin
        lineout('[33m------------------------------------------------------------------- [32mExport help[m');
        outfile(profdrive+cnarg[num]^.linehelp);
        lineout('[33m-------------------------------------------------------------------------------[m');
      end
      else lineout('[31m̃T[rXɂ̓wv܂B');
    until not cts;
  end;

procedure exporthelp;
  begin
    lineout('');
    outfile(bmesdrive+j_exporthelp);
  end;

procedure transmitterminal(chn:byte);
  var
    temp:char;
    send:char;     { for handshaking }
    recv:char;     {        :        }
    sok :boolean;
    rok :boolean;
    ctrl:boolean;
    exfl:boolean;
    abt :boolean;
    cnt :byte;
    chk1:boolean;
    chk2:boolean;
    kilf:boolean;
    kfst:boolean;
    kcnt:word;
    crin:boolean;
  begin
    flowctrl(false);
    sok:=false;
    rok:=false;
    ctrl:=false;
    exfl:=false;
    abt:=false;
    kilf:=false;
    kfst:=false;
    crin:=true;
    repeat
      cnarg[cn]^.cancelled:=false;
      cnt:=transint;
      repeat
        chk1:=inportready(chn) and not rok;
        if chk1 then begin
          recv:=inport(chn);
          rok:=true;
        end;
        chk2:=outselfready and rok;
        if chk2 then begin
          printchar(recv);
          rok:=false;
        end;
        dec(cnt);
      until not chk1 or not chk2 or (cnt=0);
      cnt:=transint;
      repeat
        chk1:=inready and not sok;
        if chk1 then begin
          send:=inputchar;
          sok:=true;
          if kilf then begin
            if send=#$01 then begin
              kfst:=true;
              kcnt:=gettcount;
            end
            else kfst:=false;
          end;
          if (send='~') and (not ctrl) and (not kilf) and crin then begin
            sok:=false;
            ctrl:=true;
            crin:=false;
            printchar('~');
          end
          else if ctrl then begin
            ctrl:=false;
            if upcase(send) in ['W','T','C','#','\','?','.'] then begin
              printchar(upcase(send));
              flushed;
              flowctrl(true);
              lineout('');
              case upcase(send) of
                'W':who0;
                'T':talks;
                'C':begin
                    lineout('[32mR}hLZ[h[m');
                    lineout(
                      '[35m^[mA[33m Rb҂ƂŕA܂[m');
                    kilf:=true;
                end;
                '#':showstatus;
                '\':writememo;
                '?':exporthelp;
                '.':exfl:=true;
              end;
              lineout('');
              flowctrl(false);
              sok:=false;
              crin:=true;
            end;
          end
          else if send in [#$0a,#$0d] then crin:=true
          else crin:=false;
        end;
        chk2:=outportready(chn) and sok;
        if chk2 then begin
          outport(chn,send);
          sok:=false;
        end;
        dec(cnt);
      until not chk1 or not chk2 or (cnt=0);
      abt:=not ctsport(chn);
      if kfst and (calctcount(kcnt)>seccnt*3) then begin
        flushed;
        flowctrl(true);
        lineout('');
        lineout('[33mLZ[h܂B[m');
        kilf:=false;
        kfst:=false;
        crin:=true;
        flowctrl(false);
      end;
    until exfl or abt or not cts;
    flowctrl(true);
  end;

procedure exportexec(select:byte);
  var
    loop:byte;
    num :byte;
    temp:string;
    send:string;
    mode:boolean;
    error:boolean;
    thru:word;
  begin
    loop:=checknumber(select,true);
    if loop=0 then exit;
    cnarg[loop]^.linelock:=true;
    stringout('[36mAڑł[m ...');
    send:=cnarg[loop]^.lineinit;
    mode:=true;
    num:=1;
    error:=false;
    flowport(loop,false);
    flushport(loop);
    repeat
      temp:='';
      thru:=0;
      while not (send[num] in ['[',']']) and
        (length(send)>=num) and (thru=0) do begin
        case send[num] of
          ex1:temp:=temp+small(cnarg[cn]^.caller);
          ex2:temp:=temp+cnarg[cn]^.caller;
          ex3:temp:=temp+cnarg[cn]^.handle_name;
          ex4:temp:=temp+cnarg[cn]^.password;
          ex5:thru:=1;
          ex6:thru:=2;
          else temp:=temp+send[num];
        end;
        inc(num);
      end;
      if mode then outportstr(loop,temp,error)
      else error:=inportstr(loop,temp);
      if thru>0 then waiting(seccnt*2*thru)
      else case send[num] of 
        '[':begin
            waiting(seccnt div 2);
            inc(num);
            mode:=false;
        end;
        ']':begin
            waiting(seccnt div 2);
            inc(num);
            mode:=true;
        end;
      end;
    until (length(send)<num) or error or not cts;
    if error then begin
      lineout('[31m ڑs[m');
      lineout('');
      lineout('[31mT[rXVXeƂ̐ڑs܂B[m');
      endport(loop);
      cnarg[loop]^.linelock:=false;
      exit;
    end;
    lineout('[33m ڑ܂[m');
    if cnarg[cn]^.expert<>eexpert then exporthelp;
    lineout('');
    transmitterminal(loop);
    lineout('  [m');
    lineout('');
    stringout('[36mIł[m ...');
    endport(loop);
    if (cnarg[loop]^.lineexport=lcross) and
      not cnarg[loop]^.nulmodem then begin
      getcpltport(loop,'ATZ'+#$0D);
      getcpltport(loop,cnarg[loop]^.ModemInitCode);
    end;
    lineout('[33m I[m');
    lineout('');
    lineout('[32mQ[gEFCT[rXI܂B[m');
    flushport(loop);
    cnarg[loop]^.linelock:=false;
  end;

{----------------------------------------------}

procedure export;
  var
    loop:byte;
    num :byte;
    dumy:integer;
    temp:string[10];
  begin
    num:=0;
    for loop:=1 to MaxCnNum do
      if enterexport(loop) then inc(num);
    if num=0 then begin
      lineout('');
      lineout('[33mQ[gEFCT[rX͍sĂ܂B[m');
      exit;
    end;
    cnarg[cn]^.cnstat:=zexport;
    if hoststat = 0 then dispstatus(cn);
    lineout('');
    str(num:2,temp);
    lineout('[36mQ[gEFCT[rX@[33mT[rX[m:[32m'+
      temp+'[m');
    if cnarg[cn]^.expert=ebegin then begin
      lineout('');
      outfile(bmesdrive+j_export);
    end;
    repeat
      if cnarg[cn]^.expert<>eexpert then exportlist;
      lineoutifneed;
      cnarg[cn]^.prompt:=
        '[36mEXPORT[m ([33mL:list  nn:export  H:help  ?:menu  0:quit[m) >';
      temp:=allcaps(getinput(cnarg[cn]^.prompt,10,echo));
      if (temp='L') and (cnarg[cn]^.expert=eexpert) then exportlist
      else if temp='H' then exportlookhelp
      else if temp='?' then begin
        lineout('');
        outfile(bmesdrive+j_export);
      end
      else begin
        val(temp,num,dumy);
        if (num>0) and (dumy=0) then exportexec(num);
      end;
    until ((num=0) and (dumy=0)) or not cts;
  end;

end.

