
;===========================================================
;  RS232C ײް (Sending recovery for interrupt)
;    Driver version     : 2.5
;    Interface revision : 1.02  ('RTRS$102')
;  Copyright by Eskage/ComServeNOBUYA
;
;  荞݃n}ΑM[ :-)       (Ȃ񂾂)
;
; The resource IWi
; '91.05.15 RSDRV61K.ASM NB
; '91.11.04 I[o[N₷ۂ̉P
; '91.11.11 RSDRV98/RSDRV61K/RSDRV32C (NOBUYA)
; '91.11.24 AIWA B98-01 Ή                (NOBUYA)
; '91.11.24 荞݃}XN̕A΍        (ComServe)
; '91.11.26 ꂵ XON ̍폜             (ComServe)
; --------- M荞ݔ (rsdrvsir.asm)
; '91.11.27 M荞ݎ                (ComServe)
; '91.11.27 rWύX̂P            (ComServe)
; '91.12.04 M荞ݕύX                (NOBUYA)
; '91.12.04 荞݂d̂ŕύX      (ComServe)
; '91.12.04 rWύX̂Q            (ComServe)
; '92.01.07 Cx߂̏CiHj        (ComServe)
; '92.01.08 }NCHCN              (NOBUYA)
;           ݋/֎~֘Aŷر
; '92.01.08 txready dlƈقȂĂ  (ComServe)
; '92.01.16 rWύX̂R            (ComServe)
; '92.02.24 荞ݕ̕ύX    (ComServe)
;           iƒ悤j
; '92.03.30 M荞ݗpobt@̏k    (ComServe)
; '92.05.09 XON/OFF ̔肪t        (MOTO)
; '92.06.02 PIO-9032B ̃{[[gݒ    (Take)
; '92.06.02 CTS̃oOĈP             (ComServe)
; '92.07.08 PIO-9032C ̊荞݃}XN    (MOGURA)
; '92.07.08 CTS̃oOĈQ()   (ComServe)
; '92.07.12 CTS̃oOĈR             (ComServe)
; '92.07.14 荞ݍē΍                (KAZ/09.02ɂč폜BJlł)
; '92.07.16 CTS̃oOĈS             (ComServe)
; '92.07.17 Mޯ̧ر݂̂Ƃ(ComServe)
; '92.07.18 LœK                      (ComServe)
; '92.07.19 荞ݗD揇ʂ̉]          (ComServe)
; '92.09.02 EOIs̕ύX                 (Take/10.17ɂČ֖߂܂B)
; '92.10.07 D揇ʉ]̃oOC          (ComServe)
; '92.10.17 GbWgKN悤ɕύX  (ComServe)
; '93.01.03 S̈׃EFCg𑝂₵      (ComServe)
; '93.01.03 VSYNC ̕U                (ComServe)
;
; AZuIvVō\z{[hI鎖
; iMASM /DBOARD=PC98_ONLY | PC_9861K | PIO_9032C | B98_01j
;
;===========================================================

DEVICE          equ     'RS send for interrupt '
VERSION         equ     ' ver2.6  for rev1.02'
DATE            equ     '1993/01/03'
DRV_REV         equ     'RTRS$102'
;

;                        12345678901234567890123456789012345678
COPYRIGHT       equ     'Copyright by Eskage/ComServeNOBUYA   ',DATE


PC98_ONLY       equ     0
PC_9861K        equ     1
PIO_9032C       equ     2
B98_01          equ     3

;BOARD           equ     PC98_ONLY
;BOARD           equ     B98_01
;--------------------------------------------------
;    ްޕʏ  \tgEFA
;--------------------------------------------------
if      BOARD   eq      PC98_ONLY
;
; PC-9801 W RS-232C ߰Ă̂
;
CH_MAX          equ     1
CMD_MAX         equ     0FH
TTL_LEN         equ     48
;                               123456
RS_TTL          equ     DEVICE,'on232c',VERSION

elseif  BOARD   eq      PC_9861K
;
; PC-9801 W RS-232C ߰ + PC-9861K (PIO-9032B)
;
CH_MAX          equ     3
CMD_MAX         equ     2FH
TTL_LEN         equ     48
;                               123456
RS_TTL          equ     DEVICE,'9861K ',VERSION

elseif  BOARD   eq      PIO_9032C
;
; PC-9801 W RS-232C ߰ + PIO-9032C (PIO-9032B~2)
;
CH_MAX          equ     5
CMD_MAX         equ     4FH
TTL_LEN         equ     48
;                               123456
RS_TTL          equ     DEVICE,'9032C ',VERSION

elseif  BOARD   eq      B98_01
;
; PC-9801 W RS-232C ߰ + B98-01
;
CH_MAX          equ     3
CMD_MAX         equ     2FH
TTL_LEN         equ     48
;                               123456
RS_TTL          equ     DEVICE,'B98-01',VERSION
endif

;--------------------------------------------------
;    ްޕʏ@n[hEFA
;       INTMSKD:8259 ϽPIC   Ͻޯ
;       INTMSKS:8259 ڰPIC Ͻޯ
;
;    ߰ĕʏ
;       RSDAT:  8251 ްڼ޽
;       RSCNT:  8251 Ӱ//ðڼ޽
;       RSSTA:  RS-232C ٥ڼ޽
;       RSMSK:  Ͻڼ޽
;       RSMR:   Ͻڼ޽ ǂݍ݉\i`Ή\j
;       INTEBL: Ͻڼ޽ ޯ
;       INTDIS: Ͻڼ޽ ֎~ޯ
;       INTVEC: ޸ԍ
;       IMRMSK: 8259 IMR Ͻޯ
;       PICMST: 8259 IMR Ͻ/ڰ       i`Ͻj
;       FUNC:   ̧ݸݥڼ޽            igpȂꍇ͒`Ȃj
;       FNCREG: ̧ݸݥڼ޽ ݒް
;       BAUD:   ްڰĐݒڼ޽          igpȂꍇ͒`Ȃj
;       BMAX:   ްڰĂ̐ݒől
;       BMASK:  ްڰĐݒްϽް
;
;--------------------------------------------------
;

; PC-9801 W RS-232C ߰
; RS-232C (1)  int=IR4  (RS-232C)
RSDAT1  equ       30H
RSCNT1  equ       32H
RSSTA1  equ       33H
RSMSK1  equ       35H
RSMR1   equ       -1
INTVEC1 equ       0CH
IMRMSK1 equ       10H
PICMST1 equ       -1
INTEBL1 equ       05H
INTDIS1 equ      0F8H

if      BOARD   eq      PC98_ONLY
;
; PC-9801 W RS-232C ߰Ă̂
;
INTMSKD EQU       10H
INTMSKS EQU       00H

elseif  BOARD   eq      PC_9861K
;
; PC-9801 W RS-232C ߰ + PC-9861K (PIO-9032B)
;
INTMSKD EQU       38H
INTMSKS EQU       00H

; RS-232C (2)  int=IR5  (INT1)
RSDAT2  equ      0B1H
RSCNT2  equ      0B3H
RSSTA2  equ      0B0H
RSMSK2  equ      0B0H
BAUD2   equ      0B8H         ; Thanks to Take 
BMAX2   equ       08H         ; Thanks to Take 
BMASK2  equ       07H         ; Thanks to Take 
INTVEC2 equ       0DH
IMRMSK2 equ       20H
PICMST2 equ       -1
INTEBL2 equ       05H
INTDIS2 equ      0F8H

; RS-232C (3)  int=IR3  (INT0)
RSDAT3  equ      0B9H
RSCNT3  equ      0BBH
RSSTA3  equ      0B2H
RSMSK3  equ      0B2H
BAUD3   equ      0BAH         ; Thanks to Take 
BMAX3   equ       08H         ; Thanks to Take 
BMASK3  equ       07H         ; Thanks to Take 
INTVEC3 equ       0BH
IMRMSK3 equ       08H
PICMST3 equ       -1
INTEBL3 equ       05H
INTDIS3 equ      0F8H

elseif  BOARD   eq      PIO_9032C
;
; PC-9801 W RS-232C ߰ + PIO-9032C (PIO-9032B~2)
;
INTMSKD EQU       38H
INTMSKS EQU       30H		; Thanks to MOGURA 

; RS-232C (2)  int=IR5  (INT1)	; Thanks to MOGURA 
RSDAT2  equ      0B1H
RSCNT2  equ      0B3H
RSSTA2  equ      0B0H
RSMSK2  equ      0B0H
RSMR2   equ       -1
BAUD2   equ      0B8H
BMAX2   equ       08H
BMASK2  equ       07H
INTVEC2 equ       0DH		; Thanks to MOGURA 
IMRMSK2 equ       20H		; Thanks to MOGURA 
PICMST2 equ       -1
INTEBL2 equ       05H
INTDIS2 equ      0F8H

; RS-232C (3)  int=IR3  (INT0)	; Thanks to MOGURA 
RSDAT3  equ      0B9H
RSCNT3  equ      0BBH
RSSTA3  equ      0B2H
RSMSK3  equ      0B2H
RSMR3   equ       -1
BAUD3   equ      0BAH
BMAX3   equ       08H
BMASK3  equ       07H
INTVEC3 equ       0BH		; Thanks to MOGURA 
IMRMSK3 equ       08H		; Thanks to MOGURA 
PICMST3 equ        -1
INTEBL3 equ       05H
INTDIS3 equ      0F8H

; RS-232C (3)  int=IR12 (INT5)
RSDAT4  equ     01B1H
RSCNT4  equ     01B3H
RSSTA4  equ     01B0H
RSMSK4  equ     01B0H
RSMR4   equ       -1
BAUD4   equ     01B8H
BMAX4   equ       08H
BMASK4  equ       07H
INTVEC4 equ       14H
IMRMSK4 equ       10H		; Thanks to MOGURA 
INTEBL4 equ       05H
INTDIS4 equ      0F8H

; RS-232C (3)  int=IR13 (INT6)
RSDAT5  equ     01B9H
RSCNT5  equ     01BBH
RSSTA5  equ     01B2H
RSMSK5  equ     01B2H
RSMR5   equ       -1
BAUD5   equ     01BAH
BMAX5   equ       08H
BMASK5  equ       07H
INTVEC5 equ       15H
IMRMSK5 equ       20H		; Thanks to MOGURA 
INTEBL5 equ       05H
INTDIS5 equ      0F8H

elseif  BOARD   eq      B98_01
;
; PC-9801 W RS-232C ߰ + B98-01
;
INTMSKD EQU       38H
INTMSKS EQU       00H

; RS-232C (2)  int=IR5  (INT1)
RSDAT2  equ      0B1H
RSCNT2  equ      0B3H
RSSTA2  equ      0B0H
RSMSK2  equ      0B0H
BAUD2   equ      0D1H
BMAX2   equ       0BH
BMASK2  equ       0FH
FUNC2   equ      0D3H
FNCREG2 equ      0F2H
INTVEC2 equ       0DH
IMRMSK2 equ       20H
PICMST2 equ        -1
INTEBL2 equ       05H
INTDIS2 equ       00H

; RS-232C (3)  int=IR3  (INT0)
RSDAT3  equ      0B9H
RSCNT3  equ      0BBH
RSSTA3  equ      0B2H
RSMSK3  equ      0B2H
BAUD3   equ      0D5H
BMAX3   equ       0BH
BMASK3  equ       0FH
FUNC3   equ      0D7H
FNCREG3 equ      0F2H
INTVEC3 equ       0BH
IMRMSK3 equ       08H
PICMST3 equ       -1
INTEBL3 equ       05H
INTDIS3 equ       00H

FNC_REG equ      0F2H

endif

TCOUNT2 equ       75H            ; -2
TMODE   equ       77H            ; Ӱ

XON     equ       11H            ;]ĊJ
XOFF    equ       13H            ;]ꎞf
BREAKS  equ       03H            ;Break key
PAUSES  equ       13H            ;Pause key
TRUE    equ       0FFH
FALSE   equ       00H

CLRER   equ       00010000b      ;Error clear
RTSEN   equ       00100000b      ;RTS ON
DTREN   equ       00000010b      ;DTR ON
TXEN    equ       00000001b      ;TxE ON
RXEN    equ       00000100b      ;RxE ON

TXRDY   equ       00000001b
RXRDY   equ       00000010b

TXDUMY  equ       01H

RSMASK  equ       0FH           ; 232C }XNf[^
RSEBL   equ       00H           ; M\
RSXOFF  equ       01H           ; XOFF v
RSBFUL  equ       02H           ; obt@ (XOFFMς)
RSXON   equ       03H           ; XON  v

VSYNCEN equ       04H           ; VSYNC 
VRESET  equ       64H           ; VSYNC reset port
VRATE   equ       4             ; VSYNC 񖈂ɒ荞݂s邩B

OCW1_M  equ       02H
OCW2_M  equ       00H
OCW3_M  equ       00H
ISR_M   equ       00H
IMR_M   equ       02H

OCW1_S  equ       0AH
OCW2_S  equ       08H
OCW3_S  equ       08H
ISR_S   equ       08H
IMR_S   equ       0AH

TXBUFL  equ     0200H           ;Mobt@̒
RXBUFL  equ     0800H           ;Mobt@̒
RXONp   equ     0100H           ;MJnʒu
RXOFFp  equ     0600H           ;M~ʒu

SETVECT equ      25H
GETVECT equ      35H

;--------------------------------------------------
;       ėp}N
;--------------------------------------------------
msdos   macro   req,param
        IFNB    <param>
                mov     ax,req*256+param
        ELSE
                mov     ah,req
        ENDIF
        int     21h
endm

timing  macro                   ;肪Ƃ܂Rl
        out     5fh,al
        out     5fh,al
        out     5fh,al
        out     5fh,al
        out     5fh,al
        out     5fh,al
        out     5fh,al
        out     5fh,al
        out     5fh,al
endm

pushs   macro   regs
        irp     reg,<regs>
        push    reg
        endm
endm

pops    macro   regs
        irp     reg,<regs>
        pop     reg
        endm
endm

movsreg macro   sreg1,sreg2
        push    sreg2
        pop     sreg1
endm

changevect      macro   vect,vecth
        msdos   GETVECT,vecth
        mov     word ptr ofs&vect,bx
        mov     word ptr seg&vect,es
        mov     dx,offset int&vect
        msdos   SETVECT,vecth
endm

resetvect       macro   vect,vecth
        push    ds
        mov     dx,word ptr ofs&vect
        mov     ds,word ptr seg&vect
        msdos   SETVECT,vecth
        pop     ds
endm

;--------------------------------------------------
;       R[hEX^[g
;--------------------------------------------------
code    segment word public
        assume  cs:code,ds:code,es:code

        org     0000h           ;ײް  ̾ 0 

;-------------------------------------------------------------------
; ײް ̖ߍ
;  Offset  Length  Data
;  00000H     08H  ײް ̓K ޼ޮ 
;  00008H     01H  30H iLQƁj
;  00009H    (30H) ײް   i48j
;  00039H     30H  쌠\ i48j
;  00069H     02H  RS-232C [`̃ItZbgAhX
;  0006BH     02H  RS-232C [`̃ItZbgAhX
;  0006DH     02H  t@NVR[̃ItZbgAhX
;  0006FH     04H  R}hCfarAhXiRTBBS Zbgj
;  00073H     01H  ײް  ߰   
;  00074H     02H  M ޯ̧  ޲ 
;  00076H     02H  M ޯ̧  ޲ 
;
;@ғE ٰ  TP ̋K (Procedure) ɏ] call B
;@ڰ  ı  ڼ޽  ނYĂ͂ȂB
;
;  ײް   ͌ɂ 48 ȓȂǂB
;  ȉꍇA00008H ɒw肷Bj

revs    db      DRV_REV         ;ײް dl ޼ޮ  (rev1.02)
titlen  db      TTL_LEN
rstit   db      RS_TTL
cpr     db      COPYRIGHT
srtbl   dw      setrs           ; ٰ
rmtbl   dw      remove          ; ٰ
functbl dw      func            ;̧ݸݺ
cmdline dd      ?               ;ײ
rsch    db      CH_MAX          ;ِ
txbufs  dw      TXBUFL          ;Mޯ̧
rxbufs  dw      RXBUFL          ;Mޯ̧
;-------------------------------------------------------------------

;------------------------------------------------
; WORK AREA
;------------------------------------------------
workarea        macro   CN
ofsCN&CN        dw      ?
segCN&CN        dw      ?
chkbrk&CN       db      ?
flow&CN         db      ?
sfflow&CN       db      ?
hdflow&CN       db      ?
cmdset&CN       db      ?
txpara&CN       db      ?
txtail&CN       dw      ?
txptr&CN        dw      ?
txbuff&CN       db      TXBUFL dup(?)
rxpara&CN       db      ?
rxtail&CN       dw      ?
rxptr&CN        dw      ?
rxbuff&CN       db      RXBUFL dup(?)
endm

        CHNO =    1
rept    CH_MAX
        workarea        %CHNO
        CHNO =    CHNO + 1
endm

ofs0A   dw      ?               ;int0Ah ޔp
seg0A   dw      ?
ofs0F   dw      ?               ;int0Fh ޔp
seg0F   dw      ?
ofs17   dw      ?               ;int17h ޔp
seg17   dw      ?
ofs18   dw      ?               ;int18h ޔp
seg18   dw      ?

exflag  db      ?               ;VSYNC ē`FbN
vcount  db      ?               ;VSYNC sJE^
vexec	db	?		;VSYNC Ŏɏ`l

imrmsave        db      ?       ;imri}X^[jۑp {ComServe}
if      INTMSKS    eq   0
imrssave        db      ?       ;imriX[ujۑp {ComServe}
endif

;------------------------------------------------------
;       }N
;------------------------------------------------------

;------------------------------------------------
;       RS-232C ̃}XN̉s
;
;------------------------------------------------
rsinte  macro   CN
        cli                     ;{ComServe}
        mov     dx,RSMSK&CN
ifdef   RSMR&CN
        in      al,dx
        or      al,INTEBL&CN
else
        mov     al,INTEBL&CN
endif
        out     dx,al           ;RxR,TxE,TxR}XN
        jmp     $+2             ;{ NOBUYA }
        sti                     ;{ComServe}
endm

;------------------------------------------------
;       RS-232C ̃}XNs
;
;------------------------------------------------
rsintd  macro   CN
        cli                     ;{ComServe}
        mov     dx,RSMSK&CN
ifdef   RSMR&CN
        in      al,dx
        and     al,INTDIS&CN
else
        mov     al,INTDIS&CN
endif
        out     dx,al           ;RxR,TxE,TxR}XN
        jmp     $+2             ;{ NOBUYA }
        sti                     ;{ComServe}
endm

;------------------------------------------------
;       RS-232C PIC ɂ銄̃}XN̉s
;
;------------------------------------------------
rspice  macro   CN
        cli                     ;{ComServe}
ifdef   PICMST&CN
        in      al,IMR_M        ;荞݋֎~
        and     al,(not IMRMSK&CN)
        out     IMR_M,al
else
        in      al,IMR_S
        and     al,(not IMRMSK&CN)
        out     IMR_S,al
endif
        jmp     $+2             ;{ NOBUYA }
        sti                     ;{ComServe}
endm

;------------------------------------------------
;       RS-232C PIC ɂ銄̃}XNs
;
;------------------------------------------------
rspicd  macro   CN
        cli                     ;{ComServe}
ifdef   PICMST&CN
        in      al,IMR_M        ;荞݋֎~
        or      al,IMRMSK&CN
        out     IMR_M,al
else
        in      al,IMR_S
        or      al,IMRMSK&CN
        out     IMR_S,al
endif
        jmp     $+2             ;{ NOBUYA }
        sti                     ;{ComServe}
endm

;------------------------------------------------
; $*0 : qr|QRQbCjVCY
;      in :al=baud
;      out:none
;------------------------------------------------
rsinit          macro   CN
rsinit&CN       proc    near
        mov     ah,al

        rspicd  CN
        rsintd  CN

        push    ax
        push    dx
if      CN      eq      1
        mov     al,ah
        call    timerinit       ;timerinit
elseifdef   BAUD&CN
        mov     al,BMAX&CN      ;set baud
        sub     al,ah
        and     al,BMASK&CN
        mov     dx,BAUD&CN
        out     dx,al
endif

ifdef   FUNC&CN
        mov     dx,FUNC&CN      ;̧ݸݥڼ޽
        mov     al,FNCREG&CN
        out     dx,al
endif
        timing
        xor     al,al
        mov     dx,RSCNT&CN
        out     dx,al           ;make sure that
        timing
        out     dx,al           ;USART is in commmand
        timing
        out     dx,al           ;word sequence
        timing
        mov     al,40h          ;internal reset
        out     dx,al
        timing
        mov     al,4eh          ;Ӱܰ: stop=1bit
        out     dx,al           ;parity=disable, 8bit, 16x
        timing
        mov     al,CLRER or RTSEN or DTREN or RXEN
        out     dx,al           ;Error clear,RTS,DTR,RxE enable set
        mov     cmdset&CN,al

;       -------------------------------------------
;       M֌W (͂łȂ)

        xor     ax,ax
        mov     txptr&CN,ax     ;txptr1 :=0
        mov     txtail&CN,ax    ;txtail1:=0
        mov     txpara&CN,RSEBL ;txpara1:=enable
        mov     al,FALSE
        mov     sfflow&CN,al    ;sfflow1:=false
        mov     hdflow&CN,al    ;hdflow1:=false

        mov     dx,RSDAT&CN     ;TXEN ͊ɗĂ
        mov     al,TXDUMY
        out     dx,al

;       -------------------------------------------

        call    initbuf&CN

        pop     dx
        pop     ax

        rsinte  CN
        rspice  CN

        ret
rsinit&CN       endp
endm

;------------------------------------------------
; $*1 : t[Rg[ ON/OFF
;      in :AL ($00=ON , other=OFF)
;      out:none
;------------------------------------------------
rsflow  macro   CN
        local   l03, l04
rsflow&CN       proc    near
        and     al,al           ;if AL=$00 then begin
        jnz     l03
        mov     al,TRUE         ;  flow1:=true
        jmp     short l04       ;end
l03:    mov     al,FALSE        ;else begin
l04:    mov     flow&CN,al      ;  flow1:=false
        mov     sfflow&CN,FALSE ;  sfflow1:=false
        ret
rsflow&CN       endp
endm

;------------------------------------------------
; $*2 : o̓obt@ɓĂ镶^
;      in :none
;      out:AX
;------------------------------------------------
gettxlen        macro   CN
        local   l09
gettxlen&CN     proc    near
        mov     ax,txtail&CN    ;len:=txtail1-txptr1
        sub     ax,txptr&CN
        jae     l09             ;if len<0 then
        add     ax,TXBUFL       ;  len:=len+buf_length
l09:    ret
gettxlen&CN     endp
endm

;------------------------------------------------
; $*3 : ̓obt@ɓĂ镶^
;      in :none
;      out:AX
;------------------------------------------------
getrxlen        macro   CN
        local   l09
getrxlen&CN     proc    near
        mov     ax,rxtail&CN    ;len:=rxtail1-rxptr1
        sub     ax,rxptr&CN
        jae     l09             ;if len<0 then
        add     ax,RXBUFL       ;  len:=len+buf_length
l09:    ret
getrxlen&CN     endp
endm

;------------------------------------------------
; $*4 : Po
;      in :AL
;      out:RS-232C
;------------------------------------------------
rssend  macro   CN
        local   l01,l02,l03,l0a,l0b
rssend&CN       proc    near
        mov     cl,al
l01:    rspicd  CN              ;荞݋֎~
        call    gettxlen&CN
        cmp     ax,(TXBUFL-1)
        je      l0b
l02:
        mov     bx,offset txbuff&CN
        mov     si,txtail&CN    ;si:=txtail1
        mov     [bx+si],cl      ;txbuff1[si]:=al
        inc     si              ;si:=si+1
        cmp     si,TXBUFL       ;if si=buf_length then
        jnz     l0a
        xor     si,si           ;  si:=0
l0a:    mov     txtail&CN,si    ;txtail1:=si
l0b:    rspice  CN              ;荞݋
        ret
rssend&CN       endp
endm

;------------------------------------------------
; $*5 : P
;      in :RS-232C
;      out:AL=chr, AH=$00
;------------------------------------------------
rsrecv  macro   CN
        local   l05, l06, l07, l08, l09, l0e
rsrecv&CN       proc    near
        rspicd  CN              ; 荞݋֎~

        call    getrxlen&CN     ;if len(rxbuff1)<>0 then
        and     ax,ax
        jz      l0e
        mov     dx,ax
        mov     bx,offset rxbuff&CN
        mov     si,rxptr&CN
        mov     al,[bx+si]      ;al:=rxbuff1[si]
        inc     si              ;si:=si+1
        cmp     si,RXBUFL       ;if si=buf_length then
        jnz     l07
        xor     si,si           ;  si:=0
l07:    mov     rxptr&CN,si     ;rxptr1:=si
        push    ax
        cmp     dx,RXONp        ;ǂݎ XOFF Ԃ XON Ԃ
        ja      l08             ;  ڍs`FbNAXON 𑗏o

        mov     al,cmdset&CN
        or      al,RTSEN
        mov     dx,RSCNT&CN
        out     dx,al
        mov     cmdset&CN,al
        mov     al,rxpara&CN
        cmp     al,RSBFUL
        jne     l08

        mov     rxpara&CN,RSXON ; XON Mw

l08:    rspice  CN              ; 荞݋
        pop     ax
        xor     ah,ah           ;ah:=$00
        ret

l0e:    rspice  CN              ; 荞݋
        ret
rsrecv&CN       endp
endm

;------------------------------------------------
; $*6 : ̓obt@̏
;      in :none
;      out:none
;------------------------------------------------
initbuf macro   CN
initbuf&CN      proc    near

ifdef   PICMST&CN
        in      al,IMR_M        ;荞݋֎~
        push    ax
        or      al,IMRMSK&CN
        out     IMR_M,al
else
        in      al,IMR_S
        push    ax
        or      al,IMRMSK&CN
        out     IMR_S,al
endif
        jmp     $+2             ;{ NOBUYA }
        sti
        xor     ax,ax
        mov     rxptr&CN,ax     ;rxptr1 :=0
        mov     rxtail&CN,ax    ;rxtail1:=0
        mov     chkbrk&CN,al    ;chkbreak:=0
        mov     rxpara&CN,RSEBL ;rxpara1:=enable
        mov     al,cmdset&CN
        or      al,CLRER
        mov     dx,RSCNT&CN
        out     dx,al           ;Clear error
        mov     cmdset&CN,al
        pop     ax
        cli
ifdef   PICMST&CN
        out     IMR_M,al
else
        out     IMR_S,al
endif
        jmp     $+2             ;{ NOBUYA }
        sti
        ret
initbuf&CN      endp
endm

;------------------------------------------------
; $*7 : ڰݸ װ ̌o
;      in :none
;      out:AL
;------------------------------------------------
getstat macro   CN
        local   l02
getstat&CN      proc    near
        xor     ax,ax
        mov     dx,RSCNT&CN
        in      al,dx
        and     al,20h
        push    ax
        in      al,dx
        timing
        test    al,38h          ;ð { NOBUYA }
        jz      l02
        mov     al,cmdset&CN
        out     dx,al
l02:    pop     ax
        ret
getstat&CN      endp
endm

;------------------------------------------------
; $*8 : LA`FbN
;      in :none
;      out:AL
;------------------------------------------------
chkcts  macro   CN
chkcts&CN       proc    near
        xor     ax,ax
        mov     dx,RSSTA&CN
        in      al,dx
        not     al
        and     al,20h
        ret
chkcts&CN       endp
endm

;------------------------------------------------
; $*9 : DTR 𗎂Ƃiؒfj
;      in :none
;      out:none
;------------------------------------------------
dropdtr macro   CN
dropdtr&CN      proc    near
        cli                     ; { NOBUYA }
        mov     al,cmdset&CN
        and     al,not DTREN
        mov     dx,RSCNT&CN
        out     dx,al
        mov     cmdset&CN,al
        sti
        ret
dropdtr&CN      endp
endm

;------------------------------------------------
; $*A : DTR,RTS  Ȱ ɂ
;      in :none
;      out:none
;------------------------------------------------
raiserts        macro   CN
raiserts&CN     proc    near
        cli                     ; { NOBUYA }
        mov     al,cmdset&CN
        or      al,RTSEN or DTREN
        mov     dx,RSCNT&CN
        out     dx,al
        mov     cmdset&CN,al
        sti
        ret
raiserts&CN     endp
endm

;------------------------------------------------
; $*B : break , pause ̓`FbN
;      in :none
;      out:AL
;------------------------------------------------
break   macro   CN
break&CN        proc    near
        xor     ax,ax
        mov     al,chkbrk&CN
        mov     chkbrk&CN,ah
        ret
break&CN        endp
endm

;================================================
;@qr|QRQbn[hEFA荞
;@iM荞݁j
;================================================
rshdint macro   CN
        local   l01,l02,l03,l0c,l0d,l0e
        local   erx,erx1,erx2,erx3,erx4,erx5,erx6,erx0
        local   etx,etx1,etx2,etx3,etx4,etx5,etx6,etx7,etx0

;------------------------------- U蕪
intCN&CN        proc    far
        pushs   <ax,bx,cx,dx,si,ds,cs>
        pop     ds

	;}XNƊ荞ݐM

ifdef   PICMST&CN
        in      al,IMR_M
        or      al,IMRMSK&CN
        out     IMR_M,al
else
        in      al,IMR_S
        or      al,IMRMSK&CN
        out     IMR_S,al
endif

ifndef  PICMST&CN
        mov     al,0a0h         ;ڰPIC ̗D揇ʉ]
        out     OCW2_S,al

        mov     al,20h          ;ڰPIC  EOI s
        out     OCW2_S,al

        mov     al,0Bh          ;ڰނɊ޽̊قȂ ?
        out     OCW3_S,al
        in      al,ISR_M
        test    al,0FFh
        jnz     l0d             ;΂̂܂
endif
        mov     al,0a0h         ;ϽPIC ̗D揇ʉ]
        out     OCW2_M,al

        mov     al,20h          ;ϽPIC  EOIs
        out     OCW2_M,al       ;

l0d:    mov     dx,RSCNT&CN
        in      al,dx
        test    al,TXRDY or RXRDY ; Mf[^͖ȂH
        je      l0e

l01:    test    al,RXRDY        ;Mf[^LH
        je      l02
        call    erx             ;M
l02:    mov     dx,RSCNT&CN
        in      al,dx
        test    al,TXRDY        ;M\H
        je      l0d
        call    etx             ;M
        jmp     l0d

l0e:
        ;}XNJƂɊ荞ݗv
	;GbŴ pic B

ifdef   PICMST&CN
        in      al,IMR_M
        and     al,(not IMRMSK&CN)
        out     IMR_M,al
else
        in      al,IMR_S
        and     al,(not IMRMSK&CN)
        out     IMR_S,al
endif

        pops    <ds,si,dx,cx,bx,ax>
        iret
intCN&CN        endp

;------------------------------- M
erx             proc    near
        mov     bx,offset rxbuff&CN
        mov     dx,RSDAT&CN
        in      al,dx
        cmp     flow&CN,FALSE   ; \tgEFAt[͋֎~ ?
        je      erx3            ; Thanks MOTO 
        cmp     al,XOFF         ; XOFF M ?
        jne     erx1
	mov	sfflow&CN,TRUE  ; ~(\tgEFAt[)
        jmp     erx0
erx1:
        cmp     al,XON          ; XON M ?
        jne     erx3
        mov     sfflow&CN,FALSE ; ĊJ(\tgEFAt[)
        jmp     erx0
erx3:
        cmp     al,BREAKS       ;if (get 1 chr)=abort then
        jnz     erx4
        mov     chkbrk&CN,al    ;  chkbreak:=abort
        jmp     short erx5
erx4:				;Ӗ悤ȋCȂłȂ
        cmp     al,PAUSES       ;else if (get 1 chr)=pause then
        jnz     erx5
        mov     chkbrk&CN,al    ;  chkbreak:=pause
erx5:
        mov     si,rxtail&CN    ;si:=rxtail1
        mov     [bx+si],al      ;rxbuff1[si]:=(get 1 chr)
        inc     si              ;si:=si+1
        cmp     si,RXBUFL       ;if si=buf_length then
        jnz     erx6
        xor     si,si           ;  si:=0
erx6:
        mov     rxtail&CN,si    ;rxtail1:=si
        call    getrxlen&CN
        cmp     ax,RXOFFp       ;if ax>=RXOFFp then
        jb      erx0

        mov     al,cmdset&CN
        and     al,not RTSEN
        mov     dx,RSCNT&CN
        out     dx,al
        mov     cmdset&CN,al

        mov     al,rxpara&CN
        cmp     al,RSEBL
        jne     erx0
        mov     rxpara&CN,RSXOFF; XOFF Mw
erx0:
        ret
erx             endp

;------------------------------- M
etx             proc    near
        mov     dx,RSSTA&CN     ; |[gM\ ?
        in      al,dx           ;
        and     al,40h          ;
        jnz     etx6

        cmp     flow&CN,FALSE   ; \tgEFAt[͋֎~ ?
        je      etx2            ; Thanks MOTO 
        cmp     rxpara&CN,RSXOFF; XOFFޑMv ?
        jne     etx1
        mov     al,XOFF         ; XOFFނ𑗐M
        mov     rxpara&CN,RSBFUL; ޯ̧ԂƂ
        jmp     etx4
etx1:
        cmp     rxpara&CN,RSXON ; XONޑMv ?
        jne     etx2
        mov     al,XON          ; XONނ𑗐M
        mov     rxpara&CN,RSEBL ; M\ԂƂ
        jmp     etx4
etx2:
        cmp     hdflow&CN,TRUE  ; n[hEFAt[Œ~ ?
        je      etx6
        cmp     sfflow&CN,TRUE  ; \tgEFAt[Œ~ ?
        je      etx6
        call    gettxlen&CN     ; M邩 ?
        and     ax,ax
        jz      etx6

        mov     bx,offset txbuff&CN
        mov     si,txptr&CN
        mov     al,[bx+si]      ;al:=txbuff1[si]
        inc     si              ;si:=si+1
        cmp     si,TXBUFL       ;if si=buf_length then
        jne     etx3
        xor     si,si           ;  si:=0
etx3:   mov     txptr&CN,si     ;txptr1:=si
etx4:
        mov     dx,RSDAT&CN
        out     dx,al           ;Data output
        jmp     etx0

etx6:   or      txpara&CN,RSEBL ; MptO
etx7:   mov     al,cmdset&CN    ; M荞݂֎~
        and     al,not TXEN
        mov     dx,RSCNT&CN
        out     dx,al           ;TxE disable
        mov     cmdset&CN,al
        timing
        mov     al,TXDUMY
        mov     dx,RSDAT&CN
        out     dx,al
etx0:
        ret
etx             endp
endm

;------------------------------------------------
;       WvEe[u
;------------------------------------------------
jmptable        macro   CN
        dw      rsinit&CN       ; $00
        dw      rsflow&CN       ; $01
        dw      gettxlen&CN     ; $02
        dw      getrxlen&CN     ; $03
        dw      rssend&CN       ; $04
        dw      rsrecv&CN       ; $05
        dw      initbuf&CN      ; $06
        dw      getstat&CN      ; $07
        dw      chkcts&CN       ; $08
        dw      dropdtr&CN      ; $09
        dw      raiserts&CN     ; $0A
        dw      break&CN        ; $0B
        dw      nops            ; $0C
        dw      nops            ; $0D
        dw      nops            ; $0E
        dw      nops            ; $0F
endm
;-----------------------------------------------
;       }NI
;-----------------------------------------------


;================================================
; hCȏgݍ
;================================================

setrs           proc    far

        push    ds                      ;ް 
        movsreg ds,cs                   ; ı

        cli
        in      al,IMR_M                ; PIC ɂ֘A荞݋֎~
        mov     imrmsave,al             ; imri}X^[jۑ {ComServe}
        or      al,INTMSKD
        out     IMR_M,al
if      INTMSKS    eq   0
        in      al,IMR_S
        mov     imrssave,al             ; imriX[ujۑ {ComServe}
        or      al,INTMSKS
        out     IMR_S,al
endif
        jmp     $+2                     ;{ NOBUYA }
        sti

        CHNO =    1
rept    CH_MAX
        rsintd          %CHNO
        changevect      CN%CHNO,INTVEC%CHNO     ;qrQRQb荞
        CHNO =    CHNO + 1
endm
        changevect      0A,0Ah          ;urxmb荞
        changevect      18,18h          ;bqsahnrgbv
        changevect      0F,0Fh          ;sS荞ݑ΍̂
        changevect      17,17h          ;    

        mov     exflag,FALSE
        mov     vcount,VRATE
	mov	vexec,1

        cli
        in      al,IMR_M                ;荞݃}XNWX^ǂ
        and     al,not VSYNCEN          ;int 0Ah(VSYNC)
        out     IMR_M,al                ;荞݃}XNWX^ɏ
        xor     al,al
        out     VRESET,al               ;CRTVĂ\ɂ邽߂ؾ
        jmp     $+2                     ;{ NOBUYA }
        sti

        pop     ds                      ;ڼ޽ ؽı
        ret

setrs           endp

;================================================
; hCỏ
;================================================
remove          proc    far

        push    ds                      ;ް 
        movsreg ds,cs                   ; ı

        cli
        in      al,IMR_M                ; PIC ɂ֘A荞݋֎~
        or      al,INTMSKD
        or      al,VSYNCEN
        out     IMR_M,al
if      INTMSKS    eq   0
        in      al,IMR_S
        or      al,INTMSKS
        out     IMR_S,al
endif
        jmp     $+2                     ;{ NOBUYA }
        sti

        CHNO =    1
rept    CH_MAX
        rsintd          %CHNO
        resetvect       CN%CHNO,INTVEC%CHNO     ;qrQRQb荞
        CHNO =    CHNO + 1
endm
        resetvect       0A,0Ah
        resetvect       18,18h
        resetvect       0F,0Fh
        resetvect       17,17h

        cli                             ; 荞݃}XNA {ComServe}
        mov     al,imrmsave
        out     IMR_M,al
if      INTMSKS    eq   0
        mov     al,imrssave
        out     IMR_S,al
endif
        jmp     $+2                     ;{ NOBUYA }
        sti

        pop     ds                      ;ڼ޽ ؽı
        ret

remove          endp

;================================================
; t@NVR[
;   in:AH(R}hԍ)
;================================================
func    proc    far

        push    ds              ;ް 
        movsreg ds,cs           ; ı
        mov     ax,si           ;̧ݸݎ擾

        cmp     ah,CMD_MAX      ;ޔ͈!!
        jae     dummy           ;  NG
        push    ax
        mov     al,ah
        xor     ah,ah
        mov     bx,offset jmptbl
        shl     ax,1
        add     bx,ax           ;ð ڽ ..
        pop     ax
        call    [bx]            ;Jump !

dummy:  mov     si,ax           ;߂l
        pop     ds              ;ڼ޽ ؽı
        ret
func            endp

nops:   ret

;================================================
;@qr|QRQbĂяo
;================================================
rsscan  macro   CN
        local   l01,l02,l03,l04,l05,l06,l07,l09
rsscan&CN:
        rspicd  CN
        test    cmdset&CN,TXEN          ; M͋֎~ ?
        jnz     l09
        cmp     hdflow&CN,TRUE          ; n[hEFAt[Œ~ ?
        jne     l07
        mov     dx,RSSTA&CN             ; |[g͑M\ ?
        in      al,dx
        and     al,40h
        jnz     l09
        mov     hdflow&CN,FALSE         ; n[hEFAt[
l07:    cmp     flow&CN,FALSE           ; XON/XOFFw肠 ?
        je      l03                     ; Thanks MOTO 
        cmp     sfflow&CN,TRUE          ; \tgEFAt[Œ~ ?
        je      l09
        mov     al,txpara&CN            ; XON/XOFF 
        and     al,RSMASK
        cmp     al,RSXON
        jne     l01
        mov     al,XON
        jmp     l05
l01:
        cmp     al,RSXOFF
        jne     l02
        mov     al,XOFF
        jmp     l05
l02:
        cmp     al,RSEBL
        jne     l09
l03:
        mov     si,txptr&CN             ; Mf[^L?
        cmp     si,txtail&CN
        je      l09
        mov     bx,offset txbuff&CN
        mov     al,[bx+si]              ;al:=txbuff1[si]
        inc     si                      ;si:=si+1
        cmp     si,TXBUFL               ;if si=buf_length then
        jne     l04
        xor     si,si                   ;  si:=0
l04:
        mov     txptr&CN,si             ;txptr1:=si
l05:
        mov     dx,RSDAT&CN
        out     dx,al                   ;Data output
l06:
        mov     al,cmdset&CN
        or      al,TXEN
        mov     cmdset&CN,al
        mov     dx,RSCNT&CN
        timing
        out     dx,al
l09:
        rspice  CN
	ret
endm

;================================================
; 荞ݏ
;================================================

        CHNO =  1
rept    CH_MAX
	rsscan	%CHNO
        CHNO =  CHNO + 1
endm

maketablem	macro	CN
	dw	rsscan&CN
endm

exec0Atable:
        CHNO =  1
rept    CH_MAX
	maketablem	%CHNO
        CHNO =  CHNO + 1
endm

int0A:
        push    ds                      ;ް 
        movsreg ds,cs                   ; ı
        pushs   <ax,bx,dx,si>

        cmp     exflag,TRUE             ;ēłȂΏs
        jnz     lcvi
        jmp     lxvi
lcvi:   dec     vcount
        jz      lrvi
        jmp     lxvi

lrvi:   mov     vcount,VRATE
        mov     exflag,TRUE
	xor	bh,bh
	mov	bl,vexec
	dec	bl
	shl	bl,1
	add	bx,offset exec0Atable

	call	[bx]

	mov	al,vexec
	inc	al
	cmp	al,CH_MAX
	jbe	lemx
	mov	al,1

lemx:	mov	vexec,al
        mov     exflag,FALSE

lxvi:   xor     al,al
        out     64h,al                  ;CRTVĂ\ɂ邽߂ؾ
        pops    <si,dx,bx,ax>
        pop     ds
        jmp     dword ptr cs:[ofs0A]    ;VSYNC[`

;================================================
; CRT BIOS gbv
;================================================
int18:  pushf
        call    dword ptr cs:[ofs18]
        out     64h,al
int0F:
int17:  iret

;------------------------------------------------
;       WvEe[u
;------------------------------------------------
jmptbl:
        CHNO =  1
rept    CH_MAX
        jmptable        %CHNO
        CHNO =  CHNO + 1
endm

;------------------------------------------------
;       e߰ėp
;------------------------------------------------
        CHNO =    1
rept    CH_MAX
        rshdint         %CHNO
        rsinit          %CHNO
        rsflow          %CHNO
        gettxlen        %CHNO
        getrxlen        %CHNO
        rssend          %CHNO
        rsrecv          %CHNO
        initbuf         %CHNO
        getstat         %CHNO
        chkcts          %CHNO
        dropdtr         %CHNO
        raiserts        %CHNO
        break           %CHNO
        CHNO =    CHNO + 1
endm

;------------------------------------------------
;       W߰ėpۯݒ
;------------------------------------------------
timerinit:
        push    ax
        mov     ax,cs
        mov     ds,ax
        mov     al,0b6h
        out     TMODE,al
        mov     ax,0000h
        mov     es,ax
        mov     bx,offset timdat1
        mov     al,es:[0501h]   ;VXeʈ
        test    al,80h          ;10MHz : timedat1
        jz      l06             ; 8MHz : timedat2
        mov     bx,offset timdat2
l06:    pop     ax
        xor     ah,ah
        add     ax,ax
        add     bx,ax
        mov     ax,[bx]
        out     TCOUNT2,al
        timing
        mov     al,ah
        out     TCOUNT2,al
        timing
        ret

timdat1:
        dw      0800h, 0400h, 0200h, 0100h
        dw      0080h, 0040h, 0020h, 0010h
        dw      0008h, 0004h
timdat2:
        dw      0680h, 0340h, 01a0h, 00d0h
        dw      0068h, 0034h, 001ah, 000dh
        dw      0006h, 0003h                 ; ۏؖ

code    ends
        end

