
;==============================================
;  RS232C ײް
;    Driver version     : 1.9
;    Interface revision : 1.02  ('RTRS$102')
;  Copyright by Eskage/ComServeNOBUYA
;
; The resource IWi
; '91.05.15 RSDRV61K.ASM NB
; '91.11.04 I[o[N₷ۂ̉P
; '91.11.11 RSDRV98/RSDRV61K/RSDRV32C (NOBUYA)
; '91.11.24 AIWA B98-01 Ή                (NOBUYA)
; '91.11.24 荞݃}XN̕A΍        (ComServe)
; '91.11.26 ꂵ XON ̍폜             (ComServe)
; '92.01.06 rWύXP                (ComServe)
; '92.01.16 rWύXQ                (ComServe)
; '92.02.21 }NCHCN              (ComServe)
; '92.02.25 obt@ Xflow 폜 (ComServe)
; '92.06.02 PIO-9032B ̃{[[gݒ    (Take)
; '92.07.08 PIO-9032C ̊荞݃}XN    (MOGURA)
; '93.01.03 S̈׃EFCg𑝂₵      (ComServe)
;
; AZuIvVō\z{[hI鎖
; iMASM /DBOARD=PC98_ONLY | PC_9861K | PIO_9032C | B98_01j
;
;==============================================
VERSION         equ     ' ver1.9  for rev1.02'
DATE            equ     '1993/01/03'
DRV_REV         equ     'RTRS$102'
;

;                        12345678901234567890123456789012345678
COPYRIGHT       equ     'Copyright by Eskage/ComServeNOBUYA   ',DATE


PC98_ONLY       equ     0
PC_9861K        equ     1
PIO_9032C       equ     2
B98_01          equ     3

USER_VEC        equ     19h

;--------------------------------------------------
;    ްޕʏ  \tgEFA
;--------------------------------------------------
if      BOARD   eq      PC98_ONLY
;
; PC-9801 W RS-232C ߰Ă̂
;
CH_MAX          equ     1
CMD_MAX         equ     0FH
TTL_LEN         equ     48
;                        1234567890123456789012345678
RS_TTL          equ     'RSDRV:Default/1ch           ',VERSION

elseif  BOARD   eq      PC_9861K
;
; PC-9801 W RS-232C ߰ + PC-9801K (PIO-9032B)
;
CH_MAX          equ     3
CMD_MAX         equ     2FH
TTL_LEN         equ     48
;                        1234567890123456789012345678
RS_TTL          equ     'RSDRV:PC-9861K/3ch          ',VERSION

elseif  BOARD   eq      PIO_9032C
;
; PC-9801 W RS-232C ߰ + PIO-9032C (PIO-9032B~2)
;
CH_MAX          equ     5
CMD_MAX         equ     4FH
TTL_LEN         equ     48
;                        1234567890123456789012345678
RS_TTL          equ     'RSDRV:PIO-9032C/5ch         ',VERSION

elseif  BOARD   eq      B98_01
;
; PC-9801 W RS-232C ߰ + B98-01
;
CH_MAX          equ     3
CMD_MAX         equ     2FH
TTL_LEN         equ     48
;                        1234567890123456789012345678
RS_TTL          equ     'RSDRV:B98-01/3ch            ',VERSION
endif

;--------------------------------------------------
;    ްޕʏ@n[hEFA
;       INTMSKD:8259 ϽPIC   Ͻޯ
;       INTMSKS:8259 ڰPIC Ͻޯ
;
;    ߰ĕʏ
;       RSDAT:  8251 ްڼ޽
;       RSCNT:  8251 Ӱ//ðڼ޽
;       RSSTA:  RS-232C ٥ڼ޽
;       RSMSK:  Ͻڼ޽
;       RSMR:   Ͻڼ޽ ǂݍ݉\i`Ή\j
;       INTEBL: Ͻڼ޽ ޯ
;       INTDIS: Ͻڼ޽ ֎~ޯ
;       INTVEC: ޸ԍ
;       IMRMSK: 8259 IMR Ͻޯ
;       PICMST: 8259 IMR Ͻ/ڰ       i`Ͻj
;       FUNC:   ̧ݸݥڼ޽            igpȂꍇ͒`Ȃj
;       FNCREG: ̧ݸݥڼ޽ ݒް
;       BAUD:   ްڰĐݒڼ޽          igpȂꍇ͒`Ȃj
;       BMAX:   ްڰĂ̐ݒől
;       BMASK:  ްڰĐݒްϽް
;
;--------------------------------------------------
;

; PC-9801 W RS-232C ߰
; RS-232C (1)  int=IR4  (RS-232C)
RSDAT1  equ       30H
RSCNT1  equ       32H
RSSTA1  equ       33H
RSMSK1  equ       35H
RSMR1   equ       -1
INTVEC1 equ       0CH
IMRMSK1 equ       10H
PICMST1 equ       -1
INTEBL1 equ       01H
INTDIS1 equ      0F8H

if      BOARD   eq      PC98_ONLY
;
; PC-9801 W RS-232C ߰Ă̂
;
INTMSKD EQU       10H
INTMSKS EQU       00H

elseif  BOARD   eq      PC_9861K
;
; PC-9801 W RS-232C ߰ + PC-9861K (PIO-9032B)
;
INTMSKD EQU       38H
INTMSKS EQU       00H

; RS-232C (2)  int=IR5  (INT1)
RSDAT2  equ      0B1H
RSCNT2  equ      0B3H
RSSTA2  equ      0B0H
RSMSK2  equ      0B0H
BAUD2   equ      0B8H         ; Thanks to Take 
BMAX2   equ       08H         ; Thanks to Take 
BMASK2  equ       07H         ; Thanks to Take 
INTVEC2 equ       0DH
IMRMSK2 equ       20H
PICMST2 equ       -1
INTEBL2 equ       01H
INTDIS2 equ      0F8H

; RS-232C (3)  int=IR3  (INT0)
RSDAT3  equ      0B9H
RSCNT3  equ      0BBH
RSSTA3  equ      0B2H
RSMSK3  equ      0B2H
BAUD3   equ      0BAH         ; Thanks to Take 
BMAX3   equ       08H         ; Thanks to Take 
BMASK3  equ       07H         ; Thanks to Take 
INTVEC3 equ       0BH
IMRMSK3 equ       08H
PICMST3 equ       -1
INTEBL3 equ       01H
INTDIS3 equ      0F8H

elseif  BOARD   eq      PIO_9032C
;
; PC-9801 W RS-232C ߰ + PIO-9032C (PIO-9032B~2)
;
INTMSKD EQU       38H
INTMSKS EQU       30H		; MOGURA

; RS-232C (2)  int=IR5  (INT1)	; MOGURA
RSDAT2  equ      0B1H
RSCNT2  equ      0B3H
RSSTA2  equ      0B0H
RSMSK2  equ      0B0H
RSMR2   equ       -1
BAUD2   equ      0B8H
BMAX2   equ       08H
BMASK2  equ       07H
INTVEC2 equ       0DH		; MOGURA
IMRMSK2 equ       20H		; MOGURA
PICMST2 equ       -1
INTEBL2 equ       01H
INTDIS2 equ      0F8H

; RS-232C (3)  int=IR3  (INT0)	; MOGURA
RSDAT3  equ      0B9H
RSCNT3  equ      0BBH
RSSTA3  equ      0B2H
RSMSK3  equ      0B2H
RSMR3   equ       -1
BAUD3   equ      0BAH
BMAX3   equ       08H
BMASK3  equ       07H
INTVEC3 equ       0BH		; MOGURA
IMRMSK3 equ       08H		; MOGURA
PICMST3 equ        -1
INTEBL3 equ       01H
INTDIS3 equ      0F8H

; RS-232C (3)  int=IR12 (INT5)
RSDAT4  equ     01B1H
RSCNT4  equ     01B3H
RSSTA4  equ     01B0H
RSMSK4  equ     01B0H
RSMR4   equ       -1
BAUD4   equ     01B8H
BMAX4   equ       08H
BMASK4  equ       07H
INTVEC4 equ       14H
IMRMSK4 equ       10H		; MOGURA
INTEBL4 equ       01H
INTDIS4 equ      0F8H

; RS-232C (3)  int=IR13 (INT6)
RSDAT5  equ     01B9H
RSCNT5  equ     01BBH
RSSTA5  equ     01B2H
RSMSK5  equ     01B2H
RSMR5   equ       -1
BAUD5   equ     01BAH
BMAX5   equ       08H
BMASK5  equ       07H
INTVEC5 equ       15H
IMRMSK5 equ       20H		; MOGURA
INTEBL5 equ       01H
INTDIS5 equ      0F8H

elseif  BOARD   eq      B98_01
;
; PC-9801 W RS-232C ߰ + B98-01
;
INTMSKD EQU       38H
INTMSKS EQU       00H

; RS-232C (2)  int=IR5  (INT1)
RSDAT2  equ      0B1H
RSCNT2  equ      0B3H
RSSTA2  equ      0B0H
RSMSK2  equ      0B0H
BAUD2   equ      0D1H
BMAX2   equ       0BH
BMASK2  equ       0FH
FUNC2   equ      0D3H
FNCREG2 equ      0F2H
INTVEC2 equ       0DH
IMRMSK2 equ       20H
PICMST2 equ        -1
INTEBL2 equ       01H
INTDIS2 equ       00H

; RS-232C (3)  int=IR3  (INT0)
RSDAT3  equ      0B9H
RSCNT3  equ      0BBH
RSSTA3  equ      0B2H
RSMSK3  equ      0B2H
BAUD3   equ      0D5H
BMAX3   equ       0BH
BMASK3  equ       0FH
FUNC3   equ      0D7H
FNCREG3 equ      0F2H
INTVEC3 equ       0BH
IMRMSK3 equ       08H
PICMST3 equ       -1
INTEBL3 equ       01H
INTDIS3 equ       00H

FNC_REG equ      0F2H

endif

TCOUNT2 equ       75H            ; -2
TMODE   equ       77H            ; Ӱ
XON     equ       11H            ;]ĊJ
XOFF    equ       13H            ;]ꎞf
ENABLE  equ       37H            ;RS,DTR ON
RSOFF   equ       17H            ;RS OFF
DTROFF  equ       35H            ;DTR OFF
BREAKS  equ       03H            ;Break key
PAUSES  equ       13H            ;Pause key
RXRDY   equ     00000010b
TXRDY   equ     00000001b

OCW1_M  equ       02H
OCW2_M  equ       00H
OCW3_M  equ       00H
ISR_M   equ       00H
IMR_M   equ       02H

OCW1_S  equ       0AH
OCW2_S  equ       08H
OCW3_S  equ       08H
ISR_S   equ       08H
IMR_S   equ       0AH

BUFLEN  equ     0800H           ;̓obt@̒
XONp    equ     0100H           ;XON𑗐Mʒu
XOFFp   equ     0600H           ;XOFF𑗐Mʒu

TRUE    equ     0FFH
FALSE   equ      00H

SETVECT equ      25H
GETVECT equ      35H

;--------------------------------------------------
;       ėp}N
;--------------------------------------------------
msdos   macro   req,param
        IFNB    <param>
                mov     ax,req*256+param
        ELSE
                mov     ah,req
        ENDIF
        int     21h
endm

timing  macro                   ;肪Ƃ܂Rl
        out     5fh,al
        out     5fh,al
        out     5fh,al
        out     5fh,al
        out     5fh,al
        out     5fh,al
        out     5fh,al
        out     5fh,al
        out     5fh,al
endm

pushs   macro   regs
        irp     reg,<regs>
        push    reg
        endm
endm

pops    macro   regs
        irp     reg,<regs>
        pop     reg
        endm
endm

movsreg macro   sreg1,sreg2
        push    sreg2
        pop     sreg1
endm

changevect      macro   vect,vecth
        msdos   GETVECT,vecth
        mov     word ptr ofs&vect,bx
        mov     word ptr seg&vect,es
        mov     dx,offset int&vect
        msdos   SETVECT,vecth
endm

resetvect       macro   vect,vecth
        push    ds
        mov     dx,word ptr ofs&vect
        mov     ds,word ptr seg&vect
        msdos   SETVECT,vecth
        pop     ds
endm

;--------------------------------------------------
;       R[hEX^[g
;--------------------------------------------------
code    segment word public
        assume  cs:code,ds:code,es:code

        org     0000h           ;ײް  ̾ 0 

;-------------------------------------------------------------------
; ײް ̖ߍ
;  Offset  Length  Data
;  00000H     08H  ײް ̓K ޼ޮ 
;  00008H     01H  30H iLQƁj
;  00009H    (30H) ײް   i48j
;  00039H     30H  쌠\ i48j
;  00069H     02H  RS-232C [`̃ItZbgAhX
;  0006BH     02H  RS-232C [`̃ItZbgAhX
;  0006DH     02H  t@NVR[̃ItZbgAhX
;  0006FH     04H  R}hCfarAhXiRTBBS Zbgj
;  00073H     01H  ײް  ߰   
;  00074H     02H  M ޯ̧  ޲ 
;  00076H     02H  M ޯ̧  ޲ 
;
;@ғE ٰ  TP ̋K (Procedure) ɏ] call B
;@ڰ  ı  ڼ޽  ނYĂ͂ȂB
;
;  ײް   ͌ɂ 48 ȓȂǂB
;  ȉꍇA00008H ɒw肷Bj

revs    db      DRV_REV         ;ײް dl ޼ޮ  (rev1.02)
titlen  db      TTL_LEN
rstit   db      RS_TTL
cpr     db      COPYRIGHT
srtbl   dw      setrs           ; ٰ
rmtbl   dw      remove          ; ٰ
functbl dw      func            ;̧ݸݺ
cmdline dd      ?               ;ײ
rsch    db      CH_MAX          ;ِ
txbufs  dw      0               ;Mޯ̧
rxbufs  dw      BUFLEN          ;Mޯ̧
;-------------------------------------------------------------------

;------------------------------------------------
; WORK AREA
;------------------------------------------------
workarea        macro   CN
ofsCH&CN        dw      ?
segCH&CN        dw      ?
flow&CN         db      ?
Xpara&CN        db      ?
rxtail&CN       dw      ?
rxptr&CN        dw      ?
chkbrk&CN       db      ?
buff&CN         db      BUFLEN dup(?)
endm

        workarea        1
if      CH_MAX  ge      2
        workarea        2
endif
if      CH_MAX  ge      3
        workarea        3
endif
if      CH_MAX  ge      4
        workarea        4
endif
if      CH_MAX  ge      5
        workarea        5
endif

ofsUSER dw      ?               ;intUSER ޔp
segUSER dw      ?
ofs0F   dw      ?               ;int0Fh ޔp
seg0F   dw      ?
ofs17   dw      ?               ;int17h ޔp
seg17   dw      ?
imrmsave        db      ?       ;imri}X^[jۑp {ComServe}
imrssave        db      ?       ;imriX[ujۑp {ComServe}

;------------------------------------------------------
;       }N
;------------------------------------------------------

;------------------------------------------------
;       RS-232C ̃}XNs
;
;------------------------------------------------
rsintd  macro   CN
ifdef   RSMR&CN
        mov     dx,RSMSK&CN
        in      al,dx
        and     al,INTDIS&CN
else
        mov     al,INTDIS&CN
endif
        mov     dx,RSMSK&CN
        out     dx,al           ;RxR,TxE,TxR}XN
endm

;------------------------------------------------
; $*0 : qr|QRQbCjVCY
;      in :al=baud
;      out:none
;------------------------------------------------
rsinit          macro   CN
rsinit&CN:
if      CN      eq      1
        call    timerinit       ;timerinit
elseifdef   BAUD&CN
        mov     ah,BMAX&CN      ;set baud
        sub     ah,al
        mov     al,ah
        and     al,BMASK&CN
        mov     dx,BAUD&CN
        out     dx,al
endif

ifdef   FUNC&CN
        mov     dx,FUNC&CN      ;̧ݸݥڼ޽
        mov     al,FNCREG&CN
        out     dx,al
endif
        mov     al,TRUE         ;flow1:=true
        mov     flow&CN,al
        mov     al,XON          ;Xpara1:=XON
        mov     Xpara&CN,al

ifdef   PICMST&CN
        in      al,IMR_M        ;荞݋֎~
        or      al,IMRMSK&CN
        out     IMR_M,al
else
        in      al,IMR_S
        or      al,IMRMSK&CN
        out     IMR_S,al
endif
        rsintd  CN
        push    ax
        push    dx
        timing
        xor     al,al
        mov     dx,RSCNT&CN
        out     dx,al           ;make sure that
        timing
        out     dx,al           ;USART is in commmand
        timing
        out     dx,al           ;word sequence
        timing
        mov     al,40h          ;internal reset
        out     dx,al
        timing
        mov     al,4eh          ;Ӱܰ: stop=1bit
        out     dx,al           ;parity=disable, 8bit, 16x
        timing
        mov     al,ENABLE       ;ܰ
        out     dx,al
        pop     dx
        pop     ax
        or      al,INTEBL&CN    ;RxRDY enable set
        out     dx,al

ifdef   PICMST&CN
        in      al,IMR_M        ;荞݋
        and     al,not IMRMSK&CN
        out     IMR_M,al
else
        in      al,IMR_S
        and     al,not IMRMSK&CN
        out     IMR_S,al
endif
        call    initbuf&CN
        ret
endm

;------------------------------------------------
; $*1 : t[Rg[ ON/OFF
;      in :AL ($00=ON , other=OFF)
;      out:none
;------------------------------------------------
rsflow  macro   CN
        local   l03, l04
rsflow&CN:
        and     al,al           ;if AL=$00 then begin
        jnz     l03
        mov     al,TRUE         ;  flow1:=true
        jmp     short l04       ;end
l03:    mov     al,FALSE        ;else begin
l04:    mov     flow&CN,al      ;  flow1:=false
        ret
endm

;------------------------------------------------
; $*2 : o̓obt@ɓĂ镶^
;      ĩhCo[ɂ̓obt@͂Ȃ̂
;        |[go͉\Ăj
;      in :none
;      out:AX
;------------------------------------------------
gettxlen        macro   CN
        local   l01
gettxlen&CN:
        xor     ax,ax
        mov     dx,RSCNT&CN
        in      al,dx
        and     al,05h
        jz      l01
        mov     dx,RSSTA&CN
        in      al,dx
        and     al,40h
        jnz     l01
        xor     al,al
        ret
l01:    mov     al,1
        ret
endm

;------------------------------------------------
; $*3 : ̓obt@ɓĂ镶^
;      in :none
;      out:AX
;------------------------------------------------
getrxlen        macro   CN
        local   l09
getrxlen&CN:
        mov     ax,rxtail&CN    ;len:=rxtail1-rxptr1
        sub     ax,rxptr&CN
        jae     l09             ;if len<0 then
        add     ax,BUFLEN       ;  len:=len+buf_length
l09:    ret
endm

;------------------------------------------------
; $*4 : P
;      in :AL
;      out:RS-232C
;------------------------------------------------
rssend  macro   CN
rssend&CN:
        mov     dx,RSDAT&CN
        out     dx,al
        ret
endm

;------------------------------------------------
; $*5 : P
;      in :RS-232C
;      out:AL=chr, AH=$00
;------------------------------------------------
rsrecv  macro   CN
        local   l07, l08, l09, l0e
rsrecv&CN:
        call    getrxlen&CN     ;if len(buff1)<>0 then
        and     ax,ax
        jz      l0e
        mov     dx,ax
        mov     bx,offset buff&CN
        cli
        mov     si,rxptr&CN
        mov     al,[bx+si]      ;al:=buff1[si]
        inc     si              ;si:=si+1
        cmp     si,BUFLEN       ;if si=buf_length then
        jnz     l07
        xor     si,si           ;  si:=0
l07:    mov     rxptr&CN,si     ;rxptr1:=si
        sti
        push    ax
        cmp     dx,XONp         ;if len(buff1)<=XONp then
        jae     l08
        mov     al,Xpara&CN     ;  if Xpara1=XOFF then
        cmp     al,XOFF
        jnz     l08
        mov     al,ENABLE       ;    RTS enable
        mov     dx,RSCNT&CN
        out     dx,al
        mov     al,XON          ;    Xpara1:=XON
        mov     Xpara&CN,al
        mov     al,flow&CN      ;    if flow1=true then
        and     al,al
        jz      l08
l09:
        mov     dx,RSSTA&CN
        in      al,dx
        test    al,40h
        not     al
        jnz     l08
        mov     dx,RSCNT&CN
        in      al,dx
        test    al,TXRDY
        jz      l09
        mov     al,XON
        call    rssend&CN       ;    write(f,XON)
l08:    pop     ax
        xor     ah,ah           ;ah:=$00
l0e:    ret
endm

;------------------------------------------------
; $*6 : ̓obt@̏
;      in :none
;      out:none
;------------------------------------------------
initbuf macro   CN
        local   l01
initbuf&CN:
        xor     ax,ax
        cli
        mov     rxptr&CN,ax     ;rxptr1 :=0
        mov     rxtail&CN,ax    ;rxtail1:=0
        mov     chkbrk&CN,al    ;chkbreak:=0
        sti
        mov     al,ENABLE       ;RTS enable
        mov     dx,RSCNT&CN
        out     dx,al
        mov     al,XON
        cmp     al,flow&CN
        jz      l01
        mov     Xpara&CN,al     ;Xpara1:=XON
l01:    ret
endm

;------------------------------------------------
; $*7 : ڰݸ װ ̌o
;      in :none
;      out:AL
;------------------------------------------------
getstat macro   CN
        local   l02
getstat&CN:
        xor     ax,ax
        mov     dx,RSCNT&CN
        in      al,dx
        and     al,20h
        push    ax
        in      al,dx
        timing
        test    al,3Ch          ;ð
        jz      l02
        mov     al,ENABLE       ;ܰ
        out     dx,al
l02:    pop     ax
        ret
endm

;------------------------------------------------
; $*8 : LA`FbN
;      in :none
;      out:AL
;------------------------------------------------
chkcts  macro   CN
chkcts&CN:
        xor     ax,ax
        mov     dx,RSSTA&CN
        in      al,dx
        not     al
        and     al,20h
        ret
endm

;------------------------------------------------
; $*9 : DTR 𗎂Ƃiؒfj
;      in :none
;      out:none
;------------------------------------------------
dropdtr macro   CN
dropdtr&CN:
        mov     al,DTROFF
        mov     dx,RSCNT&CN
        out     dx,al
        ret
endm

;------------------------------------------------
; $*A : DTR,RTS  Ȱ ɂ
;      in :none
;      out:none
;------------------------------------------------
raiserts        macro   CN
raiserts&CN:
        mov     al,ENABLE
        mov     dx,RSCNT&CN
        out     dx,al
        ret
endm

;------------------------------------------------
; $*B : break , pause ̓`FbN
;      in :none
;      out:AL
;------------------------------------------------
break   macro   CN
break&CN:
        xor     ax,ax
        mov     al,chkbrk&CN
        mov     chkbrk&CN,ah
        ret
endm

;================================================
;    qr|QRQbn[hEFA荞
; if[^MɊ荞݂j
;================================================
rshdint macro   CN
        local   l08,l09,l10,l0a,l0b,l0c,l0d
intCH&CN:
        pushs   <ax,bx,dx,si,ds,cs>
        pop     ds
        mov     dx,RSCNT&CN
        in      al,dx
        test    al,RXRDY        ;Mf[^LH
        jz      l0c

        mov     bx,offset buff&CN
        mov     dx,RSDAT&CN
        in      al,dx
l08:    cmp     al,BREAKS       ;if (get 1 chr)=abort then
        jnz     l09
        mov     chkbrk&CN,al    ;  chkbreak:=abort
        jmp     short l10
l09:    cmp     al,PAUSES       ;else if (get 1 chr)=pause then
        jnz     l10
        mov     chkbrk&CN,al    ;  chkbreak:=pause
l10:    cli
        mov     si,rxtail&CN    ;si:=rxtail1
        mov     [bx+si],al      ;buff1[si]:=(get 1 chr)
        inc     si              ;si:=si+1
        cmp     si,BUFLEN       ;if si=buf_length then
        jnz     l0a
        xor     si,si           ;  si:=0
l0a:    mov     rxtail&CN,si    ;rxtail1:=si
        call    getrxlen&CN
        sti
        cmp     ax,XOFFp        ;if ax>=XOFFp then
        jbe     l0c
        mov     al,Xpara&CN     ;  if Xpara1=XON then
        cmp     al,XON
        jnz     l0c
        mov     al,RSOFF        ;    RTS disable
        mov     dx,RSCNT&CN
        out     dx,al
        mov     al,XOFF         ;    Xpara1:=XOFF
        mov     Xpara&CN,al
        mov     al,flow&CN      ;    if flow1=true then
        and     al,al
        jz      l0c
        mov     al,XOFF
        call    rssend&CN       ;      write(f,XOFF)
l0c:    pops    <ds,si,dx,bx>
ifndef  PICMST&CN
        mov     al,20h          ; ڰPIC  EOI s
        out     OCW2_S,al
        mov     al,0Bh          ; ڰނɊ޽̊قȂ ?
        out     OCW3_S,al
        in      al,ISR_M
        test    al,0FFh
        jnz     l0d             ; ΏI
endif
        mov     al,20h          ; ϽPIC  EOIs
        out     OCW2_M,al       ;
l0d:
        pop     ax
        iret
endm

;------------------------------------------------
;       WvEe[u
;------------------------------------------------
jmptable        macro   CN
        dw      rsinit&CN       ; $00
        dw      rsflow&CN       ; $01
        dw      gettxlen&CN     ; $02
        dw      getrxlen&CN     ; $03
        dw      rssend&CN       ; $04
        dw      rsrecv&CN       ; $05
        dw      initbuf&CN      ; $06
        dw      getstat&CN      ; $07
        dw      chkcts&CN       ; $08
        dw      dropdtr&CN      ; $09
        dw      raiserts&CN     ; $0A
        dw      break&CN        ; $0B
        dw      nops            ; $0C
        dw      nops            ; $0D
        dw      nops            ; $0E
        dw      nops            ; $0F
endm
;-----------------------------------------------
;       }NI
;-----------------------------------------------


;================================================
; hCȏgݍ
;================================================

setrs   proc    far
        push    ds                      ;ް 
        movsreg ds,cs                   ; ı

        cli
        in      al,IMR_M                ; PIC ɂ֘A荞݋֎~
        mov     imrmsave,al             ; imri}X^[jۑ {ComServe}
        or      al,INTMSKD
        out     IMR_M,al
if      INTMSKS    eq   0
        in      al,IMR_S
        mov     imrssave,al             ; imriX[ujۑ {ComServe}
        or      al,INTMSKS
        out     IMR_S,al
endif
        sti

        CHNO =    1
rept    CH_MAX
        rsintd          %CHNO
        changevect      CH%CHNO,INTVEC%CHNO     ;qrQRQb荞
        CHNO =    CHNO + 1
endm
        changevect      0F,0Fh          ;sS荞ݑ΍̂
        changevect      17,17h          ;    

        pop     ds                      ;ڼ޽ ؽı
        ret

setrs           endp

;================================================
; hCỏ
;================================================
remove          proc    far

        push    ds                      ;ް 
        movsreg ds,cs                   ; ı

        cli
        in      al,IMR_M                ; PIC ɂ֘A荞݋֎~
        or      al,INTMSKD
        out     IMR_M,al
if      INTMSKS    eq   0
        in      al,IMR_S
        or      al,INTMSKS
        out     IMR_S,al
endif
        sti

        CHNO =    1
rept    CH_MAX
        rsintd          %CHNO
        resetvect       CH%CHNO,INTVEC%CHNO     ;qrQRQb荞
        CHNO =    CHNO + 1
endm
        resetvect       0F,0Fh
        resetvect       17,17h

        cli                             ; 荞݃}XNA {ComServe}
        mov     al,imrmsave
        out     IMR_M,al
if      INTMSKS    eq   0
        mov     al,imrssave
        out     IMR_S,al
endif
        sti

        pop     ds                      ;ڼ޽ ؽı
        ret

remove          endp

;================================================
; t@NVR[
;   in:AH(R}hԍ)
;================================================
func            proc    far

        push    ds              ;ް 
        movsreg ds,cs           ; ı
        mov     ax,si           ;̧ݸݎ擾

        cmp     ah,CMD_MAX      ;ޔ͈!!
        jae     dummy           ;  NG
        push    ax
        mov     al,ah
        xor     ah,ah
        mov     bx,offset jmptbl
        shl     ax,1
        add     bx,ax           ;ð ڽ ..
        pop     ax
        call    [bx]            ;Jump !

dummy:  mov     si,ax           ;߂l
        pop     ds              ;ڼ޽ ؽı
        ret
func            endp

nops:   ret

;------------------------------------------------
;       _~[荞ݏ
;------------------------------------------------
int0F:
int17:  iret

;------------------------------------------------
;       WvEe[u
;------------------------------------------------
jmptbl:
        CHNO =  1
rept    CH_MAX
        jmptable        %CHNO
        CHNO =  CHNO + 1
endm

;------------------------------------------------
;       e߰ėp
;------------------------------------------------
        CHNO =    1
rept    CH_MAX
        rshdint         %CHNO
        rsinit          %CHNO
        rsflow          %CHNO
        gettxlen        %CHNO
        getrxlen        %CHNO
        rssend          %CHNO
        rsrecv          %CHNO
        initbuf         %CHNO
        getstat         %CHNO
        chkcts          %CHNO
        dropdtr         %CHNO
        raiserts        %CHNO
        break           %CHNO
        CHNO =    CHNO + 1
endm

;------------------------------------------------
;       W߰ėpۯݒ
;------------------------------------------------
timerinit:
        push    ax
        mov     ax,cs
        mov     ds,ax
        mov     al,0b6h
        out     TMODE,al
        mov     ax,0000h
        mov     es,ax
        mov     bx,offset timdat1
        mov     al,es:[0501h]   ;VXeʈ
        test    al,80h          ;10MHz : timedat1
        jz      l06             ; 8MHz : timedat2
        mov     bx,offset timdat2
l06:    pop     ax
        xor     ah,ah
        add     ax,ax
        add     bx,ax
        mov     ax,[bx]
        out     TCOUNT2,al
        timing
        mov     al,ah
        out     TCOUNT2,al
        timing
        ret

timdat1:
        dw      0800h, 0400h, 0200h, 0100h
        dw      0080h, 0040h, 0020h, 0010h
        dw      0008h, 0004h
timdat2:
        dw      0680h, 0340h, 01a0h, 00d0h
        dw      0068h, 0034h, 001ah, 000dh
        dw      0006h, 0003h                 ; ۏؖ

code    ends
        end

