
;==============================================
;  RS232C ײް (BUSICOM/Channel-4)
;    Driver version     : 1.0
;    Interface revision : 1.02  ('RTRS$102')
;  Copyright by Eskage/ComServe
;
; The resource IWi
; '92.03.31 RSDRVNRM.ASM NB   (ComServe)
; '92.10.18 eC                    (kim)
; '92.10.19 IvVŋ@I        (ComServe)
;
;==============================================
VERSION         equ     ' ver1.0  for rev1.02'
DATE            equ     '1992/10/19'
DRV_REV         equ     'RTRS$102'
;

;                        12345678901234567890123456789012345678
COPYRIGHT       equ     'Copyright by Eskage/ComServe          ',DATE

CH_MAX          equ     4
CMD_MAX         equ     0FH
TTL_LEN         equ     48
;                        1234567890123456789012345678
RS_TTL          equ     'RSDRV:Busicom Channel-4/??  ',VERSION
TITOFS		equ	24


WRITEOK equ     01H            ;ްoͽ۰
READOK  equ     02H            ;ްͽ۰

RSRESET equ     10             ;`lZbg
ERCLEAR equ     13             ;G[NA
GETTXL  equ     26             ;Mobt@
GETRXL  equ     25             ;Mf[^
STAT1   equ     20             ;Xe[^XP
STAT2   equ     21             ;Xe[^XQ
GETRXD  equ     31             ;PM
SETTXD  equ     32             ;PM
EDTR    equ     80             ;DTR ON		{ kim }
DDTR    equ     81             ;DTR OFF

BREAKS  equ     03H            ;Break key
PAUSES  equ     13H            ;Pause key

TRUE    equ     0FFH
FALSE   equ     00H

;--------------------------------------------------
;       ėp}N
;--------------------------------------------------

pushs   macro   regs
        irp     reg,<regs>
        push    reg
        endm
endm

pops    macro   regs
        irp     reg,<regs>
        pop     reg
        endm
endm

movsreg macro   sreg1,sreg2
        push    sreg2
        pop     sreg1
endm

;--------------------------------------------------
;       R[hEX^[g
;--------------------------------------------------
code    segment word public
        assume  cs:code,ds:code,es:code

        org     0000h           ;ײް  ̾ 0 

;-------------------------------------------------------------------
; ײް ̖ߍ
;  Offset  Length  Data
;  00000H     08H  ײް ̓K ޼ޮ 
;  00008H     01H  30H iLQƁj
;  00009H    (30H) ײް   i48j
;  00039H     30H  쌠\ i48j
;  00069H     02H  RS-232C [`̃ItZbgAhX
;  0006BH     02H  RS-232C [`̃ItZbgAhX
;  0006DH     02H  t@NVR[̃ItZbgAhX
;  0006FH     04H  R}hCfarAhXiRTBBS Zbgj
;  00073H     01H  ײް  ߰   
;  00074H     02H  M ޯ̧  ޲ 
;  00076H     02H  M ޯ̧  ޲ 
;
;@ғE ٰ  TP ̋K (Procedure) ɏ] call B
;@ڰ  ı  ڼ޽  ނYĂ͂ȂB
;
;  ײް   ͌ɂ 48 ȓȂǂB
;  ȉꍇA00008H ɒw肷Bj

revs    db      DRV_REV         ;ײް dl ޼ޮ  (rev1.02)
titlen  db      TTL_LEN
rstit   db      RS_TTL
cpr     db      COPYRIGHT
srtbl   dw      setrs           ; ٰ
rmtbl   dw      remove          ; ٰ
functbl dw      func            ;̧ݸݺ
cmdline dd      ?               ;ײ
rsch    db      CH_MAX          ;ِ
txbufs  dw      256             ;Mޯ̧
rxbufs  dw      256             ;Mޯ̧ (mɂ 1024)
;-------------------------------------------------------------------

;------------------------------------------------
; WORK AREA
;------------------------------------------------
dport   dw      ?               ;ް߰
tport   dw      ?               ;ݸ߰

;------------------------------------------------
; |[go̓[`
;      in :al=data
;      out:none
;------------------------------------------------
outport proc    near
        mov     dx,tport
        push    ax
ox01:   in      al,dx
        test    al,WRITEOK
        jz      ox01
        pop     ax
        mov     dx,dport
        out     dx,al
        ret
outport endp

;------------------------------------------------
; |[g̓[`
;      in :none
;      out:al=data
;------------------------------------------------
inport  proc    near
        mov     dx,tport
ix01:   in      al,dx
        test    al,READOK       ; { kim }
        jz      ix01
        mov     dx,dport
        in      al,dx           ; { kim }
        ret
inport  endp

;------------------------------------------------
; $00 : qr|QRQbCjVCY
;      in :al=baud
;      out:none
;------------------------------------------------
rsinit  proc    near
        add     al,40
        call    outport
        mov     al,RSRESET
        call    outport
        mov     al,53           ;8 bits length
        call    outport
        mov     al,60           ;1 stop bits
        call    outport
        mov     al,70           ;Parity-none
        call    outport
        mov     al,84           ;RTS self auto
        call    outport
        mov     al,94           ;software's flow self auto
        call    outport
        jmp     initbuf
rsinit  endp

;------------------------------------------------
; $01 : t[Rg[ ON/OFF
;      in :AL ($00=ON , other=OFF)
;      out:none
;------------------------------------------------
rsflow  proc    near
        add     al,94           ;software's flow control
        call    outport
        ret
rsflow  endp

;------------------------------------------------
; $02 : o̓obt@ɓĂ镶^
;      in :none
;      out:AX
;------------------------------------------------
gettxlen        proc    near
        mov     al,GETTXL       ;get txbuffer free
        call    outport
        call    inport
        mov     bl,al
        mov     al,255
        sub     al,bl
        xor     ah,ah
        ret
gettxlen        endp

;------------------------------------------------
; $03 : ̓obt@ɓĂ镶^
;      in :none
;      out:AX
;------------------------------------------------
getrxlen        proc    near
        mov     al,GETRXL       ;get rxbuffer sinked
        call    outport
        call    inport
        xor     ah,ah
        ret
getrxlen        endp

;------------------------------------------------
; $04 : P
;      in :AL
;      out:RS-232C
;------------------------------------------------
rssend  proc    near
        mov     bl,al
        mov     al,SETTXD       ;set data to txbuffer
        call    outport
        mov     al,bl
        call    outport
        ret
rssend  endp

;------------------------------------------------
; $05 : P
;      in :RS-232C
;      out:AL=chr, AH=$00
;------------------------------------------------
rsrecv  proc    near
        mov     al,GETRXD       ;get data from rxbuffer
        call    outport
        call    inport
        xor     ah,ah
        ret
rsrecv  endp

;------------------------------------------------
; $06 : ̓obt@̏
;      in :none
;      out:none
;------------------------------------------------
initbuf proc    near
        mov     al,RSRESET      ;all reset (not changed baud and status)
        call    outport
        ret
initbuf endp

;------------------------------------------------
; $07 : ڰݸ װ ̌o
;      in :none
;      out:AL
;------------------------------------------------
getstat proc    near
        mov     al,STAT2        ;get status2
        call    outport
        call    inport
        and     al,80h          ;mask of parity-error
        ret
getstat endp

;------------------------------------------------
; $08 : LA`FbN
;      in :none
;      out:AL
;------------------------------------------------
chkcts  proc    near
        mov     al,STAT1        ;get status1
        call    outport
        call    inport
        and     al,04h          ;mask of carrier detects
        ret
chkcts  endp

;------------------------------------------------
; $09 : DTR 𗎂Ƃiؒfj
;      in :none
;      out:none
;------------------------------------------------
dropdtr proc    near
        mov     al,DDTR         ;disable DTR
        call    outport
        ret
dropdtr endp

;------------------------------------------------
; $0A : DTR,RTS  Ȱ ɂ
;      in :none
;      out:none
;------------------------------------------------
raiserts        proc    near
        mov     al,EDTR         ;enable DTR
                                ;RTS ͏ɓ삵Ă̂ŐGȂB
        call    outport
        ret
raiserts        endp

;------------------------------------------------
; $0B : break , pause ̓`FbN
;      i܂肠j
;      in :none
;      out:AL
;------------------------------------------------
break   proc    near
        mov     al,STAT1        ;get status1
        call    outport
        call    inport
        and     al,10h          ;mask of xoff detective
        jnz     br01
        xor     al,al
        ret
br01:   mov     al,PAUSES
        ret
break   endp

;-----------------------------------------------
;       }NI
;-----------------------------------------------


;================================================
; hCȏgݍ݁^J
;================================================

setrs   proc    far

	push	ds
	mov	ax,cs
	mov	ds,ax

	mov	si,offset rstit+TITOFS

	les	bx,cmdline		;R}hC擾
	mov	cl,byte ptr es:[bx]	;cl=length(cmdline);
	inc	bx
	xor	dx,dx

lpopt:	mov	al,byte ptr es:[bx]
	cmp	al,'-'
	jz	stopt
	cmp	al,'/'
	jz	stopt

	jmp	short nxopt

stopt:	inc	bx
	dec	cl
	jz	enopt
	mov	al,byte ptr es:[bx]
	cmp	al,'9'
	jz	set98
	cmp	al,'A'			;蔲 :-)
	jz	setAT
	cmp	al,'a'
	jz	setAT
	cmp	al,'F'
	jz	setFM
	cmp	al,'f'
	jz	setFM

nxopt:	inc	bx
	dec	cl
	jz	enopt
	jmp	short lpopt

set98:	xor	dl,dl
	mov	word ptr ds:[si],03839h	;"98"
	jmp	short nxopt
setAT:	mov	dl,1
	mov	word ptr ds:[si],05441h	;"AT"
	jmp	short nxopt
setFM:	mov	dl,2
	mov	word ptr ds:[si],04d46h	;"FM"
	jmp	short nxopt

enopt:	shl	dx,1
	shl	dx,1
	mov	bx,offset ioadr
	add	bx,dx

	mov	ax,word ptr ds:[bx]
	mov	dport,ax
	mov	ax,word ptr ds:[bx+2]
	mov	tport,ax

	pop	ds

remove: ret

setrs   endp

;================================================
; t@NVR[
;   in:AH(R}hԍ)
;================================================

func    proc    far
        push    ds              ;ް 
        movsreg ds,cs           ; ı
        mov     ax,si           ;̧ݸݎ擾
        and     ah,0fh          ;{ kim }
        cmp     ah,CMD_MAX      ;ޔ͈!!
        jae     dummy           ;  NG
        push    ax
        mov     al,ah
        and     al,0f0h
        mov     cl,4
        shr     al,cl
        call    outport         ;channel ݒ
        mov     al,ah
        and     al,0fh
        xor     ah,ah
        mov     bx,offset jmptbl
        shl     ax,1
        add     bx,ax           ;ð ڽ ..
        pop     ax
        call    [bx]            ;Jump !
dummy:  mov     si,ax           ;߂l
        pop     ds              ;ڼ޽ ؽı
        ret
func    endp

nops:   ret

;------------------------------------------------
;       WvEe[u
;------------------------------------------------
jmptbl  dw      rsinit          ; $00
        dw      rsflow          ; $01
        dw      gettxlen        ; $02
        dw      getrxlen        ; $03
        dw      rssend          ; $04
        dw      rsrecv          ; $05
        dw      initbuf         ; $06
        dw      getstat         ; $07
        dw      chkcts          ; $08
        dw      dropdtr         ; $09
        dw      raiserts        ; $0A
        dw      break           ; $0B
        dw      nops            ; $0C
        dw      nops            ; $0D
        dw      nops            ; $0E
        dw      nops            ; $0F

;------------------------------------------------
;       h^nAhXEe[u
;------------------------------------------------
ioadr   dw	000ddh,000dfh	;for PC-9800
	dw	070dch,070deh	;for FM-R
	dw	0031ch,0031eh	;for PC/AT

code    ends
        end

