Uses
  Crt;


  {$I ..\users.inc}

Type

  oldUSERSrecord = Record
    Name                                     : String [36];
    Location, Organization, Address1,
    Address2, Address3                       : String [50];
    Comment                                  : String [80];
    Password, HPhone, BPhone                 : String [15];
    Lang                                     : String [8];
    LastRead, NoCalls, Uploads, Downloads,
    UploadsK, DownloadsK, TodayK, MsgsPosted,
    LastDate, FirstDate, BirthDate,
    TimeUsedToday, TotalTime                 : LongInt;
    TimeCount, More, HotKeys                 : Boolean;
    Protocol, Lines, MsgArea, FileArea       : Byte;
    Security                                 : Word;
    Emu                                      : Char;
  End;

Var
  InStruct      : oldUSERSrecord;
  OutStruct     : USERSrecord;
  InFile        : File Of oldUSERSrecord;
  OutFile       : File Of USERSrecord;

Procedure ErrorExit (S: String);
Begin
  WriteLn (S);
  WriteLn (' Error exit..');
  WriteLn;
  Halt (1);
End;

Begin

  WriteLn;
  TextColor (11); WriteLn ('  Tornado 1.06beta -> 1.07beta userbase convertor');
  TextColor (14); WriteLn ('  Copyright (c) Konstatin Klyagin, Kharkov, Ukraine, 1996');
  WriteLn;
  TextColor (7);

  {$I-}
  Assign (InFile, 'users.tor');
  Reset (InFile);
  If IOResult <> 0 Then ErrorExit ('! Unable to open file USERS.TOR');
  If FileSize (InFile) = 0 Then ErrorExit ('! File USERS.TOR is empty');

  Assign (OutFile, 'ubconv.$$$');
  ReWrite (OutFile);
  If IOResult <> 0 Then ErrorExit ('! Unable to create file ubconv.$$$');

  WriteLn (' Total users: ', FileSize (InFile));
  WriteLn (' Converting userbase, please wait..');

  While Not EoF (InFile) Do
  Begin
    Read (InFile, InStruct);
    If IOResult <> 0 Then
    Begin
      Erase (OutFile);
      ErrorExit ('! File USERS.TOR is already converted or corrupted');
    End;
    Write (' User: ', InStruct. Name + '                                              ');

    OutStruct. Name := InStruct. Name;
    OutStruct. Location := InStruct. Location;
    OutStruct. Organization := InStruct. Organization;
    OutStruct. Address1 := InStruct. Address1;
    OutStruct. Address2 := InStruct. Address2;
    OutStruct. Address3 := InStruct. Address3;
    OutStruct. Comment := InStruct. Comment;
    OutStruct. Password := InStruct. Password;
    OutStruct. HPhone := InStruct. HPhone;
    OutStruct. BPhone := InStruct. BPhone;
    OutStruct. Lang := InStruct. Lang;
    OutStruct. LastRead := InStruct. LastRead;
    OutStruct. NoCalls := InStruct. NoCalls;
    OutStruct. Uploads := InStruct. Uploads;
    OutStruct. Downloads := InStruct. Downloads;
    OutStruct. UploadsK := InStruct. UploadsK;
    OutStruct. DownloadsK := InStruct. DownloadsK;
    OutStruct. TodayK := InStruct. TodayK;
    OutStruct. MsgsPosted := InStruct. MsgsPosted;
    OutStruct. LastDate := InStruct. LastDate;
    OutStruct. FirstDate := InStruct. FirstDate;
    OutStruct. BirthDate := InStruct. BirthDate;
    OutStruct. TimeUsedToday := InStruct. TimeUsedToday;
    OutStruct. TotalTime := InStruct. TotalTime;
    OutStruct. TimeCount := InStruct. TimeCount;
    OutStruct. More := InStruct. More;
    OutStruct. HotKeys := InStruct. HotKeys;
    OutStruct. Protocol := InStruct. Protocol;
    OutStruct. Lines := InStruct. Lines;
    OutStruct. MsgArea := InStruct. MsgArea;
    OutStruct. FileArea := InStruct. FileArea;
    OutStruct. Security := InStruct. Security;
    OutStruct. Emu := teAnsi;

    Write (OutFile, OutStruct);
    Write (#13);
  End;

  Close (OutFile);
  Assign (OutFile, 'ubconv.$$$');

  Erase (InFile);

  Rename (OutFile, 'users.tor');

  WriteLn;
  WriteLn (' Convert complete!');
  WriteLn;
End.
