Uses
  OpCrt,
  tMisc;

Var
  AreasBBS, MsgAreaCtl          : Text;
  Board                         : Integer;
  S, Address, BaseType, Base,
  rSec, wSec, sSec, nAreasBBS,
  Scan, nMsgAreaCtl, BasePath,
  HudPath, Group, Origin        : String;

Procedure ParseCommandLine;
Var
  i, fNum       : Byte;
  Param, Value  : String;

Begin
  fNum := 0;
  For i := 1 To ParamCount Do
  Begin
    Param := ParamStr (i);

    If (Param [1] = '-') Then
    Case Param [2] Of
      'A', 'a' : Address := Copy (Param, 3, 255);
      'R', 'r' : rSec    := Copy (Param, 3, 255);
      'W', 'w' : wSec    := Copy (Param, 3, 255);
      'S', 's' : sSec    := Copy (Param, 3, 255);
      'H', 'h' : HudPath := Copy (Param, 3, 255);
      'G', 'g' : Group   := PlaceSubStr (Copy (Param, 3, 255), '_', ' ');
      'M', 'm' : Scan    := Copy (Param, 3, 255);
      'O', 'o' : Origin  := PlaceSubStr (Copy (Param, 3, 255), '_', ' ');
    End Else
    Begin
      Inc (fNum);
      If fNum = 1 Then nAreasBBS := Param Else nMsgAreaCtl := Param;
    End;
  End;
End;

Procedure Error (i: Byte);
Const
  Action        : Array [1..2] Of String [6] = ('open', 'create');

Var
  P             : String;

Begin
  If i = 1 Then P := nAreasBBS
           Else P := nMsgAreaCtl;

  If IOResult <> 0 Then
  Begin
    WriteLn ('! Unable to ' + Action [i] + ' file ' + Trim (NiceFileName (P, 30)));
    WriteLn;
    Exit;
  End;
End;

Begin
  WriteLn;
  TextColor (11); WriteLn ('  areas.bbs to Tornado msgarea.ctl file format convertor');
  TextColor (14); WriteLn ('  Copyright (c) Konstatin Klyagin, Kharkov, Ukraine, 1996');
  WriteLn;
  TextColor (7);

  If ParamCount = 0 Then
  Begin
    WriteLn (' Usage:');
    WriteLn ('  ABBSCONV.EXE <areas.bbs name> <msgarea.ctl name> [switches]');
    WriteLn ('  Where switches are:');
    WriteLn ('    -A<network_address>');
    WriteLn ('    -R<read_security>');
    WriteLn ('    -W<write_security>');
    WriteLn ('    -S<sysop_security>');
    WriteLn ('    -H<path_to_hudson_msgbase>');
    WriteLn ('    -G<group>');
    WriteLn ('    -M<Yes/No - scan for private mail>');
    WriteLn ('    -O<Origin_line>');
    WriteLn;
    Exit;
  End;

  nAreasBBS := 'areas.bbs';
  nMsgAreaCtl := 'msgarea.ctl';
  HudPath := 'C:\TORNADO\MSGBASE\';

  ParseCommandLine;
  Assign (AreasBBS, nAreasBBS);
  {$I-} Reset (AreasBBS);
  {$I+} Error (1);

  Assign (MsgAreaCtl, nMsgAreaCtl);
  {$I-} ReWrite (MsgAreaCtl);
  {$I+} Error (2);

  WriteLn (' Converting ' + nAreasBBS + ' to ' + nMsgAreaCtl + ' ...');
  Write   (' Area: ');

  WriteLn (MsgAreaCtl, '; This message areas config file for Tornado');
  WriteLn (MsgAreaCtl, '; generated by areas.bbs->msgarea.ctl convertor');
  WriteLn (MsgAreaCtl, '; (c) Konstantin Klyagin, 1996');
  WriteLn (MsgAreaCtl);

  While Not Eof (AreasBBS) Do
  Begin
    ReadLn (AreasBBS, S);
    S := TrimLead (S);
    If (S [1] = ';') Or (Trim (S) = '') Then Continue;
    Write (PadCh (ExtractWord (2, S, [' ']), ' ', 40) + Replicate (#8, 40));
    Base := ExtractWord (1, S, [' ']);
    Board := 0;

    Case Base [1] Of
      '0'..'9': Begin
                  BaseType := 'Hudson';
                  BasePath := HudPath;
                  Board    := Str2Long (Base);
                End;
      '$'     : Begin
                  BaseType := 'Squish';
                  BasePath := Copy (Base, 2, 255);
                End;
      '!'     : Begin
                  BaseType := 'JAM';
                  BasePath := Copy (Base, 2, 255);
                End;
      'P'     : Continue;
    Else
      Begin
        BaseType := 'Fido';
        BasePath := Base;
      End;
    End;

    WriteLn (MsgAreaCtl, '[MsgArea]');
    WriteLn (MsgAreaCtl, 'Name            "' + ExtractWord (2, S, [' ']) + '"');
    WriteLn (MsgAreaCtl, 'UseAddress      ' + Address);
    WriteLn (MsgAreaCtl, 'Origin          "' + Origin + '"');
    WriteLn (MsgAreaCtl, 'BaseType        ' + BaseType);
    WriteLn (MsgAreaCtl, 'BasePath        ' + BasePath); If Board > 0 Then
    WriteLn (MsgAreaCtl, 'BoardNum        ' + Long2Str (Board));
    WriteLn (MsgAreaCtl, 'Scan_PrivMail   ' + Scan);
    WriteLn (MsgAreaCtl, 'Read_Security   ' + rSec);
    WriteLn (MsgAreaCtl, 'Write_Security  ' + wSec);
    WriteLn (MsgAreaCtl, 'SysOp_Security  ' + sSec);
    WriteLn (MsgAreaCtl, 'Group           ' + Group);
    WriteLn (MsgAreaCtl, ';');

  End;

  Close (AreasBBS);
  Close (MsgAreaCtl);
  WriteLn (#13#10' Done.'#13#10);
End.
