UNIT TorMacro;

INTERFACE

CONST
  MaxMacroNameLength = 4;
  MaxMacroStringLength = 80;

TYPE
  PElementOfMacrosTable = ^TElementOfMacrosTable;
  TElementOfMacrosTable = Record
    MacroName   : String [MaxMacroNameLength];
    MacroStr    : String [MaxMacroStringLength];
    NextElement : PElementOfMacrosTable;
  End;

  PMacrosTable = ^TMacrosTable;
  TMacrosTable = Object
    Table : PElementOfMacrosTable;
    Constructor Init(Tabl:PElementOfMacrosTable);
    Procedure Insert(NewMac:PElementOfMacrosTable);
    Procedure Delete(Var DelMac:PElementOfMacrosTable);
    Procedure ReplaceMacro(MName, MStr : String);
    Function Replace(InStr:String):String;
    Destructor Done;
  End;

  Function NewMacroTable(Tabl:PElementOfMacrosTable):PMacrosTable;
  Function NewMacro(MName, MStr:String; NextMac:PElementOfMacrosTable):PElementOfMacrosTable;

IMPLEMENTATION

Uses
  tMisc;

Function NewMacro(MName, MStr:String; NextMac:PElementOfMacrosTable):PElementOfMacrosTable;
Var
  TmpMac : PElementOfMacrosTable;

Begin
  New(TmpMac);
  With TmpMac^ Do
  Begin
    MacroName := UpString (MName);
    MacroStr := MStr;
    NextElement := NextMac;
  End;

  NewMacro := TmpMac;
End;

Function NewMacroTable(Tabl:PElementOfMacrosTable):PMacrosTable;
Begin
  NewMacroTable := New (PMacrosTable, Init (Tabl));
End;

  Constructor TMacrosTable.Init(Tabl:PElementOfMacrosTable);
    Begin
      Table:=Nil;
      If Tabl<>Nil Then Table:=Tabl;
    End;

  Procedure TMacrosTable.Insert(NewMac:PElementOfMacrosTable);
    Var
      TmpMac : PElementOfMacrosTable;
    Begin
      If NewMac = Nil Then Exit;
      If Table = Nil Then
      Begin
        Table := NewMac;
        Exit;
      End;

      TmpMac := Table^. NextElement;

      While TmpMac^. NextElement <> Nil
       Do TmpMac := TmpMac^. NextElement;
      TmpMac^. NextElement := NewMac;
    End;

  Procedure TMacrosTable.Delete(Var DelMac:PElementOfMacrosTable);
    Var
      TmpMac:PElementOfMacrosTable;
    Begin
      If DelMac=Nil Then Exit;
      TmpMac:=Table;
      While TmpMac<>DelMac Do TmpMac:=TmpMac^.NextElement;
      If TmpMac<>Nil Then TmpMac^.NextElement:=DelMac^.NextElement;
      Dispose(DelMac);
    End;

  Procedure TMacrosTable.ReplaceMacro(MName, MStr : String);
    Var
      TmpMac, TmpMac1 :PElementOfMacrosTable;

    Begin
      TmpMac := Table;
      MName := UpString (MName);

      While (TmpMac<>Nil) And (TmpMac^.MacroName<>MName) Do
      Begin
        TmpMac1 := TmpMac;
        TmpMac := TmpMac^. NextElement;
      End;

      If TmpMac=Nil Then
      Begin
        TmpMac := NewMacro (MName, MStr, Nil);
        TmpMac1^. NextElement := TmpMac;
      End Else
        TmpMac^.MacroStr:=MStr;
    End;

Function TMacrosTable.Replace(InStr:String):String;
Var
  TmpMac        : PElementOfMacrosTable;

Begin
  TmpMac := Table;
  While TmpMac <> Nil Do
  Begin
    InStr := PlaceSubStr (InStr, TmpMac^.MacroName, TmpMac^.MacroStr);
    TmpMac := TmpMac^.NextElement;
  End;
End;

Destructor TMacrosTable.Done;
Var
  Tmp1, Tmp2 : PElementOfMacrosTable;
Begin
  Tmp1 := Table;
  While Tmp1 <> Nil Do Begin
    Tmp2:=Tmp1^.NextElement;
    Dispose(Tmp1);
    Tmp1:=Tmp2;
  End;
End;

END.
