Unit
  IBMSO32;

{$OrgName+}

Interface

Uses
  kSockDef,
  OS2Def;

{$CDECL+}
Function accept (SFamily: ULong; SAddr: PSockAddr; SAddrL: PLongInt): ApiRet;
Function bind (SSocket: ULong; SAddr: PSockAddr; SAddrLen: ULong): ApiRet;
Function connect (SSocket: ULong; SAddr: PSockAddr; SAddrLen: ULong): ApiRet;
Function gethostid: ApiRet;
Function getpeername (sSocket: ULong; SAddr: PSockAddr; Var SAddrLen: ULong): ApiRet;
Function getsockname (SSocket: ULong; SName: PSockAddr; Var SLength: ULong): ApiRet;
Function getsockopt (SSocket: ULong; sLevel: LongInt; sOptname: LongInt; sOptVal: PChar; Var sOptLen: LongInt): ApiRet;
Function ioctl (SSocket: ULong; SRequest: LongInt; SArgP: Pointer; SArgSize: ULong): ApiRet;
Function listen (SSocket: ULong; SQueue: ULong): ApiRet;
Function recv (SSocket: ULong; SBuffer: pointer; SLength: ULong; SFlags: ULong): APIRET;
Function recvfrom (SSocket: ULong; SBuffer: pointer; SLength: ULong; SFlags: ULong; SAddr: pSockAddr; sAddrLen: pLongInt): APIRET;
Function select (Sockets: pointer; noreads, nowrites, noexcepts: longint; timeout: longint): ApiRet;
Function send (SSocket: ULong; SBuffer: Pointer; SLength: ULong; SFlags: ULong): APIRET;
Function sendto (sSocket: ULong; sBuffer: pointer; sLength: ULong; sFlags: ULong; sAddr: pSockAddr; sAddrLen: LongInt): APIRET;
Function setsockopt (sSocket: ulong; sLevel: uLong; sOptName: uLong; sOptVal: pointer; sOptLen: uLong): ApiRet;
Function socket (SDomain: ULong; SType: ULong; SProtocol: ULong): APIRET;
Function soclose (SProtocol: ULong): APIRET;
Function so_cancel (SProtocol: ULong): APIRET;
Function soabort (SProtocol: ULong): APIRET;
Function sock_errno: APIRET;
Function recvmsg (sSocked: uLong; sMsgHdr: pMsgHdr; sFlags: LongInt): ApiRet;
Function sendmsg (SSocket: ULong; sMsgHdr: pMsgHdr; SFlags: ULong): APIRET;
Function readv (sSocket: uLong; sIoVec: pIoVec; sLength: uLong): ApiRet;
Function writev (sSocket: uLong; sIoVec: pIoVec; sLength: uLong): ApiRet;
Function shutdown (SSocket: ULong; SFlags: ULong): APIRET;
Function sock_init: APIRET;
Function psock_errno (s: pChar): ApiRet;
Function getinetversion (sVersion: PChar): ApiRet;
{$CDECL-}

Implementation

{$CDECL+}
{$L IBMTCPIP.LIB}

Function accept;          external;
Function bind;            external;
Function connect;         external;
Function gethostid;       external;
Function getpeername;     external;
Function getsockname;     external;
Function getsockopt;      external;
Function ioctl;           external;
Function listen;          external;
Function recvmsg;         external;
Function recv;            external;
Function recvfrom;        external;
Function select;          external;
Function send;            external;
Function sendmsg;         external;
Function sendto;          external;
Function setsockopt;      external;
Function sock_init;       external;
Function sock_errno;      external;
Function psock_errno;     external;
Function socket;          external;
Function soclose;         external;
Function soabort;         external;
Function so_cancel;       external;
Function readv;           external;
Function writev;          external;
Function shutdown;        external;
Function getinetversion;  external;
{$CDECL-}

End.
