{$IFNDEF OS2}
{$F+}
{$ENDIF}
{$I-}

Unit Log;

{*********************************************************}
{*                      LOG.PAS                          *}
{*                                                       *}
{*  Copyright (c) Konstantin Klyagin, 1995-98,           *}
{*                exspecially for Tornado BBS System     *}
{*                                                       *}
{*********************************************************}

Interface

Uses
{$IFNDEF WIN32}
  DOS,
{$ELSE}
  OpCrt,
{$ENDIF}
  tMisc;

Var
  LogName       : PathStr;
  Logging       : Boolean;
  LogEvents     : String [20];
  Int2MonthFunc : Function (n: Byte): String;

Procedure LogOpen (Name, Events, NewStr: String);
Procedure LogWrite (Symb: Char; Event: String);
Procedure LogClose;

Implementation

{$IFDEF WIN32}
{$IFNDEF NOT_TOR}
Uses
  Tor32u;
{$ENDIF}
{$ENDIF}

{$IFNDEF NOT_TOR}
{$I INC\ver.inc}
{$ELSE}
{$I ver.inc}
{$ENDIF}

Var
  LastCall      : LongInt;
  LogNewStr     : String;
  fLog          : Text;

Procedure LogOpen;
Var
  IOR                           : Integer;

Label
  IOError;

Begin
  LogName := Name;
  LogNewStr := NewStr;
  Logging := True;
  If LogName = '' Then Exit;
  LastCall := MidSec;

  Assign (fLog, Name);
  Reset (fLog);
  IOR := IOResult;

  If (IOR <> 0) and (IOR <> 2) Then GoTo IOError;

  If IOR = 2 Then
  Begin
    Rewrite (fLog);
    IOR := IOResult;

    If IOR <> 0 Then
    Begin
      IOError:
      ExitProc := Nil;
      WriteLn ('! Log file open/create error!');
      WriteLn ('!          IO error code: ' + Long2Str (IOR));
      WriteLn;
      Halt (208);
    End;

    WriteLn (fLog, '# ' + Copy (StrDate, 1, 2) + '-' + Int2MonthFunc (Str2Long
            (Copy (StrDate, 4, 2))) + '-' + Copy (StrDate, 9, 2) + ' ' +
            StrTime + NewStr);
  End Else Append (fLog);

  WriteLn (fLog);
  WriteLn (fLog, ' ' + Copy (StrDate, 1, 2) + '-' +
          Int2MonthFunc (Str2Long (Copy (StrDate, 4, 2))) + '-' +
          Copy (StrDate, 9, 2) + ', ' + NameVer);

  LogEvents := Events;
  Close (fLog);
End;

Procedure LogWrite (Symb: Char; Event: String);
Var
  tMS   : LongInt;

Label
  EoP;

Begin
  Event := PlaceSubStr (PlaceSubStr (Event, #13#10, ''), #10#13, '');
{$IFDEF WIN32}
{$IFNDEF NOT_TOR}
  If ((Pos ('&', LogEvents) <> 0) And (Symb = '&')) Or (Symb <> '&') Then
  MainForm. Memo1. Lines. Add (Symb + ' ' + StrTime + ' ' + Event);
{$ENDIF}
{$ENDIF}

  If LogName = '' Then Exit;

  tMS := MidSec;

  If LastCall > tMS Then LogOpen (LogName, LogEvents, LogNewStr);
  LastCall := tMS;

  If Logging Then
  Begin
    Assign (fLog, LogName);
    ReSet (fLog);

    Case IOResult Of
       0 : Begin
             Close (fLog);
             Append (fLog);
           End;
       2 : ReWrite (fLog);
    Else
       Exit;
    End;

    If IOResult <> 0 Then Exit;

    If Pos (Symb, LogEvents) <> 0 Then WriteLn (fLog, Symb + ' ' + StrTime + ' ' + Event);
    Close (fLog);
  End;
End;

Procedure LogClose;
Begin
  Logging := False;
End;

End.