{$I-}
{$IFNDEF OS2}
{$F+,O+}
{$ENDIF}

Unit DoReg;

{*********************************************************}
{*                       DOREG.PAS                       *}
{*                                                       *}
{*  Copyright (c) Konstantin Klyagin, 1995-98,           *}
{*                exspecially for Tornado BBS System     *}
{*                                                       *}
{*********************************************************}

Interface

Uses
  TGlob,
  Users;

Procedure SaveDoReg;
Function GetDoReg (Var User: tUser): Boolean;
Function DoRegExist: Boolean;

Implementation

Uses
  tMisc;

Type
  DoRegRec = Record
    Question    : Byte;
    Date        : LongInt;
    User        : tUser;
  End;

Var
  Fin, Fout     : File Of DoRegRec;
  tDoReg        : DoRegRec;

Function DoRegExist: Boolean;
Begin
  DoRegExist := False;
  If Not Cnf. RegResume Then Exit;

  Assign (Fin, Cnf. Path + 'resreg.tor');
  ReSet (Fin);
  If IOResult <> 0 Then ReWrite (Fin);

  While Not EoF (Fin) Do
  Begin
    Read (Fin, tDoReg);
    If UpString (tDoReg. User. Name) = UpString (R. Name) Then
    Begin
      DoRegExist := True;
      Break;
    End;
  End;

  Close (Fin);
End;

Function GetDoReg (Var User: tUser): Boolean;
Begin
  GetDoReg := False;
  If Not Cnf. RegResume Then Exit;

  Assign (Fin, Cnf. Path + 'resreg.tor');
  ReSet (Fin);
  If IOResult <> 0 Then ReWrite (Fin);

  Assign (Fout, Cnf. TempDir + 'resreg.t$$');
  ReWrite (Fout);

  While Not EoF (Fin) Do
  Begin
    Read (Fin, tDoReg);
    If UpString (tDoReg. User. Name) = UpString (R. Name) Then
    Begin
      User := tDoReg. User;
      RegLet := tDoReg. Question;
      GetDoReg := True;
      Continue;
    End;
    Write (Fout, tDoReg);
  End;

  Close (Fin);
  Close (Fout);
  Erase (Fin);
  tRenameFile (Cnf. TempDir + 'resreg.t$$', Cnf. Path + 'resreg.tor');
End;

Procedure SaveDoReg;
Var
  Written       : Boolean;

Begin
  If (R. Name = '') Or Is_User (R. Name, Cnf. Aliases) Or
     (Not Cnf. RegResume) Or
     (RegLet = 0)
  Then Exit;

  Written := False;
  Assign (Fin, Cnf. Path + 'resreg.tor'); ReSet (Fin);
  Assign (Fout, Cnf. TempDir + 'resreg.t$$'); ReWrite (Fout);

  While Not EoF (Fin) Do
  Begin
    Read (Fin, tDoReg);

    If DateL-tDoReg. Date >= Cnf. DoRegExpire Then Continue;

    If UpString (tDoReg. User. Name) = UpString (R. Name) Then
    Begin
      Written := True;
      tDoReg. User := R;
      tDoReg. Question := RegLet;
      tDoReg. Date := DateL;
    End;

    Write (Fout, tDoReg);
  End;

  If Not Written Then
  Begin
    tDoReg. User := R;
    tDoReg. Question := RegLet;
    tDoReg. Date := DateL;
    Write (Fout, tDoReg);
  End;

  Close (Fout);
  Close (Fin);
  Erase (Fin);
  tRenameFile (Cnf. TempDir + 'resreg.t$$', Cnf. Path + 'resreg.tor');
End;

End.