Unit
  Crc32;

Interface

Const
  Crc32Table : Array [0..255] Of LongInt = (
  $00000000, $77073096, $ee0e612c, $990951ba, $076dc419, $706af48f, $e963a535,
  $9e6495a3, $0edb8832, $79dcb8a4, $e0D5e91e, $97D2D988, $09b64c2b, $7eb17cbd,
  $e7b82D07, $90bf1D91, $1db71064, $6ab020f2, $f3b97148, $84be41de, $1adad47D,
  $6ddde4eb, $f4D4b551, $83D385c7, $136c9856, $646ba8c0, $fd62f97a, $8a65c9ec,
  $14015c4f, $63066cd9, $fa0f3D63, $8D080df5, $3b6e20c8, $4c69105e, $D56041e4,
  $a2677172, $3c03e4D1, $4b04D447, $D20D85fd, $a50ab56b, $35b5a8fa, $42b2986c,
  $dbbbc9D6, $acbcf940, $32D86ce3, $45df5c75, $dcd60dcf, $abd13D59, $26D930ac,
  $51de003a, $c8D75180, $bfd06116, $21b4f4b5, $56b3c423, $cfba9599, $b8bda50f,
  $2802b89e, $5f058808, $c60cd9b2, $b10be924, $2f6f7c87, $58684c11, $c1611dab,
  $b6662D3D, $76dc4190, $01db7106, $98D220bc, $efd5102a, $71b18589, $06b6b51f,
  $9fbfe4a5, $e8b8D433, $7807c9a2, $0f00f934, $9609a88e, $e10e9818, $7f6a0dbb,
  $086D3D2D, $91646c97, $e6635c01, $6b6b51f4, $1c6c6162, $856530D8, $f262004e,
  $6c0695ed, $1b01a57b, $8208f4c1, $f50fc457, $65b0D9c6, $12b7e950, $8bbeb8ea,
  $fcb9887c, $62dd1ddf, $15da2D49, $8cd37cf3, $fbd44c65, $4db26158, $3ab551ce,
  $a3bc0074, $D4bb30e2, $4adfa541, $3dd895D7, $a4D1c46D, $D3D6f4fb, $4369e96a,
  $346ed9fc, $ad678846, $da60b8D0, $44042D73, $33031de5, $aa0a4c5f, $dd0D7cc9,
  $5005713c, $270241aa, $be0b1010, $c90c2086, $5768b525, $206f85b3, $b966D409,
  $ce61e49f, $5edef90e, $29D9c998, $b0D09822, $c7D7a8b4, $59b33D17, $2eb40D81,
  $b7bd5c3b, $c0ba6cad, $edb88320, $9abfb3b6, $03b6e20c, $74b1D29a, $ead54739,
  $9dd277af, $04db2615, $73dc1683, $e3630b12, $94643b84, $0D6D6a3e, $7a6a5aa8,
  $e40ecf0b, $9309ff9D, $0a00ae27, $7D079eb1, $f00f9344, $8708a3D2, $1e01f268,
  $6906c2fe, $f762575D, $806567cb, $196c3671, $6e6b06e7, $fed41b76, $89D32be0,
  $10da7a5a, $67dd4acc, $f9b9df6f, $8ebeeff9, $17b7be43, $60b08ed5, $D6D6a3e8,
  $a1D1937e, $38D8c2c4, $4fdff252, $D1bb67f1, $a6bc5767, $3fb506dd, $48b2364b,
  $D80D2bda, $af0a1b4c, $36034af6, $41047a60, $df60efc3, $a867df55, $316e8eef,
  $4669be79, $cb61b38c, $bc66831a, $256fd2a0, $5268e236, $cc0c7795, $bb0b4703,
  $220216b9, $5505262f, $c5ba3bbe, $b2bd0b28, $2bb45a92, $5cb36a04, $c2D7ffa7,
  $b5D0cf31, $2cd99e8b, $5bdeae1D, $9b64c2b0, $ec63f226, $756aa39c, $026D930a,
  $9c0906a9, $eb0e363f, $72076785, $05005713, $95bf4a82, $e2b87a14, $7bb12bae,
  $0cb61b38, $92D28e9b, $e5D5be0D, $7cdcefb7, $0bdbdf21, $86D3D2D4, $f1D4e242,
  $68ddb3f8, $1fda836e, $81be16cd, $f6b9265b, $6fb077e1, $18b74777, $88085ae6,
  $ff0f6a70, $66063bca, $11010b5c, $8f659eff, $f862ae69, $616bffd3, $166ccf45,
  $a00ae278, $D70dd2ee, $4e048354, $3903b3c2, $a7672661, $D06016f7, $4969474D,
  $3e6e77db, $aed16a4a, $D9D65adc, $40df0b66, $37D83bf0, $a9bcae53, $debb9ec5,
  $47b2cf7f, $30b5ffe9, $bdbdf21c, $cabac28a, $53b39330, $24b4a3a6, $bad03605,
  $cdd70693, $54de5729, $23D967bf, $b3667a2e, $c4614ab8, $5D681b02, $2a6f2b94,
  $b40bbe37, $c30c8ea1, $5a05df1b, $2D02ef8D
  );

Function UpdateCrc32 (CurByte : Byte; CurCrc : LongInt) : LongInt;
{$IFDEF MSDOS}
Inline(
 { Fixed 02.11.95 }
                         {;Get args -- DX:BX = CurCrc, CX = CurByte;}
  $5B/                   {        POP     BX}
  $5A/                   {        POP     DX}
  $59/                   {        POP     CX}
  $52/                   {        PUSH    DX}
  $53/                   {        PUSH    BX      ;Save original CurCrc}
                         {;ES:AX := Get Crc32Table[CurCrc xor CurByte];}
  $31/$CB/               {        XOR     BX,CX   ;DX:BX = CurCrc xor CurByte}
  $30/$FF/               {        XOR     BH,BH   ;Byte(DX:BX)}
  $D1/$E3/               {        SHL     BX,1    ;LongInt index}
  $D1/$E3/               {        SHL     BX,1}
  $C4/$87/>CRC32TABLE/   {        LES     AX,>Crc32Table[BX]}
                         {;DX:BX := (CurCrc shr 8) and $00FFFFFF;}
  $5B/                   {        POP     BX      ;Get original CurCrc}
  $5A/                   {        POP     DX}
  $B9/$08/$00/           {        MOV     CX,8    ;Shift 8 bits}
  $D1/$EA/               {C1:     SHR     DX,1    ;Hi reg into carry}
  $D1/$DB/               {        RCR     BX,1    ;Carry into lo reg}
  $E2/$FA/               {        LOOP    C1      ; for 8 bits}
  $81/$E2/$FF/$00/       {        AND     DX,$00FF}
                         {;DX:AX := ES:AX xor DX:BX (sets function result)}
  $31/$D8/               {        XOR     AX,BX}
  $8C/$C3/               {        MOV     BX,ES}
  $31/$DA);              {        XOR     DX,BX}
{$ENDIF}

Implementation

{$IFNDEF MSDOS}
Function UpdateCrc32 (CurByte : Byte; CurCrc : LongInt) : LongInt;
Begin
  UpdateCrc32 := Crc32Table[Byte(CurCrc xor LongInt(CurByte))] xor
                 ((CurCrc shr 8) and $00FFFFFF);
End;
{$ENDIF}

End.