{$I-,S-}
{$IFNDEF OS2}
{$R-,V-,B-,F+,O+,A-}
{$ENDIF}

{Conditional defines that may affect this unit}
{$I APDEFINE.INC}

{*********************************************************}
{*                    APPORT.PAS 2.03                    *}
{*     Copyright (c) TurboPower Software 1991.           *}
{* Portions copyright (c) Information Technology 1989,   *}
{*    and used under license to TurboPower Software      *}
{*                 All rights reserved.                  *}
{*********************************************************}

Unit ApPort;
  {-Defines an abstract port data block and some common procedures}

Interface

Uses
{$IFNDEF OS2}
  ApMisc,
{$ELSE}
  ApOS2,
{$ENDIF}

{$IFNDEF WIN32}
  DOS,
{$ENDIF}
  ApSame;

{$I APPORT.PA0}

Implementation

Var
  PortExitSave : Pointer;

(*
Function IsPS2 : Boolean;
  {-Returns True if the current machine is a PS/2}
Type
  OS = Record
         O : Word;
         S : Word;
       End;
  MachineID = Record
                Length   : Word;
                Model    : Byte;
                SubModel : Byte;
              End;
Var
  ID : ^MachineID;
  Regs : Registers;
  Model : ^Byte;

Begin
  IsPS2 := False;
  Model := Ptr (BiosSele, $FFFE);

  {Exit if machine is pre-AT}
  If Model^ > $FC Then
    Exit;

  {Get the location of the System Config Table}
  With Regs Do Begin
    AX := $C000;

    {Initialize ES:BX to nil}
    ES := 0;
    BX := 0;

    Intr ($15, Regs);

    {Exit if carry set or ES:BX didn't change}
    If ( (ES = 0) And (BX = 0) ) Or Odd (Flags) Then
      Exit;

    OS (ID).S := ES;
    OS (ID).O := BX;
  End;

  {ID points to system config table}
  With ID^ Do Begin
    {Check for BIOS's that set the high order submodel bit}
    If (SubModel And $80) = $80 Then
      Exit;
    {Check for PS/2s}
    If (Model < $FC) Or
       ( (Model = $FC) And (SubModel > $03) )
    Then
      IsPS2 := True;
  End;
End;

*)

Function ComNameString (ComName : ComNameType) : String;
  {-Returns a displayable comport name string}
Var
  S : String [3];
Begin
  Str (Ord (ComName) + 1, S);
  ComNameString := 'COM' + S;
End;

Function CheckForString (Var Index : Byte; C : Char;
                        S : String; IgnoreCase : Boolean) : Boolean;
  {-Checks for string S on consecutive calls, returns True when found}
Begin
  CheckForString := False;
  Inc (Index);

  {Upcase both data if ignoring case}
  If IgnoreCase Then Begin
    C := UpCase (C);
    S [Index] := UpCase (S [Index] );
  End;

  {Compare...}
  If C = S [Index] Then
    {Got match, was it complete?}
    If Index = Length (S) Then Begin
      Index := 0;
      CheckForString := True;
    End
  Else
  Else
    {No match, reset Index}
    If C = UpCase (S [1] ) Then
      Index := 1
    Else
      Index := 0;
End;

Procedure RotateIrqPriority (Irq : Byte);
  {-Rotate priorities to give Irq the highest priority at the PIC}
Var
  OCW2 : Byte;

Procedure RotatePrim (PortAddr : Byte; I : Byte);
  Begin
    If I = 0 Then
      I := 7
    Else
      Dec (I);
    OCW2 := $C0 + I;
    Port [PortAddr] := OCW2;
  End;

Begin
  If (Irq >= 8) And (Irq <= $F) Then
    {Alter slave}
    RotatePrim ($A0, Irq - 8)
  Else If (Irq >= 0) And (Irq <= 7) Then
    {Alter master}
    RotatePrim ($20, Irq)
End;

Procedure PortExitProc;
  {-Exit procedure to close any open com ports}
Var
  I : Byte;
Begin
  ExitProc := PortExitSave;
  For I := 1 To MaxActivePort Do
    If ActiveComPort [I] <> Nil Then
      ActiveComPort [I]^. DoneProc (ActiveComPort [I] );
End;

Var
  I : Integer;
Begin
  {Init all ports as available}
  For I := 1 To MaxActivePort Do
    ActiveComPort [I] := Nil;

  PortExitSave := ExitProc;
  ExitProc := @PortExitProc;
End.
