unit setup1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, InstGlob, StdCtrls, ExtCtrls, tMisc, ConfUpd, Mask, ToolEdit;

type
  TForm1 = class(TForm)
    GroupBox1: TGroupBox;
    Label1: TLabel;
    langDoc: TComboBox;
    Label2: TLabel;
    langProg: TComboBox;
    Label3: TLabel;
    langUser: TComboBox;
    GroupBox2: TGroupBox;
    Label4: TLabel;
    Label5: TLabel;
    Panel1: TPanel;
    Label6: TLabel;
    Button1: TButton;
    Button2: TButton;
    GroupBox3: TGroupBox;
    InstallNew: TRadioButton;
    Upgrade: TRadioButton;
    InstFrom: TDirectoryEdit;
    InstTo: TDirectoryEdit;
    procedure Button2Click(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure InstallNewClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

uses progress;

{$R *.DFM}

procedure TForm1.Button2Click(Sender: TObject);
begin
  Close;
end;

procedure TForm1.FormShow(Sender: TObject);
Var
  S : String;

begin
  langDoc. ItemIndex := 0;
  langProg. ItemIndex := 0;
  langUser. ItemIndex := 3;
  GetDir (0, S);
  InstFrom. Text := S;
end;

procedure TForm1.Button1Click(Sender: TObject);
Var
  Code : Integer;
  Srec : TSearchRec;
  Free : LongInt;

begin
  iPath := InstTo. Text;
  InstDir := InstFrom. Text;
  InstGlob. Upgrade := Upgrade. Checked;
  If langDoc. ItemIndex = 0 Then DocLang := lEnglish Else DocLang := lRussian;

  Case langProg. ItemIndex Of
    0 : IntfLang := lEnglish;
    1 : IntfLang := lRussian;
    2 : IntfLang := lGerman;
  End;

  Language := EnglishLang;

  If (iPath [Length (iPath)] = '\') And (Length (iPath) > 3) Then iPath [0] := Chr (Length (iPath)-1);
  If iPath = '' Then Exit;

  If InstGlob. Upgrade Then VerInstalled := DetectVer (iPath);

  If (Not FileExists (AddBackSlash (InstDir) + 'tbase.zip')) Or
     (Not FileExists (AddBackSlash (InstDir) + 'tctl.zip')) Or
     (Not FileExists (AddBackSlash (InstDir) + 'tdoc.zip')) Or
     (Not FileExists (AddBackSlash (InstDir) + 'tmisc.zip')) Then
  Begin
    ShowMessage (PlaceSubStr (Language [InstNotFound], '|', ''));
    Exit;
  End;

  If Not DirExists (iPath) Then
  Begin
    MkDir (iPath);
    If IOResult <> 0 Then
    Begin
      ShowMessage (PlaceSubStr (Language [InvalidPath], '|', ''));
      Exit;
    End;
  End;

  ChDir (iPath);
  Free := DiskFree (0);
  If Free < 0 Then Free := 2147483647;
  If Free < SpaceNeed Then
  Begin
    ShowMessage (PlaceSubStr (Language [DiskSpace] +
    Long2Str (SpaceNeed) + Language [BytesNeed], '|', ''));
    Exit;
  End;

  Case langUser. ItemIndex Of
    0 : Begin
          lngEnglish := True;
          lngRussian := False;
          lngGerman := False;
        End;
    1 : Begin
          lngEnglish := False;
          lngRussian := True;
          lngGerman := False;
        End;
    2 : Begin
          lngEnglish := False;
          lngRussian := False;
          lngGerman := True;
        End;
    3 : Begin
          lngEnglish := True;
          lngRussian := True;
          lngGerman := True;
        End;
    4 : Begin
          lngEnglish := True;
          lngRussian := True;
          lngGerman := False;
        End;
    5 : Begin
          lngEnglish := True;
          lngRussian := False;
          lngGerman := True;
        End;
    6 : Begin
          lngEnglish := False;
          lngRussian := True;
          lngGerman := True;
        End;
  End;

  Visible := False;

  If Go. ShowModal = mrCancel Then
  Begin
    ShowMessage ('Installation aborted.');

    Code := FindFirst (TempDir + '\*.*', faAnyFile-faVolumeID-faDirectory, Srec);
    While Code = 0 Do
    Begin
      DeleteFile (TempDir + '\' + Srec. Name);
      Code := FindNext (Srec);
    End;
    FindClose (Srec);

    RmDir (TempDir);
  End;

  Close;
end;

procedure TForm1.InstallNewClick(Sender: TObject);
begin
  Label3. Enabled := InstallNew. Checked;
  langUser. Enabled := InstallNew. Checked;
end;

end.
