unit progress;

interface

uses
  OpCrt, InstGlob, Controls, StdCtrls, Classes, Gauges,
  Forms, Windows, ZipMstr, SysUtils, tMisc, ConfUpd;

type
  TGo = class(TForm)
    ProgBar: TGauge;
    Label1: TLabel;
    Label2: TLabel;
    Archive: TLabel;
    FileName: TLabel;
    Zipper: TZipMaster;
    Memo1: TMemo;
    GroupBox1: TGroupBox;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    SysOp: TEdit;
    BBSname: TEdit;
    Location: TEdit;
    GroupBox2: TGroupBox;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    ComPort: TComboBox;
    Baud: TComboBox;
    InitString: TEdit;
    AnswerString: TEdit;
    Button1: TButton;
    procedure FormShow(Sender: TObject);
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Go: TGo;
  TempDir : String;
  S1, S2 : PChar;

implementation

{$R *.DFM}

Procedure TorExtract (FName: PathStr);
Var
  Code : Integer;
  Srec : TSearchRec;
  ResName : PathStr;
  S : String;
  FilesCount, CurFile : LongInt;

Begin
  Go. Archive. Caption := FName;
  GetDir (0, S);
  Go. Zipper. FSpecArgs. Clear;

  Case State Of
    Menus    : Go. Zipper. FSpecArgs. Add ('*.mn' + LangIndex [CurrentL]);
    TxtFiles : Begin
                 Go. Zipper. FSpecArgs. Add ('*.a?' + LangIndex [CurrentL]);
                 Go. Zipper. FSpecArgs. Add ('*.tr' + LangIndex [CurrentL]);
               End;
    Ctls     : Go. Zipper. FSpecArgs. Add ('*.ct' + LangIndex [CurrentL]);
    Logos    : Go. Zipper. FSpecArgs. Add ('logo.*');
  Else
    Go. Zipper. FSpecArgs. Add ('*.*');
  End;

  Go. Zipper. ZipFileName := AddBackSlash (InstDir) + FName;
  Go. Zipper. ExtrBaseDir := TempDir;
  Go. Memo1. Lines. Add ('Unpacking ' + FName + ' ...');
  Application. ProcessMessages;
  Go. Zipper. Extract;
  FilesCount := 0;
  CurFile := 0;
  Go. ProgBar. Progress := 0;

  Code := FindFirst (TempDir + '\*.*', faAnyFile-faVolumeID-faDirectory, Srec);
  While Code = 0 Do
  Begin
    Inc (FilesCount);
    Code := FindNext (Srec);
  End;
  FindClose (Srec);

  Code := FindFirst (TempDir + '\*.*', faAnyFile-faVolumeID-faDirectory, Srec);

  While Code = 0 Do
  Begin
    Inc (CurFile);
    ResName := Srec. Name;
    Go. ProgBar. Progress := Trunc (CurFile/(FilesCount/100));

    If OkFile (ResName) Then
    Begin
      StrPCopy (S1, AddBackSlash (TempDir) + Srec. Name);
      StrPCopy (S2, AddBackSlash (S) + ResName);
      Go. FileName. Caption := ResName;
      Go. Memo1. Lines. Add (S2);
      Application. ProcessMessages;
      CopyFile (S1, S2, False);
    End;

    DeleteFile (AddBackSlash (TempDir) + Srec. Name);
    Code := FindNext (Srec);
  End;

  FindClose (Srec);
  Application. ProcessMessages;
End;

procedure TGo.FormShow(Sender: TObject);
Const
  Done : Boolean = False;

begin
  If Done Then Exit;
  Done := True;
  Height := 176;

  TempDir := InstDir + '\TMP' + TempFName;
  MkDir (TempDir);
  Zipper. Load_Unz_Dll;

  UnPackFiles (TorExtract);

  RmDir (TempDir);
  Zipper. UnLoad_Unz_Dll;

  Memo1. Lines. Add ('Unpack finished.');
  ActiveControl := SysOp;

  If Not InstGlob. Upgrade Then
  Begin
    ComPort. ItemIndex := 1;
    Baud. ItemIndex := 4;
    Top := Top-Trunc ((358-Height)/2);
    Height := 358;
    ProgBar. Progress := 0;
  End Else
  Begin
    Top := Top-Trunc ((210-Height)/2);
    Height := 210;
    Button1. Top := 152;
    GroupBox1. Width := 0;
    GroupBox2. Width := 0;
    ChDir (iPath);
    Memo1. Lines. Add ('Updating CTL files ...');
    UpdateConfigFiles ('tornado.upd', VerInstalled);
    DeleteFile ('tornado.upd');
    ChDir (InstDir);
  End;
end;

Procedure Status;
Begin
  Go. ProgBar. Progress := Go. ProgBar. Progress + 10;
  Application. ProcessMessages;
End;

procedure TGo.Button1Click(Sender: TObject);
begin
  If Not InstGlob. Upgrade Then
  Begin
    Zipper. Destroy;
    StVal. SysOp := SysOp. Text;
    StVal. Location := Location. Text;
    StVal. BBSname := BBSname. Text;
    StVal. AnswerString := AnswerString. Text;
    StVal. InitString := InitString. Text;
    StVal. ComPort := ComPort. Text [4];
    StVal. BaudRate := Str2Long (Baud. Text);

    Archive. Caption := '';
    FileName. Caption := '';
    Label2. Caption := '';
    Label1. Caption := 'Updating CTL files ...';
    Memo1. Lines. Add ('Updating CTL files ...');

    Button1. Enabled := False;
    ProgBar. Progress := 0;
    Application. ProcessMessages;
    UpdConfigs (Status);
    ProgBar. Progress := 100;
    Memo1. Lines. Add ('Installation completed.');
    Memo1. Lines. Add ('Have a nice BBSing with Tornado!');
  End;

  ModalResult := mrOk;
end;

initialization

  GetMem (S1, 256);
  GetMem (S2, 256);

finalization

  FreeMem (S1, 256);
  FreeMem (S2, 256);

end.