; This is the simple Tornado main configuration file.
;
; ATTENTION! This file contains example of configuration only and it can
; be used as a manual, but not as a working config file. So before you
; start Tornado make sure that all the parameters are set up properly.
; 
;
;   Before we start I'll tell you about the main structure of this file.
; However, all this rules are related to all other Tornado configuration
; files.
;
;   So, the file is divided into three parts. Each part contains
; configuration parameters, grouped into the sections. Each section begins
; with the line that contains the name of this section:
;
; [Section_Name]
;
; where "[" and "]" points to the section beginning and "Secti-
; on_Name"  the name of the section itself.
;
;   The following lines, up to the next section, contain variables.
; Each section contains its own set of variables that it must contain.
; If the section contains wrong variable then error message is displayed.
; The order of the sections and the variables in the section is not
; important, so don't care about it.
;
; In general view the way of setting up variable is as shown below:
;
; {1,2,3-5}  Variable_Name  Parameter
;     
;                            The value of a variable
;             
;              The name of a variable
;     
;      BBS line numbers, that will
;                             use this variable.
;
;   Let's talk a bit about the first variable. When you are working in the
;   multiline mode some variables must have different values. For example
;   variable Port, so that different lines use different ports. This feature
;   will allow you to have the configuration of all lines in one config-file.
;
;   Example:
;     {1} BBSname  Tornado Testing BBS line #1
;     {2} BBSname  Tornado Testing BBS line #2
;     {3} BBSname  Tornado Testing BBS line #3
;     {4} BBSname  Tornado Testing BBS line #4
;
;
;   The first variable field is optional. In this case Tornado will under-
;   stand that this parameter is related to all lines of BBS. You will be
;   able to find out a bit more about working in multiline mode if you read
;   the documentation.
; 
;   One can use system environment variables in the variables, for example:
;
;                           LNG_Path %TORNADO%\LNGS\
;
; 
;   You can also use the directive #define.
;
;
;   Directive #define is used to define macrosubstitutions. The structure
;   of #define is:
;
;    #define <substring> <string>
;
;   All the substrings <substring> in the configuration file will be
;   replaced with the string <string>.
;
;
; Example:
;
; #define (Tor_Path)  D:\FIDO\TORNADO
;  
; LogFile (Tor_Path)\LOG\tornado.log
;         ^^^^^^^^^^^^^^^^^^^^^^^^^^
;                   will be replaced with D:\FIDO\TORNADO\LOG\tornado.log
; 
;
[System]
;
;    System's main parameters.
;
SysOp Beta Tester                   ; SysOp's Name
;
BBSname Beta Testing BBS            ; BBS name
;
Location Beta Testing Area          ; BBS Location
;
Path C:\TORNADO                     ; System path of Tornado
;
Private No                          ; "Private BBS" mode.
                                    ; The registration of new users is
                                    ; permitted, so you have to input the
                                    ; names of people who can access your
                                    ; BBS manually in the user editor.
;
Overlay_XMS   Yes                   ; Allows overlay loading in XMS
                                    ; Default is (No)
;
Overlay_EMS   Yes                   ; Allows overlay loading in EMS
                                    ; Default is (No)
;
Date_Mask DD-MM-YY                  ; Date format
;
Answer 00:00-24:00                  ; Time periods when Tornado will answer
                                    ; incoming calls
;
[Modem]
;
;    Modem parameters section
;
Port 2                              ; COM-port number, for OS/2 version may
                                    ; contain the name of device.
;
Layer Fossil                        ; With the aid of what I/O device
                                    ; we will perform the work with the port.
                                    ; Available meanings:
                                    ; Fossil (default), Uart, Int14,
                                    ; Digi14. For OS/2 version the value
                                    ; of this parameter doesn't have any
                                    ; meaning, because it is always "fossil".
;
;Port_Address 2f8 ; Port Address  Optional parameters. Uses when
 ;;                                       port has unstandart parameters
;IRQ 3            ; IRQ Number Ĵ  Have meaning only when Layer is
;;                                        set to UART and for DOS version.
;Com_Vector 11   ; COM Interrupt Vector 
;
;
HardWare_Flow  Yes                  ; Is modem set to RTS/CTS flow control
                                    ; (default Yes)
;
SoftWare_Flow  Yes                  ; Is modem set to XON/XOFF flow control
                                    ; (default Yes)
;
BaudRate 19200                      ; Modem speed
;
InitString ATZ|                     ; Modem initialization string
;
Init_Tryes 3                        ; Max tries to initialize modem
;
AnswerString ATA|                   ; Answer string
;
OffHookString   ATH1|               ; Off-hook string
;
Modem_Connect    CONNECT            ; String coming from a modem in case of
                                    ; successful handshake
;
Modem_Ring       RING               ; String coming from a modem in case of
                                    ; incoming ring
;
Modem_NoCarrier  NO CARRIER         ; String coming from a modem in case of
                                    ; handshake failure
;
Modem_Ok         OK                 ; String coming from a modem in case of
                                    ; succesful initialization
;
DataBits   8                        ; Data Bits
;
StopBits   1                        ; Stop Bits
;
Parity   None                       ; Port Parity
;
HangupString ATH0|                  ; Hangup string
;
Rings   1                           ; Number of rings before picking
                                    ; up the phone
;
Carrier_Lost_Delay  3               ; Time of ignorance of DCD-signal absense
                                    ; in seconds.
;
Min_Speed  2400                     ; Minimal Speed for working with BBS.
                                    ; In case of entering on slower speed
                                    ; file tooslow.a?? is shown and Tornado
                                    ; will hangup.
;
[Files&Dirs]
;
;    Files And Directories
;
LogFile   tornado.log               ; Log-file name. If the name is not
                                    ; mentioned, log-file won't be created.
;
Chat_Log chat.log                   ; The name of a chat-log file
;
TRC_Log  trc.log                     ; Log file name to store TRC (Tornado
                                     ; Relay Chat) input into.
;
TempDir C:\                         ; Temp files directory.
;
FlagsDir C:\TMP                     ; Flags directory.
;
DoorInfoDir C:\TMP                  ; Directory where on calling external
                                    ; programs EXITINGO.BBS and DORINFO.BBS
                                    ; files will be created.
;
Logo   TXTFILE\logo                 ; Name of logo-file without extention
                                    ; (Extension depends on current terminal
                                    ; emulation)
;
Save_Tag_Path   USERTAG\            ; Directory for .lst files
                                    ; in which list of users' tagged files
                                    ; are stored.
                                    ; Have meaning only when parameter
                                    ; [Miscellaneous]->Save_Tag_List is set
                                    ; to Yes.
;
Priv_Uploads_Dir  USERTAG\          ; Directory for private uploads.
;
;LNG_Path  C:\TORNADO               ; Path to language definition (.LNG) files.
;
MsgAreas_File msgarea.ctl           ; Name of Message Areas description file
;
FileAreas_File filearea.ctl         ; Name of File Areas description file
;
;MsgGroups_File mgroups.ctl         ; Name of Message Groups description file
;
;FileGroups_File fgroups.ctl        ; Name of File Groups description file
;
Limits_File limits.ctl              ; Name of Users' Limits description-file
;
DoorWay_CTL doorway.ctl             ; Name of configuration file of built-in
                                    ; DoorWay
;
Upgrader_CTL upgrader.ctl           ; Name of configuration file of built-in
                                    ; Upgrade Manager
;
Protocol_CTL  protocol.ctl          ; Name of configuration file of built-in
                                    ; and external protocols
;
Default_LangFile english.lng        ; Name of Default Language
                                    ; description-file
;
VIP_List vip.ctl                    ; Very important persons list - a list
                                    ; of persons, on whose entering Tornado
                                    ; informs SysOp (default - not set)
;
GoodUsers_List gooduser.ctl         ; Good  users  list - users  who  access
                                    ; a special  security  level during  the
                                    ; registration. This level is defined by
                                    ; [NewUsers]->Good_Security parameter.
;
BadUsers_List baduser.ctl           ; Bad users list - users on whose
                                    ; entering Tornado will show baduser.a??
                                    ; file and hangup is followed.
;
BadPasswords_List badpwds.ctl       ; Bad paswords list  -  list  of  the
                                    ; words  which are prohibited  to  be
                                    ; used as passwords
;
SuxxUsers_List suxx.ctl             ; Suxx users list - bad  users  list. If
                                    ; one is online Tornado sometimes emula-
                                    ; tes line disturbances  and  can  break
                                    ; the session.
;
[NewUsers]
;
; New Users Config
;
Security  1                         ; Nuber of access level (from limits.ctl),
                                    ; set to user when he/she access BBS
                                    ; for the first time. After a space
                                    ; you can put flags se ti user by
                                    ; default
;
Register_Time 10                    ; Time given to user for registration
;
Reg_Resume Yes                      ; If we should continue the registration
                                    ; after the loss of carrier during the
                                    ; registration
;
CapitalizeNames Yes                 ; If Tornado will capitalize usernames
                                    ; automatically on logon
;
Fast_Logon No                       ; If you are running in a local mode
                                    ; Tornado will allow you to go
                                    ; directly to main menu
;
Show_News  Yes                      ; Show news to user at enter
                                    ; Can be set to:
                                    ; Yes   : show all news;
                                    ; Last  : show only recent news (came
                                    ;         after the user's last session
                                    ; No    : show none.
;
ANSI  Ask                           ; ANSI using (Yes, No, Ask)
;
More  Ask                           ; Pause after each screen page
                                    ; (Yes, No, Ask)
;
Hot_Keys  Ask                       ; Hotkeys using (Yes, No, Ask)
;
Frames   Ask                        ; "Frames" user interface
                                    ; (Yes, No, Ask)
;
Data_Phone  Yes                     ; If Tornado will ask for a office/
                                    ; data phone (Yes/No)?
;
Voice_Phone  Yes                    ; If Tornado will ask for a home
                                    ; voice phone (Yes/No)?
;
One_word_names No                   ; If Tornado will accept one word
                                    ; names (Yes/No) ?
;
Birthdate Yes                       ; If Tornado will ask for a birthday
                                    ; of the user (Yes/No) ?
;
IEMSI_Enable Yes                    ; Allows to use IEMSI protocol on
                                    ; entering, default - Yes
FS_Editor      Ask                  ; Full-screen editor using (Yes, No, Ask)
;
Address   Yes                       ; If Tornado will ask for a
                                    ; net addresses (Yes/No)?
;
Organization Yes                    ; If Tornado will ask for a place of
                                    ; user's work (Yes/No)?
;
Scan_NewFiles   Ask                 ; If Tornado will search for new files
                                    ; Yes - Always, No - Never, Ask - Ask
;
Scan_PrivMail  Ask                  ; If Tornado will search for messages
                                    ; addressed to a user on each entering
                                    ; Yes - Always, No - Never, Ask - Ask
;
Aliases    Yes                      ; If we will accept aliases
;
Good_Security  4                    ; Access level set to user who is in
                                    ; GoodUsers_List.
;
Display_Lines 24                    ; Default display lines number
;
Display_Lines_Ask Yes               ; Ask at registration of new user the
                                    ; desired number of lines to display,
                                    ; of assume the default value specified
                                    ; by Display_Lines parameter (Yes/No)
;
Location Yes                        ; Ask at registration of new user the
                                    ; geographic location of the new user
                                    ; (Yes/No)
;
Accept_Registration Yes             ; Ask user to confirm finishing regis-
                                    ; tration process
;
Ask_Alias  Yes                      ; Ask new user for alias at registra-
                                    ; tion.
;
[Miscellaneous]
;
;    Miscellaneous features
;
CDTime   20                         ; Time to wait for a DCD-signal after
                                    ; picking up the phone
;
PassTryes   3                       ; Max tries to enter the password
;
Inactive_Time   400                 ; Time (sec.) of "inactive user"
                                    ; i.e. user do nothing half of this
                                    ; time, Tornado will warn him, and
                                    ; when the second part of this time is
                                    ; wasted Tornado will hang-up
;
CRInMenu   Yes                      ; If Tornado will redraw the screen
                                    ; after <Enter> or a key not used in
                                    ; active menu
;
MainMenu main                       ; The name of main menu file. It is
                                    ; searched in the directory, the name of
                                    ; which is set by [Files]->Menus
                                    ; parameter in current .LNG file.
                                    ; (depends on language selection)
;
AutoAnsi Detect                     ; Yes    - Set ANSI terminal emulation
                                    ;          automatically
                                    ; No     - Set TTY terminal emulation
                                    ;          automatically
                                    ; Detect - Detect the mode of remote
                                    ;          terminal
;
LogEvents ~:!+*%                    ; Events, to put them to LOG file
                                    ; 
                                    ; Events might be:
                                    ;
                                    ; ~ - Registration
                                    ; : - Local events messages
                                    ; ! - Errors and important messages
                                    ; + - Normal events
                                    ; * - Receivig/sending files
                                    ; % - Executing scripts
                                    ; & - Debug messages
                                    ;
;
Effects Yes                         ; Visual effects (zooming windows, etc.)
;
Sound Yes                           ; Sound effects
;
Abort_Key Esc                       ; User "abort action" key
                                    ; (file view/new files search/
                                    ; mail search etc):
                                    ;
                                    ; Esc  - Abort on Esc pressing Esc
                                    ;
                                    ; Any  - Abort on any key pressing
                                    ;
                                    ; None - User cannot abort actions
;
Password_Length 3                   ; Minimal password length
;
Show_Secured Yes                    ; If Tornado will show to a user secured
                                    ; menu points
;
AskChatTopic Yes                    ; If Tornado will ask for a chat topic
                                    ; before start it
;
Page_Time 00:00-24:00               ; Time intervals when SysOp is
                                    ; available for chat
;
Page_Duration 30                    ; SysOp paging duration
;
To_SysOp_Area 1                     ; Mail area, that will contain letters
                                    ; addressed to SysOp
;
Chat_Time_Suspend Yes               ; If Tornado will suspend user's time
                                    ; during the chat with SysOp
;
Save_Tag_List   Yes                 ; If Tornado will save the list of files
                                    ; tagged for downloading before quit
                                    ; (default Yes)
;
Txt_More_Disable   Yes              ; If Tornado will disable a pause after
                                    ; each screen page on showing text files
                                    ; (asc/ans/avt/...)
;
Local_OffHook  No                   ; If your modem will be Off-Hook when
                                    ; you are in a local mode
;
Hide_SysOp  Yes                     ; If this parameter is set to Yes, then
                                    ; Tornado will hide SysOp's name in the
                                    ; userlist
;
ResReg_Expire   5                   ; Number of days, when Tornado will
                                    ; erase the registration file of users,
                                    ; who didn't pass the registration
;
News_Pause_Ask Yes                  ; Ask user does he wants to view next
                                    ; news
;
Emu_Allow   Ansi, Avatar, Tty       ; Available terminal emulation protocols
;
Clock   Yes                         ; Clock in the upper right corner
                                    ; of screen
;
One_Column_Menus    Yes             ; Whether to display menues as one-column
                                    ; (Yes) or two-column (No) list
;
Status_Bar  Yes                     ; If status bar will appear on the
                                    ; screen when Tornado is starting
;
Ignore_Old_Flags  3                 ; Ignore flagfiles created earlier that
                                    ; <specified_number> hours ago.
;
Logoff_Ask      Yes                 ; Whether to ask user confirmation on
                                    ; the session ending at choosing
                                    ; 'Logoff' menu item.
;
Logoff_Mail     Yes                 ; Ask user whether does he want to le-
                                    ; ave a message for SysOp before end-
                                    ; ing session.
;
UserInfo_MinSec  2                  ; Minimal access level to see detailed
                                    ; information about users.
;
External_Editor ;gedit.bat *P *B *T ; Command line to call external full-
                                    ; screen message editor.
;
QWK_Pack     pkzip -a %1 %2         ; Command line to pack QWK packets.
                                    ; Macros are:
                                    ;
                                    ; %1 - path to and name of the QWK-file
                                    ; %2 - name of file containing  a  list
                                    ;      of files to be packed.
;
QWK_UnPack   pkunzip -o %1          ; Command line to unpack QWK packets.
                                    ; The %1 macro, meaning rep-file name,
                                    ; can be used.
;
External_Chat ; chat.exe *P         ; Command line to invoke an external chat
                                    ; program. All  the  macros, mentioned in
                                    ; the EXEC menu command  description, can
                                    ; be used. If the parameter is  an  empty
                                    ; string, the internal  chat  facility is
                                    ; used.
;
Page_Times_Limit 3                  ; How many times can user page Sysop
                                    ; per one session
;
MsgQuote_Prefix  Yes                ; Put the quoted message author's inti-
                                    ; als at quote-replying to the message
                                    ; in a message area (Yes/No)
;
[Messages]
;
; Messages
;
No_One_Word_Names     "You must enter both your first and last name!"
;
LoginString   "\15Enter your name: \12"    ; Name prompt string
;
ChooseLang1   "|\14Choose your language\12: \14"
ChooseLang2   "\15Enter the number of the language you have chosen\12: \14"
                                           ; "Choose your language" string
;
[FileAreas]
;
; File Areas definitions
;
DLCount Yes                         ; If Tornado will make download counters
                                    ; in 'files.bbs' files.
;
DLCountMask "[###]"                 ; Download counter mask.
                                    ; Available mask symbols:
                                    ;  "#" - the number after some zeros
                                    ;  "*" - the number after some spaces
                                    ; Example:
                                    ;  mask "[###]" = counter "[001]"
                                    ;  mask "[***]" = counter "[  1]"
;
DLFree_Key "/f"                     ; Substring in the description in
                                    ; files.bbs which means that this
                                    ; file downloading won't decrease
                                    ; your time limit
;
Long_Desc_Pos      14               ; The starting position of long
                                    ; escriptions in FILES.BBS
;
Long_Desc_Char      >               ; Symbol followed by a long description
                                    ; of a file in files.bbs.
;
Cut_LongDescs Yes                   ; Whether to cut long descriptions (Yes)
                                    ; or to wrap them (No)
;
Cut_Descs No                        ; The same for standard descriptions
;
DLDescriptions  Ask                 ; If Tornado will transmit file
                                    ; descriptions (Yes, No, Ask)
;
Upload_Time_Plus 2                  ; How many minutes Tornado will add to
                                    ; user time limit for 1 minute of upload
;
Upload_Space 500                    ; Minimal free space (in kilobytes)
                                    ; to allow upload to your BBS
;
UpLoad_AjustDate Yes                ; Adjust date of the uploaded files
                                    ; to the current one.
;
List_Options  DLC, Date, Size, Missing
                                    ; File area preview options:
                                    ;
                                    ; Date    : show date of file
                                    ; Size    : show size of file
                                    ; Missing : show missing files.
                                    ; DLC     : show download counters.
;
Abort_Protocol DownLoad,UpLoad      ; Whether to interrupt file transfer if
                                    ; the user's time limit is exceeded or to
                                    ; wait until the transfer is completed
                                    ;
                                    ; DownLoad - interrupt downloading
                                    ; UpLoad   - interrupt uploading
                                    ;
                                    ; The default is:  DownLoad,UpLoad
;
Desc_Under_DLC Yes                  ; Create long single-line file descripti-
                                    ; ons for files download counters.
;
Abort_Protocol   DownLoad, UpLoad   ; If Tornado will abort transmitting
                                    ; of the file on time limit finishing
                                    ; or it will wait for the end of
                                    ; transmittion
                                    ;
                                    ; DownLoad - abort downloading
                                    ; UpLoad   - abort uploading
                                    ;
                                    ; Default:
                                    ; UpLoad, DownLoad.
;
[Colors]
;
; Colors Definitions
;
Blinking No                         ; Yes allows blinking
                                    ; No allows 16 colors for background
;
; Tornado's main screen
;
ms_Frame  DarkGray/Black            ; Screen Frame
ms_Headers  Green/Black             ; Windows' headers of the main screen
ms_Status  Black/LightGray          ; Status line
ms_Lamps  Blue/LightGray            ; Status line indicators
ms_HighLamps  Red/LightGray         ; Lighted status line indicators
ms_StatusFlags  White/Blue          ; Status line flags
ms_Statistics  LightGray/Black      ; Users' statistics
ms_Log  Cyan/Black                  ; Information
ms_Clock  Black/LightGray           ; Clock

;
; "File Transfer Protocol" window
;
prot_Frame  LightGray/DarkGray      ; Protocol window frame
prot_Header  LightGreen/DarkGray    ; Header
prot_Text  Cyan/DarkGray            ; Information
prot_Notice  White/DarkGray         ; "Copyright" header ;)
prot_Values  Yellow/DarkGray        ; Different dynamic information (CPS, filename etc)
prot_ScrollBar  Red/DarkGray        ; Transfer scroller
prot_Messages  LightGray/DarkGray   ; Window messages

;
; Dialog windows
;
dlg_Frame  LightGray/DarkGray       ; Dialog window frame
dlg_Title  LightGreen/DarkGray      ; Header
dlg_Input  Yellow/DarkGray          ; Input field
dlg_Scroller  LightGray/Black       ; Scrollers in dialogs
dlg_Button  Yellow/Green            ; Buttons
dlg_Text  White/DarkGray            ; Text in dialog windows

;
; Warning windows
;
alert_Frame  Yellow/Red             ; Frame
alert_Text  White/Red               ; Text

;
; Some elements of remote user interface
;
list_Number  Yellow/Black           ; Numbers in lists (file/msg areas)
list_Dot  White/Black               ; Points after the numbers
list_Item  LightGreen/Black         ; Lists elements (file/msg areas)
list_Separator  Blue/Black          ; Separators in lists
;
msglist_Number  LightGray/Black     ; Message list: numbers
msglist_From  LightGray/Black       ; Message list: field From
msglist_To  LightGray/Black         ; Message list: field To
msglist_Subj  LightGray/Black       ; Message list: subjects
msglist_LightTo White/Black         ; Message list: highlighted To
msglist_LightFrom White/Black       ; Message list: highlighted From
;
userlist_Name  White/Black          ; Userlist: names
userlist_Location  LightGreen/Black ; Userlist: locations
userlist_BirthDate LightGreen/Black ; Userlist: birthdays
userlist_LastDate  LightGreen/Black ; Userlist: last call dates
userlist_Numbers   LightGreen/Black ; Userlist: user numbers
;
todays_Line  White/Black            ; Today's callers: line numbers
todays_Name  White/Black            ; Today's callers: names
todays_EnterTime  White/Black       ; Today's callers: Enter time
todays_OnLine  Yellow/Black         ; Today's callers: time online
todays_Transfers  Yellow/Black      ; Today's callers: UL/DL
;
arcview_FileName  Yellow/Black      ; Archive viewer: file names
arcview_Date  White/Black           ; Archive viewer: file dates
arcview_Size  White/Black           ; Archive viewer: size
arcview_Compressed  White/Black     ; Archive viewer: compress ratio
;
flist_FileName  Yellow/Black        ; Filelist: file names
flist_TagNum  White/Black           ; Filelist: numbers to tag
flist_Size  LightRed/Black          ; Filelist: size
flist_Date  LightRed/Black          ; Filelist: file dates
flist_DLC   White/Black             ; Filelist: download counters
flist_Description  LightGreen/Black ; Filelist: descriptions
flist_Comments  White/Black         ; Filelist: comments
;
mread_Normal  LightGray/Black       ; Message editor: normal text
mread_Quote   Green/Black           ; Message editor: quoted text
mread_Origin  White/Black           ; Message editor: origin line and tearline
;
frames_Color Yellow/Black           ; Frames of input lines
news_Frames Yellow/Black            ; News: frames
news_Date   LightGreen/Black        ; News: dates
;
menus_Hidden  DarkGray/Black        ; Hidden menu items. When [Miscellaneous]->Show_Secured set to Hidden
;