{$IFNDEF OS2}
{$O+,F+}
{$ENDIF}
{$I-}

Unit SaveTag;

Interface

Uses
  Parse,
  tMisc,
  Log,
  Resource,
{$IFNDEF WIN32}
  Strings,
  Objects,
  DOS,
{$ELSE}
  Classes,
  OpCrt,
{$ENDIF}
  FilesBBS,
  tGlob,
  tModem,
  Users,
  MainComm;

Procedure SaveTagList;
Function RestoreTagList: Boolean;

Implementation

Var
  F     : Text;
  i     : LongInt;

Procedure SaveTagList;
Begin
  If (Not Cnf. SaveTagList) Or
     (F2Transfer^. Count < 1) Or
     (R. Name = '') Or Registering
  Then Exit;

  Assign (F, Cnf. SaveTagPath + HexL (Crc32Str (R. Name)) + '.lst');
  Append (F);
  If IOResult <> 0 Then ReWrite(F);
  If IOResult <> 0 Then
  Begin
    LogWrite ('!', sm (smTagSaveErr));
    Exit;
  End;

  WriteLn (F, '; ' + R. Name);

  For i := 0 To F2Transfer^. Count-1 Do
  If (PTagFileRec (F2Transfer^. At (i))^. PathName <> '') and
     (PTagFileRec (F2Transfer^. At (i))^. PathName <> '!') and
     (PTagFileRec (F2Transfer^. At (i))^. PathName <> UpString
     (Cnf. TempDir + 'file_id.1')) Then
  If PTagFileRec (F2Transfer^. At (i))^. FromName = '' Then
  Begin
    If PTagFileRec (F2Transfer^. At (i))^. Free
    Then WriteLn (F, '#' + PTagFileRec (F2Transfer^. At (i))^. PathName)
    Else WriteLn (F, '+' + PTagFileRec (F2Transfer^. At (i))^. PathName);
  End Else
    WriteLn (F, '*' + PTagFileRec (F2Transfer^. At (i))^. FromName + '|' + PTagFileRec
            (F2Transfer^. At (i))^. PathName);

  Close (F);
End;

Function RestoreTagList;
Var
  S             : PathStr;
  FileRec       : TTagFileRec;
  tFSize        : LongInt;
  C             : Char;

Begin
  RestoreTagList := False;
  If Not Cnf. SaveTagList Then Exit;

  Assign (F, Cnf. SaveTagPath + HexL (Crc32Str (R. Name)) + '.lst');
  ReSet (F);
  If IOResult <> 0 Then Exit;

  While Not Eof (F) Do
  Begin
    ReadLn (F, S);

    C := S [1]; If C = ';' Then Continue;
    If C in ['+', '*', '#'] Then S := Copy (S, 2, 255);

    Case C Of
      '+' : Begin
              FileRec. AreaNum := -10;
              FileRec. FromName := '';
              FileRec. Free := False;
            End;

      '#' : Begin
              FileRec. AreaNum := -10;
              FileRec. FromName := '';
              FileRec. Free := True;
            End;

      '*' : Begin
              FileRec. AreaNum := -20;

              If Pos ('|', S) <> 0
              Then
                FileRec. FromName := ExtractWord (1, S, ['|'])
              Else
                FileRec. FromName := 'Unknown';

              S := Copy (S, Pos ('|', S)+1, 255);
            End;
    Else
      FileRec. AreaNum := -10;
    End;

    If (S <> '') and (S <> '!') and (FileExists (S)) and
       (S <> UpString (Cnf. TempDir + 'file_id.1')) {and
       ((R. TodayK + Trunc (gFileSize (S) / 1024 + (SizeOfAll/1024)) <
       Round ((GetConnectSpeed / 10 * (R. TotalTime - MidSec + EnterTime)) / 1024))
       or Local)}
    Then

    With FileRec, F2Transfer^ Do
    Begin
      RestoreTagList := True;

      tFSize           := gFileSize (S);

      PathName         := S;
      Size             := tFSize;

      Insert (NewTagFile (FileRec));
      Inc (SizeOfAll, tFSize);
    End;

  End;
  Close (F);
  Erase (F);
End;

End.