{$S-,R-,Q-,I-,Cdecl-,OrgName-,AlignRec-}

Unit Os2Timer;

Interface

Uses
  OS2Base;

Type
  H_Timer = LongInt;

Const
  H_Timer_Reset = 0;

Var
  TxTimer,
  RxTimer: H_Timer;

Function Ticker: LongInt;
Function h_Timer_Get: longint;
Function h_Timer_Set (Duration: Word): LongInt;
Function h_Timer_Running (Timer: LongInt): Boolean;
Function h_Timer_Expired (Timer: LongInt): Boolean;

Implementation

Const
  TicksInDay = 1572480;
  TicsFreq = 1675;
  SecsFreq = 92;

Function Ticker: LongInt;
Var
  Res: LongInt;

Begin
  DosQuerySysInfo (Qsv_Time_Low, Qsv_Time_Low, Res, SizeOf (res));
  Ticker := Res;
End;

Function h_Timer_Get : longint;
Begin
 H_Timer_Get := Ticker;
End;

Function H_Timer_Set (Duration: Word): LongInt;
Begin
  H_Timer_Set := H_Timer_Get + Duration;
End;

Function H_Timer_Running (Timer: LongInt): Boolean;
Begin
  H_Timer_Running := (Timer <> 0);
End;

Function H_Timer_Expired (Timer: LongInt): Boolean;
Begin
  H_Timer_Expired := H_Timer_Get > Timer
End;

End.
