{$IFDEF MSDOS}
{$O+,F+}
{$ENDIF}
{$I-,F+}

Unit Locate;

{*********************************************************}
{*                     LOCATE.PAS                        *}
{*                                                       *}
{*  Copyright (c) Konstantin Klyagin, 1995-98,           *}
{*                exspecially for Tornado BBS System     *}
{*                                                       *}
{*********************************************************}

Interface

Uses
{$IFNDEF WIN32}
  DOS,
  OpInline,
{$ELSE}
  OpCrt,
  SysUtils,
{$ENDIF}
  tGlob,
  tMisc;

Var
  fLocate_Continue : Boolean;

Type
  ShowFileProc = Procedure (FName: PathStr);

Procedure fLocate (Mask: PathStr; ShowProc: ShowFileProc);

Implementation

Const
  FirstDir      : Boolean = True;

Var
  SaveDir       : PathStr;

Procedure fLocate (Mask: PathStr; ShowProc: ShowFileProc);
Var
  DirInfo       : {$IFNDEF WIN32} SearchRec {$ELSE} TSearchRec {$ENDIF};
  FirstLevel    : Boolean;
  CurDir        : PathStr;

Begin
  FirstLevel := False;

  If FirstDir Then
  Begin
    GetDir (0, SaveDir);
    SmartChDir (JustPathName (Mask));
    FirstLevel := True;
    fLocate_Continue := True;
    FirstDir := False;
  End;

  GetDir (0, CurDir);
  CurDir := AddBackSlash (CurDir);

{$IFDEF WIN32}
  DOSerror :=
{$ENDIF}
  FindFirst (CurDir + '*.*', AnyFile{$IFNDEF OS2}-VolumeID{$ENDIF}, DirInfo);
  While DOSerror = 0 Do
  Begin
    If Not fLocate_Continue Then Break;
    If DirInfo. Attr and Directory <> 0 Then
    Begin
      If (DirInfo. Name <> '.') And
         (DirInfo. Name <> '..') Then
      Begin
        SmartChDir (CurDir + DirInfo. Name);
        If IOResult = 0 Then
        Begin
          fLocate (Mask, ShowProc);
          If Not FirstLevel Then SmartChDir ('..');
        End;
      End;
    End Else
    If DirInfo. Attr and VolumeID = 0 Then
    If MatchWildCard (DirInfo. Name, JustFileName (Mask)) Then
       ShowProc (CurDir + DirInfo. Name);

    FindNext (DirInfo);
    fLocate_Continue := fLocate_Continue And Not DrawAborted;
  End;

  {$IFDEF OS2}
  FindClose (DirInfo);
  {$ENDIF}

  If FirstLevel Then
  Begin
    SmartChDir (SaveDir);
    FirstDir := True;
  End;

  If IOResult <> 0 Then;
End;

End.