unit help;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Objects, tMsgLib, tGlob, Resource, Buttons;

type
  THelpForm = class(TForm)
    Memo1: TMemo;
    BitBtn1: TBitBtn;
    procedure FormActivate(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
    procedure Memo1Enter(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  HelpForm: THelpForm;

implementation

uses tor32u;

{$R *.DFM}

procedure THelpForm.FormActivate(Sender: TObject);
Var
  Help           : PNotSortedCollection;
  i              : LongInt;

Const
  AlreadyRead : Boolean = False;

Begin
  If Not AlreadyRead Then
  Begin
    Help := New (PNotSortedCollection, Init (10, 1));

    If Not ReadCollection (MsgFileName, PBigCollection (Help), 'Help', NameVer, True) Then
    Begin
      Dispose (Help, Done);
      Exit;
    End;

    For i := 0 To Help^. Count-1 Do Memo1. Lines. Add (PString (Help^. At (i))^);
    Dispose (Help, Done);
    AlreadyRead := True;
  End;
End;

procedure THelpForm.BitBtn1Click(Sender: TObject);
begin
  MainForm. miHelp := True;
  Close;
end;

procedure THelpForm.Memo1Enter(Sender: TObject);
begin
  ActiveControl := BitBtn1;
end;

end.
