PROGRAM ConfigBBS;


USES DOS,CRT,STRstuff;
TYPE

       Config_Record = RECORD
          Caller_Number  : REAL;
          Port_Num       : BYTE;
          Init_Str       : STRING [25];
          Init_Delay     : INTEGER;
          HangupStr      : STRING [80];
          Autobaud       : BOOLEAN;
          On_300         : STRING [20];
          On_1200        : STRING [20];
          On_2400        : STRING [20];
          Locked         : BOOLEAN;
          LockedSpeed    : LONGINT;

          Accept_New     : BOOLEAN;
          Timer_On       : BOOLEAN;

          Sysopname      : STRING [40];
          SysopName2     : STRING [40];
          SysopName3     : STRING [40];
          Sysop_Pw       : STRING [8];
          SystemName     : STRING [40];
          Miscpath       : STRING [50];
          Userpath       : STRING [50];
          Unvallevel     : BYTE;
          Vallevel       : BYTE;
          Sysoplevel     : BYTE;
          LocalLockPSW   : STRING [8];
          HiAccessPSW    : STRING [8];

          Bell_On        : BOOLEAN;
          B_color        : BYTE;
          W_color        : BYTE;
          F_color        : BYTE;

          D_level1       : BYTE;
          D_level2       : BYTE;
          D_noa          : BYTE;
          D_K            : ARRAY [1..4] OF BYTE;

          To_Prompt      : BOOLEAN;
          Show_Linenum   : BOOLEAN;
          Ext_chars      : BOOLEAN;

          promptSTR      : STRING [50];
          ChatIn         : STRING [80];
          ChatOut        : STRING [80];
          ChatCall1      : STRING [80];
          AfterChat      : STRING [80];
          TooManyChat    : STRING [80];
          ChatLimit      : WORD;
          LastCaller     : STRING [40];
          OneLiner       : STRING [80];
          LeftBy         : STRING [20];
          UpNum          : BYTE;
          BusyOnLocal    : BOOLEAN;
          Liners         : BOOLEAN;
          Color          : BOOLEAN;
          EditPath       : STRING [80];
          FullScreen     : BOOLEAN;
          TopTen         : ARRAY [1..10] of STRING [40];
          TopBytes       : ARRAY [1..10] of LongINT;
       END;

  FileType = RECORD
    Area_Name  : STRING [40]; {Arrays for holding File Info}
    File_Path  : STRING [40];
    Area_File  : STRING [40];
    Area_Level : BYTE;
  END;

  boards_type = record
           name : string [80];
           path : string [40];
           Tpath : String [40];
           Ipath : String [40];
           Filename : string [9];
           default_access : char;
           validate_access: char;
          end;

       door_type = RECORD
          name     : STRING [50];
          level    : BYTE;
          dos_code : BYTE;
          FileName : STRING;
          Ratio    : REAL;
       END;

       bulletin_record = RECORD
          name     : STRING[50];
          filename : STRING[30];
       END;

 d_k_type = record
  level : byte;
  k     : integer;
 end;

 ExternalProtocolRecord = RECORD
          Name         : STRING[40];
          Path         : STRING[40];
          UpString     : STRING[30];
          DownString   : STRING[30];
          Command      : STRING[5];
          BatchString  : STRING[5];
   END;

CONST
   Config_Filename = 'CONFIG.DAT';

VAR
  Config      : Config_Record;
  boards      : array [0..15] of boards_type;
  doors       : array [1..15] of door_type;
  files       : ARRAY [1..30] of FileType;
  PickLst    : PickType;
  b_changed, f_changed, bull_changed, d_changed, p_changed : boolean;
  MaxAreas   : INTEGER;
  MaxBoards  : INTEGER;
  MaxDoors   : INTEGER;
  MainInput  : INTEGER;
  TempInt    : INTEGER;
  TempStr    : STRING;
  TempBy     : BYTE;
  TempBoo    : BOOLEAN;
  Code       : INTEGER;
  maxfiles   : BYTE;
  MaxProts   : BYTE;


PROCEDURE WriteLine (InStr: STRING);

  BEGIN
       Writeln (InStr);
  END;

PROCEDURE WriteString (InStr: STRING);

  BEGIN
       Write (InStr);
  END;

PROCEDURE ClearScreen;

VAR I:INTEGER;
  BEGIN
    ClrScr;
  END;


PROCEDURE Defaults;

  VAR
    X : INTEGER;
    I : INTEGER;

 BEGIN
  WITH Config Do
   BEGIN
    SystemName    := 'TOPsoftware BBS';
    Caller_Number := 0;
    d_level1      := 40;
    d_level2      := 50;
    d_noa         := 0;
    port_num      := 1;
    init_str      := '~~~~~~ATS0=1 H0 E0 M0 X4{';
    On_300        := 'CONNECT';
    On_1200       := 'CONNECT 1200';
    On_2400       := 'CONNECT 2400';
    Locked        := FALSE;
    LockedSpeed   := 9600;
    init_delay    := 6000;
    accept_new    := TRUE;
    to_prompt     := TRUE;
    ext_chars     := TRUE;
    show_linenum  := TRUE;
    timer_on      := TRUE;
    Color         := TRUE;
    sysopname     := 'SYSOP';
    SysopName2    := '';
    SysopName3    := '';
    LastCaller    := 'SYSOP';
    sysop_pw      := 'SYSOP';
    miscpath      := 'C:\TOP\';
    userpath      := 'C:\TOP\';
    EditPath      := 'C:\TOP\TOPED.EXE\';
    FullScreen    := FALSE;
    unvallevel    := 40;
    vallevel      := 60;
    sysoplevel    := 255;
    bell_on       := TRUE;
    b_color       := 0;
    w_color       := 7;
    f_color       := 7;
    hangupstr     := 'ATH0';
    autobaud      := TRUE;
    promptSTR     := '-=@:~:^:? for menu:=-';
    ChatIn        := '----  Chat with Sysop  ----';
    ChatOut       := '----  Done Chatting with Sysop  ----';
    ChatCall1     := 'Ringing the Chat Bell. . . .';
    AfterChat     := 'The Sysop will answer if he is around.';
    TooManyChat   := 'Please, Dont be rude.';
    ChatLimit     := 3;
    HiAccessPSW   := 'PASSWORD';
    OneLiner      := 'This Space Available.  Express Yourself!';
    LeftBy        := 'SYSOP';
    Maxfiles      :=0;
    UpNum         :=1;
    BusyOnLocal   :=TRUE;
    Liners        :=TRUE;
    For I := 1 to 10 do TopTen[I] := '';
    For I := 1 to 10 do TopBytes[I] := 0;
    END;
  END;


PROCEDURE ClearFiles;

   VAR Count : INTEGER;

   BEGIN
  For Count := 1 to 30 do
       BEGIN
        WITH Files[Count] do
         BEGIN
          Area_Name := '';
          File_Path := '';
          Area_File := '';
          Area_Level := 0;
        END;
       END;
     END;


PROCEDURE ReadFiles;

  VAR
    ScratchFile : TEXT;
    Count       : INTEGER;

 CONST
   Data_File = 'FileArea.Txt';

  BEGIN
    Count := 0;
    ClearFiles;
    Assign  (ScratchFile,Data_File);
    {$I-} Reset (ScratchFile); {$I+}
    If IOresult = 0 then
      BEGIN
        WriteLine ('-Reading File Area Configuration...');
        REPEAT
         BEGIN
          Count := Succ(Count);
            WITH Files[Count] do
             BEGIN
              ReadLn (ScratchFile,Area_Name);
              ReadLn (ScratchFile,File_Path);
              ReadLn (ScratchFile,Area_File);
              ReadLn (ScratchFile,Area_Level);
             END;
          END;
        UNTIL (Count = 30) or (SEEKEOF (ScratchFile));
        Maxfiles:= Count;
      END
      ELSE
       BEGIN
        WITH Files[1] do
         BEGIN
           Area_Name  := 'General Files';
           File_Path  := 'C:\TOP\FILES\';
           Area_File  := 'AREA1';
           Area_Level := 40;
         END;
         MaxFiles := 1;
         F_Changed := TRUE;
       END;
    END;

PROCEDURE SaveFiles;
 var
  F_file : text;
  i      : integer;
 begin
  assign (F_file,'FileArea.TXT');
  ReWrite(F_file);
  for i := 1 to maxfiles do
   begin
    with files [i] do
     begin
      Writeln (F_File,Area_Name);
      Writeln (F_File,File_Path);
      Writeln (F_File,Area_File);
      Writeln (F_File,Area_Level);
     end;
   end;
  close (F_file);
 end;

 PROCEDURE ChangeFiles;

 VAR
   I        : INTEGER;
   Question : STRING [5];
   tempstr  : STRING [80];
   TempS    : STRING;
   TempS2   : STRING;
   tempint  : INTEGER;
   code     : INTEGER;
   x        : INTEGER;
   TempInt2 : INTEGER;

 CONST
  NameMsg = 'Enter File Area Name';
  PathMsg = 'Enter File Path  Example: C:\TOP\FILE1\';
  FileMsg = 'Enter Record File Name Example: AREA';
  LevMsg  = 'Enter Access Level (1-255)';

 BEGIN
  TempInt := 1;
  I       := 1;
  REPEAT
   BEGIN
    If TempInt = 0 Then TempInt := 1;
    Clrscr;
    Str (config.Port_Num,TempS);
   WITH Files[I] do
    BEGIN
     PickLst[1] := 'Name         ' + Area_Name;
     PickLst[2] := 'Directory    ' + File_Path;
     PickLst[3] := 'FileName     ' + Area_File;
     Str (Area_Level,TempS);
     PickLst[4] := 'Access Level ' + TempS;
     PickLst[5] := 'Next';
     PickLst[6] := 'Last';
     PickLst[7] := 'Add';
     PickLst[8] := 'Delete';
     PickLst[9] := 'Jump';
     PickLst[10] := 'Exit';
     Str (I,TempS);
     TempS2 := 'File Area # '+ TempS;
     TempInt := PickList (PickLst,TempS2,15,4,TempInt,45,10,6,15,1);
     f_changed := true;
     case TempInt of
        1 : BEGIN
             TempStr := Area_Name;
             TempStr := StringBox('File Area Name','Name:',30,TempStr,NameMsg,14,18,18,15,2);
             if tempstr <> '@@@' then
              BEGIN
               Area_Name := tempstr;
               Area_Name := allcaps (Area_Name);
              END;
             END;
         2 : BEGIN
              TempStr := File_Path;
             TempStr := StringBox('File Directory','Directory:',30,TempStr,PathMsg,14,18,18,15,2);
              IF tempstr <> '@@@' then
               BEGIN
                IF tempstr [2] = ':' THEN
                 BEGIN
                  IF tempstr [length (tempstr)] <> '\' then tempstr := tempstr + '\';
                  File_Path := tempstr;
                  File_Path := allcaps (File_Path);
                 END;
               END;
            END;
        3 : BEGIN
             TempStr := Area_File;
             TempStr := StringBox('List Filename','Name:',30,TempStr,FileMsg,14,18,18,15,2);
             if tempstr <> '@@@' then
              BEGIN
               Area_File := allcaps(tempstr);
              END;
             END;
       4  : BEGIN
             Str(Area_Level,TempStr);
             TempStr := StringBox('Access Level','Level:',30,TempStr,LevMsg,14,18,18,15,2);
             if tempstr <> '@@@' then
              BEGIN
               Val (TempStr,TempInt2,Code);
               If (TempInt2 > 0) and (TempInt2 < 256) THEN
               Area_Level := tempInt2;
              END;
             END;
        7  : BEGIN
              IF maxFiles < 31 then
               BEGIN
                MaxFiles := succ (MaxFiles);
                I:= MaxFiles;
               END;
             END;
       end {of case}
    end; {of with}
    if (TempInt = 8) and (maxfiles > 0) then
     begin
      if i = maxfiles then
       begin
        with files [i] do
         begin
          Area_name := '';
          File_path := '';
          Area_File := '';
          Area_Level := 0;
         end;
        maxfiles := pred (maxfiles);
        i := pred (i);
       end
      else
       begin
        for x := i to (maxfiles - 1) do files [x] := files [x + 1];
        with files [maxfiles] do
         begin
          Area_name := '';
          File_path := '';
          Area_File := '';
          Area_Level := 0
         end;
        maxfiles := pred (maxfiles);
       end;
     end;
    if TempInt = 9 then
     BEGIN
      TempStr := StringBox('Jump','To:',6,'','',25,18,18,15,2);
       if tempstr <> '@@@' then
          BEGIN
            Val (TempStr,TempInt2,Code);
            if (code = 0) and (tempint2 <= maxfiles) and (tempint2 >= 1) then
            i := tempint2;
           END;
       END;
    if (tempint = 5)  then
       if i < maxfiles then i := succ (i)
         else i := 1;
    if (tempint = 6)  then
       if i > 1 then i := i - 1 else if i = 1 then i := maxfiles;
    END;
  until (TempInt = 10);
 end;

 procedure read_config;
 var
  c_file : File Of Config_Record;
  x      : integer;
 begin
  assign (c_file,Config_Filename);
  {$I-}
  reset (c_file);
  {$I+}
  If IOResult <> 0 then defaults
  else
   begin
    {$I-}
     Read (C_File,Config);
      {$I+} IF IoResult <> 0 then
        BEGIN
          Writeln ('-Fatal Error: Config file contaminated.  Delete Config.Dat and Reconfigure!');
          Halt;
        END;
     close (c_file);
   end;
 end;

PROCEDURE ModemConfig;

 VAR
  TempSTR       : STRING;
  TempS         : STRING;
  TempInt       : BYTE;
  TempInt2      : INTEGER;

 CONST
  InitMsg = 'Example: ~AT E0 M1 X4{';
  ResuMsg = 'Example: CONNECT';
  ResuMsg1= 'Example: CONNECT 1200';
  ResuMsg2= 'Example: CONNECT 2400';
  HangMsg = 'String To Hang Up Modem Without DTR';
  DelaMsg = 'Modem Delay  Example: 5000';

 BEGIN
  TempInt := 1;
  REPEAT
   BEGIN
    If TempInt = 0 Then TempInt := 1;
    Clrscr;
    Str (config.Port_Num,TempS);
    PickLst[1] := 'Com Port Number                       ' + TempS;
    PickLst[2] := 'Modem Init String                     ' + Config.Init_Str;
    PickLst[3] := 'Result Code for 300 Baud              ' + Config.On_300;
    PickLst[4] := 'Result Code for 1200 Baud             ' + Config.On_1200;
    PickLst[5] := 'Result Code for 2400 Baud             ' + Config.On_2400;
    PickLst[6] := 'String to Hangup Modem                ' + Config.HangUpStr;
    IF Config.Locked THEN TempS := 'YES' ELSE TempS := 'NO';
    PickLst[7] := '9600+ Baud Modem?                     ' + TempS;
    Str (Config.LockedSpeed,TempS);
    PickLst[8] := 'Speed of Locked Modem                 ' + TempS;
    IF Config.Autobaud THEN TempS := 'YES' ELSE TempS := 'NO';
    PickLst[9] := 'Set speed to modem result code?       ' + TempS;
    Str (Config.Init_Delay,TempS);
    PickLst[10]:= 'Modem Initialization Delay            ' + TempS;
    IF Config.BusyOnLocal THEN TempS := 'YES' ELSE TempS := 'NO';
    PickLst[11]:= 'Busy Modem on Local Logon?            ' + TempS;
    PickLst[12]:= 'Exit';
    TempInt := PickList (PickLst,'Modem Configuration',5,1,TempInt,70,12,6,15,5);
    CASE TempInt of
     1 : BEGIN
          PickLst[1] := 'Port 1';
          PickLst[2] := 'Port 2';
          PickLst[3] := 'Port 3';
          PickLst[4] := 'Port 4';
          TempInt2 := PickList (PickLst,'Comm Port Number',20,17,1,20,4,6,15,2);
          IF tempint2 in [1,2,3,4] then Config.port_num := tempint2;
         END;
     2 : BEGIN
          TempStr := Config.Init_Str;
          TempStr := StringBox('Modem Initialization String','Init String:',30,TempStr,InitMsg,14,18,18,15,2);
          if tempstr <> '@@@' then
           BEGIN
            Config.Init_Str := tempstr;
            Config.Init_Str := allcaps (Config.Init_Str);
           END;
         END;
     3 : BEGIN
          TempStr := Config.On_300;
          TempStr := StringBox('Result code for 300 Baud','Result Code:',30,TempStr,ResuMsg,14,18,18,15,2);
          if tempstr <> '@@@' then
           BEGIN
            Config.On_300 := tempstr;
            Config.On_300 := allcaps (Config.On_300);
           END;
         END;
     4 : BEGIN
          TempStr := Config.On_1200;
          TempStr := StringBox('Result code for 1200 Baud','Result Code:',30,TempStr,ResuMsg1,14,18,18,15,2);
          if tempstr <> '@@@' then
           BEGIN
            Config.On_1200 := tempstr;
            Config.On_1200 := allcaps (Config.On_1200);
           END;
         END;
     5 : BEGIN
          TempStr := Config.On_2400;
          TempStr := StringBox('Result code for 2400 Baud','Result Code:',30,TempStr,ResuMsg2,14,18,18,15,2);
          if tempstr <> '@@@' then
           BEGIN
            Config.On_2400 := tempstr;
            Config.On_2400 := allcaps (Config.On_2400);
           END;
         END;

     6 : BEGIN
          TempStr := Config.HangUpStr;
          TempStr := StringBox('Hang Up Command','Command:',30,TempStr,HangMsg,14,18,18,15,2);
          if tempstr <> '@@@' then
           BEGIN
            Config.HangUpStr := tempstr;
            Config.HangUpStr := allcaps (Config.HangUpStr);
           END;
         END;

     7 : BEGIN
          PickLst[1] := 'YES';
          PickLst[2] := 'NO';
          TempInt2 := PickList (PickLst,'9600+ Modem',20,17,1,20,2,6,15,2);
          CASE TempInt2 OF
              1: Config.Locked := TRUE;
              2: Config.Locked := FALSE;
          END;
         END;
     8 : BEGIN
          PickLst[1] := ' 9600';
          PickLst[2] := '19200';
          PickLst[3] := '38400';
          PickLst[4] := '57600';
          TempInt2 := PickList (PickLst,'9600+ Port Speed',20,17,1,20,4,6,15,2);
          CASE TempInt2 OF
              1: Config.LockedSpeed  := 9600;
              2: Config.LockedSpeed  := 19200;
              3: Config.LockedSpeed  := 38400;
              4: Config.LockedSpeed  := 57600;
          END;
         END;

     9 : BEGIN
          PickLst[1] := 'YES';
          PickLst[2] := 'NO';
          TempInt2 := PickList (PickLst,'Autobaud Detect',20,17,1,20,2,6,15,2);
          CASE TempInt2 OF
              1: Config.AutoBaud := TRUE;
              2: Config.AutoBaud := FALSE;
          END;
         END;
     10: BEGIN
          Str(Config.Init_Delay,TempStr);
          TempStr := StringBox('Modem Delay','Delay:',30,TempStr,DelaMsg,14,18,18,15,2);
          if tempstr <> '@@@' then
           BEGIN
            Val (TempStr,TempInt2,Code);
            If (TempInt2 > 0) and (TempInt2 < 32767) THEN
            Config.Init_Delay := tempInt2;
           END;
         END;
     11: BEGIN
          PickLst[1] := 'YES';
          PickLst[2] := 'NO';
          TempInt2 := PickList (PickLst,'Auto Busy Modem',20,17,1,20,2,6,15,2);
          CASE TempInt2 OF
              1: Config.BusyOnLocal := TRUE;
              2: Config.BusyOnLocal := FALSE;
          END;
         END;
     END; {of case}
  END;
  until (TempInt = 12);
 end;

PROCEDURE DriveAndFiles;

 VAR
  Input        : INTEGER;
  TempInt      : BYTE;
  TempStr      : STRING;

 CONST
  PathMsg  = 'Enter FULL path (i.e., C:\TOP\)';
  PathMsg2 = 'Enter FULL FileSpec (i.e., C:\TOP\TOPED.EXE';


 BEGIN
  TempInt := 1;
  REPEAT
   If TempInt = 0 THEN TempInt := 1;
   Clrscr;
   PickLst[1] := 'User File Directory        ' + Config.UserPath;
   PickLst[2] := 'Main BBS Directory         ' + Config.MiscPath;
   PickLst[3] := 'External Editor FileSpec   ' + Config.EditPath;
   PickLst[4] := 'Exit';
   TempInt := PickList (PickLst,'Directories',7,6,TempInt,65,4,6,15,5);
   CASE TempInt of
    1 : BEGIN
         TempStr := Config.UserPath;
         TempStr := StringBox('Directories','User File Directory:',30,TempStr,PathMsg,10,12,16,15,6);
         if tempstr <> '@@@' then
          BEGIN
            IF tempstr [2] = ':' THEN
             BEGIN
              if tempstr [length (tempstr)] <> '\' then tempstr := tempstr + '\';
              Config.userpath := tempstr;
              Config.userpath := allcaps (Config.userpath);
             END;
          END;
        END;

    2 : BEGIN
         TempStr := Config.MiscPath;
         TempStr := StringBox('Directories','Main BBS Directory:',30,TempStr,PathMsg,10,12,16,15,6);
         IF tempstr <> '@@@' then
          BEGIN
            IF tempstr [2] = ':' THEN
             BEGIN
              IF tempstr [length (tempstr)] <> '\' then tempstr := tempstr + '\';
              Config.miscpath := tempstr;
              Config.miscpath := allcaps (Config.miscpath);
             END;
          END;
       END;
   3 : BEGIN
         TempStr := Config.EditPath;
         TempStr := StringBox('Directories','External Editor FileSpec:',30,TempStr,PathMsg2,10,12,16,15,6);
         IF tempstr <> '@@@' THEN
          BEGIN
            IF tempstr [2] = ':' THEN
             BEGIN
              Config.Editpath := tempstr;
              Config.Editpath := allcaps (Config.Editpath);
             END;
          END;
        END;
    end;
  until (TempInt = 4);
 end;


PROCEDURE Levels;

 VAR
  Input    : INTEGER;
  Code     : INTEGER;
  TempInt  : INTEGER;
  TempInt2 : INTEGER;
  TempStr  : STRING;
  TempS    : STRING;

 CONST
   SysMsg = 'Enter Sysop Level  (1-255)';
   UnvMsg = 'Enter Unvalided User Level (1-255)';
   ValMsg = 'Enter Validated User Level (1-255)';
   UD1Msg = 'Enter Unvalidated U/D Level (1-255)';
   UD2Msg = 'Enter Validated U/D Level (1-255)';
   NoaMsg = 'Enter Level for NO U/D Access (1-255)';

  BEGIN
  TempInt := 1;
  REPEAT
   BEGIN
    If TempInt = 0 Then TempInt := 1;
    Clrscr;
    Str (config.SysopLevel,TempS);
    PickLst[1] := 'Sysop Level                ' + TempS;
    Str (Config.Unvallevel,TempS);
    PickLst[2] := 'Unvalidated User Level     ' + TempS;
    Str(Config.ValLevel,TempS);
    PickLst[3] := 'Validated User Level       ' + TempS;
    Str (Config.D_Level1,TempS);
    PickLst[4] := 'Unvalidated Download Level ' + TempS;
    Str(Config.D_Level2,TempS);
    PickLst[5] := 'Validated Download Level   ' + TempS;
    Str(Config.D_Noa,TempS);
    PickLst[6] := 'Level for NO U/D Access    ' + TempS;
    PickLst[7] := 'Exit';
    TempInt := PickList (PickLst,'Levels',20,5,TempInt,31,7,6,15,5);
    CASE TempInt of
      1 : BEGIN
           Str(Config.SysopLevel,TempStr);
          TempStr := StringBox('Sysop Level','Level:',30,TempStr,SysMsg,14,18,18,15,2);
          if tempstr <> '@@@' then
           BEGIN
            Val (TempStr,TempInt2,Code);
            If (TempInt2 > 0) and (TempInt2 < 256) THEN
            Config.SysopLevel := tempInt2;
           END;
         END;
   2 :  BEGIN
          Str(Config.UnValLevel,TempStr);
          TempStr := StringBox('Unvalidated User Level','Level:',30,TempStr,UnvMsg,14,18,18,15,2);
          if tempstr <> '@@@' then
           BEGIN
            Val (TempStr,TempInt2,Code);
            If (TempInt2 > 0) and (TempInt2 < 256) THEN
            Config.UnValLevel := tempInt2;
           END;
         END;
    3 :  BEGIN
          Str(Config.ValLevel,TempStr);
          TempStr := StringBox('Validated User Level','Level:',30,TempStr,ValMsg,14,18,18,15,2);
          if tempstr <> '@@@' then
           BEGIN
            Val (TempStr,TempInt2,Code);
            If (TempInt2 > 0) and (TempInt2 < 256) THEN
            Config.ValLevel := tempInt2;
           END;
         END;
    4 :  BEGIN
          Str(Config.D_Level1,TempStr);
          TempStr := StringBox('Unvalidated U/D User Level','Level:',30,TempStr,UD1Msg,14,18,18,15,2);
          if tempstr <> '@@@' then
           BEGIN
            Val (TempStr,TempInt2,Code);
            If (TempInt2 > 0) and (TempInt2 < 256) THEN
            Config.D_Level1 := tempInt2;
           END;
         END;
     5 :  BEGIN
          Str(Config.D_Level2,TempStr);
          TempStr := StringBox('Validated U/D User Level','Level:',30,TempStr,UD2Msg,14,18,18,15,2);
          if tempstr <> '@@@' then
           BEGIN
            Val (TempStr,TempInt2,Code);
            If (TempInt2 > 0) and (TempInt2 < 256) THEN
            Config.D_Level2 := tempInt2;
           END;
         END;
    6 :  BEGIN
          Str(Config.D_Noa,TempStr);
          TempStr := StringBox('No Access U/D Level','Level:',30,TempStr,NoaMsg,14,18,18,15,2);
          if tempstr <> '@@@' then
           BEGIN
            Val (TempStr,TempInt2,Code);
            If (TempInt2 > 0) and (TempInt2 < 256) THEN
            Config.D_Noa := tempInt2;
           END;
         END;
     END;
   END;
  until (TempInt = 7);
 end;

PROCEDURE SysInfo;

 VAR
  Input    : INTEGER;
  Code     : INTEGER;
  TempInt  : INTEGER;
  TempInt2 : INTEGER;
  TempStr  : STRING;
  TempS    : STRING;

 CONST
   SysnMsg = 'Enter System Name';
   SyoNMsg = 'Enter Sysop Name';
   SyoN2Msg = 'Enter Second Sysop Name';
   SyoN3Msg = 'Enter Third Sysop Name';
   SyoPWMsg = 'Enter Sysops Default Password';
   SyoHPMsg = 'Enter Sysop Access Password';

  BEGIN
  TempInt := 1;
  REPEAT
   BEGIN
    If TempInt = 0 Then TempInt := 1;
    Clrscr;
    PickLst[1] := 'System Name                   ' + config.SystemName;
    PickLst[2] := 'Sysop name                    ' + config.SysopName;
    PickLst[3] := 'Second Sysop                  ' + config.SysopName2;
    PickLst[4] := 'Third Sysop                   ' + config.SysopName3;
    PickLst[5] := 'Sysop`s Default Password      ' + config.Sysop_Pw;
    PickLst[6] := 'Password For Sysop Access     ' + config.HiAccessPSW;
    PickLst[7] := 'Exit';
    TempInt := PickList (PickLst,'System Info',15,5,TempInt,65,7,6,15,5);
    CASE TempInt of
     1 : BEGIN
          TempStr := Config.SystemName;
          TempStr := StringBox('System Name','Name:',30,TempStr,SysNMsg,14,18,18,15,2);
          if tempstr <> '@@@' then
           BEGIN
            Config.SystemName := tempstr;
           END;
         END;
     2 : BEGIN
          TempStr := Config.SysopName;
          TempStr := StringBox('Sysop Name','Name:',30,TempStr,SyoNMsg,14,18,18,15,2);
          if tempstr <> '@@@' then
           BEGIN
            Config.SysopName := tempstr;
            Config.SysopName := Allcaps (Config.SysopName);
           END;
         END;
     3 : BEGIN
          TempStr := Config.SysopName2;
          TempStr := StringBox('2nd Sysop Name','Name:',30,TempStr,SyoN2Msg,14,18,18,15,2);
          if tempstr <> '@@@' then
           BEGIN
            Config.SysopName2 := tempstr;
            Config.SysopName2 := Allcaps (Config.SysopName2);
           END;
         END;
     4 : BEGIN
          TempStr := Config.SysopName3;
          TempStr := StringBox('3nd Sysop Name','Name:',30,TempStr,SyoN3Msg,14,18,18,15,2);
          if tempstr <> '@@@' then
           BEGIN
            Config.SysopName3 := tempstr;
            Config.SysopName3 := Allcaps (Config.SysopName3);
           END;
         END;
     5 : BEGIN
          TempStr := Config.Sysop_PW;
          TempStr := StringBox('Sysop Default Password','Password:',30,TempStr,SyoPWMsg,14,18,18,15,2);
          if tempstr <> '@@@' then
           BEGIN
            Config.Sysop_PW := tempstr;
            Config.Sysop_PW := Allcaps (Config.Sysop_PW);
           END;
         END;
     6 : BEGIN
          TempStr := Config.HiAccessPSW;
          TempStr := StringBox('Sysop Functions Password','Password:',30,TempStr,SyoHPMsg,14,18,18,15,2);
          If TempStr <> '@@@' THEN
           BEGIN
            Config.HiAccessPSW := tempstr;
            Config.HiAccessPSW := Allcaps (Config.HiAccessPSW);
           END;
         END;
     END;
   END;
  until (TempInt = 7);
 end;
PROCEDURE misc_stuff;

 VAR
  Input    : INTEGER;
  Code     : INTEGER;
  TempInt  : INTEGER;
  TempInt2 : INTEGER;
  TempStr  : STRING;
  TempS    : STRING;

 CONST
   BCOMsg = 'Enter Background Color (0-7)';
   WcoMsg = 'Enter Window Color (0-15)';
   FCOMsg = 'Enter Text Color (0-15)';
   UPLMsg = 'Enter Upload Area (1-30)';
   LIMMsg = 'Enter Chat Limit';

  BEGIN
  TempInt := 1;
  REPEAT
   BEGIN
    If TempInt = 0 Then TempInt := 1;
    Clrscr;
    IF Config.Accept_New THEN TempS := 'YES' ELSE TempS := 'NO';
    PickLst[1] := 'Accept New Users?                  ' + TempS;
    If Config.Bell_On THEN TempS := 'ON' ELSE TempS := 'OFF';
    PickLst[2] := 'Bell Default                       ' + TempS;
    Str (Config.B_Color,TempS);
    PickLst[3] := 'Background Color                   ' + TempS;
    Str (Config.F_Color,TempS);
    PickLst[4] := 'Text Color                         ' + TempS;
    Str (Config.W_Color,TempS);
    PickLst[5] := 'Window Color                       ' + TempS;
    If Config.Color THEN TempS := 'COLOR' ELSE TempS := 'MONOCHROME';
    PickLst[6] := 'Color/Monocrome                    ' + TempS;
    if Config.liners THEN TempS := 'YES' ELSE TempS :='NO';
    PickLst[7] := 'Enable the One Liner Feature       ' + TempS;
    If Config.FullScreen THEN Temps := 'YES' ELSE TempS :='NO';
    PickLst[8] := 'Enable the External Editor         ' + TempS;
    Str (Config.UpNum,TempS);
    PickLst[9] := 'Upload Area For New Uploads        ' + TempS;
    Str (Config.ChatLimit,TempS);
    PickLst[10]:= 'Maximum Chat Requests              ' + TempS;
    PickLst[11]:= 'Exit';
    TempInt := PickList (PickLst,'General',17,2,TempInt,47,11,6,15,5);
    CASE TempInt of
     1 : BEGIN
          PickLst[1] := 'YES';
          PickLst[2] := 'NO';
          TempInt2 := PickList (PickLst,'Accept New Users?',20,17,1,20,2,6,15,2);
          CASE TempInt2 OF
              1: Config.Accept_New := TRUE;
              2: Config.Accept_New := FALSE;
          END;
         END;
     2 : BEGIN
          PickLst[1] := 'ON';
          PickLst[2] := 'OFF';
          TempInt2 := PickList (PickLst,'Bell Default?',20,17,1,20,2,6,15,2);
          CASE TempInt2 OF
              1: Config.Bell_on := TRUE;
              2: Config.Bell_on := FALSE;
          END;
         END;
     3 : BEGIN
          Str(Config.b_Color,TempStr);
          TempStr := StringBox('Background Color','Color:',30,TempStr,BCOMsg,14,18,18,15,2);
          if tempstr <> '@@@' then
           BEGIN
            Val (TempStr,TempInt2,Code);
            If (TempInt2 >= 0) and (TempInt2 < 8) THEN
            Config.b_color := tempInt2;
           END;
         END;
    4 : BEGIN
          Str(Config.f_Color,TempStr);
          TempStr := StringBox('Text Color','Color:',30,TempStr,FCOMsg,14,18,18,15,2);
          if tempstr <> '@@@' then
           BEGIN
            Val (TempStr,TempInt2,Code);
            If (TempInt2 >= 0) and (TempInt2 < 16) THEN
            Config.F_color := tempInt2;
           END;
         END;
    5 : BEGIN
          Str(Config.W_Color,TempStr);
          TempStr := StringBox('Window Color','Color:',30,TempStr,WCOMsg,14,18,18,15,2);
          if tempstr <> '@@@' then
           BEGIN
            Val (TempStr,TempInt2,Code);
            If (TempInt2 >= 0) and (TempInt2 < 16) THEN
            Config.w_color := tempInt2;
           END;
         END;
    6 : BEGIN
          PickLst[1] := 'COLOR';
          PickLst[2] := 'MONOCROME';
          TempInt2 := PickList (PickLst,'Color/Monocrome?',20,17,1,20,2,6,15,2);
          CASE TempInt2 OF
              1: Config.Color := TRUE;
              2: Config.Color := FALSE;
          END;
         END;
     7 : BEGIN
          PickLst[1] := 'ENABLE';
          PickLst[2] := 'DISABLE';
          TempInt2 := PickList (PickLst,'One Liner?',20,17,1,20,2,6,15,2);
          CASE TempInt2 OF
              1: Config.Liners := TRUE;
              2: Config.Liners := FALSE;
          END;
         END;
     8 : BEGIN
          PickLst[1] := 'ENABLE';
          PickLst[2] := 'DISABLE';
          TempInt2 := PickList (PickLst,'External Editor?',20,17,1,20,2,6,15,2);
          CASE TempInt2 OF
              1: Config.Fullscreen := TRUE;
              2: Config.Fullscreen := FALSE;
          END;
         END;
      9 : BEGIN
          Str(Config.UpNum,TempStr);
          TempStr := StringBox('Upload Area','Area:',30,TempStr,UPLMsg,14,18,18,15,2);
          if tempstr <> '@@@' then
           BEGIN
            Val (TempStr,TempInt2,Code);
            If (TempInt2 > 0) and (TempInt2 < 31) THEN
            Config.Upnum := tempInt2;
           END;
         END;
     10: BEGIN
          Str(Config.ChatLimit,TempStr);
          TempStr := StringBox('Chat Limit','Limit:',30,TempStr,LIMMsg,14,18,18,15,2);
          if tempstr <> '@@@' then
           BEGIN
            Val (TempStr,TempInt2,Code);
            If (TempInt2 > 0) and (TempInt2 < 32767) THEN
            Config.Chatlimit := tempInt2;
           END;
         END;
    end; { end of case}
   END;
  until (TempInt = 11);
 end;


procedure read_boards;
 var
  board_file : text;
  i          : integer;

procedure clear_boards;
 var
  x : integer;
 begin
  for x := 0 to 15 do
   begin
    with boards [x] do
     begin
      name := '';
      path := '';
      filename := '';
      Tpath := '';
      Ipath := '';
      validate_access := 'N';
      default_Access := 'N';
     end;
   end;
 end;

 begin
  maxboards := 0;
  clear_boards;
  assign (board_file,'BOARDS.TXT');
  {$I-}
  reset (board_file);
  {$I+}
  if IOresult <> 0 then
   begin
    with boards [0] do
     begin
      name := 'MAIL';
      path := 'A:\';
      Tpath := '';
      Ipath := '';
      filename := 'MAIL';
      default_access := 'I';
      validate_access := 'I';
     end;
    maxboards := succ (maxboards);
    with boards [1] do
     begin
      name := 'General';
      path := 'A:\';
      filename := 'GENERAL';
      Tpath := '';
      Ipath := '';
      default_access := 'W';
      validate_access := 'W';
     end;
    b_changed := true;
   end
  else
   begin
    repeat
     with boards [maxboards] do
      begin
       readln (board_file,name);
       readln (board_file,path);
       readln (board_file,Tpath);
       readln (Board_file,Ipath);
       readln (board_file,filename);
       readln (board_file,default_access);
       readln (board_file,validate_access);
      end;
     if not eof (board_file) then maxboards := succ (maxboards);
    until eof (board_file);
    close (board_file);
   end;
 end;


{PROCEDURE ReadEvents;

 VAR
  EventFile  : TEXT;
  i          : INTEGER;
  j          : BYTE;

PROCEDURE ClearEvents;

 VAR
  X : INTEGER;

 BEGIN
  for x := 1 to 15 do
   BEGIN
    with EventPack [x] do
     BEGIN
      Day       := 0;
      DayOfWeek := 0;
      hour      := 0;
      min       := 0;
      ErrorLevel:= 0;
      Done      := FALSE;
      Forced    :=FALSE;
     END;
   END;
 END;

 begin
  maxEvents := 0;
  clearEvents;
  assign (EventFile, 'EVENTS.TXT');
  $I-
  reset (EventFile);
  $I+
  if IOresult = 0 then
   begin
    MaxEvents := 1;
    repeat
     with EventPack [maxEvents] do
      begin
       Readln (EventFile,Day);
       readln (EventFile,DayofWeek);
       readln (EventFile,Hour);
       readln (EventFile,Min);
       readln (EventFile,ErrorLevel);
       Readln (EventFile,J);
       IF J = 0 THEN Done := FALSE ELSE Done := TRUE;
       readln (EventFile,J);
       IF J = 0 THEN Forced := FALSE ELSE Forced := TRUE;
      end;
     if not eof (EventFile) then maxEvents := succ (maxEvents);
    until eof (EventFile);
    close (Eventfile);
   end;
 end;

PROCEDURE SaveEvents;

 VAR

  EventFile : TEXT;
  i         : INTEGER;
  J         : INTEGER;

 BEGIN
  assign (EventFile,'EVENTS.TXT');
  ReWrite(EventFile);
  for i := 1 to maxEvents Do
   begin
    with EventPack [i] do
     begin
       Writeln (EventFile,Day);
       Writeln (EventFile,DayofWeek);
       Writeln (EventFile,Hour);
       Writeln (EventFile,Min);
       Writeln (EventFile,ErrorLevel);
       IF Done = FALSE THEN J :=0 ELSE J := 1;
       Writeln (EventFile,J);
       IF Forced = FALSE THEN J := 0 ELSE J := 1;
       Writeln (EventFile,J);
     end;
   end;
  close (EventFile);
 end;}


PROCEDURE ChangeProts;
    VAR
    Prots : ARRAY [1..15] of ExternalProtocolRecord;


PROCEDURE ReadProtocols;

 VAR
  ProtFile   : TEXT;
  i          : INTEGER;
  j          : BYTE;

PROCEDURE ClearProtocols;

 VAR
  X : INTEGER;

 BEGIN
  for x := 1 to 15 do
   BEGIN
    with Prots [x] do
     BEGIN
      Name       :='';
      Path       :='';
      UpString   :='';
      DownString :='';
      Command    :='';
      BatchString := '';
     END;
   END;
 END;

 begin
  maxProts := 0;
  clearProtocols;
  assign (ProtFile, 'PROTS.TXT');
  {$I-}
  reset (ProtFile);
  {$I+}
  if IOresult = 0 then
   begin
    MaxProts := 1;
    repeat
     with Prots [maxProts] do
      begin
       Readln (ProtFile,Name);
       readln (ProtFile,Path);
       readln (ProtFile,UpString);
       readln (ProtFile,DownString);
       readln (ProtFile,Command);
       readln (ProtFile,BatchString);
      end;
     if not eof (ProtFile) then maxProts := succ (maxProts);
    until eof (ProtFile);
    close (Protfile);
   end;
 end;


PROCEDURE SaveProts;

 VAR

  ProtFile  : TEXT;
  i         : INTEGER;
  J         : INTEGER;

 BEGIN
  assign (ProtFile,'PROTS.TXT');
  ReWrite(ProtFile);
  for i := 1 to maxProts Do
   begin
    with Prots [i] do
     begin
       Writeln (ProtFile,Name);
       Writeln (ProtFile,Path);
       Writeln (ProtFile,UpString);
       Writeln (ProtFile,DownString);
       Writeln (ProtFile,Command);
       Writeln (ProtFile,BatchString);
     end;
   end;
  close (ProtFile);
 end;

PROCEDURE DoProts;

 VAR
   I        : INTEGER;
   Question : STRING [5];
   tempstr  : STRING [80];
   TempS    : STRING;
   TempS2   : STRING;
   tempint  : INTEGER;
   code     : INTEGER;
   x        : INTEGER;
   TempInt2 : INTEGER;

 CONST
  NameMsg = 'Enter File Area Name';
  PathMsg = 'Enter Protocol Filespec Exp: C:\TP\DSZ.EXE';
  BatcMsg = 'String to proceed batch list';
  UpMsg   = 'Enter Upload command String';
  DnMsg   = 'Enter Download Command String';
  ComdMsg = 'Enter the U/D Command';

 BEGIN
  TempInt := 1;
  I       := 1;
  REPEAT
   BEGIN
    If TempInt = 0 Then TempInt := 1;
    Clrscr;
    Str (config.Port_Num,TempS);
   WITH Prots[I] do
    BEGIN
     PickLst[1] := 'Name         ' + Name;
     PickLst[2] := 'FileSpec     ' + Path;
     PickLst[3] := 'Upstring     ' + Upstring;
     PickLst[4] := 'DownString   ' + DownString;
     PickLst[5] := 'Command      ' + Command;
     If BatchString <> '' THEN TempS := BatchString ELSE TempS := 'NONE';
     PickLst[6] := 'BatchString  ' + TempS;
     PickLst[7] := 'Next';
     PickLst[8] := 'Last';
     PickLst[9] := 'Add';
     PickLst[10] := 'Delete';
     PickLst[11] := 'Jump';
     PickLst[12] := 'Exit';
     Str (I,TempS);
     TempS2 := 'Protocol# '+ TempS;
     TempInt := PickList (PickLst,TempS2,15,4,TempInt,45,12,6,15,1);
     P_changed := true;
     case TempInt of
         1 : BEGIN
             TempStr := Name;
             TempStr := StringBox('Protocol Name','Name:',30,TempStr,NameMsg,14,18,18,15,2);
             if tempstr <> '@@@' then
              BEGIN
               Name := allcaps (tempstr);
              END;
             END;
         2 : BEGIN
              TempStr := Path;
             TempStr := StringBox('Protocol FileSpec','FileSpec:',30,TempStr,PathMsg,14,18,18,15,2);
              IF tempstr <> '@@@' then
               BEGIN
                  Path := allcaps(tempstr);
                 END;
            END;
        3 : BEGIN
             TempStr := UpString;
             TempStr := StringBox('Upload String','String:',30,TempStr,UpMsg,14,18,18,15,2);
             if tempstr <> '@@@' then
              BEGIN
               UpString := tempstr;
              END;
             END;
        4 : BEGIN
             TempStr := DownString;
             TempStr := StringBox('Download String','String:',30,TempStr,DnMsg,14,18,18,15,2);
             if tempstr <> '@@@' then
              BEGIN
               DownString := tempstr;
              END;
             END;
        5 : BEGIN
             TempStr := Command;
             TempStr := StringBox('Command String','String:',30,TempStr,ComdMsg,14,18,18,15,2);
             if tempstr <> '@@@' then
              BEGIN
               Command := tempstr;
              END;
             END;
        6 : BEGIN
             TempStr := BatchString;
             TempStr := StringBox('BatchString','String:',30,TempStr,BatcMsg,14,18,18,15,2);
             if tempstr <> '@@@' then
              BEGIN
               BatchString := tempstr;
              END;
             END;
        9  : BEGIN
              IF maxProts < 15 then
               BEGIN
                MaxProts := succ (MaxProts);
                I:= MaxProts;
               END;
             END;
       END {of case}
    END; {of with}
    IF (TempInt = 10) and (MaxProts > 1) THEN
     BEGIN
      IF I = MaxProts THEN
       BEGIN
        WITH Prots [i] do
         BEGIN
          name := '';
          Path := '';
          UpString :='';
          DownString :='';
          Command :='';
         end;
        maxProts := pred (maxProts);
        i := pred (i);
       end
      else
       begin
        for x := i to (maxProts - 1) do Prots [x] := Prots [x + 1];
        with Prots [maxProts] do
         begin
          name := '';
          Path := '';
          UpString :='';
          DownString :='';
          Command :='';
         end;
        maxProts := pred (MaxProts);
       end;
     end;
    if (tempInt = 7) then if i < maxProts then i := succ (i) else i := 1;
    if (tempInt = 8) then if i > 1 then i := i - 1 else if i = 1 then i := maxProts;
    IF TempInt = 11 THEN
     BEGIN
      TempStr := StringBox('Jump','To:',6,'','',25,18,18,15,2);
       if tempstr <> '@@@' then
          BEGIN
            Val (TempStr,TempInt2,Code);
            if (code = 0) and (tempint2 <= maxProts) and (tempint2 >= 1) then
            i := tempint2;
           END;
       END;
      END;
  until (TempInt = 12);
 end;

 BEGIN {MAIN}
  ReadProtocols;
  DoProts;
  If P_Changed THEN SaveProts;
 END;


PROCEDURE ChangeBulletins;
    VAR
    Bulls : ARRAY [1..25] of Bulletin_Record;
    BullFile : TEXT;
      B_Changed  : BOOLEAN;
      MaxBulls   : INTEGER;


PROCEDURE GetBulletins;

 VAR
  BullFile   : TEXT;
  i          : INTEGER;
  j          : BYTE;

PROCEDURE ClearBulletins;

 VAR
  X : INTEGER;

 BEGIN
  for x := 1 to 25 do
   BEGIN
    with Bulls [x] do
     BEGIN
      Name       :='';
      FileName   :='';
     END;
   END;
 END;

 begin
  maxBulls := 0;
  clearBulletins;
  assign (BullFile, 'BULLS.TXT');
  {$I-}
  reset (BullFile);
  {$I+}
  if IOresult = 0 then
   begin
    MaxBulls := 1;
    repeat
     with Bulls [maxBulls] do
      begin
       Readln (BullFile,Name);
       readln (BullFile,FileName);
      end;
     if not eof (BullFile) then maxBulls := succ (maxBulls);
    until eof (BullFile);
    close (Bullfile);
   end;
 end;


PROCEDURE SaveBulls;

 VAR

  BullFile  : TEXT;
  i         : INTEGER;
  J         : INTEGER;

 BEGIN
  assign (BullFile,'BULLS.TXT');
  ReWrite(BullFile);
  for i := 1 to maxBulls Do
   begin
    with Bulls [i] do
     begin
       Writeln (BullFile,Name);
       Writeln (BullFile,Filename);
     end;
   end;
  close (BullFile);
 end;

PROCEDURE DoBulls;
 VAR
   I        : INTEGER;
   Question : STRING [5];
   tempstr  : STRING [80];
   TempS    : STRING;
   TempS2   : STRING;
   tempint  : INTEGER;
   code     : INTEGER;
   x        : INTEGER;
   TempInt2 : INTEGER;

 CONST
  NameMsg = 'Enter Bulletin Name';
  PathMsg = 'Enter Bulletin Filespec Exp: C:\TOP\B1.TXT';
  LevMsg  = 'Enter Access Level (1-255)';

 BEGIN
  TempInt := 1;
  I       := 1;
  REPEAT
   BEGIN
    If TempInt = 0 Then TempInt := 1;
    Clrscr;
    Str (config.Port_Num,TempS);
   WITH Bulls[I] do
    BEGIN
     PickLst[1] := 'Name         ' + Name;
     PickLst[2] := 'FileSpec     ' + FileName;
     PickLst[3] := 'Next';
     PickLst[4] := 'Last';
     PickLst[5] := 'Add';
     PickLst[6] := 'Delete';
     PickLst[7] := 'Jump';
     PickLst[8] := 'Exit';
     Str (I,TempS);
     TempS2 := 'Bulletin# '+ TempS;
     TempInt := PickList (PickLst,TempS2,15,5,TempInt,45,8,6,15,1);
     B_Changed := TRUE;
     CASE TempInt OF
       1 : BEGIN
             If MaxBulls = 0 THEN MaxBulls := 1;
             TempStr := Name;
             TempStr := StringBox('Bulletin Name','Name:',30,TempStr,NameMsg,14,18,18,15,2);
             if tempstr <> '@@@' then
              BEGIN
               Name := tempstr;
              END;
             END;
       5 : BEGIN
            IF maxBulls < 26 then
              BEGIN
              MaxBulls := succ (MaxBulls);
              I := MaxBulls
               END;
             END;
        2 : BEGIN
             TempStr := FileName;
             TempStr := StringBox('Bulletin Filespec','Filespec:',30,TempStr,pathMsg,14,18,18,15,2);
             if tempstr <> '@@@' then
              BEGIN
               FileName := Allcaps(tempstr);
              END;
             END;
       END {of case}
    END; {of with}
    IF (TempInt = 6) and (MaxBulls > 1) THEN
     BEGIN
      IF I = MaxBulls THEN
       BEGIN
        WITH Bulls [i] do
         BEGIN
          name := '';
          FileName := '';
         end;
        maxBulls := pred (maxBulls);
        i := pred (i);
       end
      else
       begin
        for x := i to (maxBulls - 1) do Bulls [x] := Bulls [x + 1];
        with Bulls [maxBulls] do
         begin
          name := '';
          FileName := '';
         end;
        maxBulls := pred (MaxBulls);
       end;
     end;
    if (TempInt = 3) then if i < maxBulls then i := succ (i) else i := 1;
    if (TempInt = 4) then if i > 1 then i := i - 1 else if i = 1 then i := maxBulls;
    IF (TempInt = 7) THEN
    BEGIN
      TempStr := StringBox('Jump','To:',6,'','',25,18,18,15,2);
       if tempstr <> '@@@' then
          BEGIN
            Val (TempStr,TempInt2,Code);
            if (code = 0) and (tempint2 <= maxbulls) and (tempint2 >= 1) then
            i := tempint2;
           END;
       END;
    END;
  until (TempInt = 8);
 end;

 BEGIN {MAIN}
  GetBulletins;
  DoBulls;
  If B_Changed THEN SaveBulls;
 END;


 procedure clear_bulletins;
  var
   x : integer;
  begin
   {for x := 1 to 20 do
    with Config.bulletpack [x] do
     begin
      name := '';
      filename := '';
      path     := '';
     end;}
  end;


procedure read_doors;
 var
  b_file : text;
  i      : integer;
 procedure clear_doors;
  var
   x : integer;
  begin
   for x := 1 to 15 do
    with doors [x] do
     begin
      name := '';
      dos_code := 0;
      level := 0;
      FileName :='';
      Ratio := 0;
    end;
  end;

 begin
   maxdoors := 1;
   clear_DOORS;
   assign (b_file,'DOORS.TXT');
   {$I-}
   reset (b_file);
   {$I+}
   if IOresult <> 0 then
    begin
      with doors [1] do
       begin
        name     := 'NONE';
        level    := 255;
        dos_code := 0;
        FileName :='C:\TOP\DORINFO1.DEF';
        Ratio    := 100;
       end;
      d_changed := true;
    end
   else
    begin
     repeat
       with doors [maxdoors] do
        begin
         readln (b_file,name);
         readln (b_file,level);
         readln (b_file,dos_code);
         Readln (B_file,FileName);
         Readln (B_file,Ratio);
        end;
       if not eof (b_file) then maxdoors := succ (maxdoors);
     until eof (b_file);
     close (b_file);
    end;
 end;




procedure get_boards;
 VAR
   I        : INTEGER;
   Question : STRING [5];
   tempstr  : STRING [80];
   TempS    : STRING;
   TempS2   : STRING;
   tempint  : INTEGER;
   code     : INTEGER;
   x        : INTEGER;
   TempInt2 : INTEGER;

 CONST
  NameMsg = 'Enter Message Area Name';
  PathMsg = 'Enter Directory Exp: C:\TOP\MSG\';
  FileMsg = 'Enter Filename Example: AREA';
  LevMsg  = 'Enter Access Level (1-255)';
  TpatMsg = 'Enter Directory for Text Save';
  IpatMsg = 'Enter Directory for Text Import';

 BEGIN
  TempInt := 1;
  I       := 0;
  REPEAT
   BEGIN
    If TempInt = 0 Then TempInt := 1;
    Clrscr;
    Str (config.Port_Num,TempS);
   WITH Boards[I] do
    BEGIN
     PickLst[1] := 'Name                  ' + Name;
     PickLst[2] := 'Directory             ' + Path;
     PickLst[3] := 'Text Save Directory   ' + Tpath;
     PickLst[4] := 'Text Import Directory ' + Ipath;
     PickLst[5] := 'Filename              ' + filename;
     PickLst[6] := 'Default Access        ' + default_access;
     PickLst[7] := 'Validated Access      ' + Validate_access;
     PickLst[8] := 'Next';
     PickLst[9] := 'Last';
     PickLst[10] := 'Add';
     PickLst[11] := 'Delete';
     PickLst[12] := 'Jump';
     PickLst[13] := 'Exit';
     Str (I,TempS);
     TempS2 := 'Message Area# '+ TempS;
     TempInt := PickList (PickLst,TempS2,12,1,TempInt,57,13,6,15,1);
     B_Changed := TRUE;
     CASE TempInt OF
       1 : BEGIN
             TempStr := Name;
             TempStr := StringBox('Area Name','Name:',30,TempStr,NameMsg,14,18,18,15,2);
             if tempstr <> '@@@' then
              BEGIN
               Name := tempstr;
              END;
             END;
        2 : BEGIN
             TempStr := Path;
             TempStr := StringBox('Message Area Directory','Directory:',30,TempStr,pathMsg,14,18,18,15,2);
             if tempstr <> '@@@' then
              BEGIN
               if tempstr [length(tempstr)] <> '\' then tempstr := tempstr + '\';
               Path := Allcaps(tempstr);
              END;
             END;
        3 : BEGIN
             TempStr := Tpath;
             TempStr := StringBox('Text Save Path','Path:',30,TempStr,TpatMsg,14,18,18,15,2);
             IF TempStr <> '' THEN
              if tempstr [length(tempstr)] <> '\' then tempstr := tempstr + '\';
             Tpath := allcaps(tempstr);
            END;
        4 : BEGIN
             TempStr := Ipath;
             TempStr := StringBox('Text Import Path','Path:',30,TempStr,IpatMsg,14,18,18,15,2);
             IF TempStr <> '' THEN
              if tempstr [length(tempstr)] <> '\' then tempstr := tempstr + '\';
             Ipath := allcaps(tempstr);
            END;
        5 : BEGIN
             TempStr := Filename;
             TempStr := StringBox('Filename','Name:',30,TempStr,FileMsg,14,18,18,15,2);
             if tempstr <> '@@@' then
              BEGIN
               FileName := allcaps(tempstr);
              END;
             END;
       6 : BEGIN
            PickLst[1] := 'Invisible';
            PickLst[2] := 'None';
            PickLst[3] := 'Write';
            PickLst[4] := 'Read';
            PickLst[5] := 'Maintance';
            PickLst[6] := 'CoSysop';
            TempInt2 := PickList (PickLst,'Default Access',20,17,1,20,6,6,15,2);
            CASE TempInt2 of
             1 : Default_Access := 'I';
             2 : Default_Access := 'N';
             3 : Default_Access := 'W';
             4 : Default_Access := 'R';
             5 : Default_Access := 'M';
             6 : Default_Access := 'C';
            END;
           END;
       7 : BEGIN
            PickLst[1] := 'Invisible';
            PickLst[2] := 'None';
            PickLst[3] := 'Write';
            PickLst[4] := 'Read';
            PickLst[5] := 'Maintance';
            PickLst[6] := 'CoSysop';
            TempInt2 := PickList (PickLst,'Validated Access',20,17,1,20,6,6,15,2);
            CASE TempInt2 of
             1 : Validate_Access := 'I';
             2 : Validate_Access := 'N';
             3 : Validate_Access := 'W';
             4 : Validate_Access := 'R';
             5 : Validate_Access := 'M';
             6 : Validate_Access := 'C';
            END;
           END;
        10 : BEGIN
            IF maxBoards < 15 then
              BEGIN
              MaxBoards := succ (MaxBoards);
              I := MaxBoards
               END;
             END;
       end {of case}
    end; {of with}
    if (TempInt = 11) and (maxboards > 1) then
     begin
      if i = maxboards then
       begin
        with boards [i] do
         begin
          name := '';
          path := '';
          validate_access :='N';
          default_access := 'N';
          filename := '';
         end;
        maxboards := pred (maxboards);
        i := pred (i);
       end
      else
       begin
        for x := i to (maxboards - 1) do boards [x] := boards [x + 1];
        with boards [maxboards] do
         begin
          name := '';
          filename := '';
          path := '';
          validate_access := 'N';
          default_access := 'N';
         end;
        maxboards := pred (maxboards);
       end;
     end;
    if TempInt = 12 then
     begin
      TempStr := StringBox('Jump','To:',6,'','',25,18,18,15,2);
       if tempstr <> '@@@' then
          BEGIN
            Val (TempStr,TempInt2,Code);
            if (code = 0) and (tempint2 <= maxboards) and (tempint2 >= 0) then
            i := tempint2;
           END;
     end;

    if (TempInt = 8) then
       if i < maxboards then i := succ (i)
         else i := 0;
    if (TempInt = 9) then if i > 0 then i := i - 1 else if i = 0 then i := maxboards;
   END;
  until (TempInt = 13);
 end;



PROCEDURE Prompt_Config;

   CONST
     BoardName     =  'Public';
     UserName      =  'Joe Sample';
     TimeLeft      =  '40';
     NewMessages   =  '5';
     TotalMessages =  '105';
     Message_Area  =  '1';

Var
   QUIT : BOOLEAN;

function main_prompt : STRING;
 var
  tempSTR : string[15];
  totalSTR : string[80];
  i        : integer;


 begin
   i := 1;
   totalSTR := '';
   while (i <= length (Config.promptSTR)) do
    begin
     case Config.promptSTR [i] of
      '@' : totalSTR := totalSTR + BoardName;
      '`' : totalSTR := totalSTR + Message_Area;
      '~' : totalSTR := totalSTR + TimeLeft;
      '%' : totalSTR := totalSTR + TotalMessages;
      '^' : totalSTR := totalSTR + NewMessages;
      '&' : totalSTR := totalSTR + username;
      '_' : totalSTR := totalSTR + ' ';
      else totalSTR := totalSTR + Config.promptSTR [i];
     end;
     i := succ (i);
    end;
   main_prompt := totalSTR;
 end;

PROCEDURE ListCommands;
   BEGIN
     ClearScreen;
     WriteLine (' ');
     WriteLine (' ');
     WriteLine (' ');
     WriteLine ('Valid Parser Commands: ');
     WriteLine (' ');
     WriteLine ('@ - Name of Current Board');
     WriteLine ('` - Number of Current Board');
     WriteLine ('% - Number of Total Messages on Current Board');
     WriteLine ('^ - Number of New Messages on Current Board');
     WriteLine ('~ - Current User`s Remaining Time');
     WriteLine ('& - Current User`s Name');
     WriteLine ('_ - Space');
     WriteLine (' ');
   END;

PROCEDURE PrintCurrentPrompt;
   BEGIN
    WriteString('Current Prompt- ');
    WriteLine (Config.PromptSTR);
    WriteString('Parsed Prompt-  ');
    WriteLine (Main_Prompt);
    WriteLine (' ');
   END;

PROCEDURE ChangeAfterChat;
   BEGIN
     ClearScreen;
     WriteLine (' ');
     WriteLine (' ');
     WriteLine (' ');
     WriteLine (' ');
     WriteLine ('Current Message Displayed after Chat Request:');
     WriteLine (' ');
     WriteLine (Config.AfterChat);
     WriteLine (' ');
     WriteLine ('Enter New Message or <Return>');
     WriteLine (' ');
     WriteString (': ');
     ReadLn (tempstr);
     If TempStr <> '' Then Config.AfterChat := TempStr;
   END;

PROCEDURE ChangeTooManyChat;
   BEGIN
     ClearScreen;
     WriteLine (' ');
     WriteLine (' ');
     WriteLine (' ');
     WriteLine (' ');
     WriteLine ('Current Message Displayed TOO MANY Chat Requests:');
     WriteLine (' ');
     WriteLine (Config.TooManyChat);
     WriteLine (' ');
     WriteLine ('Enter New Message or <Return>');
     WriteLine (' ');
     WriteString (': ');
     ReadLn (tempstr);
     If TempStr <> '' Then Config.TooManyChat := TempStr;
   END;

PROCEDURE ChangeChatIn;
  BEGIN
   ClearScreen;
   WriteLine (' ');
   WriteLine (' ');
   WriteLine (' ');
   WriteLine (' ');
   WriteLine ('Current Opening Chat Message:');
   WriteLine (' ');
   WriteLine (Config.ChatIn);
   WriteLine (' ');
   WriteLine ('Enter New Opening Chat Message or <Return>');
   WriteLine (' ');
   WriteString(': ');
   ReadLn (tempstr);
   If TempStr <>'' Then Config.ChatIn := TempStr;
  END;

PROCEDURE ChangeChatOut;
  BEGIN
   ClearScreen;
   WriteLine (' ');
   WriteLine (' ');
   WriteLine (' ');
   WriteLine (' ');
   WriteLine ('Current Closing Chat Message:');
   WriteLine (' ');
   WriteLine (Config.ChatOut);
   WriteLine (' ');
   WriteLine ('Enter New Closing Chat Message or <Return>');
   WriteLine (' ');
   WriteString(': ');
   ReadLn (tempstr);
   If TempSTr <> '' Then Config.ChatOut := TempStr;
  END;

PROCEDURE ChangeChatMessage;
  BEGIN
   ClearScreen;
   WriteLine (' ');
   WriteLine (' ');
   WriteLine (' ');
   WriteLine (' ');
   WriteLine ('Current Page Message:');
   WriteLine (' ');
   WriteLine (Config.ChatCall1);
   WriteLine (' ');
   WriteLine ('Enter new Sysop Page Message or <Return>');
   WriteLine (' ');
   WriteString(': ');
   ReadLn (tempstr);
   If TempStr <> '' Then Config.ChatCall1 := TempStr;
  END;

PROCEDURE ChangePrompt;
  BEGIN
   ListCommands;
   PrintCurrentPrompt;
   WriteLine (' ');
   WriteLine ('Enter New Main Prompt or <Return>');
   WriteLine (' ');
   WriteString(': ');
   ReadLn (tempstr);
   If TempStr <> '' Then Config.PromptStr := TempStr;
  END;


BEGIN {PromptConfigure}
    REPEAT
     BEGIN
     ClearScreen;
      WriteLine ('Prompt Setup.');
      WriteLine (' ');
      WriteLine ('1....Change Opening Chat Message');
      WriteLine ('2....Change Closing Chat Message');
      WriteLine ('3....Change Page Message');
      WriteLine ('4....Change Message AFTER page');
      WriteLine ('5....Change Message AFTER too many Chat Attempts');
      WriteLine ('6....Change Main Prompt');
      WriteLine ('7....Quit');

      WriteString('Enter Choice: ');
      ReadLn (tempstr);
      Val(TempStr,TempInt,Code);
      If TempStr ='' Then TempInt :=0;
     Case TempInt Of
        1:ChangeChatIn;
        2:ChangeChatOut;
        3:ChangeChatMessage;
        4:ChangeAfterChat;
        5:ChangeTooManyChat;
        6:ChangePrompt;
        7:Quit := TRUE;
      END
     END; {repeat}
    Until (Quit = TRUE)
  END;



procedure get_doors;

 VAR
   I        : INTEGER;
   Question : STRING [5];
   tempstr  : STRING [80];
   TempS    : STRING;
   TempS2   : STRING;
   tempint  : INTEGER;
   code     : INTEGER;
   x        : INTEGER;
   TempInt2 : INTEGER;

 CONST
  NameMsg = 'Enter Door Area Name';
  PathMsg = 'Enter Directory Exp: C:\TOP\MSG\';
  FileMsg = 'Enter Filespec Exp: C:\TOP\DORINFO.DEF';
  LevMsg  = 'Enter Access Level (1-255)';
  DosMsg  = 'Enter the Dos Errorlevel (1-255)';

 BEGIN
  TempInt := 1;
  I       := 1;
  REPEAT
   BEGIN
    If TempInt = 0 Then TempInt := 1;
    Clrscr;
    Str (config.Port_Num,TempS);
   WITH Doors[I] do
    BEGIN
     PickLst[1] := 'Name             ' + Name;
     Str(Level,TempS);
     PickLst[2] := 'Level            ' + TempS;
     Str(Dos_Code,TempS);
     PickLst[3] := 'Dos Code         '+ TempS;
     PickLst[4] := 'Info File        '+ FileName;
     PickLst[5] := 'Next';
     PickLst[6] := 'Last';
     PickLst[7] := 'Add';
     PickLst[8] := 'Delete';
     PickLst[9] := 'Jump';
     PickLst[10] := 'Exit';
     Str (I,TempS);
     TempS2 := 'Door# '+ TempS;
     TempInt := PickList (PickLst,TempS2,15,2,TempInt,45,10,6,15,1);
     D_Changed := TRUE;
     Ratio := 1;
     CASE TempInt OF
       1 : BEGIN
             TempStr := Name;
             TempStr := StringBox('Door Name','Name:',30,TempStr,NameMsg,14,18,18,15,2);
             if tempstr <> '@@@' then
              BEGIN
               Name := tempstr;
              END;
             END;
        4 : BEGIN
             TempStr := FileName;
             TempStr := StringBox('Info Filespec','Filespec:',30,TempStr,fileMsg,14,18,18,15,2);
             if tempstr <> '@@@' then
              BEGIN
               FileName := Allcaps(tempstr);
              END;
             END;
        4 : BEGIN
             TempStr := Filename;
             TempStr := StringBox('FileSpec','FileSpec:',30,TempStr,FileMsg,14,18,18,15,2);
             if tempstr <> '@@@' then
              BEGIN
               FileName := allcaps(tempstr);
              END;
             END;
       7 : BEGIN
            IF maxDoors < 16 then
              BEGIN
              MaxDoors := succ (MaxDoors);
              I := MaxDoors
               END;
             END;
        2  : BEGIN
             Str(Level,TempStr);
             TempStr := StringBox('Level','Level:',30,TempStr,LevMsg,14,18,18,15,2);
              if tempstr <> '@@@' then
              BEGIN
               Val (TempStr,TempInt2,Code);
               If (TempInt2 > 0) and (TempInt2 < 256) THEN
               Level := tempInt2;
              END;
             END;
        3  : BEGIN
             Str(Dos_Code,TempStr);
             TempStr := StringBox('Dos Code','Code:',30,TempStr,DosMsg,14,18,18,15,2);
              if tempstr <> '@@@' then
              BEGIN
               Val (TempStr,TempInt2,Code);
               If (TempInt2 > 0) and (TempInt2 < 256) THEN
               Dos_Code := tempInt2;
              END;
             END;
       end {of case}
    end; {of with}
    if (TempInt = 8) and (maxdoors > 1) then
     begin
      if i = maxdoors then
       begin
        with doors [i] do
         begin
          name := '';
          level := 0;
          dos_code := 0;
         end;
        maxdoors := pred (maxdoors);
        i := pred (i);
       end
      else
       begin
        for x := i to (maxdoors - 1) do doors [x] := doors [x + 1];
        with doors [maxdoors] do
         begin
          name := '';
          level := 0;
          dos_code := 0;
         end;
        maxdoors := pred (maxdoors);
       end;
     end;
    if (TempInt = 5) then if i < maxdoors then i := succ (i) else i := 1;
    if (TempInt = 6) then if i > 1 then i := i - 1 else if i = 1 then i := maxdoors;
    If TempInt = 9 THEN
     TempStr := StringBox('Jump','To:',6,'','',25,18,18,15,2);
       if tempstr <> '@@@' then
          BEGIN
            Val (TempStr,TempInt2,Code);
            if (code = 0) and (tempint2 <= maxdoors) and (tempint2 >= 1) then
            i := tempint2;
           END;
       END;
  until (Tempint = 10);
 end;



procedure save_doors;
 var
  b_file : text;
  i      : integer;
 begin
  assign (b_file,'DOORS.TXT');
  ReWrite(b_file);
  for i := 1 to maxdoors do
   begin
    with doors [i] do
     begin
      WriteLn (b_file,name);
      writeln (b_file,level);
      writeln (b_file,dos_code);
      Writeln (B_File,FileName);
      Writeln (B_File,Ratio);
     end;
   end;
  close (b_file);
 end;



procedure save_boards;
 var
  board_file : text;
  i          : integer;
 begin
  assign (board_file,'BOARDS.TXT');
  rewrite (board_file);
  for i := 0 to maxboards do
   begin
    with boards [i] do
     begin
      writeln (board_file,name);
      writeln (board_file,path);
      Writeln (Board_File,Tpath);
      Writeln (Board_File,IPath);
      writeln (board_file,filename);
      writeln (board_file,default_access);
      writeln (board_file,validate_access);
     end;
    end;
  close (board_file);
 end;



procedure save_config;
 var
  c_file : File of Config_Record;
  i      : integer;
 begin
  assign (c_file,Config_Filename);
  rewrite (c_file);
  Write (C_File,Config);
   close (c_file);
 end;

BEGIN
 ClrScr;
 Read_Config;
 B_Changed    := FALSE;
 P_Changed    := FALSE;
 f_changed    := FALSE;
 bull_changed := FALSE;
 TempInt      := 1;
 Clear_bulletins;
 Read_Boards;
 Read_Doors;
 ReadFiles;


 REPEAT
    ClrScr;
    IF TempInt = 0 THEN TempInt := 1;
    PickLst[1] := 'Access Levels';
    PickLst[2] := 'Bulletins';
    PickLst[3] := 'Directories';
    PickLst[4] := 'Doors';
    PickLst[5] := 'File Areas';
    PickLst[6] := 'General';
    PickLst[7] := 'Message Areas';
    PickLst[8] := 'Modem';
    PickLst[9] := 'Prompts';
    PickLst[10] := 'Transfer Protocols';
    PickLst[11] := 'System Info';
    PickLst[12] := 'Save And Exit';
    TempInt := Picklist (Picklst,'QCONFIG 1.0',30,5,TempInt,20,12,4,15,2);
    CASE TempInt of
      1 : Levels;
      2 : ChangeBulletins;
      3 : DriveAndFiles;
      4 : Get_Doors;
      5 : ChangeFiles;
      6 : Misc_Stuff;
      7 : Get_Boards;
      8 : ModemConfig;
      9 : Prompt_Config;
      10: ChangeProts;
      11: SysInfo;
    END;
 UNTIL (TempInt = 12);
 ClrScr;
 Save_Config;
 IF B_Changed then Save_Boards;
 IF D_Changed then Save_Doors;
 IF F_Changed then SaveFiles;
END.
