
UNIT Str;

INTERFACE

USES Dos, Qbbs;


FUNCTION Padr    (InputSt : STRING; Num : INTEGER) : STRING;
FUNCTION AllCaps (St: STRING): STRING;
FUNCTION Clipr   (St: STRING): STRING;
FUNCTION Clipl   (St: STRING): STRING;
FUNCTION Clip    (St: STRING): STRING;
FUNCTION Strr    (R: REAL) : STRING;
FUNCTION Stri    (I: INTEGER): STRING;
FUNCTION Strif   (I, P : INTEGER): STRING;
FUNCTION Striz   (I, P : INTEGER): STRING;
FUNCTION BackToI (INP: STRING): INTEGER;
FUNCTION Strt    (T: Time_TYPE): STRING;
FUNCTION Strd    (D: Date_TYPE): STRING;
PROCEDURE Reformat_Date (VAR date: STRING; Month, Day, Year: BYTE);
PROCEDURE Reformat_Time (VAR Time: STRING; Hour, Min: BYTE);


IMPLEMENTATION

procedure reformat_date(var date : STRING; month, day, year : byte);
 const
  month_record : array [1..12] of string[3] =
     ('Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec');

 var
  daySTR : string[5];
  monthSTR : string[5];
  yearSTR  : string[5];
 begin
   daySTR := '';
   monthSTR := '';
   yearSTR := '';
   Str(day,daySTR);
   Str(year,yearSTR);
   monthSTR := month_record [month];
   date := monthSTR + ' ' + daySTR + ', ' + yearSTR;
 end;


procedure reformat_time(var time : STRING; hour, min : byte);
 var
  night : boolean;
  timeSTR : string[5];
 begin
  night := false;
  if (hour > 11) then
    begin
      night := true;
      hour := hour - 12;
    end;
  if hour = 0 then hour := 12;
  str (hour,time);
  str (min,timeSTR);
  if min < 10 then timeSTR := '0' + timeSTR
   else if length(timeSTR)  = 1 then timestr := timestr + '0';
  time := time  + ':' + timeSTR;
  if night then time := time + 'pm' else time := time + 'am';
 end;


function padr (inputst : STRING; num : integer) : STRING;
 var
  i : integer;
  st: anystring;
 begin
  st := inputst;
  for i := (length (st) + 1) to num do st := st + ' ';
  padr := st;
 end;


FUNCTION allcaps (st: STRING): STRING;
VAR
  i: Byte;
BEGIN
  FOR i := 1 TO Length (st) DO st [i] := Upcase (st [i] );
  allcaps := st;
END;

FUNCTION clipr (st: STRING): STRING;
BEGIN
  WHILE (Length (st) > 0) AND (st [Length (st) ] = ' ') DO
    st [0] := Chr (Ord (st [0] ) - 1);
  clipr := st;
END;

FUNCTION clipl (st: STRING): STRING;
BEGIN
  WHILE (Length (st) > 0) AND (st [1] = ' ') DO
    st := Copy (st, 2, 255);
  clipl := st;
END;

FUNCTION clip (st: STRING): STRING;
BEGIN
  clip := clipr (clipl (st) );
END;


FUNCTION strr (r: Real): STRING;
VAR
  st: String [30];
BEGIN
  str (r:20:0, st);
  strr := clip (st);
END;

FUNCTION stri (i: Integer): STRING;
VAR
  st: String [6];
BEGIN
  str (i, st);
  stri := st;
END;

FUNCTION strif (i, p: Integer): STRING;
VAR
  st: String [80];
BEGIN
  str (i:p, st);
  strif := st;
END;

FUNCTION striz (i, p: Integer): STRING;
VAR
  st: String [80];
  j : Byte;
BEGIN
  str (i:p, st);
  FOR j := 1 TO Length (st) - 1 DO
    IF st [j] = ' ' THEN st [j] := '0';
  striz := st;
END;


FUNCTION backtoi (inp : STRING): integer;
 var
  code : integer;
  counter : integer;
  i       : integer;
 begin
  Val (inp,i,code);
  backtoi := i;
 end;


FUNCTION strt (t: time_type): STRING;
 var
  tempstring : string[10];
BEGIN
  reformat_time (tempstring, t.hour, t.min);
  strt := tempstring;
END;

FUNCTION strd (d: date_type): STRING;
 var
  tempdate : string[10];
BEGIN
  reformat_date (tempdate, d.month, d.day, d.year);
  strd := tempdate;
END;


