



UNIT SpaceStf;

INTERFACE
  USES Dos,QBBS;

  PROCEDURE DiskSpace (Drive : BYTE; VAR TotalSpace,SpaceLeft : REAL);
  PROCEDURE SetError;
  PROCEDURE CurrentTime (VAR TimePackage : Time_Type);
  PROCEDURE CurrentDate (VAR DatePackage : Date_Type);
  PROCEDURE ReformatDate( VAR Date : STRING; Month, Day, Year, DayOfWeek : WORD);
  PROCEDURE reformat_time(var time : STRING; hour, min : byte);
  FUNCTION strt (t: time_type): STRING;
  FUNCTION strd (d: date_type): STRING;
  FUNCTION Hash (st: STRING): INTEGER;
  FUNCTION FindHash(TargetName: STRING; VAR FilePointer : INTEGER) : BOOLEAN;
  FUNCTION FindAlias(TargetName: STRING; VAR FilePointer : INTEGER) : BOOLEAN;
  PROCEDURE ReadRec (I:INTEGER);


IMPLEMENTATION

PROCEDURE ReadRec (I:INTEGER);


 BEGIN
   Seek (CurFile,I);
   Read (CurFile,FileRecord);
 END;


PROCEDURE DiskSpace (Drive : BYTE; VAR TotalSpace,SpaceLeft : REAL);

  BEGIN
    TotalSpace := DiskSize (Drive);
    SpaceLeft  := DiskFree (Drive);
  END;


PROCEDURE SetError;
 TYPE
    RegByte = Registers;
VAR
  Regw    : Registers;
  Regb    : RegByte absolute RegW;
  Nowtime : Time_Type;
  b_file  : TEXT;

BEGIN
  writeln ('Writing BBS data file...');
  assign (b_file,Config.miscpath + 'DOOR.DAT');
  rewrite (b_file);
  case current_speed of
   slow : writeln (b_file,'300');
   fast : writeln (b_file,'1200');
   very_fast : writeln (b_file,'2400');
  end;
  writeln (b_file,user.name);
  CurrentTime (NowTime);
  Writeln (B_File,NowTime.Hour);
  Writeln (B_File,NowTime.Min);
  close (b_file);
  regb.ah := 76;
  if dos_error_level = 3 then regB.al := door_num
  ELSE
  IF Dos_Error_Level = 4 Then RegB.al := 4
  ELSE regB.al := 1;
  msdos (regw);
end;

PROCEDURE CurrentTime (VAR TimePackage : time_type);

   VAR
     Dummy : WORD;

   BEGIN
    WITH Timepackage DO
     BEGIN
      GetTime (hour,min,sec,dummy);
     END;
   END;


PROCEDURE CurrentDate (VAR DatePackage : Date_Type);

   BEGIN
    WITH DatePackage DO
     BEGIN
      GetDate (Year,Month,Day,DayOfWeek);
     END;
   END;


PROCEDURE ReformatDate( VAR Date : STRING; Month, Day, Year, DayOfWeek : WORD);
 const
  MonthRecord : ARRAY [1..12] of STRING[12] =

     ('January',
      'Febuary',
      'March',
      'April',
      'May',
      'June',
      'July',
      'August',
      'September',
      'October',
      'November',
      'December');

  DayRecord : ARRAY [0..6] of String[10] =

     ('Sunday',
      'Monday',
      'Tuesday',
      'Wednesday',
      'Thursday',
      'Friday',
      'Saturday');


 VAR
  daySTR   : STRING[5];
  monthSTR : STRING[12];
  yearSTR  : STRING;
  WeekSTR  : STRING[10];


 BEGIN
   DaySTR   := '';
   MonthSTR := '';
   YearSTR  := '';
   WeekSTR  := '';
   Str(day,daySTR);
   Str(year,yearSTR);
   WeekSTR  :=  DayRecord [DayOfWeek];
   monthSTR := MonthRecord [Month];
   Date := WeekSTR + ', '+ MonthSTR + ' ' + DaySTR + ', ' + YearSTR;
 END;


procedure reformat_time(var time : STRING; hour, min : byte);
 var
  night : boolean;
  timeSTR : string[5];
 begin
  night := false;
  if (hour > 11) then
    begin
      night := true;
      hour := hour - 12;
    end;
  if hour = 0 then hour := 12;
  str (hour,time);
  str (min,timeSTR);
  if min < 10 then timeSTR := '0' + timeSTR
   else if length(timeSTR)  = 1 then timestr := timestr + '0';
  time := time  + ':' + timeSTR;
  if night then time := time + 'pm' else time := time + 'am';
 end;

FUNCTION strt (t: time_type): STRING;
 var
  tempstring : string;
BEGIN
  reformat_time (tempstring, t.hour, t.min);
  strt := tempstring;
END;

FUNCTION strd (d: date_type): STRING;
 var
  tempdate : string;
BEGIN
  ReformatDate (tempdate, d.month, d.day, d.year,D.DayOfWeek);
  strd := tempdate;
END;

FUNCTION Hash (st: STRING): INTEGER;

VAR
  i: Byte;
  temp:BYTE;



BEGIN {hash}
  Temp :=0;
  FOR i := 1 TO Length (st) DO
    Temp := Temp + ord(ST[i]);
  hash := Temp;
END;

FUNCTION FindHash(TargetName: STRING; VAR FilePointer : INTEGER) : BOOLEAN;
 var
  name : integer;
  found   : boolean;
  i       : integer;


 begin
   name := hash (targetname);
   found := false;
   i := 0;
   {I-}
    reset (Userfile);
   {I+}
  { IF IOResult <>0 THEN
     BEGIN}
      while (not found) and (i <= maxusers) do
       begin
       if name = userindex[i].name then
         begin
          seek(userfile,userindex [i].recordnumber);
          read(userfile,tempuser);
          if targetname = tempuser.name then found := true else i := i + 1;
         end
       else i := i + 1;
     end;
   FilePointer := i;
   FindHash := found;
{  END
   ELSE BEGIN
         Writeln( '-FATAL ERROR: Userfile Not Found');
         Halt;
        END;}
   Close (Userfile);

 end;

FUNCTION FindAlias(TargetName: STRING; VAR FilePointer : INTEGER) : BOOLEAN;
 var
  name : integer;
  found   : boolean;
  i       : integer;


 begin
   found := false;
   i := 0;
   {I-}
    reset (Userfile);
   {I+}
      while (not found) and (i <= maxusers) do
         begin
          seek(userfile,userindex [i].recordnumber);
          read(userfile,tempuser);
          if targetname = tempuser.Alais then found := true else i := i + 1;
         end;
   FilePointer := i;
   FindAlias:= found;
   Close (Userfile);

 end;


END.
