
UNIT MsgSys;

INTERFACE

  Uses Dos,Crt,QBBS,Chario,Strstuff,SpaceStf,InitBBS,Message,Read,Sysop,Login,
       windows;

PROCEDURE MessageMenu;

IMPLEMENTATION

PROCEDURE MessageMenu;


CONST

   MaxBoards     = 15                {For Temporary Compatability}
   LibFileExt    = '.MSG';
   HeaderFileExt = '.HDR';
   InfoFileExt   = '.INF';

TYPE
   BoardInfoType = RECORD
     Name           : STRING[80];
     Path           : STRING[25];
     Filename       : STRING[9];
     HighMessage    : INTEGER;
     HighestRead    : INTEGER;
     MessagePointer : INTEGER;
     DefaultAccess  : CHAR;
     ValidateAccess : CHAR;
     NewMsgStart    : INTEGER;
     TotalMsgs      : INTEGER;
     TotalDeleted   : INTEGER;
     BlocksDeleted  : INTEGER;
   END;


   MessageRecord = RECORD
     Deleted     : BOOLEAN;
     Locked      : BOOLEAN;
     Date        : STRING;
     Time        : STRING[7];
     Title       : STRING[28];
     PersonTo    : STRING[25];
     From        : STRING[25];
     Number      : LONGINT;
     StartBlock  : INTEGER;
     TotalBlocks : INTEGER;
     Alais       : STRING[25];
     AlaisTo     : STRING[25];
     Reference   : LONGINT;
    END;


VAR
  AreaInfo         : ARRAY [1..255] of MessageInfoType;  {Area Information}
  ScratchFile      : FILE;
  NumberOfAreas    : BYTE;
  CurrentArea      : BYTE;                    {Area I'm In...}
  MainCommand      : CommandType;            {The Main Command}
  TempStr          : STRING;
  Count            : INTEGER;
  Quit             : BOOLEAN;
  MainSelection    : STRING;
  MessagePrompt    : STRING;
  MenuNumber       : BYTE;
  I,J              : BYTE;
  GoAhead          : BOOLEAN;


PROCEDURE ClearMessageInfo

   VAR Count : INTEGER;

   BEGIN
    For Count := 1 to 30 do
       BEGIN
        WITH AreaInfo[Count] DO   {Where I left off}
         AreaName[Count] := '';
         FilePath[Count] := '';
         AreaLevel[Count]:= 0;
       END;
     END;

PROCEDURE ClearRecord;

   VAR
      I  : INTEGER;

   BEGIN
    WITH FileRecord Do
     BEGIN
          Deleted                            := FALSE;
          FileName                           := '';
          NameHash                           := 0;
          FOR I := 1 to 5 Do Description [I] := '';
          Password                           := '';
          FSize                              := 0;
          TimesDownloaded                    := 0;
          UploadedBy                         := '';
          Date.Month                         := 1;
          Date.Day                           := 1;
          Date.Year                          := 80;
          Date.DayOfWeek                     := 1;
          BlankInt1                          := 0;
          BlankInt2                          := 0;
          BlankInt3                          := 0;
          BlankStr4                          := '';
          BlankStr5                          := '';
          BlankStr6                          := '';
          BlankBoo7                          := FALSE;
          BlankBoo8                          := FALSE;
          BlankBoo9                          := FALSE;
     END;
    END;

PROCEDURE ReWriteFileRecord(RecordNum : INTEGER; RecFile : STRING);

 VAR
  tempstr : string[5];
  CurFile : File Of FileAreaRecord;

 BEGIN
  Assign (CurFile,RecFile);
  {$I-}
  Reset (CurFile);
  {$I+}
  IF IOResult = 0 THEN
   BEGIN
    STR (RecordNum,tempstr);
    Seek (CurFile, RecordNum);
    Write (CurFile, FileRecord);
    LineOut ('');
    Close (CurFile);
   END
   ELSE Show_Error ('Error Writing File List -- Please tell sysop.');
 END;

PROCEDURE AddRecord (RecFile : STRING);

 VAR

  Drive : INTEGER;
  CurFile : File Of FileAreaRecord;

 BEGIN
  Assign (CurFile,RecFile);
  {$I-}
  Reset (Curfile);
  {$I+}
  IF IOResult = 0 THEN
   BEGIN
    Seek (CurFile, FileSize (CurFile));
    Write (CurFile,FileRecord);
    Close (CurFile);
    Drive := ord (FilePath[CurrentArea][1]) - 64;
    DiskSpace (drive,drive_total_avail [drive],drive_space [drive]);
   END
   ELSE Show_Error ('Error Appending File List -- Please tell sysop.');
 END;

PROCEDURE MakeRecord (RecFile : STRING);

 VAR

  Drive : INTEGER;
  CurFile : File Of FileAreaRecord;

 BEGIN
  Assign (CurFile,RecFile);
  {$I-}
  ReWrite (Curfile);
  {$I+}
  IF IOResult = 0 THEN
   BEGIN
    Write (CurFile,FileRecord);
    Write (CurFile,FileRecord);
    Close (CurFile);
    Drive := ord (FilePath[CurrentArea][1]) - 64;
    DiskSpace (drive,drive_total_avail [drive],drive_space [drive]);
   END
   ELSE Show_Error ('Error Creating File List -- Please tell sysop.');
 END;

FUNCTION Read_Config: BYTE;

  VAR
    ScratchFile : TEXT;
    Count       : INTEGER;
    Dummy       : STRING;

 CONST
   Data_File = 'FileArea.Txt';

  BEGIN
    Count := 0;
    ClearArrays;
    Assign  (ScratchFile,Config.Miscpath+Data_File);
    {$I-} Reset (ScratchFile); {$I+}
    If IOresult = 0 then
      BEGIN
        REPEAT
            Count := Succ(Count);
            ReadLn (ScratchFile,AreaName[Count]);
            ReadLn (ScratchFile,FilePath[Count]);
            ReadLn (ScratchFile,Dummy);
            ReadLn (ScratchFile,AreaLevel[Count]);
        UNTIL (Count = 30) or (SEEKEOF (ScratchFile));
        NumberofAreas := Count;
        Close (ScratchFile);
        Read_Config := 0;
      END
      ELSE
       BEGIN
         Show_Error('Sorry, File Section Closed for Configuration.');
         Read_Config :=1;
         Close (ScratchFile);
       END;
    END;

 PROCEDURE List_Areas;

     VAR   Count : BYTE;

     BEGIN
       ClearBreak;
       Count := 0;
       LineOut (C('Y2'));
       StringOut ('Area ');
       StringOut (C('G2')+'     Description');
       LineOut ('');
       StringOut (C('Y2'));
       StringOut ('---- ');
       StringOut (C('G2')+'     -----------');
       LineOut ('');
         REPEAT
           BEGIN
             Count := Succ (Count);
             If User.D_Level >= AreaLevel [Count] then
             BEGIN
              StringOut(C('Y2')+Strif(Count,4));
              StringOut(C('G2') + '      ');
              StringOut(AreaName[Count]);
              LineOut ('');
             END;
           END;
         UNTIL (Count = NumberofAreas) or (Not There) or (CTRL_C);
         LineOut (C('C2'));
       END;

PROCEDURE Change_Areas;

   VAR         NewArea : INTEGER;
               Prompt  : String [40];
               TempStr : String [2];
               TempS   : STRING;
               Code    : INTEGER;
               Valid   : BOOLEAN;
               TempI   : INTEGER;
               Parameter : BYTE;    {Remove after hooking upto new parser}

   PROCEDURE Change;
     BEGIN
       IF TempI > 0 Then
         BEGIN
          CurrentArea := TempI;
          LineOut (' ');
          Show_Error ('Changing to the '+AreaName[CurrentArea]+ ' area.');
         END;
     END;

   BEGIN
     Parameter :=0;
     IF (NOT p_abort) AND (p_min <> -1) THEN Parameter := p_min;
     IF Parameter <=0  Then
       BEGIN
         REPEAT
           Valid := False;
           BEGIN
             Str (CurrentArea:2,TempStr);
             Prompt := ('Area['+Clipl(TempStr)+']:New Area (?/list): ');
             TempS := GetInput (Prompt,lcase,echo,3);
             Val (TempS,TempI,Code);
             TempS :=AllCaps (TempS);
             If (TempS ='') or (TempS = 'Q') Then EXIT
               ELSE
                BEGIN
                  if ((TempI < 1) and (TempS <> '?'))
                     or (TempI> NumberofAreas) then EXIT;
                  LineOut (' ');

                  If TempS = '?' then List_Areas ELSE
                  IF User.D_level >= AreaLevel [TempI]  Then
                  BEGIN
                    Change;
                    Valid := TRUE;
                  END;
               END;
             END;
            UNTIL (VALID) or (Not THERE);
         END
         ELSE
            IF (Parameter <=NumberOfAreas) and (User.D_Level >=AreaLevel [parameter])
               Then
                 BEGIN
                    TempI := Parameter;
                    Change;
                  END;
      END;



  FUNCTION Exists(FileName: NAME): BOOLEAN;

    VAR Found        : BOOLEAN;
        SFile        : FILE;

   BEGIN
      Assign(SFile, FileName);
      {$I-}
       Reset(SFile)
      {$I+};
      Found := (IOresult = 0);
      IF found Then Close(SFile);
     Exists := Found;
  END;

  FUNCTION Alpha(FileName: NAME): BOOLEAN;

    VAR
        StrPos: INTEGER;
        Okay:   BOOLEAN;
        Dots:   BYTE;

    BEGIN
      Dots := 0;
      Alpha := TRUE;
      IF Length(Filename) > 0 THEN
        FOR StrPos := 1 to Length(filename) do
          BEGIN
            IF FileName[StrPos] = '.' then Dots := Dots + 1;
            IF not (FileName[StrPos] in ['.', '-', '_', '0'..'9', 'A'..'Z'])
                or (Dots > 1)
            Then
              BEGIN
               alpha := false;
              END;
          END;
       END;



 FUNCTION GetFileSize (TempFile : NAME):LONGINT;

 Var Temp         : LONGINT;
     SFile        : FILE of CHAR;

   BEGIN
    IF Exists(TempFile) THEN
     BEGIN
      Assign (SFile,TempFile);
      Reset (SFile);
      Temp := Filesize (SFile);
      Close (SFile);
      GetFileSize := TEMP;
     END
      ELSE
      GetFileSize :=0;
   END;


PROCEDURE AddToBatch (Upload:BOOLEAN);

  VAR
     I        : INTEGER;
     TempName : STRING[40];
     TempStr  : STRING[5];
     TempInt  : LongINT;
     Code     : INTEGER;
     TempDes  : ARRAY [1..5] of STRING[40];
     Done     : BOOLEAN;
     K,L      : INTEGER;
     TempCh   : CHAR;
     TempStr1 : STRING;


  BEGIN
   I := MaxBatch;
   TempInt := 0;
   REPEAT
    BEGIN
     LineOut ('');
     StringOut (C('C2'));
     Str (I+1,TempStr);
     StringOut (C('G2')+'File #');
     StringOut (C('B2')+TempStr);
     StringOut (C('M2')+' [Name/Number]: ');
     TempName := GetInput ('',lcase,echo,30);
     TempName := Allcaps (TempName);
     IF NOT Upload then
      BEGIN
       VAL (TempName,TempInt,Code);
       IF TempInt <> 0 THEN
        BEGIN
           Assign (CurFile,FilePath[CurrentArea]+RFileName);
           {$I-}
             Reset (CurFile);
           {$I+}
           IF IOResult <> 0 THEN
            BEGIN
             Show_Error (C('R')+'Error Opening File Area Record File.  Please tell Sysop.');
             Exit;
            END;
          IF TempInt < FileSize (CurFile) THEN  ReadRec (TempInt)
            ELSE
             BEGIN
              LineOut (C('R2')+'Number out of range.');
              Close (CurFile);
              Exit;
             END;
          TempName := FileRecord.FileName;
          Close (CurFile);
         END;
       IF (Alpha (TempName)) and (Exists (FilePath[CurrentArea]+TempName))
        THEN
         BEGIN
          LineOut (C('G2')+'File Marked.');
          BatchType :='DOWNLOAD';
          I := I + 1;
          MaxBatch := MaxBatch + 1;
          BatchTran[I] := FilePath[CurrentArea]+TempName
         END
         ELSE
           IF TempName <> '' THEN
            LineOut (C('R2')+'File Not Found.');
        END;

         IF (Alpha (TempName)) and (TempName <> '') and (Upload) and
          (NOT Exists(FilePath[Config.Upnum]))THEN
          BEGIN
           BatchType :='UPLOAD';
           I := I + 1;
           MaxBatch := MaxBatch + 1;
           If (User.D_Level <> 255) and (Config.UpNum <= NumberOfAreas) THEN
            BatchTran[I] := FilePath[Config.UpNum] + TempName
           ELSE
            BatchTran[I] := FilePath[CurrentArea] + TempName;
           Done := FALSE;
           REPEAT
             BEGIN
              LineOut ('');
              LineOut (C('G2')+'Enter Description (<ENTER> / Done: ');
              K := 0;
               REPEAT
                BEGIN
                 K := K + 1;
                 TempDes[K] := GetInput ('>',lcase,echo,40);
                 If TempDes[K] = '' THEN K := 5;
                END;
               UNTIL (K = 5) or (NOT THERE);
               LineOut (C('B2'));
               If Yes ('Is this the description you want? (y,n): ') THEN
               Done := TRUE;
              END;
           UNTIL (Done) or (Not THERE);
          For K := 1 to 5 DO Descripts[I,K] := TempDes[K];
         END;
       END;
      UNTIL (TempName = '') or (NOT There);
     END;

PROCEDURE DisplayRecord(RecNum: LongINT);

 VAR
    TempStr,
    TempStr1,
    TempStr2,
    TempStr3,
    TempStr4  : STRING;

  PROCEDURE CheckJ;

   VAR
      L : INTEGER;
      WhatNot : CHAR;

   BEGIN
    J := J + 1;
    IF (User.MorePrompt) AND (J >= User.ScrnLines - 5) THEN
     BEGIN
       StringOut (C('G2')+'[MORE (Y,n,[m]ark file)]: ');
       StringOut (C('W2'));
       Whatnot := ReadC;
       L := 0;
        CASE WhatNot OF
         'N','n' : GoAhead := FALSE;
         'M','m' : AddtoBatch (FALSE);
        END;
       IF Whatnot <> '' THEN L := 1;
       For L := 1 to 25 + L do StringOut (^H);
       For L := 1 to 25 + L do StringOut (' ');
       For L := 1 to 25 + L do StringOut (^H);
       J := 0;
     END;
   END;


  BEGIN
    IF (User.Level = 255) OR (NOT FileRecord.Deleted) THEN
     BEGIN
      IF FileRecord.Deleted THEN
       BEGIN
        StringOut (C('R2'));
        LineOut ('[DELETED]');
        CheckJ;
       END;
       If FileRecord.Password <> '' THEN StringOut ('* ') ELSE StringOut ('  ');
       StringOut (C('W2')+'#');
       Str (RecNum,TempStr);
       StringOut (Padr(TempStr,3));
       StringOut (C('G2')+Padr(FileRecord.FileName,12));
       Str (FileRecord.FSize:8:0,TempStr);
       StringOut (C('R2')+Padr(TempStr,10));
        WITH FileRecord.Date DO
         BEGIN
          Str (Day,TempStr1);
          Str (Month,TempStr2);
          Str (Year,TempStr3);
          TempStr3 := Copy (TempStr3,3,2);
          TempStr4:= Padr(TempStr2+'/'+Tempstr1+'/'+TempStr3,8);
          StringOut (C('C2')+TempStr4);
         END;
          StringOut (C('M2')+'|'+FileRecord.Description[1]);
          J := J + 1;
          LineOut('');
          StringOut (C('B2')+Padr('      From:      '+FileRecord.Uploadedby,36));
          StringOut (C('M2')+'|'+FileRecord.Description[2]);
          J := J + 1;
          LineOut ('');
          Str (FileRecord.TimesDownloaded,TempStr);
          StringOut (C('Y') +Padr('      Downloads: '+TempStr,36));
          StringOut (C('M2')+'|'+FileRecord.Description[3]);
          J := J + 1;
          LineOut ('');
          IF FileRecord.Description[4] <> '' THEN
           BEGIN
            LineOut ('                                    |'+FileRecord.Description[4]);
            J := J + 1;
           END;
          IF FileRecord.Description[5] <> '' THEN
           BEGIN
            LineOut ('                                    |'+FileRecord.Description[5]);
            J := J + 1;
           END;
          LineOut('');
          J := J + 1;
          LineOut ('');
          CheckJ;
         END;
        END;

PROCEDURE ShowFileList (RecordFile : STRING);

 VAR
    I         : INTEGER;
    DONE      : BOOLEAN;
    TempStr,
    TempStr1,
    TempStr2,
    TempStr3,
    TempStr4  : STRING;
    LastRec   : INTEGER;



  BEGIN
   GoAhead := TRUE;
   EnableBreak;
   IF Exists(RecordFile) THEN
    BEGIN
      Assign (CurFile,RecordFile);
      {$I-}
      Reset (CurFile);
      {$I+}
      IF IOResult = 0 THEN
       BEGIN
        LastRec := FileSize (Curfile);
       Close (Curfile);
        LineOut ('');
        I := 0;
        J := 1;
        REPEAT
         BEGIN
          Reset (Curfile);
          I := I + 1;
          ReadRec (I);
          Close (Curfile);
          IF (User.Level = 255) OR (NOT FileRecord.Deleted) THEN
          DisplayRecord(I);
          END;
        UNTIL (I = (LastRec - 1)) or (BREAK) or (NOT THERE) or (NOT GoAhead);
       DisableBreak;
      END
    ELSE Show_Error ('Error Reading Filelist -- Please Tell Sysop.');
   END
  ELSE Show_Error ('Sorry, No files in the directory.');
END;

PROCEDURE WriteToFileList (Record_File : TitleType;
                             FileName    : TitleType;
                             Size        : REAL;
                             Password    : STRING;
                             Description : DescriptionType);

  VAR
     TempSize     : STRING [8];
     TempName     : STRING;
     I            : BYTE;
     J            : BYTE;
     K            : BYTE;

 BEGIN
   J := 0;
   For I := 1 to Length (FileName) DO
   IF FileName [I] = '\' THEN J :=I;
   IF J > 0 THEN
    BEGIN
     TempName := Copy (FileName,J+1,Length(FileName));
    END
    ELSE TempName := FileName;
    ClearRecord;
    FileRecord.Description[1] := Description[1];
    FileRecord.Description[2] := Description[2];
    FileRecord.Description[3] := Description[3];
    FileRecord.Description[4] := Description[4];
    FileRecord.Description[5] := Description[5];
    FileRecord.FileName       := TempName;
    FileRecord.FSize          := Size;
    CurrentDate(FileRecord.Date);
    FileRecord.UploadedBy     := User.Name;
    FileRecord.Password       := Password;
    IF Not Exists (Record_File) Then MakeRecord(Record_File)
    ELSE
     AddRecord (Record_File);
 END;

PROCEDURE RecieveFile (FileName:TitleType;Num:BYTE);

  VAR
    Dummy  : STRING;
    Result : BYTE;



  BEGIN
    LineOut (C('G2'));
    StringOut ('Ready to Recieve File(s). Type <ENTER> to Start Transfer.');
    Dummy:= getinput ('',lcase,echo,2);
    IF MaxBatch = 0 THEN
     BEGIN
      SwapVectors;
      Exec(Prots[num].path,Prots[num].UpString+' '+FileName);
      SwapVectors;
     END
    ELSE
     BEGIN
      SwapVectors;
      Exec(Prots[num].path,Prots[num].UpString+' '+Prots[Num].BatchString+Config.MiscPath+'TRANS.LST');
      SwapVectors;
     END;
  END;

  PROCEDURE WriteBatchList(Num:BYTE);

 VAR
    I        : INTEGER;
    FileName : STRING [40];
    TFile    : TEXT;

 BEGIN
   Assign (Tfile,Config.MiscPath+'TRANS.LST');
   ReWrite (Tfile);
   FOR I := 1 to MaxBatch do Writeln (Tfile,BatchTran[I]);
   Close (Tfile);
 END;

PROCEDURE ClearBatchList;

  VAR
     I       : INTEGER;
     J       : INTEGER;

  BEGIN
   For I := 1 to 10 Do
    BEGIN
     BatchTran[I] :='';
     FOR J := 1 to 5 do Descripts[I,j] :='';
    END;
   MaxBatch :=0;
   BatchType := 'NONE';
  END;

PROCEDURE ReadProts;

  VAR
    ScratchFile : TEXT;
    Count       : INTEGER;

 CONST
   Data_File = 'PROTS.TXT';

PROCEDURE ClearArrays;

   VAR Count : INTEGER;

   BEGIN
  For Count := 1 to 15 do
       BEGIN
        WITH Prots [Count] Do
          BEGIN
           Name       :='';
           Path       :='';
           UpString   :='';
           DownString :='';
           Command    :='';
           BatchString :='';
          END;
       END;
     END;


  BEGIN
    ClearArrays;
    Count := 0;
    Assign  (ScratchFile,Config.Miscpath+Data_File);
    {$I-} Reset (ScratchFile); {$I+}
    If IOresult = 0 then
      BEGIN
        REPEAT
         BEGIN
            Count := Succ(Count);
            WITH Prots[Count] DO
             BEGIN
              ReadLn (ScratchFile,Name);
              ReadLn (ScratchFile,Path);
              ReadLn (ScratchFile,UpString);
              ReadLn (ScratchFile,DownString);
              Readln (ScratchFile,Command);
              Readln (ScratchFile,BatchString);
             END;
           END;
        UNTIL (Count = 15) or (SEEKEOF (ScratchFile));
        MaxProts := Count;
        Close (ScratchFile);
      END
      ELSE
       BEGIN
        MaxProts := 0;
       END;
    END;

PROCEDURE SendFile (FileName:TitleType;Num:BYTE);

  VAR
    Dummy  : STRING;
    Result : BYTE;


  BEGIN
    LineOut (C('G2'));
    StringOut ('Sending File(s).  Type <ENTER> to Start Transfer.');
    Dummy:= getinput ('',lcase,echo,2);
    IF MaxBatch = 0 THEN
     BEGIN
      SwapVectors;
      Exec(Prots[num].path,Prots[num].DownString+' '+FileName);
      SwapVectors;
     END
    ELSE
     BEGIN
      SwapVectors;
      Exec(Prots[num].path,Prots[num].DownString+' '+Prots[Num].BatchString+Config.MiscPath+'TRANS.LST');
      SwapVectors;
     END;
  END;



PROCEDURE ShowTransferProtocol;

  VAR
    I :  BYTE;

  BEGIN
     Show_Error (C('G2')+'Choose Transfer Protocol:');
     LineOut ('');
     IF MaxProts > 0 THEN
      BEGIN
       For I := 1 to MaxProts Do
        BEGIN
         WITH Prots[I] DO
          BEGIN
           StringOut (C('M2')+'[');
           StringOut (C('R2')+Command);
           StringOut (C('M2') +'] ');
           LineOut (C('G2') +Name);
          END;
         END;
        END
         ELSE
          BEGIN
           LineOut (C('R2'));
           LineOut ('ERROR: No Configured Transfer Protocols');
           LineOut (C('W2'));
          END;
         LineOut ('');
       END;

PROCEDURE Recieve (FileName : TitleType);

VAR      Choice   : STRING[5];
         Prompt   : STRING;
         FileSize : LONGINT;
         FileDate : DATE_TYPE;
         Pswd     : STRING;
         Descript : DescriptionType;
         OneDes   : DescriptionType;
         I,J,K,L  : BYTE;
         Num      : BYTE;
         Done     : BOOLEAN;
         ThenTime : Time_Type;
         NowTime  : Time_Type;
         Counter  : BYTE;
         Total    : BYTE;
BEGIN
  FOR L := 1 to 5 Do Descript [L] := '';
  ShowTransferProtocol;
  Choice := GetInput (C('C2')+'Enter Selection: ',Lcase,Echo,5);
  Choice := Allcaps(Choice);
  Num :=0;
  FOR I := 1 to MaxProts Do
   BEGIN
     IF Allcaps(Prots[I].Command) = Choice THEN Num := I;
   END;
  IF Num = 0 THEN
   BEGIN
    LineOut ('');
    LineOut (C('R2')+'Invalid Protocol.');
    LineOut ('');
    Exit;
   END;
  ClrScr;
  CurrentTime(ThenTime);
  TimeCheck := FALSE;
    IF MaxBatch > 0 THEN
      BEGIN
       IF Prots[Num].BatchString = '' THEN
        BEGIN
         Show_Error (C('R2')+'You must select a BATCH protocol to use a batch list.');
         Exit;
        END;
       WriteBatchList(Num);
      END;
  RecieveFile(FileName,Num);
  InitWindow;
  UpdateWindow (init);
  Flow_Control := TRUE;
  Done         := FALSE;
  IF MaxBatch = 0 THEN
   BEGIN
    Show_Error (C('G2')+'Looking for file...');
    i := CurrentArea;
    IF Exists (FileName) Then
     FileSize := GetFileSize (FileName)
    ELSE
    BEGIN
     Show_Error(C('R2')+'I cannot Find your Upload.  Please tell sysop.');
     UpdateLog ('UUPLOAD',FileName);
     Exit;
    END;
    REPEAT
     BEGIN
      LineOut ('');
      LineOut (C('G2')+'Enter Description (<ENTER> / Done: ');
      K := 0;
      REPEAT
       BEGIN
        K := K + 1;
        Descript[K] := GetInput ('>',lcase,echo,40);
        If Descript[K] = '' THEN K := 5;
       END;
      UNTIL (K = 5) or (NOT THERE);
        LineOut (C('B2'));
        If Yes ('Is this the description you want? (y,n): ') THEN
         BEGIN
          Done := TRUE;
          UpdateLog ('SUPLOAD',FileName);
         END;
       END;
     UNTIL (Done) or (Not THERE);
   LineOut ('');
  If FileSize <> 0 THEN
    WriteToFileList(FilePath[CurrentArea]+RFileName,
                       FileName,FileSize,Pswd,Descript);
  END
  ELSE
   BEGIN
    LineOut ('');
    FOR J := 1 to MaxBatch do
     BEGIN
      FileSize := 0;
      IF Exists (BatchTran[J]) THEN FileSize :=GetFileSize (BatchTran[J]);
      If FileSize = 0 THEN UpdateLog ('UUPLOAD',FileName) ELSE
       UpdateLog ('SUPLOAD',FileName);
      IF FileSize <> 0 THEN
      BEGIN
       WriteToFileList(FilePath[CurrentArea]+RFileName,
                       BatchTran[J],FileSize,'',Descripts[J]);
      END;
       Write;
     END;
    END;
   CurrentTime (NowTime);
       IF (ThenTime.Hour <> NowTime.Hour) THEN
        BEGIN
         IF ThenTime.Hour > NowTime.Hour THEN NowTime.Hour := NowTime.Hour + 23;
         Counter := NowTime.Hour - ThenTime.Hour
        END
        ELSE
         Counter := 0;
       IF ThenTime.Min > NowTime.Min then NowTime.Min := NowTime.Min + 60;
       Counter := Counter * 60;
       Total := NowTime.Min -  ThenTime.Min + Counter;
       Time_Limit := Time_Limit+(Total * 60);
       TimeCheck := TRUE;
       ClearBatchList;
   END;


PROCEDURE Upload;

  VAR              ScratchFile : FILE;
                   Filename    : STRING [30];
                   Aborted     : BOOLEAN;

  BEGIN
  IF MaxBatch = 0 THEN
   BEGIN
     LineOut (C('W2'));
     FileName := getinput ('FileName to Upload: ',lcase,echo,30);
     FileName := allcaps (FileName);
     If (User.D_Level <> 255) and (Config.UpNum <= NumberOfAreas) THEN
      CurrentArea := Config.UpNum;
     LineOut (' ');
       If  (Alpha (FileName)) and
         (NOT Exists (FilePath[CurrentArea]+FileName)) Then
               Recieve (FilePath[CurrentArea]+FileName)
           ELSE
           BEGIN
            Show_Error (C('R2')+'File Exists Or Invalid File Name.');
           END;
       END
       ELSE
        Recieve('BATCH');
  END;

PROCEDURE Send (FileName : TitleType);

VAR      Choice     : STRING[5];
         Prompt     : STRING;
         TempName   : STRING;
         TempName1  : STRING;
         Num        : BYTE;
         I,J,K,L,M  : BYTE;

  BEGIN
   ShowTransferProtocol;
   Choice := GetInput (C('G2')+'Enter Selection: ',Lcase,Echo,5);
   Choice := Allcaps(Choice);
   Num :=0;
   FOR I := 1 to MaxProts Do
    BEGIN
     IF Allcaps(Prots[I].Command) = Choice THEN Num := I;
    END;
   IF Num = 0 THEN
    BEGIN
     LineOut ('');
     LineOut (C('R2')+'Invalid Protocol.');
     LineOut ('');
     Exit;
    END;
     Flow_Control := FALSE;
     ClrScr;
     IF MaxBatch > 0 THEN
      BEGIN
       IF Prots[Num].BatchString = '' THEN
        BEGIN
         Show_Error (C('R2')+'You must select a BATCH protocol to use a batch list.');
         Exit;
        END;
       WriteBatchList(Num);
      END;
     SendFile(FileName,Num);
     For J := 1 to MaxBatch Do
      BEGIN
       UpdateLog ('SDOWNLOAD',BatchTran[J]);
       K := 0;
       For L := 1 to Length (BatchTran[J]) DO
       IF BatchTran [J][L] = '\' THEN K := L;
        BEGIN
         TempName  := Copy (BatchTran[J],1,K);
         TempName1 := Copy (BatchTran[J],K+1,Length(BatchTran[J]));
        END;
        Assign (CurFile,TempName+'AREA');
        {$I-}
         Reset (CurFile);
        {$I+}
        IF IOresult = 0 THEN
         BEGIN
          For M := 1 to FileSize (Curfile) - 1 DO
           BEGIN
            ReadRec (M);
            IF TempName1 = FileRecord.FileName THEN
             BEGIN
              FileRecord.TimesDownloaded := FileRecord.TimesDownloaded + 1;
              Close (CurFile);
              ReWriteFileRecord(M,TempName+'AREA');
              Reset (CurFile);
             END;
           END;
          Close (CurFile);
         END;
      END;
     ClrScr;
     InitWindow;
     UpdateWindow (init);
     Writeln;
     Flow_Control := TRUE;
     ClearBatchList;
  END;




PROCEDURE DisplayBatch;

  VAR
     I,j,k    : INTEGER;
     FileName : STRING [40];
     TempName : STRING [40];

  BEGIN
   LineOut ('');
   LineOut (C('G2')+'Batch Transfer List');
   LineOut ('');
   If MaxBatch = 0 THEN
    BEGIN
     LineOut (C('R2'));
     LineOut ('No Files in Batch List.');
    END
    ELSE
     BEGIN
       IF BatchType = 'UPLOAD' THEN LineOut (C('B2')+'Files to Upload')
       ELSE LineOut (C('B2')+'Files to Download');
       LineOut ('');
       I := 0;
       REPEAT
        BEGIN
         I := I + 1;
         J := 0;
         FileName := BatchTran [I];
         For K := 1 to Length (FileName) DO
         IF FileName [K] = '\' THEN J := K;
         IF J > 0 THEN
          BEGIN
           TempName := Copy (FileName,J+1,Length(FileName));
          END
          ELSE TempName := FileName;
          LineOut (TempName);
         END;
        UNTIL (I = MaxBatch) or (NOT There);
       END;
    END;

PROCEDURE Download;

  VAR              ScratchFile : FILE;
                   Filename    : STRING [30];
                   Aborted     : BOOLEAN;
                   M           : INTEGER;

  BEGIN
     LineOut (C('C2'));
     IF MaxBatch = 0 THEN
      BEGIN
       FileName := getinput ('File to download: ',lcase,echo,30);
       FileName := allcaps (FileName);
       LineOut (' ');
       Show_Error (C('G2')+'Looking for file...');
       If  (Alpha (FileName)) and (Exists(FilePath[CurrentArea]+FileName))
           Then
            BEGIN
             Send (FilePath[CurrentArea]+FileName);
             UpdateLog ('SDOWNLOAD',FilePath[CurrentArea]+FileName);
             Assign (CurFile,FilePath[CurrentArea]+'AREA');
            {$I-}
             Reset (CurFile);
            {$I+}
            IF IOresult = 0 THEN
             BEGIN
              For M := 1 to FileSize (Curfile) - 1 DO
               BEGIN
                ReadRec (M);
                 IF FileName = FileRecord.FileName THEN
                  BEGIN
                   FileRecord.TimesDownloaded := FileRecord.TimesDownloaded + 1;
                   Close (CurFile);
                   ReWriteFileRecord(M,FilePath[CurrentArea]+'AREA');
                   Reset (CurFile);
                  END;
                END;
              Close (CurFile);
             END;
           END
           ELSE
           BEGIN
            LineOut (' ');
            Show_Error (C('R2')+'Sorry, file not found.');
           END
       END
      ELSE
       Send('BATCH');
     END;

PROCEDURE FileMaintenance;
 VAR
  Selection     : STRING; {used for menu selection}
  GoingForward  : BOOLEAN;
  FilePointer   : LONGint;
  Done          : BOOLEAN;
  FileChanged   : BOOLEAN;
  Code          : INTEGER;
  TempInt       : INTEGER;
  FunctNum      : INTEGER;
  I             : INTEGER;
  LastFile      : LONGint;
  funct_num     : INTEGER;

PROCEDURE SysopAddFile;

  VAR
   FileName : STRING [30];
   FileSize : LONGINT;
   Descript : DescriptionType;
   Pswd     : STRING;
   FileDate : Date_Type;
   I,J,K    : BYTE;

  BEGIN
    FOR J := 1 to 5 Do Descript [J] := '';
    LineOut (C('G2'));
    FileName := getinput ('Enter new File Name: ',lcase,echo,30);
    FileName := allcaps (FileName);
    i := CurrentArea;
    IF Exists (FilePath[i]+FileName) Then
       FileSize := GetFileSize (FilePath[i]+FileName)
     ELSE
      BEGIN
       FileSize :=0;
       IF yes(C('R2')+'File Not Found...Abort (y,n)? ') THEN Exit;
      END;
    LineOut (C('G2'));
    LineOut ('');
    LineOut (C('G2')+'Enter Description (<ENTER> / Done): ');
    K := 0;
     REPEAT
      BEGIN
       K := K + 1;
       Descript[K] := GetInput ('>',lcase,echo,40);
       If Descript[K] = '' THEN K := 5;
      END;
      UNTIL (K = 5) or (NOT THERE);
    LineOut ('');
    Pswd := '';
    IF Yes (C('G2')+'Password Protect this File (y,n)? ') THEN
     Pswd := GetInput ('Password: ',lCase,Echo,10);
    LineOut ('');
    If Yes (C('C2')+'Ok To Add (y,n)? ') Then
      WriteToFileList(FilePath[i]+RFileName,
                        FileName,FileSize,Pswd,Descript);
  END;

PROCEDURE FilePrompt;

 VAR
  tempSTR   : STRING[50];
  tempSTR1  : STRING[25];
  tempSTR2  : STRING[25];
  TempSTR3  : STRING[10];
  TempSTR4  : STRING[2];
  TempInt   : LONGint;
  TempInt2  : INTEGER;

 BEGIN
  Assign (CurFile,FilePath[CurrentArea]+RFileName);
  {$I-}
   Reset (CurFile);
  {$I+}
  IF IOResult = 0 then
   BEGIN
    TempInt := FileSize (CurFile) - 1;
    Close (CurFile);
   END
    ELSE TempInt := 0;
  CASE GoingForward OF
   true : tempSTR3 := '+';
   false: tempSTR3 := '-';
  END;
  str (FilePointer,tempSTR1);
  str (TempInt,tempSTR2);
  Str (CurrentArea,TempSTR4);
  StringOut (C('R')+'<');
  StringOut (C('G2')+'AREA: ');
  StringOut (C('B2')+ TempSTR4);
  StringOut (C('R') + '> ');
  StringOut (C('M2') + TempSTR3);
  StringOut (C('C2') + 'File');
  StringOut (C('R') +' [');
  StringOut (C('Y2') + tempSTR1);
  StringOut (C('R') + '] ');
  StringOut (C('G2') + '(1-' + tempSTR2 + '), ?: ');
  StringOut (C('W2'));
  LastFile := TempInt;
 END;

PROCEDURE DeleteToggle;

BEGIN
 FileRecord.Deleted := Not FileRecord.Deleted;
 IF FileRecord.Deleted THEN Show_Error (C('G2')+'File Deleted.')
 ELSE Show_Error (C('G2')+'File UnDeleted.');
 ReWriteFileRecord(FilePointer,FilePath[CurrentArea]+RFileName);
END;

PROCEDURE ChangeDescription;

  VAR
    TempDes : ARRAY [1..5] of STRING[80];
    K,L     : BYTE;

  BEGIN
    For K := 1 to 5 do TempDes[K] := '';
    LineOut (C('G2')+'Enter Description (<ENTER> / Done | <ENTER> on first line Aborts:): ');
    K := 0;
     REPEAT
      BEGIN
       K := K + 1;
       TempDes[K] := GetInput ('>',lcase,echo,40);
       If TempDes[K] = '' THEN K := 5;
      END;
      UNTIL (K = 5) or (NOT THERE);
     IF TempDes [1] <> '' THEN
      BEGIN
       FileRecord.Description[1] := TempDes[1];
       FileRecord.Description[2] := TempDes[2];
       FileRecord.Description[3] := TempDes[3];
       FileRecord.Description[4] := TempDes[4];
       FileRecord.Description[5] := TempDes[5];
       ReWriteFileRecord(FilePointer,FilePath[CurrentArea]+RFileName);
      END;
    END;

PROCEDURE ChangeUploadedBy;

 VAR
  TempStr : STRING;

 BEGIN
   TempStr := GetInput ('New Uploader: ',ucase,echo,40);
   IF TempStr <> '' THEN FileRecord.UploadedBy := TempStr;
   ReWriteFileRecord(FilePointer,FilePath[CurrentArea]+RFileName);
 END;

PROCEDURE ChangePassword;

 VAR
  TempStr : STRING;

 BEGIN
   TempStr := GetInput ('New Password (<ENTER> / None>: ',ucase,echo,8);
   IF TempStr <> '' THEN FileRecord.Password := TempStr;
   ReWriteFileRecord(FilePointer,FilePath[CurrentArea]+RFileName);
 END;

PROCEDURE ChangeFileSize;

  VAR
   TempSTR : STRING;
   Code    : INTEGER;
   TempR   : REAL;

   BEGIN
    WITH FileRecord Do
     BEGIN
      TempStr := GetInput ('New File Size: ',UCASE,ECHO,10);
      TempR   := 0;
      VAL (TempStr,TempR,Code);
      IF TempR > 0 THEN FSize := TempR;
     END;
    ReWriteFileRecord(FilePointer,FilePath[CurrentArea]+RFileName);
   END;

PROCEDURE ChangeTimesDownLoaded;
    BEGIN
     WITH FileRecord DO
      BEGIN
       TimesDownLoaded :=
        GetNumber ('New Times Downloaded: ',0,999999999,TimesDownloaded,FALSE);
       END;
     ReWriteFileRecord(FilePointer,FilePath[CurrentArea]+RFileName);
    END;

PROCEDURE CopyFile;

VAR
  AreaTo   : BYTE;
  TempStr  : STRING;
  Code     : INTEGER;
  TempFile : FILE of FileAreaRecord;
  NSize    : LONGint;


BEGIN
  TempStr := GetInput ('Area to MOVE file to <ENTER / abort>: ',lcase,echo,2);
  AreaTo := 0;
  Val (TempStr,AreaTo,Code);
  If AreaTo = 0 THEN Exit;
  IF AreaTo <=  NumberOfAreas THEN
   BEGIN
    Assign (TempFile,FilePath[AreaTo]+RFileName);
    {$I-}
     Reset (TempFile);
    {$I+}
    IF IOResult <> 0 THEN
     BEGIN
      ReWrite (TempFile);
     END;
    NSize := FileSize (TempFile);
    IF NSize = 0 THEN NSize := 1;
    Close (TempFile);
    ReWriteFileRecord(NSize,FilePath[AreaTo]+RFileName);
    FileRecord.Deleted := TRUE;
    ReWriteFileRecord(FilePointer,FilePath[CurrentArea]+RFileName);
    SwapVectors;
    Exec('Command.Com','/C COPY '+FilePath[CurrentArea]+FileRecord.Filename+' '+FilePath[AreaTo]+FileRecord.Filename);
    Exec('Command.Com','/C DEL '+FilePath[CurrentArea]+FileRecord.Filename);
    SwapVectors;
    InitWindow;
    UpdateWindow (init);
    ClrScr;
   END
   ELSE Show_Error ('File Area out of Range.');
  END;

PROCEDURE ReadFirst;

 BEGIN
  FilePointer := 1;
  Assign (CurFile,FilePath[CurrentArea]+ RFileName);
  {$I-}
   Reset (CurFile);
  {$I+}
  IF IOResult = 0 then
   BEGIN
    ReadRec (FilePointer);
    J := 0;
    DisplayRecord (FilePointer);
    Close (CurFile);
   END;
  END;


BEGIN
  Done         := FALSE;
  FileChanged  := FALSE;
  GoingForward := TRUE;
  ReadFirst;
  REPEAT
   funct_num := 0;
   IF Cnum = 0 THEN FilePrompt;
   selection := getinput ('',lcase,echo,80);
   selection := allcaps (selection);
   if selection = '' then
    begin
     case  GoingForward of
      true : funct_num := 96;
      false: funct_num := 97;
     end;
    end
    ELSE Parse (Selection,p_cmd,p_min,p_max,p_abort);
   val (selection, tempint, code);
   if (selection <> MenuChoices [96]) and (selection <> MenuChoices [97])
     and (code = 0) and (funct_num = 0) then
    begin
      if  (tempint > 0) and (tempint <= LastFile) then
        begin
         Assign (CurFile,FilePath[CurrentArea]+RFileName);
         {$I-}
          Reset (CurFile);
         {$I+}
         IF IOResult = 0 then
          BEGIN
           FilePointer := tempint;
           ReadRec (FilePointer);
           DisplayRecord (FilePointer);
           Close (CurFile);
          END;
        end
      else show_error ('Out Of Range.');
    end
   else
    begin
      i := 96;
      while (i <= 110) and (funct_num = 0) do
       begin
        if (P_Cmd = MenuChoices [i])  then funct_num := i;
        i := succ (i);
       end;
      case funct_num of
        98 : begin
               done := true;
              end;
        99  : BEGIN
               Assign (CurFile,FilePath[CurrentArea]+RFileName);
               {$I-}
                Reset (CurFile);
               {$I+}
                IF IOResult = 0 then
                 BEGIN
                  ReadRec (FilePointer);
                  J := 0;
                  DisplayRecord (FilePointer);
                  Close (CurFile);
                 END;
              END;
        96  : begin
               GoingForward := true;
               if FilePointer = LastFile then show_error ('Highest File')
               else
                begin
                 FilePointer := succ (FilePointer);
                 Assign (CurFile,FilePath[CurrentArea]+RFileName);
                {$I-}
                 Reset (CurFile);
                {$I+}
                 IF IOResult = 0 then
                  BEGIN
                   ReadRec (FilePointer);
                   J := 0;
                   DisplayRecord (FilePointer);
                   Close (CurFile);
                  END;
                end;
              end;
        97 : begin
               GoingForward := false;
               if FilePointer = 1 then show_error ('Lowest File')
               else
                begin
                 FilePointer := pred (FilePointer);
                 Assign (CurFile,FilePath[CurrentArea]+RFileName);
                {$I-}
                  Reset (CurFile);
                {$I+}
                 IF IOResult = 0 then
                  BEGIN
                   ReadRec (FilePointer);
                   J := 0;
                   DisplayRecord (FilePointer);
                   Close (CurFile);
                  END;
                end;
              end;
        100 : SysopAddFile;
        101 : DeleteToggle;
        102 : CopyFile;
        103 : BEGIN
               Change_Areas;
               ReadFirst;
               END;
        104 : FileOut ('FMaint.Txt',FALSE);
        105 : ChangeUploadedBy;
        106 : ChangePassword;
        107 : ChangeUploadedBy;
        108 : ChangeDescription;
        109 : ChangeTimesDownloaded;
        110 : IF yes (C('R2')+'Log off now (y,n)? ') then Logoff;
       end;
    end;
  until (done) or (not there);
 END;

BEGIN
  IF Read_Config = 0 Then
    BEGIN
      ReadProts;
      ClearBatchList;
      LineOut (' ');
      LineOut (' ');
      Show_Error (C('C2')+'TOPquark Files Section 2.0 [BETA]');
      Quit := FALSE;
      CurrentArea := 1;
      REPEAT
        BEGIN
          Str (CurrentArea:2,TempStr);
          FilePrompt := ('Area['+Clipl(TempStr)+']:Files Command (?/list): ');
          StringOut (C('M2'));
          MainSelection := GetInput (FilePrompt,lcase,echo,40);
          MainSelection := allcaps (MainSelection);
          MenuNumber := 0;
          IF MainSelection <> '' THEN
           BEGIN
            parse (MainSelection,p_cmd,p_min,p_max,p_abort);
            i := 77;
            WHILE (i <= 95) AND (MenuNumber = 0) DO
              BEGIN
               IF MenuChoices [i] = p_cmd THEN MenuNumber := i;
               i := Succ (i);
              END;
            END;
	     CASE MenuNumber OF
              77 : ShowFileList(FilePath[CurrentArea]+RFileName);
              78 : Change_Areas;
              79 : Quit := TRUE;
              80 : Download;
              81 : Upload;
              82 : ChatCall;
              83 : BEGIN
                    FileOut ('FileMnu.Txt',FALSE);
                    If Level = Config.Sysoplevel THEN
                      BEGIN
                        Show_Error (MenuChoices[85]+ ' - Sysop Menu');
                        LineOut ('');
                      END;
                    END;
              85 : IF User.Level = Config.SysopLevel THEN FileMaintenance;
              87 : IF BatchType <>'DOWNLOAD' THEN
                     BEGIN
                      LineOut ('Add to Batch Transfer List.');
                      AddtoBatch (TRUE);
                     END
                     ELSE
                      Show_Error (C('R2')+'Sorry, you must clear the batch list to switch to uploading.');
              88 : IF BatchType <> 'UPLOAD' THEN
                     BEGIN
                      LineOut ('Add to Batch Transfer List.');
                      AddtoBatch (FALSE);
                     END
                     ELSE
                      Show_Error(C('R2')+'Sorry, you must clear the batch list to switch to downloading.');
              89 : DisplayBatch;
              90 : ClearBatchList;
              91 : IF yes (C('R2')+'Log off now (y,n)? ') then Logoff;
             END;                  {end of case}

           END;
       UNTIL (NOT there) OR (QUIT);
    END;
   END;

END.