
 UNIT Message;

 INTERFACE
   Uses Dos,Crt,QBBS,Chario,Strstuff,SpaceStf,InitBBS,Ibmcom1d;
   PROCEDURE FileOut (FileName : STRING; LogFile : BOOLEAN);
   PROCEDURE Version;
   PROCEDURE ChatCall;
   PROCEDURE Feedback;
   PROCEDURE ChangeConfig;
   PROCEDURE Bulletins;
   PROCEDURE Doors;
   PROCEDURE UserStatus;
   PROCEDURE BoardHeader;
   PROCEDURE BoardStatus (number : INTEGER);
   PROCEDURE MasterStats;
   PROCEDURE ShowDiskSpaceStuff;
   PROCEDURE CloseBoard (number : INTEGER);
   PROCEDURE AreaChange (Cboard : BOOLEAN);
   PROCEDURE SaveMessageData (board_to_save : INTEGER;Bypass:BOOLEAN);
   PROCEDURE ReadHeader (number : INTEGER);
   PROCEDURE ReadTextFile (Tpath:STRING;BoardToSave:INTEGER);
   PROCEDURE DisplayHeader (number : INTEGER);
   PROCEDURE SuckinText (number : INTEGER);
   PROCEDURE DisplayMessage (number : INTEGER);
   PROCEDURE SaveMessage(board_to_save : INTEGER);
   PROCEDURE edit (start_line : INTEGER; board_to_save : INTEGER);
   PROCEDURE EditOptions (board_to_save : INTEGER);
   PROCEDURE post (board_number : integer; personto, alaisto: NameType; reference:LONGINT;
                   oldtitle : nametype; Force: BOOLEAN);
   PROCEDURE SendMail;
   PROCEDURE FindMail (VAR Index : INTEGER; VAR Ok : BOOLEAN);
   PROCEDURE ReadMail;
   PROCEDURE CheckMail;
   PROCEDURE Email;




 IMPLEMENTATION

   Uses Windows;

FUNCTION Exists(FileName: STRING): BOOLEAN;

    VAR Found        : BOOLEAN;
        Scratch_File : TEXT;

   BEGIN
      Assign(Scratch_File, FileName);
      {$I-} Reset(Scratch_File) {$I+};
      Found := (IOresult = 0);
      IF found Then Close(Scratch_File);
     Exists := Found;
  END;

PROCEDURE FindMail (var index : integer; var ok : boolean);
 begin
   ok := false;
   while (index <= boardpack [0].total_msgs) and (there) and (not ok) do
     begin
       if hash (user.name) = mail_to_hash [index] then
         begin
           seek(headerfile,boardpack [0].messageindex [index]);
           read(headerfile,messageheader);
           if user.name = messageheader.personto then ok := true else index := index + 1;
         end
       else index := index + 1;
     end;
 end; { end of procedure }


procedure ReadMail;
 var
  option     : string[30];
  old_msg_area_number : integer;
  ok         : boolean;
  index      : INTEGER;
  oldmsgptr  : INTEGER;
  AlaisUsed  : BOOLEAN;
  OldAlais   : STRING;
  Read       : BOOLEAN;

 procedure kill_mail;
  var
    x : integer;
  begin
   messageheader.deleted := true;
   seek(headerfile, filepos(headerfile) - 1);
   write(headerfile,messageheader);
  end; { end of kill message procedure }


 procedure forwardmail;
  var
   tempinput : string[25];
   oldindex  : integer;
   ok        : boolean;
   dummy     : integer;
  begin
   ok := false;
   repeat
     tempinput := getinput('Forward to: ',ucase,echo,25);
     if (tempinput <> '') then
       begin
        if tempinput = user.name then
         lineout('You may not forward mail to yourself.')
        else
         begin
           if FindHash(tempinput,dummy) then ok := true
           else
             begin
              lineout('User not found!');
               lineout('Retry or <ENTER> to abort');
             end;
         end;
       end;
   until (Tempinput = '') or (not there) or (ok);
   if (ok) and (there) then
      begin
       mail_to_hash [index] := hash (tempinput);
       seek(headerfile, filepos (headerfile) - 1);
       messageheader.personto := tempinput;
       write(headerfile, messageheader);
      end;
  end;

 procedure pack_mail_to_hash;
  var
   x : integer;
  begin
   WITH Boardpack [0] Do
     BEGIN
      if total_msgs = 1 then total_msgs := 0
   else
     begin
       for x := index to (total_msgs) do
        begin
          mail_to_hash [x] := mail_to_hash [x + 1];
	  messageindex [x] := messageindex [x + 1];
        end;
       total_msgs := pred (total_msgs);
       total_deleted := succ (total_deleted);
       blocks_deleted := blocks_deleted + messageheader.totalblocks;
     end;
   END;
  end;


 begin;
   WITH BoardPack [0] Do

    BEGIN
     Read := FALSE;
     if (total_msgs > 0) THEN
      begin
        old_msg_area_number := MsgAreaNumber;
        if old_msg_area_number <> 0 then
          begin
            CloseBoard (MsgAreaNumber);
            OpenBoard (0);
            MsgAreaNumber := 0;
          end;
        Index := 1;
        repeat
	  if total_msgs > 0 then findmail (index, ok) else ok := false;
          If ok then
               begin
                   ClearBreak;
                   EnableBreak;
                   Read := TRUE;
                   ReadHeader (index);
                   DisplayHeader (index);
                   DisplayMessage (index);
                   DisableBreak;
                   repeat
                     StringOut (C('C'));
                     option := getinput ('R, K, /, F, Q, N, ?: ',ucase,echo,30);
                     if option = '' then option := 'N';
                     case option [1] of
                       '/' : begin;
                              ClearBreak;
                              EnableBreak;
                              DisplayHeader (index);
                              DisplayMessage (index);
                              DisableBreak;
                             end;
                       'R' : BEGIN
                               OldMsgPtr := BoardPack[0].msg_pointer;
                               BoardPack[0].msg_pointer := index;
                               WITH Messageheader do
                                BEGIN
                                 OldAlais :=User.Alais;
                                 If Alaisto <> personto then
                                  BEGIN
                                   User.Alais :=Alaisto;
                                   IF Not (User.AlaisOn) THEN AlaisUsed:=TRUE;
                                   User.AlaisOn := TRUE;
                                  END
                                  ELSE AlaisUsed :=FALSE;
                                 post (0,from,alais,0,title,FALSE);
                                 User.Alais :=OldAlais;
                                 IF AlaisUsed THEN User.AlaisOn := FALSE;
                                END;
                               LineOut (C('R2'));
                               BoardPack[0].msg_pointer := OldMsgPtr;
                               If Yes('Delete Mail Now (y,n)? ') THEN
                                BEGIN
                                 ReadHeader (Index);
                                 kill_mail;
                                 pack_mail_to_hash;
                                END;
                               StringOut (C('W2'));
                             end;
                       'K' : begin
                               kill_mail;
                               pack_mail_to_hash;
                             end;
                       'F' : forwardmail;
                       '?' : begin
                                lineout (C('Y2'));
                                lineout ('(R)eply (K)ill (/) Re-read');
                                lineout ('(F)orward (Q)uit (N)ext');
                                lineout ('');
                             end;
                       'N' : index := succ (index);
                       end;
                   until (option [1] in ['Q','R','N','K','F']) or (not there);
                   StringOut (C('W2'));
               end
                Else
                 IF NOT Read THEN Show_Error ('Sorry, no mail for you today...');

        until (not OK) or (option [1] = 'Q') or (not there) or (index > boardpack [0].total_msgs);
        if old_msg_area_number <> 0 then
          begin
            CloseBoard (MsgAreaNumber);
            MsgAreaNumber := old_msg_area_number;
            OpenBoard (MsgAreaNumber);
          end;
      end
    else lineout (C('B2')+'No mail for you...');
   END; {Of WITH}
end; { end of procedure }


procedure CheckMail;
 var
  question : string [5];
  index    : integer;
  ok       : boolean;
 begin
   if boardpack [0].total_msgs > 0 then
    begin
      MsgAreaNumber := 0;
      OpenBoard (MsgAreaNumber);
      Index := 1;
      findmail (index, ok);
      if Ok then
        begin
          lineout('');
          StringOut (C('G2'));
          lineout('You have mail!');
          StringOut (C('B2'));
          if yes ('Read now (y/n)? ') then ReadMail;
          StringOut (C('W2'));
        end
      else
        begin
          lineout('');
          StringOut (C('B2'));
          lineout('Sorry, no mail for you today...');
          StringOut (C('W2'));
          lineout('');
        end;
      CloseBoard (MsgAreaNumber);
    end;
 end; {end of procedure}



procedure Email;
 VAR
  option  : STRING[3];

 BEGIN
  REPEAT
   BEGIN
    If Cnum = 0 THEN
     BEGIN
      StringOut (C('M2')+'[R]ead');
      StringOut (C('G2')+' [S]end');
      StringOut (C('C2')+' [Q]uit: ');
     END;
    option := getinput ('',ucase,echo,3);
    if option <> '' then
     case option [1] of
        'R' : ReadMail;
        'S' : SendMail;
      end;
    END;
  until (option = 'Q') or (not there);
 end;


 VAR
  AnsiX  : BYTE;
  AnsiY  : BYTE;

PROCEDURE InterpretAnsi(Message:STRING);

VAR A : Byte;
    Num : Array[1..8] of Byte;
    NumTotal : Byte;
    Code     : Word;
    NumStr   : String[4];
  Begin
  For A := 1 to 8 Do
    Num[A] := 1;                           { default all numbers to 1 }
  NumStr := '';
  NumTotal := 0;
  For A := 3 to Length(Message) Do
    Begin
    If Message[A] in ['0'..'9'] Then
      NumStr := NumStr + Message[A]
    Else
      If NumStr <> '' Then
        Begin
        Inc(NumTotal);
        Val(NumStr,Num[NumTotal],Code);
        NumStr := '';
        End;
    End;

  Case Message[Length(Message)] of
    's' : Begin
          AnsiX := WhereX;                 { Save Cursor }
          AnsiY := WhereY;
          End;
    'u' : Gotoxy(AnsiX,AnsiY);             { Restore Cirsor }
    'J' : If Num[1] = 2 Then
            ClrScr
          Else
            Write(Message);
    'K' : ClrEol;
'f','H' : Gotoxy(Num[2],Num[1]);
    'A' : For A := 1 to Num[1] Do
            If WhereY > 1 Then
              Gotoxy(WhereX,WhereY-1);
    'B' : For A := 1 to Num[1] Do
            If WhereY < 25 Then
              Gotoxy(WhereX,WhereY+1);
    'C' : For A := 1 to Num[1] Do
            If WhereX < 80 Then
              Gotoxy(WhereX+1,WhereY);
    'D' : For A := 1 to Num[1] Do
            If WhereX > 1 Then
              Gotoxy(WhereX-1,WhereY);
    'm' : For A := 1 to NumTotal Do
            Begin
            Case Num[A] of
              0 : TextAttr := 7;                       { Reset all attributes }
              1 : TextAttr := TextAttr or 8;           { Bold on }
              4 : TextAttr := (TextAttr And $F8) or 1; { Underline on }
              5 : TextAttr := TextAttr or $80;         { Blink on }
              7 : TextAttr := (TextAttr And $88) or 7; { Reverse video }
              8 : TextAttr := TextAttr And $88;        { Conceal on }
             30 : TextAttr := (TextAttr And $F8) or Black;
             31 : TextAttr := (TextAttr And $F8) or Red;
             32 : TextAttr := (TextAttr And $F8) or Green;
             33 : TextAttr := (TextAttr And $F8) or Brown;
             34 : TextAttr := (TextAttr And $F8) or Blue;
             35 : TextAttr := (TextAttr And $F8) or Magenta;
             36 : TextAttr := (TextAttr And $F8) or Cyan;
             37 : TextAttr := (TextAttr And $F8) or LightGray;
             40 : TextAttr := (TextAttr And $8F) or ($10 * Black);
             41 : TextAttr := (TextAttr And $8F) or ($10 * Red);
             42 : TextAttr := (TextAttr And $8F) or ($10 * Green);
             43 : TextAttr := (TextAttr And $8F) or ($10 * Brown);
             44 : TextAttr := (TextAttr And $8F) or ($10 * Blue);
             45 : TextAttr := (TextAttr And $8F) or ($10 * Magenta);
             46 : TextAttr := (TextAttr And $8F) or ($10 * Cyan);
             47 : TextAttr := (TextAttr And $8F) or ($10 * LightGray);
             End;
            End;
    End;
  End;


 PROCEDURE FileOut (filename : STRING; logfile : BOOLEAN);



    VAR
       TextFile                    : TEXT;
       Text_Line                   : STRING;
       Temp_Line                   : STRING;
       Goahead                     : BOOLEAN;
       Temp                        : STRING;
       Counter                     : INTEGER;
       Whatnot                     : STRING;
       I,J,K                       : INTEGER;
       Ansi_Line                   : STRING;
       Exit                        : BOOLEAN;

    PROCEDURE CheckDate (TestStr : AnyString);

       VAR

          Date_Array       :ARRAY[1..3] OF STRING[5];
                                   {Month,Day,Year}
          Year,Day,Month   :INTEGER;
          Code             :INTEGER;
          I                :INTEGER;
          J                :INTEGER;
          Error            :BOOLEAN;

       BEGIN
          IF TestStr <>'' THEN
           BEGIN
             Error := FALSE;
             GoAhead := TRUE;
             FOR I := 1 TO 3 DO Date_Array[I] :='';
             J := 0;
             FOR I := 1 TO Length (TestStr) DO
              BEGIN
                IF (TestStr[I] IN ['%',' ','-','.','/'])
                 AND (J < 3) THEN J:=Succ(J)
                  ELSE
                   IF (TestStr[I] IN ['0'..'9']) AND (J <> 0) THEN
                   BEGIN
                    Date_Array[J] :=Date_Array[J] + TestStr[I];
                   END
                  ELSE
                   Error := TRUE;
             END;
             IF (NOT Error) THEN
              BEGIN
                Val (Date_Array[1],month,Code);
                Val (Date_Array[2],Day,Code);
                Val (Date_Array[3],Year,Code);
                IF Year < 1900 THEN Year := Year + 1900;
                IF (year < user.year) OR (Month < User.Month)
                 OR (Day  < User.day) THEN GoAhead :=FALSE;
             END;
          END;
       END;



    BEGIN                          {FileOut}
       Assign (textfile,filename);
  {$I-}
       Reset (textfile);
  {$I+}
       IF IOResult = 0 THEN BEGIN
          Goahead := TRUE;
          Counter := 0;
          ClearBreak;
          EnableBreak;
          StringOut (C('W2'));
          REPEAT
             BEGIN
                Readln (textfile, text_line);
                Counter := Counter + 1;
                IF (Counter > PageLength) and (MoreOn) THEN
                 BEGIN
                  Counter :=0;
                  StringOut (C('G2')+'[MORE (Y,n)]: ');
                  StringOut (C('W2'));
                  Whatnot := ReadC;
                  IF (WhatNot ='N') or (WhatNot ='n') THEN GoAhead := FALSE;
                  IF WhatNot = '' then J := 1 ELSE J := 0;
                  For I := 1 to 14 + J do StringOut (^H);
                  For I := 1 to 14 + J do StringOut (' ');
                  For I := 1 to 14 + J do StringOut (^H);
                 END;

                Temp_Line := AllCaps (Clip(Text_Line));

                IF (Temp_Line[1] = '~') AND (User.Level <> 255) THEN
                 BEGIN
                  {This way nothing gets displayed for this line.}
                 END
                 ELSE
                IF Temp_line ='%BREAK ON'  THEN BEGIN
                   ClearBreak;
                   EnableBreak;
                END
                ELSE IF Temp_line ='%BREAK OFF' THEN BEGIN
                   ClearBreak;
                   DisableBreak;
                END
                ELSE IF Temp_line ='%KEYS'      THEN BEGIN
                   Show_Error ('-^C to Abort / ^S to Pause / ^Q to Resume-');
                   LineOut ('');
                END
                ELSE IF Temp_line ='%PAUSE'     THEN BEGIN
                   StringOut ('Press <Enter>:');
                   REPEAT
                      Temp := ReadC
                   UNTIL (Temp =^M) OR (BREAK) OR (NOT There);
                   LineOut ('');
                END
                ELSE IF Temp_line[1] ='%' THEN BEGIN
                   CheckDate(Temp_Line);
                END
                ELSE If GoAhead THEN
                 BEGIN
                  K := 0;
                  If (Text_Line[1]='~') THEN K := K + 1; {Don't Show ~}
                  IF Text_Line = '' THEN LineOut ('')
                  ELSE
                  BEGIN
                  REPEAT
                   BEGIN
                    K := Succ (K);
                    Ansi_Line := '';
                    IF Text_Line [K] = ESC THEN
                     BEGIN
                      Ansi_Line := ESC;
                      Exit := FALSE;
                      REPEAT
                       BEGIN
                        K := Succ (K);
                        If Text_Line [K] <> ESC THEN
                        Ansi_Line := Ansi_Line + Text_Line [K]
                        ELSE
                         BEGIN
                          K := Pred(K);
                          Exit := TRUE;
                         END;
                       END;
                      UNTIL (Text_Line [K] = 'm') or (Text_Line [K] = ^M) or
                       (Not THERE) OR (BREAK) or (K >= Length (Text_Line)) or
                       (EXIT) or (Text_Line[K] = 's') or (Text_Line[K] = 'u')
                       or (Text_Line [K] = 'J') or (Text_Line [K] = 'K') or
                       (Text_Line[K] = 'f') or (Text_Line[K] = 'A') or
                       (Text_Line[K] = 'C') or (Text_Line[K] = 'H') or
                       (Text_Line[K] = 'B') or (Text_Line[K] = 'D');
                     END;
                     If Ansi_Line <> '' THEN
                      BEGIN
                       If Connect_Mode <> LOCAL THEN Com_Tx_String (Ansi_Line);
                       InterpretAnsi(Ansi_Line);
                      END
                      ELSE
                      StringOut (Text_Line [K]);
                   END;
                  UNTIL (Text_Line [K] = ^M) or (K >= Length (Text_Line))
                   or (BREAK) Or (NOT there);
                  Text_Line :='';
                  LineOut ('');

                 END;
             END;
          END;
          UNTIL Eof (textfile) OR (BREAK) OR (NOT Goahead) or (NOT There);
          DisableBreak;
          Close (textfile);
       END
       ELSE BEGIN
          IF NOT Logfile THEN Show_Error (filename  + ' has run away...please tell sysop!')
          ELSE Show_Error ('No Log Today.');
       END;
       LineOut ('');
    END;


 PROCEDURE Version;

    BEGIN
       EnableBreak;
       lineout (C('C2'));
       lineout (softwarename);
       lineout (C('G2'));
       LineOut ('Programmers: ');
       LineOut (C('C2'));
       StringOut (' John Lorance  ');
       StringOut (C('R2')+'Mark Firestone');
       LineOut (C('Y2')+'  Wayne Conrad ');
       LineOut (C('G2'));
       LineOut ('Thanks to: ');
       LineOut (C('M2'));
       StringOut ('Sue Widemark');
       LineOut ('');
       Lineout (C('G2'));
       LineOut ('For all her kind assistance (and code)...');
       lineout (C('R2'));
       lineout ('This software is based on a program by John Lorance called QBBS.');
       LineOut ('It has been translated to Turbo Pascal 5.5 and rewritten.');
       LineOut (C('M2'));
       LineOut (CompileDate);
       lineout ('');
       DisableBreak;
    END;


 PROCEDURE ChatCall;

    VAR
       i : INTEGER;

    BEGIN
       LineOut (C('C2'));
       i := 1;
       Yelling := TRUE;
       UpdateWindow (Yell);
       ChatTimes := Succ (ChatTimes);
       IF ChatTimes <= Config.ChatLimit THEN
         BEGIN
          StringOut (Config.chatCall1);
          IF NOT silence THEN
            BEGIN
              WHILE (i <= 1500) AND (there) DO
               BEGIN
                I := I + 100;
                Sound (I);
                Delay (50);
               END;
              NoSound;
            END;
          IF NOT silence THEN
            BEGIN
              WHILE (i >= 0) AND (there) DO
               BEGIN
                I := I - 100;
                Sound (I);
                Delay (50);
               END;
             NoSound;
            END;
          LineOut (C('M2'));
          LineOut (Config.AfterChat);
          LineOut ('');
         END
         ELSE
         BEGIN
          LineOut (C('R2'));
          LineOut (Config.TooManyChat);
          LineOut (' ');
         END;
    END;

 PROCEDURE feedback;

    VAR
       DONE : BOOLEAN;
       Tempnum : INTEGER;

    BEGIN
       DONE := FALSE;
       REPEAT
          BEGIN
             LineOut (C('M2'));
             LineOut ('Send feedback to:');
             StringOut  (C('G2')+'    1 : ');
             LineOut (Config.SysopName);
             IF Config.SysopName2 <> '' THEN
              BEGIN
               StringOut  (C('M2')+'    2 : ');
               LineOut (Config.SysopName2);
              END;
             IF Config.SysopName3 <> '' THEN
              BEGIN
               StringOut  (C('Y2')+'    3 : ');
               Lineout (Config.SysopName3);
              END;
              TempNum :=0;
             Tempnum := GetNumber ('Which would you like? ',1,3,TempNum,FALSE);
             CASE TempNum OF
                1 : BEGIN
                   LineOut ('To: ' + Config.SysopName);
                   Post (0,Config.Sysopname,'',0,'',FALSE);
                   Done := TRUE;
                END;
                2 : BEGIN
                   IF Config.SysopName2 <> '' THEN BEGIN
                      LineOut('To: ' + Config.SysopName2);
                      Post(0,Config.SysopName2,'',0,'',FALSE);
                      Done:= TRUE;
                   END
                   ELSE Show_Error ('No such Sysop.');
                END;
                3 : BEGIN
                   IF Config.SysopName3 <> '' THEN BEGIN
                      LineOut ('To: ' + Config.SysopName3);
                      Post (0,Config.SysopName3,'',0,'',FALSE);
                      Done := TRUE;
                   END
                   ELSE Done :=TRUE;
                END;
             END;                  {Of Case}
          END;                     {Of Repeat}
       UNTIL (DONE) or (NOT THERE) or (TempNum = 0);
    END;




 PROCEDURE ChangeConfig;

    VAR
       question : STRING[80];
       EXIT     : BOOLEAN;

    PROCEDURE change_width;

       BEGIN
          lineout (C('G2'));
          Stringout ('Screen Width is ');
          StringOut (C('R2')+ stri (user.width));
          StringOut (C('G2')+' characters');
          StringOut (C('C2'));
          LineOut ('');
          user.width := getnumber('Screen width (20-80): ',20,80,user.width,FALSE);
          term_width := user.width;
          lineout (C('W2'));
       END;

    PROCEDURE ChangeLines;

       BEGIN
          lineout (C('G2'));
          Stringout ('Screen Length is: ');
          StringOut (C('R2')+ stri (user.scrnlines));
          StringOut (C('G2')+' lines.');
          StringOut (C('C2'));
          LineOut ('');
          user.scrnlines :=
           getnumber('Screen Length (10-60)? ',10,60,user.scrnlines,FALSE);
           pagelength := user.Scrnlines;
          lineout (C('W2'));
       END;

    PROCEDURE Toggle_Graphics;

       BEGIN
          User.Graphics := NOT User.Graphics;
          StringOut (C('G2')+'Graphics Now ');
          IF User.Graphics THEN LineOut (C('M2')+'On')
          ELSE LineOut ('Off');
       END;

    PROCEDURE ToggleMore;

       BEGIN
          User.MorePrompt := NOT User.MorePrompt;
          StringOut (C('G2')+'More Prompt Now ');
          IF User.MorePrompt THEN LineOut (C('M2')+'On')
          ELSE LineOut ('Off');
          MoreOn := User.MorePrompt;
       END;

    PROCEDURE ToggleEdit;

       BEGIN
          User.FullEdit := NOT User.FullEdit;
          StringOut (C('G2')+'Full Screen Editor Now: ');
          IF User.FullEdit THEN LineOut (C('M2')+'On')
          ELSE LineOut ('Off');
       END;

    PROCEDURE ToggleAlias;

       BEGIN
        IF User.Alais <> 'NONE' THEN
         BEGIN
          User.AlaisOn := NOT User.AlaisOn;
          StringOut (C('G2')+'Alias Now ');
          IF User.AlaisOn THEN LineOut (C('M2')+'On')
          ELSE LineOut (C('M2')+'Off');
         END
         ELSE
         BEGIN
          LineOut (C('R2'));
          LineOut ('You must choose an alias before you can turn it on and off!');
          LineOut (C('W2'));
         END;
       END;

    PROCEDURE change_password;

       VAR
          tempSTR : STRING[8];

       BEGIN
          lineout (C('C2'));
          StringOut ('Current Password is:  ' );
          LineOut (C('M2') + user.password);
          StringOut (C('M2'));
          tempSTR := getinput ('New password (8 chars max)? ',ucase,echo,8);
          IF tempstr <> '' THEN user.password := tempstr
          ELSE show_error (C('R')+'Not changed');
          lineout (C('W2'));
       END;

  PROCEDURE Editor_Exit;

     VAR
       TempStr : STRING;

     BEGIN
      lineout (C('C2'));
      IF User.Editor_Exit ='' Then TempStr := '[Blank Line]' ELSE
        TempStr := User.Editor_Exit;
      Stringout ('Current Editor Exit is:  ');
      LineOut (C('C2') + TempStr);
      StringOut (C('M2'));
      tempSTR := getinput ('New editor exit string (<ENTER> = Blank Line): ',ucase,echo,5);
      User.Editor_Exit := tempstr;
     END;



 PROCEDURE UpdateUser;
 var
  i : integer;
 begin
    {$I-}
    Reset (userfile);
    {$I+}
    Seek (userfile,userindex [userindex_pos].recordnumber);
    CurrentTime (LogOffTime);
    CurrentDate (logOffDate);
    WITH User Do
     BEGIN
      Month     := LogOffDate.Month;
      Day       := LogOffDate.Day;
      Year      := LogOffDate.Year;
      Hour      := LogOffTime.Hour;
      Min       := LogOffTime.Min;
      DayOfWeek := LogOffDate.DayOfWeek;
      TimeLeftToday := time_limit - time_logged;
     END;

      FOR I := 0 to MaxBoards do
       User.Highest_read [I] := Boardpack [I].highest_read;
    Write (userfile,user);
    Close (userfile);
   end;

    PROCEDURE ChangeAlais;

       VAR
         TempStr : STRING[40];
         Ok      : BOOLEAN;
         Dummy   : INTEGER;

       BEGIN
         StringOut (C('C2')+'Your Current Alias is: ');
         StringOut (C('G2')+User.Alais);
         LineOut ('');
         TempStr :=getinput ('Enter your Alais: ',Ucase,TRUE,40);
         Ok := FindAlias (TempStr,Dummy);
         IF OK THEN
          BEGIN
           LineOut (C('G2'));
           LineOut ('Sorry, Alias in Use.');
           LineOut (C('W2'));
          END
          ELSE
         IF TempStr = '' THEN
          BEGIN
           User.Alais := 'NONE';
           User.AlaisOn := FALSE;
           LineOut (C('R2'));
           LineOut ('No Alias Selected.  Alias turned off.');
           LineOut (C('W2'));
          END
          ELSE
           Ok := FindHash (TempStr,Dummy);
           IF Not (OK) then User.Alais := TempStr
           ELSE
            BEGIN
             LineOut (C('G2'));
             LineOut ('Sorry, that is the real name of another user.');
             LineOut (C('W2'));
            END;
             UpdateUser;
       END;

    PROCEDURE Change_Zip_Read;

       VAR
          I      : INTEGER;
          Code   : INTEGER;
          Temp   : STRING [10];
          Exit   : BOOLEAN;
          Change : STRING[80];

       PROCEDURE Print_Header;

          VAR
             I : BYTE;
             K : BYTE;

          BEGIN
             LineOut ('');
             LineOut    ('Msg Area:123456789012345');
             StringOut  ('Zip Read:');
             FOR I := 1 TO 15 DO
                IF (I > Maxboards) OR (User.Board_Access[I] IN ['N','I']) THEN StringOut ('-')
                ELSE IF (User.Zip_Read[I]) THEN StringOut ('Y')
                ELSE IF (NOT User.Zip_Read[I]) THEN StringOut ('n');
             LineOut ('');
          END;


       BEGIN
          REPEAT
             BEGIN
                Print_Header;
                Exit := FALSE;
                LineOut ('');
                Temp := GetInput('Enter Board to Change <Q/EXIT>: ',ucase,echo,5);
                LineOut ('');
                Val (Temp,I,Code);
                IF Code = 0 THEN
                   IF (I > 0) AND (I <= Maxboards) AND (NOT(User.Board_Access[I] IN ['I','N'])) THEN User.Zip_Read[I] :=
                        NOT User.Zip_Read[I];
                LineOut ('');
                IF Temp[1] = 'Q' THEN Exit := TRUE;
             END;
          UNTIL (Exit) OR (NOT THERE);
       END;


    PROCEDURE config_menu;

       BEGIN
          ClearBreak;
          lineout ('');
          EnableBreak;
          StringOut (C('C2'));
          LineOut ('Alais Settings');
          LineOut (C('Y2'));
          LineOut (' (A)lias Toggle');
          LineOut (' (C)hange Alias');
          LineOut (C('C2'));
          LineOut ('Terminal Settings');
          LineOut (C('Y2'));
          LineOut (' (G)raphics (ANSI) Toggle');
          LineOut (' (L)ines per Page');
          LineOut (' (M)ore Prompt Toggle');
          lineout (' (W)idth');
          LineOut (C('C2'));
          LineOut ('User Attributes');
          LineOut (C('Y2'));
          LineOut (' (E)ditor Exit Change ');
          LineOut (' (F)ull Screen Editor Toggle');
          lineout (' (P)assword');
          lineout (' (Z)ip Read');
          LineOut (' (Q)uit');
          lineout (' (?)This Menu');
          DisableBreak;
          lineout ('');
       END;

    BEGIN
       IF CNum = 0 THEN config_menu;
       REPEAT
          BEGIN
             EXIT := FALSE;
             Question :='';
             Question := getinput ('Change Which <Q/Exit>: ',ucase,echo,30);
             IF Question = '' THEN Question := 'Q';
             CASE question [1] OF
                'F' : ToggleEdit;
                'P' : change_password;
                'A' : ToggleAlias;
                'E' : Editor_Exit;
                'L' : ChangeLines;
                'C' : ChangeAlais;
                'M' : ToggleMore;
                'W' : change_width;
                'Z' : change_zip_read;
                'G' : Toggle_Graphics;
                '?' : config_menu;
                'Q' : Exit := TRUE;
             END;
          END;
       UNTIL (NOT there) OR (Exit);
       lineout ('');
    END;





 PROCEDURE doors;

    TYPE

 DoorRecord = RECORD
          name     : STRING [50];
          level    : BYTE;
          dos_code : BYTE;
          FileName : STRING;
          Ratio    : REAL;
       END;

    VAR
       option    : STRING[5];
       number    : INTEGER;
       code      : INTEGER;
       Maxdoors  : BYTE;
       TempStr   : STRING;
       doorpack  : ARRAY[1..15] OF DoorRecord;



 PROCEDURE getdoors;


 var
  b_file : text;
  i      : integer;
  path   : string [30];

 procedure clear_doors;
  var
   x : integer;
  begin
   for x := 1 to 15 do
    with doorpack [x] do
     begin
      name := '';
      level := 0;
      dos_code := 0;
      FileName :='';
      Ratio    :=0;
     end;
  end;

 begin
   maxdoors := 1;
   clear_doors;
   assign (b_file,Config.Miscpath + 'DOORS.TXT');
   {$I-}
   reset (b_file);
   {$I+}
   if IOresult <> 0 then
    begin
     maxdoors := 0;
    end
   else
    begin
     repeat
       with doorpack [maxdoors] do
        begin
         readln (b_file,name);
         readln (b_file,level);
         readln (b_file,dos_code);
         Readln (b_File,FileName);
         Readln (b_file,Ratio);
        end;
       if not eof (b_file) then maxdoors := succ (maxdoors);
     until eof (b_file);
     close (b_file);
    end;
 end;

    PROCEDURE WriteDoorFile;

      VAR
       TempStr : STRING;
       TempStr1: STRING;
       TempStr2: STRING;
       TempInt : INTEGER;
       D_File  : TEXT;
       J       : INTEGER;
       Done    : BOOLEAN;

      BEGIN
       Assign (D_File,DoorPack[number].FileName);
       ReWrite (D_file);
       Writeln (D_File,Config.SystemName);
       Done := FALSE;
       TempStr :='';
       TempStr1:='';
       For J := 1 to Length (Config.SysopName) Do
        BEGIN
          IF Config.SysopName[J]=' ' THEN Done := TRUE;
          IF NOT DONE then TempStr:=TempStr+Config.SysopName[J]
          ELSE
           IF Config.SysopName[J] <> ' ' THEN
             TempStr1:=TempStr1+Config.SysopName[J];
        END;
        Writeln (D_File,TempStr);
        Writeln (D_File,TempStr1);
        Str (Config.Port_Num,TempStr);
        IF Connect_Mode = REMOTE THEN Writeln (D_File,'COM'+TempStr)
         ELSE
           Writeln (D_File,'COM0');
           Str(Config.LockedSpeed,TempStr2);
          CASE Current_Speed OF
            Slow      : TempStr :='300';
            Fast      : TempStr :='1200';
            Very_Fast : TempStr :='2400';
            Locked    : TempStr := TempStr2; {Locked Modem Speed}
          END;
         IF Connect_Mode = REMOTE THEN Writeln (D_File,TempStr+' BAUD,N,8,1')
          ELSE
           Writeln (D_File,'2400 BAUD,N,8,1');
         Writeln (D_File,'0');     {<---Find out what this does...}
         Done := FALSE;
         TempStr :='';
         TempStr1:='';
         For J := 1 to Length (User.Name) Do
          BEGIN
           IF User.Name[J]=' ' THEN Done := TRUE;
          IF NOT DONE then TempStr:=TempStr+User.Name[J]
          ELSE
           If User.Name[J] <> ' ' THEN TempStr1:=TempStr1+User.Name[J];
        END;
        Writeln (D_File,TempStr);
        Writeln (D_File,TempStr1);
        Writeln (D_File,User.CityState);
        IF User.Graphics Then Writeln (D_File,'1')
         ELSE Writeln (D_File,'0');
        Writeln (D_File,'0');   {<---Find out what this does!!!}
        Str ((Time_Limit-Time_Logged) Div 60,TempStr);
        Writeln(D_File,Tempstr);
        Close (D_file);
      END;

    PROCEDURE show_doors;

       VAR
          i : INTEGER;

       BEGIN
          lineout ('');
          EnableBreak;
          lineout (C('G2')+'Doors Available:');
          i := 1;
          WHILE (i <= maxdoors) AND (NOT BREAK) AND (there) DO
            BEGIN
             Stringout (C('B2')+'    ' + stri (i) + '...');
             StringOut (C('G2') + doorpack [i].name);
             LineOut ('');
             i := Succ (i);
            END;
          DisableBreak;
          lineout ('');
       END;

    BEGIN
       GetDoors;
       lineout ('');
       IF maxdoors = 0 THEN lineout ('NO Doors')
       ELSE IF NOT door_ok THEN lineout ('NON-BATCH run')
       ELSE BEGIN
          REPEAT
             option := '';
             StringOut (C('C2'));
             option := getinput ('Doors [1-' + stri (maxdoors) + '] <ENTER> to quit, ? to list: ',ucase,echo,5);
             IF option = '?' THEN show_doors
             ELSE IF (option <> '') AND (option <> '+') AND (option <> '-') THEN BEGIN
                Val (option,number,code);
                IF (code = 0) AND (number >= 1) AND (number <= maxdoors)
                  AND (level >= doorpack [number].level) THEN
                   BEGIN
                    IF User.Ratio >= Doorpack[Number].Ratio THEN
                     BEGIN
                      door_num := doorpack [number].dos_code;
                      STR (Number,TempStr);
                      UpdateLog ('OPENDOOR',TempStr);
                      WriteDoorFile;
                     END
                     ELSE
                     BEGIN
                      LineOut ('');
                      LineOut (C('G2')+'Sorry, but you must have a higher post/call ratio to use this door.');
                      LineOut ('Try Posting more messages. ');
                      LineOut('');
                     END;
                   END
                ELSE  IF (level <> doorpack [number].level) THEN
                 show_error (C('G2')+'Sorry, You do not have access.')
                ELSE show_error (C('R')+'Invalid Command.');
             END;
          UNTIL (NOT there) OR (door_num <> 0) OR (option = '');
       END;
       lineout ('');
    END;

PROCEDURE Bulletins;

    TYPE

 BullRecord = RECORD
          name     : STRING[50];
          FileName : STRING[50];
       END;

    VAR
       option    : STRING[5];
       number    : INTEGER;
       code      : INTEGER;
       Maxbulls  : BYTE;
       Bulls     : ARRAY[1..25] OF BullRecord;
       TempStr   : STRING;



 PROCEDURE getbulls;


 var
  b_file : text;
  i      : integer;
  path   : string [30];

 procedure clearBulls;
  var
   x : integer;
  begin
   for x := 1 to 15 do
    with Bulls [x] do
     begin
      name := '';
      Filename := '';
     end;
  end;

 begin
   maxbulls := 1;
   clearbulls;
   assign (b_file,'BULLS.TXT');
   {$I-}
   reset (b_file);
   {$I+}
   if IOresult <> 0 then
    begin
     maxBulls := 0;
    end
   else
    begin
     repeat
       with Bulls [maxbulls] do
        begin
         readln (b_file,name);
         readln (b_file,FileName);
        end;
       if not eof (b_file) then maxbulls := succ (maxbulls);
     until eof (b_file);
     close (b_file);
    end;
 end;

    PROCEDURE show_Bulls;

       VAR
          i : INTEGER;

       BEGIN
          lineout ('');
          EnableBreak;
          lineout (C('G2')+'Bulletins Available:');
          i := 1;
          WHILE (i <= maxbulls) AND (NOT BREAK) AND (there) DO
            BEGIN
             Stringout (C('B2')+'    ' + stri (i) + '...');
             StringOut (C('G2') + Bulls [i].name);
             LineOut ('');
             i := Succ (i);
            END;
          DisableBreak;
          lineout ('');
       END;

    BEGIN
       GetBulls;
       lineout ('');
       IF maxBulls = 0 THEN lineout ('Sorry, Area Closed.')
       ELSE BEGIN
          REPEAT
             option := '';
             StringOut (C('C2'));
             option := getinput ('Bulletins [1-' + stri (maxbulls) + '] (<ENTER>/quit, ?/list): ',ucase,echo,5);
             IF option = '?' THEN show_bulls
             ELSE IF (option <> '') AND (option <> '+') AND (option <> '-') THEN BEGIN
                Val (option,number,code);
                IF (code = 0) AND (number >= 1) AND (number <= maxbulls) THEN
                     BEGIN
                      STR (Number,TempStr);
                      UpdateLog ('BULL',TempStr);
                      FileOut (Bulls[Number].Filename,False);
                     END
                ELSE show_error (C('R')+'Invalid Command.');
             END;
          UNTIL (NOT there) OR (option = '');
       END;
       lineout ('');
    END;

 PROCEDURE BoardHeader;

    BEGIN
       StringOut (C('W2')+'# ');
       StringOut (C('G2')+'Live ');
       StringOut (C('C2')+'Dead ');
       StringOut (C('R2')+'Deadspace');
       LineOut ('');
       LineOut (C('Y2')+'- ---- ---- ---------');
       StringOut(C('W2'));
    END;

 PROCEDURE BoardStatus (number : INTEGER);


    VAR
       really : REAL;
       really2: REAL;

    BEGIN
       really := boardpack [number].blocks_deleted;
       really2 := boardpack[number].total_deleted;
       lineout (strif (number,2) + ' ' + strif (boardpack [number].total_msgs,3) + '  ' + strif (boardpack [number].
            total_deleted,3) + '  ' + strr ((really * 128) + (really2 * 103)));
    END;

 PROCEDURE UserStatus;

    BEGIN
       lineout (' U ' + strif (maxusers,3) + '  ' + strif (usersdeleted,3) + '  ' + stri (usersdeleted * 92));
    END;

 PROCEDURE ShowDiskSpaceStuff;

    VAR
       drive : INTEGER;

    BEGIN
       drive := Ord (boardpack [MsgAreaNumber].path [1]) - 64;
       lineout ('There is ' + strr (drive_space [drive]) + ' bytes left out of '+ strr (drive_total_avail [drive]) +
            ' bytes');
    END;

 PROCEDURE MasterStats;

    VAR
       i : INTEGER;
       drive : INTEGER;

    BEGIN
       lineout ('');
       BoardHeader;
       i := 0;
       EnableBreak;
       WHILE (i <= maxboards) AND (NOT BREAK) AND (there) DO BEGIN
          BoardStatus (i);
          i := Succ (i);
       END;
       UserStatus;
       lineout ('');
       FOR i := 1 TO 10 DO
          IF drive_total_avail [i] > 0 THEN lineout ('There is ' + strr (drive_space [i]) + ' bytes left out of '+ strr
               (drive_total_avail [i]) + ' bytes on drive ' + Chr (i + 64));

       DisableBreak;
       lineout ('');
    END;


 PROCEDURE CloseBoard (number : INTEGER);

    BEGIN
    {$I-}
       Close (headerfile);
       IF boardpack [number].total_msgs > 0 THEN Close (libfile);
    {$I+}
    END;


 PROCEDURE AreaChange (CBoard: BOOLEAN);

    VAR
       tempinput : STRING[5];
       tempint   : INTEGER;
       code      : INTEGER;
       lowestnum : INTEGER;
       lowestSTR : STRING[3];
       done      : BOOLEAN;
       change    : BOOLEAN;

    PROCEDURE list_boards;

       VAR
          i : INTEGER;
          display : BOOLEAN;
          tempSTR : STRING[5];
          tempSTR2: STRING[5];

       BEGIN
          i := 0;
          ClearBreak;
          EnableBreak;
          lineout('');
          Stringout (C('W2')+'#    ');
          StringOut (C('G2')+'New  ');
          StringOut (C('R2')+'Access  ');
          StringOut (C('B2')+'Board Description');
          LineOut (C('Y2'));
          lineout ('--   ---  ------  -----------------');
          WHILE (NOT BREAK)        {and not there}
               AND (i <= maxboards) DO BEGIN
             IF ((i = 0) AND ((user.board_access[0] <> 'N') OR (level < Config.Sysoplevel))) OR (user.board_access[i] =
                  'I') THEN display := FALSE
             ELSE display := TRUE;
             IF display THEN BEGIN
                StringOut (C('W2'));
                stringout (strif (i,2) + '   ');
                StringOut (C('G2'));
                stringout (strif (boardpack [i].total_msgs - boardpack [i].msg_pointer, 3));
                stringout ('  ');
                StringOut (C('R2'));
                CASE user.board_access [i] OF
                   'W' : stringout ('Write');
                   'N' : stringout ('None ');
                   'R' : stringout ('Read ');
                   'C' : stringout ('Cosys');
                   'M' : stringout ('Maint');
                END;
                stringout ('   ');
                StringOut (C('B2'));
                lineout (boardpack [i].name);
             END;
             i := Succ (i);
          END;
          DisableBreak;
          lineout('');
          lineout (C('W2'));
       END;


    BEGIN
       done := FALSE;
       change := FALSE;
       IF (NOT (user.board_access[0] IN ['N','I'])) OR (level = Config.SysopLevel) THEN lowestSTR := '0'
       ELSE lowestSTR := '1';
       Val (lowestSTR,lowestnum,code);
       lineout ('');
       REPEAT
          StringOut (C('W2'));
          IF (NOT p_abort) AND (p_min <> -1) THEN Str (p_min,tempinput)
          ELSE tempinput := getinput ('Area #[' + stri (MsgAreaNumber) + '] (' + lowestSTR + '-' + stri (maxboards) +
               ') ? for list, CR to quit: ' ,ucase,echo,5);

          IF tempinput <> '' THEN BEGIN
             p_min := -1;
             IF tempinput = '?' THEN list_boards
             ELSE BEGIN
                Val (tempinput,tempint,code);
                IF code = 0 THEN BEGIN
                   IF (tempint <= maxboards) AND (tempint >= lowestnum) THEN BEGIN
                      IF (NOT (user.board_access [tempint] IN ['N','I'])) OR (level = Config.SysopLevel) THEN BEGIN
                         done := TRUE;
                         IF tempint = MsgAreaNumber THEN change := FALSE
                         ELSE change := TRUE;
                      END
                      ELSE IF user.board_access [tempint] = 'N' THEN show_error ('You do not have access');
                   END;
                END;
             END;
          END
          ELSE BEGIN
             done := TRUE;
             change := FALSE;
          END;
       UNTIL (done) OR (NOT there);
       IF change THEN BEGIN
          lineout (C('G2'));
          stringout ('Changing to the ' + boardpack [tempint].name + ' sub-board...');
          If CBoard then CloseBoard (MsgAreaNumber);
          MsgAreaNumber:= tempint;
          OpenBoard (MsgAreaNumber);
          lineout ('');
          lineout ('');
       END;
    END;

PROCEDURE RecoverText (FileSpec:STRING);

  VAR
    TempFile : TEXT;
    I        : INTEGER;
    J        : INTEGER;
    Line     : STRING[80];
    Ch       : Char;

  BEGIN
   FOR i := 1 TO 6528 DO messagetext [i] := 0;
   Assign(TempFile,FileSpec);
   IF Exists(FileSpec) THEN
    BEGIN
     I := 1;
     Line := '';
     Reset (TempFile);
     Readln (TempFile,MessageHeader.PersonTo);
     Readln (TempFile,MessageHeader.From);
     Readln (TempFile,MessageHeader.Title);
     Readln (TempFile,MessageHeader.Date);
     Readln (TempFile,MessageHeader.Time);
      REPEAT
       Read (TempFile,Ch);
       IF (ch <>^j) and (ch <>^m) then Line := Line + CH
        ELSE
         BEGIN
          IF (Ch=^m) THEN
           BEGIN
            MessBuff[i] := Line;
            Line :='';
            I := I + 1;
            Read (tempfile,ch);
            IF (Ch='') and (CH <> ' ') THEN Line := Line + CH;
           END;
         END;
     UNTIL (EOF(TempFile)) or (I = 80);
     Close (TempFile);
     MaxLinesEntered := I-1;
  END;
 END;


PROCEDURE WriteTextFile (BoardToSave:INTEGER);

  VAR
        I         : INTEGER;
        J         : INTEGER;
        Counter   : INTEGER;
        Finished  : BOOLEAN;
        TempFile  : TEXT;
        TempStr   : STRING;
        TempStr2  : STRING;
        TempDir   : STRING;
        Sr        : SearchRec;
        TempInt   : INTEGER;
        Code      : INTEGER;


   BEGIN
    Finished := FALSE;
    WITH BoardPack[BoardToSave] do
     BEGIN
       J := 0;
       FindFirst (Tpath+'M*.',0,Sr);
       WHILE DosError = 0 Do
        BEGIN
         TempStr2 := Copy (Sr.Name,2,Length(Sr.Name));
         Val (TempStr2,TempInt,Code);
         IF TempInt > J THEN J := TempInt;
         Findnext (Sr);
        END;
      J := J + 1;
      Str (J,TempStr);
      Assign (TempFile,Tpath+'M'+TempStr);
     END;
      i       := 0;
      counter := 0;
      Rewrite (TempFile);
      Writeln (TempFile,MessageHeader.PersonTo);
      Writeln (TempFile,MessageHeader.From);
      Writeln (TempFile,MessageHeader.Title);
      Writeln (TempFile,MessageHeader.Date);
      Writeln (TempFile,MessageHeader.Time);
       REPEAT
        BEGIN
         i := 0;
          REPEAT
           BEGIN
            i := Succ (i);
            counter := Succ (counter);
            IF messagetext [counter] <> 0 THEN
            IF messagetext [counter] <> 13 THEN
             Write (TempFile,Chr (messagetext [counter]));
            IF messageText [Counter] = 13 THEN Writeln (TempFile);
            IF messagetext [counter] = 0 THEN Finished:= TRUE;
           END;
          UNTIL (messagetext [counter] = 13) OR (Finished);
         END;
        UNTIL (Finished);
       Close (TempFile);
      END;

PROCEDURE SaveMessageData (board_to_save : INTEGER;Bypass:BOOLEAN);
 var
  old_msg_area_number : INTEGER;
  TotalBytes          : INTEGER;
  drive               : INTEGER;
  TempInt             : INTEGER;
  Code                : INTEGER;
  TempReal            : REAL;
  TempStr             : STRING;

 BEGIN
  old_msg_area_number := MsgAreaNumber;
  IF board_to_save <> old_msg_area_number then
   BEGIN
    CloseBoard (MsgAreaNumber);
    OpenBoard (board_to_save);
    MsgAreaNumber := board_to_save;
   END;
  WITH User Do
   BEGIN
    IF NOT Bypass THEN
     BEGIN
      PostTimes   := PostTimes + 1;
      Ratio       := (PostTimes / CallTimes) * 100;
     END;
    END;
  WITH BoardPack [MsgAreaNumber] Do
   BEGIN
    IF NOT Bypass THEN
     BEGIN
      If User.AlaisOn THEN MessageHeader.Alais := User.Alais
      ELSE MessageHeader.Alais := MessageHeader.From;
     END;
    IF total_msgs = 0 then rewrite (libfile,128);
    messageheader.number := new_msg_index [total_msgs] + 1;
    IF NOT Bypass THEN
     BEGIN
      If Tpath <> '' THEN
      WriteTextFile(Board_to_Save);                 {Do Loopholes Deal}
     END;
    messageheader.startblock := filesize(libfile);
    seek(libfile, filesize (libfile));
    blockwrite(libfile, messagetext{bytestream}, messageheader.totalblocks);
    seek(headerfile,filesize(headerfile));
    write(headerfile,messageheader);       { write the message header }
    total_msgs := succ (total_msgs);
    new_msg_index [total_msgs] := succ (new_msg_index [total_msgs - 1]);
    new_since_pack := succ (new_since_pack);
    messageindex [total_msgs] := filepos (headerfile) - 1;
    if MsgAreaNumber = 0 then mail_to_hash [total_msgs] := hash (messageheader.personto);
    if board_to_save <> old_msg_area_number then
     BEGIN
      CloseBoard (MsgAreaNumber);
      MsgAreaNumber := old_msg_area_number;
      OpenBoard (MsgAreaNumber);
     END;
    drive := ord (boardpack [board_to_save].path [1]) - 64;
    DiskSpace (drive,drive_total_avail [drive],drive_space [drive]);
   END; {OF With}
  END;

  PROCEDURE ReadTextFile (Tpath:STRING;BoardToSave:INTEGER);

  VAR
        I         : INTEGER;
        J         : INTEGER;
        Counter   : INTEGER;
        Finished  : BOOLEAN;
        TempFile  : TEXT;
        TempStr   : STRING;
        TempStr2  : STRING;
        TempDir   : STRING;
        Sr        : SearchRec;
        TempInt   : INTEGER;
        Code      : INTEGER;
        bytestream  : ARRAY[1..6528] OF BYTE;
        x           : INTEGER;
        numofblocks : INTEGER;
        linecounter : INTEGER;
        bytes       : INTEGER;


   BEGIN
    Finished := FALSE;
    J := 0;
    FindFirst (Tpath+'M*.',0,Sr);
    WHILE DosError = 0 Do
     BEGIN
       numofblocks := 1;
       x           := 0;
       linecounter := 0;
       bytes       := 0;
      J:=J+1;
      Str(J,TempStr);
      LineOut ('Importing Message #'+ TempStr);
      If Exists (Tpath+Sr.Name) THEN
       BEGIN
        RecoverText(Tpath+Sr.Name);
         REPEAT
          BEGIN
           Linecounter := Succ (Linecounter);
           FOR x := 1 TO Length (MessBuff [linecounter]) DO
            BEGIN
             Bytes := Succ (bytes);
             Messagetext [bytes] := Ord (MessBuff [linecounter][x]);
            END;
           Bytes := Succ (bytes);
           Messagetext [bytes] := 13;
          END;
        UNTIL (linecounter = MaxLinesEntered);
        numofblocks := bytes DIV 128;
        IF bytes MOD 128 <> 0 THEN numofblocks := Succ (numofblocks);
        messageheader.totalblocks := numofblocks;
        SaveMessageData(BoardToSave,TRUE);
       END ELSE Show_Error ('Logic Error In Import.  Please Panic.');
       FindNext(sr);
      END;
     END;

 PROCEDURE ReadHeader (number : INTEGER);

    BEGIN
       Seek(headerfile,boardpack [MsgAreaNumber].messageindex [number]);
       Read(headerfile,messageheader);
    END;

 PROCEDURE DisplayHeader (number : INTEGER);

    VAR
      Disp : BOOLEAN;

    BEGIN
      LineOut('');
      StringOut(C('W2')+'#' + stri (number));
      IF MessageHeader.Locked THEN StringOut (C('R')+'  [Locked]');
      StringOut('   '+ C('B2')+messageheader.date + ' / ' + messageheader.time);
      LineOut ('');
      If MessageHeader.AlaisTo = MessageHeader.PersonTo THEN
       BEGIN
        StringOut (C('C2')+'To:    ');
        StringOut (PadR(C('G2')+ MessageHeader.PersonTo,33))
       END
       ELSE
       BEGIN
        StringOut (C('C2')+'To:    ' );
        StringOut (PadR(C('G2')+ MessageHeader.Alaisto,33));
       END;
      StringOut (C('C2')+'Absolute:   ');
      StringOut (C('G2')+ stri(MessageHeader.Number));
      LineOut ('');
      If MessageHeader.Alais = MessageHeader.From THEN
       BEGIN
        StringOut (C('C2')+'From:  ');
        StringOut (PadR(C('G2') + MessageHeader.From,33));
       END
       ELSE
       BEGIN
        StringOut (C('C2')+'From:  ');
        StringOut (Padr(C('G2')+MessageHeader.Alais,33));
       END;
      IF MessageHeader.Reference <> 0 THEN
       BEGIN
        StringOut (C('C2')+'Reference:  ');
        StringOut (C('G2')+stri(MessageHeader.Reference));
       END
      ELSE
       BEGIN
        StringOut (C('C2')+'Reference:  ');
        StringOut (C('G2')+'NONE');
       END;
      LineOut ('');
      StringOut (C('C2')+'Title: ');
      StringOut (Padr(C('G2')+ MessageHeader.Title,33));
       If User.Level = Config.SysopLevel THEN
         If MessageHeader.Alais <> MessageHeader.From THEN
         BEGIN
          StringOut (C('C2')+'Real Name:  ');
          StringOut (C('G2')+MessageHeader.From);
         END;
      LineOut ('');
      LineOut (C('Y2'));
    END;

 PROCEDURE SuckinText (number : INTEGER);

    BEGIN
       Seek(libfile,messageheader.startblock);
       BlockRead(libfile, messagetext, messageheader.totalblocks);
    END;

 PROCEDURE DisplayMessage (number : INTEGER);

    VAR
       charcounter  : INTEGER;
       done         : BOOLEAN;
       i            : INTEGER;
       Counter      : INTEGER;
       J            : INTEGER;
       L            : INTEGER;
       WhatNot      : STRING;
       ColorCode    : STRING;


    BEGIN
       FOR i := 1 TO 6528 DO messagetext [i] := 0;
       timecheck := FALSE;
       SuckinText (number);
       lineout('');
       done := FALSE;
       ColorCode := 'Y2';
       IF NOT ScanMode THEN
        BEGIN
          Counter     := 7;
          charcounter := 1;
          L := 0;
          WHILE (charcounter <= messageheader.totalblocks * 128) AND
           (NOT BREAK) AND (there) AND (NOT done) DO
            BEGIN
             IF (messagetext [charcounter] <> 0) and (Not DONE) THEN
              BEGIN
               L := L + 1;
               IF (Chr(Messagetext [CharCounter]) = '>') AND (L = 1) THEN
                StringOut (C('C2'));
               IF (Chr(MessageText [CharCounter])) in ['~','@'] THEN
                BEGIN
                 IF (CharCounter + 1) < (MessageHeader.TotalBlocks *128) THEN
                  BEGIN
                   CharCounter := CharCounter + 1;
                   IF (Chr(Messagetext [CharCounter]) in
                    ['R','r','B','b','G','g','Y','y','C','c','W','w','M','m'])
                     THEN
                     BEGIN
                      IF (CharCounter + 1) < (MessageHeader.TotalBlocks * 128)
                       THEN
                        BEGIN
                         ColorCode := Allcaps(Chr(Messagetext [CharCounter]));
                         IF (Messagetext [CharCounter + 1] = 32 )THEN
                           StringOut (C(ColorCode))
                           ELSE
                             IF(Chr(Messagetext[CharCounter + 1])) = '2' THEN
                              BEGIN
                               ColorCode := ColorCode +'2';
                               StringOut (C(ColorCode));
                               CharCounter := CharCounter +1;
                               END
                                ELSE
                                 BEGIN
                                  StringOut (C(ColorCode));
                                 END;
                          END;
                         END;
                        END;
                       END ELSE
               writec (Chr (messagetext [charcounter]))
              END
             ELSE done := TRUE;
             IF MessageText[CharCounter]=13 then
              BEGIN
               L := 0;
               Counter := Counter + 1;
               StringOut (C(ColorCode));
              END;
             IF (Counter > PageLength) and (MoreOn) THEN
               BEGIN
                Counter :=1;
                StringOut (C('G2')+'[MORE (Y,n)]: ');
                StringOut (C(ColorCode));
                WhatNot := ReadC;
                IF (WhatNot ='N') or (WhatNot ='n') THEN Done := TRUE;
                  IF WhatNot = '' then J := 1 ELSE J := 0;
                  For I := 1 to 14 + J do StringOut (^H);
                  For I := 1 to 14 + J do StringOut (' ');
                  For I := 1 to 14 + J do StringOut (^H);
                 END;
             charcounter := Succ (charcounter);
          END;
          lineout('');
          lineout('');
       END;
       timecheck := TRUE;
    END;                           { End of display message }

 PROCEDURE SaveMessage(board_to_save : INTEGER);

    VAR
       bytestream  : ARRAY[1..6528] OF BYTE;
       x           : INTEGER;
       numofblocks : INTEGER;
       linecounter : INTEGER;
       bytes       : INTEGER;
       old_msg_area_number : INTEGER;
       drive               : INTEGER;
       TempStr             : STRING;

    BEGIN
       FillChar (messagetext,6528,0);
       numofblocks := 1;
       x           := 0;
       linecounter := 0;
       bytes       := 0;
       lineout ('');
       LineOut (C('G2')+'Saving....');
       REPEAT
          linecounter := Succ (linecounter);
          FOR x := 1 TO Length (MessBuff [linecounter]) DO BEGIN
             bytes := Succ (bytes);
             messagetext [bytes] := Ord (MessBuff [linecounter][x]);
          END;
          bytes := Succ (bytes);
          messagetext [bytes] := 13;
       UNTIL (linecounter = MaxLinesEntered);
       WITH User Do
         BEGIN
           STR (Bytes,TempStr);
           StringOut (C('C2'));
           StringOut (TempStr + ' Bytes Saved  /  ');
           BytesPosted :=BytesPosted + Bytes;
           STR (BytesPosted,TempStr);
           StringOut (C('R2'));
           StringOut (TempStr +' Total Bytes Posted.');
           LineOut (C('W2'));
         END;
       numofblocks := bytes DIV 128;
       IF bytes MOD 128 <> 0 THEN numofblocks := Succ (numofblocks);

       messageheader.totalblocks := numofblocks;
       messageheader.from        := user.name;
       SaveMessageData (board_to_save,FALSE);
       lineout ('');
       IF ed_ing THEN ed_saved := TRUE;
    END;                           { end of SAVE procedure }


{$I Edit.Inc}

 PROCEDURE sendmail;

    VAR
       towhom     : STRING[25];
       dummy      : INTEGER;
       OldPointer : INTEGER;

    BEGIN
       REPEAT
          StringOut (C('C2'));
          towhom := getinput ('To: ',ucase,echo,25);
          IF towhom <> '' THEN BEGIN
             IF FindHash (towhom,dummy) THEN BEGIN
                OldPointer :=BoardPack[0].Msg_Pointer;
                BoardPack[0].Msg_Pointer :=0;
                post (0, towhom,'',0,'',FALSE);
                BoardPack[0].Msg_Pointer :=OldPointer;
                towhom := ''
             END
             ELSE lineout ('User not found...');
          END;
       UNTIL (towhom = '') OR (NOT there);
       StringOut (C('W2'));
    END;


 END.
