UNIT FileSys;

INTERFACE

  Uses Dos,Crt,QBBS,Chario,Strstuff,SpaceStf,InitBBS,Message,Read,Sysop,Login,
       ConfigBBS,windows;

PROCEDURE Filemenu;

IMPLEMENTATION

PROCEDURE Filemenu;

CONST
  PageLength             = 24;    {Put this in a config ...}

TYPE

  DescriptionType  = STRING [40];
  TitleType        = STRING [30];
  Name             = STRING [40];
  CommandType      = STRING [20];

ExternalProtocolRecord = RECORD
          Name         : STRING[40];
          Path         : STRING[40];
          UpString     : STRING[30];
          DownString   : STRING[30];
          Command      : STRING[5];
       END;


VAR
  AreaName         : Array [1..30] of STRING [40]; {Arrays for holding File Info}
  FilePath         : Array [1..30] of STRING [40];
  AreaFile         : Array [1..30] of STRING [40];
  AreaLevel        : Array [1..30] of BYTE;
  Prots            : ARRAY [1..15] of ExternalProtocolRecord;
  ScratchFile      : FILE;
  NumberOfAreas    : BYTE;
  CurrentArea      : BYTE;                    {Area I'm In...}
  MainCommand      : CommandType;            {The Main Command}
  TempStr          : STRING;
  Count            : INTEGER;
  Quit             : BOOLEAN;
  MainSelection    : STRING;
  FilePrompt       : STRING;
  MenuNumber       : BYTE;
  I                : BYTE;
  MaxProts         : BYTE;


PROCEDURE ClearArrays;

   VAR Count : INTEGER;

   BEGIN
  For Count := 1 to 30 do
       BEGIN
         AreaName[Count] := '';
         FilePath[Count] := '';
         AreaFile[Count] := '';
         AreaLevel[Count]:= 0;
       END;
     END;


FUNCTION Read_Config: BYTE;

  VAR
    ScratchFile : TEXT;
    Count       : INTEGER;

 CONST
   Data_File = 'FileArea.Txt';

  BEGIN
    Count := 0;
    ClearArrays;
    Assign  (ScratchFile,Config.Miscpath+Data_File);
    {$I-} Reset (ScratchFile); {$I+}
    If IOresult = 0 then
      BEGIN
        REPEAT
            Count := Succ(Count);
            ReadLn (ScratchFile,AreaName[Count]);
            ReadLn (ScratchFile,FilePath[Count]);
            ReadLn (ScratchFile,AreaFile[Count]);
            ReadLn (ScratchFile,AreaLevel[Count]);
        UNTIL (Count = 30) or (SEEKEOF (ScratchFile));
        NumberofAreas := Count;
        Close (ScratchFile);
        Read_Config := 0;
      END
      ELSE
       BEGIN
         Show_Error('Sorry, File Section Closed for Configuration.');
         Read_Config :=1;
         Close (ScratchFile);
       END;
    END;

 PROCEDURE List_Areas;

     VAR   Count : BYTE;

     BEGIN
       ClearBreak;
       Count := 0;
       LineOut (C('Y2'));
       StringOut ('Area ');
       StringOut (C('G2')+'     Description');
       LineOut ('');
       StringOut (C('Y2'));
       StringOut ('---- ');
       StringOut (C('G2')+'     -----------');
       LineOut ('');
         REPEAT
           BEGIN
             Count := Succ (Count);
             If User.D_Level >= AreaLevel [Count] then
             BEGIN
              StringOut(C('Y2')+Strif(Count,4));
              StringOut(C('G2') + '      ');
              StringOut(AreaName[Count]);
              LineOut ('');
             END;
           END;
         UNTIL (Count = NumberofAreas) or (Not There) or (CTRL_C);
         LineOut (C('C2'));
       END;

PROCEDURE Change_Areas;

   VAR         NewArea : INTEGER;
               Prompt  : String [40];
               TempStr : String [2];
               TempS   : STRING;
               Code    : INTEGER;
               Valid   : BOOLEAN;
               TempI   : INTEGER;
               Parameter : BYTE;    {Remove after hooking upto new parser}

   PROCEDURE Change;
     BEGIN
       IF TempI > 0 Then
         BEGIN
          CurrentArea := TempI;
          LineOut (' ');
          Show_Error ('Changing to the '+AreaName[CurrentArea]+ ' area.');
         END;
     END;

   BEGIN
     Parameter :=0;
     IF (NOT p_abort) AND (p_min <> -1) THEN Parameter := p_min;
     IF Parameter <=0  Then
       BEGIN
         REPEAT
           Valid := False;
           BEGIN
             Str (CurrentArea:2,TempStr);
             Prompt := ('Area['+Clipl(TempStr)+']:New Area (?/list): ');
             TempS := GetInput (Prompt,lcase,echo,3);
             Val (TempS,TempI,Code);
             TempS :=AllCaps (TempS);
             If (TempS ='') or (TempS = 'Q') Then EXIT
               ELSE
                BEGIN
                  if ((TempI < 1) and (TempS <> '?'))
                     or (TempI> NumberofAreas) then EXIT;
                  LineOut (' ');

                  If TempS = '?' then List_Areas ELSE
                  IF User.D_level >= AreaLevel [TempI]  Then
                  BEGIN
                    Change;
                    Valid := TRUE;
                  END;
               END;
             END;
            UNTIL (VALID) or (Not THERE);
         END
         ELSE
            IF (Parameter <=NumberOfAreas) and (User.D_Level >=AreaLevel [parameter])
               Then
                 BEGIN
                    TempI := Parameter;
                    Change;
                  END;
      END;



  FUNCTION Exists(FileName: NAME): BOOLEAN;

    VAR Found        : BOOLEAN;
        Scratch_File : FILE;

   BEGIN
      Assign(Scratch_File, FileName);
      {$I-} Reset(Scratch_File) {$I+};
      Found := (IOresult = 0);
      IF found Then Close(Scratch_File);
     Exists := Found;
  END;

  FUNCTION Alpha(FileName: NAME): BOOLEAN;

    VAR
        StrPos: INTEGER;
        Okay:   BOOLEAN;
        Dots:   BYTE;

    BEGIN
      Dots := 0;
      Alpha := TRUE;
      IF Length(Filename) > 0 THEN
        FOR StrPos := 1 to Length(filename) do
          BEGIN
            IF FileName[StrPos] = '.' then Dots := Dots + 1;
            IF not (FileName[StrPos] in ['.', '-', '_', '0'..'9', 'A'..'Z'])
                or (Dots > 1)
            Then
              BEGIN
               alpha := false;
              END;
          END;
       END;




 FUNCTION Get_File_Size (TempFile : NAME):LONGINT;

 Var Temp         : LONGINT;

   BEGIN
     Assign (ScratchFile,TempFile);
     Reset (ScratchFile);
     Temp := Filesize (ScratchFile);
     Temp := Temp * 128;
     Close (ScratchFile);
     Get_File_Size := TEMP;
   END;


PROCEDURE Write_To_FileList (Record_File :TitleType;
                             FileName    :TitleType;
                             Size        :REAL;
                             Discription :DescriptionType);

  VAR
     ScratchFile  : TEXT;
     TempSize     : STRING [8];
     TempName     : STRING;
     I            : BYTE;
     J            : BYTE;
     K            : BYTE;

 BEGIN
   Assign (ScratchFile,Record_File);
   J := 0;
   For I := 1 to Length (FileName) DO
   IF FileName [I] = '\' THEN J :=I;
   IF J > 0 THEN
    BEGIN
      K := 0;
      TempName :='';
      For I := J to Length (FileName) DO
       BEGIN
        K := Succ (k);
        TempName [K] := FileName[I];
       END;
    END
    ELSE TempName := FileName;

   Str (Size:8:0,TempSize);
   If Not Exists (Record_File) Then
     BEGIN
       Rewrite (ScratchFile);
       Writeln (ScratchFile,'File Name           Size Description');
       Writeln (ScratchFile,'---------           ---- -----------');
       Close (ScratchFile);
     END;
   Append (ScratchFile);
   Writeln (ScratchFile,Padr(TempName,16),TempSize,' ',Discription);
   Close (ScratchFile);
 END;

PROCEDURE RecieveFile (FileName:TitleType;Num:BYTE);

  VAR
    Dummy  : STRING;
    Result : BYTE;



  BEGIN
    LineOut ('');
    StringOut ('Ready to Recieve File. Type <RETURN> to Start Transfer.');
    Dummy:= getinput ('',lcase,echo,2);
    Writeln ('Executing: '+ Prots[num].path,Prots[num].UpString+' '+FileName);
    SwapVectors;
    Exec(Prots[num].path,Prots[num].UpString+' '+FileName);
    SwapVectors;
  END;



PROCEDURE ReadProts;

  VAR
    ScratchFile : TEXT;
    Count       : INTEGER;

 CONST
   Data_File = 'PROTS.TXT';
PROCEDURE ClearArrays;

   VAR Count : INTEGER;

   BEGIN
  For Count := 1 to 15 do
       BEGIN
        WITH Prots [Count] Do
          BEGIN
           Name       :='';
           Path       :='';
           UpString   :='';
           DownString :='';
           Command    :='';
          END;
       END;
     END;


  BEGIN
    ClearArrays;
    Count := 0;
    Assign  (ScratchFile,Config.Miscpath+Data_File);
    {$I-} Reset (ScratchFile); {$I+}
    If IOresult = 0 then
      BEGIN
        REPEAT
         BEGIN
            Count := Succ(Count);
            WITH Prots[Count] DO
             BEGIN
              ReadLn (ScratchFile,Name);
              ReadLn (ScratchFile,Path);
              ReadLn (ScratchFile,UpString);
              ReadLn (ScratchFile,DownString);
              Readln (ScratchFile,Command);
             END;
           END;
        UNTIL (Count = 15) or (SEEKEOF (ScratchFile));
        MaxProts := Count;
        Close (ScratchFile);
      END
      ELSE
       BEGIN
        MaxProts := 0;
       END;
    END;

PROCEDURE SendFile (FileName:TitleType;Num:BYTE);

  VAR
    Dummy  : STRING;
    Result : BYTE;


  BEGIN
    LineOut (C('G2'));
    StringOut ('Sending File.  Type <RETURN> to Start Transfer.');
    Dummy:= getinput ('',lcase,echo,2);
    SwapVectors;
    Exec(Prots[num].path,Prots[num].DownString+' '+FileName);
    SwapVectors;

  END;


PROCEDURE ShowTransferProtocol;

  VAR
    I :  BYTE;

  BEGIN
     Show_Error ('Choose Transfer Protocol:');
     LineOut ('');
     IF MaxProts > 0 THEN
      BEGIN
       For I := 1 to MaxProts Do
        BEGIN
         WITH Prots[I] DO
           LineOut ('['+Command+'] '+Name);
         END;
        END
         ELSE
          BEGIN
           LineOut (C('R2'));
           LineOut ('ERROR: No Configured Transfer Protocols');
           LineOut (C('W2'));
          END;
         LineOut ('');
       END;

PROCEDURE Recieve (FileName : TitleType);

VAR      Choice   : STRING[5];
         Prompt   : STRING;
         OldX     : BYTE;
         OldY     : BYTE;
         FileSize : LONGINT;
         Discript : STRING [30];
         I        : BYTE;
         Num       : BYTE;

BEGIN
  ShowTransferProtocol;
  Choice := GetInput ('Enter Selection: ',Lcase,Echo,5);
  Choice := Allcaps(Choice);
  Num :=0;
  FOR I := 1 to MaxProts Do
   BEGIN
     IF Allcaps(Prots[I].Command) = Choice THEN Num := I;
   END;
  IF Num = 0 THEN
   BEGIN
    LineOut ('');
    LineOut (C('M2')+'Invalid Protocol.');
    LineOut ('');
    Exit;
   END;
  OldX := WhereX;
  OldY := WhereY;
  Flow_Control := FALSE;
  RecieveFile(FileName,Num);
  InitWindow;
  UpdateWindow (init);
  GotoXY (OldX,OldY);
  Flow_Control := TRUE;
  Show_Error ('Looking for file...');
  i := CurrentArea;
  IF Exists (FileName) Then
   FileSize := Get_File_Size (FileName)
   ELSE
   BEGIN
    Show_Error('I cannot Find your Upload.  Please tell sysop.');
    Exit;
   END;
   LineOut ('');
   StringOut ('Enter Description: ');
   Discript := GetInput ('',lcase,echo,40);
   LineOut ('');
   IF User.D_Level = 255 THEN
    Write_To_FileList(FilePath[i]+AreaFile[i],FileName,FileSize,Discript)
   ELSE
    Write_To_FileList(FilePath[Config.Upnum]+AreaFile[Config.Upnum],
                       FileName,FileSize,Discript);
  END;


PROCEDURE Upload;

  VAR              ScratchFile : FILE;
                   Filename    : STRING [30];
                   Aborted     : BOOLEAN;

  BEGIN
     LineOut (' ');
     StringOut ('Enter the name of the file that you wish upload: ');
     FileName := getinput ('',lcase,echo,30);
     FileName := allcaps (FileName);
     If Config.UpNum <= NumberOfAreas THEN CurrentArea := Config.UpNum;
     LineOut (' ');
     If  (Alpha (FileName)) and
        (NOT Exists (FilePath[CurrentArea]+FileName)) Then
           If User.D_Level = 255 THEN
              Recieve (FilePath[CurrentArea]+FileName)
            ELSE Recieve (FilePath [Config.UpNum]+FileName)
          ELSE
          BEGIN
           Show_Error ('File Exists Or Invalid File Name.');
          END;
        END;

PROCEDURE Send (FileName : TitleType);

VAR      Choice : STRING[5];
         Prompt : STRING;
         OldX   : BYTE;
         OldY   : BYTE;
         Num    : BYTE;
         I      : BYTE;

  BEGIN
   ShowTransferProtocol;
   Choice := GetInput ('Enter Selection: ',Lcase,Echo,5);
   Choice := Allcaps(Choice);
   Num :=0;
   FOR I := 1 to MaxProts Do
    BEGIN
     IF Allcaps(Prots[I].Command) = Choice THEN Num := I;
    END;
   IF Num = 0 THEN
    BEGIN
     LineOut ('');
     LineOut (C('M2')+'Invalid Protocol.');
     LineOut ('');
     Exit;
    END;
     OldX := WhereX;
     OldY := WhereY;
     Flow_Control := FALSE;
     SendFile(FileName,Num);
     InitWindow;
     UpdateWindow (init);
     GotoXY (OldX,OldY);
     Flow_Control := TRUE;
  END;



PROCEDURE Download;

  VAR              ScratchFile : FILE;
                   Filename    : STRING [30];
                   Aborted     : BOOLEAN;

  BEGIN
     LineOut (' ');
     FileName := getinput ('File to download: ',lcase,echo,30);
     FileName := allcaps (FileName);
     LineOut (' ');
     Show_Error ('Looking for file...');
     If  (Alpha (FileName)) and (Exists(FilePath[CurrentArea]+FileName))
          Then Send (FilePath[CurrentArea]+FileName)
          ELSE
          BEGIN
           LineOut (' ');
           Show_Error ('Sorry, file not found.');
          END;
        END;




PROCEDURE SysopAddFile;

  VAR
   FileName : STRING [30];
   FileSize : LONGINT;
   Discript : STRING [40];
   I        : BYTE;

  BEGIN
    LineOut ('');
    FileName := getinput ('Enter new Filename: ',lcase,echo,30);
    FileName := allcaps (FileName);
    Show_Error ('Checking file size...');
    i := CurrentArea;
    IF Exists (FilePath[i]+FileName) Then
       FileSize := Get_File_Size (FilePath[i]+FileName)
     ELSE
       BEGIN
         Show_Error('File Not Found...');
         Exit;
       END;
    LineOut ('');
    Discript := GetInput ('Description: ',lcase,echo,40);
    LineOut ('');
    If Yes ('Ok To Add?') Then
      Write_To_FileList(FilePath[i]+AreaFile[i],FileName,FileSize,Discript);
  END;


BEGIN
  IF Read_Config = 0 Then
    BEGIN
      ReadProts;
      LineOut (' ');
      LineOut (' ');
      Show_Error (C('C2')+'TOPquark Files Section 1.0');
      Quit := FALSE;
      CurrentArea := 1;
      REPEAT
        BEGIN
          Str (CurrentArea:2,TempStr);
          FilePrompt := ('Area['+Clipl(TempStr)+']:Files Command (?/list): ');
          StringOut (C('M2'));
          MainSelection := GetInput (FilePrompt,lcase,echo,40);
          MainSelection := allcaps (MainSelection);
          MenuNumber := 0;
          IF MainSelection <> '' THEN
           BEGIN
            parse (MainSelection,p_cmd,p_min,p_max,p_abort);
            i := 77;
            WHILE (i <= 90) AND (MenuNumber = 0) DO
              BEGIN
               IF MenuChoices [i] = p_cmd THEN MenuNumber := i;
               i := Succ (i);
              END;
            END;
	     CASE MenuNumber OF
              77 : FileOut (FilePath[CurrentArea] + AreaFile [CurrentArea],
                             FALSE);
              78 : Change_Areas;
              79 : Quit := TRUE;
              80 : Download;
              81 : Upload;
              82 : ChatCall;
              83 : BEGIN
                    FileOut ('FileMnu.Txt',FALSE);
                    If Level = Config.Sysoplevel THEN
                      BEGIN
                        Show_Error (MenuChoices[84]+ ' - Sysop Menu');
                        LineOut ('');
                      END;
                    END;
              84 :  BEGIN
                     If Level = Config.SysopLevel THEN
                      BEGIN
                       Show_Error ('Extended Access Commands');
                       LineOut (C('M2'));
                       LineOut (MenuChoices[85]+ ' - Add File to file list');
                       LineOut (MenuChoices[86]+ ' - Remove File from file list');
                       LineOut (C('W2'));
                      END;
                    END;
              85 : If Level = Config.SysopLevel THEN SysopAddFile;
             END;                  {end of case}
           END;
       UNTIL (NOT there) OR (QUIT);
    END;
   END;

END.