
 UNIT Message;

 INTERFACE
   Uses Dos,Crt,QBBS,Chario,Strstuff,SpaceStf,InitBBS;
   PROCEDURE FileOut (FileName : STRING; LogFile : BOOLEAN);
   PROCEDURE Version;
   PROCEDURE ChatCall;
   PROCEDURE Feedback;
   PROCEDURE ChangeConfig;
   PROCEDURE Bulletins;
   PROCEDURE Doors;
   PROCEDURE UserStatus;
   PROCEDURE BoardHeader;
   PROCEDURE BoardStatus (number : INTEGER);
   PROCEDURE MasterStats;
   PROCEDURE ShowDiskSpaceStuff;
   PROCEDURE CloseBoard (number : INTEGER);
   PROCEDURE AreaChange (Cboard : BOOLEAN);
   PROCEDURE SaveMessageData (board_to_save : INTEGER);
   PROCEDURE ReadHeader (number : INTEGER);
   PROCEDURE DisplayHeader (number : INTEGER);
   PROCEDURE SuckinText (number : INTEGER);
   PROCEDURE DisplayMessage (number : INTEGER);
   PROCEDURE SaveMessage(board_to_save : INTEGER);
   PROCEDURE edit (start_line : INTEGER; board_to_save : INTEGER);
   PROCEDURE EditOptions (board_to_save : INTEGER);
   PROCEDURE post (board_number : integer; personto, alaisto: NameType; reference:LONGINT;
                   oldtitle : nametype; Force: BOOLEAN);
   PROCEDURE SendMail;
   PROCEDURE FindMail (VAR Index : INTEGER; VAR Ok : BOOLEAN);
   PROCEDURE ReadMail;
   PROCEDURE CheckMail;
   PROCEDURE Email;




 IMPLEMENTATION

   Uses Windows;



PROCEDURE FindMail (var index : integer; var ok : boolean);
 begin
   ok := false;
   while (index <= boardpack [0].total_msgs) and (there) and (not ok) do
     begin
       if hash (user.name) = mail_to_hash [index] then
         begin
           seek(headerfile,boardpack [0].messageindex [index]);
           read(headerfile,messageheader);
           if user.name = messageheader.personto then ok := true else index := index + 1;
         end
       else index := index + 1;
     end;
 end; { end of procedure }


procedure ReadMail;
 var
  option     : string[30];
  old_msg_area_number : integer;
  ok         : boolean;
  index      : INTEGER;
  oldmsgptr  : INTEGER;

 procedure kill_mail;
  var
    x : integer;
  begin
   messageheader.deleted := true;
   seek(headerfile, filepos(headerfile) - 1);
   write(headerfile,messageheader);
  end; { end of kill message procedure }


 procedure forwardmail;
  var
   tempinput : string[25];
   oldindex  : integer;
   ok        : boolean;
   dummy     : integer;
  begin
   ok := false;
   repeat
     tempinput := getinput('Forward to: ',ucase,echo,25);
     if (tempinput <> '') then
       begin
        if tempinput = user.name then lineout('DONT BE OBNOXIOUS!')
        else
         begin
           if FindHash(tempinput,dummy) then ok := true
           else
             begin
              lineout('User not found!!');
               lineout('RE-type name or CR to abort');
             end;
         end;
       end;
   until (Tempinput = '') or (not there) or (ok);
   if (ok) and (there) then
      begin
       mail_to_hash [index] := hash (tempinput);
       seek(headerfile, filepos (headerfile) - 1);
       messageheader.personto := tempinput;
       write(headerfile, messageheader);
      end;
  end;

 procedure pack_mail_to_hash;
  var
   x : integer;
  begin
   WITH Boardpack [0] Do
     BEGIN
      if total_msgs = 1 then total_msgs := 0
   else
     begin
       for x := index to (total_msgs) do
        begin
          mail_to_hash [x] := mail_to_hash [x + 1];
	  messageindex [x] := messageindex [x + 1];
        end;
       total_msgs := pred (total_msgs);
       total_deleted := succ (total_deleted);
       blocks_deleted := blocks_deleted + messageheader.totalblocks;
     end;
   END;
  end;


 begin;
   WITH BoardPack [0] Do
    BEGIN
     if total_msgs > 0 then
      begin
        old_msg_area_number := MsgAreaNumber;
        if old_msg_area_number <> 0 then
          begin
            CloseBoard (MsgAreaNumber);
            OpenBoard (0);
            MsgAreaNumber := 0;
          end;
        Index := 1;
        repeat
	  if total_msgs > 0 then findmail (index, ok) else ok := false;
          If ok then
               begin
                   ClearBreak;
                   EnableBreak;
                   ReadHeader (index);
                   DisplayHeader (index);
                   DisplayMessage (index);
                   DisableBreak;
                   repeat
                     StringOut (C('C'));
                     option := getinput ('R, K, /, F, Q, N, ?: ',ucase,echo,30);
                     if option = '' then option := 'N';
                     case option [1] of
                       '/' : begin;
                              ClearBreak;
                              EnableBreak;
                              DisplayHeader (index);
                              DisplayMessage (index);
                              DisableBreak;
                             end;
                       'R' : begin
                               OldMsgPtr := BoardPack[0].msg_pointer;
                               BoardPack[0].msg_pointer := index;
                               post (0, messageheader.from,'',0, messageheader.title,FALSE);
                               LineOut (C('R'));
                               BoardPack[0].msg_pointer := OldMsgPtr;
                               If Yes('Delete Mail Now (y,n)? ') THEN
                                BEGIN
                                 ReadHeader (Index);
                                 kill_mail;
                                 pack_mail_to_hash;
                                END;
                               StringOut (C('W2'));
                             end;
                       'K' : begin
                               kill_mail;
                               pack_mail_to_hash;
                             end;
                       'F' : forwardmail;
                       '?' : begin
                                lineout (C('Y2'));
                                lineout ('(R)eply (K)ill (/) Re-read');
                                lineout ('(F)orward (Q)uit (N)ext');
                                lineout ('');
                             end;
                       'N' : index := succ (index);
                       end;
                   until (option [1] in ['Q','R','N','K','F']) or (not there);
                   StringOut (C('W2'));
               end;
        until (not OK) or (option [1] = 'Q') or (not there) or (index > boardpack [0].total_msgs);
        if old_msg_area_number <> 0 then
          begin
            CloseBoard (MsgAreaNumber);
            MsgAreaNumber := old_msg_area_number;
            OpenBoard (MsgAreaNumber);
          end;
      end
    else lineout (C('B2')+'No mail for you...');
   END; {Of WITH}
end; { end of procedure }


procedure CheckMail;
 var
  question : string [5];
  index    : integer;
  ok       : boolean;
 begin
   if boardpack [0].total_msgs > 0 then
    begin
      MsgAreaNumber := 0;
      OpenBoard (MsgAreaNumber);
      Index := 1;
      findmail (index, ok);
      if Ok then
        begin
          lineout('');
          StringOut (C('G2'));
          lineout('You have mail!');
          StringOut (C('B2'));
          if yes ('Read now (y/n)? ') then ReadMail;
          StringOut (C('W2'));
        end
      else
        begin
          lineout('');
          StringOut (C('B2'));
          lineout('Sorry, no mail for you today...');
          StringOut (C('W2'));
          lineout('');
        end;
      CloseBoard (MsgAreaNumber);
    end;
 end; {end of procedure}



procedure Email;
 VAR
  option  : STRING[3];

 BEGIN
  REPEAT
   BEGIN
    StringOut (C('M2'));
    option := getinput ('[R]ead [S]end [Q]uit: ',ucase,echo,3);
    if option <> '' then
     case option [1] of
        'R' : ReadMail;
        'S' : SendMail;
      end;
    END;
  until (option = 'Q') or (not there);
 end;

 PROCEDURE FileOut (filename : STRING; logfile : BOOLEAN);



    VAR
       TextFile                    : TEXT;
       Text_Line                   : AnyString;
       Temp_Line                   : AnyString;
       Goahead                     : BOOLEAN;
       Temp                        : Anystring;

    PROCEDURE CheckDate (TestStr : AnyString);

       VAR

          Date_Array       :ARRAY[1..3] OF STRING[5];
                                   {Month,Day,Year}
          Year,Day,Month   :INTEGER;
          Code             :INTEGER;
          I                :INTEGER;
          J                :INTEGER;
          Error            :BOOLEAN;

       BEGIN
          IF TestStr <>'' THEN BEGIN
             Error := FALSE;
             GoAhead := TRUE;
             FOR I := 1 TO 3 DO Date_Array[I] :='';
             J := 0;
             FOR I := 1 TO Length (TestStr) DO BEGIN
                IF (TestStr[I] IN ['%',' ','-','.','/']) AND (J < 3) THEN J:=Succ(J)
                ELSE IF (TestStr[I] IN ['0'..'9']) AND (J <> 0) THEN BEGIN
                   Date_Array[J] :=Date_Array[J] + TestStr[I];
                END
                ELSE Error := TRUE;
             END;
             IF (NOT Error) THEN BEGIN

                Val (Date_Array[1],month,Code);
                Val (Date_Array[2],Day,Code);
                Val (Date_Array[3],Year,Code);

                IF (year < user.year) OR (Month < User.Month) OR (Day  < User.day) THEN GoAhead :=FALSE;
             END;
          END;
       END;



    BEGIN                          {FileOut}
       Assign (textfile,filename);
  {$I-}
       Reset (textfile);
  {$I+}
       IF IOResult = 0 THEN BEGIN
          Goahead := TRUE;
          ClearBreak;
          EnableBreak;
          REPEAT
             BEGIN
                Readln (textfile, text_line);
                Temp_Line := AllCaps (Clip(Text_Line));


                IF Temp_line ='%BREAK ON'  THEN BEGIN
                   ClearBreak;
                   EnableBreak;
                END
                ELSE IF Temp_line ='%BREAK OFF' THEN BEGIN
                   ClearBreak;
                   DisableBreak;
                END
                ELSE IF Temp_line ='%KEYS'      THEN BEGIN
                   Show_Error ('-^C to Abort / ^S to Pause / ^Q to Resume-');
                   LineOut ('');
                END
                ELSE IF Temp_line ='%PAUSE'     THEN BEGIN
                   StringOut ('Press Enter:');
                   REPEAT
                      Temp := ReadC
                   UNTIL (Temp =^M) OR (BREAK) OR (NOT There);
                   LineOut ('');
                END
                ELSE IF Temp_line[1] ='%' THEN BEGIN
                   CheckDate(Temp_Line);
                END
                ELSE LineOut(text_line);
             END;
          UNTIL Eof (textfile) OR (BREAK) OR (NOT Goahead) or (NOT There);
          DisableBreak;
          Close (textfile);
       END
       ELSE BEGIN
          IF NOT Logfile THEN Show_Error (filename  + ' has run away...please tell sysop!')
          ELSE Show_Error ('No Log Today.');
       END;
       LineOut ('');
    END;


 PROCEDURE Version;

    BEGIN
       EnableBreak;
       lineout (C('C2'));
       lineout (softwarename + '(C) Copyright by Fly-By-Night Software.');
       lineout (' ');
       LineOut ('Programmers: ');
       LineOut (' ');
       LineOut (' Mark Firestone   Laurence Starks ');
       LineOut ('');
       LineOut ('Thanks to: ');
       LineOut (' ');
       LineOut (' John Lorance  Sue Widemark  Wayne Conrad');
       Lineout (' ');
       LineOut ('For all their kind assistance (and code)...');
       lineout ('');
       lineout ('This software is based on a program by John Lorance called QBBS.');
       LineOut ('It has been translated to Turbo Pascal 5.5 and rewritten.');
       LineOut ('');
       LineOut (CompileDate);
       lineout ('');
       DisableBreak;
    END;


 PROCEDURE ChatCall;

    VAR
       i : INTEGER;

    BEGIN
       LineOut (C('C2'));
       i := 1;
       Yelling := TRUE;
       UpdateWindow (Yell);
       ChatTimes := Succ (ChatTimes);
       IF ChatTimes <= Config.ChatLimit THEN
         BEGIN
          StringOut (Config.chatCall1);
          IF NOT silence THEN
            BEGIN
              WHILE (i <= 1500) AND (there) DO
               BEGIN
                I := I + 100;
                Sound (I);
                Delay (50);
               END;
              NoSound;
            END;
          IF NOT silence THEN
            BEGIN
              WHILE (i >= 0) AND (there) DO
               BEGIN
                I := I - 100;
                Sound (I);
                Delay (50);
               END;
             NoSound;
            END;
          LineOut (C('M2'));
          LineOut (Config.AfterChat);
          LineOut ('');
         END
         ELSE
         BEGIN
          LineOut (C('R2'));
          LineOut (Config.TooManyChat);
          LineOut (' ');
         END;
    END;

 PROCEDURE feedback;

    VAR
       DONE : BOOLEAN;
       Tempnum : INTEGER;

    BEGIN
       DONE := FALSE;
       REPEAT
          BEGIN
             LineOut (C('M2'));
             LineOut ('Send feedback to:');
             StringOut  (C('G2')+'    1 : ');
             LineOut (Config.SysopName);
             IF Config.SysopName2 <> '' THEN
              BEGIN
               StringOut  (C('M2')+'    2 : ');
               LineOut (Config.SysopName2);
              END;
             IF Config.SysopName3 <> '' THEN
              BEGIN
               StringOut  (C('Y2')+'    3 : ');
               Lineout (Config.SysopName3);
              END;
             Tempnum := GetNumber ('Which would you like? ',1,3,TempNum,FALSE);
             CASE TempNum OF
                1 : BEGIN
                   LineOut ('To: ' + Config.SysopName);
                   Post (0,Config.Sysopname,'',0,'',FALSE);
                   Done := TRUE;
                END;
                2 : BEGIN
                   IF Config.SysopName2 <> '' THEN BEGIN
                      LineOut('To: ' + Config.SysopName2);
                      Post(0,Config.SysopName2,'',0,'',FALSE);
                      Done:= TRUE;
                   END
                   ELSE Show_Error ('No such Sysop.');
                END;
                3 : BEGIN
                   IF Config.SysopName3 <> '' THEN BEGIN
                      LineOut ('To: ' + Config.SysopName3);
                      Post (0,Config.SysopName3,'',0,'',FALSE);
                      Done := TRUE;
                   END
                   ELSE Done :=TRUE;
                END;
             END;                  {Of Case}
          END;                     {Of Repeat}
       UNTIL (DONE) or (NOT THERE) or (TempNum = 0);
    END;




 PROCEDURE ChangeConfig;

    VAR
       question : STRING[80];
       EXIT     : BOOLEAN;

    PROCEDURE change_width;

       BEGIN
          lineout (C('G2'));
          Stringout ('Old width = ');
          LineOut (C('R2')+ stri (user.width));
          StringOut (C('C2'));
          user.width := getnumber('Terminal width (20-80)? ',20,80,user.width,FALSE);
          term_width := user.width;
          lineout (C('W2'));
       END;

    PROCEDURE Toggle_Graphics;

       BEGIN
          User.Graphics := NOT User.Graphics;
          StringOut (C('G2')+'Graphics Now ');
          IF User.Graphics THEN LineOut (C('M2')+'On')
          ELSE LineOut ('Off');
       END;

    PROCEDURE change_password;

       VAR
          tempSTR : STRING[8];

       BEGIN
          lineout (C('C2'));
          StringOut ('Old password = ' );
          LineOut (C('M2') + user.password);
          StringOut (C('M2'));
          tempSTR := getinput ('New password (8 chars max)? ',ucase,echo,8);
          IF tempstr <> '' THEN user.password := tempstr
          ELSE show_error (C('R')+'Not changed');
          lineout (C('W2'));
       END;

  PROCEDURE Editor_Exit;

     VAR
       TempStr : STRING;

     BEGIN
      lineout (C('C2'));
      IF User.Editor_Exit ='' Then TempStr := '[Blank Line]' ELSE
        TempStr := User.Editor_Exit;
      Stringout ('Old Editor Exit = ');
      LineOut (C('C2') + TempStr);
      StringOut (C('M2'));
      tempSTR := getinput ('New editor exit string (Return = Blank Line): ',ucase,echo,5);
      User.Editor_Exit := tempstr;
     END;


    PROCEDURE ChangeAlais;

       VAR
         TempStr : STRING[40];

       BEGIN
        REPEAT
        BEGIN
         LineOut ('');
         StringOut ('Your Current Alais is: ');
         StringOut (User.Alais);
         LineOut ('');
         If (Yes( 'Would you like your alais on?') )THEN
          BEGIN
           User.AlaisOn :=TRUE;
           IF (User.Alais = 'NONE') or (Yes('Change Alais? ')) THEN
           User.Alais :=getinput ('Enter your Alais: ',Ucase,TRUE,40)
          END
          ELSE
           User.AlaisOn :=FALSE;
          END;
       UNTIL (User.Alais <> '') or ( User.AlaisOn = FALSE) or (Not There);
         IF User.Alais <> 'NONE' THEN
          BEGIN
           LineOut ('');
           LineOut ('You may turn off your alais that the configure menu if you wish.');
           LineOut ('');
          END;
       END;

    PROCEDURE Change_Zip_Read;

       VAR
          I      : INTEGER;
          Code   : INTEGER;
          Temp   : STRING [10];
          Exit   : BOOLEAN;
          Change : STRING[80];

       PROCEDURE Print_Header;

          VAR
             I : BYTE;
             K : BYTE;

          BEGIN
             LineOut ('');
             LineOut    ('Msg Area:123456789012345');
             StringOut  ('Zip Read:');
             FOR I := 1 TO 15 DO
                IF (I > Maxboards) OR (User.Board_Access[I] IN ['N','I']) THEN StringOut ('-')
                ELSE IF (User.Zip_Read[I]) THEN StringOut ('Y')
                ELSE IF (NOT User.Zip_Read[I]) THEN StringOut ('n');
             LineOut ('');
          END;


       BEGIN
          REPEAT
             BEGIN
                Print_Header;
                Exit := FALSE;
                LineOut ('');
                Temp := GetInput('Enter Board to Change <Q/EXIT>: ',ucase,echo,5);
                LineOut ('');
                Val (Temp,I,Code);
                IF Code = 0 THEN
                   IF (I > 0) AND (I <= Maxboards) AND (NOT(User.Board_Access[I] IN ['I','N'])) THEN User.Zip_Read[I] :=
                        NOT User.Zip_Read[I];
                LineOut ('');
                IF Temp[1] = 'Q' THEN Exit := TRUE;
             END;
          UNTIL (Exit) OR (NOT THERE);
       END;


    PROCEDURE config_menu;

       BEGIN
          ClearBreak;
          lineout ('');
          EnableBreak;
          StringOut (C('M2'));
          LineOut (' (A)lais Change - On/Off');
          LineOut (' (E)ditor Exit Change ');
          LineOut (' (G)raphics (ANSI) Toggle');
          lineout (' (P)assword');
          lineout (' (W)idth');
          lineout (' (Z)ip Read');
          LineOut (' (Q)uit');
          lineout (' (?)This Menu');
          DisableBreak;
          lineout ('');
       END;

    BEGIN
       config_menu;
       REPEAT
          BEGIN
             EXIT := FALSE;
             Question :='';
             StringOut (C('C2'));
             question := getinput ('Change which <Q/EXIT>? ',ucase,echo,80);
             CASE question [1] OF
                'P' : change_password;
                'E' : Editor_Exit;
                'A' : ChangeAlais;
                'W' : change_width;
                'Z' : change_zip_read;
                'G' : Toggle_Graphics;
                '?' : config_menu;
                'Q' : Exit := TRUE;
             END;
          END;
       UNTIL (NOT there) OR (Exit);
       lineout ('');
    END;



 PROCEDURE bulletins;

    VAR
       option : STRING[5];
       number : INTEGER;
       code   : INTEGER;

    PROCEDURE show_bullets;

       VAR
          i : INTEGER;

       BEGIN
  {lineout ('');
  enable_break;
  lineout ('Available Bulletins:');
  i := 1;
  while (i <= config.maxbullets) and (not break) and (there) do
   begin
    lineout ('    ' + stri (i) + '....' + Config.bulletpack [i].name);
    i := succ (i);
   end;
  disable_break;
  lineout ('');}
       END;

    BEGIN
 { lineout ('');
  if Config.maxbullets = 0 then lineout ('No Bulletins')
  else
   begin
     repeat
       option := '';
       option := getinput ('Bulletins [1-' + stri (Config.maxbullets) + '], ? for list, <CR to EXIT>: ',ucase,echo,5);
       if option = 'CR' then
        begin
         lineout('');
         lineout ('When it says to enter "CR" it does not mean you enter the letters');
         lineout ('"C" and "R", it means you enter a RETURN.');
         lineout ('');
        end
       else
       if option = '?' then show_bullets
       else if (option <> '') and (option <> '+') and (option <> '-') then
        begin
         val (option,number,code);
         if (code = 0) and (number >= 1) and (number <= Config.maxbullets) then
           file_out (Config.bulletpack [number].filename,false) else show_error ('Invalid #');
        end;
     until (not there) or (option = '');
   end;
  lineout ('');}
       Show_Error ('Under Repair!');
    END;


 PROCEDURE doors;

    TYPE

 DoorRecord = RECORD
          name     : STRING [50];
          level    : BYTE;
          dos_code : BYTE;
          FileName : STRING;
          Ratio    : REAL;
       END;

    VAR
       option    : STRING[5];
       number    : INTEGER;
       code      : INTEGER;
       Maxdoors  : BYTE;
       doorpack  : ARRAY[1..15] OF DoorRecord;



 PROCEDURE getdoors;


 var
  b_file : text;
  i      : integer;
  path   : string [30];

 procedure clear_doors;
  var
   x : integer;
  begin
   for x := 1 to 15 do
    with doorpack [x] do
     begin
      name := '';
      level := 0;
      dos_code := 0;
      FileName :='';
      Ratio    :=0;
     end;
  end;

 begin
   maxdoors := 1;
   clear_doors;
   assign (b_file,Config.Miscpath + 'DOORS.TXT');
   {$I-}
   reset (b_file);
   {$I+}
   if IOresult <> 0 then
    begin
     maxdoors := 0;
    end
   else
    begin
     repeat
       with doorpack [maxdoors] do
        begin
         readln (b_file,name);
         readln (b_file,level);
         readln (b_file,dos_code);
         Readln (b_File,FileName);
         Readln (b_file,Ratio);
        end;
       if not eof (b_file) then maxdoors := succ (maxdoors);
     until eof (b_file);
     close (b_file);
    end;
 end;

    PROCEDURE WriteDoorFile;

      VAR
       TempStr : STRING;
       TempStr1: STRING;
       TempInt : INTEGER;
       D_File  : TEXT;
       J       : INTEGER;
       Done    : BOOLEAN;

      BEGIN
       Assign (D_File,DoorPack[number].FileName);
       ReWrite (D_file);
       Writeln (D_File,Config.SystemName);
       Done := FALSE;
       TempStr :='';
       TempStr1:='';
       For J := 1 to Length (Config.SysopName) Do
        BEGIN
          IF Config.SysopName[J]=' ' THEN Done := TRUE;
          IF NOT DONE then TempStr:=TempStr+Config.SysopName[J]
          ELSE
           IF Config.SysopName[J] <> ' ' THEN
             TempStr1:=TempStr1+Config.SysopName[J];
        END;
        Writeln (D_File,TempStr);
        Writeln (D_File,TempStr1);
        Str (Config.Port_Num,TempStr);
        IF Connect_Mode = REMOTE THEN Writeln (D_File,'COM'+TempStr)
         ELSE
           Writeln (D_File,'COM0');
          CASE Current_Speed OF
            Slow      : TempStr :='300';
            Fast      : TempStr :='1200';
            Very_Fast : TempStr :='2400';
          END;
         IF Connect_Mode = REMOTE THEN Writeln (D_File,TempStr+' BAUD,N,8,1')
          ELSE
           Writeln (D_File,'2400 BAUD,N,8,1');
         Writeln (D_File,'0');     {<---Find out what this does...}
         Done := FALSE;
         TempStr :='';
         TempStr1:='';
         For J := 1 to Length (User.Name) Do
          BEGIN
           IF User.Name[J]=' ' THEN Done := TRUE;
          IF NOT DONE then TempStr:=TempStr+User.Name[J]
          ELSE
           If User.Name[J] <> ' ' THEN TempStr1:=TempStr1+User.Name[J];
        END;
        Writeln (D_File,TempStr);
        Writeln (D_File,TempStr1);
        Writeln (D_File,User.CityState);
        IF User.Graphics Then Writeln (D_File,'1')
         ELSE Writeln (D_File,'0');
        Writeln (D_File,'0');   {<---Find out what this does!!!}
        Str ((Time_Limit-Time_Logged) Div 60,TempStr);
        Writeln(D_File,Tempstr);
        Close (D_file);
      END;

    PROCEDURE show_doors;

       VAR
          i : INTEGER;

       BEGIN
          lineout ('');
          EnableBreak;
          lineout (C('G2')+'Doors Available:');
          i := 1;
          WHILE (i <= maxdoors) AND (NOT BREAK) AND (there) DO
            BEGIN
             Stringout (C('B2')+'    ' + stri (i) + '...');
             StringOut (C('G2') + doorpack [i].name);
             LineOut ('');
             i := Succ (i);
            END;
          DisableBreak;
          lineout ('');
       END;

    BEGIN
       GetDoors;
       lineout ('');
       IF maxdoors = 0 THEN lineout ('NO Doors')
       ELSE IF NOT door_ok THEN lineout ('NON-BATCH run')
       ELSE BEGIN
          REPEAT
             option := '';
             StringOut (C('C2'));
             option := getinput ('Doors [1-' + stri (maxdoors) + '] <RETURN> to quit, ? to list: ',ucase,echo,5);
             IF option = 'CR' THEN BEGIN
                lineout(C('R'));
                lineout ('When it says to enter "CR" it does not mean you enter the letters');
                lineout ('"C" and "R", it means you enter a RETURN.');
                lineout ('');
             END
             ELSE IF option = '?' THEN show_doors
             ELSE IF (option <> '') AND (option <> '+') AND (option <> '-') THEN BEGIN
                Val (option,number,code);
                IF (code = 0) AND (number >= 1) AND (number <= maxdoors)
                  AND (level >= doorpack [number].level) THEN
                   BEGIN
                    IF User.Ratio >= Doorpack[Number].Ratio THEN
                     BEGIN
                      door_num := doorpack [number].dos_code;
                      WriteDoorFile;
                     END
                     ELSE
                     BEGIN
                      LineOut ('');
                      LineOut (C('R')+'Sorry, but you must have a higher post/call ratio to use this door.');
                      LineOut ('Try Posting more messages. ');
                      LineOut('');
                     END;
                   END
                ELSE  IF (level <> doorpack [number].level) THEN
                 show_error (C('R')+'Sorry, You do not have access.')
                ELSE show_error (C('R')+'Invalid Command.');
             END;
          UNTIL (NOT there) OR (door_num <> 0) OR (option = '');
       END;
       lineout ('');
    END;

 PROCEDURE BoardHeader;

    BEGIN
       StringOut (C('W2')+'# ');
       StringOut (C('G2')+'Live ');
       StringOut (C('C2')+'Dead ');
       StringOut (C('R2')+'Deadspace');
       LineOut ('');
       LineOut (C('Y2')+'- ---- ---- ---------');
       StringOut(C('W2'));
    END;

 PROCEDURE BoardStatus (number : INTEGER);


    VAR
       really : REAL;
       really2: REAL;

    BEGIN
       really := boardpack [number].blocks_deleted;
       really2 := boardpack[number].total_deleted;
       lineout (strif (number,2) + ' ' + strif (boardpack [number].total_msgs,3) + '  ' + strif (boardpack [number].
            total_deleted,3) + '  ' + strr ((really * 128) + (really2 * 103)));
    END;

 PROCEDURE UserStatus;

    BEGIN
       lineout (' U ' + strif (maxusers,3) + '  ' + strif (usersdeleted,3) + '  ' + stri (usersdeleted * 92));
    END;

 PROCEDURE ShowDiskSpaceStuff;

    VAR
       drive : INTEGER;

    BEGIN
       drive := Ord (boardpack [MsgAreaNumber].path [1]) - 64;
       lineout ('There is ' + strr (drive_space [drive]) + ' bytes left out of '+ strr (drive_total_avail [drive]) +
            ' bytes');
    END;

 PROCEDURE MasterStats;

    VAR
       i : INTEGER;
       drive : INTEGER;

    BEGIN
       lineout ('');
       BoardHeader;
       i := 0;
       EnableBreak;
       WHILE (i <= maxboards) AND (NOT BREAK) AND (there) DO BEGIN
          BoardStatus (i);
          i := Succ (i);
       END;
       UserStatus;
       lineout ('');
       FOR i := 1 TO 10 DO
          IF drive_total_avail [i] > 0 THEN lineout ('There is ' + strr (drive_space [i]) + ' bytes left out of '+ strr
               (drive_total_avail [i]) + ' bytes on drive ' + Chr (i + 64));

       DisableBreak;
       lineout ('');
    END;


 PROCEDURE CloseBoard (number : INTEGER);

    BEGIN
    {$I-}
       Close (headerfile);
       IF boardpack [number].total_msgs > 0 THEN Close (libfile);
    {$I+}
    END;


 PROCEDURE AreaChange (CBoard: BOOLEAN);

    VAR
       tempinput : STRING[5];
       tempint   : INTEGER;
       code      : INTEGER;
       lowestnum : INTEGER;
       lowestSTR : STRING[3];
       done      : BOOLEAN;
       change    : BOOLEAN;

    PROCEDURE list_boards;

       VAR
          i : INTEGER;
          display : BOOLEAN;
          tempSTR : STRING[5];
          tempSTR2: STRING[5];

       BEGIN
          i := 0;
          ClearBreak;
          EnableBreak;
          lineout('');
          Stringout (C('W2')+'#    ');
          StringOut (C('G2')+'New  ');
          StringOut (C('R2')+'Access  ');
          StringOut (C('B2')+'Board Description');
          LineOut (C('Y2'));
          lineout ('--   ---  ------  -----------------');
          WHILE (NOT BREAK)        {and not there}
               AND (i <= maxboards) DO BEGIN
             IF ((i = 0) AND ((user.board_access[0] <> 'N') OR (level < Config.Sysoplevel))) OR (user.board_access[i] =
                  'I') THEN display := FALSE
             ELSE display := TRUE;
             IF display THEN BEGIN
                StringOut (C('W2'));
                stringout (strif (i,2) + '   ');
                StringOut (C('G2'));
                stringout (strif (boardpack [i].total_msgs - boardpack [i].msg_pointer, 3));
                stringout ('  ');
                StringOut (C('R2'));
                CASE user.board_access [i] OF
                   'W' : stringout ('Write');
                   'N' : stringout ('None ');
                   'R' : stringout ('Read ');
                   'C' : stringout ('Cosys');
                   'M' : stringout ('Maint');
                END;
                stringout ('   ');
                StringOut (C('B2'));
                lineout (boardpack [i].name);
             END;
             i := Succ (i);
          END;
          DisableBreak;
          lineout('');
          lineout (C('W2'));
       END;


    BEGIN
       done := FALSE;
       change := FALSE;
       IF (NOT (user.board_access[0] IN ['N','I'])) OR (level = Config.SysopLevel) THEN lowestSTR := '0'
       ELSE lowestSTR := '1';
       Val (lowestSTR,lowestnum,code);
       lineout ('');
       REPEAT
          StringOut (C('W2'));
          IF (NOT p_abort) AND (p_min <> -1) THEN Str (p_min,tempinput)
          ELSE tempinput := getinput ('Area #[' + stri (MsgAreaNumber) + '] (' + lowestSTR + '-' + stri (maxboards) +
               ') ? for list, CR to quit: ' ,ucase,echo,5);

          IF tempinput <> '' THEN BEGIN
             p_min := -1;
             IF tempinput = '?' THEN list_boards
             ELSE BEGIN
                Val (tempinput,tempint,code);
                IF code = 0 THEN BEGIN
                   IF (tempint <= maxboards) AND (tempint >= lowestnum) THEN BEGIN
                      IF (NOT (user.board_access [tempint] IN ['N','I'])) OR (level = Config.SysopLevel) THEN BEGIN
                         done := TRUE;
                         IF tempint = MsgAreaNumber THEN change := FALSE
                         ELSE change := TRUE;
                      END
                      ELSE IF user.board_access [tempint] = 'N' THEN show_error ('You do not have access');
                   END;
                END;
             END;
          END
          ELSE BEGIN
             done := TRUE;
             change := FALSE;
          END;
       UNTIL (done) OR (NOT there);
       IF change THEN BEGIN
          lineout (C('G2'));
          stringout ('Changing to the ' + boardpack [tempint].name + ' sub-board...');
          If CBoard then CloseBoard (MsgAreaNumber);
          MsgAreaNumber:= tempint;
          OpenBoard (MsgAreaNumber);
          lineout ('');
          lineout ('');
       END;
    END;

PROCEDURE SaveMessageData (board_to_save : INTEGER);
 var
  old_msg_area_number : INTEGER;
  TotalBytes          : INTEGER;
  drive               : INTEGER;
  TempInt             : INTEGER;
  Code                : INTEGER;
  TempReal            : REAL;
  TempStr             : STRING;
 begin
  old_msg_area_number := MsgAreaNumber;
  if board_to_save <> old_msg_area_number then
   begin
    CloseBoard (MsgAreaNumber);
    OpenBoard (board_to_save);
    MsgAreaNumber := board_to_save;
   end;
  WITH User Do
   BEGIN
    PostTimes   := PostTimes + 1;
    Ratio       := (PostTimes / CallTimes) * 100;
   END;

  WITH BoardPack [MsgAreaNumber] Do
   BEGIN
    If User.AlaisOn THEN MessageHeader.Alais := User.Alais
     ELSE MessageHeader.Alais := MessageHeader.From;
    if total_msgs = 0 then rewrite (libfile,128);
    messageheader.number := new_msg_index [total_msgs] + 1;
  messageheader.startblock := filesize(libfile);
  seek(libfile, filesize (libfile));
  blockwrite(libfile, messagetext{bytestream}, messageheader.totalblocks);
  seek(headerfile,filesize(headerfile));
  write(headerfile,messageheader);       { write the message header }
  total_msgs := succ (total_msgs);
  new_msg_index [total_msgs] := succ (new_msg_index [total_msgs - 1]);
  new_since_pack := succ (new_since_pack);
  messageindex [total_msgs] := filepos (headerfile) - 1;
  if MsgAreaNumber = 0 then mail_to_hash [total_msgs] := hash (messageheader.personto);
  if board_to_save <> old_msg_area_number then
     begin
      CloseBoard (MsgAreaNumber);
      MsgAreaNumber := old_msg_area_number;
      OpenBoard (MsgAreaNumber);
     end;
  drive := ord (boardpack [board_to_save].path [1]) - 64;
  DiskSpace (drive,drive_total_avail [drive],drive_space [drive]);
 END; {OF With}

 end;

 PROCEDURE ReadHeader (number : INTEGER);

    BEGIN
       Seek(headerfile,boardpack [MsgAreaNumber].messageindex [number]);
       Read(headerfile,messageheader);
    END;

 PROCEDURE DisplayHeader (number : INTEGER);

    VAR
      Disp : BOOLEAN;

    BEGIN
      LineOut('');
      StringOut(C('W2')+'#' + stri (number));
      IF MessageHeader.Locked THEN StringOut (C('R')+'  [Locked]');
      StringOut('   '+ C('B2')+messageheader.date + ' / ' + messageheader.time);
      LineOut ('');
      If MessageHeader.AlaisTo = MessageHeader.PersonTo THEN
       BEGIN
        StringOut (C('C2')+'To:    ');
        StringOut (PadR(C('G2')+ MessageHeader.PersonTo,33))
       END
       ELSE
       BEGIN
        StringOut (C('C2')+'To:    ' );
        StringOut (PadR(C('G2')+ MessageHeader.Alaisto,33));
       END;
      StringOut (C('C2')+'Absolute:   ');
      StringOut (C('G2')+ stri(MessageHeader.Number));
      LineOut ('');
      If MessageHeader.Alais = MessageHeader.From THEN
       BEGIN
        StringOut (C('C2')+'From:  ');
        StringOut (PadR(C('G2') + MessageHeader.From,33));
       END
       ELSE
       BEGIN
        StringOut (C('C2')+'From:  ');
        StringOut (Padr(C('G2')+MessageHeader.Alais,33));
       END;
      IF MessageHeader.Reference <> 0 THEN
       BEGIN
        StringOut (C('C2')+'Reference:  ');
        StringOut (C('G2')+stri(MessageHeader.Reference));
       END
      ELSE
       BEGIN
        StringOut (C('C2')+'Reference:  ');
        StringOut (C('G2')+'NONE');
       END;
      LineOut ('');
      StringOut (C('C2')+'Title: ');
      StringOut (Padr(C('G2')+ MessageHeader.Title,33));
       If User.Level = Config.SysopLevel THEN
         If MessageHeader.Alais <> MessageHeader.From THEN
         BEGIN
          StringOut (C('C2')+'Real Name:  ');
          StringOut (C('G2')+MessageHeader.From);
         END;
      LineOut ('');
      LineOut (C('Y2'));


    END;

 PROCEDURE SuckinText (number : INTEGER);

    BEGIN
       Seek(libfile,messageheader.startblock);
       BlockRead(libfile, messagetext, messageheader.totalblocks);
    END;

 PROCEDURE DisplayMessage (number : INTEGER);

    VAR
       charcounter  : INTEGER;
       {messagetext  : array [1..3328] of byte;}
       done         : BOOLEAN;
       i            : INTEGER;


    BEGIN
       FOR i := 1 TO 3328 DO messagetext [i] := 0;
       timecheck := FALSE;
       SuckinText (number);
       lineout('');
       done := FALSE;
       IF NOT ScanMode THEN
        BEGIN
          charcounter := 1;
          WHILE (charcounter <= messageheader.totalblocks * 128) AND (NOT BREAK) AND (there) AND (NOT done) DO BEGIN
             IF messagetext [charcounter] <> 0 THEN writec (Chr (messagetext [charcounter]))
             ELSE done := TRUE;
             charcounter := Succ (charcounter);
          END;
          lineout('');
          lineout('');
       END;
       timecheck := TRUE;
    END;                           { End of display message }



 PROCEDURE SaveMessage(board_to_save : INTEGER);

    VAR
       bytestream  : ARRAY[1..3328] OF BYTE;
       x           : INTEGER;
       numofblocks : INTEGER;
       linecounter : INTEGER;
       bytes       : INTEGER;
       old_msg_area_number : INTEGER;
       drive               : INTEGER;
       TempStr             : STRING;

    BEGIN
       FillChar (messagetext,3328,0);
       numofblocks := 1;
       x           := 0;
       linecounter := 0;
       bytes       := 0;
       lineout ('');
       LineOut (C('G2')+'Saving....');
       REPEAT
          linecounter := Succ (linecounter);
          FOR x := 1 TO Length (MessBuff [linecounter]) DO BEGIN
             bytes := Succ (bytes);
             messagetext [bytes] := Ord (MessBuff [linecounter][x]);
          END;
          bytes := Succ (bytes);
          messagetext [bytes] := 13;
       UNTIL (linecounter = MaxLinesEntered);
       WITH User Do
         BEGIN
           STR (Bytes,TempStr);
           StringOut (C('C2'));
           StringOut (TempStr + ' Bytes Saved  /  ');
           BytesPosted :=BytesPosted + Bytes;
           STR (BytesPosted,TempStr);
           StringOut (C('R2'));
           StringOut (TempStr +' Total Bytes Posted.');
           LineOut (C('W2'));
         END;
       numofblocks := bytes DIV 128;
       IF bytes MOD 128 <> 0 THEN numofblocks := Succ (numofblocks);

       messageheader.totalblocks := numofblocks;
       messageheader.from        := user.name;
       SaveMessageData (board_to_save);
       lineout ('');
       IF ed_ing THEN ed_saved := TRUE;
    END;                           { end of SAVE procedure }





PROCEDURE edit (start_line : INTEGER; board_to_save : INTEGER);

    VAR
       working_line : STRING[80];
       current_linenum : INTEGER;
       done            : BOOLEAN;
       i               : INTEGER;

    BEGIN
       Cnum := 0;
       current_linenum := start_line;
       timecheck := FALSE;
       done := FALSE;
       wrap := TRUE;
       lineout (C('G2'));
       lineout ('Enter message text. ' + stri (MaxLines - start_line + 1) + ' lines maximum.');
       Stringout (C('R2'));
       lineout ('/EX for editor prompt, /S to save, /Q to quote, /A to abort.');
       lineout (C('C2'));
       IF current_linenum <= MaxLines THEN
          REPEAT
             IF Config.Show_Linenum THEN working_line :=
              getinput (strif(current_linenum,2) +': ',lcase,echo,user.width - 5)
             ELSE working_line := getinput ('' ,lcase,echo,user.width - 5);
             IF Working_Line[1] <> ' ' THEN
             working_line := clipr (working_line);

             IF (working_line <> '/ex') AND (working_line <> '/EX')
              AND (working_line <> '/s') AND (working_line <> '/S') AND
               (working_line <> '/A') AND (working_line <> '/a') AND
               (working_line <> '/Q') AND (working_line <> '/q') AND
               (working_Line <> User.Editor_Exit) THEN
               BEGIN
                IF MaxLinesEntered = 40 THEN
                 BEGIN
                   MessBuff [current_linenum] := working_line;
                   done := TRUE;
                END
                ELSE
                BEGIN
                   MaxLinesEntered := Succ (MaxLinesEntered);
                   IF MaxLinesEntered > current_linenum THEN
                      FOR i := MaxLinesEntered DOWNTO current_linenum DO MessBuff [i + 1] := MessBuff [i];
                   MessBuff [current_linenum] := working_line;
                   current_linenum := Succ (current_linenum);
                END;
             END
             ELSE done := TRUE;
             IF MaxLinesEntered = (MaxLines - 2) THEN lineout(' Two lines left!');
          UNTIL (MaxLinesEntered >= MaxLines) OR (done) OR (NOT there);
       wrap := FALSE;
       IF MaxLinesEntered > 40 THEN MaxLinesEntered := 40;
       MaxLines := 40;
       timecheck := TRUE;
       IF (working_line = '/S') OR (working_line = '/s') THEN SaveMsg := TRUE
       ELSE SaveMsg := FALSE;
       IF (working_line = '/A') OR (working_line = '/a') THEN AbortMsg := TRUE
       ELSE AbortMsg := FALSE;
       IF (working_line = '/Q') OR (working_line = '/q') THEN QuoteMsg := TRUE
       ELSE QuoteMsg := FALSE;
       IF (NP :1؄	/	-̮hΌL$
H)D	(	/	-̮hΌL
H)D	/	-̮hΌLG
nld	/	-̮hΌL'aD	nhNi/	-̮hΌLGh*JI(D	jaDȇaD~W P
~W~W PN] U1D P
2 P

]U市 D ~W~W PN+PPPPP
PP
W~W1Pv
P+W~ M
  ] U$ D$~W~W  P
F݀~ uk
F݊F<>uFvT<KuFJ<MuF@<HuF6<PuF,<GuF"<IuF<QuF<OuFF FPQF݊FP~WuhF݈FF] U D
F~ uC
FF<HuF,<PuF"<KuF<MuF<-uFQF FPQFFFF]U帰D~
W~W PN~WW PNA
0䉆M
0䉆 PW~ M
~ tyPPM
PWPP&M
PPPPP
+PW~ M
PP
WPW~W PN P1Pv

 u
ƆPQPWPOW	tF~ t2PW~ M
PWPPQM
PP
F] .  Press <ESC> U帎D~W~W PNA
0䉆zM
0䉆xwPPM
WPP&M
~ u+~ t++PPPPP
PP
WrW~W PO P1Pv
~ u "Ft` PrW~ M
PrW~ M
WW1PvWWY}WPPQM
PrW~ M
zPxP
w] U1DQ +F
88Wvv
vZ 
] U市 D ~W~W PN PF0PF
0P~WF0P~0и) +PF
0PZ 
]  U市D~W~W PN~:Fs,~W~W4~W~W PNˍ~W~W PN]  Cannot open fileCannot set date/timeCannot get date/timeCannot close fileU帘D~W~W PNhW~W4W~W PNǆj=Љx~@p!PjW jh|% 	t	W~ t@ǆjWhldndp!PjW |% 	t	W>>ǆj Whl!PjW ndpd|% 	t	Wǆj >hl!PjW |% 	t	/W] Not enough memoryU DF^VF^V111s8 1ۺ Nv~ 1 11F^VFNv~v~ t		W~
1&&E
~
Wv)] UDW~
W~&0P P_&F~ u~
W~&0PF0P] U D
F~ u
FFF~6}
 tFPQFFFF] U D  WFPO~W P~
&0P|~
&] U1D~W~
&0P P]
 U1D~
&~W~
W]
 U帄 D ~W~W PN~W~
W$u@~0Ћ~6}&0+|~W~
W PN~6}&~&] UD~WzW PN~&= v~&ƆƆFH P~W~ M
P~W~ M
FPFP
ǆ ~&= t[0;~0+W~W@PW PNWW1Pv~&0;}$W P~&0ЋF+P!~&:vW P1P0F+PFP
UX~&~&<uzW~W PN<u=w ~&= w "tW~WUh<t<u;~&:v ~&= w "tW~WUD%<t<uv<t<u0~&= w Њ~&:v "t <t<t<uW~WU <t<uƆ <t<u~& <u~&:w~WWq<uzW~WWUV< rR<wN~&PZ+Wt9 tW~WUh~&0;F}~&PW~WU Ɔ ~&P:+Wu0P~W~ M
]               U DFFFFF 1FFFP~W ] U DF 1FP~W F0~
&F0~&]
 U DF
< u~~F~W~ WU <uC~~F~&}u ~&=u "t~&5~&uU
I<u
  P1PU8<u P  PU&<u"> u P PU P PU] U1D PW >u ~>~ t  >uH+++++p+++p+p+++++p++P+W P+W]U1DF0؊F0习 ãd] U1DP>dW~WF0P/
] U1D~WP>dWF0Pi
] U DF+F@FFFF
;F:FFFPFPDFЋF+F
~WFPRF;Fuˉ] U DF+F@FFFF
;F:FFFPFPFЋF+F
~WFPF;Fuˉ]         U<u  t Ё> t "¢]3KUn
^v)fsu	rsë]
 Un^v
'su	rsĪGG] Un
^JGN,F>uu	rsĪGG] U۠~vNsu	rsۋ]
 U~vNsu	rsë]
   3t@˴2              U* WWWW]˴<t
<v V  2$3@ @ l &&:t&?7 3/%!ú@ && <t<rP TX
t- G0  =*u&   ) "ôP0  X 
u<wʴ v3
Po؀>  tXπ> u t ^C	#6G#n 6W
6w6O6o:w':w#xx:w:.w
=  >
4! >ʊ
˸PX>
:u2ˋ6W6wr:
w6	r	:6w **	ˋ6Gt$&p 6G$& &ˀˠˋ6Wt3& Ju &:uË6_4 ;sauaCBB a$aˀ> u tˠ 
u2
u
&
uˋ6EE  E]EYME0  6oˁ}t
E׸>؉EM]MMM3 U~&UJJ&u&}3 \ <t4<t0<tDI<t'<t#<t7<tF<
tO< r;t&C ;vt   } K;t&< rj C둀> t&C
N &
CC~3&E&]
] 6&M&)M&}> u& G 3 3 
 
SQRPr X<t*<t-<
t3<
t5	2 ReZ:
v Q:t
	 - ZY[:6vQR>
ZYô22@ ؋P ڋ&<t!<t,<
t5<
t9G:
v<o ,c QR ZYT :tG x? G1 @ ؉P &J 2ȋc  B J B;tcQRW+Ί6@ ؊&J 2ڋc  >I u
tutë笫_ZYVWU]_^             ^ZY[!PSQRVU윻E S3ێۊ^SvPحȭЭPP^X˜WU~ë«XƫXثXX]     oڌ53 £444455& - 5 .5!E  %! #%! $%! ?%!PPP
JPPP
;Xǖ 9sWT!NX[YZ^_]ϸ  Y[ 33ۺo5t4t&; t& +5555t355"5PS˸P
P
 .%!55t)* 52  5@ :U 55  5L!.
t8 Cñd 
 20P XP XP X$0<:rд! #$456789:;<=>?uRuntime error   at  .
 3"5˃>"5 uˡ"56D&;U|&;r&;U|&;Ew˸ +r
 r;6 5r˸ t܌6w
66O
 ȋڋPR؋ZXUt`ۜy
Ӄ Ҝy
  33۽! +sMuyӃ y
y
,0,
                  MaxLinesEntered,0,FALSE);
             IF p_min <> 0 THEN p_max := getnumber ('Ending line (1- ' + stri (MaxLinesEntered) + ') or 0 to abort? ',
                  0,MaxLinesEntered,0,FALSE)
             ELSE p_max := 0;
             IF p_max = 0 THEN p_min := 0;
          END;
          IF (p_min <> 0) AND (p_max <> 0) AND (p_max <= MaxLinesEntered) THEN BEGIN
             IF p_min = -1 THEN p_min := 1;
             IF p_max = -1 THEN p_max := MaxLinesEntered;
             IF (p_min <= p_max) THEN BEGIN
                FOR i := 1 TO ((p_max - p_min) + 1) DO BEGIN
                   FOR x := p_min TO MaxLinesEntered DO
                      IF x < MaxLinesEntered THEN MessBuff [x] := MessBuff [x + 1];
                   MaxLinesEntered := PRED (MaxLinesEntered);
                END;
                lineout (stri(p_max - p_min + 1) + ' line(s) deleted');
             END;
          END;
       END;

    PROCEDURE replace_line;

       VAR
          newline : STRING [80];

       BEGIN
          IF (p_min < 1) OR (p_min > MaxLinesEntered) THEN BEGIN
             p_min := getnumber ('Replace line #(1-' + stri (MaxLinesEntered) + ') or 0 to abort? ',0,
                  MaxLinesEntered,0,FALSE);
          END;
          IF p_min <> 0 THEN BEGIN
             list_message (p_min,p_min);
             IF yes ('Replace this line(y/n)? ') THEN BEGIN
                lineout ('Enter new line or enter <RETURN> to abort: ');
                newline := getinput ('',lcase,echo,user.width);
                IF newline = '' THEN show_error ('Line NOT replaced')
                ELSE BEGIN
                   show_error ('Line REPLACED.');
                   MessBuff [p_min] := newline;
                END;
             END;
          END;
       END;

    PROCEDURE edit_line;

       VAR
          tempint  : INTEGER;
          newline  : STRING[80];
          x        : INTEGER;
          oldline  : STRING[80];

       BEGIN
          IF (p_min < 1) OR (p_min > MaxLinesEntered) THEN BEGIN
             p_min := getnumber ('Edit line #(1- ' + stri (MaxLinesEntered) + ') or 0 to abort? ',0,MaxLinesEntered,
                  0,FALSE);
          END;
          tempint := p_min;
          IF tempint <> 0 THEN BEGIN
             list_message (tempint,tempint);
             REPEAT
                oldline := getinput ('Enter old string: ',lcase,echo,80);
                IF oldline <> '' THEN BEGIN
                   x := Pos (oldline, MessBuff [tempint]);
                   IF x = 0 THEN lineout ('Not found!')
                   ELSE BEGIN
                      newline := getinput ('New string: ',lcase,echo, (user.width - Length (MessBuff [tempint])) +
                           Length (oldline));
                      IF newline <> '' THEN BEGIN
                         Delete (MessBuff [tempint],x, Length (oldline));
                         Insert (newline, MessBuff [tempint], x);
                         list_message (tempint,tempint);
                      END;
                   END;
                END;
             UNTIL (newline <> '') OR (oldline <> '') OR (NOT there);
          END;
       END;

    PROCEDURE search;

       VAR
          templine : STRING [80];
          replacew : STRING [80];
          x        : INTEGER;
          i        : INTEGER;
          y        : INTEGER;
          confirm  : BOOLEAN;
          replace  : BOOLEAN;

       BEGIN
          lineout ('');
          lineout ('Enter string to find below (EXACT MATCH) or <RETURN> to abort:');
          templine := getinput ('',lcase,echo,user.width);
          IF templine <> '' THEN BEGIN
             lineout ('');
             lineout ('Enter new string to replace with or <RETURN> for search only:');
             replacew := getinput ('',lcase,echo,user.width);
             confirm := FALSE;
             IF replacew <> '' THEN confirm := yes ('CONFIRM each(y/n)? ');
             lineout ('Searching...');
             x := 0;
             WHILE (x < MaxLinesEntered) AND (there) DO BEGIN
                i := 0;
                x := Succ (x);
                i := Pos (templine,MessBuff [x]);
                IF (i > 0) AND ((Length (replacew)  + Length (MessBuff [x])) - Length (templine) <= user.width) THEN
                     BEGIN
                   IF NOT confirm THEN lineout ('Found: Line #' + stri(x));
                   IF replacew <> '' THEN BEGIN
                      replace := TRUE;
                      IF confirm THEN BEGIN
                         list_message(x,x);
                         IF i > 1 THEN
                            FOR y := 1 TO (i-1) DO stringout (' ');
                         lineout ('    ^');
                         IF yes ('REPLACE(y/n)? ') THEN replace := TRUE
                         ELSE replace := FALSE;
                      END;
                      IF replace THEN BEGIN
                         Delete (MessBuff [x],i,Length (templine));
                         Insert (replacew,MessBuff [x],i);
                         x := PRED (x);
                      END;
                   END;
                END;
             END;
          END;
       END;                        {end of procedure}

    PROCEDURE change_title;

       VAR
          newtitle : STRING [28];

       BEGIN
          lineout('');
          lineout ('OLD title: ' + messageheader.title);
          newtitle := getinput ('Enter new title or <RETURN> to abort: ',lcase,echo,28);
          IF newtitle <> '' THEN messageheader.title := newtitle
          ELSE lineout ('** Title NOT changed **');
       END;




    BEGIN
       done := FALSE;
       p_abort := FALSE;
       REPEAT
          IF (NOT SaveMsg) AND (NOT AbortMsg) AND (NOT QuoteMsg) THEN
           BEGIN
             StringOut (C('G2'));
             option := getinput ('Edit option: ',ucase,echo,80);
             parse(option,p_cmd,p_min,p_max,p_abort);
             StringOut (C('W2'));
          END;
          IF SaveMsg THEN p_cmd := 'S';
          IF AbortMsg THEN p_cmd := 'A';
          IF QuoteMsg THEN P_Cmd := 'Q';
          IF (p_cmd <> '') AND (NOT p_abort) THEN
             CASE p_cmd [1] OF
                'A' : BEGIN
                   AbortMsg := FALSE;
                   IF yes ('Abort (y/n)? ') THEN done := TRUE;
                END;
                'I' : insert_lines;
                'F' : search;
                'D' : BEGIN
                   delete_lines;
                   IF MaxLinesEntered = 0 THEN done := TRUE;
                END;
                'E' : edit_line;
                'R' : replace_line;
                'T' : change_title;
                'S' : BEGIN
                       IF MaxLinesEntered > 0 THEN SaveMessage(board_to_save)
                       ELSE
                        BEGIN
                         LineOut ('');
                         LineOut (C('R')+'You must enter text to save a message!');
                         LineOut (C('W2'));
                        END;
                       END;
                'Q' : BEGIN
                       Quoter;
                       IF QuoteMsg THEN P_Cmd := 'C';
                       QuoteMsg := FALSE;
                      END;
                'C' : IF MaxLinesEntered < 40 THEN
                        edit (MaxLinesEntered + 1,board_to_save);
                'L' : BEGIN
                   IF (p_min = -1) AND (p_max = -1) THEN BEGIN
                      p_min := 1;
                      p_max := MaxLinesEntered;
                   END;
                   IF (p_min < 1) AND (p_max <> -1) THEN p_min := 1;
                   IF (p_min <> -1) AND (p_max < 1) THEN p_max := MaxLinesEntered;
                   IF (p_min <= p_max) AND (p_min <= MaxLinesEntered) AND (p_max <= MaxLinesEntered) THEN
                        list_message (p_min, p_max);
                END;
                '?' : BEGIN
                   lineout ('');
                   lineout ('(A)bort   (C)ontinue   (I)nsert (F)ind (and Replace)');
                   lineout ('(D)elete  (E)dit line  (L)ist   (R)eplace line');
                   lineout ('(T)itle   (S)ave       (Q)uote');
                   lineout ('');
                END;
             END;
       UNTIL (done) OR (NOT there) OR (p_cmd [1] = 'S');
       MaxLines := 40;
    END;




PROCEDURE post (board_number : integer; personto, alaisto: NameType; reference:LONGINT; oldtitle : nametype; Force: BOOLEAN);

    VAR
       i : INTEGER;
       numSTR : STRING[5];
       question : STRING[5];
       done     : BOOLEAN;
       title    : STRING[25];
       date     : date_type;
       time     : time_type;
       last_line: INTEGER;
       drive    : INTEGER;


    BEGIN
       drive := Ord (boardpack [board_number].path [1]) - 64;
       IF ((drive_space [drive]) >= (3328 + 103)) AND (boardpack [board_number].total_msgs < max_msgs_possible) THEN
            BEGIN
          FillChar (MessBuff, MaxLines, 0);
          done := FALSE;
          MessageHeader.Reference := Reference;
          StringOut (C('C2'));
          IF personto = '' THEN BEGIN
             IF Config.To_Prompt THEN BEGIN
                messageheader.personto := getinput ('To <CR for ALL>: ',lcase,echo,25);
                IF messageheader.personto = '' THEN messageheader.personto := 'ALL';
             END
             ELSE messageheader.personto := 'ALL';
          END
          ELSE messageheader.personto := personto;
          IF AlaisTo = '' Then AlaisTo := MessageHeader.PersonTo;
          MessageHeader.AlaisTo := AlaisTo;
          StringOut (C('G2'));
          IF (messageheader.personto = personto) AND (board_number <> 0) THEN lineout ('To: ' + messageheader.Alaisto);
          IF oldtitle = '' THEN BEGIN
             messageheader.title := getinput ('Title: ',lcase,echo,25);
             IF messageheader.title = '' THEN done := TRUE;
          END
          ELSE
           BEGIN
             If Cnum = 0 THEN lineout ('Title: ' + oldtitle);
             IF NOT Force THEN
              BEGIN
               StringOut (C('R2'));
               title := getinput ('Enter title (CR for old): ',lcase,echo,25);
              END
              ELSE Title := OldTitle;
               IF title = 'CR' THEN ShitHeadError
             ELSE IF title = '' THEN BEGIN
                IF Pos ('(R)',messageheader.title) = 0 THEN messageheader.title := '(R)' + oldtitle
                ELSE messageheader.title := oldtitle;
             END
             ELSE messageheader.title := title;
          END;
          messageheader.locked := FALSE;
          messageheader.deleted := FALSE;
          messageheader.from := user.name;
          IF NOT done THEN BEGIN
             CurrentDate (date);
             CurrentTime (time);
             messageheader.date := strd (date);
             messageheader.time := strt (time);
             MaxLinesEntered := 0;
             edit (1,board_number);
             EditOptions (board_number);
          END;
       END
       ELSE show_error ('Not enough disk space. Please try later');
    END;


 PROCEDURE sendmail;

    VAR
       towhom     : STRING[25];
       dummy      : INTEGER;
       OldPointer : INTEGER;

    BEGIN
       REPEAT
          StringOut (C('C2'));
          towhom := getinput ('To: ',ucase,echo,25);
          IF towhom <> '' THEN BEGIN
             IF FindHash (towhom,dummy) THEN BEGIN
                OldPointer :=BoardPack[0].Msg_Pointer;
                BoardPack[0].Msg_Pointer :=0;
                post (0, towhom,'',0,'',FALSE);
                BoardPack[0].Msg_Pointer :=OldPointer;
                towhom := ''
             END
             ELSE lineout ('User not found...');
          END;
       UNTIL (towhom = '') OR (NOT there);
       StringOut (C('W2'));
    END;


 END.
