UNIT CharIO;

INTERFACE

   USES Dos, Crt, QBBS, IBMCOM1D, Windows, StrStuff, SpaceStf;
   FUNCTION ExistFile (name :STRING) : BOOLEAN;
   PROCEDURE StringOut (St: STRING);
   PROCEDURE LineOut (St: STRING);
   PROCEDURE Reads (VAR St: STRING; Size : INTEGER; Chars : Charset; Allcaps : BOOLEAN; Echo: BOOLEAN);
   FUNCTION  There: BOOLEAN;
   PROCEDURE Hangup;
   PROCEDURE ScanKbd;
   FUNCTION  ReadC : Char;
   PROCEDURE BreakCheck;
   PROCEDURE ClearBreak;
   PROCEDURE EnableBreak;
   PROCEDURE DisableBreak;
   PROCEDURE WriteC (Ch : CHAR);
   PROCEDURE Chat;
   PROCEDURE ShitHeadError;
   PROCEDURE PullApart (Input : STRING);
   FUNCTION GetInput (Outstring : anystring; caps, echoyn : BOOLEAN; size : INTEGER) : STRING;
   FUNCTION getnumber ( prompt : STRING ; min : LONGINT; max : LONGINT; default: LONGINT; qmark  : BOOLEAN): LONGINT;
   FUNCTION yes (prompt: STRING): BOOLEAN;
   PROCEDURE show_error (prompt : STRING);
   PROCEDURE Parse (Input : STRING; VAR command : STRING; VAR min, max : INTEGER; VAR Abort : BOOLEAN);
   FUNCTION C (NewColor:STRING):STRING;
   FUNCTION CF (NewColor:STRING):STRING;


IMPLEMENTATION






CONST
  ColorTable : ARRAY [0..31] of INTEGER = (0,
                                           0,
                                           0,
                                           0,
                                           0,
                                           0,
                                           0,
                                           0,
                                           0,
                                           4,
                                           2,
                                           6,
                                           1,
                                           5,
                                           3,
                                           7,
                                           0,
                                           12,
                                           10,
                                           14,
                                           9,
                                           13,
                                           11,
                                           15,
                                           0,
                                           0,
                                           0,
                                           0,
                                           0,
                                           0,
                                           0,
                                           0);
  ColorList : ARRAY [0..31] of STRING =        ('OFF',
                                                'BOLD',
                                                'FAINT',
                                                'ITALIC',
                                                'BLINK',
                                                'RAPID BLINK',
                                                'REVERSE VIDEO',
                                                'CONCEALED',
                                                'BLACK',
                                                'R',
                                                'G',
                                                'Y',
                                                'B',
                                                'M',
                                                'C',
                                                'W',
                                                'BLACK2',
                                                'R2',
                                                'G2',
                                                'Y2',
                                                'B2',
                                                'M2',
                                                'C2',
                                                'W2',
                                                'BLACK BACKGROUND',
                                                'RED BACKGROUND',
                                                'GREEN BACKGROUND',
                                                'YELLOW BACKGROUND',
                                                'BLUE BACKGROUND',
                                                'MAGENTA BACKGROUND',
                                                'CYAN BACKGROUND',
                                                'WHITE BACKGROUND');

ResultList : ARRAY [0..31] of BYTE = (0,
                                      1,
                                      2,
                                      3,
                                      5,
                                      6,
                                      7,
                                      8,
                                      30,
                                      31,
                                      32,
                                      33,
                                      34,
                                      35,
                                      36,
                                      37,
                                      30,
                                      31,
                                      32,
                                      33,
                                      34,
                                      35,
                                      36,
                                      37,
                                      40,
                                      41,
                                      42,
                                      43,
                                      44,
                                      45,
                                      46,
                                      47);

VAR
  I : INTEGER;

FUNCTION C (NewColor:STRING):STRING;

  VAR
      I        : INTEGER;
      Result   : INTEGER;
      Code     : INTEGER;
      TempStr  : STRING;
      TempStr2 : STRING;
      ColorC   : STRING;

  BEGIN
    Result := -1;
    For I := 0 to 31 do
      BEGIN
        IF NewColor = ColorList[I] THEN Result := I;
      END;
    If Result > -1 THEN
      BEGIN
       If User.Graphics THEN
        BEGIN
         Str (ResultList[Result],TempStr);
         If ((Result > 14) and (Result < 24)) THEN
          TempStr2  := '1;' ELSE TempStr2:=';';
         ColorC    :='['+TempStr2+TempStr+';40m';
         If Connect_Mode = REMOTE THEN Com_Tx_String (ColorC);
         TextColor(ColorTable[Result]);
         OldColor :=ColorTable[Result];
        END;
       C :='';
      END
      ELSE
      BEGIN
        LineOut('');
        LineOut ('ERROR:  Bad Color Code Passed to PROCEDURE Color Change!');
        LineOut ('        Please tell sysop!');
        LineOut ('');
      END;
    END;

FUNCTION CF (NewColor:STRING):STRING;

  VAR
      I        : INTEGER;
      Result   : INTEGER;
      Code     : INTEGER;
      TempStr  : STRING;
      TempStr2 : STRING;
      ColorC   : STRING;

  BEGIN
    Result := -1;
    For I := 0 to 31 do
      BEGIN
        IF NewColor = ColorList[I] THEN Result := I;
      END;
    If Result > -1 THEN
      BEGIN
         Str (ResultList[Result],TempStr);
         If ((Result > 14) and (Result < 24)) THEN
          TempStr2  := '1;' ELSE TempStr2:=';';
         ColorC    :='['+TempStr2+TempStr+'m';
       CF :=ColorC;
      END
      ELSE
      BEGIN
        LineOut('');
        LineOut ('ERROR:  Bad Color Code Passed to PROCEDURE Color Change!');
        LineOut ('        Please tell sysop!');
        LineOut ('');
      END;
    END;

FUNCTION ExistFile (name :STRING) : BOOLEAN;
 var
  checkfile : text;
 begin
  assign (checkfile,name);
  {$I-}
  reset (checkfile);
  {$I+}
  if ioREsult <> 0 then existfile := false
   else
    begin
     close (checkfile);
     existfile := true;
    end;
 end;


 PROCEDURE stringout (st: STRING);

    VAR
       i: BYTE;

    BEGIN
       FOR i := 1 TO Length (st) DO writec (st [i] );
    END;

 PROCEDURE lineout (St: STRING);

    BEGIN
       stringout (st + ^m);

    END;


    PROCEDURE ScanKbd;
 var
  ch : char;
  time_left : integer;
  line_save : anystring;
  time : time_type;
  date : date_type;
  Done : BOOLEAN;



  PROCEDURE KickOff;
  BEGIN
    IF connect_mode = remote THEN Hangup;
    connect_mode := remote;
  END;


  procedure start_import;
   var
    name :string [35];
   begin
    writeln;
    write ('Enter filename to import: ');
    readln (name);
    if name <> '' then
     begin
      assign (imp_file,name);
      {$I-}
      reset (imp_file);
      {$I+}
      if IOResult <> 0 then writeln ('-- Could not open file --')
      else importing := true;
     end;
   end;

  procedure start_capture;
   var
    name : string [35];
   begin
    writeln;
    write ('Enter filename to capture to: ');
    readln (name);
    if name <> '' then
     begin
      assign (CapFile, name);
      {$I-}
      rewrite (CapFile);
      {$I+}
      if IOResult = 0 then
       begin
        capturing := true;
        writeln ('*** CAPTURING ***');
       end
      else writeln ('Could not open file...');
      writeln;
     end;
   end;


  procedure close_capture;
   begin
    close (CapFile);
    capturing := false;
   end;

 procedure close_import;
  begin
   close (imp_file);
   importing := false;
   com_flush_Rx;
  end;

 begin
    if (min_tick = 58 ) then
     BEGIN
      UpdateWindow (utime);
      Min_Tick := 59;
     END;
     IF timecheck THEN
      IF time_logged >= warning_time THEN
        BEGIN
          time_left := time_limit - time_logged;
          timecheck := False;
          line_save := current_line;
          IF wherex > 1 THEN lineout ('');
          lineout (^g'You have ' + stri (time_left DIV 60) + 'left.');
          stringout (line_save);
          warning_time := 32767;
          timecheck := True;
        END
      ELSE
       IF time_logged >= time_limit THEN
        BEGIN
          timecheck := False;
          IF wherex > 1 THEN lineout ('');
          lineout (^g'Your time is up.');
          CurrentTime (time);
          CurrentDate (date);
          lineout (^g + user.name + ' logging off at ' + strt (time) + ' on ' + strd (date) );
          lineout ('Thanks for calling!');
          Hangup;
          connect_mode := remote;
          timecheck := True;
        END;
   ch := #00;
   if (chat_key) and (not chatting) then chat;
   Chat_Key := FALSE;
   if keypressed then CH := Readkey;
   if (ch = #00) and (importing) then
    begin
     if not EOF (imp_file) then read (imp_file,ch) else close_import;
    end;
   if ch <> #00 then
    begin
     case ch of
       ^c, ^k : begin
                  ctrl_c := true;
                  if ch = ^k then ctrl_k := true;
                  Com_Flush_Rx;
                end;
       ^s     : ctrl_s := true;
       ^l     : UpdateWindow (setNewlevel);
       ^b     : UpdateWindow (Avail);
       ^t     : BEGIN
		 UpdateWindow (SetNewTime);
		 UpdateWindow (uTime);
                END;
       ^d     : KickOff;
       ^x     : UpdateWindow (usrc);
       ^f     : UpdateWindow (Keyb);
       ^w     : UpdateWindow (ToggleMenu);
       ^o     : if not importing then start_import
                   else
                     begin
                       writeln ('-- Import Closed --');
                       close_import;
                     end;
       ^p      : if not capturing then start_capture
                    else
                      begin
                        writeln ('-- File Closed --');
                        close_capture;
                        end;
       ^[      : Chat_Key := TRUE;
                    end;
                   end;
     if (ch = ^[) and (not chat_key) then ch := #0
     else if (ch <> #0) then
         begin
           anykey := true;
           IF (rx_chars <= rx_queue_size) THEN
          BEGIN
          rx_queue [rx_in] := Ord (ch);
          Inc (rx_in);
          IF rx_in > rx_queue_size THEN
            rx_in := 1;
          rx_chars := Succ (rx_chars);
          END;
        END;
  if not there and (importing) then
   begin
    writeln ('CLOSING IMPORT');
    close_import;
   end;
 end; {End of getting of the ScanKbd}

 
    FUNCTION ReadC : char {New Read C that I put in ***************};
 VAR
   ch       : Char;
   line_save: String [80];
   time     : time_type;
   date     : date_type;
 BEGIN
   inactive := inactive_time;
   inactive_warned := False;
   REPEAT
     ScanKbd;
     ch := chr (ord (com_Rx));
     if ch = #127 THEN ch := ^h;
     IF inactive <= 0 THEN
       BEGIN
        IF wherex > 1 THEN lineout ('');
        CurrentTime(time);
        CurrentDate(date);
        lineout (^g + user.name + ' logging off due to inactivity at ' + strt (time) + ' on ' + strd (date) );
        lineout ('Thanks for calling!');
        Hangup;
        connect_mode := remote;
       END
     ELSE
      IF (inactive <= inactive_warn_time) AND NOT inactive_warned THEN
        BEGIN
         line_save := current_line;
         IF wherex > 1 THEN lineout ('');
         lineout (^g'You have ' + stri (inactive_warn_time) + ' seconds in which to do something!');
         stringout (line_save);
         inactive_warned := True;
        END;
  UNTIL (ch <> #0) OR NOT there;
  readc := ch;
end;

PROCEDURE reads (VAR st : STRING;
      size   : INTEGER;
      chars  : charset;
      allcaps: BOOLEAN;
      echo   : BOOLEAN);

    VAR
       done: BOOLEAN;
       ch  : CHAR;
       len : BYTE;

    PROCEDURE cr;

       BEGIN
          writec (^m);
          done := TRUE;
       END;

    PROCEDURE bs;

       BEGIN
          IF len > 0 THEN BEGIN
             st [0] := Chr (len - 1);
             writec (^h);
          END;
       END;

    PROCEDURE clear;

       VAR
          i: BYTE;

       BEGIN
          FOR i := 1 TO len DO writec (^h);
          st := '';
       END;

    PROCEDURE word_left;

       VAR
          i : BYTE;
          cancel : BOOLEAN;

       BEGIN
          IF Length(st) > 0 THEN BEGIN
             i := Length (st);
             cancel := FALSE;
             WHILE (NOT cancel) AND (there) DO BEGIN
                IF st [i] <> ' ' THEN BEGIN
                   writec (^h);
                   Delete (st,i,1);
                END
                ELSE BEGIN
                   writec (^h);
                   Delete (st,i,1);
                   cancel := TRUE;
                END;
                i := PRED (i);
                IF i <= 0 THEN cancel := TRUE;
             END;
          END;
       END;



    PROCEDURE Append;

       VAR
          i: BYTE;
          x: BYTE;

       BEGIN
          IF allcaps THEN ch := UpCase (ch);
                                   {IF ch IN chars THEN}
          IF len >= size THEN BEGIN
             IF wrap THEN BEGIN
                i := len + 1;
                REPEAT
                   i := i - 1;
                   IF st [i] <> ' ' THEN wrap_save := st [i] + wrap_save;
                UNTIL (st [i] = ' ') OR (i = 1);
                IF st [i] = ' ' THEN BEGIN
                   FOR x := len DOWNTO i DO writec (^a);
                   FOR x := i TO len DO writec (' ');
                   st := Copy (st, 1, i - 1);
                END
                ELSE wrap_save := '';
                cr;
                wrap_save := wrap_save + ch;
             END;
          END
          ELSE BEGIN
             st := st + ch;
             IF echo THEN writec (ch)
             ELSE writec ('.');
          END;
       END;

    PROCEDURE tab;

       VAR
          i : INTEGER;

       BEGIN
          i := 0;
          REPEAT
             i := Succ (i);
             ch := ' ';
             len := Length(st);
             Append;
          UNTIL (i = 8) OR (NOT there) OR (done);
       END;

    BEGIN                          {ReadS}
       IF wrap THEN BEGIN
          st := wrap_save;
          stringout (st);
       END
       ELSE st := '';
       wrap_save := '';
       done := FALSE;
       REPEAT
          ch := readc;
          IF chatting AND chat_key THEN done := TRUE
          ELSE BEGIN
             len := Length (st);
             CASE ch OF
                ^m           : cr;
                ^h           : bs;
                ^x           : clear;
                ^a           : word_left;
                ^i           : tab;
                #32..#127, ^p:  Append;
                #128..#255:     IF ExtChars THEN Append;
             END;
          END;
       UNTIL done OR NOT there;
    END;


FUNCTION There: BOOLEAN;
BEGIN
  IF (connect_mode = local) OR com_carrier THEN
    there := True
  ELSE
    BEGIN
    there := False;
    IF NOT there_triggered THEN
      BEGIN
      IF wherex > 1 THEN Writeln;
      delay (9);
      com_lower_dtr;
      there_triggered := True;
      END;
    END;
END;


PROCEDURE Hangup;
VAR
  I : LONGINT;
BEGIN
 REPEAT
  BEGIN
   com_lower_dtr;
   IF Com_Carrier THEN
    BEGIN
     Delay (5000);
     StringOut ('+++');
     Delay (5000);
     LineOut (Config.HangupSTR);
    END;
   connect_mode := remote;
  END;
 UNTIL (NOT Com_Carrier);
 if connect_mode = local then connect_mode := remote
END;


PROCEDURE BreakCheck;
BEGIN
  ScanKbd;
  IF NOT break THEN
    BEGIN
    IF ctrl_s THEN
      BEGIN
      anykey := False;
      REPEAT
        ScanKbd;
      UNTIL anykey OR NOT there;
      Com_Flush_Rx;
      ctrl_s := False;
      END;
    IF ctrl_c AND break_enabled THEN
      BEGIN
      break_enabled := False;
      lineout ('^c');
      break := True;
      ctrl_c := False;
      END
    ELSE
      break := False;
    END;
END;

PROCEDURE ClearBreak;
BEGIN
  ctrl_c := False;
END;

PROCEDURE EnableBreak;
BEGIN
  break := False;
  break_enabled := True;
END;

PROCEDURE DisableBreak;
BEGIN
  break := False;
  break_enabled := False;
  ClearBreak;
end;

PROCEDURE chat;

    VAR
       st                : STRING;
       line_save         : STRING [80];
       wrap_save         : BOOLEAN;
       break_save        : BOOLEAN;
       break_enabled_save: BOOLEAN;

    BEGIN
       line_save := current_line;
       chatting := TRUE;
       yelling := FALSE;
       wrap_save := wrap;
       wrap := TRUE;
       break_save := BREAK;
       break_enabled_save := break_enabled;
       lineout ('');
       lineout (^n + Config.ChatIn);
       lineout ('');
       BREAK := FALSE;
       break_enabled := FALSE;
       done_chatting := FALSE;
       chat_key := FALSE;
       REPEAT
          reads (st, term_width - 1, [#32..#127], FALSE, TRUE)
       UNTIL chat_key OR NOT there;
       lineout ('');
       lineout (^n + Config.ChatOut);
       lineout ('');
       clearbreak;
       break_enabled := break_enabled_save;
       BREAK := break_save;
       wrap := wrap_save;
       chatting := FALSE;
       chat_key := FALSE;
       stringout (line_save);
    END;

PROCEDURE WriteC (Ch: Char);

VAR
  I: Byte;

  PROCEDURE OutputToRemote;
  BEGIN
    CASE ch OF
      ^a: com_tx (^h);
      ^h: Com_Tx_String (^h' '^h);
      ^m: Com_Tx_String (^m^j);
      ^b: com_tx (^m);
      ^n: IF wherex > 1 THEN Com_Tx_String (^m^j);
      ^p: delay (500);
    ELSE
      com_tx (ch);
      END;
  END;

 PROCEDURE OutputToFile;
   begin
    {$I-}
    case ch of
     ^a: write (CapFile,^h);
     ^h: write (CapFile,^h' '^h);
     ^m: write (CapFile,^m^j);
     ^b: write (CapFile,^m);
    else write (CapFile,ch);
     end;
    {$I+}
    if IOResult <> 0 then
     begin
       writeln ('Error in output');
       close (CapFile);
       capturing := false;
      end;
   end;


  PROCEDURE OutputToLocal;
  BEGIN
    CASE ch OF
      ^a: Write (^h);
      ^b: Write (^m);
      ^g: IF NOT silence THEN Write (^g);
      ^h: Write (^h' '^h);
      ^m: Write (^m^j);
      ^n: IF wherex > 1 THEN write (^m^j);
      ^p: delay (500);
    ELSE
      Write (ch);
      END;
  END;

  PROCEDURE remember;
  BEGIN
    CASE ch OF
      ^a, ^h   : current_line := Copy (current_line, 1, Length (current_line) - 1);
      ^m, ^n   : current_line := '';
      ^b       : current_line := '';
      #32..#255, ^p: current_line := current_line + ch;
      END;
  END;

BEGIN {WriteC}
  IF there THEN BreakCheck;
  IF (NOT break) AND there THEN
    BEGIN
      IF (connect_mode = remote) THEN OutputToRemote;
      OutputToLocal;
      if capturing then OutputToFile;
      remember;
    END;
END;


 PROCEDURE ShitHeadError;

    BEGIN
     lineout ('');
     lineout ('When it tells you to enter "CR" it does not mean you enter a');
     lineout ('"C" and "R", you enter a RETURN.');
     lineout ('');
    END;


 PROCEDURE PullApart (Input : STRING);

    VAR
       i : INTEGER;

    BEGIN
       CNum := 0;
       FOR i := 1 TO 10 DO commands [i] := '';
       i     := 1;
       WHILE (CNum < 10) AND (i > 0) DO BEGIN
          CNum := Succ (CNum);
          i := Pos (';',Input);
          CASE i OF
             0 : commands [CNum] := Input;
             ELSE
                BEGIN
                   commands [CNum] := Copy (Input,1,i-1);
                   Delete (Input,1,i);
                END;
          END;
       END;
    END;


 FUNCTION GetInput (OutString : anystring; caps, echoyn : BOOLEAN; size : INTEGER) : STRING;

    VAR
       tempvar : STRING;
       i       : INTEGER;


    BEGIN
       IF CNum = 0 THEN
         BEGIN
          stringout(outstring);
          reads(tempvar,size,[#32..#127],caps,echoyn);
          IF NOT wrap THEN pullapart (tempvar);
         END;
       IF NOT wrap THEN
         BEGIN
          tempvar := commands [1];
          FOR i := 1 TO (CNum - 1) DO commands [i] := commands [i+1];
          CNum := PRED (CNum);
         END;
       IF caps THEN tempvar := allcaps (tempvar);
       getinput := tempvar;
    END;



 FUNCTION getnumber ( prompt : STRING;
      min    : LONGINT;
      max    : LONGINT;
      default: LONGINT;
      qmark  : BOOLEAN): LONGINT;

    VAR
       st   : STRING;
       code : INTEGER;
       i    : LONGINT;
       t    : LONGINT;

    BEGIN
       REPEAT
          IF CNum = 0 THEN BEGIN
             stringout(prompt);
             reads(st,40,[#32..#127],FALSE,TRUE);
             IF NOT wrap THEN pullapart (st);
          END;
          IF NOT wrap THEN BEGIN
             st := allcaps (commands [1]);
             FOR t := 1 TO (CNum - 1) DO commands [t] := commands [t+1];
             CNum := PRED (CNum);
          END;
          IF (st = '?') AND qmark THEN BEGIN
             i := min - 1;
             code := 0;
          END
          ELSE IF (st = '') OR NOT there THEN BEGIN
             i := default;
             code := 0;
          END
          ELSE BEGIN
             Val (st, i, code);
             IF (code <> 0) OR (i < min) OR (i > max) THEN BEGIN
                lineout ('Must be between ' + stri (min) + ' and ' + stri (max) );
                code := 1;
             END;
          END;
       UNTIL (code = 0) OR NOT there;
       oldinput := '';
       getnumber := i;
    END;

 FUNCTION yes (prompt: STRING): BOOLEAN;

    VAR
       st: STRING;
       i: INTEGER;

    BEGIN
       REPEAT
          IF CNum = 0 THEN BEGIN
             stringout(prompt);
             reads(st,40,[#32..#127],TRUE,TRUE);
             IF NOT wrap THEN PullApart (st);
          END;
          IF NOT wrap THEN BEGIN
             st := allcaps (commands [1]);
             FOR i := 1 TO (CNum - 1) DO commands [i] := commands [i+1];
             CNum := PRED (CNum);
          END;
          st := Copy (st, 1, 1);
       UNTIL (st <> '') AND (st [1] IN ['Y','N'] ) OR NOT there;
       yes := st = 'Y';
    END;



 PROCEDURE show_error (prompt : STRING);

    BEGIN
       lineout ('');
       lineout (prompt);
       lineOut ('');
    END;

 PROCEDURE Parse (       Input : STRING;
                   VAR   command : STRING;
                   VAR   min, max : INTEGER;
                   VAR   Abort : BOOLEAN);

    VAR
       i : INTEGER;
       morecommand : BOOLEAN;
       minstr, maxstr : STRING [5];
       moreminstr     : BOOLEAN;
       code           : INTEGER;
       totalmin       : INTEGER;
       totalmax       : INTEGER;
       testint        : INTEGER;

    BEGIN
       totalmin := min;
       totalmax := max;
       morecommand := TRUE;
       moreminstr := TRUE;
       command := '';
       minstr := '';
       maxstr := '';
       min := -1;
       max := -1;
       i := 0;

       Abort := FALSE;
       IF (Length (Input) = 1) THEN command := Input
       ELSE
        BEGIN
          Val (Input,testint,code);
          WHILE (i < Length (Input)) AND (NOT Abort) DO
           BEGIN
            i := Succ (i);
            IF (Input [i] IN [#58..#127,#32..#44,#46,#47])
             AND (morecommand) THEN command := command + Input [i]
             ELSE IF (NOT morecommand)
              AND (Input [i] IN [#58..#127,#32..#44,#46,#47])
               THEN Abort := TRUE;
            IF Input [i] IN ['0'..'9'] THEN
             BEGIN
              morecommand := FALSE;
               IF moreminstr THEN minstr := minstr + Input [i]
                ELSE maxstr := maxstr + Input [i];
             END;
            IF Input [i] IN ['-'] THEN moreminstr := FALSE;
            IF (Input [i] IN ['-']) AND (morecommand) THEN moreminstr := FALSE;
          END;
        Val (minstr,min,code);
        max := min;
        IF (maxstr = '') AND (Input [Length(Input)] = '-') THEN max := -1
         ELSE
          BEGIN
           Val(maxstr,max,code);
           If MoreMinStr = TRUE THEN Max := min;
          END;
        END;
    END;
END.