(*****************************************************************************)
(*>                                                                         <*)
(*>                     Telegard Bulletin Board System                      <*)
(*>      Copyright 1988-1991 by Martin Pollard.  All rights reserved.       <*)
(*>                                                                         <*)
(*>                     Data Types and File Structures                      <*)
(*>                                                                         <*)
(*****************************************************************************)

const
  ver:string[15]='2.7';         { current version number }

  maxboards=255;                { msg bases, 0 - x }
  maxuboards=255;               { file bases, 0 - x }
  maxprotocols=120;             { xfer protocols, 1 - x }
  maxevents=10;                 { scheduled events, 0 - x          }
                                { #0 is Nightly Events (if active) }
  maxarcs=8;                    { archivers, 1 - x }
  numvoteqs=20;                 { voting questions, 1 - x }
  numvoteas=9;                  { voting question answers, 0 - x }
  maxmenucmds=50;               { menu commands, 1 - x }

(*---------------------------------------------------------------------------*)

type
  acstring = string[20];                      { Access Control System string }
  acrq = '@'..'Z';                            { AR flags }
  clrs = array[FALSE..TRUE,0..9] of byte;     { color records:     }
                                              { [FALSE][x] = mono  }
                                              {  [TRUE][x] = color }
  secrange = array[0..255] of integer;        { security tables }
  cpackdatetime = array[1..6] of byte;        { packed date/time }
  mzscanr = set of 0..maxboards;              { msg base scan flags }
  fzscanr = set of 0..maxuboards;             { file base scan flags }
  mhireadr =
    array[0..maxboards] of cpackdatetime;     { last msg read table }

(*****************************************************************************)
(*                                                                           *)
(*       The format of the packed date/time structure is as follows:         *)
(*                                                                           *)
(*                 Byte #1    |    Byte #2    |    Byte #3                   *)
(*             ===============|===============|===============               *)
(*             7 6 5 4 3 2 1 0|7 6 5 4 3 2 1 0|7 6 5 4 3 2 1 0               *)
(*             `-----------' `-------------' `-----' `-------'               *)
(*                RESERVED        Year        Month     Day                  *)
(*                              (8 bits)    (4 bits) (5 bits)                *)
(*                                                                           *)
(*                 Byte #4    |    Byte #5    |    Byte #6                   *)
(*             ===============|===============|===============               *)
(*             7 6 5 4 3 2 1 0|7 6 5 4 3 2 1 0|7 6 5 4 3 2 1 0               *)
(*             `-------' `---------' `---------' `-----------'               *)
(*               Hour      Minute      Second    1/100 Seconds               *)
(*             (5 bits)   (6 bits)    (6 bits)     (7 bits)                  *)
(*                                                                           *)
(*****************************************************************************)

  uflags =            { user AC flags }
  (
    rlogon,           { L - Restricted to one call a day }
    rchat,            { C - Can't page the SysOp }
    rvalidate,        { V - Posts marked unvalidated }
    ramsg,            { A - Can't change the AutoMessage }
    rpostan,          { * - Can't post anonymously }
    rpostpvt,         { E - Can't post private }
    rpostnet,         { N - Can't post NetMail }
    rpost,            { P - Can't post at all }
    rvoting,          { K - Can't vote }
    rmsg,             { M - Force mail deletion }
    rreserved,        { RESERVED }
    onekey,           { onekey input mode }
    avatar,           { user has AVATAR }
    pause,            { pause }
    novice,           { user is at novice help level }
    ansi,             { user has ANSI }
    color,            { user has color }
    alert,            { alert SysOp when user logs on }
    smw,              { short-message waiting for user }
    nomail,           { user mail-box is closed }
    fnodlratio,       { 1 - No UL/DL ratio }
    fnopostratio,     { 2 - No post/call ratio }
    fnofilepts,       { 3 - No file points checking }
    fnodeletion       { 4 - Protection from deletion }
  );

  anontyp =           { msg base anonymous types }
  (
    atno,             { No anonymous posts allowed }
    atyes,            { Anonymous posts are allowed }
    atforced,         { ALL posts are forced anonymous }
    atdearabby,       { "Dear Abby" message base }
    atanyname         { User's can post as ANY name they want }
  );

  basetyp =           { msg base types }
  (
    mlocal,           { local messages }
    mnetmail,         { NetMail messages }
    mechomail,        { EchoMail messages }
    mgroupmail        { GroupMail messages }
  );

  posttyp =           { msg base message types }
  (
    mpublic,          { public messages only }
    mprivate          { private messages only }
  );

(*---------------------------------------------------------------------------*)

  msgindexstatr=      { *.MIX status flags }
  (
    deleted,          { is message deleted? }
    unvalidated,      { is message unvalidated? }
    permanent         { is message permanent? }
  );

  fidoattrib=         { *.MIX Fido message attributes }
  (
    private,          { private }
    crash,            { crash mail }
    received,         { received }
    sent,             { sent }
    fattach,          { file attached }
    intransit,        { in-transit }
    orphan,           { orphaned }
    kill,             { kill after sending }
    local,            { local message }
    hold,             { hold for pickup }
    unused,           { **UNUSED** }
    freq,             { file request }
    rreq,             { return receipt request }
    receipt,          { return receipt message }
    areq,             { audit request }
    fureq             { file update request }
  );

  fidoxattrib=        { *.MIX Fido message attributes (extended) }
  (
    direct,           { direct to recipient }
    immediate,        { immediate delivery }
    delsent           { delete when sent }
  );

  msgindexrec=        { *.MIX : Message index records }
  record
    hdrptr:longint;                   { message header pointer }
    isreplyto:integer;                { reply-to message number (-1=none) }
    isreplytoid:cpackdatetime;        { packed date/time of replied message }
    numreplies:integer;               { number of replies to THIS message }
    msgdate:cpackdatetime;            { message date/time (packed) }
    msgdowk:byte;                     { message day of week (0=Sun..6=Sat) }
    attrib:set of fidoattrib;         { Fido msg attributes (see above) }
    xattrib:set of fidoxattrib;       { extended Fido attribs (see above) }
    flags:set of msgindexstatr;       { status flags (see above) }
  end;

  fromtoinfo=         { *.BRD from/to information }
  record
    anon:byte;              { anonymous type (0=no, 1/2=yes, 3="Abby", }
                            {   4="Problemed Person", 5=any name }
    usernum:word;           { user number (0=none) }
    zone:word;              { zone (0=none) }
    net:word;               { net (0=none) }
    node:word;              { node (0=none) }
    point:word;             { point (0=none) }
    name:string[36];        { user name (all caps) if anon=3..5, }
                            { otherwise null ('')                }
    real:string[36];        { user real name (all caps) }
    alias:string[36];       { user alias (all caps) }
  end;

  mheaderrec=         { *.BRD : Message header records }
  record
    msgptr:longint;             { pointer to message text }
    msglength:word;             { length of message text }
    cost:word;                  { cost to send message (NetMail only) }
    fromi:fromtoinfo;           { from user information }
    toi:fromtoinfo;             { to user information }
    title:string[71];           { title of message }
    datetime:string[19];        { Net/Echo/Group original msg date }
  end;

(*---------------------------------------------------------------------------*)

  filstat=            { *.DIR status flags }
  (
    notval,                       { if file is not validated }
    isrequest,                    { if file is offline }
    resumelater                   { if file is resume-later }
  );

  ulfrec=             { *.DIR : File records }
  record
    filename:string[12];          { filename }
    description:string[60];       { file description }
    filepoints:integer;           { file points }
    nacc:integer;                 { number DLs }
    res1:byte;                    { RESERVED }
    blocks:integer;               { # 128 byte blks }
    owner:integer;                { ULer of file }
    stowner:string[36];           { ULer's name }
    date:string[8];               { date ULed }
    daten:integer;                { numeric date ULed       }
                                  { (# days since 01/01/85) }
    vpointer:longint;             { pointer to verbose descr (-1=none) }
    filestat:set of filstat;      { file status }
    res2:array[1..10] of byte;    { RESERVED }
  end;

(*---------------------------------------------------------------------------*)

  mnuflags=           { *.MNU status flags }
  (
    clrscrbefore,                 { C: clear screen before menu display }
    dontcenter,                   { D: don't center the menu titles! }
    nomenuprompt,                 { N: no menu prompt whatsoever? }
    forcepause,                   { P: force a pause before menu display? }
    autotime                      { T: is time displayed automatically? }
  );

  menurec=            { *.MNU : Menu records }
  record
    menuname:array[1..3] of string[100]; { menu name }
    directive:string[12];                { help file displayed }
    tutorial:string[12];                 { tutorial help file }
    menuprompt:string[120];              { menu prompt }
    acs:acstring;                        { access requirements }
    password:string[15];                 { password required }
    fallback:string[8];                  { fallback menu }
    forcehelplevel:byte;                 { forced help level for menu }
    gencols:byte;                        { generic menus: # of columns }
    gcol:array[1..3] of byte;            { generic menus: colors }
    menuflags:set of mnuflags;           { menu status variables }
  end;

  cmdflags=           { *.MNU command status flags }
  (
    hidden,                       { H: is command ALWAYS hidden? }
    unhidden                      { U: is command ALWAYS visible? }
  );

  commandrec=         { *.MNU : Command records }
  record
    ldesc:string[70];               { long command description }
    sdesc:string[35];               { short command description }
    ckeys:string[14];               { command-execution keys }
    acs:acstring;                   { access requirements }
    cmdkeys:string[2];              { command keys: type of command }
    mstring:string[50];             { MString: command data }
    commandflags:set of cmdflags;   { command status variables }
  end;

(*---------------------------------------------------------------------------*)

  zlogrec=            { ZLOG.DAT : System log }
  record
    date:string[8];                   { entry date }
    userbaud:array[0..4] of integer;  { new user logon BPS rates   }
                                      { (300,1200,2400,4800,9600+) }
    active:integer;                   { % activity }
    calls:integer;                    { # of calls }
    newusers:integer;                 { # of new users }
    pubpost:integer;                  { # of public posts }
    privpost:integer;                 { # of private posts }
    netpost:integer;                  { # of NetMail posts }
    criterr:integer;                  { # of critical errors }
    uploads:integer;                  { # of uploads }
    downloads:integer;                { # of downloads }
    uk:longint;                       { amount ULed in K }
    dk:longint;                       { amount DLed in K }
  end;

(*---------------------------------------------------------------------------*)

  mbflags=            { BOARDS.DAT status flags }
  (
    mbrealname,                   { real names are forced }
    mbvisible,                    { visible to users w/o access }
    mbfilter,                     { filter ANSI/8-bit ASCII }
    mbstrip,                      { strip center/title codes }
    mbaddtear,                    { add tear/origin lines }
    mbtopstar,                    { Top Star base (GroupMail only) }
    mbimmune,                     { immune to "twitting" }
    mbinternet                    { special Internet (UUCP) handling }
  );

  boardrec=           { BOARDS.DAT : Message base records }
  record
    name:string[40];              { message base description }
    filename:string[8];           { BRD/MIX data filename }
    msgpath:string[40];           { messages pathname }
    password:string[20];          { base password }
    acs:acstring;                 { access requirement }
    postacs:acstring;             { post access requirement }
    maxmsgs:word;                 { max message count }
    anonymous:anontyp;            { anonymous type }
    mbstat:set of mbflags;        { message base status vars }
    mbtype:basetyp;               { message base type }
    mbpost:posttyp;               { message base posting type }
    origin:string[50];            { origin line }
    kludge_color:byte;            { color of kludge line }
    quote_color:byte;             { color of quoted line }
    tear_color:byte;              { color of tear line }
    origin_color:byte;            { color of origin line }
    zone:word;                    { network address }
    net:word;                     { (zone:net/node.point) }
    node:word;
    point:word;
  end;

(*---------------------------------------------------------------------------*)

  confrec=            { CONFRENC.DAT : Conference data }
  record
    conference:array['@'..'Z'] of
    record
      acs:acstring;       { access requirement }
      name:string[40];    { name of conference }
    end;
  end;

(*---------------------------------------------------------------------------*)

  eventrec=           { EVENTS.DAT : Scheduled event records }
  record
    active:boolean;               { whether active }
    description:string[30];       { event description (for logs) }
    etype:char;                   { A:CS, C:hat, D:os call, E:xternal }
    execdata:string[20];          { errorlevel if "E", commandline if "D" }
    busytime:integer;             { off-hook time before; 0 if none }
    exectime:integer;             { time of execution }
    busyduring:boolean;           { busy phone DURING event? }
    duration:integer;             { length of time event takes }
    execdays:byte;                { bitwise execution days,    }
                                  { or day of month if monthly }
    monthly:boolean;              { monthly event? }
  end;

(*---------------------------------------------------------------------------*)

  tbflags=            { GFILES.DAT status flags }
  (
    tbunhidden,                   { whether *VISIBLE* to users w/o access }
    tbreserved1,                  { RESERVED FLAG #1 }
    tbreserved2                   { RESERVED FLAG #2 }
  );

  tfilerec=           { GFILES.DAT : Text-file records }
  record
    title:string[40];             { title }
    filen:string[12];             { filename }
    gdate:string[8];              { date of Tfile / Tfile base }
    gdaten:integer;               { numeric date for fast calculation }
    acs:acstring;                 { access requirement }
    ulacs:acstring;               { upload to base access requirement }
    tbstat:set of tbflags;        { text-file base status vars }
    res:array[1..10] of byte;     { RESERVED }
  end;

(*---------------------------------------------------------------------------*)

  lcallers=           { LASTON.DAT : Last few callers records }
  record
    callernum:longint;            { system caller number }
    name:string[36];              { user name of caller }
    number:integer;               { user number of caller }
    citystate:string[30];         { city/state of caller }
  end;

(*---------------------------------------------------------------------------*)

  macrorec=           { MACROS.LST : Keyboard macro records }
  record
    macro:array[1..4] of string[240];
  end;

(*---------------------------------------------------------------------------*)

  modemflags=         { MODEM.DAT status flags }
  (
    lockedport,       { COM port locked at constant rate }
    xonxoff,          { XON/XOFF (software) flow control }
    ctsrts            { CTS/RTS (hardware) flow control }
  );

  modemrec=           { MODEM.DAT : Modem configuration }
  record
    waitbaud:word;                { wait bps }
    comport:byte;                 { COM port number }
    init:string[80];              { initialization string }
    answer:string[40];            { answer string }
    hangup:string[40];            { hangup string }
    offhook:string[40];           { phone off-hook string }
    nocallinittime:integer;       { reinit modem after x mins of inactivity }
    lockedportbaud:word;          { bps rate to use when COM port locked }
    flags:set of modemflags;      { status flags (see above) }
    nocarrier:byte;               { NO CARRIER result code }
    resultcode:array[1..2,0..7]   { CONNECT result codes:                    }
                 of byte;         { 300,1200,2400,4800,7200,9600,12000,14400 }
  end;

(*---------------------------------------------------------------------------*)

  smalrec=            { NAMES.LST : Sorted names listing }
  record
    name:string[36];                  { user name }
    number:integer;                   { user number }
  end;

(*---------------------------------------------------------------------------*)

  netflags=           { NETWORK.DAT status flags }
  (
    nstrip,           { strip message codes? }
    naddtear,         { add tear/origin lines to Net/Group? }
    nholduser,        { hold all non-SysOp NetMail? }
    nhold,            { default NetMail to "hold"? }
    ncrash,           { default NetMail to "crash"? }
    nkill             { default NetMail to "kill/sent"? }
  );

  networkrec=         { NETWORK.DAT : Network information }
  record
    zone:word;                { network address       }
    net:word;                 { (zone:net/node.point) }
    node:word;
    point:word;
    origin:string[50];        { origin line }
    kludge_color:byte;        { color of kludge line }
    quote_color:byte;         { color of quoted text }
    tear_color:byte;          { color of tear line }
    origin_color:byte;        { color of origin line }
    flags:set of netflags;    { status flags }
    netpath:string[40];       { NetMail path }
    echopath:string[40];      { EchoMail path }
    grouppath:string[40];     { GroupMail path }
    nodepath:string[40];      { nodelist path }
  end;

(*---------------------------------------------------------------------------*)

  nodeflags=          { NODELIST.DAT status flags }
  (
    hub,      { node is a net hub }
    host,     { node is a net host }
    region,   { node is region coord }
    zone,     { node is a zone coord }
    cm,       { runs continuous mail }
    ores1,    { reserved for Opus }
    ores2,    { reserved for Opus }
    ores3,    { reserved for Opus }
    ores4,    { reserved for Opus }
    ores5,    { reserved for Opus }
    nores1,   { reserved for non-Opus }
    nores2,   { reserved for non-Opus }
    nores3,   { reserved for non-Opus }
    nores4,   { reserved for non-Opus }
    nores5,   { reserved for non-Opus }
    nores6    { reserved for non-Opus }
  );

  modemtypes=         { NODELIST.DAT modem type flags }
  (
    hst,      { node uses a USRobotics HST modem }
    pep,      { node uses a Telebit PEP modem }
    v32,      { node uses a V.32 modem }
    v32b,     { node uses a V.32bis modem }
    h96       { node uses a Hayes Express96 modem }
  );

  nodedatarec=        { NODELIST.DAT : Version 6 nodelist data }
  record
    net:integer;                    { net number }
    node:integer;                   { node number }
    cost:integer;                   { cost per minute to call }
    name:array[0..33] of byte;      { node name }
    phone:array[0..39] of byte;     { phone number }
    city:array[0..29] of byte;      { city and state }
    password:array[0..7] of byte;   { password }
    realcost:integer;               { phone company's charge }
    hubnode:integer;                { node # of this node's hub (0=none) }
    rate:byte;                      { actual bps rate divided by 300 }
    modem:set of modemtypes;        { modem type codes }
    flags:set of nodeflags;         { set of flags }
    res:array[1..2] of byte;        { RESERVED }
  end;

  nodeindexrec=       { NODELIST.IDX : Version 6 nodelist index }
  record
    node:integer;       { node number }
    net:integer;        { net number }
  end;

(*---------------------------------------------------------------------------*)

  xbflags=            { PROTOCOL.DAT status flags }
  (
    xbactive,                       { is protocol active? }
    xbisbatch,                      { is batch definition? }
    xbisresume,                     { is resume definition? }
    xbxferokcode                    { does result code = xfer OK? }
  );

  protrec=            { PROTOCOL.DAT : File transfer protocols }
  record
    xbstat:set of xbflags;              { protocol flags }
    ckeys:string[14];                   { command keys }
    descr:string[40];                   { description }
    acs:acstring;                       { access string }
    templog:string[25];                 { temp. log file }
    uloadlog:string[25];                { permanent log files }
    dloadlog:string[25];
    ulcmd:string[78];                   { UL/DL command lines }
    dlcmd:string[78];
    ulcode:array [1..6] of string[6];   { UL/DL codes }
    dlcode:array [1..6] of string[6];
    envcmd:string[60];                  { environment setup cmd (B) }
    dlflist:string[25];                 { DL file lists (B) }
    maxchrs:integer;                    { max chrs in cmdline }
    logpf:integer;                      { pos in log file for data (B) }
    logps:integer;
    res:array[1..15] of byte;           { RESERVED }
  end;

(*---------------------------------------------------------------------------*)

  smr=                { SHORTMSG.DAT : One-line messages }
  record
    msg:string[160];    { message }
    destin:integer;     { destination user # (-1=deleted) }
  end;

(*---------------------------------------------------------------------------*)

  filearcinforec=     { STATUS.DAT archive configuration records }
  record
    active:boolean;               { whether this archive format is active }
    ext:string[3];                { 3-char file extension }
    listline:string[25];          { view archive cmdline ('' for internal) }
    arcline:string[25];           { compression cmdline }
    unarcline:string[25];         { de-compression cmdline }
    testline:string[25];          { integrity test cmdline ('' for *None*) }
    cmtline:string[25];           { comment cmdline ('' for *None*) }
    succlevel:integer;            { success ERRORLEVEL (-1=ignore results) }
  end;

  systatrec=          { STATUS.DAT : System configuration }
  record
    gfilepath:string[79];             { GFILES path (data files) }
    afilepath:string[79];             { AFILES path (text files) }
    menupath:string[79];              { MENUS path (system menu files) }
    trappath:string[79];              { LOGS path (trap/chat/log files) }
    msgpath:string[79];               { MSGS path (msg base data files) }
    tfilepath:string[79];             { TFILES path (Tfiles base files) }
    temppath:string[79];              { TEMP path (temporary files) }

    bbsname:string[80];               { BBS name }
    bbsphone:string[12];              { BBS phone number }
    sysopname:string[30];             { SysOp's full name or alias }
    maxusers:integer;                 { max number of users system can have }
    lowtime:integer;                  { SysOp begin minute (in minutes) }
    hitime:integer;                   { SysOp end time }
    dllowtime:integer;                { normal downloading hours }
    dlhitime:integer;
    shuttlelog:boolean;               { is Shuttle Logon active? }
    lock300:boolean;                  { lock out 300 baud? }
    sysoppw:string[20];               { SysOp PW }
    newuserpw:string[20];             { newuser PW (or NULL if none) }
    shuttlepw:string[20];             { Shuttle PW (if Shuttle active) }
    b300lowtime:integer;              { 300 baud calling hours }
    b300hitime:integer;
    b300dllowtime:integer;            { 300 baud DL hours }
    b300dlhitime:integer;
    closedsystem:boolean;             { DON'T allow new users? }
    swapshell:boolean;                { is swap shell function enabled? }
    eventwarningtime:integer;         { time before event warning }
    tfiledate:string[8];              { last date text-files were inserted }
    swapshelltype:byte;               { swap shell type (0=disk,1=EMS) }

    res1:array[1..23] of byte;        { RESERVED SPACE #1 }

    sop:acstring;                     { SysOp }
    csop:acstring;                    { Co-SysOp }
    msop:acstring;                    { Message SysOp }
    fsop:acstring;                    { File SysOp }
    spw:acstring;                     { SysOp PW at logon }
    seepw:acstring;                   { see SysOp PWs remotely  }
    normpubpost:acstring;             { post public messages }
    normprivpost:acstring;            { post private messages }
    anonpubread:acstring;             { see who posted public anon }
    anonprivread:acstring;            { see who posted private anon }
    anonpubpost:acstring;             { post anon public messages }
    anonprivpost:acstring;            { post anon private messages }
    seeunval:acstring;                { see unvalidated files }
    dlunval:acstring;                 { DL unvalidated files }
    nodlratio:acstring;               { no UL/DL ratio }
    nopostratio:acstring;             { no post/call ratio }
    nofilepts:acstring;               { no file points checking }
    ulvalreq:acstring;                { uploads require validation by SysOp }
    normnetpost:acstring;             { post NetMail messages }

    fsecmd:string[40];                { full screen editor command }

    res2:array[1..38] of byte;        { RESERVED SPACE #2 }

    maxprivpost:byte;                 { max private posts per call }
    maxnetpost:byte;                  { max NetMail posts per call }
    maxpubpost:byte;                  { max public posts per call }
    maxchat:byte;                     { max chat-pages per call }

    res3:array[1..4] of byte;         { RESERVED SPACE #3 }

    maxlogontries:byte;               { tries allowed for PW's at logon }
    bsdelay:byte;                     { backspacing delay }
    sysopcolor:byte;                  { SysOp color in chat mode }
    usercolor:byte;                   { user color in chat mode }
    minspaceforpost:integer;          { minimum K drive space left to post }
    minspaceforupload:integer;        { minimum K drive space left to upload }
    backsysoplogs:byte;               { days to keep SYSOP##.LOG }
    wfcblanktime:byte;                { minutes after which to blank WFC menu }
    linelen:byte;                     { default video line length }
    pagelen:byte;                     { default video page length }

    res4:array[1..18] of byte;        { RESERVED SPACE #4 }

    specialfx:boolean;                { WFC menu "special effects" }
    logonlogoff:boolean;              { enable LOGON.BAT & LOGOFF.BAT? }
    allowalias:boolean;               { allow alias's? (handles) }
    phonepw:boolean;                  { use phone number password in logon? }
    localsec:boolean;                 { is local security ON? }
    localscreensec:boolean;           { is local screen-security ON? }
    globaltrap:boolean;               { trap ALL USER'S activity? }
    autochatopen:boolean;             { does chat buffer auto-open? }
    autominlogon:boolean;             { Auto-Message in logon? }
    bullinlogon:boolean;              { bulletins in logon? }
    lcallinlogon:boolean;             { "Last Few Callers" list in logon? }
    yourinfoinlogon:boolean;          { "Your Info" in logon? }
    multitask:boolean;                { is BBS multitasking? }
    offhooklocallogon:boolean;        { take phone off-hook for local logons? }
    forcevoting:boolean;              { is manditory logon voting active? }
    compressbases:boolean;            { "compress" file/message base numbers? }
    searchdup:boolean;                { search for dup. filenames when UL? }
    slogtype:byte;                    { SysOp log type: File/Printer/Both }
    stripclog:boolean;                { strip colors from SysOp log output? }
    newapp:integer;                   { user# to send new user application to }
    guestuser:integer;                { user# of guest user account }
    timeoutbell:integer;              { minutes before time-out bell }
    timeout:integer;                  { minutes before timeout (logoff) }
    usewfclogo:boolean;               { whether to use WFC menu logo }
    useems:boolean;                   { attempt to use EMS for overlay }
    usebios:boolean;                  { use ROM BIOS for local video output }
    cgasnow:boolean;                  { suppress snow on CGA systems }

    res5:array[1..16] of byte;        { RESERVED SPACE #5 }

    filearcinfo:array[1..maxarcs]
                of filearcinforec;    { archive specs }
    filearccomment:array[1..3]
                   of string[80];     { BBS comments for archives }

    uldlratio:boolean;                { are UL/DL ratios active? }
    fileptratio:boolean;              { is auto file-pt compensation active? }
    fileptcomp:byte;                  { file point compensation ratio }
    fileptcompbasesize:byte;          { file point "base compensation size" }
    ulrefund:byte;                    { percent time refund for ULs }
    tosysopdir:byte;                  { "To SysOp" file base }
    validateallfiles:boolean;         { validate ALL FILES automatically? }
    remdevice:string[10];             { remote output device (GATEx,COMx,etc) }
    maxintemp:integer;                { max K allowed in TEMP\3\ }
    minresume:integer;                { min K to allow resume-later }
    maxdbatch:byte;                   { max files in DL batch queue }
    maxubatch:byte;                   { max files in UL batch queue }
    unlistfp:byte;                    { # of file points for unlisted DLs }

    res6:array[1..21] of byte;        { RESERVED SPACE #6 }

    newcredit:longint;                { newuser NetMail credit }
    autocredit:longint;               { auto-validation NetMail credit }
    newsl:byte;                       { newuser SL }
    newdsl:byte;                      { newuser DSL }
    newar:set of acrq;                { newuser AR }
    newac:set of uflags;              { newuser AC }
    newfp:integer;                    { newuser file points }
    autosl:byte;                      { auto-validation SL }
    autodsl:byte;                     { auto-validation DSL }
    autoar:set of acrq;               { auto-validation AR }
    autoac:set of uflags;             { auto-validation AC }

    allstartmenu:string[8];           { logon menu to start ALL users on }

    res7:array[1..22] of byte;        { RESERVED SPACE #7 }

    batchfileext:string[3];           { batch filename extension }
    bulletprefix:string[8];           { default bulletins filename prefix }

    res8:array[1..15] of byte;        { RESERVED SPACE #8 }

    timeallow:secrange;               { time allowance }
    callallow:secrange;               { call allowance }
    dlratio:secrange;                 { # ULs/# DLs ratios }
    dlkratio:secrange;                { DLk/ULk ratios }
    postratio:secrange;               { post/call ratios }

    lastdate:string[8];               { last system date }
    curwindow:byte;                   { type of SysOp window currently in use }
    istopwindow:boolean;              { is SysOp window on top of screen? }
    callernum:longint;                { total number of callers }
    numusers:integer;                 { number of users }
    todayzlog:zlogrec;                { TODAY's ZLOG record }
    postcredits:integer;              { file points/upload credit }
                                      { compensation for posts    }
    rebootforevent:boolean;           { reboot before events? }
    watchdogdoor:boolean;             { WatchDog active in doors? }
    windowon:boolean;                 { is SysOp window on? }
    swappath:string[79];              { swap shell path }
    arcpath:string[40];               { archive utility path }
    protpath:string[40];              { protocol driver path }

    res9:array[1..35] of byte;        { RESERVED SPACE #9 }

    versionid:word;                   { version (eg $0270 = v2.7) }
  end;

(*---------------------------------------------------------------------------*)

  fstringrec=         { STRING.DAT : User-definable strings }
  record
    ansiq:string[80];                 { "Do you want ANSI? " string }
    note:array[1..2] of string[80];   { Logon notes (L #1-2) }
    lprompt:string[80];               { Logon prompt (L #3) }
    echoc:char;                       { Echo char for PWs }
    sysopin:string[80];               { "SysOp In" (inside SysOp hours)}
    sysopout:string[80];              { "SysOp Out" }
    engage:string[80];                { "Engage Chat" }
    endchat:string[80];               { "End Chat" }
    wait:string[80];                  { "SysOp Working" }
    pause:string[80];                 { "Pause" }
    entermsg1:string[80];             { "Enter Message" line #1 }
    entermsg2:string[80];             { "Enter Message" line #2 }
    newscan1:string[80];              { "NewScan begin" }
    newscan2:string[80];              { "NewScan done" }
    scanmessage:string[80];           { Message scanning prompt }
    automsgt:string[80];              { Auto-Message title }
    autom:char;                       { Auto-Message border characters }

    shelldos1:string[80];             { " >> SysOp shelling to DOS ..." }
    shelldos2:string[80];             { " ... thank you for waiting." }
    chatcall1:string[80];             { "Paging SysOp, please wait..." }
    chatcall2:string[80];             { ">>><*><<<" }
    guestline:string[80];             { "To be a guest ... " }
    namenotfound:string[80];          { "Name NOT found in user list." }
    bulletinline:string[80];          { Bulletin line }
    thanxvote:string[80];             { "Thanks for voting" }

    listline:string[80];              { "List files - P to pause" }
    newline:string[80];               { "Search for new files -" }
    searchline:string[80];            { "Search all dirs for file mask" }
    findline1:string[80];             { "Search for descriptions... " }
    findline2:string[80];             { "Enter the string to search for.." }
    downloadline:string[80];          { "Download - " }
    uploadline:string[80];            { "Upload - " }
    viewline:string[80];              { "View interior files - " }
    nofilepts:string[80];             { "Insufficient file points." }
    unbalance:string[80];             { "Your UL/DL ratio is unbalanced" }

    pninfo:string[80];                { "P to Pause, N for next dir" }
    gfnline1:string[80];              { "[Enter]=All files" }
    gfnline2:string[80];              { "File mask: " }
    batchadd:string[80];              { "File added to batch queue." }

    quotestr1:string[50];             { message quote header #1 }
    quotestr2:string[50];             { message quote header #2 }

    mtaskline:string[80];             { "System Under Multi-Tasking..." }
  end;

(*---------------------------------------------------------------------------*)

  fbflags=            { UPLOADS.DAT status flags }
  (
    fbnoratio,                    { if <No Ratio> active }
    fbunhidden,                   { whether *VISIBLE* to users w/o access }
    fbdirdlpath,                  { if *.DIR file stored in DLPATH }
    fbreserved1,                  { RESERVED FLAG #1 }
    fbusegifspecs,                { whether to use GifSpecs }
    fbreserved2                   { RESERVED FLAG #2 }
  );

  ulrec=              { UPLOADS.DAT : File base records }
  record
    name:string[40];              { area description }
    filename:string[12];          { filename + ".DIR" }
    dlpath:string[40];            { download path }
    ulpath:string[40];            { upload path }
    maxfiles:integer;             { max files allowed (1-2000) }
    password:string[20];          { password required }
    arctype:byte;                 { wanted archive type (1..max,0=inactive) }
    cmttype:byte;                 { wanted comment type (1..3,0=inactive) }
    res1:array[1..2] of byte;     { RESERVED SPACE #1 }
    fbstat:set of fbflags;        { file base status vars }
    acs:acstring;                 { access requirements }
    ulacs:acstring;               { upload requirements }
    nameacs:acstring;             { see-names requirements }
    res2:array[1..10] of byte;    { RESERVED SPACE #2 }
  end;

(*---------------------------------------------------------------------------*)

  userflags=          { USER.LST status flags }
  (
    lockedout,          { if locked out }
    udeleted,           { if deleted }
    trapactivity,       { if trapping users activity }
    trapseperate,       { if trap to seperate TRAP file }
    chatauto,           { if auto chat trapping }
    chatseperate,       { if seperate chat file to trap to }
    slogseperate,       { if seperate SysOp log }
    clsmsg,             { if clear-screen before message }
    avadjust            { if AVATAR color adjust }
  );

  userrec=            { USER.LST : User account records }
  record

    { configuration information }

    name:string[36];                  { user name }
    realname:string[36];              { real name }
    street:string[30];                { mailing address }
    citystate:string[30];             { city, state }
    zipcode:string[10];               { zipcode }
    ph:string[12];                    { user phone # }
    bday:string[8];                   { user birthdate }
    sex:char;                         { user sex }

    pw:string[20];                    { user password }
    firston:string[8];                { firston date }
    laston:string[8];                 { laston date }

    computer:string[30];              { type of computer }
    occupation:string[40];            { occupation }
    wherebbs:string[40];              { BBS reference }
    note:string[39];                  { SysOp note }

    lockedfile:string[8];             { lockout msg to print }
    cols:clrs;                        { user colors }
    linelen:byte;                     { line length (# cols) }
    pagelen:byte;                     { page length (# rows) }
    mpointer:longint;                 { pointer to entry in MACRO.LST }
    userstartmenu:string[8];          { menu to start user out on }

    flags:set of userflags;           { flags (see above) }

    { system access information }

    sl:byte;                          { SL }
    dsl:byte;                         { DSL }
    ac:set of uflags;                 { user flags }
    ar:set of acrq;                   { AR flags }

    { message system information }

    lastmsg:byte;                     { last message base # }
    pubpost:integer;                  { # public posts }
    privpost:integer;                 { # private posts }
    netpost:integer;                  { # NetMail posts }
    forusr:integer;                   { forward mail to user # }
    credit:longint;                   { NetMail points (credit) }
    debit:longint;                    { NetMail points (debit) }
    mhiread:mhireadr;                 { NewScan high message pointers }
    mzscan:mzscanr;                   { NewScan message bases }
    boardsysop:array[1..5] of byte;   { msg board SysOp }

    { file system information }

    lastfil:byte;                     { last file base # }
    uploads:integer;                  { # of ULs }
    downloads:integer;                { # of DLs }
    uk:longint;                       { amount ULed (kilobytes) }
    dk:longint;                       { amount DLed (kilobytes) }
    filepoints:integer;               { # of file points }
    flistopt:byte;                    { type of file list type to use }
    fzscan:fzscanr;                   { NewScan file bases }

    { system usage information }

    ttimeon:longint;                  { total mins spent on }
    loggedon:integer;                 { # times logged on }
    tltoday:integer;                  { # min left today }
    ontoday:byte;                     { # times on today }
    illegal:byte;                     { # illegal logon attempts }

    { miscellaneous information }

    vote:array[1..20] of byte;        { voting data }
    timebank:integer;                 { # mins in Time Bank }
    timebankadd:integer;              { time added to timebank TODAY }
  end;

(*---------------------------------------------------------------------------*)

  verbrec=            { VERBOSE.DAT : Verbose descriptions }
  record
    descr:array[1..4] of string[50];
  end;

(*---------------------------------------------------------------------------*)

  vdatar=             { VOTING.DAT : Voting records }
  record
    question:string[79];          { voting question }
    numa:integer;                 { number of user's who have answered }
    answ:array[0..numvoteas] of
    record
      ans:string[40];             { answer description }
      numres:integer;             { # user's who picked this answer }
    end;
  end;

