Unit StatusBar;
{$I Sys75.Inc}

Interface

Uses
  TotFast;

Procedure ShowStatus;

Const
  StatBar: Byte = 1;
  NewStatBar: Boolean = True;
  MaxStatBar = 6;
  SpecialBar: Boolean = False;
  ForceStatBar: Boolean = False;
  SnapShotOff: Byte = 1;

Var
  SnapShot: Array [1..160] of Byte;
  StatScrPtr: pScreenObj;

Implementation

Uses
  Spuds,
  ApPort, OoCom,
  TotStr, TotSys, TotMisc, TotDate,
  Misc, Users, Comm, RemEmu, Emu, Fonts, Clocks, Chats, filespon, msgspon;

Var
  OldRts, OldDtr: Boolean;
  SaveMem: LongInt;

Procedure ShowStatus;

  function h (b: Boolean; s: String): string;
  begin
    if b then
      h := '~' + s + '~  '
    else
      h := s + '  ';
  end;

Var
  Old: Word;
  S: String;
  Snap2: Array [1..160] of Byte;
  Dtr, Rts: Boolean;
Begin
  If Current <> Board Then Exit;
  With StatScrPtr^ do Case StatBar of
    0:
       Begin
         If NewStatBar Then Begin
           Clock^. Show (False);

           If SpecialBar Then
             Move (Mem [Seg (ScreenPtr^):Ofs (Screen^. ScreenPtr^) + 4160], Snap2, 160);

           PartClear (1, currentmode, 80, currentmode, 7, ' ');

           If SpecialBar Then Begin
             If SnapShotOff = pred (currentmode) Then SnapShotOff := currentmode;
             Move (Mem [Seg (ScreenPtr^):Ofs (Screen^. ScreenPtr^) + Pred (SnapShotOff) * 160], SnapShot, 160);
             Move (Snap2, Mem [Seg (ScreenPtr^):Ofs (Screen^. ScreenPtr^) + Pred (SnapShotOff) * 160], 160);
           End;

           GetXY (Old);
           SetScreenSize (1, 1, 80, currentmode);
           UpdateCursor (Hi (Old), Lo (Old));
         End;
       End;
    1:
       Begin
        If NewStatBar Then Begin
           If SpecialBar And (SnapShotOff = currentmode) Then Begin
             Move (Mem [Seg (ScreenPtr^):Ofs (Screen^. ScreenPtr^) + Pred (SnapShotOff) * 160], Snap2, 160);
             Move (SnapShot, Mem [Seg (ScreenPtr^):Ofs (Screen^. ScreenPtr^) + Pred (SnapShotOff) * 160], 160);
             SnapShotOff := pred (currentmode);
             Move (Mem [Seg (ScreenPtr^):Ofs (Screen^. ScreenPtr^) + Pred (SnapShotOff) * 160], SnapShot, 160);
             Move (Snap2, Mem [Seg (ScreenPtr^):Ofs (Screen^. ScreenPtr^) + Pred (SnapShotOff) * 160], 160);
           End;

           PartClear (1, currentmode, 80, currentmode, $1F, ' ');
           GetXY (Old);
           SetScreenSize (1, 1, 80, pred (currentmode));
           UpdateCursor (Hi (Old), Lo (Old));
           Clock^. Change (72, currentmode, $1F);
           Clock^. Show (True);
         End;

         With User do
           S := Handle + '~  TO:~' + IntToStr (CurTimeOn) + '~  TL:~' + IntToStr (timeleft) + '~  SL:~' + IntToStr (sl) +
                + '~  DSL:~' + IntToStr (dsl);
         WriteHi (2, currentmode, $17, $1F, PadLeft (S, 70, ' '));

         If SysPaged Then
           WriteAt (80, currentmode, 159, 'C')
         Else
           WriteAt (80, currentmode, 31, ' ')
       End;
    2:
       Begin
         If NewStatBar Then Begin
           If SpecialBar And (SnapShotOff = currentmode) Then Begin
             Move (Mem [Seg (ScreenPtr^):Ofs (Screen^. ScreenPtr^) + Pred (SnapShotOff) * 160], Snap2, 160);
             Move (SnapShot, Mem [Seg (ScreenPtr^):Ofs (Screen^. ScreenPtr^) + Pred (SnapShotOff) * 160], 160);
             SnapShotOff := pred (currentmode);
             Move (Mem [Seg (ScreenPtr^):Ofs (Screen^. ScreenPtr^) + Pred (SnapShotOff) * 160], SnapShot, 160);
             Move (Snap2, Mem [Seg (ScreenPtr^):Ofs (Screen^. ScreenPtr^) + Pred (SnapShotOff) * 160], 160);
           End;

           PartClear (1, currentmode, 80, currentmode, $1F, ' ');
           GetXY (Old);
           SetScreenSize (1, 1, 80, pred (currentmode));
           UpdateCursor (Hi (Old), Lo (Old));
           Clock^. Change (72, currentmode, $1F);
           Clock^. Show (True);
         End;

         S := h (InLock, 'InLock') + h (OutLock, 'OutLock') + h (B (vToggles, 8), 'Available') +
              h (TmpSysop, 'TempSysop') + h ((TimeLock In User. Options) Or (User. TimeLimit = 0), 'TimeLock') +
              h (TextTrap, 'TextTrap') + h (B (vToggles, 1), 'Printer');

         WriteHi (2, currentmode, $1F, $19, S);

         If SysPaged Then
           WriteAt (80, currentmode, 159, 'C')
         Else
           WriteAt (80, currentmode, 31, ' ')
       End;
    3:
       Begin
         If NewStatBar Then Begin
           If SpecialBar And (SnapShotOff = currentmode) Then Begin
             Move (Mem [Seg (ScreenPtr^):Ofs (Screen^. ScreenPtr^) + Pred (SnapShotOff) * 160], Snap2, 160);
             Move (SnapShot, Mem [Seg (ScreenPtr^):Ofs (Screen^. ScreenPtr^) + Pred (SnapShotOff) * 160], 160);
             SnapShotOff := pred (currentmode);
             Move (Mem [Seg (ScreenPtr^):Ofs (Screen^. ScreenPtr^) + Pred (SnapShotOff) * 160], SnapShot, 160);
             Move (Snap2, Mem [Seg (ScreenPtr^):Ofs (Screen^. ScreenPtr^) + Pred (SnapShotOff) * 160], 160);
           End;

           PartClear (1, currentmode, 80, currentmode, $1F, ' ');
           GetXY (Old);
           SetScreenSize (1, 1, 80, pred (currentmode));
           UpdateCursor (Hi (Old), Lo (Old));
           Clock^. Change (72, currentmode, $1F);
           Clock^. Show (True);
         End;

         S := h (InputTimer, 'InputTimer') + h (B (vToggles, 2), 'Custom') + h (B (vToggles, 4), 'Speaker') +
              h (tmpfspons, 'All_File_Areas') + h (tmpmspons, 'All_Message_Bases');

         WriteHi (2, currentmode, $1F, $19, S);

         If SysPaged Then
           WriteAt (80, currentmode, 159, 'C')
         Else
           WriteAt (80, currentmode, 31, ' ')
       End;
    4:
       Begin
         If NewStatBar Then Begin
           If SpecialBar And (SnapShotOff = currentmode) Then Begin
             Move (Mem [Seg (ScreenPtr^):Ofs (Screen^. ScreenPtr^) + Pred (SnapShotOff) * 160], Snap2, 160);
             Move (SnapShot, Mem [Seg (ScreenPtr^):Ofs (Screen^. ScreenPtr^) + Pred (SnapShotOff) * 160], 160);
             SnapShotOff := pred (currentmode);
             Move (Mem [Seg (ScreenPtr^):Ofs (Screen^. ScreenPtr^) + Pred (SnapShotOff) * 160], SnapShot, 160);
             Move (Snap2, Mem [Seg (ScreenPtr^):Ofs (Screen^. ScreenPtr^) + Pred (SnapShotOff) * 160], 160);
           End;

           PartClear (1, currentmode, 80, currentmode, $1F, ' ');
           GetXY (Old);
           SetScreenSize (1, 1, 80, pred (currentmode));
           UpdateCursor (Hi (Old), Lo (Old));
           Clock^. Change (72, currentmode, $1F);
           Clock^. Show (True);
         End;

         With User do
           S := '~  FP:~' + IntToStr (fp) + '~  UL:~' + IntToStr (uploads) + '~  DL:~' +
                IntToStr (downloads) + '~  FO:~' + datestr (firston) + '~  LO:~' + datestr (laston. d);

         If BaudRate = 0 Then
           S := 'Local' + S
         Else
           S := IntToStr (BaudRate) + S;

         WriteHi (2, currentmode, $1F, $19, PadLeft (S, 70, ' '));

         If SysPaged Then
           WriteAt (80, currentmode, 159, 'C')
         Else
           WriteAt (80, currentmode, 31, ' ')
       End;
    5:
       Begin
         If NewStatBar Then Begin
           If SpecialBar And (SnapShotOff = currentmode) Then Begin
             Move (Mem [Seg (ScreenPtr^):Ofs (Screen^. ScreenPtr^) + Pred (SnapShotOff) * 160], Snap2, 160);
             Move (SnapShot, Mem [Seg (ScreenPtr^):Ofs (Screen^. ScreenPtr^) + Pred (SnapShotOff) * 160], 160);
             SnapShotOff := pred (currentmode);
             Move (Mem [Seg (ScreenPtr^):Ofs (Screen^. ScreenPtr^) + Pred (SnapShotOff) * 160], SnapShot, 160);
             Move (Snap2, Mem [Seg (ScreenPtr^):Ofs (Screen^. ScreenPtr^) + Pred (SnapShotOff) * 160], 160);
           End;

           PartClear (1, currentmode, 80, currentmode, $1F, ' ');
           Clock^. Change (72, currentmode, $1F);
           Clock^. Show (True);
           GetXY (Old);
           SetScreenSize (1, 1, 80, pred (currentmode));
           UpdateCursor (Hi (Old), Lo (Old));

           WritePlain (70, currentmode, '');
           WritePlain (45, currentmode, ' maxwell rules ');

           SaveMem := Succ (MemAvail);

           if localonly then WritePlain (1, currentmode, ' this node is local only');

           if not localonly then If Succ (Random (10)) > 5 then
             WritePlain (19, currentmode, 'bearded')
           Else
             WritePlain (19, currentmode, 'shoven ');

           if not localonly then With NodeData do
             WritePlain (27, currentmode, ' ' + ComNameString (Port) + ' ' + IntToStr (Baud) +
                         ' ' + IntToStr (Data) + ParityChar [Parity] + IntToStr (Stop));

           if not localonly then Uart^. GetModem (OldRts, OldDtr);
         End;

         If SaveMem <> MemAvail Then Begin
           WritePlain (61, currentmode, ' ' + IntToStr (MemAvail));
           SaveMem := MemAvail;
         End;

         If SysPaged Then
           WriteAt (80, currentmode, 159, 'C')
         Else
           WriteAt (80, currentmode, 31, ' ');

         if localonly then begin
           newstatbar := false;
           exit;
         end;

         If NewStatBar Or Uart^. CheckDeltaDSR Then If Uart^. CheckDSR Then
           WritePlain (2, currentmode, 'DSR')
         Else
           WritePlain (2, currentmode, 'dsr');

         Uart^. GetModem (Dtr, Rts);

         If NewStatBar Or (Dtr <> OldDtr) Then Begin
           If Dtr Then
             WritePlain (5, currentmode, 'DTR')
           Else
             WritePlain (5, currentmode, 'dtr');
           OldDtr := Dtr;
         End;

         If NewStatBar Or Uart^. CheckDeltaCTS Then If Uart^. CheckCTS Then
           WritePlain (9, currentmode, 'CTS')
         Else
           WritePlain (9, currentmode, 'cts');

         If NewStatBar Or (Rts <> OldRts) Then Begin
           If Rts Then
             WritePlain (12, currentmode, 'RTS')
           Else
             WritePlain (12, currentmode, 'rts');
           OldRts := Rts;
         End;

         If NewStatBar Or Uart^. CheckDeltaDCD Then If Uart^. CheckDCD Then
           WritePlain (16, currentmode, 'CD')
         Else
           WritePlain (16, currentmode, 'cd');

         newstatbar := false;
       End;
    6:
       Begin
         If NewStatBar Then Begin
           If SpecialBar And (SnapShotOff = currentmode) Then Begin
             Move (Mem [Seg (ScreenPtr^):Ofs (Screen^. ScreenPtr^) + Pred (SnapShotOff) * 160], Snap2, 160);
             Move (SnapShot, Mem [Seg (ScreenPtr^):Ofs (Screen^. ScreenPtr^) + Pred (SnapShotOff) * 160], 160);
             SnapShotOff := pred (currentmode);
             Move (Mem [Seg (ScreenPtr^):Ofs (Screen^. ScreenPtr^) + Pred (SnapShotOff) * 160], SnapShot, 160);
             Move (Snap2, Mem [Seg (ScreenPtr^):Ofs (Screen^. ScreenPtr^) + Pred (SnapShotOff) * 160], 160);
           End;
           GetXY (Old);
           SetScreenSize (1, 1, 80, pred (currentmode));
           UpdateCursor (Hi (Old), Lo (Old));
           PartClear (1, currentmode, 80, currentmode, $1F, ' ');
           Clock^. Change (72, currentmode, $1F);
           Clock^. Show (True);
           if not syspaged then
             WriteAt (2, currentmode, $17, 'No one has paged.')
           else
             WriteHi (2, currentmode, $1F, $19, 'Paged by ' + User. Handle + ':~ ' + ChatReason);
         End;
       End;
  End;

  NewStatBar := False;
End;

End.
