Unit Protocols;
{$I Sys75.Inc}

Interface

Uses
  Dos,
  Spuds,
  ApPort,
  ooAbsPcl,
  OoCom,
  TotLink, TotFast,
  filemenu;

Type
  tBatch = Record
    pts, Files, fLeft, Bytes, bLeft: LongInt;
  End;

  SwitchToBinary =
  Object
    Port     : AbstractPortPtr;
    Parity   : ParityType;
    DataBits : DataBitType;
    StopBits : StopBitType;
    Baud     : LongInt;
    Constructor Init (AP : AbstractPortPtr);
    Destructor Done;
  End;

  pProtocol = ^tProtocol;
  tProtocol = Object
                Constructor Init;
                Procedure   InitVars;
                Procedure   ForceProto (z: byte);
                Function    GetProto: AbstractProtocolPtr;
                Procedure   GetFiles;
                procedure   clearnamelist;
                Function    AddFile (F: PathStr): Boolean;
                procedure   dispnamelist;
                function    getremfname (var fname: str12): boolean;
                Procedure   Redraw;
                Procedure   Upload;
                Procedure   Download;
                Destructor  Done;
                Private
                  SS               : ^ScreenObj;
                  SrcFile          : File;
                  SrcFilename      : String;
                  Switch           : ^SwitchToBinary;
                  Proto            : AbstractProtocolPtr;
                  ChangeBuffers    : Boolean;
                  ForcedProt       : Byte;
                  NamesList        : ^DllObj;
              End;

Var
  Proto: ^tProtocol;
  Batch: tBatch;
  leeched,
  AbortXfer        : Boolean;
  ar               : farearec;
  usingexternal    : boolean;
  ResumeXfer       : Boolean;

Const
  UseRealPaths: Boolean = False;

Implementation

Uses
  Crt,
  TotStr, TotSys, TotList, TotInput, TotKey, TotMisc, TotWin,
  ApMisc, ApTimer, ApUart,
  OoXModem, OoYModem, OoZModem, OoKermit, OoAscii, OoModem,
  joinconf, comm, rememu, Fonts, Users, ScrSave, Clocks, StatusBar, Misc, acs,
  dumbterm, hookers, emu;

Var
  TransferMode     : TransferModeType;
  Protocol         : Byte;
  Name             : String [12];
  flog             : text;
  HitEsc           : Boolean;
  lc, la           : byte;

Type
  BufPtr = ^BufferArray;
  BufferArray = Array [0..MaxInt] of Char;

Function Empty: Boolean; Far; Begin Empty := False End;

var
  pst: longint;
  mins: byte;

  Procedure LogFileActivity (AP : AbstractProtocolPtr; LogFileStatus : LogFileType); Far;
  Var
    r, actualcps: real;
    CurElapsedTics: LongInt;
    CurBytesTransferred: LongInt;
  const
    peez: string [10] = ('RRRRRRZZKA');

    procedure doit (ch: char);
    begin
      with ap^ do
        {$I-}
        writeln (flog, ch + ' ' + padright (inttostr (GetFileSize), 9, ' ') + ' ' +
                 padright (inttostr (baudrate), 6, ' ') + ' bps ' + padright (inttostr (round (actualcps)), 5, ' ') +
                 ' cps ' + padright (inttostr (GetTotalErrors), 4, ' ') + ' errors 0 ' +
                 padright (inttostr (GetBlockSize), 6, ' ') + ' ' + GetPathName + ' -1');
      {$IFDEF Debug}{$I+}{$ENDIF}
      if ioresult <> 0 then ;
    end;

  Begin
    With AP^ Do Begin
      CurElapsedTics := GetElapsedTics;
      CurBytesTransferred := GetBytesTransferred;

      If CurElapsedTics > 0 Then Begin
        R := CurBytesTransferred - GetInitialFilePos;
        if curelapsedtics <> 0 then
          ActualCPS := R / (CurElapsedTics / 18.2)
        else
          actualcps := 0.0;
      End Else
        ActualCPS := 0.0;

      Case LogFileStatus of
        lfReceiveStart: ;
        lfReceiveOk:    doit (ucase (peez [protocol]));
        lfReceiveFail:  doit ('E');
        lfReceiveSkip:  doit ('E');
        lfTransmitStart: ;
        lfTransmitOk:   doit (lcase (peez [protocol]));
        lfTransmitFail: doit ('e');
        lfTransmitSkip: if leeched then
                          doit ('q')
                        else
                          doit ('e');
      End;
    End;
  End;

  Procedure UpdateProgressBar (Row, Col, Len : Byte; Percent : Real);
  Const
    CompleteChar = 'o';
  Var
    CharPercent : Real;
    CharCount : Byte;
    BarStr : String;
  Begin
    if len = 0 then inc (len);
    if charpercent = 0 then charpercent := 1.0;

    CharPercent := 100.0 / Len;
    CharCount := Trunc ((Percent * 100) / CharPercent);

    If CharCount > Len Then
      CharCount := Len;

    FillChar (BarStr [1], CharCount, CompleteChar);
    BarStr [0] := Char (CharCount);
    If CharCount <> 0 Then
      Screen^. WriteAt (Row, Col, 15, padleft (BarStr, 72, ''));
  End;

  Procedure UpdateStatusMsg (Row, Col, Len : Byte);
  Const
    LastStatus: Word = 65535;
  Var
    Msg: String;
  Begin
    If AsyncStatus <> LastStatus Then Begin
      Msg := StatusStr (AsyncStatus);
      Screen^. WriteHi (Row, Col, 15, 8, padleft ('[~' + Msg + '~]', 70, ' '));
      laststatus := asyncstatus;
    End;
  End;

  Var
    SaveName: String;
    savbitexfer,
    TotXferBytes,
    TotXferTics,
    DiskSpace: LongInt;

  Procedure WindowStat (AP: AbstractProtocolPtr; Starting, Ending: Boolean);
  Const
    NewProgBar = '';

    Procedure Showpd;
    Var
      S: String;
      l: longint;
    Begin
      l := DiskSpace - totxferbytes;
      If l> 999999999 then
        S := IntToStr (l Div 1000000000) + ' Gigz'
      Else If DiskSpace > 999999 then
        S := IntToStr (l Div 1000000) + ' Megz'
      Else If DiskSpace > 999 then
        S := IntToStr (l Div 1000) + ' Keyz'
      Else
        S := IntToStr (l) + ' Bitz';
      Screen^. WriteAt (69, 7, 15, PadLeft (S, 9, ' '))
    End;

  Const
    TransMode: Array [TransferModeType] of String [8] = ('Transmit', 'Receive');
    nas = '[ Not Applicable ]';
  Var
    Blocks: Integer;
    Efficiency, MaxCPS, ActualCPS, R: Real;
    CurBlockSize: Word;
    CurFileSize: LongInt;
    CurBytesRemaining: LongInt;
    CurBytesTransferred: LongInt;
    CurElapsedTics: LongInt;
    I: Word;
    B: Boolean;
    S: String [6];
  Begin
    With AP^ Do Begin
      If Starting Then Begin
        Screen^. Clear (0, ' ');

        If currentmode <> 25 Then Begin
          Setmode (25, true);
          Clock^. Change (72, 25, 23);
        End;

        Screen^. CursOff;
        ShowScreen (Xfer);
        if current = terminal then
          Term^. StatusBar (True)
        else begin
          newstatbar := true;
          showstatus;
        end;

        Clock^. Show (True);
        Screen^. WriteAt (69, 2, 15, TransMode [TransferMode]);
        Screen^. WriteAt (69, 3, 15, Name);

        Case GetCheckType Of
          bcNone      : S := bcsNone;
          bcChecksum1 : S := bcsChecksum1;
          bcChecksum2 : S := bcsChecksum2;
          bcCrc16     : S := bcsCrc16;
          bcCrc32     : S := bcsCrc32;
          bcCrcK      : S := bcsCrcK;
        End;

        Screen^. WriteAt (69, 4, 15, S);
        TotXferTics := BiosTime;
        SaveName := '';
        savbitexfer := 0;
        TotXferBytes := 0;

        If TransferMode = Transmit Then begin
          Screen^. WriteAt (5, 13, 15, NewProgBar);
          Screen^. WriteAt (69, 7, 8, 'n/a');
          Screen^. WriteAt (14, 22, 15, PadLeft (IntToStr (Batch. Files), 8, ' '));
        end Else Begin
          Screen^. WriteAt (44, 3, 8, 'n/a');
          Screen^. WriteAt (44, 4, 8, 'n/a');
          Screen^. WriteAt (44, 5, 8, 'n/a');
          Screen^. WriteAt (44, 6, 8, 'n/a');
          Screen^. WriteAt (44, 7, 8, 'n/a');
          Screen^. WriteAt (44, 8, 8, 'n/a');
          Screen^. WriteBetween ( 1, 40, 17, 8, nas);
          Showpd;
        End;

        If Current <> Board Then
          Screen^. WriteBetween (40, 80, 17, 8, nas)
        else With User do Begin
          Screen^. WriteBetween (43, 77, 18, 15, ' ' + Handle + ' ');
          Screen^. WriteAt (56, 19, 15, IntToStr (FP));
          Screen^. WriteAt (56, 20, 15, IntToStr (Ratio (uploads, downloads)));
          Screen^. WriteAt (56, 21, 15, PadLeft (IntToStr (curtimeon), 4, ' '));
          Screen^. WriteAt (56, 22, 15, PadLeft (IntToStr (timeleft), 4, ' '));
        End;
      End;

      CurBlockSize := GetBlockSize;
      CurFileSize := GetFileSize;
      CurBytesRemaining := GetBytesRemaining;
      CurBytesTransferred := GetBytesTransferred;
      CurElapsedTics := GetElapsedTics;

      Screen^. WriteAt (16, 2, 15, Padleft (SetLower (GetFileName), 12, ' '));

      {Display total bytes, bytes transferred, and bytes remaining}
      Screen^. WriteAt (16, 6, 15, PadLeft (IntToStr (CurFileSize), 13, ' '));
      Screen^. WriteAt (16, 7, 15, PadLeft (IntToStr (CurBytesTransferred), 13, ' '));
      Screen^. WriteAt (16, 8, 15, PadLeft (IntToStr (CurBytesRemaining), 13, ' '));

      {Calculate and display throughput}
      If CurElapsedTics > 0 Then Begin
        R := CurBytesTransferred - GetInitialFilePos;
        if curelapsedtics <> 0 then
          ActualCPS := R / (CurElapsedTics / 18.2)
        else
          actualcps := 0.0;
      End Else
        ActualCPS := 0.0;

      Screen^. WriteAt (69, 5, 15, PadLeft (IntToStr (Round (ActualCPS)), 8, ' '));

      {Estimated time, elapsed time and time remaining}
      Screen^. WriteAt (16, 3, 15, PadLeft (FormatMinSec (EstimateTransferSecs (CurFileSize)), 13, ' '));
      Screen^. WriteAt (16, 4, 15, PadLeft (FormatMinSec (Tics2Secs (CurElapsedTics)), 13, ' '));
      Screen^. WriteAt (16, 5, 15, PadLeft (FormatMinSec (EstimateTransferSecs (CurBytesRemaining)), 13, ' '));

      If CurBytesTransferred = 0 Then Screen^. WriteAt (5, 11, 15, NewProgBar);

      If TransferMode = Receive Then Showpd;

      If TransferMode = Transmit Then Begin
        If GetFileName <> SaveName Then begin
          SaveName := GetFileName;
          savbitexfer := TotXferBytes;
          leeched := false;
        end else begin
          If Batch. Bytes <> 0 Then Begin
            R := Batch. bLeft;
            if batch. bytes <> 0 then
              R := R / Batch. Bytes
            else
              r := 0;
          End Else
            R := 1;

          UpdateProgressBar (5, 13, Length (NewProgBar), 1.0 - R);
          Screen^. WriteAt (38, 14, 15, PadRight (IntToStr (Trunc ((1.0 - R) * 100)), 3, ' '));
        end;

        if not leeched then
          leeched := CurBytesTransferred = Getfilesize;
        TotXferBytes := savbitexfer + curBytesTransferred;
        Batch. bLeft := Batch. Bytes - TotXferBytes;

        Screen^. WriteAt (44, 3, 15, PadLeft (FormatMinSec (EstimateTransferSecs (Batch. Bytes)), 12, ' '));
        Screen^. WriteAt (44, 4, 15, PadLeft (FormatMinSec (Tics2Secs (Et (TotXferTics))), 12, ' '));
        Screen^. WriteAt (44, 5, 15, PadLeft (FormatMinSec (EstimateTransferSecs (Batch. bLeft)), 12, ' '));
        Screen^. WriteAt (44, 6, 15, PadLeft (IntToStr (Batch. Bytes), 12, ' '));
        Screen^. WriteAt (44, 7, 15, PadLeft (IntToStr (Batch. Bytes - Batch. bLeft), 12, ' '));
        Screen^. WriteAt (44, 8, 15, PadLeft (IntToStr (Batch. bLeft), 12, ' '));
      End;

      {Error counts}
      Screen^. WriteAt (44, 2, 15, PadLeft (IntToStr (GetTotalErrors), 12, ' '));

      {Update the progress bar (if the file size is known}
      If CurFileSize <> 0 Then Begin
        R := CurBytesRemaining;
        R := R / CurFileSize;
      End Else
        R := 1;

      UpdateProgressBar (5, 11, Length (NewProgBar), 1.0 - R);
      Screen^. WriteAt (38, 10, 15, PadRight (IntToStr (Trunc ((1.0 - R) * 100)), 3, ' '));

      {Update status message}
      UpdateStatusMsg (11, 15, 65);

      {Calculate and display efficiency}
      if current = board then
        maxcps := baudrate div 10
      else
        MaxCPS := APort^. PR^. CurBaud Div 10;
      If MaxCPS > 0 Then
        Efficiency := (ActualCPS / MaxCPS) * 100.0
      Else
        Efficiency := 0.0;
      Screen^. WriteHi (69, 6, 8, 15, PadLeft (IntToStr (Trunc (Efficiency)) + '~%', 9, ' '));
    End;
  End;

Procedure Background (PP : AbstractProtocolPtr); Far;
Var
  B: word;
Begin
  If Not hung Then Begin
    If Not LocalOnly And Online And Not Uart^. CheckDCD Then Begin
      For B := 1 to 1000 do Begin
        Crt. Delay (1);
        If Uart^. CheckDCD Then break;
      End;
      if not uart^. checkdcd then begin
        hung := True;
        abortxfer := true;
      end;
    End;
  End;

  If Key^. KeyPressed Then begin
    vdone := true;
    scrsavproc;

    Case Key^. GetKey of
      kEsc: abortxfer := true;
      kAltD: begin
             Hung := True;
             abortxfer := true;
           end;
      kF1: if protocol = pzmodem then with ZModemProtocolPtr (pp)^ do begin
             if transfermode = transmit then
{               lastblock := true}
             else begin
               HeaderType := ZSkip;
               LogFile (pp, lfReceiveSkip);
               ZmodemState := rzRqstFile;
               AsyncStatus := ecSkipFile;
               WindowStat (PP, false, false);
             end;
           end;
      kF2: Begin
             If User. timeleft > 5 then
               dec (User. timeleft, 5)
             else
               User. timeleft := 0;
             Screen^. WriteAt (56, 22, 15, PadLeft (IntToStr (user. timeleft), 4, ' '));
           End;
      kF3: Begin
             If User. timeleft < 1440 then
               inc (User. timeleft, 5)
             else
               User. timeleft := 1440;
             Screen^. WriteAt (56, 22, 15, PadLeft (IntToStr (user. timeleft), 4, ' '));
           End;
      kAltL: For B := 1 to Succ (Random (255)) do
               Uart^. PutChar (Chr (Random (128) + 129));
      kAltA:
                  Begin
                    vToggles := vToggles Xor 8;
                    ShowStatus;
                  End;
      kAltB:
                   Begin
                     If StatBar < MaxStatBar Then
                       Inc (StatBar)
                     Else
                       StatBar := 0;

                     NewStatBar := True;
                     ShowStatus;
                   End;
      kAltC:
                  Begin
                    vToggles := vToggles Xor 2;
                    ShowStatus;
                  End;
      kAltO: Begin
                     InputTimer := Not InputTimer;
                     NoKbdPress := 0;
                     ShowStatus;
                   End;
      kAltP:
                  Begin
                    vToggles := vToggles Xor 1;
                    ShowStatus;
                  End;
      kAltR:
                  Begin
                    vToggles := vToggles Xor 4;
                    ShowStatus;
                  End;
      kAltT:
                  Begin
                     TmpSysop := Not TmpSysop;
                     ShowStatus;
                   End;
      kF7:
                  Begin
                    InLock := Not InLock;
                    ShowStatus;
                  End;
      kF8:
                  Begin
                    OutLock := Not OutLock;
                    ShowStatus;
                  End;
      kF9:
                  Begin
                   ToggleUserOpt (TimeLock);
                   ShowStatus;
                 End;
      kAlt0:
                   Begin
                     StatBar := 0;
                     NewStatBar := True;
                     ShowStatus;
                   End;
      kAlt1..kAlt9:
                          If Succ (Key^. LastKey - kAlt1) <= MaxStatBar Then Begin
                            StatBar := Succ (Key^. LastKey - kAlt1);
                            NewStatBar := True;
                            ShowStatus;
                          End;
    End;
  end;

  if et (pst) = 9 then begin
    Clock^. DispLoop;
    ShowStatus;
    ScrSavProc;
  end;

  if et (pst) >= 18 then begin
    inc (mins);
    Clock^. DispLoop;
    ShowStatus;
    ScrSavProc;
    pst := biostime;
  End;

  if mins >= 60 then begin
    If Current = Board Then Begin
      Inc (DailyLog. TimeOnline);
      With User do Begin
        Inc (CurTimeOn);
        Inc (TimeOnToday);
        Inc (tTimeOn);
        If Not ((TimeLock In Options) Or (TimeLimit = 0)) and (timeleft > 0) then
          Dec (TimeLeft);

        screen^. writeat (56, 21, 15, padleft (inttostr (curtimeon), 4, ' '));
        screen^. writeat (56, 22, 15, padleft (inttostr (timeleft), 4, ' '));
      end;
    End;
    mins := 0;
  end;
end;

Constructor tProtocol. Init;
Begin
  NamesList := Nil;
  forcedprot := 0;
End;

  Procedure tProtocol. ForceProto (z: byte);
  Begin
    ForcedProt := z;
  End;

  Function MyAcceptFile (AP : AbstractProtocolPtr): Boolean; Far;
  Begin
{    If Current = Board Then Begin
      MyAcceptFile := False
    End Else} MyAcceptFile := True;
  End;

  Function tProtocol. GetProto: AbstractProtocolPtr;
  var
    Prot: ProtRec;
    extfilename: pathstr;

    procedure parseit (var s: string);
    var
      t: string;
      b: byte;
    begin
      t := '';
      for b := 1 to length (s) do with nodedata do begin
        if (s [b] = '%') and (b <> length (s)) then case s [succ (b)] of
          '1': begin
                 t := t + chr (byte (port) + 48);
                 inc (b);
               end;
          '2': begin
                 t := t + inttostr (baud);
                 inc (b);
               end;
          '3': begin
                 t := t + extfilename;
                 inc (b);
               end;
          '4': begin
                 t := t + inttostr (baudrate);
                 inc (b);
               end;
          '5': begin
                 t := t + nodepath + 'DSZ.LOG';
                 inc (b);
               end;
          '6': begin
                 t := t + chr (pred (byte (port)) + 48);
                 inc (b);
               end;
          '7': begin
                 t := t + hexw (base);
                 inc (b);
               end;
          '8': begin
                 t := t + inttostr (irq);
                 inc (b);
               end;
          '9': begin
                 t := t + hexb (vector);
                 inc (b);
               end;
        end else t := t + s [b];
      end;
      s := t;
    end;

    procedure buildfilelist;
    var
      t: text;
      ba: batchrec;
      la, lc: byte;
      af: file of farearec;
    begin
      assign (t, nodedata. nodepath + 'filelist');
      rewrite (t);
      la := 0;
      lc := 0;
      with vbatch^ do begin
        jump (1);
        repeat
          get (ba);
          with ba do begin
            if (lc <> conf) or (la <> area) then begin
              assign (af, uc. filepath + 'filearea.' + inttostr (conf));
              reset (af);
              seek (af, pred (area));
              read (af, ar);
              close (af);
              la := area;
              lc := conf;
            end;
            writeln (t, ar. path + flname);
          end;

          if activenodenumber = totalnodes then break;
          advance (1);
        until false;
      end;
      close (t);
    end;

    function getprotremote: byte;
    var
      f: file of protrec;
      theshits: boolean;
      amode: boolean;
      x: byte;
      s: string;
      c: char;
      shit: pdllobj;
    begin
      getprotremote := 0;
      assign (f, Uc. DataPath + 'PROTOS.DAT');
      reset (f);
      theshits := exist (uc. disppath + 'pdprotos.ans') or exist (curstatset. path + 'pdprotos.ans');

      if theshits then begin
        new (shit, init);
        s := '';
        while not eof (f) do begin
          read (f, prot);
          with prot do begin
            if (not hasacs (acs)) or
               ((mnpreq in opts) and online and not modem^. GetLastErrorMode) then begin
              s := s + ' ';
              continue;
            end;

            if transfermode = transmit then
              if ptype = pexternal then
                if ((nameslist^. totalnodes = 1) and (sline = '')) or
                ((nameslist^. totalnodes > 1) and (bsline = '')) then begin
                  s := s + ' ';
                  continue;
              end else else
                if (nameslist^. totalnodes > 1) and not (ptype in [pYmodemG..pKermit]) then begin
                  s := s + ' ';
                  continue;
                end;
            shit^. add (pdname, 31);
            s := s + ucase (ckeys);
          end;
        end;

        c := getpdchar (uc. disppath + 'pdprotos.ans', 1, s, shit);
        if (c = 'Q') or hung then begin
          dispose (shit, done);
          close (f);
          exit;
        end;
        if c = #0 then
          theshits := false
        else begin
          getprotremote := pos (c, s);
          seek (f, pred (pos (c, s)));
          read (f, prot);
        end;
        dispose (shit, done);
      end;

      if not theshits then begin
        amode := exist (uc. disppath + 'protocol.ans') or exist (curstatset. path + 'protocol.ans');
        s := 'Q';

        if amode then
          pfile ('protocol.ans')
        else begin
          comwriteln ('');
          fillin1 := 'Download Protocols';
          pfile ('hdr.ans');
          comwriteln (^M^J + cs (150));
        end;

        while not eof (f) do begin
          read (f, prot);
          with prot do begin
            if (not hasacs (acs)) or
               ((mnpreq in opts) and not modem^. GetLastErrorMode) then begin
              s := s + ' ';
              continue;
            end;
            ckeys := ucase (ckeys);
            if not amode then
              comwriteln ('|UP[|UI' + ckeys + '|UP]|UR  ' + padleft (name, 12, ' ') + '|UP - |UR' + padleft (descr, 40, ' '));
            s := s + ckeys;
          end;
        end;

        if not amode then comwrite (^M^J + cs (140));

        repeat
          c := ucase (readinchar);
          if c = ' ' then continue;
        until (c = ^M) or hung or (pos (c, s) <> 0);
        if hung then begin
          close (f);
          exit;
        end;

        send (c);
        comwriteln ('');
        if (c = ^M) or (c = 'Q') then begin
          close (f);
          exit;
        end;

        seek (f, pos (c, s) - 2);
        read (f, prot);
        getprotremote := filepos (f);
        fillin1 := name;
        if TransferMode = transmit then fillin2 := 'download' else fillin2 := 'upload';
        comwriteln (^m^j + cs (146) + ^m^j);
      end;

      SS^. Save;
      close (f);
      name := prot. name;
    end;

    function getprotlocal: boolean;
    var
      ListWin:  ^ListLinkObj;
      ItemList: ^StrDLLOBJ;
      B: Byte;
    Begin
      GetProtLocal := False;

      New (ItemList, Init);
      If ItemList = Nil Then Exit;

      With ItemList^ Do for b := 1 to 10 do
        If Add (' ' + pee [b]) <> 0 Then break;

      if itemlist <> nil then begin
        New (ListWin, Init);
        If ListWin <> Nil Then begin
          With ListWin^ Do Begin
            AssignList (ItemList^);
            SetColors ($17, $07, $1F);
            SetColWidth (13);
            with Win^ do begin
              SetColors ($08, $08, $07, $09, $08, $01, $08);
              SetClose (False);
              SetTitle (' Protocols ');
              SetSize (30, 7, 44, 18, 1)
            end;
            SetActivePick (pZmodem);
            vUseLastCol := True;
            SetTagging (False);
            If Not Go Then Begin
              prot. ptype := 0;
              name := '';
            End else begin
              GetProtLocal := True;
              prot. ptype := vActivePick;
              name := pee [prot. ptype];
            end;
          End;
        end;
        Dispose (ListWin, Done);
      end;
      Dispose (ItemList, Done);
    end;

    function getsinglefile: pathstr;
    var
      ba: batchrec;
      af: file of farearec;
    begin
      with vbatch^ do
        getnodedata (nodeptr (1), ba);
      with ba do begin
        assign (af, uc. filepath + 'filearea.' + inttostr (conf));
        reset (af);
        seek (af, pred (area));
        read (af, ar);
        close (af);
        getsinglefile := ar. path + flname;
      end;
    end;

  Var
    P: AbstractProtocolPtr;
    s: string;
  begin
    getproto := nil;
    HitEsc := False;
    ChangeBuffers := False;

    If ForcedProt <> 0 Then begin
      prot. ptype := forcedprot;
      forcedprot := 0;
      name := pee [prot. ptype];
    end else begin
      if current = terminal then
        if not getprotlocal then exit else
      else
        if getprotremote = 0 then exit;
    end;

    if hung then exit;

    protocol := prot. ptype;

    Case protocol of
      pZmodem, pZmodem8k:
             Begin
               P := New (ZModemProtocolPtr, Init (Uart));
               If P <> Nil Then
                 With ZModemProtocolPtr (P)^ Do Begin
                   SetFileMgmtOptions (True, False, WriteAppend);
                   If ResumeXfer Then
                     SetRecoverOption (True);
                   If prot. ptype = pZmodem8K Then Begin
                     ChangeBuffers := True;
                     If NodeData. InSize < 16414 Then
                       Uart^. ChangeBufferSizes (16414, 0);
                     If NodeData. OutSize < 16414 Then
                       Uart^. ChangeBufferSizes (0, 16414);
                     SetBigSubpacketOption (True);
                   End;
                 End;
             End;

      pYmodem, pYmodemG:
             Begin
               P := New (YmodemProtocolPtr, Init (Uart, True, prot. ptype = YmodemG));
               If P <> Nil Then
                 YmodemProtocolPtr (P)^. SetBlockWait (RelaxedBlockWait);
             End;

      pXmodem, pXmodemCRC, pXmodem1K, pXmodem1KG:
             Begin
               P := New (XModemProtocolPtr, Init (Uart, prot. ptype = pXmodem1K, prot. ptype = pXmodem1KG));
               If P <> Nil Then
                 With XModemProtocolPtr (P)^ Do Begin
                   SetBlockWait (RelaxedBlockWait);
                 End;
             End;

      pAscii:
             Begin
               P := New (AsciiProtocolPtr, Init (Uart));
               If P <> Nil Then
               If TransferMode = Transmit Then Begin
                 AsciiProtocolPtr (P)^. SetDelays (0, 100);
               End;
             End;

      pKermit:
             Begin
               P := New (KermitProtocolPtr, Init (Uart));
               With KermitProtocolPtr(P)^ do Begin
                 SetMaxWindows(15);
                 SetMaxLongPacketLen(500);
               End;
             End;

      pExternal:
             with prot do Begin
               usingexternal := true;
               if transfermode = transmit then begin
                 if vbatch^. totalnodes > 1 then begin
                   s := bsline;
                   extfilename := nodedata. nodepath + 'filelist';
                   buildfilelist;
                 end else begin
                   s := sline;
                   extfilename := getsinglefile;
                 end;
               end else begin
                 if ubatch^. totalnodes > 1 then
                   s := brline
                 else
                   s := rline;
                 extfilename := varea. path;
               end;
               parseit (s);
               runcomm (pname + ' ' + s, '|15E|07x|08ternal |15P|07r|08otocols', true, true);
               deletefile (nodedata. nodepath + 'filelist');
               p := nil;
             End;

      Else P := Nil;
    End;

    GetProto := P;

    If P = Nil Then Begin
      HitEsc := True;
      Exit;
    End;

    With P^ Do Begin
      if current = board then SetLogFileProc (LogFileActivity);
      SetShowStatusProc (WindowStat);
      pst := biostime;
      mins := 0;
      SetBackgroundProc (Background);
      SetOverwriteOption(WriteRename);
      SetHandshakeWait  (180, 5);
      SetAcceptFileFunc (MyAcceptFile);
    End;
  End;

  procedure tProtocol. clearnamelist;
  begin
    if nameslist <> nil then
      nameslist^. emptylist
    else
      new (nameslist, init);
  end;

  Function tProtocol. AddFile (F: PathStr): Boolean;
  Begin
    AddFile := (nameslist <> nil) and (NamesList^. Add (F, 80) = 0);
  End;

  procedure tProtocol. dispnamelist;
  begin
    if nameslist <> nil then dispose (nameslist, done);
    nameslist := nil;
  end;

  function tProtocol. getremfname (var fname: str12): boolean;
  begin
    getremfname := false;
    comwrite (cs (154));
    fname := '';
    getcapstr (12, 'A', false, false, fname);
    comwriteln ('');
    if hung or (fname = '') then exit;
    getremfname := true;
  end;

  Procedure tProtocol. GetFiles;
  Var
    ListWin: ^ListDirObj;
    L: LongInt;
    Rec: tFileInfo;
    S: PathStr;
    CurDir: DirStr;
    F: File;
    W: pWinObj;
  Begin
    GetDir (0, CurDir);
    Screen^. EnableHighBgd;
    New (ListWin, Init);

    With ListWin^ Do
    Begin
      Win^. SetSize (1, 1, 80, Pred (Monitor^. Depth), 1);
      Win^. SetShadow (False);
      SetColors ($1F, $87, $89);
      ReadFiles (Uc. TmUlPath, AnyFile);

      If Proto^. SupportsBatch Then
        SetTagging (True)
      Else
        SetTagging (False);

      Go;
      Win^. Remove;
      Screen^. DisableHighBgd;

      If (LastKey = 27) Or (Lastkey = 600) Then
        HitEsc := True
      Else Begin
        S := GetHiString;

        If Proto^. SupportsBatch Then Begin
          New (W, Init);
          if w <> nil then begin
            W^. SetSize (28, 10, 50, 14, 2);
            W^. SetClose (False);
            Screen^. EnableHighBgd;
            W^. Draw;
            Screen^. WritePlain (2, 2, 'Validating files...');
          end;

          FillChar (Batch, Sizeof (Batch), 0);
          clearnamelist;

          l := 1;
          while l <= FileList^. TotalNodes do begin
            If GetStatus (L, 0) Then with rec do Begin
              with Filelist^ do begin
                GetFileRecord (Rec, l);
                filelist^. delnode (nodeptr (l));
              end;

              Assign (F, Path + FileName);
              {$I-}
              Reset (F, 1);
              {$IFDEF Debug}{$I+}{$ENDIF}
              If IoResult = 0 Then Begin
                With Batch do Begin
                  Inc (Files);
                  Inc (Bytes, FileSize (F));
                End;
                S := Path + FileName;
                Close (F);
                if not AddFile (S) then break;
              End;
            End else inc (l);
          End;

          If NamesList^. TotalNodes = 0 Then Begin
            Assign (F, S);
            {$I-}
            Reset (F, 1);
            {$IFDEF Debug}{$I+}{$ENDIF}
            If IoResult = 0 Then Begin
              NamesList^. Add (S, 80);
              With Batch do Begin
                Files := 1;
                Bytes := FileSize (F);
              End;
            End;
            {$I-}
            Close (F);
            {$IFDEF Debug}{$I+}{$ENDIF}
          End;

          With Batch do Begin
            fLeft := Files;
            bLeft := Bytes;
          End;

          if w <> nil then begin
            Dispose (W, Done);
            Screen^. DisableHighBgd;
          end;
        End Else Begin
          SrcFileName := S;
          Assign (F, SrcFileName);
          {$I-}
          Reset (F, 1);
          {$IFDEF Debug}{$I+}{$ENDIF}
          If IoResult = 0 Then Begin
            With Batch do Begin
              Files := 1;
              fLeft := files;
              Bytes := FileSize (F);
              bLeft := Bytes;
            End;
            Proto^. SetFileMask (SrcFileName);
          End Else HitEsc := True;
          {$I-}
          Close (F);
          {$IFDEF Debug}{$I+}{$ENDIF}
        End;
      End;
    End;
    Dispose (ListWin, Done);
    ChDir (CurDir);
  End;

  Procedure tProtocol. InitVars;
  Begin
    AbortXfer := False;
    SrcFilename := '';
    lc := 0;
    la := 0;
    leeched := false;
    usingexternal := false;
  End;

  Function KbdAbort : Boolean; Far;
  Begin
    If abortxfer or ((Current = Board) And hung) Then
      KbdAbort := True
    Else if ((Current <> Board) And Key^. KeyPressed and (Key^. GetKey = kEsc)) Then
      KbdAbort := True
    else
      KbdAbort := False;
  End;

  Function NextFileToSend (AP: AbstractProtocolPtr; Var FName: PathStr): Boolean;
  Var
    sav, W: LongInt;
    B: Byte;
    S: PathStr;
    D: DirStr;
    N: NameStr;
    E: ExtStr;
    ba: batchrec;
    af: file of farearec;
  Begin
    NextFileToSend := False;
    FName := '';
    dec (batch. fleft);
    if batch. fleft = 0 then exit;
    Screen^. WriteAt (30, 22, 15, PadLeft (IntToStr (Batch. fLeft), 8, ' '));
    NextFileToSend := True;

    if current = terminal then with Proto^. NamesList^ do begin
      W := TotalNodes;
      If W <> 0 Then Begin
        Get (FName);
        DelNode (StartNodePtr);
        Dec (W);

        For B := 1 to 4 do Begin
          If B > W then begin
            Screen^. WriteAt (14, 17 + B, 15, Replicate (12, ' '));
            continue;
          end;
          Get (S);
          advance (1);
          FSplit (S, D, N, E);
          Screen^. WriteAt (14, 17 + B, 15, PadLeft (SetLower (N + E), 12, ' '));
        End;
        jump (1);
      End;
    end else with vBatch^ do begin
      sav := succ (ActiveNodeNumber);
      w := totalnodes;

      if UseRealPaths then begin
        Get (s);
        fname := s;

        For B := 1 to 4 do Begin
          If sav + pred (b) > w Then begin
            Screen^. WriteAt (14, 17 + B, 15, Replicate (12, ' '));
            continue;
          end;
          advance (1);
          Get (s);
          FSplit (s, D, N, E);
          Screen^. WriteAt (14, 17 + B, 15, PadLeft (SetLower (N + E), 12, ' '));
        End;
      end else begin
        Get (ba);

        with ba do begin
          if (lc <> conf) or (la <> area) then begin
            assign (af, uc. filepath + 'filearea.' + inttostr (conf));
            reset (af);
            seek (af, pred (area));
            read (af, ar);
            close (af);
            la := area;
            lc := conf;
          end;
        end;

        fname := ar. path + ba. flname;

        For B := 1 to 4 do Begin
          If sav + pred (b) > w Then begin
            Screen^. WriteAt (14, 17 + B, 15, Replicate (12, ' '));
            continue;
          end;
          advance (1);
          Get (ba);
          FSplit (ba. flname, D, N, E);
          Screen^. WriteAt (14, 17 + B, 15, PadLeft (SetLower (N + E), 12, ' '));
        End;
      end;
      ShiftActiveNode (nodeptr (sav), sav);
    end;
  End;

  Procedure tProtocol. Redraw;
  Begin
    vdone := true;
    scrsavproc;
    If Current = Board Then
      AllowScrSav (False)
    else
      AllowScrSav (true);

    Screen^. Clear (0, ' ');

    If (Current = Terminal) And ExDispMode Then Begin
      Setmode (28, false);
      setscreensize (1, 1, 80, 25);
      Clock^. Change (72, 28, 23);
    end else if current = terminal then begin
      setscreensize (1, 1, 80, 24);
      Clock^. Change (72, 25, 23);
    End Else If (Current = Board) And (succ (curpagelen) <> currentmode) Then Begin
      Setmode (succ (curpagelen), false);
      setscreensize (1, 1, 80, curpagelen);
      Clock^. Change (72, currentmode, 23);
    End;

    with screen^ do
      updatecursor (wherex, wherey);

    SS^. Display;
    Dispose (SS, Done);

    If Current = Terminal Then
      Term^. StatusBar (True)
    Else Begin
      NewStatBar := True;
      ShowStatus;
    End;

    Screen^. curson;
  End;

  Procedure tProtocol. Upload;
  Var
    WinCoords: tByteCoords;
  Begin
    if localonly then exit;
    InitVars;
    Proto := Nil;
    TransferMode := Transmit;

    New (SS, Init);
    If SS = Nil Then Exit;
    SS^. Save;
    Screen^. CursOff;

    Proto := GetProto;
    If proto = nil then hitesc := true;

    if usingexternal then begin
      If Current = Terminal Then
        Term^. StatusBar (True)
      Else Begin
        NewStatBar := True;
        ShowStatus;
      End;
      if not localonly then Uart^. SetModem (True, True);
      exit;
    end;

    If Not HitEsc Then Begin
      if current = terminal then GetFiles;
      If Not HitEsc Then Begin
        Uart^. SetAbortFunc (KbdAbort);

        With Proto^ Do Begin
          If SupportsBatch Then Begin
            SetNextFileFunc (NextFileToSend);
            apOptionsOff (apIncludeDirectory);
          End;

          If Modem^. GetConnectSpeed <> 0 Then
            SetActualBPS (Modem^. GetConnectSpeed);

          DiskSpace := 0;

          key^. assignidlehook (noinputidlehook);
          key^. assignpressedhook (noinputpressedhook);

          if current = terminal then
            NamesList^. Jump (1)
          else
            vBatch^. Jump (1);

          Assign (FLog, NodeData. NodePath + 'DSZ.LOG');
          {$I-}
          Append (FLog);
          If IOResult = 2 Then Rewrite (FLog);
          {$IFDEF Debug}{$I+}{$ENDIF}

          AllowScrSav (False);
          New (Switch, Init (Uart));
          ProtocolTransmit;
          abortxfer := abortxfer or (asyncstatus = eccancelrequested) or (asyncstatus = ecuserabort);
          Dispose (Switch, Done);

          Close (FLog);

          with key^ do if current = board then begin
            assignidlehook (bbsidle);
            assignpressedhook (bbspressed);
          end else begin
            assignidlehook (termidle);
            assignpressedhook (termpressed);
          end;
        End;
      End;
    End;

    If (current = terminal) and proto^. SupportsBatch Then dispnamelist;
    If Proto <> Nil Then Dispose (Proto, Done);
    If ChangeBuffers Then
      With NodeData Do
        Uart^. ChangeBufferSizes (InSize, OutSize);

    Redraw;

    if not localonly then begin
      Uart^. SetModem (True, True);
      Uart^. SetAbortFunc (NoAbortProc);
    end;
  End;

  Procedure tProtocol. Download;
  Var
    FName: String;
    WinCoords: tByteCoords;
    Temp,
    DnldDir: DirStr;
  Begin
    if localonly then exit;
    InitVars;
    Proto := Nil;
    TransferMode := Receive;

    New (SS, Init);
    If SS = Nil Then Exit;
    SS^. Save;
    Screen^. CursOff;

    Proto := GetProto;

    if usingexternal then begin
      Redraw;
      Uart^. SetModem (True, True);
      exit;
    end;

    if proto = nil then hitesc := true;

    If Current = Terminal Then
      DnldDir := Uc. TmDlPath
    Else
      DnldDir := varea. path;

    If Not HitEsc Then Begin
      If Not Proto^. SupportsBatch Then Begin
        If (online and getremfname (fname)) or (not online and EnterFileName (FName)) Then Begin
          If Exist (DnldDir + FName) Then
            If not online and Not YesNo (FName + ' already exists,', 'overwrite?') Then Begin
              Dispose (Proto, Done);
              SS^. Display;
              Dispose (SS, Done);
              Exit;
            End else if online then begin
              { get overwrite confirmation here }
            end;
        End Else Begin
          Dispose (Proto, Done);
          SS^. Display;
          Dispose (SS, Done);
          Exit;
        End;
      End Else
        FName := '';

      Uart^. SetAbortFunc (KbdAbort);

      Temp := fExpand (DnldDir);
      DiskSpace := DiskFree (Ord (Temp [1]) - 64);

      With Proto^ Do Begin
        SetDestinationDirectory (DnldDir);
        SetReceiveFilename (FName);
        if current = terminal then
          SetOverwriteOption (WriteAnyway)
        else
          SetOverwriteOption (WriteFail);

        Assign (FLog, NodeData. NodePath + 'DSZ.LOG');
        {$I-}
        Append (FLog);
        If IOResult = 2 Then Rewrite (FLog);
        {$IFDEF Debug}{$I+}{$ENDIF}

        key^. assignidlehook (noinputidlehook);
        key^. assignpressedhook (noinputpressedhook);

        AllowScrSav (False);
        New (Switch, Init (Uart));
        ProtocolReceive;
        abortxfer := {(asyncstatus = eccancelrequested) or} abortxfer or (asyncstatus = ecuserabort);
        Dispose (Switch, Done);

        Close (FLog);

        with key^ do if current = board then begin
          assignidlehook (bbsidle);
          assignpressedhook (bbspressed);
        end else begin
          assignidlehook (termidle);
          assignpressedhook (termpressed);
        end;
      End;
    End;

    If Proto <> Nil Then Dispose (Proto, Done);

    Redraw;

    if not localonly then begin
      Uart^. SetModem (True, True);
      Uart^. SetAbortFunc (NoAbortProc);
    end;
  End;

Destructor tProtocol. Done;
Begin
End;

Constructor SwitchToBinary. Init (AP : AbstractPortPtr);
Begin
  Port := AP;
  Port^. GetLine (Baud, Parity, DataBits, StopBits, False);
  Port^. SetLine (0, NoParity, 8, 1);
End;

Destructor SwitchToBinary. Done;
Begin
  Port^. SetLine (0, Parity, DataBits, StopBits);
End;

End.
