{$S-,R-,I-,O+,F+,A+,G+}

{Conditional defines that may affect this unit}
{$I APDEFINE.INC}

{Include OPro's define file if UseOPro is specified}
{$IFDEF UseOPro}
{$I OPDEFINE.INC}
{$ENDIF}

{*********************************************************}
{*                 OOASCII.PAS 1.12                      *}
{*     Copyright (c) TurboPower Software 1991.           *}
{*                 All rights reserved.                  *}
{*********************************************************}

unit OOAscii;
  {-Provides ASCII recieve and transmit functions (using OOP)}

interface

uses
  Dos,
  {$IFDEF UseOPro}
  OpInline,
  OpString,
  OpRoot,
  OpDate,
  {$ENDIF}
  {$IFDEF UseTPro}
  TpMemChk,
  TpInline,
  TpString,
  TpDate,
  {$ENDIF}
  ApPort,
  ApTimer,
  ApMisc,
  OoCom,
  OoAbsPcl;

const
  {Run-time constants}
  DefInterCharDelay : Word = 0;   {Default is zero ms delay between chars}{!!.12}
  DefInterLineDelay : Word = 0;   {Default is zero ms delay between lines}
  DefEOLChar : Char = cCr;        {Default EOL char is carriage return}
  DefRcvTimeout : Word = 1092;    {Default tics to assume end of receive}
  DefBlockLen : Word = 60;        {Default block length (assume avg of 60)}

  {---- Option code for AsciiProtocol ----}
  apSuppressCtrlZ  = $0800;                                             {!!.12}

  DefAsciiOptions  : Word = 0;

type
  AsciiProtocolPtr = ^AsciiProtocol;
  AsciiProtocol = object(AbstractProtocol)
    apInterCharDelay : Word;
    apInterLineDelay : Word;
    RcvTimeOut       : Word;
    apEOLChar        : Char;
    CtrlZEncountered : Boolean;
    GotFirstBlock    : Boolean;
    constructor Init(APPtr : AbstractPortPtr);
      {-Allocates and initializes a protocol control block}
    constructor InitCustom(APPtr : AbstractPortPtr;
                           InterCharDelay, InterLineDelay : Word;
                           Options : Word);
      {-Allocates and initializes a protocol control block}
    destructor Done; virtual;
      {-Disposes of the protocol record}
    procedure SetDelays(InterChar, InterLine : Word);
      {-Set the delay (in ms) between each character and each line}
    procedure SetEOLChar(C : Char);
      {-Set the character used to mark the end of line}
    function GetLineNumber : LongInt;
      {-Return the current line number}

    {$IFDEF UseStreams}
    constructor Load(var S : IdStream);
      {-Load an AsciiProtocol object from a stream}
    procedure Store(var S : IdStream);
      {-Store an AsciiProtocol object to a stream}
    {$ENDIF}

    {#Z+}
    procedure apUpdateBlockCheck(CurByte : Byte); virtual;
      {-Updates the block check character (whatever it is)}
    procedure apSendBlockCheck; virtual;
      {-Makes final adjustment and sends the BlockCheck character}
    function apVerifyBlockCheck : Boolean; virtual;
      {-Receives and checks the block check value}
    function apGetFirstBlockNum : Byte; virtual;
      {-Returns first block number}

    function apProcessHandshake : Boolean; virtual;
      {-Process initial handshake, return true to exit}
    procedure apInitForTransmit; virtual;
      {-Gets protocol request from receiver, sets parms}
    function apProcessBlockReply : Boolean; virtual;
      {-Process reply to last block; return True if TransmitBlock should exit}
    procedure apTransmitBlock(var Block : DataBlockType;
                            BLen : Word; BType : Char); virtual;
      {-Transmits one data block}
    procedure apTransmitEot(First : Boolean); virtual;
      {-Transmit an Eot}
    procedure apSendHandshakeChar(Handshake : Char); virtual;
      {-Send the current handshake char}
    procedure apReceiveBlock(var Block : DataBlockType;
                             var BlockSize : Word;
                             var HandShake : Char); virtual;
      {-Receive on record into Buffer}
    procedure apCancel; virtual;
      {-Sends cancel request to remote}
    procedure ProtocolTransmit; virtual;
      {-Starts Ascii protocol transmit}
    procedure ProtocolReceive; virtual;
      {-Starts Ascii protocol receive}
    procedure apTransmitFile; virtual;
    procedure apReceiveFile; virtual;
    {#Z-}
  end;

{$IFDEF UseStreams}
procedure AsciiProtocolStream(SPtr : IdStreamPtr);
  {-Register all types needed for streams containing AsciiProtocol objects}
{$ENDIF}

implementation

uses totstr;

type
  Chars = array[1..1024] of Char;      {Maximum buffer supported}

  constructor AsciiProtocol.Init(APPtr : AbstractPortPtr);
    {-Allocates and initializes a protocol control block}
  begin
    {Init ancestor}
    if not AbstractProtocol.InitCustom(APPtr, DefAsciiOptions) then
      Fail;
    ProtType := Ascii;
    apInterCharDelay := DefInterCharDelay;
    apInterLineDelay := DefInterLineDelay;
    apEOLChar        := DefEOLChar;
    CtrlZEncountered := False;
    RcvTimeout       := DefRcvTimeout;
    BlockLen         := DefBlockLen;
  end;

  constructor AsciiProtocol.InitCustom(APPtr : AbstractPortPtr;
                                       InterCharDelay, InterLineDelay : Word;
                                       Options : Word);
    {-Allocates and initializes a protocol control block}
  begin
    if not AsciiProtocol.Init(APPtr) then
      Fail;
    apOptionsOn(Options);
    SetDelays(InterCharDelay, InterLineDelay);
  end;

  destructor AsciiProtocol.Done;
    {-Disposes of the protocol record}
  begin
    AbstractProtocol.Done;
  end;

  procedure AsciiProtocol.apCancel;
    {-Sends cancel request to remote}
  begin
  end;

  procedure AsciiProtocol.SetDelays(InterChar, InterLine : Word);
    {-Set the delay (in ms) between each character and each line}
  begin
    apInterCharDelay := InterChar;
    apInterLineDelay := InterLine;
  end;

  procedure AsciiProtocol.SetEOLChar(C : Char);
    {-Set the character used to mark the end of line}
  begin
    apEOLChar := C;
  end;

  function AsciiProtocol.GetLineNumber : LongInt;
    {-Return the current line number}
  begin
    GetLineNumber := BlockNum;
  end;

  procedure AsciiProtocol.apUpdateBlockCheck(CurByte : Byte);
    {-Updates the block check character (whatever it is)}
  begin
  end;

  procedure AsciiProtocol.apSendBlockCheck;
    {-Makes final adjustment and sends the BlockCheck character}
  begin
  end;

  function AsciiProtocol.apVerifyBlockCheck : Boolean;
    {-Receives and checks the block check value}
  begin
    apVerifyBlockCheck := True;
  end;

  function AsciiProtocol.apGetFirstBlockNum : Byte;
    {-Returns first block number}
  begin
    apGetFirstBlockNum := 0;
  end;

  function AsciiProtocol.apProcessHandshake : Boolean;
    {-Process initial handshake, return true to exit}
  begin
    apProcessHandshake := True;
  end;

  procedure AsciiProtocol.apInitForTransmit;
    {-Gets protocol request from receiver, sets parms}
  begin
    apResetStatus;
    CtrlZEncountered := False;
    {Set the first block number}
    BlockNum := apGetFirstBlockNum;
    AsyncStatus := ecOK;
  end;

  function AsciiProtocol.apProcessBlockReply : Boolean;
    {-Process reply to last block; return True if TransmitBlock should exit}
  begin
    apProcessBlockReply := True;
  end;

  procedure AsciiProtocol.apTransmitBlock(var Block : DataBlockType;
                                          BLen : Word; BType : Char);
    {-Transmits one data block}
  var
    BytesWritten : Word;
    C : Char;
  begin
    with APort^ do begin
      {Stop writing on CtrlZ}
      if CtrlZEncountered and FlagIsSet(apFlags, apSuppressCtrlZ) then
        Exit;

      {Wait here until free space is available}
      if not apWaitForFreeSpace(SizeOf(DataBlockType), TransTimeout) then begin
        if ((AsyncStatus mod 10000) = ecUserAbort) then
          GotError(epFatal+ecCancelRequested)
        else
          GotError(epFatal+ecBufferIsFull);
        Exit;
      end;

      BytesWritten := 0;
      repeat
        {Check for user abort}
        if UserAbort then begin
          AsyncStatus := ecCancelRequested;
          Exit;
        end;

        {Try to transfer a character}
        Inc(BytesTransferred);
        Dec(BytesRemaining);
        if BytesRemaining < 0 then
          BytesRemaining := 0;
        Inc(BytesWritten);
        C := Chars(Block)[BytesWritten];
        if (C = ^Z) and FlagIsSet(apFlags, apSuppressCtrlZ) then begin
          BytesWritten := BLen;
          CtrlZEncountered := True;
        end else begin
          {Send character and check for delays}
          PutChar(C);
          if C = apEOLChar then begin
            Inc(BlockNum);
            if apInterLineDelay > 0 then
              Delay(apInterLineDelay);
            apUserStatus(False, False);
          end else if apInterCharDelay > 0 then
            Delay(apInterCharDelay);
        end
      until BytesWritten = BLen;

      {Update status info and show status}
      if BytesRemaining < 0 then
        BytesRemaining := 0;
      ElapsedTics := ElapsedTime(Timer);
      apUserStatus(False, False);
    end;
  end;

  procedure AsciiProtocol.apTransmitEot;
    {-Transmit an Eot}
  begin
  end;

  procedure AsciiProtocol.apSendHandshakeChar(Handshake : Char);
    {-Send the current handshake char}
  begin
  end;

  procedure AsciiProtocol.apReceiveBlock(var Block : DataBlockType;
                                         var BlockSize : Word;
                                         var HandShake : Char);
    {-Receive block into Buffer}
  var
    Finished : Boolean;
    Cnt : Word;
    C : Char;
    SaveStatus : Word;

  begin
    AsyncStatus := ecAsciiReceiveInProgress;
    with APort^ do begin
      {Handle end}
      if CtrlZEncountered then begin
        AsyncStatus := ecEndFile;
        Exit;
      end;

      Finished := False;
      Cnt := 1;
      {Loop getting chars until timeout or ^Z found}
      repeat
        GetCharTimeout(C, RcvTimeout);
        if AsyncStatus = ecOk then begin
          {Add character to buffer}
          Chars(Block)[Cnt] := C;
          Inc(Cnt);
          {Count lines}
          if C = apEOLChar then
            Inc(BlockNum);
        end else if (AsyncStatus mod 10000) = ecTimeout then begin
          {Assume we're finished if we timeout}
          AsyncStatus := ecOk;
          Finished := True;
          CtrlZEncountered := True;
        end else if (AsyncStatus mod 10000) = ecUserAbort then begin
          AsyncStatus := ecOk;
          Finished := True;
          CtrlZEncountered := True;
        end;

        {Start the protocol timer on the first received character}
        if not GotFirstBlock then begin
          GotFirstBlock := True;
          NewTimer(Timer, 1);
        end;

        {Assume we're finished on ^Z}
        if C = ^Z then begin
          Finished := True;
          CtrlZEncountered := True;
        end;

        {Finished if block is full}
        if Cnt > BlockLen then
          Finished := True;
      until Finished;
      Dec(Cnt);
      BlockSize := Cnt;

      {Update data areas and show status}
      Inc(BytesTransferred, Cnt);
      Dec(BytesRemaining, Cnt);
      if BytesRemaining < 0 then
        BytesRemaining := 0;
      ElapsedTics := ElapsedTime(Timer);
      SaveStatus := AsyncStatus;
      AsyncStatus := ecAsciiReceiveInProgress;
      apUserStatus(False, False);
      AsyncStatus := SaveStatus;
    end;
  end;

  procedure AsciiProtocol.apTransmitFile;
  label
    ExitPoint;
  var
    DataBlock : ^DataBlockType;
    Finished : Boolean;
    BlockSize : Word;
  begin
    with APort^ do begin
      {Get a protocol DataBlock}
      if not GetMemCheck(DataBlock, SizeOf(DataBlockType)) then begin  {!!.03}
        GotError(epFatal+ecOutOfMemory);
        apShowLastStatus;
        Exit;
      end;

      {Pathname must already be set before we get here}
      Pathname := Setupper(Pathname);

      {Show file name to user logging routine}
      LogFile(@Self, lfTransmitStart);

      {Go prepare for reading protocol blocks}
      AsyncStatus := ecOk;
      apPrepareReading;
      if AsyncStatus <> ecOk then
        goto ExitPoint;

      {Start protocol timer now}
      NewTimer(Timer, 1);

      {Repeat for entire "file"}
      FileOfs := 0;
      BlockSize := BlockLen;
      repeat
        {Get a block and send it}
        Finished := apReadProtocolBlock(DataBlock^, BlockSize);

        {Don't send empty blocks (will only happen with empty files)}
        if BlockSize <= 0 then
          Finished := True
        else begin
          {If no errors, then send this block to the remote}
          if AsyncStatus = ecOk then begin
            apTransmitBlock(DataBlock^, BlockSize, #0);                {!!.12}

            {If TransmitBlock failed, go clean up}
            if AsyncStatus <> ecOk then
              goto ExitPoint;

            {Update FileOfs}
            Inc(FileOfs, BlockSize);
          end;
        end;
      until Finished;

      {Drain the output buffer, showing status and checking for aborts}
      if not apDrainOutput(2) then
        goto ExitPoint;

      {Show end of file message}
      AsyncStatus := ecEndFile;

    ExitPoint:
      {Close the file (or whatever was giving us blocks)}
      apFinishReading;

      {Show status, user logging, and clean up}
      apShowLastStatus;
      if AsyncStatus = ecEndFile then begin
        AsyncStatus := ecOk;
        LogFile(@Self, lfTransmitOk)
      end else
        LogFile(@Self, lfTransmitFail);
      FreeMemCheck(DataBlock, SizeOf(DataBlockType));
    end;
  end;

  procedure AsciiProtocol.apReceiveFile;
  var
    BlockSize : Word;
    DataBlock : ^DataBlockType;
    Finished  : Boolean;
    C         : Char;
    FileSkipped : Boolean;
  label
    ExitPoint;

  begin
    with APort^ do begin
      {Initialize status}
      apResetStatus;

      {Show first status}
      AsyncStatus := ecOk;
      apShowFirstStatus;

      {Get a protocol DataBlock}
      if not GetMemCheck(DataBlock, SizeOf(DataBlockType)) then begin  {!!.03}
        GotError(epFatal+ecOutOfMemory);
        apShowLastStatus;
        Exit;
      end;

      {Pathname should already have name of file to receive}
      if Pathname = '' then begin
        GotError(epFatal+ecNoFilename);
        apShowLastStatus;
        FreeMemCheck(DataBlock, SizeOf(DataBlock));                    {!!.03}
        Exit;
      end else
        PathName := Setupper(PathName);

      {Send file name to user's LogFile procedure}
      LogFile(@Self, lfReceiveStart);

      {Accept this file}
      FileSkipped := False;
      if not AcceptFile(@Self) then begin
        FileSkipped := True;
        APort^.GotError(epNonFatal+ecFileRejected);
        goto ExitPoint;
      end;

      {Prepare file for writing protocol blocks}
      apPrepareWriting;
      if AsyncStatus <> ecOk then begin
        if AsyncStatus = ecFileAlreadyExists then
          FileSkipped := True;
        goto ExitPoint;
      end;

      {Say we don't have any blocks yet}
      GotFirstBlock := False;

      {Repeat for entire file}
      FileOfs := 0;
      repeat
        {Receive a data block}
        apReceiveBlock(DataBlock^, BlockSize, C);

        if AsyncStatus = ecOk then begin
          {Got block ok, go write it out}
          Finished := apWriteProtocolBlock(DataBlock^, BlockSize);
          if AsyncStatus = ecOk then
            Inc(FileOfs, BlockSize)
          else
            {Failed to write the block, clean up and exit}
            goto ExitPoint;
        end else
          {Failed to get block (protocol is already over), clean up and exit}
          Finished := True;
      until Finished;

  ExitPoint:
      {Clean up block writing routine}
      apFinishWriting;

      {Show status and clean up}
      if AsyncStatus = ecEndFile then begin
        AsyncStatus := ecOk;
        LogFile(@Self, lfReceiveOk)
      end else if FileSkipped then
        LogFile(@Self, lfReceiveSkip)
      else
        LogFile(@Self, lfReceiveFail);
      apShowLastStatus;
      FreeMemCheck(DataBlock, SizeOf(DataBlockType));
    end;
  end;

  procedure AsciiProtocol.ProtocolTransmit;
    {-Starts Ascii protocol transmit}
  begin
    AbstractProtocol.ProtocolTransmit;
    with APort^ do begin
      {Do startup and init stuff}
      apResetStatus;
      apShowFirstStatus;
      CtrlZEncountered := False;
      BlockNum := 0;
      FindingFirst := True;
      FileListIndex := 0;

      {Transmit one file}
      if not NextFile(@Self, Pathname) then begin
        {AsyncStatus already set}
        apShowLastStatus;
        PR^.ProtocolActive := False;
        Exit;
      end;
      apTransmitFile;
      apShowLastStatus;

      {Show protocol no longer active}
      PR^.ProtocolActive := False;
    end;
  end;

  procedure AsciiProtocol.ProtocolReceive;
    {-Starts Ascii receive protocol}
  begin
    AbstractProtocol.ProtocolReceive;

    {Get the file}
    apReceiveFile;

    {Show protocol no longer active}
    APort^.PR^.ProtocolActive := False;
  end;

  {$IFDEF UseStreams}
  procedure AsciiProtocolStream(SPtr : IdStreamPtr);
  begin
    AbstractProtocolStream(SPtr);
    SPtr^.RegisterType(otAsciiProtocol, veAsciiProtocol,
                       TypeOf(AsciiProtocol),
                       @AsciiProtocol.Store, @AsciiProtocol.Load);
  end;

  constructor AsciiProtocol.Load(var S : IdStream);
    {-Load an AsciiProtocol object from a stream}
  begin
    if not AbstractProtocol.Load(S) then
      Fail;
    S.ReadRange(apInterCharDelay, GotFirstBlock);
    S.Read(GotFirstBlock, SizeOf(Boolean));
  end;

  procedure AsciiProtocol.Store(var S : IdStream);
    {-Store an AsciiProtocol object to a stream}
  begin
    AbstractProtocol.Store(S);
    S.WriteRange(apInterCharDelay, GotFirstBlock);
    S.Write(GotFirstBlock, SizeOf(Boolean));
  end;
  {$ENDIF}

end.
