Unit MsgSpon;
{$I Sys75.Inc}

Interface

Uses
  Spuds;

Procedure rMsgSponsor (C: Char; P: Str100);
Procedure editBase;
Procedure MakeBase;
Procedure userBase;
function  mspons: boolean;

const
  tmpmspons: boolean = false;

Implementation

Uses
  TotStr, TotMisc,
  Comm, EmuCodes, Menus, Misc, RemEmu, Acs, Users, Messages, Emu, regs, joinconf;

function mspons: boolean;
begin
  mspons := sysopacs or cosysopacs or (setupper (vbase. sponsor) = setupper (user. handle));
end;

Procedure EditBase;
var
  bf: File of mBaseRec;
  br: mBaseRec;

  Procedure DrawBaseEditor;
  Var
    B: Byte;
  Begin
    ComWrite ('|UB%CS');
    Box (1, 1, 79, 3, User. Cols [6] );
    Box (1, 4, 79, 22, User. Cols [6] );
    ComWriteAt (3, 2, '|URCommand|UP: |UI');
    ComWriteAt (30, 2, '|UP[|USQ|UP]|URuit');
    ComWriteAt (57, 2, '|15S|07ys|08tem/|157|075 |15B|07a|08se |15E|07di|08tor');
    ComWriteAt (3, 5, '|UP[|USA|UP]|UR Base Name');
    ComWriteAt (3, 6, '|UP[|USB|UP]|UR Access ACS');
    ComWriteAt (3, 7, '|UP[|USC|UP]|UR Post ACS');
    ComWriteAt (3, 8, '|UP[|USD|UP]|UR Anonymous ACS');
    ComWriteAt (3, 9, '|UP[|USE|UP]|UR Sponsor');
    ComWriteAt (3,10, '|UP[|USF|UP]|UR NetMail');
    ComWriteAt (3,11, '|UP[|USG|UP]|UR Origin Line');
    ComWriteAt (3,12, '|UP[|USH|UP]|UR EchoMail Path');
    ComWriteAt (3,13, '|UP[|USI|UP]|UR Node');
    ComWriteAt (3,14, '|UP[|USJ|UP]|UR QWK Name');
    ComWriteAt (3,15, '|UP[|USK|UP]|UR AutoDelete');
    ComWriteAt (3,16, '|UP[|USL|UP]|UR Data File Name');
    ComWriteAt (3,17, '|UP[|USM|UP]|UR Pulldown Name');
    ComWriteAt (3,18, '|UP[|USN|UP]|UR Mandatory Read          |UP[|USO|UP]|UR Real Names         |UP[|USP|UP]|UR Privates');
    ComWriteAt (3,19, '|UP[|US[|UP]|UR Previous Base');
    ComWriteAt (3,20, '|UP[|US]|UP]|UR Next Base');
    ComWriteAt (3,21, '|UP[|USZ|UP]|UR Undo Changes');
    usercol (3);
    For B := 5 To 17 Do
      ComWriteAt (22, B, ':');
    ComWriteAt (22, 18, ':');
    ComWriteAt (46, 18, ':');
    ComWriteAt (67, 18, ':');
  End;

  Procedure FillBaseData (C: Char);
  Var
    Z: Char;
    S: String [80];
  Begin
    If Hung Then Exit;
    usercol (2);
    With br Do Case C Of
      'A': Send (GoXy (24, 5) + PadLeft (Name, 30, ' '));
      'B': Send (GoXy (24, 6) + PadLeft (accacs, 40, ' '));
      'C': Send (GoXy (24, 7) + PadLeft (postacs, 40, ' '));
      'D': Send (GoXy (24, 8) + PadLeft (anonacs, 40, ' '));
      'E': Send (GoXy (24, 9) + PadLeft (sponsor, 30, ' '));
      'F': Send (GoXy (24,10) + NoYes [NetMl in fags]);
      'G': Begin
             Send (GoXy (24,11));
             If Length (originline) > 55 Then
               Send (Copy (originline, 1, 54) + Attr (User. Cols [6]) + '')
             Else
              Send (PadLeft (originline, 55, ' '));
           End;
      'H': Send (GoXy (24,12) + PadLeft (echomaildir, 50, ' '));
      'I': Send (GoXy (24,13) + PadLeft (Node, 15, ' '));
      'J': Send (GoXy (24,14) + PadLeft (qwkname, 12, ' '));
      'K': Send (GoXy (24,15) + PadLeft (inttostr (autodel), 5, ' '));
      'L': Send (GoXy (24,16) + PadLeft (fname, 8, ' '));
      'M': Send (GoXy (24,17) + PadLeft (pdname, 30, ' '));
      'N': Send (GoXy (24,18) + NoYes [mand in fags]);
      'O': Send (GoXy (48,18) + NoYes [rnames in fags]);
      'P': Send (GoXy (69,18) + NoYes [privs in fags]);
      #0: For Z := 'A' To 'P' Do
            FillBaseData (Z);
    End;
  End;

Var
  C: Char;
Begin
  assign (bf, uc. bordpath + 'MsgBases.' + inttostr (curmconf));
  {$I-}
  reset (bf);
  {$IFDEF Debug}{$I+}{$ENDIF}
  if ioresult = 2 then rewrite (bf);
  Seek (bf, pred (curbase));
  Read (bf, br);
  DrawBaseEditor;
  FillBaseData (#0);

  Repeat
    usercol (4);
    Send (Goxy (12, 2) + ' '#8);
    C := uCase (ReadInChar);
    If Hung Then Break;
    If Pos (C, 'ABCDEFGHIJKLMNOPZ[]Q') = 0 Then Continue;
    Send (C);
    usercol (2);

    With br Do Case C Of
      'A':
           Begin
             Send (GoXy (24, 5));
             GetStr (30, False, False, Name);
             FillBaseData (C);
           End;
      'B':
           Begin
             Send (GoXy (24, 6));
             allowflagedit := true;
             GetcapStr (40, 'A', False, False, accacs);
             allowflagedit := false;
             FillBaseData (C);
           End;
      'C':
           Begin
             Send (GoXy (24, 7));
             allowflagedit := true;
             GetcapStr (40, 'A', False, False, postacs);
             allowflagedit := false;
             FillBaseData (C);
           End;
      'D':
           Begin
             Send (GoXy (24, 8));
             allowflagedit := true;
             GetcapStr (40, 'A', False, False, anonacs);
             allowflagedit := false;
             FillBaseData (C);
           End;
      'E':
           Begin
             Send (GoXy (24, 9));
             GetStr (30, False, False, sponsor);
             FillBaseData (C);
           End;
      'F':
           Begin
             if netml in fags then
               fags := fags - [netml]
             else
               fags := fags + [netml];
             FillBaseData (C);
           End;
      'G':
           Begin
             Send (GoXy (1, 22));
             ComWriteln ('|UREnter the origin line|UP:|UI');
             GetStr (80, False, False, originline);
             If Hung Then Break;
             Send (GoXy (1, 22) + Clr2Eol);
             Send (GoXy (1, 23) + Clr2Eol);
             FillBaseData (C);
           End;
      'H':
           Begin
             Send (GoXy (24,12));
             GetStr (50, False, False, echomaildir);
             FillBaseData (C);
           End;
      'I':
           Begin
             Send (GoXy (24,13));
             GetStr (15, False, False, node);
             FillBaseData (C);
           End;
      'J':
           Begin
             Send (GoXy (24,14));
             GetStr (12, False, False, qwkname);
             FillBaseData (C);
           End;
      'K':
           Begin
             Send (GoXy (24,15));
             autodel := GetNumStr (true, False, 0, 65535, 0, 65535, autodel, autodel);
             FillBaseData (C);
           End;
      'L':
           Begin
             Send (GoXy (24,16));
             GetCapStr (8, 'A', False, False, fName);
             cleanpathname (fname, false);
             FillBaseData (C);
           End;
      'M':
           Begin
             Send (GoXy (24,17));
             GetStr (30, False, False, pdName);
             FillBaseData (C);
           End;
      'N':
           Begin
             if mand in fags then
               fags := fags - [mand]
             else
               fags := fags + [mand];
             FillBaseData (C);
           End;
      'O':
           Begin
             if rnames in fags then
               fags := fags - [rnames]
             else
               fags := fags + [rnames];
             FillBaseData (C);
           End;
      'P':
           Begin
             if privs in fags then
               fags := fags - [privs]
             else
               fags := fags + [privs];
             FillBaseData (C);
           End;
      'Z':
           Begin
             Seek (bf, Pred (FilePos (bf)));
             Read (bf, br);
             FillBaseData (#0);
           End;
      '[':
           Begin
             Seek (bf, Pred (FilePos (bf)));
             Write (bf, br);

             Seek (bf, Pred (FilePos (bf)));
             If FilePos (bf) = 0 Then
               Seek (bf, Pred (FileSize (bf)))
             Else
               Seek (bf, Pred (FilePos (bf)));
             Read (bf, br);
             FillBaseData (#0);
           End;
      ']':
           Begin
             Seek (bf, Pred (FilePos (bf)));
             Write (bf, br);

             If FilePos (bf) = FileSize (bf) Then Seek (bf, 0);
             Read (bf, br);
             FillBaseData (#0);
           End;
      'Q':
           Begin
             Seek (bf, Pred (FilePos (bf)));
             Write (bf, br);
             Break;
           End;
    End;
  Until hung;
  If Not hung Then ComWriteAt (1, 23, '|UR');
  Close (bf);
  Log (2, 'Edited message bases in conf ' + mconf. desc);
  gobase (curbase, false);
End;

Procedure MakeBase;
var
  bf: file of mbaserec;
  br: mbaserec;
Begin
  assign (bf, uc. bordpath + 'MsgBases.' + inttostr (curmconf));
  {$I-}
  reset (bf);
  {$IFDEF Debug}{$I+}{$ENDIF}
  if ioresult = 2 then rewrite (bf);
  if filesize (bf) >= 255 then begin
    close (bf);
    ComWriteLn ('|15T|12h|04e |15c|12a|04pacity |15f|12o|04r |15u|12s|04ers |15o|12n |15t|12h|04is |15s|12y|04stem |15h|12a' +
                '|04d |15b|12e|04en |15r|12|e|04ched|08.');
    If Not hung Then PressEnter;
    Exit;
  end;
  fillchar (br, sizeof (br), 0);
  br. name := 'New Base';
  br. fname := 'NEWBASE';
  br. sponsor := uc. sysopname;
  br. autodel := 200;
  seek (bf, filesize (bf));
  write (bf, br);
  curbase := filesize (bf);
  close (bf);
  editbase;
  Log (2, 'Added message base "' + vbase. name + '" to conf "' + mconf. desc + '"');
End;

Procedure KillBase;
var
  f: file;
Begin
  comwriteln ('');
  assign (f, uc. bordpath + 'MsgBases.' + inttostr (curmconf));
  {$I-}
  reset (f, 1);
  {$IFDEF Debug}{$I+}{$ENDIF}
  if ioresult = 2 then exit;
  if filesize (f) = 0 then begin
    close (f);
    exit;
  end;
  if filesize (f) = sizeof (mbaserec) then begin
    comwriteln ('|08There must be at least one base in every conference.'^M^J);
    close (f);
    exit;
  end;
  comwrite ('|15D|07e|08lete base ' + vbase. name  + ' ');
  if litebar (lbno, false, true) = lbno then begin
    close (f);
    exit;
  end;
  removerec (f, pred (curbase), sizeof (mbaserec));
  close (f);
  comwrite ('|15D|07e|08lete message data file ' + vbase. fname + ' too ');
  if litebar (lbno, false, true) = lbno then deletefile (uc. bordpath + vbase. fname);
  Log (2, 'Deleted message base "' + vbase. name + '" from conf "' + mconf. desc + '"');
  if pred (curbase) = fsize (uc. filepath + 'MsgBases.' + inttostr (curmconf)) div sizeof (mbaserec) then
    gobase (pred (curbase), false)
  else
    gobase (curbase, false);
  comwriteln ('');
End;

Procedure reorbase;
var
  bf: file of mbaserec;
  br, tr: mbaserec;
  w: word;
  lui: longint;
  wow, b: byte;

  procedure minilist;
  var
    b: byte;
  begin
    fillin1 := 'Message Bases';
    pfile ('hdr.ans');
    send (^M^J);
    seek (bf, 0);
    b := 1;
    while not eof (bf) do begin
      read (bf, br);
      comwriteln ('  |UP[|UI' + padright (inttostr (b), 3, ' ') + '|UP]|US  ' + br. name);
      inc (b);
    end;
    send (^M^J);
  end;

Begin
  assign (bf, uc. bordpath + 'MsgBases.' + inttostr (curmconf));
  {$I-}
  reset (bf);
  {$IFDEF Debug}{$I+}{$ENDIF}
  if ioresult = 2 then exit;
  Log (2, 'Re-ordered message bases in conf ' + mconf. desc);

  minilist;
  for b := 1 to filesize (bf) do begin
    seek (bf, pred (b));
    read (bf, br);
    repeat
      comwrite ('|UR Enter new base |US#' + inttostr (b) + ' |UP(|US' + br. name + '|UP) [|UI1|UP-|UI' +inttostr(filesize (bf))
                + '|UP, |UIQ|UP/|URquit|UP]: |UI');
      Lui := GetQNumStr (False, False, 1, FileSize (bf), 0, 0, b, 0, wow, '?Qq');
      if hung then break;
      comwriteln ('');
      if wow = 1 then
        minilist
      else if wow > 1 then
        break
      else if lui <> 0 then break;
    until hung;

    if wow > 1 then break;

    if hung then begin
      close (bf);
      exit;
    end;

    comwriteln ('');
    if b = lui then continue;

    seek (bf, pred (lui));
    read (bf, br);

    if lui > b then begin
      for w := pred (lui) downto b do begin
        seek (bf, filepos (bf) - 2);
        read (bf, tr);
        write (bf, tr);
        seek (bf, pred (filepos (bf)));
      end;
    end else begin
      for w := lui to pred (b) do begin
        read (bf, tr);
        seek (bf, filepos (bf) - 2);
        write (bf, tr);
        seek (bf, succ (filepos (bf)));
      end;
    end;

    seek (bf, pred (b));
    write (bf, br);
  end;

  close (bf);
  gobase (curbase, false);
End;

procedure packmsgs;
begin
end;

procedure acstoall (yes: boolean);
begin
  tmpmspons := yes;
  if yes then
    Log (0, 'Access to all message bases/confs given.')
  else
    Log (0, 'Access to all message bases/confs revoked.');
end;

procedure userbase;
var
  uf: file of tuserdata;
  ur: ^tuserdata;
begin
  Send (Cls);
  assign (uf, uc. datapath + 'users.dat');
  reset (uf);
  getmem (ur, sizeof (tuserdata));
  While not eof (uf) do begin
    read (uf, ur^);
    if ( ur^. handle <> '') and UserHasAcs (ur^, vbase. accacs) then comwriteln ('  ' + ur^. handle);
    if (_y = 24) and (more (false) = mno) then break;
  end;
  close (uf);
  freemem (ur, sizeof (tuserdata));
  comwrite ('');
  Log (1, 'Lited users w/ acs to message base "' + vbase. name + '"');
end;

procedure movemsgs;
begin
end;

procedure textmsgs;
begin
end;

Procedure rMsgSponsor (C: Char; P: Str100);
Begin
  Case C of
    'E': editbase; {edit}
    'K': killbase; {kill}
    'M': makebase; {make}
{}  'P': packmsgs; {pack}
    'R': reorbase; {reor}
    '@': acstoall (p [1] = '+'); {tacs}
    'L': userbase; {user}
{}  'M': movemsgs; {move}
{}  'T': textmsgs; {text}
    Else rError ('S' + C);
  End;
End;

End.
