Unit Main;
{$I Sys75.Inc}

Interface

Uses
  Spuds;

Procedure rMainMenu (C: Char; P: Str100);
Procedure ConfigUser (P: Str100);

Type
  uctxys = Array [1..23] of axy;

Var
  ucxys: ^uctxys;
  ucParsed: Boolean;

Implementation

Uses
  Dos,
  TotKey, TotStr, TotDate, TotMisc, TotFast,
  Misc, InfoForm, Emu, RemEmu, Comm, Menus, TopTen, users, EmuCodes, Parsers,
  Chats,  StatusBar, Matrix, fonts, acs, filemenu, protocols;

Var
  axyCursor: axy;

Procedure GoodBye;
Begin
  ComWriteLn (^M^J + Cs (38));
  hung := True;
End;

Procedure ConfigUser (P: Str100);
Var
  mFile,
  sFile: File of SetRec;
  curmode: byte;

  Procedure Draw (C: Char);
  Var
    Z: Char;
  Begin
    With User do begin
      Case C of
        'A': If PutAxy (ucxys^[ 1]) then ComWrite (NoYes [fseditor in options]);
        'B': If PutAxy (ucxys^[ 2]) then ComWrite (NoYes [litebars in options]);
        'C': If PutAxy (ucxys^[ 3]) then ComWrite (NoYes [hotkeys in options]);
        'D': If PutAxy (ucxys^[ 4]) then ComWrite (NoYes [ReplyRead in options]);
        'E': If PutAxy (ucxys^[ 5]) then ComWrite (NoYes [Pause in options]);
        'F': If PutAxy (ucxys^[ 6]) then
               Send (attr (Cols [1]) + PadLeft (Colorstr [Cols [1] Mod 16] + ' on ' + Colorstr [Cols [1] Div 16], 22, ' '));
        'G': If PutAxy (ucxys^[ 7]) then
               Send (attr (Cols [2]) + PadLeft (Colorstr [Cols [2] Mod 16] + ' on ' + Colorstr [Cols [2] Div 16], 22, ' '));
        'H': If PutAxy (ucxys^[ 8]) then
               Send (attr (Cols [3]) + PadLeft (Colorstr [Cols [3] Mod 16] + ' on ' + Colorstr [Cols [3] Div 16], 22, ' '));
        'I': If PutAxy (ucxys^[ 9]) then
               Send (attr (Cols [4]) + PadLeft (Colorstr [Cols [4] Mod 16] + ' on ' + Colorstr [Cols [4] Div 16], 22, ' '));
        'J': If PutAxy (ucxys^[10]) then
               Send (attr (Cols [5]) + PadLeft (Colorstr [Cols [5] Mod 16] + ' on ' + Colorstr [Cols [5] Div 16], 22, ' '));
        'K': If PutAxy (ucxys^[11]) then
               Send (attr (Cols [6]) + PadLeft (Colorstr [Cols [6] Mod 16] + ' on ' + Colorstr [Cols [6] Div 16], 22, ' '));
        'U': If PutAxy (ucxys^[23]) then
               Send (attr (Cols [7]) + PadLeft (Colorstr [Cols [7] Mod 16] + ' on ' + Colorstr [Cols [7] Div 16], 22, ' '));
        'L': If PutAxy (ucxys^[12]) then ComWrite (IntToStr (PageLen));
        'M': If PutAxy (ucxys^[13]) then ComWrite (UsrNote);
        'N': If PutAxy (ucxys^[14]) then ComWrite (IntToStr (MenuProm));
        'O': If PutAxy (ucxys^[15]) then
               If CurMenuSet. Path = '' Then
                 ComWrite ('No menu sets defined')
               Else
                 ComWrite (PadLeft (CurMenuSet. Name, 20, ' '));
        'P': If PutAxy (ucxys^[16]) then
               If CurStatSet. Path = '' Then
                 ComWrite ('No stat sets defined')
               Else
                 ComWrite (PadLeft (CurStatSet. Name, 20, ' '));
        'Q': If PutAxy (ucxys^[17]) then ComWrite (street);
        'R': If PutAxy (ucxys^[18]) then ComWrite (citystate);
        'S': If PutAxy (ucxys^[19]) then ComWrite (noyes [userip in options]);
        'T': If PutAxy (ucxys^[21]) then ComWrite (NoYes [redisp in options]);
         #0: For Z := 'A' to 'U' do
               Draw (Z);
      End;
    End;
  End;

Var
  C: Char;
Begin
  GetMem (ucxys, Sizeof (ucxys^));
  FillChar (ucxys^, Sizeof (ucxys^), 0);

  Assign (mFile, Uc. DataPath + 'MenuSet.Dat');
  {$I-}
  Reset (mFile);
  {$IFDEF Debug}{$I+}{$ENDIF}
  If IoResult = 0 Then Begin
    Seek (mFile, Pred (User. MenuSet));
    Read (mFile, CurMenuSet);
  End;

  Assign (sFile, Uc. DataPath + 'StatSet.Dat');
  {$I-}
  Reset (sFile);
  {$IFDEF Debug}{$I+}{$ENDIF}
  If IoResult = 0 Then Begin
    Seek (sFile, Pred (User. StatSet));
    Read (sFile, CurStatSet);
  End;

  If P = '' Then P := 'ConfScr.Ans';

  reallyunabortable := true;
  If (Pos (':', P) <> 0) Or (Pos ('\', P) <> 0) Then
    ShowFileProc (P, UserConfigProc)
  Else If (CurStatSet. Path <> '') And Exist (CurStatSet. Path + P) Then
    ShowFileProc (CurStatSet. Path + P, UserConfigProc)
  Else
    ShowFileProc (Uc. DispPath + P, UserConfigProc);

  GetAxy (axyCursor);
  Draw (#0);
  PutAxy (axyCursor);

  Repeat
    C := uCase (ReadInChar);
    if hung then break;
    With User do Case C of
      'Q': Break;
      'F': If PutAxy (ucxys^[ 1]) then Begin
            ToggleUserOpt (fseditor);
            Draw ('A');
          End;
      'Y': If PutAxy (ucxys^[ 2]) then Begin
            ToggleUserOpt (litebars);
            Draw ('B');
          End;
      'H': If PutAxy (ucxys^[ 3]) then Begin
            ToggleUserOpt (HotKeys);
            Draw ('C');
          End;
      'R': If PutAxy (ucxys^[ 4]) then Begin
            ToggleUserOpt (replyread);
            Draw ('D');
          End;
      'D': If PutAxy (ucxys^[ 5]) then Begin
            ToggleUserOpt (pause);
            Draw ('E');
          End;
      '1': If ucxys^[ 6]. x <> 0 then Begin
            With ucxys^[20] do
              GetColor (x, y, Cols [1]);
            if hung then break;
            Draw ('F');
          End;
      '2': If ucxys^[ 7]. x <> 0 then Begin
            With ucxys^[20] do
              GetColor (x, y, Cols [2]);
            if hung then break;
            Draw ('G');
          End;
      '3': If ucxys^[ 8]. x <> 0 then Begin
            With ucxys^[20] do
              GetColor (x, y, Cols [3]);
            if hung then break;
            Draw ('H');
          End;
      '4': If ucxys^[ 9]. x <> 0 then Begin
            With ucxys^[20] do
              GetColor (x, y, Cols [4]);
            if hung then break;
            Draw ('I');
          End;
      '5': If ucxys^[10]. x <> 0 then Begin
            With ucxys^[20] do
              GetColor (x, y, Cols [5]);
            if hung then break;
            Draw ('J');
          End;
      '6': If ucxys^[11]. x <> 0 then Begin
            With ucxys^[20] do
              GetColor (x, y, Cols [6]);
            if hung then break;
            Draw ('K');
          End;
      '7': If ucxys^[23]. x <> 0 then Begin
            With ucxys^[20] do
              GetColor (x, y, Cols [7]);
            if hung then break;
            Draw ('U');
          End;
      'G': If PutAxy (ucxys^[12]) then Begin
            case pagelen of
              0..24: pagelen := 27;
              25..27: pagelen := 29;
              28..29: pagelen := 42;
              30..42: pagelen := 49;
              49..255: pagelen := 24;
            end;
            Draw ('L');
          End;
      'U': If PutAxy (ucxys^[13]) and b (uc. options, usernoteedit) then Begin
            if sx2 - _x < 30 then
              getstr (sx2 - _x, true, false, usrnote)
            else
              getstr (30, true, false, usrnote);
            if hung then break;
            Draw ('M');
          End;
      'P': If PutAxy (ucxys^[14]) then Begin
            Draw ('N');
          End;
      'M': If (CurMenuSet. Path <> '') And PutAxy (ucxys^[15]) then Begin
            If FilePos (mFile) = FileSize (mFile) Then
              MenuSet := 1
            Else
              Inc (MenuSet);
            Seek (mFile, Pred (MenuSet));
            Read (mFile, CurMenuSet);
            Draw ('O');
          End;
      'S': If (CurStatSet. Path <> '') And PutAxy (ucxys^[16]) then Begin
            If FilePos (sFile) = FileSize (sFile) Then
              StatSet := 1
            Else
              Inc (StatSet);
            Seek (sFile, Pred (StatSet));
            Read (sFile, CurStatSet);
            Draw ('P');
          End;
      'A': If PutAxy (ucxys^[17]) then Begin
            if sx2 - _x < 30 then
              getcapstr (sx2 - _x, 'P', true, false, street)
            else
              getcapstr (30, 'P', true, false, street);
            if hung then break;
            Draw ('Q');
          End;
      'L': If PutAxy (ucxys^[18]) then Begin
            if sx2 - _x < 30 then
              getcapstr (sx2 - _x, 'P', true, false, citystate)
            else
              getcapstr (30, 'P', true, false, citystate);
            if hung then break;
            Draw ('R');
          End;
      'E': If PutAxy (ucxys^[19]) then Begin
            toggleuseropt (userip);
            Draw ('S');
          End;
      'O': If PutAxy (ucxys^[21]) then Begin
            ToggleUserOpt (redisp);
            Draw ('T');
          End;
      'Z': If PutAxy (ucxys^[22]) then Begin
            { DefArcType }
            Draw ('U');
          End;
      Else
        Continue;
    End;

    If hung Then Break;
    PutAxy (axyCursor);
  Until False;

  Log (0, 'Configured account');

  Seek (mFile, Pred (User. MenuSet));
  Read (mFile, CurMenuSet);
  Close (mFile);

  Seek (sFile, Pred (User. StatSet));
  Read (sFile, CurStatSet);
  Close (sFile);

  with user do if pagelen <= 25 then
    curmode := 25
  else if pagelen <= 28 then
    curmode := 28
  else if pagelen <= 30 then
    curmode := 30
  else if pagelen <= 43 then
    curmode := 43
  else
    curmode := 50;

  if statbar <> 0 then screen^. partclear (1, currentmode, 80, currentmode, 0, ' ');
  if curmode <> currentmode then setmode (curmode, true);
  curpagelen := user. pagelen;

  if statbar <> 0 then begin
    newstatbar := true;
    showstatus;
  end;

  comwriteln ('');
  FreeMem (ucxys, Sizeof (ucxys^));
End;

Var
  tu: tUserData;
  nu: Word;
  ulparsed: boolean;

Procedure UserLister (C: Char);
var
  s: string;
Begin
  if ulparsed then begin
    With tu do Case C of
      '#': s := IntToStr (nu);
      'H': s := Handle;
      'L': s := IntToStr (Sl);
      'N': s := UsrNote;
      'A': s := Copy (ph, 1, 3);
      'C': s := DateStr (laston. d);
      Else s := '@' + C;
    End;
    comwrite (padd (s));
    ulparsed := false;
  End else if c = '@' then ulparsed := true else comwritech (c);
End;

Procedure ListUsers;
Var
  Path: DirStr;
  uf: File of tUserData;
Begin
  Assign (uf, Uc. DataPath + 'Users.Dat');
  {$I-}
  Reset (uf);
  {$IFDEF Debug}{$I+}{$ENDIF}
  If IoResult <> 0 Then Exit;

  If Exist (CurStatSet. Path + 'Users.*') Then
    Path := CurStatSet. Path
  Else
    Path := Uc. DispPath;

  ShowFile (Path + 'Users.Top', False, True);
  if not InputBroke then For nu := 1 to FileSize (uf) do Begin
    Read (uf, tu);
    if tu. handle = '' then continue;
    ulparsed := false;
    ShowFileProc (Path + 'Users.Mid', UserLister);
    if InputBroke then break;
  End;

  Close (uf);
  if not InputBroke then
    ShowFile (Path + 'Users.Bot', False, True)
  else
    comwriteln ('|UR' + ^M^J);
  Log (0, 'Listed system users');
End;

Procedure ChatSysop (P: Str100);
Var
  S: String;
Begin
  ComWriteLn ('');

  If not sysopacs and not cosysopacs and (ChatTries >= Uc. ChatTimes) Then Begin
    ComWriteLn (Cs (35)); {Too many pages}
    Exit;
  End;

  ComWriteLn (^M^J + Cs (123)); {Requesting chat}
  If hung Then Exit;

  ComWriteLn ('');

  p := setupper (p);

  if sysopacs or cosysopacs then p := p + 'A';

  If (pos ('A', p) = 0) and Not B (vToggles, 8) Then Begin
    ComWriteLn (Cs (18)); {Sysop is not available}
    ComWrite (Cs (42)); {Is this an emergency?}
    If LiteBar (lbNo, False, true) = lbYes Then Begin
      If Uc. Chatpw <> '' Then Begin
        If not spuds. b (uc. options, localsec) Then begin
          If _y = 1 then
            if statbar = 0 then
              SnapShotOff := currentmode
            else
              SnapShotOff := pred (currentmode)
          else
            SnapShotOff := 1;
          Move (Mem [Seg (Screen^. ScreenPtr^):Ofs (Screen^. ScreenPtr^) + SnapShotOff], SnapShot, 160);
          Screen^. PartClear (1, SnapShotOff, 80, SnapShotOff, $17, ' ');
          Screen^. WritePlain (1, SnapShotOff, ' Chat pw = ' + Uc. ChatPW + '  ' + Replicate (30, ' ') + ' ');
          specialbar := true;
        end;

        ComWrite (Cs (50)); {Chat password: }
        S := '';
        GetPwStr (14 + Length (Uc. ChatPW), False, True, S);

        If not spuds. b (uc. options, localsec) Then
          Move (SnapShot, Mem [Seg (Screen^. ScreenPtr^):Ofs (Screen^. ScreenPtr^) + SnapShotOff], 160);

        ComWriteln (^J);

        If S <> SetLower (Uc. ChatPW) Then begin
          Log (2, 'Entered incorrect password chatting sysop');
          Log (2, '  Entered: ' + s);
          Exit;
        end;
      End;
    End Else Exit;
  End;

  If hung Then Exit;
  if pos ('N', p) = 0 then begin
    ComWrite (Cs (34)); {Chat reason: }
    ChatReason := '';
    GetStr (80, False, false, ChatReason);
    If hung Then Exit;
    ComWriteLn (^M^J);
    If Strip ('A', ' ', ChatReason) = '' Then Exit;
  end;

  Inc (ChatTries);
  Log (2, 'Paged sysop for chat');
  Log (2, '  Reason: ' + chatreason);
  ComWriteLn (Cs (99)); {Paging sysop}
  PageSysop (True);
  ComWriteLn (^M^J);
End;

procedure transferuser;
var
  hand: handlestr;
  tu: ^tuserdata;
  rec: word;
begin
  comwrite (^M^J + cs (168));
  hand := '';
  getstr (30, false, false, hand);
  comwriteln ('');
  if hung or (hand = '') or (setupper (hand) = setupper (user. handle)) then exit;

  if not lookupuser (hand, rec) then begin
    comwriteln (cs (9));
    exit;
  end;

  getmem (tu, sizeof (tuserdata));
  readuserrec (tu^, rec);

  if (cosysopacs and (tu^. sl >= user. sl)) or (not sysopacs and not cosysopacs) then begin
    comwrite (^M^J + cs (12));
    hand := '';
    GetPwStr (0, false, false, hand);
    comwriteln ('');
    if hung or (hand = '') or (setupper (hand) <> setupper (tu^. pw)) then begin
      freemem (tu, sizeof (tuserdata));
      log (2, 'Entered wrong password changing to user ' + tu^. handle);
      log (2, '  Entered: ' + hand);
      exit;
    end;
  end;

  log (2, 'CHANGED TO USER ' + tu^. handle);
  freemem (tu, sizeof (tuserdata));
  byeuser;
  vbatch^. emptylist;
  ubatch^. emptylist;
  fillchar (batch, sizeof (batch), 0);
  readuserrec (user, rec);
  if checkaccess then UpdateCurUserStat else hung := true;
end;

Procedure rMainMenu (C: Char; P: Str100);
Begin
  Case C of
    'Z': Unsupported;
    'M': Unsupported;
    'A': Unsupported;
    'C': ChatSysop (P);
    'F': FillOutFormFile (P);
    'G': GoodBye;
    'H': hung := True;
    'I': FillOutInfoform (StrToInt (P));
    'K': ConfigUser (P);
    'L': ListUsers;
    'S': Unsupported;
    'U': Unsupported;
    'V': Unsupported;
    'W': ShowLastCallers (StrToInt (P));
    'X': transferuser;
    'Y': pFile ('UserStat.*');
    '+': Begin
           ComWriteln ('');
           user. pw := Makepw (false, true);
           Log (0, 'Changed password');
           ComWriteln ('');
         End;
    Else rError ('[' + C);
  End;
End;

End.
