Unit HostMode;
{$I Sys75.Inc}

Interface

Uses
  Spuds;

Type
  pBBSObj = ^BBSObj;
  BBSObj = Object
             Constructor Init;
             Procedure   FindBaudRate;
             Procedure   ResetBBSVars;
             Procedure   StartUp;
             Procedure   WellCum;
             Procedure   Disconnect;
             Procedure   Run (Auto, Remote: Boolean);
             Procedure   CloseUp;
             Destructor  Done;
           End;

Var
  BBS: pBBSObj;

Implementation

Uses
  Dos, Crt, Hookers,
  TotFast, TotInput, TotKey, TotStr, TotLink, TotMisc, TotSys, TotDate,
  ApMisc, OoModem, OoCom, ApPort,
  Comm, Emu, RemEmu, Fonts, EmuCodes, ScrBack, Misc, Users, ScrSave,
  Scripts, Menus, Chats, Matrix, Events, StatusBar, Protocols, InfoForm, Regs,
  BlackLst, sysop, crunches, filespon, msgspon;

Constructor BBSObj. Init;
Begin
End;

Procedure BBSObj. FindBaudRate;
Const
  numbauds = 13;
  Bauds: Array [1..numbauds] of LongInt = (300, 1200, 2400, 4800, 9600, 14400, 16800, 19200, 21600, 24000, 26400, 28800,
                                           33600);
Var
  A, B: Byte;
  C, D: Word;
Begin
  if localonly then exit;
  Uart^. FlushInBuffer;
  Uart^. FlushOutBuffer;

  ComWrite (#27'[0m'^M^J'Auto-detecting baud rate, please hold...'#27'[0;30m');
  Uart^. DrainOutBuffer (100);

  With Modem^ do Begin
    Uart^. FlushInBuffer;
    iDelay (750);
    Uart^. FlushInBuffer;
    iDelay (200);
    Uart^. PutChar (chr (commandchar));
    iDelay (250);
    Uart^. PutChar (chr (commandchar));
    iDelay (250);
    Uart^. PutChar (chr (commandchar));

    GetModemResponse (60);

    hung := not uart^. checkdcd;
    if hung then exit;

    If AsyncStatus = ecOk Then Begin
      SetModemOnline;
      if AsyncStatus mod 10000 = ecConnect Then Begin
        BaudRate := GetConnectSpeed;
        ComWriteLn (#27'[0m'^M^J);
        Exit;
      End;
    End;
  End;

  hung := not uart^. checkdcd;
  if hung then exit;

  Uart^. FlushInBuffer;
  Uart^. FlushOutBuffer;

  ComWriteLn (#27'[0m'^M^J);
  ComWriteln ('Could not auto-detect baud rate. You must select the correct rate.');
  ComWriteln ('Press [Space Bar] to advance to next baud, [Enter] to accept.'^M^J);

  For A := 1 to 5 do Begin
    For B := 1 to numbauds do Begin
      ComWrite (^M + ' Trying ' + IntToStr (Bauds [B]) + '...             '^M'');
      For C := 1 to 2000 do Begin
        D := ReadInputNW;
        If Hung Then Exit;
        If (D = 32) Or (D = 13) Then Break;
        iDelay (1);
      End;
      If D = 13 Then Break;
    End;
    If D = 13 Then Break;
  End;

  If D <> 13 Then Begin
    ComWriteln (^M^J'Could not determine baud rate, disconnecting...');
    Log (2, 'Disconnected caller due to unknown baud rate');
    Hung := True;
    exit;
  End else comwriteln ('');

  BaudRate := Bauds [B];
End;

Procedure BBSObj. ResetBBSVars;
Begin
  If Online Then begin
    HighestEmu := TermTTY;
    detectedemu := [termtty];
  end;

  hung := False;
  stayon := false;
  ResumeXfer := false;
  clearfirst := false;
  reliablepagelen := false;
  uselog := false;
  allowpads := true;
  allowflagedit := false;
  tmpfspons := false;
  tmpmspons := false;
  SpecialBar := False;
  LoginCombo := False;
  TmpSysop   := False;
  TextTrap   := False;
  PwError    := 0;
  SysPwError := 0;
  HandleError:= 0;
  NupError   := 0;
  SysValidated := False;
  SystemLaunched := False;
  InputTimer := True;
  CurTimeOn := 0;
  ChatTries := 0;
  Chatted := false;
  StatBar := Uc. DefStatBar;
  Current := Board;
  Applied := False;
  JustApplied := False;
  NoKbdPress := 0;
  allowedituser := true;
  allowruncfg := true;
  curpagelen := 25;
  insertmode := true;
End;

Procedure BBSObj. StartUp;
Begin
  uselog := true;
  InsertMode := True;
  if online then {begin
    ResetBBSVars;}
    Prep (False, False, '');
{  end;}
  defuser;
  InputTimer := True;
  Scroll^. Clear;
End;

{$I ns.pas}

Procedure BBSObj. WellCum;
Var
  ts: string;
Begin
  If Online Then Begin
    fillin1 := IntToStr (BaudRate);
    If BaudRate >= 10000 Then Begin
      Delete (fillin1, Pred (Length (fillin1)), 2);
      Insert ('.', fillin1, Length (fillin1));
      fillin1 := Strip ('R', '.', Strip ('R', '0', fillin1)) + 'k';
    End;

    ComWriteln (cs (188));

    DetectRemTerm;
  End;

  if hung then exit;
  UsingRip := Spuds. B (Uc. Options, IsRipOn) And (TermRIP in DetectedEmu);

  if sysauto then exit;

  {$IFNDEF Rolfi}
  ComWrite  ('|08%CS');
  uncrunch (nooroziz, mem [seg (screen^. screenptr^): 0], nooroziz_length);
  if online then refresh;
  send (goxy (1, 15));

  If Registered Then Begin
    ts := '|08this copy of |15S|07ys|08tem/|157|075 |08is registered to: [|15' + Uc. SysopName + '|08]';
    ComWriteAt ((80 - 43 - Length (Uc. SysopName)) Div 2, _y, ts);
  End;

  ComWriteln ('');

  if hung then exit;
  ComWriteln ('');

  If Not Registered Then Begin
    ts := '|08Convince |07%SN|08 to register this copy of |15S|07ys|08tem|15/|077|085 ' +
          '|15B|07B|08S|16!|07!|08!';
    ComWriteAt ((80 - 50 - Length (Uc. SysopName)) Div 2, _y, ts);
    ComWriteLn (^M^J'|01             Registered copies do not have the |095|01 second delay|09!');
    iDelay (5000);
    If Not LocalOnly Then Uart^. FlushInBuffer;
    Key^. FlushBuffer;
  End;
  {$ENDIF Rolfi}
  if hung then exit;
  ComWriteLn (Cs (20));
End;

Procedure BBSObj. Disconnect;
Var
  F: File;
  L: LongInt;
  S: String;
Begin
  L := BiosTime;
  If Not LocalOnly And Online And Not SystemLaunched Then Begin
    If Uart^. CheckDCD Then Begin
      Uart^. DrainOutBuffer (540);

      If Uart^. CheckDCD then if HighestEmu > TermTTY Then Begin
        Uart^. PutStringtimeout (^['[6n', 180);
        Uart^. GetStringTimeout (S, 255, ['['], 180);
        Uart^. PutStringTimeOut (Attr (7), 180);
      End Else
        iDelay (5000);
    End;

    L := BiosTime;

    While Uart^. CheckDCD do Begin
      Modem^. HangUpModem (mHangUp, True);
      iDelay (500);
      If Not Uart^. CheckDCD Then Break;

      Modem^. HangUpModem (mHangUp, False);
      iDelay (1000);
      If Not Uart^. CheckDCD Then Break;

      If Et (L) >= 540 Then Halt (11);
    End;

    InitModem (0);
  End;
End;

Procedure BBSObj. CloseUp;
Begin
  If Not SystemLaunched Then Log (2, 'User logged off.');
  with user do If Handle <> '' Then byeuser;
End;

Procedure BBSObj. Run (Auto, Remote: Boolean);
Var
  Rec: Word;
  S: PwStr;
Label
  Dropped;
Begin
  Online := Remote;
  SysAuto := Auto;
  StartUp;

  If Remote Then Begin
    If BaudRate = 0 Then BaudRate := Modem^. GetConnectSpeed;
    If BaudRate = 0 Then FindBaudRate;
  End;

  if hung then goto dropped;

  vAllowChat := True;

  If Online and (BaudRate < NodeData.  LogonBaud) Then
    If Uc. LockOutBaudPw <> '' Then Begin
      If not spuds. b (uc. options, localsec) Then begin
        If _y = 1 then
          if statbar = 0 then
            SnapShotOff := currentmode
          else
            SnapShotOff := pred (currentmode)
        else
          SnapShotOff := 1;
        Move (Mem [Seg (Screen^. ScreenPtr^):Ofs (Screen^. ScreenPtr^) + Pred (SnapShotOff) * 160], SnapShot, 160);
        Screen^. PartClear (1, SnapShotOff, 80, SnapShotOff, $17, ' ');
        Screen^. WritePlain (1, SnapShotOff, ' Baud pw = ' + Uc. LockOutBaudPw + '  ' + Replicate (30, ' ') + ' ');
        specialbar := true;
      end;

      ComWrite (Cs (89)); {Baud password: }
      S := '';
      GetPwStr (14 + Length (Uc. LockOutBaudPW), False, True, S);
      If Hung Then Goto Dropped;

      If not spuds. b (uc. options, localsec) Then
        Move (SnapShot, Mem [Seg (Screen^. ScreenPtr^):Ofs (Screen^. ScreenPtr^) + Pred (SnapShotOff) * 160], 160);

      ComWriteln (^J);

      If S <> SetLower (Uc. LockOutBaudPw) Then Hung := True;
    End Else Hung := True;

  If Hung Then Goto Dropped;

  If Online Then Begin
    Write (LogFile, '> ', CurrentTime (False), '  Modems connected at ', BaudRate);
    if modem^. getlasterrormode then Write (LogFile, ' [EC]');
    writeln (logfile);
    User. Options := User. Options - [LiteBars];
    AddCaller := True;
  End Else Begin
    if sysauto then
      writeln (logfile, AnsA (Uc. Colors [2], textattr) + '> ', CurrentTime (False), '  Sysop Auto-login' +
               AnsA (Uc. Colors [1], textattr))
    else
      log (2, 'Local connection');
    ComWrite(^M^J'|15A|07d|08d this local logon to last caller li|07s|15t ');
    AddCaller := LiteBar (lbNo, False, true) = lbYes;
    If hung Then Goto Dropped;
  End;

  Wellcum;
  If hung Then Goto Dropped;
  If Online And (HighestEmu > TermTTY) Then
    User. Options := User. Options + [LiteBars];

  If SysAuto Then Begin
    LoadSysopRec (false, User);
    clrscreen (7);
    if statbar <> 0 then screen^. partclear (1, currentmode, 80, currentmode, 0, ' ');
    if user. pagelen <> currentmode then setmode (succ (user. pagelen), true);
    curpagelen := user. pagelen;

    if statbar <> 0 then begin
      newstatbar := true;
      showstatus;
    end;

    if spuds. b (uc. options, localsec) and (Not GetUserPw or Hung) Then goto dropped;

    UpdateCurUserStat;
    ShowStatus;
  End;

  If Not Hung Then RunMenus ('');

  Dropped:

  If Not ExitNoDrop Then Disconnect;
  CloseUp;
  if FrontEnd or DosSysAuto or ExitNoDrop then ForceExit := 1;
End;

Destructor BBSObj. Done;
Begin
End;

End.