Unit FileMenu;
{$I Sys75.Inc}

Interface

Uses
  dos,
  totlink, totdate,
  Spuds;

type
  batchrec = record
    flname: str12;
    fp: word;
    dls: word;
    size: longint;
    ulby: handlestr;
    pw: pwstr;
    acs: acsstr;
    priv: acsstr;
    fdate: date;
    dtul: date;
    dptr: longint;
    dlen: byte;
    offline: boolean;
    resume: boolean;
    notval: boolean;
    free: boolean;
    area, conf: byte;
  end;

  bproc = function (ba: batchrec; var ar: farearec): boolean;

Procedure rFileMenu (C: Char; P: Str100);
Procedure rBatchMenu (C: Char; P: Str100);
procedure goarea (b: word; stuv: boolean);
function  inarea (fname: str12; conf, area: byte; var rec: word): boolean;
function  areafname (conf, area: byte): namestr;
procedure farea (b: byte);
procedure readarea (b: byte; var ar: farearec);

procedure download (p: str100);
procedure changefiles (p: str100);
procedure sendfiles (s: pathstr);
procedure testfiles (p: str100);
procedure typefile (p: str100);

procedure batchadd (p: str100; val: bproc);
procedure editbatch;
procedure checkfile (s: str100; val: bproc; show: boolean);
function  inbatch (db: pdllobj; fn: str12; ar, co: byte; var rec: word): boolean;
procedure add2batch (var ba: batchrec);

function  valfileexist (ba: batchrec; var ar: farearec): boolean;
function  valfiledl (ba: batchrec; var ar: farearec): boolean;
function  valfileuplder (ba: batchrec; var ar: farearec): boolean;
function  noval (ba: batchrec; var ar: farearec): boolean;

var
  varea: farearec;
  vbatch: pdllobj;
  ubatch: pdllobj;

Implementation

Uses
  TotStr, TotMisc, totfast, totkey,
  emucodes, emu, comm, RemEmu, Users, Menus, Misc, FileSpon, StatusBar,
  JoinConf, protocols, fonts, oocom, acs, archive, hostmode;

var
  areaparsed: boolean;
  count: word;
  lcfgparsed: boolean;
  ar: farearec;
  dropped: boolean;

procedure fixhung;
begin
  bbs^. disconnect;
  hung := false;
  ModemStrFix (NodeData. OffHookStr);
  online := false;
  dropped := true;
end;

function noval (ba: batchrec; var ar: farearec): boolean;
begin
  noval := false;
  fillin1 := ba. flname;
  comwriteln (cs (143));
end;

procedure farea (b: byte);
begin
  readarea (b, varea);
  curarea := b;
end;

procedure readarea (b: byte; var ar: farearec);
var
  af: file of farearec;
begin
  assign (af, uc. filepath + 'Filearea.' + inttostr (curfconf));
  {$I-}
  reset (af);
  {$IFDEF Debug}{$I+}{$ENDIF}
  if ioresult <> 0 then exit;
  seek (af, pred (b));
  read (af, ar);
  close (af);
end;

procedure add2batch (var ba: batchrec);
begin
  with ba, vbatch^, batch do begin
    inc (files);
    inc (bytes, size);
    inc (pts, fp);
    fLeft := succ (Files);
    bLeft := Bytes;
  end;
end;

function inbatch (db: pdllobj; fn: str12; ar, co: byte; var rec: word): boolean;
var
  w: word;
  b: batchrec;
begin
  inbatch := false;
  rec := 0;
  fn := setupper (fn);
  with db^ do begin
    if totalnodes = 0 then exit;
    jump (1);
    for w := 1 to totalnodes do begin
      get (b);
      with b do begin
        if (flname = fn) and ((area = ar) or (ar = 0)) and ((conf = co) or (co = 0)) then begin
          inbatch := true;
          rec := w;
          break;
        end;
      end;
      advance (1);
    end;
  end;
end;

Procedure AreaList (C: Char);
var
  s: string;
Begin
  if areaparsed then begin
    With ar do Case C of
      '#': s := IntToStr (Count);
      'N': s := name;
      'S': s := sponsor;
      Else s := '@' + C;
    End;
    comwrite (padd (s));
    areaparsed := false;
  End else if c = '@' then areaparsed := true else comwritech (c);
End;

procedure listareas;
var
  path: dirstr;
  af: file of farearec;
begin
  assign (af, uc. filepath + 'filearea.' + inttostr (curfconf));
  {$I-}
  reset (af);
  {$IFDEF Debug}{$I+}{$ENDIF}
  if ioresult <> 0 then exit;

  If Exist (CurStatSet. Path + 'Areas.*') Then
    Path := CurStatSet. Path
  Else
    Path := Uc. DispPath;

  showfile (path + 'Areas.top', false, true);
  for count := 1 to filesize (af) do begin
    read (af, ar);
    areaparsed := false;
    showfileproc (path + 'areas.mid', arealist);
    if hung then break;
  end;
  close (af);
  if not hung then showfile (path + 'areas.bot', false, true);
  Log (0, 'Listed file areas');
end;

procedure goarea (b: word; stuv: boolean);
var
  wow: byte;
  s: pwstr;
  af: file of farearec;
  path: pathstr;
  list: pdllobj;
begin
  assign (af, uc. filepath + 'FileArea.' + inttostr (curfconf));
  {$I-}
  reset (af);
  if (ioresult <> 0) or (filesize (af) = 0) then begin
    if ioresult <> 0 then ;
    close (af);
    if ioresult <> 0 then ;
    {$IFDEF Debug}{$I+}{$ENDIF}
    if sysopacs or cosysopacs then begin
      curarea := 1;
      makearea;
      goarea (curarea, true);
    end else comwriteln ('|04error: no file areas exist');
    exit;
  end;

  if b = 0 then begin
    if exist (curstatset. path + 'pdfarea.' + inttostr (curfconf)) then
      path := curstatset. path + 'pdfarea.' + inttostr (curfconf)
    else if exist (uc. disppath + 'pdfarea.' + inttostr (curfconf)) then
      path := uc. disppath + 'pdfarea.' + inttostr (curfconf)
    else if exist (curstatset. path + 'pdfarea.ans') then
      path := curstatset. path + 'pdfarea.ans'
    else if exist (uc. disppath + 'pdfarea.ans') then
      path := uc. disppath + 'pdfarea.ans'
    else
      path := '';

    if path <> '' then begin
      new (list, init);
      while not eof (af) do begin
        read (af, ar);
        list^. add (ar. pdname, 31);
      end;
      b := getpdconf (path, curarea, list);
      dispose (list, done);
      if b = 0 then path := '';
    end;

    if path = '' then begin
      listareas;
      fillin1 := inttostr (filesize (af));
      repeat
        comwrite (^M^J + cs (105));
        b := getqnumstr (false, false, 1, filesize (af), 0, 0, curarea, 0, wow, '?');
        if b > 0 then break;
        if wow = 1 then listareas;
      until hung;
    end;
  end;

  if b > filesize (af) then begin
    close (af);
    exit;
  end;

  seek (af, pred (b));
  read (af, ar);
  close (af);

  if not tmpfspons and not hasacs (ar. accacs) then begin
    comwriteln (cs (124));
    exit;
  end;

  if (ar. pw <> '') and not tmpfspons then begin
    If not spuds. b (uc. options, localsec) Then begin
      If _y = 1 then
        if statbar = 0 then
          SnapShotOff := currentmode
        else
          SnapShotOff := pred (currentmode)
      else
        SnapShotOff := 1;
      Move (Mem [Seg (Screen^. ScreenPtr^):Ofs (Screen^. ScreenPtr^) + Pred (SnapShotOff) * 160], SnapShot, 160);
      Screen^. PartClear (1, SnapShotOff, 80, SnapShotOff, $17, ' ');
      Screen^. WritePlain (1, SnapShotOff, ' Area pw = ' + ar. pw + '  ' + Replicate (30, ' ') + ' ');
      specialbar := true;
    end;

    ComWrite (Cs (127));
    If hung Then Exit;
    S := '';

    GetPwStr (14 + Length (ar. pw), False, True, S);
    If hung Then Exit;

    If not spuds. b (uc. options, localsec) Then
      Move (SnapShot, Mem [Seg (Screen^. ScreenPtr^):Ofs (Screen^. ScreenPtr^) + Pred (SnapShotOff) * 160], 160);

    ComWriteLn ('');

    If S <> SetLower (ar. pw) Then begin
      Log (1, 'Entered incorrect password joining file area "' + ar. name + '"');
      Log (1, '  Entered: ' + s);
      Exit;
    end;
  end;

  curarea := b;
  user. lastarea := b;
  varea := ar;
  fillin1 := '0';
  fillin2 := '0';
  fillin3 := varea. sponsor;
  if stuv then begin
    comwriteln (cs (190));
    Log (0, 'Changed to file area "' + ar. name + '"');
  end;
end;

function areafname (conf, area: byte): namestr;
var
  af: file of farearec;
begin
  areafname := '';
  if (conf = 0) and (area = 0) then begin
    areafname := varea. fname;
    exit;
  end;

  if conf = 0 then conf := curfconf;
  if area = 0 then area := curarea;

  assign (af, uc. filepath + 'filearea.' + inttostr (conf));
  {$I-}
  reset (af);
  {$IFDEF Debug}{$I+}{$ENDIF}
  if ioresult <> 0 then exit;
  seek (af, pred (area));
  read (af, ar);
  areafname := ar. fname;
  close (af);
end;

function inarea (fname: str12; conf, area: byte; var rec: word): boolean;
type
  tfr = array [0..255] of tfilerec;
var
  fr: ^tfr;
  ff: file;
  b: byte;
  o, w: word;
begin
  inarea := false;
  assign (ff, uc. filepath + areafname (conf, area) + '.idx');
  {$I-}
  reset (ff, 1);
  {$IFDEF Debug}{$I+}{$ENDIF}
  if ioresult <> 0 then exit;
  if filesize (ff) = 0 then begin
    close (ff);
    exit;
  end;
  getmem (fr, sizeof (tfr));
  if fr = nil then exit;
  o := 0;
  fname := setupper (fname);
  repeat
    blockread (ff, fr^, sizeof (tfr), w);
    for b := 0 to w div sizeof (tfilerec) do
      if fname = fr^ [b]. flname then begin
        freemem (fr, sizeof (tfr));
        close (ff);
        inarea := true;
        rec := o * sizeof (tfilerec) + b;
        exit;
      end;
    inc (o);
  until w <> sizeof (tfr);
  freemem (fr, sizeof (tfr));
  close (ff);
end;

type
  tslc = array [0..12] of axy;
var
  slcxys: ^tslc;

procedure showlistcfg (c: char);
Begin
  if lcfgparsed then begin
    Case C of
      '0': GetAxy (slcxys^[0]);
      '1': GetAxy (slcxys^[1]);
      '2': GetAxy (slcxys^[2]);
      '3': GetAxy (slcxys^[3]);
      '4': GetAxy (slcxys^[4]);
      '5': GetAxy (slcxys^[5]);
      '6': GetAxy (slcxys^[6]);
      '7': GetAxy (slcxys^[7]);
      '8': GetAxy (slcxys^[8]);
      '9': GetAxy (slcxys^[9]);
      'E': GetAxy (slcxys^[10]);
      'U': GetAxy (slcxys^[11]);
      Else comwrite ('@' + C);
    End;
    lcfgparsed := false;
  End else if c = '@' then lcfgparsed := true else comwritech (c);
end;

procedure ListConfig;
const
  f = ' Nifty! ';
  nu= '1.    ';
  n = 'System75';
  e = '.Wow ';
  d = '01/01/95 ';
  s = '1000k    ';
  p = ' 100 ';
  u = 'maxwell';
  du= '01/01/95 ';
  td= '  1 ';
  de= 'The coolest stuff around!';
var
  path: dirstr;
  c: char;
  combo: byte;

  Procedure Toggle (Opt: FileListOptions; p: byte);
  Begin
    With User do Begin
      If Opt In FileList Then begin
        FileList := FileList - [Opt];
        dec (combo, p);
      end Else begin
        inc (combo, p);
        if combo > 79 then
          dec (combo, p)
        else
          FileList := FileList + [Opt];
      end;
    End;
  End;

  procedure showit (c: char);
  var
    z: char;
  begin
    if c in ['0'..'9'] then with slcxys^[ord (c) - 48] do
      send (goxy (x, y) + attr (a));

    with user do case c of
      '1': send (noyes [fl_points in filelist]);
      '2': send (noyes [fl_size in filelist]);
      '3': send (noyes [fl_date in filelist]);
      '4': send (noyes [fl_dateuld in filelist]);
      '5': send (noyes [fl_timesdl in filelist]);
      '6': send (noyes [fl_uplder in filelist]);
      '7': send (noyes [fl_desc in filelist]);
      '8': send (noyes [fl_skiplines in filelist]);
      '9': send (noyes [fl_scroll in filelist]);
      '0': send (noyes [fl_tag in filelist]);
      'E': begin
             putaxy (slcxys^[10]);
             send (attr (uc. filec [1]) + nu);
             send (attr (uc. filec [2]) + n);
             send (attr (uc. filec [3]) + e);
             if fl_points in filelist then send (attr (uc. filec [4]) + p);
             if fl_size in filelist then send (attr (uc. filec [5]) + s);
             if fl_date in filelist then send (attr (uc. filec [6]) + d);
             if fl_dateuld in filelist then send (attr (uc. filec [7]) + du);
             if fl_timesdl in filelist then send (attr (uc. filec [8]) + td);
             if fl_uplder in filelist then send (attr (uc. filec [9]) + padleft (u, 30, ' '));
             if fl_desc in filelist then send (attr (uc. filec [10]) + de);
             send (clr2eol);
           end;
      'U': begin
             putaxy (slcxys^[11]);
             send (padleft (inttostr (combo), 3, ' '));
           end;
       #0: begin
             for z := '0' to '9' do
               showit (z);
             showit ('E');
             showit ('U');
           end;
    end;
  end;

begin
  comwriteln ('');

  getmem (slcxys, sizeof (tslc));

  If (CurStatSet. Path <> '') And Exist (CurStatSet. Path + 'fconfig.ans') Then
    ShowFileProc (CurStatSet. Path + 'fconfig.ans', showlistcfg)
  Else
    ShowFileProc (Uc. DispPath + 'fconfig.ans', showlistcfg);

  combo := 20;

  with user do begin
    if fl_points  in filelist then inc (combo, 6);
    if fl_size    in filelist then inc (combo, 8);
    if fl_date    in filelist then inc (combo, 9);
    if fl_dateuld in filelist then inc (combo, 9);
    if fl_timesdl in filelist then inc (combo, 4);
    if fl_uplder  in filelist then inc (combo,30);
    if fl_desc    in filelist then inc (combo,45);
  end;

  GetAxy (slcxys^[12]);
  showit (#0);

  repeat
    PutAxy (slcxys^[12]);
    c := readinchar;
    if hung then break;
    case ucase (c) of
      'Q': Break;
      '1': toggle (fl_points, 6);
      '2': toggle (fl_size, 8);
      '3': toggle (fl_date, 9);
      '4': toggle (fl_dateuld, 9);
      '5': toggle (fl_timesdl, 4);
      '6': toggle (fl_uplder, 30);
      '7': toggle (fl_desc, 45);
      '8': toggle (fl_skiplines, 0);
      '9': toggle (fl_scroll, 0);
      '0': toggle (fl_tag, 0);
      else continue;
    end;
    showit (c);
    showit ('E');
    showit ('U');
  until hung;

  freemem (slcxys, sizeof (tslc));
  comwriteln ('');
  Log (0, 'Configured file listings');
end;

procedure ListFiles (p: str100);
type
  str45 = string [45];
  prompttype = (abort, cont, back, again);
var
  wc: string [12];
  low, high: longint;
  skipped, topopage, temp: word;
  showed, shaudy: boolean;
  dizl,
  top: byte;
  ff: file of tfilerec;
  fr: tfilerec;
  df: file of str45;
  sizes: string [6];
  s: str45;
  temp2: byte;

  function upddiz (up: boolean): boolean;
  var
    b: byte;
  begin
    if termavt in detectedemu then begin
      if up then
        seek (df, fr. dptr + dizl - (pred (curpagelen) - top))
      else
        seek (df, fr. dptr + pred (dizl));

      read (df, s);

      if up then begin
        send (^V^K^A+chr(top)+chr(34)+chr(top+pred(pred(curpagelen)-top))+chr(80));
        comwriteat (34, top, s)
      end else begin
        send (^V^J^A+chr(top)+chr(34)+chr(top+pred(pred(curpagelen)-top))+chr(80));
        comwriteat (34, top + pred (pred (curpagelen) - top), s);
      end;
      send (clr2eol);
    end else begin
      send (goxy (34, top));
      {$I-}
      seek (df, fr. dptr + dizl - (pred (curpagelen) - top));
      {$IFDEF Debug}{$I+}{$ENDIF}
      if ioresult <> 0 then
        comwrite ('Invalid description.')
      else for b := 1 to pred (curpagelen) - top do begin
        read (df, s);
        comwriteat (34, top + pred (b), s);
        send (clr2eol);
      end;
    end;

    if dizl >= fr. dlen then
      upddiz := true
    else
      upddiz := false;
    comwriteln ('');
  end;

  function prompt (shniznitz: boolean): prompttype;
  var
    cum, o: word;
    c: char;
    sam: moretype;
    baris: word;
    b, savey: byte;
    save: axy;
    slp: longint;
    joemama,
    rec, sp: word;
    fr2: tfilerec;
    ba: batchrec;

    procedure redo (boobs: boolean);
    var
      b: byte;
    begin
      if boobs then begin
        send (cls);
        reallyunabortable := true;
        if not hung then comwriteln (cs (192));
      end else
        for b := curpagelen downto top do
          send (goxy (1, b) + clr2eol);
    end;

  begin
    baris := 0;
    if not (fl_skiplines in user. filelist) then send (clr2eol + ^M^J);
    comwrite (cs (132));
    send (clr2eol);
    sp := filepos (ff);
    if shaudy or not shniznitz then
      joemama := temp
    else begin
      joemama := pred (temp);
{      if shaudy then inc (joemama);}
    end;
    getaxy (save);

    repeat
      o := readarrow;
      if hung then break;
      if o < 256 then begin
        c := ucase (chr (lo (o)));
        if ((c = 'P') or (c = 'N')) and not shaudy then continue;
        if pos (c, ^M'BTVIJ?QAHDECMPN ') = 0 then continue;
        case c of
           ^M: begin
                 seek (ff, sp);
                 prompt := cont;
                 topopage := temp;
                 if shaudy then inc (topopage);
                 if shniznitz then begin
                   for b := curpagelen downto top do
                     send (goxy (1, b) + clr2eol);
                 end;
                 shaudy := false;
                 baris := 0;
                 break;
               end;
          'B': begin
                 baris := 0;
                 if topopage = low then begin
                   prompt := again;
                   temp := pred (topopage);
                 end else begin
                   prompt := back;
                   temp := topopage;
                   cum := 0;
                   while temp > 1 do begin
                     dec (temp);
                     seek (ff, pred (temp));
                     read (ff, fr2);

                     if not fitswildcard (fr2. flname, wc) then continue;
                     if not (fl_desc in user. filelist) then fr2. dlen := 1;

                     inc (cum, fr2. dlen);

                     if (fr2. dlen >= pred (curpagelen) - top) and (cum = fr2. dlen) then
                       break
                     else if cum >= pred (curpagelen) - top then begin
                       inc (temp);
                       break;
                     end;
                     if fl_skiplines in user. filelist then inc (cum);
                   end;
                   topopage := temp;
                   dec (temp);
                 end;

                 if hung then break;
                 redo (false);
                 temp := pred (topopage);
                 seek (ff, temp);
                 shaudy := false;
                 break;
               end;
          'T': begin
                 prompt := again;
                 ttypauser := 0;
                 comwriteln ('');
                 if baris = 0 then
                   typefile ('')
                 else
                   typefile (fr2. flname);

                 if hung then break;
                 redo (true);
                 pressenter;
                 if hung then break;
                 temp := pred (topopage);
                 seek (ff, temp);
                 shaudy := false;
                 break;
               end;
          'V':; { view file archive }
          'I':; { info on file }
          'J':; { jump to next area [in new scans]}
          'A': begin {test archive}
                 prompt := again;
                 comwriteln ('');
                 if baris = 0 then
                   testfiles ('')
                 else
                   testfiles (fr2. flname);
                 if hung then break;
                 pressenter;
                 if hung then break;
                 baris := 0;
                 redo (true);
                 temp := pred (topopage);
                 seek (ff, temp);
                 shaudy := false;
                 break;
               end;
          'D': begin
                 prompt := again;
                 comwriteln ('');
                 if baris = 0 then
                   download ('')
                 else
                   download (fr2. flname);
                 if hung then break;
                 redo (true);
                 temp := pred (topopage);
                 seek (ff, temp);
                 shaudy := false;
                 break;
               end;
          'E': begin {del file}
                 prompt := again;
                 close (ff);
                 comwriteln ('');
                 if baris = 0 then
                   delfiles ('')
                 else
                   delfiles (fr2. flname);
                 if hung then break;
                 reset (ff);
                 if high > filesize (ff) then high := filesize (ff);
                 baris := 0;
                 temp := 0;
                 if high <> 0 then
                   redo (true)
                 else
                   showed := false;
                 break;
               end;
          'C': begin
                 prompt := again;
                 close (ff);
                 comwriteln ('');
                 if baris = 0 then
                   changefiles ('')
                 else
                   changefiles (fr2. flname);
                 if hung then break;
                 reset (ff);
                 if high > filesize (ff) then high := filesize (ff);
                 baris := 0;
                 temp := 0;
                 if high <> 0 then
                   redo (true)
                 else
                   showed := false;
                 break;
               end;
          'M': if fspons then begin
                 prompt := again;
                 close (ff);
                 comwriteln ('');
                 if baris = 0 then
                   movefiles (true, '')
                 else
                   movefiles (true, fr2. flname);
                 if hung then break;
                 reset (ff);
                 if high > filesize (ff) then high := filesize (ff);
                 baris := 0;
                 temp := 0;
                 if high <> 0 then
                   redo (true)
                 else
                   showed := false;
                 break;
               end;
          'H': if fspons then begin
                 prompt := again;
                 comwriteln ('');
                 if baris = 0 then
                   movefiles (false, '')
                 else
                   movefiles (false, fr2. flname);
                 if hung then break;
                 temp := pred (topopage);
                 seek (ff, temp);
                 redo (true);
                 shaudy := false;
                 break;
               end;
          'P': begin
                 if (fl_desc in user. filelist) and (dizl <> pred (curpagelen) - top) then begin
                   dec (dizl);
                   send (attr (uc. filec [10]));
                   upddiz (true);
                 end;
                 if hung then break;
                 putaxy (save);
               end;
          'N': begin
                 if (fl_desc in user. filelist) and (dizl < fr. dlen) then begin
                   inc (dizl);
                   send (attr (uc. filec [10]));
                   upddiz (false);
                 end;
                 if hung then break;
                 putaxy (save);
               end;
          ' ': if baris <> 0 then begin
                 seek (ff, pred (baris));
                 read (ff, fr2);
                 if not (fl_desc in user. filelist) then fr2. dlen := 1;
                 send (goxy (6, savey));
                 if inbatch (vbatch, fr2. flname, curarea, curfconf, rec) then begin
                   with vbatch^ do
                     delnode (nodeptr (rec));
                   comwrite ('|UV ');
                 end else if fspons or (inuserlist (fr2. priv) and hasacs (fr2. acs)) then begin
                   move (fr2, ba, sizeof (fr2));
                   with ba do begin
                     conf := curfconf;
                     area := curarea;
                   end;
                   vbatch^. add (ba, sizeof (ba));
                   add2batch (ba);
                   comwrite ('|UV' + uc. tagchar);
                 end;
                 putaxy (save);
                 if fl_tag in user. filelist then o := kdown;
               end;
          'Q': begin
                 prompt := abort;
                 break;
               end;
          '?': begin
                 TTYPauser := 0;
                 comwriteln ('');
                 showfile (uc. helppath + 'filelist.hlp', true, true);
                 if hung then break;
                 pressenter;
                 if hung then break;
                 redo (true);
                 temp := pred (topopage);
                 shaudy := false;
                 seek (ff, temp);
                 prompt := again;
                 break;
               end;
        end;
      end;

      if o > 255 then begin
        case o of
          kup: begin
                 if baris <> 0 then begin
                   seek (ff, pred (baris));
                   while filepos (ff) > 0 do begin
                     read (ff, fr2);
                     if fitswildcard (fr2. flname, wc) then break;
                     dec (baris);
                     if not (fl_desc in user. filelist) then fr2. dlen := 1;
                     seek (ff, filepos (ff) - 2);
                     if hung then break;
                   end;
                   if hung then break;
                   send (goxy (6, savey) + attr (uc. filec [2]));
                   if inbatch (vbatch, fr2. flname, curarea, curfconf, rec) then
                     send (uc. tagchar)
                   else
                     send (' ');
                   send (padleft (setupper (filename (fr2. flname)), 8, ' '));
                   send (attr (uc. filec [3]) + padleft ('.' + setupper (fileext (fr2. flname)), 5, ' '));
                 end;
                 if baris = topopage then
                   baris := 0
                 else if baris = 0 then begin
                   savey := save. y;
                   if not (fl_skiplines in user. filelist) then dec (savey);
                   baris := joemama;
                 end else
                   dec (baris);
                 if baris <> 0 then begin
                   seek (ff, pred (baris));
                   while true do begin
                     read (ff, fr2);
                     if fitswildcard (fr2. flname, wc) then break;
                     dec (baris);
                     if not (fl_desc in user. filelist) then fr2. dlen := 1;
                     if filepos (ff) = 1 then break;
                     seek (ff, filepos (ff) - 2);
                     if hung then break;
                   end;
                   if hung then break;
                   if baris <> 0 then begin
                     if shaudy then
                       dec (savey, pred (curpagelen) - top)
                     else
                       dec (savey, fr2. dlen);
                     if fl_skiplines in user. filelist then dec (savey);
                     send (goxy (6, savey));
                     usercol (5);
                     if inbatch (vbatch, fr2. flname, curarea, curfconf, rec) then
                       send (uc. tagchar)
                     else
                       send (' ');
                     send (padleft (setupper (filename (fr2. flname)), 8, ' '));
                     send (padleft ('.' + setupper (fileext (fr2. flname)), 5, ' '));
                   end;
                 end;
                 putaxy (save);
               end;
        kdown: begin
                 if baris <> 0 then begin
                   seek (ff, pred (baris));
                   while not eof (ff) do begin
                     read (ff, fr2);
                     if fitswildcard (fr2. flname, wc) then break;
                     if not (fl_desc in user. filelist) then fr2. dlen := 1;
                     inc (baris);
                     if hung then break;
                   end;
                   if hung then break;
                   send (goxy (6, savey) + attr (uc. filec [2]));
                   if inbatch (vbatch, fr2. flname, curarea, curfconf, rec) then
                     send (uc. tagchar)
                   else
                     send (' ');
                   send (padleft (setupper (filename (fr2. flname)), 8, ' '));
                   send (attr (uc. filec [3]) + padleft ('.' + setupper (fileext (fr2. flname)), 5, ' '));
                 end;
                 if baris = joemama then
                   baris := 0
                 else if baris = 0 then begin
                   baris := topopage;
                   savey := top;
                 end else
                   inc (baris);
                 if baris <> 0 then begin
                   if baris <> topopage then begin
                     if shaudy then
                       inc (savey, pred (curpagelen) - top)
                     else
                       inc (savey, fr2. dlen);
                     if fl_skiplines in user. filelist then inc (savey);
                   end;
                   seek (ff, pred (baris));
                   while not eof (ff) do begin
                     read (ff, fr2);
                     if fitswildcard (fr2. flname, wc) then begin
                       if not (fl_desc in user. filelist) then fr2. dlen := 1;
                       if fr2. dlen > succ (pred (curpagelen) - succ (savey)) then baris := 0;
                       break;
                     end;
                     if eof (ff) then begin
                       baris := 0;
                       break;
                     end else inc (baris);
                     if hung then break;
                   end;
                   if hung then break;
                   if baris <> 0 then begin
                     send (goxy (6, savey));
                     usercol (5);
                     if inbatch (vbatch, fr2. flname, curarea, curfconf, rec) then
                       send (uc. tagchar)
                     else
                       send (' ');
                     send (padleft (setupper (filename (fr2. flname)), 8, ' '));
                     send (padleft ('.' + setupper (fileext (fr2. flname)), 5, ' '));
                   end;
                 end;
                 putaxy (save);
               end;
        end;
      end;
    until hung;
  end;

  function listfile: boolean;
  var
    pt: prompttype;
    rec: word;
  begin
    listfile := false;
    read (ff, fr);
    if not (fl_desc in user. filelist) then fr. dlen := 1;
    with fr, uc, user do begin
      if fitswildcard (flname, wc) then begin
        if not showed then begin
          send (cls);
          reallyunabortable := true;
          if not hung then comwriteln (cs (192));
          top := _y;
          showed := true;
        end;
        if dlen >= pred (curpagelen) - _y then begin
          if top <> _y then begin
            pt := prompt (true);
            if hung or (pt = abort) then begin
              listfile := true;
              exit;
            end else if pt <> cont then exit;
          end;
          shaudy := (dlen > pred (curpagelen) - top);
        end;

        if size < 1000 then
          sizes := inttostr (size)
        else
          sizes := inttostr (size div 1024) + 'k';

        send (attr (filec [1]) + padleft (inttostr (filepos (ff)) + '.', 5, ' '));
        if inbatch (vbatch, flname, curarea, curfconf, rec) then
          comwrite ('|US' + uc. tagchar)
        else
          send (' ');

        if notval then begin
          send (attr (filec [2]) + padleft (setlower (filename (flname)), 8, ' '));
          send (attr (filec [3]) + padleft ('.' + setlower (fileext (flname)), 6, ' '));
        end else begin
          send (attr (filec [2]) + padleft (setupper (filename (flname)), 8, ' '));
          send (attr (filec [3]) + padleft ('.' + setupper (fileext (flname)), 6, ' '));
        end;

        if fl_points  in filelist then
          if free or varea. free then
            send (attr (filec [ 5]) + 'FREE  ')
          else
            send (attr (filec [ 4]) + padleft (inttostr (fr. fp), 6, ' '));
        if fl_size in filelist then
          if offline then
            send (attr (filec [ 5]) + 'OFFLINE ')
          else if resume then
            send (attr (filec [ 5]) + 'RESUME  ')
          else if priv <> '' then
            if inuserlist (priv) then
              send (attr (filec [ 5]) + 'FOR YOU ')
            else
              send (attr (filec [ 5]) + 'PRIVATE ')
          else
            send (attr (filec [ 5]) + padleft (sizes, 8, ' '));
        if fl_date    in filelist then send (attr (filec [ 6]) + padleft (datestr (fdate), 9, ' '));
        if fl_dateuld in filelist then send (attr (filec [ 7]) + padleft (datestr (dtul), 9, ' '));
        if fl_timesdl in filelist then send (attr (filec [ 8]) + padleft (inttostr (dls), 4, ' '));
        if fl_uplder  in filelist then send (attr (filec [ 9]) + padleft (ulby, 30, ' '));
        if fl_desc    in filelist then begin
          send (attr (filec [10]));
          if dlen <> 0 then begin
            {$I-}
            seek (df, dptr);
            {$IFDEF Debug}{$I+}{$ENDIF}
            if (ioresult <> 0) or (dlen + dptr > filesize (df)) then
              comwrite ('Invalid description.')
            else begin
              if shaudy then begin
                dizl := 0;
                temp2 := pred (curpagelen) - top;
              end else
                temp2 := dlen;
              while temp2 > 0 do begin
                {$I-}
                read (df, s);
                {$IFDEF Debug}{$I+}{$ENDIF}
                if ioresult <> 0 then begin
                  comwriteln ('');
                  break;
                end;
                if shaudy then inc (dizl);
                send (goxy (34, _y) + clr2eol);
                comwriteln (s);
                dec (temp2);
              end;
              if shaudy then begin
                repeat
                  inc (dizl);
                  if (readinputnw = 32) or hung then break;
                until upddiz (false);
                if hung then exit;
                if fl_skiplines in filelist then send (clr2eol + ^M^J);
                pt := prompt (temp <> high);
                if hung or (pt = abort) then begin
                  listfile := true;
                  exit;
                end else if pt <> cont then exit;
                if temp = high then exit;
              end;
            end;
          end else send ('No description given.' + clr2eol + ^M^J);
        end else comwriteln ('');
        if fl_skiplines in filelist then send (clr2eol + ^M^J);
      end else inc (skipped);
    end;
    if (temp = high) and showed then begin
      pt := prompt (false);
      if hung or (pt = abort) then begin
        listfile := true;
        exit;
      end;
    end;
  end;

var
  i: integer;

begin
  if not hasacs (ar. lstacs) then begin
    comwriteln (^M^J + cs (173));
    exit;
  end;

  assign (ff, uc. filepath + areafname (0, 0) + '.Idx');
  {$i-}
  reset (ff);
  {$IFDEF Debug}{$I+}{$ENDIF}
  if ioresult <> 0 then begin
    comwriteln (cs (129));
    exit;
  end;
  if filesize (ff) = 0 then begin
    close (ff);
    comwriteln (cs (129));
    exit;
  end;

  assign (df, uc. filepath + areafname (0, 0) + '.Dat');
  {$i-}
  reset (df);
  {$IFDEF Debug}{$I+}{$ENDIF}
  if ioresult <> 0 then rewrite (df);

  wc := '';
  i := 1;

  if p <> '' then begin
    system. val (p, low, i);
    if i <> 0 then
      wc := remchars (' +=/\[]":;,<>|', p)
    else
      wc := '*.*';
  end;

  if wc = '' then begin
    comwrite (Cs (134));
    getcapstr (12, 'A', false, false, wc);
    if hung then begin
      close (df);
      close (ff);
      exit;
    end;
    comwriteln ('');
    wc := remchars (' +=/\[]":;,<>|', wc);
    if wc = '' then
      wc := '*.*'
    else if (pos ('.', wc) = 0) and (length (wc) <= 10) then
      wc := wc + '.*';

    if (wc [1] = '.') or (pos ('.', wc) > 8) or (length (wc) - pos ('.', wc) > 4) then begin
      close (df);
      close (ff);
      exit;
    end;
  end;

  if i <> 0 then begin
    fillin1 := '1';
    fillin2 := inttostr (filesize (ff));
    comwrite (Cs (128));
    GetRange ('', false, 0, filesize (ff), 0, filesize (ff), -1, Low, High);

    if hung then begin
      close (df);
      close (ff);
      exit;
    end;
    comwriteln ('');
  end else begin
    if (low > filesize (ff)) or (low < -1) then low := 0;
    high := low;
  end;

  if low = 0 then begin
    close (df);
    close (ff);
    exit;
  end;

  if low = -1 then begin
    low := 1;
    high := filesize (ff);
  end;

  seek (ff, pred (low));
  topopage := low;
  shaudy := false;
  showed := false;
  skipped := 0;

  temp := low;
  while temp <= high do begin
    if hung or listfile then break;
    inc (temp);
  end;

  close (ff);
  close (df);

  Log (0, 'Listed files in area "' + varea. name + '"');
  if not hung then begin
    comwriteln ('');
    if not showed then comwriteln (cs (129));
    comwriteln ('');
  end;
end;

procedure relarea (forw: Boolean);
var
  w: word;
begin
  w := fsize (uc. filepath + 'FileArea.' + inttostr (curfconf)) div sizeof (farearec);
  if forw and (curarea = w) then begin
    comwriteln (cs (130));
    exit;
  end else if not forw and (curarea = 1) then begin
    comwriteln (cs (131));
    exit;
  end;

  if forw then
    goarea (succ (curarea), true)
  else
    goarea (pred (curarea), true);
end;

var
  times, fps: longint;

function valfileuplder (ba: batchrec; var ar: farearec): boolean;
begin
  fillin1 := ba. flname;
  if fspons or (setupper (user. handle) = setupper (ba. ulby)) then begin
    valfileuplder := false;
    comwriteln (cs (143));
  end else begin
    valfileuplder := true;
    comwriteln (cs (156));
  end;
end;

function valfileexist (ba: batchrec; var ar: farearec): boolean;
begin
  fillin1 := ba. flname;
  if exist (ar. path + ba. flname) then begin
    comwriteln (cs (143));
    valfileexist := false;
  end else begin
    comwriteln (cs (148));
    valfileexist := true;
  end;
end;

function valfiledl (ba: batchrec; var ar: farearec): boolean;
var
  p: pathstr;
begin
  with ba do begin
    valfiledl := false;
    fillin1 := flname;

    p := ar. path + flname;
    if not exist (p) then begin
      comwriteln (cs (148));
      valfiledl := true;
      exit;
    end;

    if not hasacs (ar. dnlacs) then begin
      fillin2 := ar. name;
      fillin1 := ba. flname;
      comwriteln (cs (174));
      valfiledl := true;
      exit;
    end;

    if baudrate <> 0 then inc (times, (size div (baudrate div 10) div 60));
    with user do if (timelimit <> 0) and not (timelock in options) and (times > timeleft) then begin
      if baudrate = 0 then
        fillin2 := '0'
      else
        fillin2 := inttostr ((size div (baudrate div 10) div 60));
      comwriteln (cs (144));
      valfiledl := true;
      exit;
    end;

    if not ba. free and not ar. free then begin
      if fps + fp > 999999 then
        fps := 999999
      else
        inc (fps, fp);

      if fps > user. fp then begin
        fillin2 := inttostr (fp);
        comwriteln (cs (144));
        valfiledl := true;
        exit;
      end;

      with user do if (udratio <> 0) and (ratio (uploads, downloads + succ (batch. files)) > udratio) then begin
        comwriteln (cs (165));
        valfiledl := true;
        exit;
      end;

      with user do if (udkratio <> 0) and (ratio (uk, dk + size) > udkratio) then begin
        comwriteln (cs (166));
        valfiledl := true;
        exit;
      end;

      with user do if (maxdlkperday <> 0) and (dlktoday + (batch. bytes div 1024) + (size div 1024) > maxdlkperday) then begin
        comwriteln (cs (167));
        valfiledl := true;
        exit;
      end;
    end;

    fillin2 := inttostr (fp);
    if baudrate = 0 then
      fillin3 := '0'
    else
      fillin3 := inttostr ((size div (baudrate div 10) div 60));
    fillin4 := inttostr (fps);
    fillin5 := inttostr (times);
    comwriteln (cs (143));
  end;
end;

var
  nb: word;
  lb: tfilerec;
  blparsed: boolean;

procedure showbatchtop (c: char);
var
  s: string;
Begin
  if blparsed then begin
    With lb do Case C of
      'S': s := inttostr (batch. bytes);
      'P': s := inttostr (batch. pts);
      'T': if baudrate = 0 then
             s := '0'
           else
             s := inttostr ((batch. bytes div (baudrate div 10) div 60));
      Else s := '@' + C;
    End;
    comwrite (padd (s));
    blparsed := false;
  End else if c = '@' then blparsed := true else comwritech (c);
end;

procedure showbatchmid (c: char);
var
  s: string;
Begin
  if blparsed then begin
    With lb do Case C of
      '#': s := IntToStr (nb);
      'N': s := flname;
      'S': s := IntToStr (size);
      'P': s := IntToStr (fp);
      'T': if baudrate = 0 then
             s := '0'
           else
             s := inttostr ((size div (baudrate div 10) div 60));
      Else s := '@' + C;
    End;
    comwrite (padd (s));
    blparsed := false;
  End else if c = '@' then blparsed := true else comwritech (c);
end;

procedure batchlist;
Var
  Path: DirStr;
begin
  if vbatch^. totalnodes = 0 then begin
    comwrite (^M^J + cs (155));
    exit;
  end;

  If Exist (CurStatSet. Path + 'Batch.*') Then
    Path := CurStatSet. Path
  Else
    Path := Uc. DispPath;

  blparsed := false;
  ShowFileProc (Path + 'Batch.Top', showbatchtop);

  with vbatch^ do begin
    jump (1);

    For nb := 1 to totalnodes do Begin
      get (lb);
      blparsed := false;
      ShowFileProc (Path + 'Batch.Mid', showbatchmid);
      advance (1);
    End;
  end;

  blparsed := false;
  ShowFileProc (Path + 'Batch.Bot', showbatchtop);
end;

procedure batchdel (p: str100);
var
  t: word;
  low, high: longint;
  ba: batchrec;
begin
  comwrite (^M^J);
  t := vbatch^. totalnodes;
  if t = 0 then begin
    comwrite (cs (155));
    exit;
  end;

  if p = '' then begin
    fillin1 := inttostr (t);
    comwrite (cs (152));
    getrange ('', false, 1, t, 1, t, 0, Low, High);
    if hung then exit;
    comwriteln ('');
    if low = 0 then exit;
  end else begin
    if not inbatch (vbatch, p, curarea, curfconf, t) then exit;
    low := t;
    high := t;
  end;

  with vbatch^ do begin
    jump (low);
    for t := low to high do begin
      get (ba);
      with batch, ba do begin
        dec (files);
        dec (bytes, size);
        dec (pts, fp);
        fLeft := succ (Files);
        bLeft := Bytes;
      end;
      delnode (activenodeptr);
    end;
  end;
end;

procedure batchclr (w: boolean);
begin
  comwrite (^M^J);
  if vbatch^. totalnodes = 0 then begin
    comwrite (cs (155));
    exit;
  end;
  if not w then comwrite (cs (153));
  if w or (litebar (lbno, false, true) = lbyes) then begin
    vbatch^. emptylist;
    fillchar (batch, sizeof (batch), 0);
  end;
end;

procedure checkfile (s: str100; val: bproc; show: boolean);
var
  ff: file of tfilerec;
  fr: spuds. tfilerec;
  w, l: word;
  ok: boolean;
  i: integer;
  ba: batchrec;
  lb: litebartype;
label
  finish;
begin
  assign (ff, uc. filepath + areafname (0, 0) + '.idx');
  {$I-}
  reset (ff);
  {$IFDEF Debug}{$I+}{$ENDIF}
  if ioresult <> 0 then exit;

  s := remchars (' +=/\[]":;,<>|', s);
  if (s = '') or hung then goto finish;
  comwriteln ('');
  system. val (s, w, i);
  if (i <> 0) and (pos ('.', s) = 0) then s := s + '.*';
  if (s [1] = '.') or (pos ('.', s) > 9) or (length (s) - pos ('.', s) > 4) then goto finish;
  ok := false;

  with vbatch^ do begin
    seek (ff, 0);
    while not eof (ff) do begin
      read (ff, fr);
      if not fitswildcard (fr. flname, s) then continue;
      fillin1 := fr. flname;
      ok := true;
      if inbatch (vbatch, fr. flname, curarea, curfconf, l) then begin
        if show then comwriteln (cs (214));
        continue;
      end;

      if haswildcards (s) then begin
        comwrite (cs (139));
        lb := litebar (lbyes, true, true);
      end else lb := lbyes;

      if hung then goto finish;
      if lb = lbquit then goto finish;
      if lb = lbyes then begin
        if not fspons and not inuserlist (fr. priv) then
          comwrite (cs (96))
        else if not fspons and not hasacs (fr. acs) then
          comwrite (cs (114))
        else begin
          move (fr, ba, sizeof (fr));
          with ba do begin
            conf := curfconf;
            area := curarea;
          end;
          if not val (ba, varea) then begin
            vbatch^. add (ba, sizeof (ba));
            add2batch (ba);
          end;
        end;
      end;
      comwriteln ('');
      if not haswildcards (s) then break;
    end;
  end;

  if not ok then begin
    system. val (s, w, i);
    if (i = 0) and (w <= filesize (ff)) and (w > 0) then begin
      seek (ff, pred (w));
      read (ff, fr);
      fillin1 := fr. flname;
      if not inbatch (vbatch, fr. flname, curarea, curfconf, l) then begin
        if not fspons and not inuserlist (fr. priv) then
          comwrite (cs (96))
        else if not fspons and not hasacs (fr. acs) then
          comwrite (cs (114))
        else begin
          move (fr, ba, sizeof (fr));
          with ba do begin
            conf := curfconf;
            area := curarea;
          end;
          if not val (ba, varea) then begin
            vbatch^. add (ba, sizeof (ba));
            add2batch (ba);
          end;
        end;
      end else comwriteln (cs (214));
    end;
  end;

  finish:
  close (ff);
end;

procedure batchadd (p: str100; val: bproc);
begin
  if p <> '' then begin
    checkfile (p, val, false);
    comwriteln ('');
  end;
  comwriteln (^M^J + cs (147) + ^M^J);
  repeat
    comwrite (cs (138));
    p := '';
    getstr (12, false, false, p);
    p := remchars (' +=/\[]":;,<>|', p);
    if hung or (p = '') then break;
    if p = '!' then begin
      goarea (0, true);
      continue;
    end;
    checkfile (p, val, true);
    comwriteln ('');
  until hung;
  if not hung then comwriteln ('');
end;

procedure editbatch;
var
  c: char;
Begin
  Log (0, 'Edited file batch');

  batchlist;

  repeat
    comwrite (^M^J + cs (151));
    repeat
      c := ucase (readinchar);
      if hung then exit;
    until pos (c, 'LCDAQ') <> 0;
    comwriteln (c);
    case c of
      'L': batchlist;
      'C': batchclr (false);
      'D': batchdel ('');
      'A': batchadd ('', noval);
      'Q': break;
    end;
  until hung;
  comwriteln ('');
end;

var
  dashit: axy;
  hangprocparsed: boolean;

Procedure hangxferProc (C: Char);
Var
  Test: Boolean;
Begin
  Test := True;
  If hangprocparsed Then Begin
    Case C of
      '!': GetAxy (dashit);
      Else Begin
        Comwrite ('@' + C);
        Test := False;
      End;
    End;
    If Test Then Begin
      Inc (_x, 2);
      If _x > Sx2 Then Begin
        _x := _x - Sx2;
        If _y <> Sy2 Then Inc (_y) else send (^J);
      End;
      Send (GoXy (_x, _y));
    End;
    hangprocparsed := False;
  End Else Begin
    If C = '@' Then
      hangprocparsed := True
    Else
      ComWriteCh (C);
  End;
End;

procedure checkforuplds (uplding: boolean);
type
  str45 = string [45];
var
  fr: tfilerec;
  ff: file of tfilerec;
  df: file of str45;
  d: string;
  poot, rel, passed, uplded: boolean;
  k, b, null: byte;
  ba: tfilerec;
  z: longint;
  n: str12;
  r, s: str45;
  dsz: dszrec;
  rec: word;
  i, xf, t: text;
  dt: datetime;
  tu: ^tuserdata;
begin
  Assign (xf, NodeData. NodePath + 'xfer.log');
  {$I-}
  append (xf);
  {$IFDEF Debug}{$I+}{$ENDIF}
  if ioresult <> 0 then begin
    rewrite (xf);
    writeln (xf, '|URTransfer log for node ' + inttostr (nodenumber) + ' started ' + currentdate (false) + '.');
    writeln (xf);
  end;

  uplded := false;
  Assign (t, NodeData. NodePath + 'DSZ.LOG');
  {$I-}
  reset (t);
  {$IFDEF Debug}{$I+}{$ENDIF}
  if ioresult = 0 then begin
    while not eof (t) do begin
      readln (t, d);
      dszlogstr (d, dsz);

      with dsz do begin
        n := filename (name) + '.' + fileext (name);

        fillin1 := n;
        if avcps <> 0 then
          z := round (size / avcps) div 60
        else
          z := 0;

        if usingexternal then begin
          if DailyLog. TimeOnline + z > 1440 then
            DailyLog. TimeOnline := 1440
          else
            inc (DailyLog. TimeOnline, z);

          if CurTimeOn + z > 1440 then
            CurTimeOn := 1440
          else
            inc (CurTimeOn, z);

          if user. TimeOnToday + z > 1440 then
            user. TimeOnToday := 1440
          else
            inc (user. TimeOnToday, z);

          inc (user. tTimeOn, z);

          if user. timeleft - z < 0 then
            user. timeleft := 0
          else
            dec (user. timeleft, z);
        end;
      end;

      if inbatch (ubatch, n, 0, 0, rec) then with ubatch^ do begin
        Getnodedata (nodeptr (rec), ba);
        delnode (nodeptr (rec));
        rel := true;
      end else rel := false;

      with dsz do begin
        case stat of
          'H', 'Z', 'R', 'K', 'A':
                begin
                  if not hasacs (varea. uplacs) then begin
                    deletefile (name);
                    continue;
                  end;

                  if not uplded then begin
                    comwriteln (cs (201));
                    uplded := true;
                  end;

                  fillin2 := inttostr (avcps);
                  if avcps <> 0 then
                    z := round (size / avcps) div 60
                  else
                    z := 0;

                  fillin3 := inttostr (z);
                  fillin4 := inttostr (size);
                  fillin5 := inttostr (errcnt);

                  if not hung then comwriteln (cs (200));

                  log (2, 'Uploaded ' + n +  + ', size:' + fillin4 + ', cps:' + fillin2+ ', time:' + fillin3);
                  writeln (xf, currentdate (false) + ' ' + currenttime (false) + '  |US' + user. handle + '|UR uplded ' + n +
                           ', size:' + fillin4 + ', cps:' + fillin2+ ', time:' + fillin3);

                  if spuds. b (uc. options, testuploads) then
                    passed := upldcheck (dsz. name)
                  else
                    passed := true;

                  if hung then fixhung;

                  if not passed then begin
                    log (2, n + ' failed upload processor.');
                    writeln (xf, n + ' failed upload processor.');
                  end else begin
                    log (2, n + ' passed upload processor.');
                    writeln (xf, n + ' passed upload processor.');

                    inc (totals. tuplds);
                    inc (totals. tfiles);
                    inc (dailylog. uplds);

                    fillin1 := n;
                    if dsz.name <> setupper (varea. path + n) then begin
                      comwrite (Cs (204));
                      movefile (dsz.name, varea. path + n);
                      comwriteln ('');
                    end;

                    fillchar (fr, sizeof (fr), 0);
                    with fr do begin
                      flname := n;
                      ulby := user. handle;
                      size := fsize (varea. path + n);
                      fp := size div (uc. FilePtBaseSize * 1024) * varea. mult;

                      unpacktime (ftime (varea. path + n), dt);
                      with dt do
                        fdate := dmytodate (day, month, year);
                      dtul := datenow;

                      send (^M + attr (uc. filec [2]) + clr2eol + '  ' + padleft (setlower (filename (flname)), 8, ' '));
                      send (attr (uc. filec [3]) + '.' + padleft (setlower (fileext (flname)), 5, ' '));
                      send (attr (uc. filec [5]) + padleft (inttostr (size), 9, ' '));
                      send (attr (uc. filec [4]) + padleft (inttostr (fp), 8, ' ') + attr (uc. filec [10]));

                      poot := false;
                      if uc. filediz <> 0 then begin
                        DeleteFile (NodeData. TempPath + 'file_id.diz');
                        DeleteFile (NodeData. TempPath + 'desc.sdi');
                        ComWrite ('extracting description files...');

                        if aextract (0, name, NodeData. TempPath, 'file_id.diz desc.sdi') then begin
                          if exist (NodeData. TempPath + 'file_id.diz') then begin
                            poot := true;
                            Send (goxy (34, _y) + 'importing file_id.diz...' + Clr2Eol);
                            assign (i, NodeData. TempPath + 'file_id.diz');
                          end else if exist (NodeData. TempPath + 'desc.sdi') then begin
                            poot := true;
                            Send (goxy (34, _y) + 'importing desc.sdi...' + Clr2Eol);
                            assign (i, NodeData. TempPath + 'desc.sdi');
                          end;
                        end;
                      end;

                      Send (goxy (34, _y) + Clr2Eol);
                      assign (df, uc. filepath + varea. fname + '.dat');
                      {$I-}
                      reset (df);
                      {$IFDEF Debug}{$I+}{$ENDIF}
                      if ioresult <> 0 then rewrite (df);
                      seek (df, filesize (df));
                      if (poot and rel) or not rel then fr. dptr := filepos (df);

                      if poot then begin
                        reset (i);
                        null := 0;
                        r := '';
                        for b := 1 to uc. filediz do begin
                          if eof (i) then begin
                            dec (b);
                            break;
                          end;
                          readln (i, s);
                          stripansi (s);
                          if s = '' then begin
                            inc (null);
                            continue;
                          end;
                          for k := 1 to null do begin
                            write (df, r);
                            comwriteln ('');
                            null := 0;
                          end;
                          write (df, s);
                          comwriteln (goxy (34, _y) + s);
                        end;
                        dec (b, null);
                        if b = 0 then begin
                          s := 'No description given.';
                          comwriteln (goxy (34, _y) + s);
                          inc (b);
                          write (df, s);
                        end;
                        fr. dlen := b;
                        close (i);
                        erase (i);
                      end else if not dropped and not rel and (uc. filediz <> 0) then begin
                        Send ('Enter the description below:' + Clr2Eol + ^M^J);
                        for b := 1 to uc. filediz do begin
                          send (goxy (34, _y));
                          s := '';
                          getstr (45, false, false, s);
                          if hung then exit;
                          s := remchars (^M^J^G^H^[^V, s);
                          if s = '' then begin
                            dec (b);
                            if b = 0 then begin
                              s := 'No description given.';
                              comwriteln (goxy (34, _y) + s);
                              inc (b);
                              write (df, s);
                            end;
                            break;
                          end;
                          write (df, s);
                          send (clr2eol + ^M^J);
                        end;
                        fr. dlen := b;
                      end else if rel then begin
                        seek (df, ba. dptr);
                        for b := 1 to ba. dlen do begin
                          read (df, s);
                          comwriteln (goxy (34, _y) + s);
                        end;
                        fr. dlen := ba. dlen;
                        fr. dptr := ba. dptr;
                      end else begin
                        fr. dlen := 1;
                        s := 'No description given.';
                        comwriteln (goxy (34, _y) + s);
                        write (df, s);
                      end;
                      close (df);

                      with fr do if rel then begin
                        pw := ba. pw;
                        acs := ba. acs;
                        priv := ba. priv;
                      end else if not dropped then begin
                        comwrite (^M^J + cs (207));
                        getstr (30, false, false, pw);
                        if hung then fixhung;

                        comwrite (^M^J + cs (208));
                        getstr (30, false, false, acs);
                        if hung then fixhung;

                        getmem (tu, sizeof (tuserdata));
                        for b := 1 to 10 do begin
                          fillin1 := inttostr (b);
                          comwrite (^M^J + cs (209));
                          tu^. handle := '';
                          getstr (30, false, false, tu^. handle);
                          if tu^. handle = '' then break;
                          if hung then break;
                          if lookupuser (tu^. handle, rec) then begin
                            readuserrec (tu^, rec);
                            priv := priv + 'U' + inttostr (tu^. usernum);
                          end else dec (b);
                        end;
                        freemem (tu, sizeof (tuserdata));
                        if hung then fixhung;
                      end;
                    end;

                    assign (ff, uc. filepath + varea. fname + '.idx');
                    {$I-}
                    reset (ff);
                    {$IFDEF Debug}{$I+}{$ENDIF}
                    if ioresult <> 0 then rewrite (ff);
                    seek (ff, filesize (ff));
                    write (ff, fr);
                    close (ff);

                    if spuds. b (uc. options, autovalidate) then begin
                      with user do begin
                        inc (uk, size div 1024);
                        inc (uploads);
                        inc (ulktoday, size div 1024);
                        inc (ultoday);
                      end;

                      z := round (fr. fp * (uc. fileptcomp / 100));
                      if user. fp + z > 999999 then
                        user. fp := 999999
                      else
                        inc (user. fp, z);

                      fillin1 := fr. flname;
                      fillin2 := inttostr (z);
                      comwriteln (cs (202));

                      if avcps <> 0 then
                        z := round (size / avcps) div 60
                      else
                        z := 0;

                      z := round (z * (uc. ulrefund / 100));

                      if user. timeleft + z > 1440 then
                        user. timeleft := 1440
                      else
                        inc (user. timeleft, z);

                      fillin2 := inttostr (z);
                      comwriteln (cs (205));
                    end else begin
                      fillin1 := fr. flname;
                      fillin2 := ar. sponsor;
                      comwriteln (cs (203));
                      fr. notval := true;
                    end;
                  end;
                  comwriteln ('');
                end;
                'E': begin
                       { save for later resume }
                     end;
           else if uplding then comwriteln ('|URUnrecognized result string|UP:|US'^M^J + d);
        end;
      end;
    end;
    close (t);
    erase (t);
  end else if uplding then begin
    log (2, 'DSZ.LOG not found or invalid.');
    writeln (xf, currentdate (false) + ' ' + currenttime (false) + '  |US' + user. handle + '|UR uploaded, ' +
             'but DSZ.LOG not found or invalid.');
  end;

  writeln (xf);
  close (xf);
end;

procedure download (p: str100);
var
  af: file of farearec;
  b: byte;
  ba: batchrec;
  c: char;
  dsz: dszrec;
  hangupafter: boolean;
  l: word;
  la: byte;
  lb: litebartype;
  lc: byte;
  r: real;
  s: string;
  sb: pointer;
  sbt: tbatch;
  std: longint;
  xf, t: text;
  tu: ^tuserdata;
  urec: word;
  z: longint;
label
  finish;
begin
  comwriteln ('');
  fillin1 := 'Downloading';
  pfile ('hdr.ans');
  comwriteln ('');

  sb := nil;
  fps := 0;
  times := 0;
  la := 0;
  lc := 0;
  ar := varea;
  std := vbatch^. totalnodes;

  if p <> '' then begin
    checkfile (p, valfiledl, false);
    comwriteln ('');
  end;

  if hung then exit;

  with vbatch^ do if std <> 0 then begin
    fillin1 := 'Download';
    comwrite (cs (142));
    if litebar (lbyes, false, true) = lbyes then begin
      comwriteln ('');
      jump (1);
      with ba do for l := 1 to std do begin
        get (ba);

        if (lc <> conf) or (la <> area) then begin
          assign (af, uc. filepath + 'filearea.' + inttostr (conf));
          reset (af);
          seek (af, pred (area));
          read (af, ar);
          close (af);
          lc := conf;
          la := area;
        end;

        if valfiledl (ba, ar) then
          delnode (activenodeptr)
        else begin
          advance (1);
{          add2batch (ba);}
        end;
        if hung then break;
      end;
    end else begin
      if hung then exit;
      sb := vbatch;
      sbt := batch;
      fillchar (batch, sizeof (batch), 0);
      vbatch := nil;
      new (vbatch, init);
    end;
  end;

  if hung then exit;
  batchadd ('', valfiledl);
  comwriteln ('');

  repeat
    comwrite (cs (149));
    repeat
      c := ucase (readinchar);
    until hung or (pos (c, 'QEC'^M) <> 0);

    if hung then exit;
    comwriteln (c);

    case c of
      'E': begin
             editbatch;
             continue;
           end;
      'Q': Exit;
      ^M, 'C': Break;
    end;
  until false;

  if vbatch^. totalnodes = 0 then goto finish;

  comwrite (^M^J + cs (161));
  lb := litebar (lbno, true, true);
  if hung then exit;
  if lb = lbquit then goto finish;
  hangupafter := lb = lbyes;

  userealpaths := false;
  proto^. upload;

  if not hung then begin
    if not localonly then begin
      uart^. drainoutbuffer (180);
      idelay (100);
      if usingexternal and spuds. b (nodedata. modemopt, flushxfer) then idelay (400);
    end;
    if online then refresh;
  end;

  Assign (xf, NodeData. NodePath + 'xfer.log');
  {$I-}
  append (xf);
  {$IFDEF Debug}{$I+}{$ENDIF}
  if ioresult <> 0 then begin
    rewrite (xf);
    writeln (xf, '|URTransfer log for node ' + inttostr (nodenumber) + ' started ' + currentdate (false) + '.');
    writeln (xf);
  end;

  stayon := true;
  Assign (t, NodeData. NodePath + 'DSZ.LOG');
  {$I-}
  reset (t);
  {$IFDEF Debug}{$I+}{$ENDIF}
  if ioresult = 0 then begin
    if not hung then begin
      if abortxfer then comwriteln (cs (175));
      comwriteln (cs (193));
    end;
    while not eof (t) do begin
      readln (t, s);
      dszlogstr (s, dsz);

      with dsz do begin
        fillin1 := filename (name) + '.' + fileext (name);

        if avcps <> 0 then
          z := round (size / avcps) div 60
        else
          z := 0;

        if usingexternal then begin
          if DailyLog. TimeOnline + z > 1440 then
            DailyLog. TimeOnline := 1440
          else
            inc (DailyLog. TimeOnline, z);

          if CurTimeOn + z > 1440 then
            CurTimeOn := 1440
          else
            inc (CurTimeOn, z);

          if user. TimeOnToday + z > 1440 then
            user. TimeOnToday := 1440
          else
            inc (user. TimeOnToday, z);

          inc (user. tTimeOn, z);

          if user. timeleft - z < 0 then
            user. timeleft := 0
          else
            dec (user. timeleft, z);
        end;
      end;

      if inbatch (vbatch, fillin1, 0, 0, urec) then with vbatch^ do begin
        Getnodedata (nodeptr (urec), ba);
        delnode (nodeptr (urec));
      end else continue;

      with dsz do begin
        case stat of
          'h', 'z', 'r', 'k', 'a':
                begin
                  inc (totals. tdnlds);
                  inc (dailylog. dnlds);

                  with user do begin
                    inc (dk, size div 1024);
                    inc (downloads);
                    inc (dlktoday, size div 1024);
                    inc (dltoday);
                  end;

                  with batch do begin
                    dec (files);
                    dec (pts, ba. fp);
                    dec (Bytes, size);
                  end;

                  fillin2 := inttostr (avcps);
                  fillin3 := inttostr (z);
                  fillin4 := inttostr (size);
                  fillin5 := inttostr (errcnt);

                  if not hung then comwriteln (cs (157));
                  log (2, 'Downloaded ' + fillin1 +  + ', size:' + fillin4 + ', cps:' + fillin2+ ', time:' + fillin3);
                  writeln (xf, currentdate (false) + ' ' + currenttime (false) + '  |US' + user. handle + '|UR dnlded ' +
                           fillin1 +  + ', size:' + fillin4 + ', cps:' + fillin2+ ', time:' + fillin3);

                  if user. fp < ba. fp then
                    user. fp := 0
                  else
                    dec (user. fp, ba. fp);

                  if (uc. dnldcommission <> 0) and (setupper (ba. ulby) <> setupper (user. handle)) then begin
                    if lookupuser (ba. ulby, urec) then begin
                      getmem (tu, sizeof (tuserdata));
                      readuserrec (tu^, urec);
                      r := uc. dnldcommission / 100;
                      r := r * ba. fp;
                      z := round (r);
                      fillin1 := tu^. handle;
                      fillin2 := inttostr (z);
                      if not hung then comwriteln (cs (160));
                      if tu^. fp + z > 999999 then
                        tu^. fp := 999999
                      else
                        inc (tu^. fp, z);
                      updateuserrec (tu^, urec);
                      freemem (tu, sizeof (tuserdata));
                    end;
                  end;
                end;
           'Q', 'q':
                begin
                  fillin2 := inttostr (uc. leechnuke);

                  inc (totals. tdnlds);
                  inc (dailylog. dnlds);
                  with user do begin
                    inc (dk, size div 1024);
                    inc (downloads);
                    inc (dlktoday, size div 1024);
                    inc (dltoday);
                  end;

                  fillin2 := inttostr (avcps);
                  if avcps <> 0 then
                    z := round (size / avcps) div 60
                  else
                    z := 0;

                  fillin3 := inttostr (z);
                  fillin4 := inttostr (size);
                  fillin5 := inttostr (errcnt);

                  with batch do begin
                    dec (files);
                    dec (pts, ba. fp);
                    dec (Bytes, size);
                  end;

                  if not hung then comwriteln (cs (158));
                  log (2, 'LEECHED ' + fillin1 +  + ', size:' + fillin4 + ', cps:' + fillin2+ ', time:' + fillin3);
                  writeln (xf, currentdate (false) + ' ' + currenttime (false) + '  |US' + user. handle + '|UR LEECHED ' +
                           fillin1 +  + ', size:' + fillin4 + ', cps:' + fillin2+ ', time:' + fillin3);

                  if user. fp < ba. fp * uc. leechnuke then
                    user. fp := 0
                  else
                    dec (user. fp, ba. fp * uc. leechnuke);

                  if (uc. dnldcommission <> 0) and (setupper (ba. ulby) <> setupper (user. handle)) then begin
                    if lookupuser (ba. ulby, urec) then begin
                      getmem (tu, sizeof (tuserdata));
                      readuserrec (tu^, urec);
                      r := uc. dnldcommission / 100;
                      r := r * ba. fp;
                      z := round (r);
                      fillin1 := tu^. handle;
                      fillin2 := inttostr (z);
                      if not hung then comwriteln (cs (160));
                      if tu^. fp + z > 999999 then
                        tu^. fp := 999999
                      else
                        inc (tu^. fp, z);
                      updateuserrec (tu^, urec);
                      freemem (tu, sizeof (tuserdata));
                    end;
                  end;
                end;
                'e': begin
                       with batch do begin
                         dec (files);
                         dec (pts, ba. fp);
                         dec (Bytes, size);
                       end;

                       if not hung then comwriteln (cs (159));
                       log (2, 'ERROR dnlding ' + fillin1 +  + ', size:' + fillin4 + ', cps:' + fillin2+ ', time:' + fillin3);
                       writeln (xf, currentdate (false) + ' ' + currenttime (false) + '  |US' + user. handle +
                                '|UR ERROR dnlding ' + fillin1 +  + ', size:' + fillin4 + ', cps:' + fillin2 + ', time:' +
                                fillin3);
                     end;
           else comwriteln ('|URUnrecognized result string|UP:|US'^M^J + s);
        end;
      end;
    end;
    close (t);
  end else begin
    comwriteln (^M^J + cs (175));
    log (2, 'DSZ.LOG not found or invalid.');
    writeln (xf, currentdate (false) + ' ' + currenttime (false) + '  |US' + user. handle + '|UR downloaded, but DSZ.LOG not '+
             'found or invalid.');
  end;

  writeln (xf);
  close (xf);

  dropped := false;
  checkforuplds (false);

  with batch do begin
    fleft := succ (files);
    bleft := Bytes;
    if files <> 0 then begin
      fillin1 := inttostr (files);
      fillin2 := inttostr (bytes);
      comwriteln (^M^J + cs (195));
    end;
  end;

  if dropped then hung := true;

  if not hung then comwriteln ('');
  stayon := false;

  with user do
    If TimeLeft = 0 Then Begin
      if not hung then ComWriteLn (Cs (29));
      hung := True;
    End Else If TimeLeft = 1 Then
      if not hung then ComWriteLn (Cs (108)) else
    Else If TimeLeft = 2 Then
      if not hung then ComWriteLn (Cs (107));

  if not hung and hangupafter then begin
    hangprocparsed := false;
    If (CurStatSet. Path <> '') And Exist (CurStatSet. Path + 'hangxfer.ans') Then
      ShowFileProc (CurStatSet. Path + 'hangxfer.ans', hangxferproc)
    Else
      ShowFileProc (Uc. DispPath + 'hangxfer.ans', hangxferproc);

    for b := 10 downto 0 do begin
      std := biostime;
      putaxy (dashit);
      send (padright (inttostr (b), 2, ' '));

      repeat
        l := readinputnw;
      until ((l < 256) and (l in [kEnter, kEsc, kSftH, kH])) or hung or (et (std) > 18);
      if hung then goto finish;
      if l < 256 then begin
        if l = kEsc then goto finish;
        if l in [kEnter, kH, kSftH] then break;
      end;
    end;

    comwriteln ('');
    hung := true;
  end;

  finish:

  stayon := false;

  if sb <> nil then begin
    dispose (vbatch, done);
    vbatch := sb;
    batch := sbt;
  end;

  if not hung then comwriteln ('');
end;

procedure changefiles (p: str100);
var
  rec: word;
  ff: file of tfilerec;
  fr: tfilerec;
  lastspons, lastupld: boolean;

  procedure drawchange;
  Var
    B: Byte;
  Begin
    { sides }
    ComWrite ('|UR%CS');
    box (1, 1, 79, 3, user. cols [6]);
    box (1, 4, 79,23, user. cols [6]);

    { top }
    ComWriteAt (3, 2, '|URCommand|UP: ');
    ComWriteAt (24,2, '|UP[|USQ|UP]|URuit');
    ComWriteAt (57,2, '|15S|07y|08stem/|157|075 |15F|07i|08le |15E|07d|08itor');

    { top left }
    ComWriteAt (3, 7, '|UP[A]|UR Filename    |UP:');
    ComWriteAt (3, 8, '[B]|UR Password    |UP:');
    ComWriteAt (3, 9, '[C]|UR Minimum acs |UP:');
    ComWriteAt (3,10, '[D]|UR Private for ...');

    { mid left }
    ComWriteAt (3,12, '|UP[E]|UR Edit description');
    ComWriteAt (3,13, '|UP[F]|UR Create .diz from description');
    ComWriteAt (3,14, '|UP[G]|UR Test archive crc');
    ComWriteAt (3,15, '|UP[H]|UR Display text file');
    ComWriteAt (3,16, '|UP[I]|UR Move file to another area/conf');

    { mid right }
    ComWriteAt (40,12, '|UP[J]|UR Delete file');
    ComWriteAt (40,13, '|UP[K]|UR Import .diz to description');
    ComWriteAt (40,14, '|UP[L]|UR View archive contents');
    ComWriteAt (40,15, '|UP[M]|UR Run upload checker on file');
    ComWriteAt (40,16, '|UP[N]|UR Copy file to another area/conf');

    { bottom left }
    ComWriteAt (3,18, '|UP[O]|UR File size   |UP:');
    ComWriteAt (3,19, '[P]|UR File points |UP:');
    ComWriteAt (3,20, '[R]|UR Upload date |UP:');
    ComWriteAt (3,21, '[S]|UR Times dnld  |UP:');
    ComWriteAt (3,22, '[T]|UR Uploader    |UP:');

    { bottom right }
    ComWriteAt (40,18, '[U]|UR Offline flag |UP:');
    ComWriteAt (40,19, '[V]|UR Resume Flag  |UP:');
    ComWriteAt (40,20, '[W]|UR Free Flag    |UP:');
    ComWriteAt (40,21, '[W]|UR Validated    |UP:');

    ComWriteAt (61,7, '[|US[|UP]|UR Previous file');
    ComWriteAt (61,8, '|UP[|US]|UP]|UR Next file');
  End;

  procedure hi;
  var
    b: byte;
  begin
    ComWriteAt (61,6, '|US' + padright (inttostr (filepos (ff)), 5, ' ') + '|UR of|US ' +
                padleft (inttostr (filesize (ff)), 5, ' '));

    if fspons or (setupper (fr. ulby) = setupper (user. handle)) then begin
      comwriteat (3, 5, '|UREditing file |US' + fr. flname + '|UR in area |US' + varea. name + '|UP.');
      send (rep (' ', 78 - _x));
      usercol (2)
    end else begin
      comwriteat (3, 5, '|URYou did not upload |US' + fr. flname + '|UP;|UR editing not allowed|UP.');
      send (rep (' ', 78 - _x));
      usercol (1);
    end;

    if lastupld <> fspons or (setupper (fr. ulby) = setupper (user. handle)) then begin
      for b := 1 to 4 do
        comwriteat (4, 6 + b, chr (64 + b));

      for b := 5 to 8 do
        comwriteat (4, 7 + b, chr (64 + b));

      for b := 10 to 13 do
        comwriteat (41, 2 + b, chr (64 + b));

      lastupld := not lastupld;
    end;

    if fspons then
      usercol (2)
    else
      usercol (1);

    if lastspons <> fspons then begin
      comwriteat (4, 16, 'I');
      comwriteat (41,16, 'N');

      for b := 15 to 16 do
        comwriteat (4, 3 + b, chr (64 + b));

      for b := 18 to 20 do
        comwriteat (4, 2 + b, chr (64 + b));

      for b := 21 to 24 do
        comwriteat (41, b - 3, chr (64 + b));

      lastspons := not lastspons;
    end;
  end;

  procedure fillchange (c: char);
  Var
    Z: Char;
  Begin
    usercol (2);

    With fr do Case C of
      'A': send (goxy (21, 7) + padleft (flname, 12, ' '));
      'B': send (goxy (21, 8) + padleft (pw, 30, ' '));
      'C': send (goxy (21, 9) + padleft (acs, 40, ' '));
      'O': send (goxy (21,18) + padleft (inttostr (size), 9, ' '));
      'P': send (goxy (21,19) + padleft (inttostr (fp), 6, ' '));
      'R': send (goxy (21,20) + datestr (dtul));
      'S': send (goxy (21,21) + padleft (inttostr (dls), 3, ' '));
      'T': send (goxy (21,22) + padleft (ulby, 30, ' '));
      'U': send (goxy (59,18) + truefalse [offline]);
      'V': send (goxy (59,19) + truefalse [resume]);
      'W': send (goxy (59,20) + truefalse [free]);
      'X': send (goxy (59,21) + truefalse [not notval]);
       #0: for z := 'A' to 'X' do begin
             if z = 'D' then z := 'O';
             fillchange (z);
           end;
    End;
  end;

  procedure runchange;
  type
    str45 = string [45];
  var
    b: byte;
    t: text;
    c: char;
    df: file of str45;
    ts: str45;
    ds: string [8];
    rec: word;
    temps: string;
    sp: longint;
  begin
    Repeat
      usercol (4);
      Send (Goxy (12, 2) + ' '#8);
      C := uCase (ReadInChar);
      If Hung Then Break;
      If not fspons and (Pos (C, 'INOPRSTUVW') <> 0) Then Continue;
      If (setupper (fr. ulby) <> setupper (user. handle)) and (Pos (C, 'ABCDEFGHJKLM') <> 0) Then Continue;
      Send (C);
      usercol (2);

      With fr do case C of
        'A':
             Begin
               Send (GoXy (21, 7));
               temps := flname;
               GetStr (12, true, False, temps);
               if not inarea (temps, 0, 0, rec) then begin
                 renamefile (varea. path + flname, varea. path + temps);
                 flname := temps;
               end else
                 FillChange (C);
             End;
        'B':
             Begin
               Send (GoXy (21, 8));
               GetStr (30, true, False, pw);
{               FillChange (C);}
             End;
        'C':
             Begin
               Send (GoXy (21, 9));
               allowflagedit := true;
               GetCapStr (40, 'A', true, False, acs);
               allowflagedit := false;
{               FillChange (C);}
             End;
      'D':   begin
               priv := getprimus (flname, priv);
               drawchange;
               lastspons := false;
               lastupld := false;
               hi;
               fillchange (#0);
             end;
      'E':   begin
               ComWriteAt (7,12, '|USnext version, fool|00 %BS');
               idelay (1000);
               ComWriteAt (7,12, '|UREdit description  ');
             end;
      'F':   begin
               assign (df, uc. filepath + ar. fname + '.dat');
               {$I-}
               reset (df);
               if ioresult = 0 then begin
                 seek (df, dptr);
                 if ioresult = 0 then begin
                   ComWriteAt (7,13, '|USCreating file_id.diz|B+...|B-');
                   assign (t, nodedata. temppath + 'file_id.diz');
                   rewrite (t);
                   for b := 1 to dlen do begin
                     read (df, ts);
                     if ioresult <> 0 then break;
                     writeln (t, ts);
                   end;
                   close (t);
                   ComWriteAt (7,13, '|USAdding file_id.diz|B+...|B-  ');
                   aaddto (0, ar. path + flname, nodedata. temppath + 'file_id.diz');
                 end;
                 close (df);
               end;
               {$IFDEF Debug}{$I+}{$ENDIF}
               deletefile (nodedata. temppath + 'file_id.diz');
               ComWriteAt (7,13, '|URCreate .diz from description');
             end;
      'G':   begin
               ComWriteAt (7,14, '|USTesting crc|B+...|B-  ');
               if atest (0, ar. path + flname) then
                 ComWriteAt (7,14, '|USArchive is ok     ')
               else
                 ComWriteAt (7,14, '|USArchive has bad crc');
               comwrite ('|00 %BS');
               idelay (1000);
               ComWriteAt (7,14, '|URTest archive crc');
             end;
      'H':   begin
               usercol (1);
               send (cls);
               showfile (varea. path + flname, true, false);
               comwriteln ('');
               pressenter;
               drawchange;
               lastspons := false;
               lastupld := false;
               hi;
               fillchange (#0);
             end;
      'I':   begin
               send (goxy (1, 24));
               sp := Pred (FilePos (ff));
               Seek (ff, sp);
               Write (ff, fr);
               close (ff);
               moveall := false;
               movefileprim (true, flname, curarea, curfconf, varea);
               pressenter;
               reset (ff);
               if sp < filesize (ff) then
                 seek (ff, sp)
               else if filesize (ff) = 0 then
                 break
               else
                 seek (ff, pred (sp));
               read (ff, fr);
               drawchange;
               lastspons := false;
               lastupld := false;
               hi;
               fillchange (#0);
             end;
      'J':   begin
               send (goxy (1, 24));
               sp := Pred (FilePos (ff));
               Seek (ff, sp);
               Write (ff, fr);
               close (ff);
               delall := false;
               nukeit := lbyes;
               delreal := lbyes;
               tellupld:= lbyes;
               nukepts := 1;
               delfileprim (flname, curarea, curfconf, fp, ulby, varea);
               pressenter;
               reset (ff);
               if sp < filesize (ff) then
                 seek (ff, sp)
               else if filesize (ff) = 0 then
                 break
               else
                 seek (ff, pred (sp));
               read (ff, fr);
               drawchange;
               lastspons := false;
               lastupld := false;
               hi;
               fillchange (#0);
             end;
      'K':   begin
               ComWriteAt (44,13, '|USExtracting file_id.diz|B+...|B-');
               if aextract (0, ar. path + flname, nodedata. temppath, 'file_id.diz') then begin
                 ComWriteAt (44,13, '|USImporting file_id.diz|B+...|B- ');
                 assign (df, uc. filepath + ar. fname + '.dat');
                 {$I-}
                 reset (df);
                 if ioresult <> 0 then rewrite (df);
                 dptr := filesize (df);
                 seek (df, dptr);
                 assign (t, nodedata. temppath + 'file_id.diz');
                 reset (t);
                 dlen := 0;
                 while not eof (t) do begin
                   inc (dlen);
                   readln (t, ts);
                   write (df, ts);
                   if ioresult <> 0 then break;
                 end;
                 close (t);
                 close (df);
                 deletefile (nodedata. temppath + 'file_id.diz');
               end;
               {$IFDEF Debug}{$I+}{$ENDIF}
               ComWriteAt (44,13, 'Import .diz to description');
             end;
      'L':   begin
               ComWriteAt (44,14, '|USnext version, fool   |00 %BS');
               idelay (1000);
               ComWriteAt (44,14, '|URView archive contents');
             end;
      'M':   begin
               upldcheck (varea. path + flname);
               pressenter;
               drawchange;
               lastspons := false;
               lastupld := false;
               hi;
               fillchange (#0);
             end;
      'N':   begin
               send (goxy (1, 24));
               sp := Pred (FilePos (ff));
               Seek (ff, sp);
               Write (ff, fr);
               close (ff);
               moveall := false;
               movefileprim (false, flname, curarea, curfconf, varea);
               pressenter;
               reset (ff);
               if sp < filesize (ff) then
                 seek (ff, sp)
               else if filesize (ff) = 0 then
                 break
               else
                 seek (ff, pred (sp));
               read (ff, fr);
               drawchange;
               lastspons := false;
               lastupld := false;
               hi;
               fillchange (#0);
             end;
      'O':   begin
               send (goxy (21,18));
               size := getnumstr (true, true, 0, 999999999, size, size, size, size);
               FillChange (C);
             end;
      'P':   begin
               send (goxy (21,19));
               fp := getnumstr (true, true, 0, 999999, fp, fp, fp, fp);
               FillChange (C);
             end;
      'R':   begin
               repeat
                 send (goxy (21,20));
                 ds := datestr (dtul);
                 getdatestr (true, ds);
               until hung or validdatestr (ds);
               dtul := dateval (ds);
{               FillChange (C);}
             end;
      'S':   begin
               send (goxy (21,21));
               dls := getnumstr (true, true, 0, 255, dls, dls, dls, dls);
               FillChange (C);
             end;
      'T':   begin
               send (goxy (21,22));
               temps := ulby;
               getstr (30, true, false, temps);
               if lookupuser (temps, rec) then
                 ulby := temps
               else
                 FillChange (C);
             end;
      'U':   begin
               offline := not offline;
               FillChange (C);
             end;
      'V':   begin
               resume := not resume;
               FillChange (C);
             end;
      'W':   begin
               free := not free;
               FillChange (C);
             end;
      'X':   begin
               notval := not notval;
               FillChange (C);
             end;
        '[':
             Begin
               Seek (ff, Pred (FilePos (ff)));
               Write (ff, fr);

               Seek (ff, Pred (FilePos (ff)));
               If FilePos (ff) = 0 Then
                 Seek (ff, Pred (FileSize (ff)))
               Else
                 Seek (ff, Pred (FilePos (ff)));
               Read (ff, fr);

               hi;
               FillChange (#0);
             End;
        ']':
             Begin
               Seek (ff, Pred (FilePos (ff)));
               Write (ff, fr);

               If FilePos (ff) = FileSize (ff) Then Seek (ff, 0);
               Read (ff, fr);

               hi;
               FillChange (#0);
             End;
        'Q':
             Begin
               Seek (ff, Pred (FilePos (ff)));
               Write (ff, fr);
               Break;
             End;
      End;
    Until hung;
    If Not hung Then ComWriteAt (1, 24, '|UR');
  end;

begin
  if p = '' then
    rec := 0
  else
    if not inarea (p, 0, 0, rec) then exit;

  assign (ff, uc. filepath + varea. fname + '.idx');
  {$I-}
  reset (ff);
  if ioresult <> 0 then rewrite (ff);
  if filesize (ff) = 0 then begin
    close (ff);
    comwriteln (cs (215));
    exit;
  end;
  seek (ff, rec);
  read (ff, fr);
  if ioresult <> 0 then begin
    comwriteln ('|o4error.');
    exit;
  end;
  {$IFDEF Debug}{$I+}{$ENDIF}

  lastspons := false;
  lastupld := false;

  drawchange;
  if hung then begin
    exit;
    close (ff);
  end;
  hi;
  fillchange (#0);
  if hung then begin
    exit;
    close (ff);
  end;
  runchange;
  if filesize (ff) = 0 then comwriteln (cs (215));
  close (ff);
  comwriteln ('');
end;

procedure newscanfiles (p: str100);
begin
end;

procedure customfile (p: str100);
begin
end;

procedure showinfo (p: str100);
begin
end;

procedure resumefile (p: str100);
begin
end;

procedure typefile (p: str100);
var
  rec: word;
  i: integer;
  ff: file of tfilerec;
  fr: tfilerec;
begin
  if p = '' then begin
    comwrite (cs (213));
    p := '';
    getstr (12, false, false, p);
    comwriteln ('');
  end;
  if hung then exit;

  if not inarea (p, curarea, curfconf, rec) then begin
    Val (p, rec, i);
    if i = 0 then begin
      assign (ff, uc. filepath + varea. fname + '.idx');
      {$I-}
      reset (ff);
      if ioresult <> 0 then exit;
      seek (ff, pred (rec));
      if ioresult = 0 then begin
        read (ff, fr);
        if ioresult = 0 then
          p := fr. flname
        else
          p := '';
      end;
      close (ff);
      {$IFDEF Debug}{$I+}{$ENDIF}
    end else p := '';
  end;

  if p = '' then exit;
  ttypauser := 1;
  usercol (1);
  showfile (varea. path + p, true, true);
  if hung then exit;
  comwriteln ('');
  pressenter;
end;

procedure upload;
type
  str45 = string [45];
var
  ba: tfilerec;
  tu: ^tuserdata;
  rec: word;
  hangupafter: boolean;
  lb: litebartype;
  std, l: longint;
  df: file of str45;
  s: str45;
  b: byte;
  p: str12;
label
  finish;
begin
  comwriteln ('');
  if not hasacs (ar. uplacs) then begin
    comwriteln (cs (199));
    exit;
  end;

  l := uc. minspaceforupload;
  l := l * 1024;

  if (l <> 0) and (diskfree (ord (ucase (ar. path [1])) - 64) < l) then begin
    comwriteln (cs (206));
    exit;
  end;

  fillin1 := 'Uploading';
  pfile ('hdr.ans');
  comwriteln ('');

  assign (df, uc. filepath + varea. fname + '.dat');
  {$I-}
  reset (df);
  {$IFDEF Debug}{$I+}{$ENDIF}
  if ioresult <> 0 then rewrite (df);
  seek (df, filesize (df));

  comwriteln (^M^J + cs (210) + ^M^J);
  repeat
    comwrite (cs (138));
    p := '';
    getstr (12, false, false, p);
    comwriteln ('');
    p := remchars (' +=/\[]":;,<>|', p);
    if hung or (p = '') then break;
    if haswildcards (p) then begin
      comwriteln (cs (211));
      continue;
    end;
    if inbatch (ubatch, p, 0, 0, rec) then continue;

    fillchar (ba, sizeof (ba), 0);
    comwriteln ('');

    with ba do begin
      flname := setupper (p);
      dptr := filepos (df);

      if uc. filediz <> 0 then begin
        comwriteln (cs (212));
        for b := 1 to uc. filediz do begin
          s := '';
          comwrite ('|UP: |UI');
          getstr (45, false, false, s);
          if hung then begin
            close (df);
            exit;
          end;
          s := remchars (^M^J^G^H^[^V, s);
          if s = '' then begin
            dec (b);
            if b = 0 then begin
              s := 'No description given.';
              comwriteln (s);
              inc (b);
              write (df, s);
            end;
            break;
          end;
          write (df, s);
          send (clr2eol + ^M^J);
        end;
        ba. dlen := b;
      end;

      comwrite (^M^J + cs (207));
      getstr (30, false, false, pw);
      if hung then begin
        close (df);
        exit;
      end;

      comwrite (^M^J + cs (208));
      getstr (30, false, false, acs);
      if hung then begin
        close (df);
        exit;
      end;

      getmem (tu, sizeof (tuserdata));
      for b := 1 to 10 do begin
        fillin1 := inttostr (b);
        comwrite (^M^J + cs (209));
        tu^. handle := '';
        getstr (30, false, false, tu^. handle);
        if tu^. handle = '' then begin
          comwriteln ('');
          break;
        end;
        if hung then break;
        if lookupuser (tu^. handle, rec) then begin
          readuserrec (tu^, rec);
          priv := priv + 'U' + inttostr (tu^. usernum);
        end else dec (b);
      end;
      freemem (tu, sizeof (tuserdata));
      if hung then begin
        close (df);
        exit;
      end;
    end;
    ubatch^. add (ba, sizeof (ba));
    comwriteln ('');
  until hung;

  close (df);
  if hung then exit;
  comwriteln ('');

  comwrite (cs (161));
  lb := litebar (lbno, true, true);
  if hung then exit;
  if lb = lbquit then goto finish;
  hangupafter := lb = lbyes;

  userealpaths := false;
  proto^. download;

  if not hung then begin
    if not localonly then begin
      uart^. flushinbuffer;
      uart^. drainoutbuffer (180);
      crt. delay (100);
    end;
    if online then refresh;
    if abortxfer then comwriteln (cs (175));
  end;

  dropped := false;

  if not hung and hangupafter then begin
    hangprocparsed := false;
    If (CurStatSet. Path <> '') And Exist (CurStatSet. Path + 'hangxfer.ans') Then
      ShowFileProc (CurStatSet. Path + 'hangxfer.ans', hangxferproc)
    Else
      ShowFileProc (Uc. DispPath + 'hangxfer.ans', hangxferproc);

    for b := 10 downto 0 do begin
      std := biostime;
      putaxy (dashit);
      send (padright (inttostr (b), 2, ' '));

      repeat
        l := readinputnw;
      until ((l < 256) and (l in [kEnter, kEsc, kSftH, kH])) or hung or (et (std) > 18);
      if hung then goto finish;
      if l < 256 then begin
        if l = kEsc then goto finish;
        if l in [kEnter, kH, kSftH] then break;
      end;
    end;

    comwriteln ('');
    hung := true;
    bbs^. disconnect;
    hung := false;
    ModemStrFix (NodeData. OffHookStr);
    online := false;
    dropped := true;
  end;

  stayon := true;
  checkforuplds (true);
  stayon := false;

  if dropped then hung := true;
  if not hung then comwriteln ('');

  with user do
    If TimeLeft = 0 Then Begin
      if not hung then ComWriteLn (Cs (29));
      hung := True;
    End Else If TimeLeft = 1 Then
      if not hung then ComWriteLn (Cs (108)) else
    Else If TimeLeft = 2 Then
      if not hung then ComWriteLn (Cs (107));

  finish:

  if not hung then comwriteln ('');
end;

procedure viewfile (p: str100);
begin
end;

procedure userarea;
begin
end;

procedure extractfiles (p: str100);
begin
end;

procedure searchfile (p: str100);
begin
end;

procedure whoupld (p: str100);
var
  save: FileListOpts;
begin
  with user do begin
    save := filelist;
    filelist := [fl_points, fl_size, fl_Uplder, fl_dateuld];
    listfiles (p);
    filelist := save;
  end;
end;

procedure testfiles (p: str100);
var
  w: word;
  sb: pointer;
  sbt: tbatch;
  std: longint;
  at, la, lc: byte;
  af: file of farearec;
  ba: batchrec;
label
  finish;
begin
  comwriteln ('');
  fillin1 := 'Testing Files';
  pfile ('hdr.ans');
  comwriteln ('');

  sb := nil;
  la := 0;
  lc := 0;
  std := vbatch^. totalnodes;

  if p <> '' then begin
    checkfile (p, valfileexist, false);
    comwriteln ('');
  end;

  if hung then exit;

  with vbatch^ do if std <> 0 then begin
    fillin1 := 'Test';
    comwrite (cs (142));
    if litebar (lbyes, false, true) = lbyes then begin
      comwriteln ('');
      jump (1);
      with ba do for w := 1 to totalnodes do begin
        get (ba);

        if (lc <> conf) or (la <> area) then begin
          assign (af, uc. filepath + 'filearea.' + inttostr (conf));
          reset (af);
          seek (af, pred (area));
          read (af, ar);
          close (af);
          lc := conf;
          la := area;
        end;

        if valfileexist (ba, ar) then
          delnode (activenodeptr)
        else begin
          advance (1);
{          add2batch (ba);}
        end;
        if hung then break;
      end;
      {$I-}
      close (af);
      {$IFDEF Debug}{$I+}{$ENDIF}
      if ioresult <> 0 then ;
    end else begin
      sb := vbatch;
      sbt := batch;
      fillchar (batch, sizeof (batch), 0);
      vbatch := nil;
      new (vbatch, init);
    end;
  end;

  batchadd ('', valfileexist);
  if vbatch^. totalnodes = 0 then goto finish;
  comwriteln ('');

  w := 1;
  vbatch^. jump (1);
  la := 0;
  lc := 0;
  with vbatch^, ba do while w <= totalnodes do begin
    get (ba);

    if (lc <> conf) or (la <> area) then begin
      assign (af, uc. filepath + 'filearea.' + inttostr (conf));
      reset (af);
      seek (af, pred (area));
      read (af, ar);
      close (af);
      lc := conf;
      la := area;
    end;

    fillin1 := ba. flname;
    comwrite (cs (189));
    at := aarctype (ar. path + ba. flname);
    if at = 0 then
      comwriteln (cs (100))
    else
      if atest (at, ar. path + ba. flname) then
        comwriteln (cs (177))
      else
        comwriteln (cs (178));

    with batch, ba do begin
      dec (fleft);
      dec (files);
      dec (bytes, size);
      dec (bleft, size);
      dec (pts, fp);
    end;
    delnode (activenodeptr);
  end;

  finish:

  if sb <> nil then begin
    dispose (vbatch, done);
    vbatch := sb;
    batch := sbt;
  end;

  if not hung then comwriteln ('');
end;

procedure sendfiles (s: pathstr);
var
  lb: litebartype;
  sr: searchrec;
  sb: pointer;
  sbt: tbatch;
  p: pathstr;
  saveit: axy;
label
  finish;
begin
  sb := vbatch;
  sbt := batch;
  fillchar (batch, sizeof (batch), 0);
  vbatch := nil;
  new (vbatch, init);
  s := fexpand (s);
  GetAxy (SaveIt);
  SaveANSi (False, NodeData. TempPath + 'SendSave.Tmp');

  if HasWildcards (s) then begin
    findfirst (s, anyfile - directory - volumeid, sr);
    while doserror = 0 do begin
      fillin1 := sr. name;
      comwrite (cs (139));
      lb := litebar (lbyes, true, true);
      if hung then goto finish;
      if lb = lbquit then goto finish;
      if lb = lbyes then begin
        p := filedrive (s) + ':' + filedirectory (s) + sr. name;
        with batch do begin
          inc (files);
          inc (bytes, fsize (p));
          fLeft := succ (Files);
          bLeft := Bytes;
        end;
        vbatch^. add (p, sizeof (p));
      end;
      comwriteln ('');
      findnext (sr);
    end;
  end else if exist (s) then begin
    p := s;
    with batch do begin
      inc (files);
      inc (bytes, fsize (p));
      fLeft := succ (Files);
      bLeft := Bytes;
    end;
    vbatch^. add (p, sizeof (p));
  end;

  userealpaths := true;
  proto^. upload;
  userealpaths := false;

  finish:

  ReallyUnabortable := True;
  NewStatBar := True;
  ShowStatus;
  ShowFile (NodeData. TempPath + 'SendSave.Tmp', False, False);
  PutAxy (SaveIt);
  DeleteFile (NodeData. TempPath + 'SendSave.Tmp');
  DeleteFile (NodeData. TempPath + 'dsz.log');

  dispose (vbatch, done);
  vbatch := sb;
  batch := sbt;
end;

Procedure rFileMenu (C: Char; P: Str100);
Var
  B: Word;
Begin
  b := strtoint (strip ('A', ' ', p));
  Case C of
    'A': ListAreas;
    'C': changefiles (p);
    'D': download (p);
{}  'N': newscanfiles (p);
{}  'G': customfile (p);
    'K': ListConfig;
    'L': ListFiles (p);
{}  'O': showinfo (p);
{}  'R': resumefile (p);
    'S': GoArea (B, true);
{}  'T': typefile (p);
    'U': upload;
{}  'V': viewfile (p);
    'Z': userarea;
{}  'X': extractfiles (p);
{}  'Y': searchfile (p);
    '[': RelArea (False);
    ']': RelArea (True);
    'W': whoupld (p);
    'B': testfiles (p);
    Else rError ('F' + C);
  End;
End;

Procedure rBatchMenu (C: Char; P: Str100);
Begin
  Case C of
    'E': editbatch;
    'V': batchlist;
    'A': batchadd (p, noval);
    'R': batchdel (p);
    'C': batchclr (ucase (p [1]) = 'N');
    Else rError ('B' + C);
  End;
End;

End.
