Unit Fades;
{$I Sys75.Inc}
{$D-,I-,L-,Q-,R-,S-}
{$UNDEF CHECK}

Interface

Type
  ColArrayType      = Array [1..255] Of Byte;
  RGB               = Record
                        R, G, B : Byte;
                      End;

Procedure SetCol (C, R, G, B: Byte);
Procedure GetCol (C: Byte; Var R, G, B: Byte);
Procedure SetInten (B: Byte);
Procedure InitFade;
Procedure FadeIn (Del: Byte);
Procedure FadeOut (Del: Byte);
Procedure Disolve (C1, C2, Col, Del: Byte);

Implementation

Uses
  TotMisc, TotInput;

Var
  FadeArray         : Array [0..63] Of RGB;

Const
  PelAddrRgR = $3C7;
  PelAddrRgW = $3C8;
  PelDataReg = $3C9;

Procedure SetCol (C, R, G, B: Byte);
Begin
  Port [PelAddrRgW] := C;
  Port [PelDataReg] := R;
  Port [PelDataReg] := G;
  Port [PelDataReg] := B;
End;

Procedure GetCol (C : Byte; Var R, G, B : Byte);
Begin
  Port [PelAddrRgR] := C;
  R := Port [PelDataReg];
  G := Port [PelDataReg];
  B := Port [PelDataReg];
End;

Procedure InitFade;
Var
  I: Integer;
Begin
  For i := 0 To 63 Do
    GetCol (i, fadearray [i].r, fadearray [i].g, fadearray [i].b);
End;

Procedure SetInten (b : Byte);
Var
  i  : Integer;
  fr,
  fg,
  fb : Byte;
Begin
  For i := 0 To 63 Do
  Begin
    fr := fadearray [i].r * b Div 63;
    fg := fadearray [i].g * b Div 63;
    fb := fadearray [i].b * b Div 63;
    SetCol (i, fr, fg, fb);
  End;
End;

Procedure FadeOut (Del: Byte);
Var
  I: Byte;
Begin
  For I := 63 Downto 0 Do
  Begin
    SetInten (I);
    iDelay (Del);
  End;
End;

Procedure Disolve (C1, C2, Col, Del: Byte);
Var
  b: Byte;
  X, Y, z: ShortInt;
  Bool: Boolean;
  col1, col2: RGB;
Const
  c : Array [0..15] Of Byte = (0, 1, 2, 3, 4, 5, 20, 7, 56, 57, 58, 59, 60, 61, 62, 63);
Begin
  col := c [col];

  With col1 Do
    getcol (c [c1], r, g, b);

  With col2 Do
    getcol (c [c2], r, g, b);

  If col1. r = col2. r Then
    X := 0
  Else If col1. r > col2. r Then
    X := - 1
  Else
    X := 1;

  If col1. g = col2. g Then
    Y := 0
  Else If col1. g > col2. g Then
    Y := - 1
  Else
    Y := 1;

  If col1. b = col2. b Then
    z := 0
  Else If col1. b > col2. b Then
    z := - 1
  Else
    z := 1;

  b := 0;
  Repeat
    Bool := True;

    If col1. r <> col2. r Then Begin
      Bool := False;
      Inc (col1. r, X);
    End;

    If col1. g <> col2. g Then Begin
      Bool := False;
      Inc (col1. g, Y);
    End;

    If col1. b <> col2. b Then Begin
      Bool := False;
      Inc (col1. b, z);
    End;

    With col1 Do
      setcol (col, r, g, b);

    Inc (b);

    iDelay (Del);

  Until (b = 63) Or Bool;
End;

Procedure FadeIn (Del: Byte);
Var
  I: Byte;
Begin
  For I := 0 To 63 Do
  Begin
    SetInten (I);
    iDelay (Del);
  End;
End;

End.