Unit Events;
{$I Sys75.Inc}

Interface

Uses
  Dos,
  Spuds,
  TotDate, TotLink;

Type
  fEventsRun = Array [Byte] of Boolean;

  pEventObj = ^tEventObj;
  tEventObj = Object
    Constructor Init;
    Procedure   Load;          {read events.dat into vEvents}
    Procedure   CalcNext;      {calculate which event is next}
    Procedure   ShowNext;      {show which event is next}
    Procedure   SetToggles;    {set xfer toggles and logon acs accordingly}
    Procedure   RunNum (Num: Byte);
    Procedure   Run;           {runs any events scheduled for that minute}
    Procedure   RunForced;     {runs skipped events up to that minute}
    Procedure   ClearRun;      {clears the record of which ones have been run}
    Procedure   ReadRun;       {reads the record of which ones have been run}
    Function    TimeTil: Word; {Time until next event in minutes}
    Function    GetNextStrict: Word; {Time until next strict event}
    Destructor  Done;
    Public
      er: fEventsRun;
    Private
      vEvents: pDLLObj;
      L: datetimerec;
      E: EventRec;
  End;

Var
  Event: pEventObj;
  NextEvent: EventRec;

Const
  EventsForced : Boolean = False;

Implementation

Uses
  Crt,
  TotStr, TotFast, TotMisc,
  RemEmu, Clocks, Misc, Menus, StatusBar;

Constructor tEventObj. Init;
Begin
  vEvents := Nil;
  FillChar (NextEvent, Sizeof (NextEvent), 0);
End;

Procedure tEventObj. Load;
Var
  F: File of EventRec;
  B: Byte;
Begin
  If vEvents = Nil Then New (vEvents, Init);
  If vEvents = Nil Then Exit;
  vEvents^. EmptyList;

  FillChar (NextEvent, Sizeof (NextEvent), 0);

  Assign (F, Uc. DataPath + 'Events.Dat');
  {$I-}
  Reset (F);
  {$IFDEF Debug}{$I+}{$ENDIF}
  If IoResult <> 0 Then Exit;

  For B := 1 to FileSize (F) do Begin
    Read (F, E);
    vEvents^. Add (E, Sizeof (E));
    If B = 255 Then Break;
  End;

  Close (F);
End;

Procedure tEventObj. CalcNext;
Var
  B: Byte;
Begin
  With NextEvent do Begin
    Name := '';
    tStart := 85000;
    Strict := False;
  End;

  if vevents^. totalnodes = 0 then exit;

  Now (L);

  With vEvents^ do
    For B := 1 to TotalNodes do Begin
      GetNodeData (NodePtr (B), E);
      If (E. Node = NodeNumber) Or (E. Node = 0) Then
        If (E. tStart < NextEvent. tStart) And (E. tStart > L. t) Then
          NextEvent := E;
    End;

  If NextEvent. Name = '' Then
    With vEvents^ do
      For B := 1 to TotalNodes do Begin
        GetNodeData (NodePtr (B), E);
        If (E. Node = NodeNumber) Or (E. Node = 0) Then
          If E. tStart < NextEvent. tStart Then
            NextEvent := E;
      End;

  If NextEvent. Name <> '' Then With vEvents^ do
    For B := 1 to TotalNodes do Begin
      GetNodeData (NodePtr (B), E);
      With E do
        If (Node = NodeNumber) Or (Node = 0) And (tStart = NextEvent. tStart) And Strict Then Begin
          NextEvent. Strict := True;
          Break;
        End;
    End;
End;

Procedure tEventObj. ShowNext;
Begin
  With NextEvent do if clock^. vizzy then
    If Name <> '' Then Begin
      Screen^. WriteAt (16, 16, 15, PadLeft (Name, 30, ' '));
      if tstart <> 85000 then Screen^. WriteAt (16, 17, 15, Copy (TimeStr (tStart), 1, 5));
    End Else
      Screen^. WriteAt (16, 16, 8, 'No events defined');
End;

Procedure tEventObj. RunNum (Num: Byte);
Var
  F: File;
Begin
  With vEvents^ do Begin
    if totalnodes = 0 then exit;
    If Num > TotalNodes Then Exit;
    GetNodeData (NodePtr (Num), E);

    Log (2, 'Ran event ' + e. name);

    With E do
      Case Kind of
        eAcs: If L. t = E. tEnd Then
                LogonAcs := NodeData. LogonAcs
              Else
                LogonAcs := Acs;
        eErrorLevel:
             Begin
               Assign (F, NodeData. NodePath + 'Event' + IntToStr (Num) + '.Ret');
               {$I-}
               Rewrite (F);
               {$IFDEF Debug}{$I+}{$ENDIF}
               If IoResult = 0 Then Begin
                 Close (F);
                 SetFAttr (F, Dos. Hidden + Dos. SysFile);
               End;
               If EventsForced And (Num <> vEvents^. TotalNodes) Then Begin
                 Assign (F, NodeData. NodePath + 'Events.Run');
                 Rewrite (F);
                 Close (F);
               End;
               If Clock^. Vizzy Then Begin
                 Status ('Event: ' + Name);
                 iDelay (1000);
               End;
               ForceExit := ErrorLevel;
               Exit;
             End;
        eMenu: Process (mcData, mcParam, False);
        eToggle:
             Begin
               If B (vToggles, 1) <> MakePrn Then Toggle (ttPrn);
               If B (vToggles, 8) <> MakeAvail Then Toggle (ttAvail);
               If B (vToggles, 4) <> MakeBell Then Toggle (ttSpkr);
               If B (vToggles, 2) <> MakeMisc Then Toggle (ttMisc);
             End;
        eXferAllow:
             Begin
               If B (XferAllowed, 1) <> AllowDl Then
                 XferAllowed := XferAllowed xor 1;
               If B (XferAllowed, 2) <> AllowUl Then
                 XferAllowed := XferAllowed xor 2;
               If B (XferAllowed, 4) <> AllowQwkDl Then
                 XferAllowed := XferAllowed xor 4;
               If B (XferAllowed, 8) <> AllowQwkUl Then
                 XferAllowed := XferAllowed xor 8;
             End;
      End;
  End;
  CalcNext;
End;

Procedure tEventObj. SetToggles;
Var
  B: Byte;
Begin
  if vevents^. totalnodes = 0 then exit;

  Now (l);

  With vEvents^ do
    For B := 1 to TotalNodes do Begin
      GetNodeData (NodePtr (B), E);
      With E do
        If ((L. t >= tEnd) And (Kind = eAcs)) Or ((L. t >= tStart) And ((Kind = eAcs) Or (Kind = eToggle) Or
        (Kind = eXferAllow))) Then RunNum (B);
    End;
End;

Procedure tEventObj. Run;
Var
  B: Byte;
  eF: File of fEventsRun;
  t: datetimerec;
Begin
  if vevents^. totalnodes = 0 then exit;

  Now (t);

  With vEvents^ do
    For B := 1 to TotalNodes do Begin
      GetNodeData (NodePtr (B), E);
      If ((E. Kind = eAcs) And (L. t = E. tEnd)) Or (L. t = E. tStart) And Not er [B] Then Begin
        Assign (eF, NodeData. NodePath + 'EventRun.Dat');
        {$I-}
        Reset (eF);
        {$IFDEF Debug}{$I+}{$ENDIF}
        If IoResult = 0 Then begin
          Read (eF, er);
          seek (ef, 0);
        end Else Begin
          Rewrite (eF);
          FillChar (er, sizeof (er), 0);
        End;
        if not er [b] then begin
          er [b] := true;
          Write (eF, er);
          Close (eF);
          RunNum (B);
        End Else Close (eF);
      End;
    End;

  CalcNext;
  If NextEvent. Strict Then ModemStrFix (NodeData. HangupStr);

  If (Current = Waiting) and clock^. vizzy Then Begin
    ShowNext;
    Screen^. WriteAt (44, 17, 15, FormatHourMin (TimeTil));
  End;
End;

Procedure tEventObj. ClearRun;
Var
  F: File of fEventsRun;
Begin
  Assign (F, NodeData. NodePath + 'EventRun.Dat');
  {$I-}
  Rewrite (F);
  {$IFDEF Debug}{$I+}{$ENDIF}
  If IoResult <> 0 Then Exit;
  FillChar (er, sizeof (er), 0);
  Write (F, er);
  Close (F);
End;

Procedure tEventObj. ReadRun;
Var
  F: File of fEventsRun;
Begin
  Assign (F, NodeData. NodePath + 'EventRun.Dat');
  {$I-}
  Reset (F);
  {$IFDEF Debug}{$I+}{$ENDIF}
  If IoResult <> 0 Then Begin
    ClearRun;
    exit;
  End;
  Read (F, er);
  Close (F);
End;

Procedure tEventObj. RunForced;
Var
  B: Byte;
  F: File of fEventsRun;
Begin
  if vevents^. totalnodes = 0 then exit;

  Now (l);

  With vEvents^ do
    For B := 1 to TotalNodes do Begin
      GetNodeData (NodePtr (B), E);
      If ((E. Kind = eAcs) And (L. t = E. tEnd)) Or
         (L. t = E. tStart) And Not er [B] Then Begin
        ComWriteln ('|15* R|07un|08ning |15e|07v|08ent |15#' + IntToStr (B) + '|08. .  .');
        Delay (500);
        Assign (F, NodeData. NodePath + 'EventRun.Dat');
        {$I-}
        Reset (F);
        {$IFDEF Debug}{$I+}{$ENDIF}
        If IoResult = 0 Then begin
          Read (F, er);
          seek (f, 0);
        end Else Begin
          Rewrite (F);
          FillChar (er, sizeof (er), 0);
          Write (F, er);
          Seek (F, 0);
        End;
        er [B] := True;
        Write (F, er);
        Close (F);
        RunNum (B);
      End;
      DeleteFile (NodeData. NodePath + 'Events.Run');
    End;
End;

Function tEventObj. TimeTil: Word;
Var
  n: datetimerec;
Begin
  now (n);
  if NextEvent. tStart = 85000 then begin
    timetil := 0;
    exit;
  end;

  If NextEvent. tStart >= n. t Then
    TimeTil := (NextEvent. tStart - n. t) div 60
  Else
    TimeTil := Pred (1440 - (n. t - NextEvent. tStart) div 60);
End;

Function tEventObj. GetNextStrict: Word;
Var
  B: Byte;
  w, q: longint;
  Z: Word;
  n: datetimerec;
Begin
  now (n);
  GetNextStrict := 0;
  if vevents^. totalnodes = 0 then exit;
  W := 85000;
  Now (l);

  With vEvents^ do
    For B := 1 to TotalNodes do Begin
      GetNodeData (NodePtr (B), E);
      If (E. Node = NodeNumber) Or (E. Node = 0) And E. Strict Then
        If (E. tStart < W) And (E. tStart > L. t) Then
          W := E. tStart;
    End;

  If W = 85000 Then
    With vEvents^ do
      For B := 1 to TotalNodes do Begin
        GetNodeData (NodePtr (B), E);
        If (E. Node = NodeNumber) Or (E. Node = 0) And E. Strict Then
          If E. tStart < W Then
            W := E. tStart;
      End;

  if W = 85000 then begin
    GetNextStrict := 0;
    exit;
  end;
  Z := MinPastMidnite (W);
  q := MinPastMidnite (n. t);
  If Z >= q Then
    GetNextStrict := Z - q
  Else
    GetNextStrict := Pred (1440 - q + Z);
End;

Destructor tEventObj. Done;
Begin
  If vEvents <> Nil Then Dispose (vEvents, Done);
End;

End.
