
The User's View
Introduction
Introduction

	      Many of the problems associated with BBS software are
	 likely to be the result of some user's action, or something
	 noticed by one of the users.  As sysop, you can better help
	 the user by knowing what's happening on the user side of the
	 BBS.  That is one reason for the following section.  Another
	 reason is the fact that BBS packages don't usually come with
	 documentation dedicated to helping the user learn its
	 operation.
	      The following is a description of SwiftBBS as the
	 User will view it.
Logon (file displays)
Logon


	      When a user calls a SwiftBBS system, he is initially
	 greeted with a SwiftBBS identification note, followed by a
	 sysop defined introduction screen identifying the BBS.
	 Following these displays, the user is asked for his name.
	 If the user's name is found in the user file, he's asked
	 for his password.

	      New users are required to complete a questionnaire
	 that will determine their configuration when calling the
	 system. During configuration, some options will allow the
	 user to select the (safe) default by pressing enter when
	 prompted. Most options can also be changed later if desired.
	 The initial questions include queries for name, location and
	 password to use.  What questions are asked during the rest of
	 the new user logon is determined in most part by the sysop's
	 selections.

	      These optional queries include length of display-screen
	 (may vary depending on 25/43/50 video modes), clearscreen
	 option (whether to clear the screen between displays), screen
	 pause (more?  y/n), ansi graphics, full screen editor, avatar
	 graphics, automatic mail checking, home phone, data phone,
	 user name, handle, signature use (whether to automatically
	 sign messages), birthdate, age, sex, hidden status and user
	 interests.  Following are some notes about some of these
	 queries.

	 Graphics mode:
	      The video mode that the caller uses depends on the
	 callers local configuration.  The following problems are
	 common to selecting the incorrect video configuration.

	      If garbage characters appear on the screen that include
	 numbers, semicolons and brackets ([35;34f....), the BBS is
	 sending ANSI codes and the user hasn't loaded the device
	 driver to interpret them.  You will either need to load an
	 ANSI driver or select no color.  DOS comes with ANSI.SYS that
	 must be included in the CONFIG.SYS file.  An alternate
	 ANSI.COM is also available for interpreting ANSI codes.

	      If the characters include punctuation, music & graphic
	 characters, and frequent beeps, that suggests that the BBS is
	 sending AVATAR codes and the user either isn't using a
	 terminal program that supports AVATAR or hasn't loaded a
	 device driver for them.

	      AVATAR is a new, quicker method of sending remote
	 color/graphic codes.  Some terminal programs support AVATAR
	 codes internally, and there are a few device drivers
	 available for the local console.  In order to use AVATAR
	 codes, the sysop will need to have a console driver
	 installed. SwiftBBS was developed and tested with the ZAVT
	 combined ANSI / AVATAR console driver.

	 Logon names:
	      SwiftBBS may make use of three optional names for a
	 user.  A User Name, Account Name, and Handle are provided
	 for.  The User Name is what is used in all standard displays
	 and messages.  The Account Name can be used to accept
	 messages directed to a designated alias or company.  At this
	 writing, only the SysOp may enter the Account Name in the
	 user file.  This is also a read-only name as only the User
	 Name and Handle are used in the From field.  The Handle is
	 only used in designated and approved areas.  Users may use
	 either one of them during logon, though they can't be used
	 interchangeably for messaging.  SwiftBBS will not allow a
	 user to use another users Name or Handle when selecting a
	 User Name or Handle.

	 Mail checking:
	      Mail checking is one of the more common functions
	 provided during logon.  With mailchecking, SwiftBBS searches
	 the message base for unreceived messages addressed to the
	 user and gives the user the option to read and/or reply to
	 them. This can either be set by the sysop or the sysop may
	 allow the individual user to select mail checking. A third
	 option is for the sysop to include it as an autoexec option
	 in a custom menu.

	      Most of these queries can also be asked at a later time
	 as part of a custom questionnaire or menu function so the
	 order may be different on the specific BBS you use.

	      Following the internal system questionnaire, new users
	 may also have to answer one or more custom questionnaire(s)
	 designed by the sysop.  This may include any type of display
	 or question and may even be used to generate a introductory
	 message for the new user.

	      Following the successful logon, a welcome file may be
	 displayed matching the user's video mode selection.  This is
	 customarily a graphic display of some type.  As with most
	 textfile displays, selecting 'P' will pause and 'S' will
	 abort the display.  Frequent callers may want to bypass these
	 time-consuming displays.  If there is an active NEWS file,
	 that will be shown next.

	      If mail checking is active, a search is made for
	 unreceived mail addressed to the user.
Internal menus
Introduction
Introduction


	      From there, the options may be controlled by sysop
	 defined menus.  If the sysop doesn't customize menus,
	 SwiftBBS will provide a set of standard menus that may be
	 used for most functions on the system.  The use of the
	 standard menus is what I started calling opus menus, or opus
	 style menus, since there are usually displayed with a bar and
	 the initial letter of selections are highlighted similar to
	 Opus-CBCS systems.

	      From these standard menus you can have access to all
	 available message areas, with options for read, scan, and
	 enter.  Other features are provided for changing setup.
	 Sample displays of these menus are illustrated below (minus
	 the color).  The actual display may vary slightly for newer
	 releases.  Depending on the display, the initial character
	 for each option is either highlighted or bracketed, as in
	 M)essages.
The MAIN Menu
The MAIN Menu


	 The MAIN Menu

	 Message section Files            Bulletins
	 Setup options   Information      Network section
	 Quickmenus      Goodbye (logoff) ?Help
	 SELECT:

	      Primary options available from The MAIN Menu include:

	 M)essage section -- transfers control to the message section
	    panel described below.
	 F)iles -- transfers control to the File section.
	 B)ulletins -- executes a selection menu to display bulletin
	    files.
	 N)etwork section -- tranfers control to the Network section
	    described below. Network options include node lookup and
	    file requests.
	 S)etup options -- transfers control to the Change Setup
	    panel described below.
	 I)nformation -- transfers control to the Information panel.
	 Q)uickmenus -- transfers (or returns) control to customized
	    menus beginning with the top menu.
	 G)oodbye -- logs off the user and terminates the program.
	 ?)Help -- displays a sysop's help file related to this
	    section. Files supplied with the SwiftBBS release may
	    include this description as the help file.
The Message Section
The Message Section


	 The Message Section menu lists the number of messages on the
	 system, the number of messages in the current message area,
	 the type of message area (ECHO, NET, LOCAL), the area number
	 and description name of the message area.  Two slightly
	 different menus are displayed depending on the message area
	 currently active.  If combined messages are active, the
	 display will show an option to P)ick areas to include in
	 combined reading.  If an area is selected, the display will
	 show an option to go to the >)Next or <)Last area available
	 for reading.


	 The Message Section
	 System has 14 messages numbered 1 to 14.
	 There are 9 messages in this area.

	 ECHO area 20 ... BabyNet
	 Read msgs    Enter msg  List msgs  Scan msgs  Checkmail !List ac..
	 Area change  >Next area <Last area Main Menu  Goodbye   ?Help
	 SELECT:


	 Combined messages
	 Read msgs    Enter msg  List msgs  Scan msgs  Checkmail !List ac..
	 Area change  Pick areas Main Menu  Goodbye    ?Help
	 SELECT:



	      Options available from The MESSAGE Section include:

	 R)ead messages -- Reads messages in the active message
	    area, provided the user's access levels are adequate for
	    the message area.
	 E)nter message -- Allows you to enter a new message in the
	    active area. If combined is selected, you will be prompted
	    for an area.
	 L)ist messages -- Lists messages with From, To, Subject for the
	    active area.  If selected from combined areas, the message
	    board will also be displayed.
	 S)can messages -- Allows you to display the message headers
	    in the active area.
	 C)heck mailbox -- Displays a list of un-received messages
	    addressed to you, and gives you an option to read them.
	 !)List active -- Lists all boards (with or without names),
	    with active messages.
	 A)rea change -- displays a list of named message areas.
	    Selecting 0 selects combined areas. Combined settings in
	    CONFIG.A determine the areas initially included in combined
	    access. You should P)ick the areas you're interested in.
	    The last area used is saved at logoff.
	 P)ick areas -- This option is only shown if you are in
	    combined areas.  This will allow you to select the areas
	    to use in combined reading.  Your selections will be used
	    during the current session and can optionally be saved for
	    future use.
	 >)Next  <)Last  --  These options are only shown if you are
	    not in combined areas. This will allow you to press '>'
	    or '<' to go to the next/previous message area that
	    either has messages or that is named.
	 M)ain Menu -- returns to the Main Menu.
	 G)oodbye -- logs off the user and terminates the program.
	 ?)Help -- displays a sysop's help file related to this
	    section. Files supplied with the SwiftBBS release may
	    include this description as the help file.
The File Section
The File Section


	 The File Section is designed to use the external file
	 transfer program, CEXYZ.  The name of the program used can be
	 changed to use another program name, but since file transfers
	 are very new in SwiftBBS, so there is not yet a mechanism for
	 changing options or adding protocols.  Note: CEXYZ is a free
	 program available from Cutting Edge as this is written.


	 The File Section

	 List files     Download         Upload
	 Main Menu      Goodbye (logoff) ?Help
	 SELECT:

	      Options available from The File Section include:

	 L)ist files -- displays a list of files in the standard
	    DownLoad path.
	 D)ownload -- Allows the user to download a file from the
	    standard DownLoad path.
	 U)pload -- Allows the user to upload a file to the standard
	    UpLoad path.
	 M)ain Menu -- returns to the Main Menu.
	 G)oodbye -- logs off the user and terminates the program.
	 ?)Help -- displays a sysop's help file related to this
	    section. Files supplied with the SwiftBBS release may
	    include this description as the help file.

	 When Download or Upload is selected, a protocol menu is
	 then displayed and the user is able to select a protocol.

	 Enter filename (ENTER to exit):

	 XModem    1 XModem-1K    YModem    G YModem-g
	 ZModem    Quit (Abort)   ?Help
	 Select protocol:

	 Once a protocol is selected the user will need to execute
	 the same protocol in his terminal program in order to begin
	 the transfer. Auto-ZModem is an exception to this
	 requirement and for that reason, ZModem may be preferred.
The Network Section
The Network Section


	 The Network Section

	 File Request  Node search  Main Menu  Goodbye (logoff) ?Help
	 SELECT:

	      Options available from The Network Section include:

	 F)ile Request -- if enabled by the sysop, allows the user
	    to make a file request (FReq) through BinkleyTerm. Freqs
	    are also logged in the SYSTEM.LOG.
	 N)ode search -- searches the nodelist and displays system
	    information about the selected net/node number.
	 M)ain Menu -- returns to the Main Menu.
	 G)oodbye -- logs off the user and terminates the program.
	 ?)Help -- displays a sysop's help file related to this
	    section. Files supplied with the SwiftBBS release may
	    include this description as the help file.
The Information Section
The Information Section


	 The Information Section

	 User List       Calls Today   About ...          Version
	 Yell at sysop   Main Menu     Goodbye (logoff)   ?Help
	 SELECT:

	      Options available from The Information Section include:

	 U)serList -- displays a listing of active users, city and
	    last time on.  The sub-menu allows you to search by Name,
	    Location or Interest.  Enter a part of the name to limit
	    the display to fewer names.  A global search '*' is
	    supported for both options to allow searching within the
	    field.  The '*' should be used as the initial character
	    in the search.
	 C)alls Today -- displays a list of callers who've called
	    today, with location, baudrate, and number of calls to
	    date.
	 A)bout ... -- displays a sysop's descriptive file
	    telling about something. Files are supplied with the
	    SwiftBBS release for this purpose, though the operator
	    may include any subject material, such as a description
	    of the individual system.
	 V)ersion -- displays the current version of SwiftBBS.
	 Y)ell at sysop -- prompts for a comment and activates the
	    local bell to get the sysop's attention.
	 M)ain Menu -- returns to the Main Menu.
	 G)oodbye -- logs off the user and terminates the program.
	 ?)Help -- displays a sysop's help file related to this
	    section. Files supplied with the SwiftBBS release may
	    include this description as the help file.
The CHANGE SETUP Section
The CHANGE SETUP Section


	 The CHANGE SETUP Section

	 1 Location   5 Screen Length   9 Ansi codes     C Checkmail
	 2 Password   6 Screen Width    0 Avatar codes   D AutoSign Msgs
	 3 Handle     7 Clearscreen     A Full-scrn ed.  E User signature
	 4 Interests  8 More (Y/N)      B Hide in list   Yell at sysop
	 Main Menu    Goodbye (logoff)  Review setup     ?Help
	 SELECT:

	      Options available from The Change Setup Section include:

	 1)Location -- allows the user to change the city, state
	    information in the user file.
	 2)Password -- allows the user to change his password. This
	    option requires that the user enter his current password
	    and the new password to use.
	 3)Handle -- allows the user to select or change his handle.
	 4)Interests -- allows the user to enter or change his
	    interests.
	 5)Screen Length -- allows the user to change the display
	    screen length.
	 6)Screen Width -- not active in this version
	 7)Clearscreen -- allows the user to toggle screen-clearing
	 8)More (Y/N) -- allows the user to toggle page-pausing.
	    between messages.
	 9)Ansi graphics -- toggles the use of ANSI.SYS
	    color/graphics display codes.
	 0)Avatar -- toggles the use of AVATAR.SYS color/graphics
	    display codes.  Since this requires a local display
	    driver, individual systems may have this disabled.
	 A)Full-scrn edit -- toggles the use of a full screen editor.
	    This option requires color/graphics ANSI displays
	 B)Hide in list -- allows the user to change his 'hide'
	    status on the BBS.
	 C)Checkmail -- allows the user to change his automatic mail
	    checking option. System options may over-ride automatic
	    mail checking.
	 D)AutoSign -- automatically signs all messages with the
	    text in the User Signature field.
	 E)User Signature -- allows the user to enter or change his
	    signature.
	 Y)ell at sysop -- prompts for a comment and activates the
	    local bell to get the sysop's attention.
	 M)ain Menu -- returns to the Main menu.
	 G)oodbye -- logs off the user and terminates the program.
	 R)eview -- (new option) displays the users current status
	    similar to this display.

	   User Name: Joe Williams         First call: 8/27/94
	   Handle: Little Joe              Last call:  8/27/94  (12:20)
	   Location: Tyler, Tx             Security:   1
	   Flags  A:[-XX---X-] B:[XX-X-XXX] C:[---X--X-] D:[----X--X]
	   Account: Baby Blue Computers
	   Hidden......... ON    Ansi........... ON    Full-scrn edit. ON
	   Screen length...23    Avatar......... ON    Full-scrn view.OFF
	   Screen width....80    GUI............OFF    Mail checking.. ON
	   More?.......... ON    Clearscreen.... ON    Auto signature.OFF
	   Highest message read....1
	   Signature: From my electronic Ponderosa ... Little Joe
	   Interests: cows, horses, farming, cc music

	 ?)Help -- displays a sysop's help file related to this
	    section. Files supplied with the SwiftBBS release
	    include this description as the help file.
Default Message Menu
Default Message Menu


	      One other menu that might be considered an "Opus style"
	 is a menu type for a message area.  It is a custom option
	 menu "type" that provides options for Reading, Scanning, and
	 Entry of messages in the same manner as the Message Section
	 described above.

	 The MESSAGE Section
	 System has 37 messages numbered 1 to 37.
	 There are 2 messages in this area.

	 ECHO area 1 ... LOCAL
	 Read messages  Enter message  Swiftscan
	 Previous Menu  Goodbye        ?Help
	 SELECT:

	      Options available from Default Message Section include:

	 R)ead messages -- Reads messages in the active message
	    area, provided the user's access levels are adequate for
	    the message area.
	 E)nter message -- Allows you to enter a new message in the
	    active area. If combined is selected, you will be prompted
	    for an area.
	 S)wiftscan -- Lists messages with From, To, Subject for the
	    active area.  If selected from combined areas, the message
	    board will also be displayed.
	 P)revious Menu -- returns to the previous menu.
	 G)oodbye -- logs off the user and terminates the program.
	 ?)Help -- displays a sysop's help file related to this
	    section. Files supplied with the SwiftBBS release may
	    include this description as the help file.
Slash Commands
Slash Commands


	      In addition to Internal menus, SwiftBBS also provides a
	 standard commandline interface within both custom and
	 internal menus called Slash commands.  Slash commands will
	 enable you to execute selected options from all key menus by
	 pressing '/'.  At the prompt "Slash command:", enter a
	 keyword.  As a reminder of how to use Slash commands, you can
	 enter the keyword HELP or '?' to get a display similar to
	 this:

	    Slash Command: ?
	    Slash commands will enable you to execute
	    selected options from all key menus by pressing
	    '/' followed by a keyword
	    Valid Slash commands are. . .
	    PAGE      VER       TIME      QUICK     INFO
	    SETUP     COLOR     MAIL      MAILBOX   NEWMAIL
	    MESSAGE   QUIT      HELP      LIST      ?


	 Following is a list of the keywords in this version and
	 reference to the menu type used:

	 PAGE -- prompts for a comment and activates the local bell to
	    get the sysop's attention.  This is the same as the Y)ell,
	    and custom menu type 11.

	 VER -- displays the current version of SwiftBBS.  This is the
	    same as the V)ersion, and custom menu type 8.

	 TIME -- Show the time left.  same as ...  and custom menu
	    type 14.

	 QUICK -- transfers (or returns) control to customized menus
	    beginning with the top menu.  This is the same as the
	    Q)uickmenus.

	 GO -- allows the user to jump to a designated menu. (This
	    is still in development).

	 GOSUB -- allows the user to call (gosub to) a designated
	    menu. (In development)

	 RETURN -- allows the user to return to a previous menu.
	    (In development)

	 INFO -- transfers control to the I)nformation panel.  This is
	    the same as custom menu type 89.

	 SETUP -- transfers control to the internal Change Setup
	    panel.  This is the same as the S)etup Options, and custom
	    menu type 86.

	 COLOR -- toggles the use of ANSI.SYS color/graphics display
	    codes.  This is the same as the A)nsi graphics option, and
	    custom menu type 21.

	 MAIL -- transfers control to the internal Message section
	    panel.  This is the same as custom menu type 87.

	 MAILBOX -- Displays a list of un-received messages addressed
	    to you, and gives you an option to read them.  This is
	    same as the C)heck mailbox option, and custom menu type
	    22.

	 NEWMAIL -- Lists all message areas (with or without names),
	    with active messages and a '*' indicating areas with new
	    messages.  This is the same as !)List active, and custom
	    menu type 94.

	 MESSAGE -- Allows you to enter a new message in the active
	    area.  If combined is selected, you will be prompted for
	    an area.  This is the same as the E)nter message option
	    and custom menu type 27.

	 QUIT -- logs off the user and terminates the program.  This
	    is the same as G)oodbye and custom menu type 9.

	 HELP or ?  -- Explains Slash commands and displays a list of
	    currently valid commands

	 LIST -- Lists valid Slash commands.


	      If a slash command is used to branch to another menu
	 (i.e.  SETUP), you must exit that menu in order to re-enable
	 Slash commands.  If you attempt to execute Slash commands
	 otherwise you may be warned, "Slash command still active".

	      If a slash command is not found in the table, you may be
	 notified, "Invalid Slash command", followed by a list of
	 valid commands.  SwiftBBS configuration may be used to
	 restrict access to slash commands to those with a designated
	 security level.
Bulletins
Bulletins


	      The bulletin option in SwiftBBS provides a simple to
	 use way to navigate through a series of bulletin files.
	 Bulletins are setup with a contents and individually numbered
	 bulletins. The contents should list and describe each of
	 the bulletin files.

	      When the bulletin prompt is displayed, the user must
	 enter a bulletin number in order to view the bulletin.  If
	 page-pausing is enabled, display will pause at the end of
	 each screen and query for More.  At the end of the file,
	 the prompt will be redisplayed.

	      Bulletin options are not hotkeys.  You will have to
	 press enter after entering your choice.  When a number or
	 character is entered, SwiftBBS looks for and displays the
	 associated bulletin.

	      Following display of any numbered bulletin, <Enter> or
	 'N' will increment the bulletin number, search for and
	 display that bulletin.  Selecting 'B' will decrement (go
	 Back) the bulletin number, and selecting 'A' will redisplay
	 the current bulletin.

	      Selecting 'S' (for stop) or 'Q' (for quit) will exit the
	 bulletin number.  Selecting 'L' will redisplay the bulletin
	 list.  When the bulletin contents (list) is displayed,
	 <enter> will exit the bulletins option.
Messaging
Introduction
Introduction


	      Messaging is a term that refers simply to reading and
	 writing messages to other users. It's used in contrast
	 to other common activities on Bulletin board systems,
	 such as gaming, downloads, etc. Messaging is the major
	 purpose of SwiftBBS, so it's important to understand it's
	 applications.

	      Most message areas or message boards fall into one of
	 three categories, LOCAL, NET, or ECHO.  LOCAL mail is used
	 when users leave messages to other users on the same Bulletin
	 Board System.  Messages may be part of a topical conference,
	 personal notes, and can be public or private.  With the
	 advent of NETMAIL and ECHOMAIL and all of their advantages,
	 LOCAL mail is usually limited to private notes.

	      NET mail is a step up from LOCAL in that messages are
	 directed from one user to another user, generally on another
	 Bulletin Board System.  In order to facilitate the use and
	 delivery of NET mail, the BBS must be a part of a Network,
	 such as FamilyNet, FidoNet, or ETNet.  Because of the LD
	 costs inherent in using NET mail, some systems limit users'
	 access to NETMAIL.

	      When entering NET mail messages, you will need to know
	 the net/node number as well as the individual's name.  In
	 some cases, you may be able to send (File Attach) other files
	 along with the message.

	      ECHO mail makes up the bulk of messaging today.  ECHO
	 mail (or ECHOMAIL, ECHOES) is the use of shared topical
	 message conferences.  When a message is entered into an ECHO
	 area, it is eventually distributed to all other boards
	 carrying that particular topical conference.  Its use is
	 monumental considering that messages can be distributed
	 around the world in a day or two.  Likewise, its misuse can
	 be devastating.

	      Because of the possibility of misuse, many BBS systems
	 will verify new users by voice phone or mail before granting
	 access to echomail areas.
Electronic mailbox
Electronic mailbox


	      In one sense, your use of a SwiftBBS bulletin board
	 gives you an electronic mailbox with an option that will
	 check the messagebase and tell you of messages addressed to
	 you.  These messages include only messages not previously
	 read.  This option is available from the Message Area as
	 C)heck Mailbox.  The sysop of the particular board may also
	 configure the logon procedure to automatically notify you of
	 unreceived messages, or you may also have an option to check
	 for unreceived messages each time you logon.
	      Due to the time involved in checking large message
	 bases for new mail, you can also interrupt mailchecking by
	 pressing 'S'.

	    Checking for new mail addressed to you ...
	    You have the following new mail waiting:

	    Message Board     Message Numbers
	    ----------------- ---------------------------
	    (Unknown area)    5, 7
	    DIARY             35
	    (Unknown area)    73

	    Read messages Now? (Y/n)

	      Once you read a message addressed to you it is normally
	 marked as "received".  System operators have the option to
	 "un-receive" messages for reading later.  In order to re-read
	 messages addressed to you in any area, you may select
	 R)ead/S)elected/M)ine from the message area prompt.

	      Messages displayed in SwiftBBS will usually resemble
	 the following sample with individual parts identified. All
	 of the messages in a SwiftBBS messages area are kept in a
	 single set of files, and numbered chronologically. The
	 topical area they belong to is indexed. The message number
	 refers to the global number, not the number of message in
	 the particular area.
	      Each message area is normally identified with a
	 Topical message area 'title', as "Technical" below. In
	 echomail transfers, the area may have an areatag, such as
	 TECH.
	      The message header shows the basic information about
	 the message. Often, the header is scanned over until there
	 is a message of interest.
	      In order to facilitate comprehension of an ongoing
	 conversation, it's traditional to quotes parts of a message
	 to regain users' train of thought in the discussion.  The
	 paragraph below noted as Quote is the current user's quote of
	 the previous person's message.  Quoted lines are identified
	 with a right angled bracket ( > ), often with the quoted
	 person's initials preceding it.  Multiple arrows ( JF>>> )
	 refer to quotes of quotes, etc.
	      Often times, users may use abbreviations such as OTOH
	 for 'on the other hand', or BTW meaning 'by the way', etc.

	      Since messaging can often be too impersonal, some
	 users may include such personal notes in parentheses, i.e.
	 <grin>, <hint>, etc. Smiley faces (sideways) are also used
	 for the same reason. Two of the most common faces looks
	 like this. :-) :-(
The Disected message
The Disected message


		     Message number
		            Topical message area
		         
	 Message #53 "Technical"      Read 5 times  Ŀ
	 Date:  5/10/92 @ 10:56                              Message
	 From: Mike Hubschman                              Header
	 To:   Warren Zatwarniski                        
	 Subject: Re: Modem Oddities                
	 Next Reply Message is #306

	 ^aPID SE 0.45i    kludges
	   Initials of person quoted
	  
	 WZ> Does anybody know what kinda speed is       Ŀ
	 WZ> capable out of a normal 2400 bps modem         Quote
	 WZ> without MNP or bis ?????                    

	 A good rule of thumb is divide the speed by     Ŀ
	 10.  a 2400 bps rate would get 240 cps at 100%    
	 efficiency.  Most get a little less, so 230 is    
	 a "normal" rate.  Ditto 9600 - 960 cps is          Reply
	 optimum, normal is 940-950.  This is with         
	 Ymodem-g or Zmodem (moby) (Xmodem slows things    
	 down a lot)                                     

	 WZ> I don't think that those MNP modems are
	 WZ> much more than a normal one eh?  Mayb I can
	 WZ> find a used one (cheap) kicking around
	 WZ> someplace?..hint...hint..  :-)
					 
					   Smiley face
	 Unfortunatly, they really jack up the price with Mnp...
	 Some add as much as 50% to the price...  ($89 for a
	 2400, $129 with MNP...) Since 9600's can't work without
	 some error correction, they only have one price range
	 but add a lot for increased speed (14.4 or 16.8)

	     Offline reader
	  * OLX 2.2 * He's got a magnet! Everybody stand back!
	 ---                                                 < Tearline
				  Originating system
		    Ŀ      Network address
	  * Origin: SOX! BBS 821-3317 Hialeah, FL (1:135/71)  Origin line
	 SEEN-BY: 117/331 170/100 400 403 600 711   Ŀ
	 SEEN-BY: 170/800 382/1 383/300 387/823         Seen-bys
	 SEEN-BY: 388/1000 393/101 3801/6 8         
	 ^aPATH: 135/71 135/41 13/13 396/1 3801/8    Path line
							  (usually hidden)
	 <+> Read Replies                           Ŀ
	 <A>gain, <N>ext, <B>ack, <S>top?               Prompt
						    

	      As a means of identifying the technical nature of
	 particular messages, several fields are included at the end
	 of each message.

	      The Tearline (three dashes) indicates the end of the
	 message text, and may also show the name of the program used
	 to edit or pack the message.  The Origin Line is needed to
	 identify the source of the message.

	      Seen-bys and Paths are used to monitor the messages
	 travel through the network, and may be used to detect or
	 prevent duplicate messages in the message base.
Reading messages
Reading messages


	      Most message conferences deal with a particular topic
	 and may include discussion of several subjects related to the
	 topic.  Consequently, most messages in topical conferences
	 can also be read and responded to, even if they aren't
	 addressed to you.

	      Messaging prompts are provided with Read, List and Scan
	 options to allow you to select specifics.  Explaining the
	 options available is probably more difficult to explain than
	 to actually use.  Most users will learn to use these options
	 intuitively.  The initial prompt is:

	    N)ew Messages  F)orward      R)everse Order  M)arked msgs
	    S)elected      I)ndividual   Q)uit (Abort)   ?)Help

	    Option:

	      Subsequent prompts will depend on the option selected.
	 When selecting Forward or Reverse, you will be supplied with
	 information about the message base and the messages within
	 the selected area, and then queried on the message number to
	 start with.  In all cases, you can select to pause after each
	 message or not.

	   Active Message Board: "Combined messages
	   System has messages numbered 1 to 14.
	   Enter number to start at, [Enter]=First:
	   Pause after each message? (Y/n)

	      Selecting New messages will start in forward order
	 following the last message you read the previous time you
	 logged in.  SwiftBBS maintains this information even when
	 messages are renumbered.  SwiftBBS doesn't update the "last
	 message read" pointers until you logoff, and only uses the
	 last message number in "Forward" order.

	      When reading I)ndividual messages, SwiftBBS will prompt
	 for a message number and display the message at or following
	 the number entered.
	      Selecting ?)Help attempts to find and display a
	 customized file describing the entries.

	      During messaging reading, you may also have additional
	 options to enable you to back up, or follow threads.
	 Following each message, you can select from a submenu
	 resembling this:

	    -) Read Previous Replies, +) Read Replies
	    A)gain, N)ext, L)ast, *)non-stop, R)eply, S)top?

	      The N)ext option will go to the following message if
	 you are reading Forward, or the subsequent message if you are
	 reading Reverse.  The L)ast option has the reverse effect.

	      The option to read S)elected messages will prompt you
	 for F)rom, T)o, S)ubject, M)ine, and further give you an
	 option to select the starting number.  The S)ubject option
	 will search the subject line for any occurences of the
	 pattern you specify in the subject line.
Replies to messages
Replies to messages


	      When replying to messages in topical conferences,
	 messages should be relative to the discussion and the subject
	 of the message area, or conference, and normally on the same
	 subject of the individual message you are responding to.

	      The R)eply option will quote the message you are
	 replying to and execute the proper message editor.  Using the
	 message editors is covered in the next section.

	      Reply reading options (- or +) displayed will depend on
	 the links the message actually has with previous/following
	 messages.  These are also known as "threads".  The submenu
	 during reply reading will also conform to the option you've
	 selected and return you to the current message following the
	 last message in the option.  Additionally, you can switch
	 directions when reading a thread.  When reading previous
	 replies, you may be able to read following replies by
	 selecting the proper option.

	      Some message areas may require higher access privileges
	 in order to read, enter or reply to messages in them.  In
	 these cases, a message will be displayed to that effect.
	 Some of these areas may be restricted to verified users,
	 members of an organization, or system operators.

	      If your access is suitable for message entry in a
	 particular area, you may want to add a message in response to
	 one you are reading.  You can either enter a new message or
	 reply to the existing message.  By replying to messages, your
	 message is added to the message-chain or thread.  That allows
	 other users to follow the subject of the message and view
	 previous or subsequent replies.

	      When replying to messages using an external editor, you
	 will be prompted:

	 Quote Reply Text? (Y/n)

	      When replying to a message it's often helpful to be able
	 to view and/or quote parts of the message you are replying
	 to.  This also helps other readers follow the train of
	 thought without restating the subject of the message again.
	 If you are using a supporting message editor, quoting reply
	 text will export the current message and prefix the quoting
	 characters to enable you to do that.

	      When quoting reply text, the current message is saved
	 with each line preceded by the configured quoting string.
	 This will normally be the original authors initials.  This
	 text is presently only accessible from an external editor.

	      Following that, you are then given a chance to change a
	 number of things. This version makes a change in the way
	 this is asked, so that you can only press enter if nothing
	 changes.

	 Replying to Dana Bell's message to All in BBC ...
	  Area   : BBC
	  From   : Dana Bell
	  To     : Dana Bell
	  Subject: New User on Home's Cool Board
	 Change anything (y/N)?  Y

	      The default is to reply to the person writing the
	 message.  If you want to reply to the person that he was
	 writing to, you can select 'Y' to change, 'T' to change who
	 it's to, and 'R' to select the recipient.  Alternately, you
	 can select 'S' for somebody else and you will be prompted for
	 a new name.

	  A)rea   : BBC
	  T)o     : Dana Bell
	  S)ubj   : New User on Home's Cool Board
	  Q)uit message.
	 What do you want to change? (Enter)=Nothing  T

	  O)riginator : Dana Bell
	  R)ecipient  : All
	  S)omebody else.
	 Address message to whom? (Enter)=No change

	      The default is also to reply in the same message area,
	 however, you may want (or may have been asked) to reply to
	 the message in a different area.  To do this, select 'Y' to
	 change, 'A' to change area, and select an area from the list
	 of areas displayed.

	      If the discussion has walked away from the subject
	 that's included in the S)ubject line, you might also want to
	 enter a more appropriate or meaningful description for the
	 subject line.  Your reply will still initially be linked to
	 the message you are replying to, but will eventually be
	 "pruned" from the original thread when messages are
	 re-linked.

	      Replies to Netmail messages also allow you to change the
	 destination address.
New Messages
New Messages


	      When selecting to enter a NEW message in a LOCAL or
	 individual ECHO, you will be prompted for To: and Subject:
	 lines.  At either prompt you can abort the message by not
	 entering anything and pressing enter.

	      When entering messages from the combined board area you
	 will also be prompted for a message area.  Enter the
	 appropriate number from the Area list.

	      If you want to enter a message to the system operator,
	 you can use the name "SySop", and SwiftBBS will substitute
	 the system operator's name in any non-Netmail area.

	      When entering messages from a NETMAIL area, you will
	 also be prompted for a net/node number.  Enter the
	 appropriate net/node number in the format NNN/NNN.  The
	 net/node number is used as a reference to the system's name,
	 location and phone number in the nodelist.

	      If QNL*.* nodelist files are found, the selected network
	 board's name, location, baud rate, and cost will be
	 displayed.  For network routing of messages the net/node
	 number is also used to send to a centralized system for
	 distribution.

	 Currently searching in Zone 8, Net/Group 8101 ...
	 Enter 'L' to List Nodes, 'C' to Change Net/Group,
	 or 'Z' to change Zone. <Enter> quits
	 Enter net/node address => 8101/8

	 Searching nodelist index, please wait . . .

	  8101/8  Baby Blue      Tyler TX
		 1-903-581-6077   baudrate: 9600,   cost:     0

	 Is this destination correct [Y/n]?
	 Attach files to message? (Y/n) N
	  formatting ... (8:8101/8.0)
	 To: ........


	      Entering 'C' will allow you to change the currently
	 selected Net or Group.  Entering 'L' from the net/node prompt
	 will display a list of the boards in the currently selected
	 Net or Group.  Entering 'Z' will allow you to change the
	 currently selected zone.  SwiftBBS defaults to the systems
	 own Zone and Net.


	 Currently searching in Zone 8, Net/Group 8101 ...
	 Enter 'L' to List Nodes, 'C' to Change Net/Group,
	 or 'Z' to change Zone. <Enter> quits
	 Enter net/node address => C

	 Change to what Net or Group: 8

	 Currently searching in Zone 8, Net/Group 8 ...
	 Enter 'L' to List Nodes, 'C' to Change Net/Group,
	 or 'Z' to change Zone. <Enter> quits
	 Enter net/node address => L



	 The node search/selection interface above is also used in
	 the File Request function.
Message editors
Message editors


	      Messages can be entered on-line with either the internal
	 editor or an external editor such as QuickEd.  The use of an
	 external message editor is primarily for color/graphics
	 display (ANSI) users.  External editors are written by other
	 authors and will usually differ in the way they operate, so
	 they must provide their own documentation and/or on-line help
	 information. The interface used by SwiftBBS is described in
	 the appendices.

	      For non-ANSI users and when the individual system
	 doesn't provide an external editor, SwiftBBS provides a
	 limited internal editor.  If it's not possible to load the
	 external editor for some reason, SwiftBBS will also fall-back
	 to the internal editor.  The following discussion covers only
	 the SwiftBBS internal editor.  The current version of
	 SwiftBBS may vary and all options displayed in the prompts
	 may not be active in this version. Message quoting is not
	 possible with the internal editor.

	      The internal editor begins by displaying the message
	 entry screen as below.  To enter a message, simply begin
	 typing.


	    Enter message text now (66 lines max/72 chars per line).
	    Words will wrap automatically.  Blank line to edit/save.
	       [-----------------------------------------------------]
	    01: Note to check the internal editor, and illustrate
	    02: prompts provided. A blank or space is required to
	    03: insert a blank line.


	      If you need to access one of the editing options,
	 press enter on a blank line, and make a selection from the
	 following menu.  In order to enter a blank line
	 in the message itself, you will need to enter a space or tab.


	    S)ave Msg      Q)uit (Abort)  C)ontinue      L)ist Msg
	    E)dit line     K)ill line     I)nsert line   ?)Help
	    SELECT:  C

	    Continue adding to message ...
	       [-----------------------------------------------------]
	    03: insert a blank line.
	    04:
	    05: Dana
	    06:

	    S)ave Msg      Q)uit (Abort)  C)ontinue      L)ist Msg
	    E)dit line     K)ill line     I)nsert line   ?)Help
	    SELECT:  S


	      The options include:
	 S)ave Msg -- Saves the message, and adds it to the
	    messagebase.
	 Q)uit (Abort) -- Allows you to abort the message and return
	    to the previous menu or option.
	 C)ontinue -- Allows you to continue adding text to the
	    message, after previously stopping.  The editor will
	    display the last line entered and allow you to continue
	    typing at the end of the line.
	 L)ist Msg -- Lists the lines of the message entered so far.
	    This allows you to review parts that may have scrolled
	    off of the screen.
	 E)dit -- Allows you to edit a single line in the message in
	    the normal entry fashion.
	 K)ill -- Allows you to delete one of the lines in the
	    message. Following this option, message lines are
	    renumbered.
	 I)nsert -- Allows you to insert one or more lines in the
	    message.
	 ?)Help -- Displays the helpfile, EDITHELP.A??.
Keystroke summary
Keystroke summary
Keystroke summary


	      In order to speed the user's navigation of the menus
	 and options, SwiftBBS uses hotkeys. Options from menus can
	 be executed with a single keystroke. Pressing <enter> is not
	 required. Also, there are some hotkeys that are available
	 during certain operations that will interrupt the current
	 option.
	      The hotkeys available in SwiftBBS will depend on the
	 file and/or option selected. The following is a brief
	 summary of the keys and their use.


	 HOTKEYS

	 Display files:
	 Most display files can be paused by pressing <P>, and
	 stopped by pressing <S>. If the display scrolls too fast,
	 press <P> to pause it and any other key to continue. If the
	 text being displayed doesn't interest you, press <S> to
	 stop it and return to the previous menu or option.

	 Menus:
	 Options from a menu can be selected before the menu is fully
	 displayed.  When a valid selection is made, the remainder of
	 the menu display is aborted, and the selected action is
	 taken.  The type 40 menu display attached to a menu will
	 respond in the same way.
	 Stop/Pause options are NOT valid during menu displays since
	 menu options may be <S> or <P>.

	 Messaging:
	 When a Read option is selected, the subsequent prompts for
	 reading are also hotkey options.  During message display, you
	 can pause the display be selecting <P>, or interrupt the
	 display by selecting one of the navigational options,
	 <N>ext, <L>ast, <R>eply, <X>port, and <S>top.
	 Similar options in message threading are also hotkeys.


	 DEFAULTS

	 In addition to hotkeys, SwiftBBS has several options that
	 have recommended responses called defaults, built-in.  When
	 an option has a common response, it's sometimes possible to
	 press <enter> to select it as the default.  The default action
	 is usually capitalized or otherwise indicated.

	 Yes/no/Enter options:
	 Options prompted with a <Y/n> or <y/N> query will accept an
	 enter key to select the option with the capital letter.

	 The more prompt:
	 The "More...  [Y/n/=]?  " also has a default.  When the
	 display has reached the designated line number count and you
	 have More enabled, SwiftBBS will query for a response and
	 will accept enter for the default <Y>.  In addition, this
	 prompt allow you to select '=' to read continuous to the next
	 prompt.  In messages, this allows you to read non-stop to the
	 end of the message.  This prompt will also let you select 'S'
	 to Stop (not shown).  In some cases, it's the same as "No",
	 and in others it really means "Stop", i.e.  message reading.

	 Next:
	 When presented with the  A)gain, N)ext, ... option,
	 pressing enter will select the  N)ext option.

	 New:
	 When presented with the  F)orward, R)everse, N)ew, ...
	 option, pressing enter will select the  N)ew option.

	 Message replies:
	 Using similar defaults when pressing enter, replies to
	 messages default to replying to who the message is from, No
	 to changing the subject, and Yes to quoting reply text.

	 Bulletins:
	 The default option depends upon the last selection.  When a
	 numbered bulletin has previously been selected, <Enter>
	 increments the selection number.  When a non-numbered
	 bulletin has previously been selected, <Enter> redisplays the
	 bulletin main menu.  When the bulletin main menu is
	 displayed, <Enter> exits.
