/*

 * APUS.h
 * structures and other typedefs for SwiftBBS programs.
 * adapted from QuickBBS and RemoteAccess structures.

 * (SwiftBBS) copyright 1989, 1990, 1991, 1992, 1993, 1994 by Dana Bell

 * revised 6/10/94
 * major revision expands configuration and provides support for separate
 * config file for message areas. Message area config is compatible with
 * MESSAGES.RA of RA 2.0.
 * major revision provides compatibility of USERS.BBS with RA 2.0. These
 * two modifications allow use of third-party software for echomail and
 * message/user base management.

*/

/*
 * Some string variables declared in this file are actually
 * null-terminated counted strings. This is particularly so when
 * the file is designed to be compatible with QuickBBS/RA. The first
 * [0] element is the length of the string. SwiftBBS attempts to
 * preserve that count but uses strings as null terminated character
 * arrays.
 *
 * Other strings may be offset to ignore the string count, but are null
 * terminated.
*/

#define FALSE 0
#define TRUE !FALSE

/* specify user variables as global */
/************************************/
typedef unsigned char flagtype[4];
typedef unsigned char flagdesc[31];    /* for flags.bbs file (qflag) */
  /* flagdesc are now part of configuration file */
typedef unsigned char bytearray[32];
typedef unsigned char gosubtype[20][9];
/* asktype, videotype, orphantype, time, date, longdate */

typedef struct NetAddress {
   unsigned int zone;
   unsigned int net;
   unsigned int node;
   unsigned int point;
   unsigned char domain[28];
} NETADDR;

typedef unsigned char NAME[36];

/* RA2 USER
  LASTREADrecord = array[1..200] of Word;

  USERSIDXrecord = record
                     NameCRC32,
                     HandleCRC32    : LongInt;
                   end;

  USERSXIrecord  = record
                     FreeSpace      : Array[1..200] of Byte;
                   end;

/*  New User Configuration Information for Users */
/************************************/
typedef struct apususer {
   /* unsigned int VersionID; /* deleted */
   /* identification */
   unsigned char countoffset; /* offset to allow for pascal string count */
            /* all strings are shifted down by one character */
	unsigned char Name[36];
   unsigned char Location[26];
   unsigned char Account[51];
     /* business name is business type */
   unsigned char Addr1[51];
   unsigned char Addr2[51];
   unsigned char Addr3[51];
	unsigned char handle[36];
   unsigned char Comment[80]; /* shortened to allow for shift */
   long passwordCRC;
   /* set length strings follow, use pascal count routines */
	unsigned char dataphone[16];
	unsigned char homephone[16];
   unsigned char lasttime[6];
   unsigned char lastdate[9];
	unsigned char displayattr;
    /* deleted, cls, more, ansi, avatar, gui, fsedit, fsview */
                     /*
                     Attribute,

                      { Bit 0 : Deleted
                            1 : Clear screen
                            2 : More prompt
                            3 : ANSI
                            4 : No-kill
                            5 : Xfer priority
                            6 : Full screen msg editor
                            7 : Quiet mode }

                     Attribute2     : Byte;

                      { Bit 0 : Hot-keys
                            1 : AVT/0
                            2 : Full screen message viewer
                            3 : Hidden from userlist
                            4 : Page priority
                            5 : No echomail in mailbox scan
                            6 : Guest account
                            7 : Post bill enabled }
                      */

   unsigned char pubattr;
    /* hide, list, publish, hotkey, xferpriority, no-kill, quiet */
	flagtype userflag;
	long netcredit;
	long pending;
	unsigned int timesposted;
	unsigned int security;
	long highmsgread;
   long times;
   /* transfers */
	long ups;
	long downs;
	long upK;
	long downK;
	long todayK;
   signed int elapsed;
   unsigned int len;
   unsigned char lastpwdchg;
   unsigned int group;
   unsigned int comb[200];
   unsigned char firstdate[9];
	unsigned char birthdate[9];
   unsigned char subdate[9];
   unsigned char width;
   unsigned char language;
	unsigned char dateformat;
      unsigned char password[16];
      unsigned char initpwd[16];
      unsigned char age;
      unsigned char space[3];
      /* regpwd/menu/age is forwardto in RA */
   unsigned int msgarea;
   unsigned int filearea;
   unsigned char defprotocol;
   unsigned int filegroup;
   unsigned char lastDOBcheck;
   unsigned char sex;
	long XIrecord;
    /* SAME AS userno */
   unsigned int msggroup;
   unsigned char RA2free[48];
} USER;

typedef struct userinfo {
   unsigned char automate;
    /* checkmail, signmail, echoalert, newbulletins, etc */
   unsigned char marital;
   unsigned char education;
   unsigned char employed;
   unsigned char menu[9];
   unsigned char signature[36];
   unsigned char intlist[72];
   unsigned char name[36];  /* use to match user record */
   unsigned char diary[9];  /* diary & personals base name */
	unsigned char space[90];
} USERINFO;

typedef struct usersxi {
   unsigned char userfree[200];
} USERXI;

/*
  displayattr:
  unsigned char dattr[][12] = {
		" *Deleted* ",
		" Cls codes ",
		" More. . . ",
		" ANSI okay ",
		" Avatar    ",
		" gui       ",
		" Full-scrn ",
		" FS View   "
	};

   pubattr:
   unsigned char pattr[][12] = {
		" Hidden    ",
		" List okay ",
		" Publish   ",
		" Hotkeys ",
		" xfer prior",
		" *No-Kill* ",
		" Quiet     ",
		" Reserved  "
	};
   automate:
   unsigned char autoattr[][12] = {
		" mailcheck ",
		" echoalert ",
		" newbullets",
		" Reserved  ",
		" Reserved  ",
		" Reserved  ",
		" Reserved  ",
		" Reserved  "
	};
   interests:
   unsigned char iattr[][12];
      /* to use SYSTEM defined strings for interests
*/

/* New System Configuration Information */
/************************************/
typedef struct arearecord {
   unsigned char unused[4];
	unsigned char name[41];
	unsigned char type;     /* 0=Std   1=Net  2=Echo       */
														/* 2=Reserved in QuickBBS  */
	unsigned char kind;     /* 0=Both  1=Pvt  2=Pub      3=Read-Only  */
   unsigned char attr;
   /* 0=Enable echo (1)    1=Combined access (2)  2=File attaches (4)
    * 3=Allow handles (8)  4=Use SoftCRs (16)     5=Force handle (32)
    * 6=Allow deletes (64) 7=Is a JAM area */
   unsigned char dayskill;
   unsigned char recvkill;
   unsigned int countkill;
	/* flags and levels  */
	unsigned int readlevel;
	flagtype readflags;
   flagtype readnotflags;
	unsigned int writelevel;
	flagtype writeflags;
   flagtype writenotflags;
	unsigned int sysoplevel;
	flagtype sysopflags;
	flagtype sysopnotflags;
   unsigned char origin[61];
   unsigned char aka;
   unsigned char age;
   unsigned char JAMbase[61];
   unsigned int group;
   unsigned int Altgroup[3];
   unsigned char attr2;
   unsigned char freespace2[9];
} MSGAREA;
/*    unsigned char boardtype[][12] = {
			"  * Local  ",
			"  Net only ",
			"  * Echo * ",
         "  Message  ",
         "  Monitor  ",
		};
		unsigned char boardkind[][12] = {
			"  Pub&Priv ",
			"  Private! ",
			"   Public  ",
			"  ReadOnly "
		};
*/

typedef struct eventinfo {
	unsigned char status;         /* 0=Deleted 1=Enabled 2=Disabled   */
	unsigned char runtime[6];
	unsigned char errorlevel;
	unsigned char days;
	unsigned char forced;
	unsigned char lasttimerun[9];
} EVENT;

typedef struct configrecord {
   unsigned int VersionID;

   /* site info */
   unsigned char sysop[40];
   unsigned char sitename[40];
   unsigned char location[40];
   unsigned char sitefree[144];
   unsigned char sitepwd[16];

	/* system paths/filenames   */
   unsigned char msgbasepath[64];
   unsigned char syspath[64];
   unsigned char controlpath[64];
   unsigned char sempath[64];
   unsigned char userspath[64];
   unsigned char doorpath[64];
   unsigned char nodelistpath[64];
	unsigned char netpath[64];
   unsigned char attachpath[64];
   unsigned char listpath[64];
   unsigned char dnloadpath[64];
   unsigned char uploadpath[64];
   unsigned char pathfree[64];
   /* default language */
   unsigned char menupath[64];
	unsigned char textpath[64];
   unsigned char quespath[64];
  unsigned char bulletinpath[64];
   /* filenames */
   unsigned char logfilename[64];
   unsigned char printername[4];
   /* swifecho support */
   unsigned char inpath[64];
   unsigned char pktpath[64];
   unsigned char outpath[64];
   unsigned char arcpath[64];

   /* external commands */
	unsigned char editorcmdstr[64];
   unsigned char txteditcmdstr[64];
   unsigned char chatcmdstr[64];
   unsigned char arccmdstr[64];
   unsigned char FKeys[32][10];
   unsigned char externfree[320];

   /* prompts & messages */
	unsigned char selectionprompt[70];
   unsigned char logonprompt[64];
   unsigned char langprompt[64];
   unsigned char langhdr[64];
	unsigned char loadingmessage[70];
	unsigned char originline[60];
   unsigned char fileline[40];
   unsigned char replyhdr[64];
	unsigned char quotestr[4];
   unsigned char leftbracket;
   unsigned char rightbracket;
   unsigned char echochar;
   unsigned char doafteraction;
   unsigned char promptfree[256];

   /* modem stuff */
	unsigned int commport;
   unsigned char alignmentstuff;
	unsigned long initbaud;
   unsigned long lockbaud; /* fossil locked rate */
   unsigned int inittimes;
   unsigned int modemdelay;
   unsigned int answerwait;
   unsigned char answerphone;
   unsigned char offhook;
   unsigned char sendbreak;
   unsigned char flushbuffer;
   unsigned int buffersize;
	unsigned char initstr[64];
   unsigned char init2str[64];
   unsigned char init3str[64];
	unsigned char busystr[64];
	unsigned char initresp[20];
	unsigned char busyresp[20];
   unsigned char ringstr[20];
	unsigned char answerstr[20];
   unsigned char protocolattr[6];
   unsigned char errorfreestr[15];
	unsigned char connect300[20];
	unsigned char connect1200[20];
	unsigned char connect1275[20];
	unsigned char connect2400[20];
	unsigned char connect4800[20];
	unsigned char connect7200[20];
	unsigned char connect9600[20];
	unsigned char connect12000[20];
	unsigned char connect14400[20];
	unsigned char connect19K[20];
	unsigned char connect38K[20];
   unsigned char xfercmd[64];
   unsigned char dnloadcmd[64];
   unsigned char uploadcmd[64];
   unsigned char modemfree[64];

   /* console color/video stuff */
   unsigned char keyboardpwd[40];
   unsigned char altjpwd[40];
   unsigned char videomode;
   unsigned char screenblanking;
   unsigned char monomode;
   unsigned char directwrite;
   unsigned char snowcheck;
   unsigned char inputfields;
   unsigned char blanksecs;
   unsigned char fgcolor;
   unsigned char bgcolor;
   unsigned char normfg;
   unsigned char normbg;
   unsigned char statfg;
   unsigned char statbg;
   unsigned char windfg;
   unsigned char windbg;
   unsigned char borderfg;
   unsigned char borderbg;
   unsigned char barfg;
   unsigned char barbg;
   unsigned char CRfg;
   unsigned char CRbg;
   unsigned char hilitefg;
   unsigned char hilitebg;
   unsigned char colorfree[16];

   /* hardware stuff */
   unsigned char multitasker;
   unsigned char multinode;
   unsigned char altjswap;

   /* settings/default stuff */
	unsigned int defaultsec;
	unsigned int defaultcredit;
   unsigned int defaultgroup;
	flagtype defaultflags;
   unsigned int defaultlang;
   unsigned int kludgesec;
   unsigned int groupmailsec;
   unsigned char confirmdel;
   unsigned char remotesysop;
   unsigned char logstyle;
   unsigned char autodetectANSI;
	unsigned char autologonchar;
	unsigned char fastlogon;
   unsigned char strictpwd;
	unsigned char uselastread;
	unsigned char netechoexit;
	unsigned char onewordnames;
	unsigned char checkmail;      /* asktype when user file converted */
   unsigned char hotkey;
   unsigned char fullmailcheck;
   unsigned char checkmulti;
   unsigned char fileshells;
   unsigned char msgupload;
   unsigned char freezechat;
	unsigned int logontime;
	unsigned int inactivetimeout;
   unsigned int nametries;
            /* new */
	unsigned int passwordtries;
   unsigned char passwordlen;
   unsigned char passwordabort;
            /* abort name logon */
	unsigned int maxpagetimes;
	unsigned int pagebelllen;
   unsigned char askwhypage;
   unsigned char leavepagemsg;
   unsigned char pwdmessage;
   unsigned char allowtimebank;
   unsigned char autotimebank;
   unsigned int maxtimebank;
      /* timebank for newusers */
   unsigned char EMSI_enable;
   unsigned char EMSI_newuser;
   unsigned char capname;
   unsigned char caplocation;
   unsigned char autochatcapture;
   unsigned int pwdexpiry;
   unsigned int renumthreshold;
   unsigned char extendboards;
   unsigned int slashsecurity;
   unsigned char defaultfree[55];

   /* newuser queries */
   unsigned char askusername;
   unsigned char askhandle;
   unsigned char asksignature;
	unsigned char askhomephone;
	unsigned char askdataphone;
   unsigned char askaddress;
   unsigned char askbirth;
	unsigned char askage;
   unsigned char asksex;

   unsigned char askmarital;
   unsigned char asklen;
   unsigned char askwidth;
   unsigned char askcls;
   unsigned char askmore;
	unsigned char ansiavail;
   unsigned char avataravail;

   unsigned char guiavail;
   unsigned char askfsedit;
   unsigned char askfsview;
   unsigned char askhide;
   unsigned char asklist;
   unsigned char askpublish;
   unsigned char askhotkey;
   unsigned char asklanguage;
   unsigned char askmailcheck;

   unsigned char asklogoff;
   unsigned char askinterest;
   unsigned char queryfree[29];

	/* networking stuff */
	unsigned int netmailboard;
	unsigned int matrixzone;
	unsigned int matrixnet;
	unsigned int matrixnode;
	unsigned int matrixpoint;
   NETADDR akaddr[11];
   unsigned char allownetreply;
   unsigned char killsent;
   unsigned int crashasksec;
   flagtype crashaskflags;
   unsigned int crashsec;
   flagtype crashflags;
   unsigned int fattachsec;
   flagtype fattachflags;

   /* file transfer stuff */
	unsigned char use_xmodem;
	unsigned char use_xmodem1k;
	unsigned char use_ymodem;
	unsigned char use_ymodemg;
	unsigned char use_sealink;
	unsigned char use_zmodem;
	unsigned int uploadcredit;
   unsigned int minupspace;
   unsigned char touchfiles;
   unsigned char showmissing;

   /* timed stuff */
	unsigned char lowbaudstart[6];
	unsigned char lowbaudend[6];
	unsigned char downloadstart[6];
	unsigned char downloadend[6];
	unsigned char pagingstart[6];
	unsigned char pagingend[6];
	EVENT eventrec[30];

   /* exit stuff */
   unsigned char exitlocal;
	unsigned char exit300;
	unsigned char exit1200;
	unsigned char exit1275;
	unsigned char exit2400;
	unsigned char exit4800;
	unsigned char exit7200;
	unsigned char exit9600;
	unsigned char exit12000;
	unsigned char exit14400;
	unsigned char exit19K;
	unsigned char exit38K;

	/* messaging stuff */
   flagdesc flagtext[32];
   /* flagdesc inttext[64]; */
   unsigned int pointnet;
   unsigned char endofile[408];
} CONFIG;
/*    MSGAREA boardrec[200]; */

typedef struct sysinfo {
	long callcount;
	unsigned char lastcaller[36];
	unsigned char extrasys[128];
} SYS;

typedef struct timeinfo {
	unsigned char startdate[9];
	unsigned int busyperhour[24];
	unsigned int busyperday[7];
} TIMELOG;

typedef struct exitinfo {
	unsigned int baudrate;
	SYS sysinfo;
	TIMELOG timeloginfo;
	USER userinfo;
	EVENT eventinfo;
	unsigned char netmail;
	unsigned char echomail;
	unsigned char logintime[6];
	unsigned char logindate[9];
	unsigned int tmlimit;
	unsigned int loginsec;                        /* long in QuickBBS */
	unsigned int credit;                          /* long in QuickBBS */
	unsigned int userrecnum;
	unsigned int readthru;
	unsigned int pagetimes;
	unsigned int downlimit;
	unsigned char wantchat;
	unsigned char gosublevel;
	gosubtype gosub;
	unsigned char menu[9];
} EXIT;

typedef struct useron {
        unsigned char name[36];
        unsigned char handle[36];
        unsigned char line;
        unsigned int baud;
        unsigned char city[26];
        unsigned char status;
		      /* byte - 0 : Browsing (in a menu)
               		 1 : Uploading/downloading
                      2 : Reading/posting messages
                      3 : In a door/external utility
                      4 : Chatting with sysop
                      5 : Answering questionnaire
                      6 : RTC
                      7 : New user logon
                      255 : User-defined - display StatDesc
            */
        unsigned char attr;
		  		/* Bit 0 : Hidden
            		 1 : Wants chat
                   2 : Reserved for RANETMGR
                   3 : Do not disturb flag
                   6 : Ready (0=busy)
            */
        unsigned char statdesc[11];
        unsigned char freespace[98];
        int nocalls;
} USERON;

/*
  USERONrecord   = record
                     Name,
                     Handle         : MSGTOIDXrecord;
                     Line           : Byte;
                     Baud           : Word;
                     City           : String[25];
                     Status,
                     Attribute      : Byte;
                     StatDesc       : String[10];
                     FreeSpace      : Array[1..98] of Byte;
                     NoCalls        : Word;
                   end;

                   { Status byte - 0 : Browsing (in a menu)
                                   1 : Uploading/downloading
                                   2 : Reading/posting messages
                                   3 : In a door/external utility
                                   4 : Chatting with sysop
                                   5 : Answering questionnaire
                                   6 : RTC
                                   7 : New user logon
                                 255 : User-defined - display StatDesc

                     Attribute   - Bit 0 : Hidden
                                       1 : Wants chat
                                       2 : Reserved for RANETMGR
                                       3 : Do not disturb flag
                                       6 : Ready (0=busy) }

*/

/*  Nodelist Configuration Information  */
/****************************************/
typedef struct lastcall {
        unsigned char line;
        unsigned char name[36];
        unsigned char handle[36];
        unsigned char city[26];
        unsigned int baud;
        long times;
        unsigned char logon[6];
        unsigned char logoff[6];
        unsigned char attr; /* (bit 0) 1 = hidden */
} LASTCALL;

/*
  LASTCALLrecord = record
                     Line           : Byte;
                     Name,
                     Handle         : MSGTOIDXrecord;
                     City           : String[25];
                     Baud           : Word;
                     Times          : LongInt;
                     LogOn          : String[5];
                     LogOff         : String[5];
                     Attribute      : Byte;
                   end;

                { Attribute - Bit 0 : Hidden }


/*  Nodelist Configuration Information  */
/****************************************/
typedef struct noderecord {
	unsigned char nodetype;
	unsigned int zone,net,node;
	unsigned char name[21];
	unsigned char city[41];
	unsigned char phone[41];
	unsigned char password[9];
	unsigned int flags;
	unsigned int baudrate;
	unsigned int cost;
} NODE;

typedef struct nodeindex {
	unsigned int zone,net,node;
	unsigned char nodetype;
} NIDX;
/* unsigned char nodeattrib[][12] = {
		"  Net Hub  ",
		"  Net Host ",
		" Reg Coord ",
		" Zone gate ",
		"  Runs CM  ",
		"           ",
		"           ",
		"           "
	};
*/
/* RA2 menus */
typedef struct ra2menuinfo {
	unsigned char type;
	unsigned int security;
   unsigned int maxsec;
	flagtype notflags;
   flagtype flags;
   unsigned int timeleft;
   unsigned int timeused;
   unsigned char age;
   unsigned char termtype; /* 0 = ANSI 1 = AVT */
   long minspeed;
   long maxspeed;
   long credit;
   long optioncost;
   long minutecost;
   bytearray node;
   bytearray group;
   unsigned int start[7];
   unsigned int stop[7];
	unsigned char display[136];
   unsigned char key[9];
	unsigned char data[136];
	unsigned char fg, bg;
   unsigned char menuspace[50];
} RA2MENU;

/*
  MNUrecord      = record
                     Typ            : Byte;
                     Security,
                     MaxSec         : Word;
                     NotFlagsMask,
                     Flags          : FlagType;
                     TimeLeft,
                     TimeUsed       : Word;
                     Age,
                     TermAttrib     : Byte;

                     {Bit 0 : ANSI
                          1 : AVT}

                     MinSpeed,
                     MaxSpeed,
                     Credit,
                     OptionCost,
                     PerMinCost     : LongInt;
                     Node,
                     Group          : ByteArray32;
                     StartTime,
                     StopTime       : Array[1..7] of Word;
                     Display        : String[135];
                     HotKey         : String[8];
                     MiscData       : String[135];
                     Foreground,
                     Background     : Byte;
                     FreeSpace      : Array[1..50] of Byte;
                   end;


/*  Menu Configuration Information  */
/************************************/
typedef struct menuinfo {
	unsigned char type;
	unsigned int security;
	flagtype flags;
	unsigned char display[76];
	unsigned char key;
	unsigned char data[81];
	unsigned char fg, bg;
} MENU;


/*   Message Files Structures   */
/********************************/
typedef struct msginfo {
	unsigned int lowmsg;
	unsigned int highmsg;
	unsigned int totalactive;
	unsigned int activemsgs[200];
} MSGINFO;

typedef struct msgidx {
	unsigned int msgnum;
	unsigned char board;
} MSGIDX;

typedef struct msghdr {
	unsigned int
		msgnum,
		replyto,
		seealsonum,
		tread;
	unsigned int startrec;
	unsigned int
		numrecs,
		destnet,
		destnode,
		orignet,
		orignode;
	unsigned char
		destzone,
		origzone;
	unsigned int cost;
	unsigned char
		msgattr,
		netattr;
	unsigned char board;
	unsigned char posttime[6];
	unsigned char postdate[9];
	unsigned char whoto[36];
	unsigned char whofrom[36];
	unsigned char subj[73];
} MSGHDR;

/*       unsigned int destpoint;*/

/* unsigned char msgattrib[][12] = {
		" *Deleted* ",
		" unmovdNet ",
		" *Net Msg* ",
		" *Private* ",
		" *Received ",
		" unmovdEch ",
		" * Local * ",
		" *Monitor* "                    /* Reserved in QuickBBS
	};
	unsigned char netattrib[][12] = {
		" * KILL  * ",
		"  Sent Ok  ",
		"  Attaches ",
		" * CRASH * ",
		" Recpt Req ",
		" Audit Req ",
		" IsRetRcpt ",
		"  File Req "                    /* Reserved in QuickBBS
	};
*/


/* Standard Errorlevels */
/************************/
/*
	255 compiler
	6+ external program
	5 Net & echo processing done/needed
	2 Fatal error - problem
	1 Problem accessing a file
	0 did nothing, do nothing, default
*/

/* System Configuration Information */
/************************************/
typedef struct boardrecord {
	unsigned char name[17];
	unsigned char type;     /* 0=Std   1=Net  2=Monitor  3=Echo       */
														/* 2=Reserved in QuickBBS  */
	unsigned char kind;     /* 0=Both  1=Pvt  2=Pub      3=Read-Only  */
	unsigned char combined;
	unsigned char aliases;
	/* flags and levels  */
	unsigned int readlevel;
	flagtype readflags;
	unsigned int writelevel;
	flagtype writeflags;
	unsigned int sysoplevel;
	flagtype sysopflags;
} BOARD;
