@ECHO OFF
GOTO BEGIN

Log on to the drive and directory that contains the SwiftBBS extracted
files before executing this batch file.

This batch file will do a
complete install of files for SwiftBBS, including copying major files
into a download directory.  This will take up to 1.5Meg of disk space.
To do a basic installation, copy only the key files SWIF*.EXE and run
the SWIFCNFG program manually.

If configuration is not found in local or environment variable APUS,
Swifcnfg will ask to automatically configure on \SW of current drive.
If you don't accept this, you will need to specify paths and copy the
appropriate files to their directories.

:BEGIN
SET BBSDIR=%1
IF NOT %BBSDIR%.==. GOTO CONTINUE
ECHO Enter directory name to install in (Q to Quit):
ECHO (Directory \SW is recommended)
ANSWER
IF %ANSWER%.==. GOTO PARMS
IF %ANSWER%==Q GOTO PARMS
IF %ANSWER%==QUIT GOTO PARMS
SET BBSDIR=%ANSWER%

:CONTINUE
ECHO Do you want to create directory %BBSDIR% for SwiftBBS (Y/N)?
ANSWER
IF %ANSWER%==N GOTO BEGIN

CLS
ECHO Creating SwiftBBS directory and copying files
md %BBSDIR%
COPY *.* %BBSDIR%
REM LHA e MSGBASE.LZH

CLS
ECHO Creating questionnaire directory and copying files
md %BBSDIR%\QUESTS
LHA e %BBSDIR%\QUESTS.LZH %BBSDIR%\QUESTS\
DEL %BBSDIR%\QUESTS.LZH

CLS
ECHO Creating bulletin directory and copying files
md %BBSDIR%\BULLETS
LHA e %BBSDIR%\BULLETS.LZH %BBSDIR%\BULLETS\
DEL %BBSDIR%\BULLETS.LZH

CLS
ECHO Creating menus directory and copying files
md %BBSDIR%\MENUS
LHA e %BBSDIR%\MENUS.LZH %BBSDIR%\MENUS\
DEL %BBSDIR%\MENUS.LZH

CLS
ECHO Creating textfile directory and copying files
md %BBSDIR%\TEXT
LHA e %BBSDIR%\TEXT.LZH %BBSDIR%\TEXT\
DEL %BBSDIR%\TEXT.LZH

CLS
ECHO Creating download directory and copying files
md %BBSDIR%\DNLOADS
ECHO Do you want to copy some sample files to the download directory (Y/N)?
ANSWER
IF %ANSWER%==N goto SKIP
LHA e %BBSDIR%\DNLOADS.LZH %BBSDIR%\DNLOADS\
COPY SWIFTBBS.USR %BBSDIR%\DNLOADS
COPY FILES.BBS %BBSDIR%\DNLOADS
DEL %BBSDIR%\DNLOADS.LZH
IF EXIST %BBSDIR%\DNLOADS\FILES.BBS GOTO SKIP
FOR %%A IN (%BBSDIR%\DNLOADS\*.*) DO ECHO %%A >> %BBSDIR%\DNLOADS\FILES.BBS
:SKIP
CLS
ECHO Enter the drive that installation is being made on
ANSWER
%ANSWER%:

cd %BBSDIR%
ECHO Now executing general configuration program
PAUSE
SWIFCNFG -C
ECHO Now executing configuration program for message areas
PAUSE
SWIFCNFG -A
ECHO Now executing configuration program for users
PAUSE
SWIFCNFG -U

CLS
ECHO Do you want to logon to the BBS now (Y/N)?
ANSWER
IF %ANSWER%==N goto END
SWIFTBBS -l
CD..
GOTO END
:PARMS
ECHO Format: INSTALL <dirname>
ECHO       i.e. INSTALL D:\SW
:END

