/*

 * swifecho.h

 * structures and other typedefs for Swifecho.
 * includes fidonet type 2 packet formats
 * copyright 1989, 1990 by Dana Bell

*/

#define PKTVER       2        /* Used for `ver' (below)                     */
typedef unsigned      bit;
typedef unsigned char byte;
typedef unsigned int  word;
typedef signed int sword;
typedef long int dword;
typedef unsigned char const * const  STRING;

typedef struct pktmsg
{
  word  ver;
  sword orig_node;
  sword dest_node;
  sword orig_net;
  sword dest_net;
  word  attr;
  word  cost;
} PKTMSG;

typedef struct pkt
{
		int   orig_node;        /* originating node               */
		int   dest_node;        /* destination node               */
		int   year;             /* 0..99  when packet was created */
		int   month;            /* 1..12  when packet was created */
		int   day;              /* 1..31  when packet was created */
		int   hour;             /* 0..23  when packet was created */
		int   minute;           /* 0..59  when packet was created */
		int   second;           /* 0..59  when packet was created */
		int   rate;             /* destination's baud rate        */
		int   ver;              /* packet version                 */
		int   orig_net;         /* originating network number     */
		int   dest_net;         /* destination network number     */
		char  product;          /* product type                   */
		char  x1;               /* filler (used by some systems)  */
		byte password[8];       /* ONLY 6 CHARS ARE SIGNIFICANT!! */
		word qm_orig_zone,
			  qm_dest_zone;
		byte rsvd1[8];
		word orig_zone,
			  dest_zone,
			  orig_point,
			  dest_point;
		long pr_data;
} PKT;

typedef struct msg
{
	unsigned char from[36];
	unsigned char to[36];
	unsigned char subject[72];
	char  datetime[20];
	int timesread;
	int   dest_node;        /* destination node               */
	int   orig_node;        /* originating node               */
	int cost;
	int   orig_net;         /* originating network number     */
	int   dest_net;         /* destination network number     */
	int   dest_zone;
	int   orig_zone;
	int   dest_point;
	int   orig_point;
	int   replyto;
	int   attr;
	int nextreply;
} MSG;

typedef struct addresses {
	int zone;
	int net;
	int node;
	char netnode[20];
} SEEN;
