
{$R-,S-,I-,D-,T-,F-,V-,B-,N-,L+ }
{$M 65500,0,0 }

UNIT MainMenu;

INTERFACE

USES crt, dos,
     gentypes, configrt, statret,
     textret, userret, mailret,
     gensubs, subs1, subs2, windows,
     chatstuf, mainr1, mainr2, overret1;

PROCEDURE EditUsers;
PROCEDURE ZapSpecifiedUsers;
PROCEDURE SummonSysOp;
PROCEDURE OffTheForum;
PROCEDURE ListUsers;
PROCEDURE TransferName;
PROCEDURE EditNews;
PROCEDURE YourStatus;
PROCEDURE DelErrLog;
PROCEDURE FeedBack;
PROCEDURE SetTime;
PROCEDURE ChangePwd;
PROCEDURE RequestRaise;
PROCEDURE MakeUser;
PROCEDURE InfoFormHunt;
PROCEDURE Donations;
PROCEDURE ViewSysLog;
PROCEDURE DelSysLog;
PROCEDURE ShowSystemStatus;
PROCEDURE ShowAllForms;
PROCEDURE ShowAllSysOps;
PROCEDURE MainHelp;
PROCEDURE OtherBBS;
PROCEDURE ReadErrLog;
PROCEDURE ShowAd;
PROCEDURE SetLastCall;
PROCEDURE RemoveAllForms;
PROCEDURE ReadFeedBack;

implementation

PROCEDURE EditUsers;

VAR
     eunum   : INTEGER;
     Matched : BOOLEAN;

  PROCEDURE elistusers (getspecs : BOOLEAN);

  VAR
       Cnt, f, l : INTEGER;
       u         : UserRec;
       us        : userspecsrec;

    PROCEDURE listuser;

    BEGIN
         WRITE (Cnt:4, ' ');
         Tab (u.handle, 31);
         WRITE (u.level:6, ' ');
         Tab (datestr (u.LastOn), 8);
         WRITELN (u.nbu:6, u.numon:6, postcallratio (u):7:2)
    END;

  BEGIN
       IF getspecs
       THEN IF selectspecs(us)
            THEN Exit
            ELSE BEGIN
                 f := 1;
                 l := numusers
            END
       ELSE parserange (numusers, f, l);
       SEEK (ufile, f);
       Matched := False;
       WRITELN (^B^M^M' Num Name                            Level ',
                'Last on  Posts Calls PCR');
       FOR Cnt := f TO l DO BEGIN
            READ (ufile, u);
            IF (NOT getspecs) OR
               fitsspecs(u, us)
            THEN BEGIN
                 listuser;
                 Matched := True
            END;
            handleincoming;
            IF Break
            THEN Exit
       END;
       IF NOT Matched
       THEN IF getspecs
            THEN WRITELN (^B^M'No users match specifications!')
            ELSE WRITELN (^B^M'No users found in that range!')
  END;

BEGIN
     REPEAT
          WriteStr (^M'User to edit [?,??=list]:');
          IF (Length (Input) = 0) OR
             (match (Input, 'Q'))
          THEN Exit;
          IF Input[1] = '?'
          THEN elistusers (Input = '??')
          ELSE BEGIN
               eunum := lookupuser (Input);
               IF eunum = 0
               THEN WriteStr ('User not found!')
               ELSE edituser (eunum)
          END
     UNTIL HungUpOn
END;

PROCEDURE zapspecifiedusers;

VAR
     us      : userspecsrec;
     done,
     confirm : BOOLEAN;
     u       : UserRec;
     Cnt     : INTEGER;

BEGIN
     IF selectspecs (us)
     THEN Exit;
     WriteStr ('Confirm each deletion individually? *');
     IF Length (Input) = 0
     THEN Exit;
     confirm := yes;
     IF NOT confirm
     THEN BEGIN
          WriteStr (^M'Are you SURE you want TO mass delete without confirmation? *');
         IF NOT yes
         THEN Exit
     END;
     FOR Cnt := 1 TO numusers DO BEGIN
          SEEK (ufile, Cnt);
          READ (ufile, u);
          IF (Length (u.handle) > 0) AND
             fitsspecs (u, us)
          THEN BEGIN
               IF confirm
               THEN BEGIN
                    done := False;
                    REPEAT
                         WriteStr ('Kill ' + u.handle + ' (Y/N/X/E):');
                         IF Length (Input) > 0
                         THEN CASE UpCase (Input[1]) OF
                              'Y' : BEGIN
                                         done := True;
                                         WRITELN ('Killing '+u.handle+'...');
                                         deleteuser (Cnt)
                                    END;
                              'N' : done := True;
                              'X' : Exit;
                              'E' : BEGIN
                                         edituser (Cnt);
                                         WRITELN;
                                         WRITELN
                                    END
                         END
                    UNTIL done
               END
               ELSE BEGIN
                    WRITELN ('Killing ' + u.handle + '...');
                    IF Break
                    THEN BEGIN
                         WriteStr ('Aborted!!');
                         Exit
                    END;
                    deleteuser (Cnt)
               END
          END
     END
END;

PROCEDURE summonsysop;
VAR tf:text;
    k:CHAR;
BEGIN
  chatmode:=NOT chatmode;
  bottomline;
  IF chatmode
    THEN
      IF sysopisavail
        THEN
          BEGIN
            WriteStr ('Reason FOR CHAT: &');
            chatreason:=Input;
            IF Length(Input)=0 THEN BEGIN
              chatmode:=False;
              Exit
            END;
            writelog (1,3,chatreason);
            splitscreen (4);
            top;
            clrscr;
            WRITELN (usr,unam,' < Wants TO see you, His reason:');
            WRITE (usr,chatreason);
            bottom;
            ASSIGN (tf,textfiledir+'Speak');
            RESET (tf);
            IF IOResult=0 THEN BEGIN
              while (NOT (eof(tf) OR HungUpOn)) AND chatmode DO
                BEGIN
                  READ (tf,k);
                  nobreak:=True;
                  IF Ord(k)=7 THEN summonbeep ELSE writechar (k);
                  IF keyhit THEN BEGIN
                    k:=bioskey;
                    clearbreak;
                    chat (False)
                  END
                END;
              textclose (tf)
            END;
            IF chatmode
              THEN WriteStr (^M'Use [C] again TO turn off page.')
              ELSE unsplit
          END
        ELSE
          BEGIN
            WriteStr ('Sorry, '+sysopname+
                      ' isn''t around right now.');
            chatmode:=False;
            writelog (1,2,'')
          END
    ELSE WriteStr ('Page off.  Use [C] TO turn it back on.');
  clearbreak
END;

PROCEDURE offtheforum;
VAR q,n:INTEGER;
    tn:FILE OF INTEGER;
    m:message;
BEGIN
  WriteStr ('Hang up now? *');
  IF yes THEN BEGIN
    WriteStr ('Leave message TO next user? *');
    IF yes THEN BEGIN
      q:=editor(m,False);
      IF q>=0 THEN BEGIN
        IF tonext>=0 THEN deletetext (tonext);
        tonext:=q;
        writestatus
      END
    END;
    printfile (textfiledir+'GoodBye');
    disconnect
  END
END;

PROCEDURE listusers;
VAR Cnt:INTEGER;
    u:UserRec;
BEGIN
  WRITELN (^B'Name '^M);
  IF Break THEN Exit;
  FOR Cnt:=1 TO numusers DO
    BEGIN
      SEEK (ufile,Cnt);
      READ (ufile,u); che;
      IF Length(u.handle)>0 THEN BEGIN
        Tab (u.handle,33);
        IF Break THEN Exit
      END
    END
END;

PROCEDURE transfername;
VAR un,nlvl,ntime,tmp:INTEGER;
    u:UserRec;
BEGIN
  IF tempsysop THEN BEGIN
    WriteStr ('Wiping Temp. god like powers.');
    ulvl:=regularlevel;
    tempsysop:=False
  END;
  WriteStr ('Transfer TO user name:');
  IF Length(Input)=0 THEN Exit;
  un:=lookupuser(Input);
  IF unum=un THEN BEGIN
    WriteStr ('You can''t transfer TO yourself!');
    Exit
  END;
  IF un=0 THEN BEGIN
    WriteStr ('No such Animal.');
    Exit
  END;
  SEEK (ufile,un);
  READ (ufile,u);
  IF ulvl<sysoplevel THEN IF NOT checkpassword(u) THEN BEGIN
    writelog (1,5,u.handle);
    Exit
  END;
  writelog (1,4,u.handle);
  updateuserstats (False);
  ntime:=0;
  IF datepart(u.LastOn)<>datepart(now) THEN BEGIN
    tmp:=ulvl;
    IF tmp<1 THEN tmp:=1;
    IF tmp>100 THEN tmp:=100;
    ntime:=usertime[tmp]
  END;
  IF u.timetoday<10
    THEN IF issysop OR (u.level>=sysoplevel)
      THEN
        BEGIN
          WriteStr ('The user has '+strr(u.timetoday)+' min(s) left!');
          WriteStr ('New time left:');
          ntime:=valu(Input)
        END
      ELSE
        IF u.timetoday>0
          THEN WRITELN ('Warning: You have ',u.timetoday,' minutes left!')
          ELSE
            BEGIN
              WriteStr ('Sorry, that user doesn''t have any time left!');
              Exit
            END;
  unum:=un;
  readurec;
  IF ntime<>0 THEN BEGIN
    urec.timetoday:=ntime;
    writeurec
  END;
END;

PROCEDURE editnews;
VAR nn,numnews:INTEGER;
    nf:FILE OF INTEGER;

  PROCEDURE getnn (txt:mstr);
  BEGIN
    WriteStr ('News number TO '+txt+':');
    nn:=valu(Input);
    IF (nn<1) OR (nn>numnews) THEN nn:=0
  END;

  PROCEDURE delnews;
  VAR Cnt:INTEGER;
      r:INTEGER;
  BEGIN
    IF nn=0 THEN getnn ('Killed');
    IF nn<>0 THEN BEGIN
      SEEK (nf,nn-1);
      READ (nf,r); che;
      deletetext (r);
      numnews:=FileSize(nf)-1;
      FOR Cnt:=nn TO numnews DO
        BEGIN
          SEEK (nf,Cnt);
          READ (nf,r);
          SEEK (nf,Cnt-1);
          WRITE (nf,r)
        END;
      SEEK (nf,numnews);
      truncate (nf)
    END
  END;

  PROCEDURE listnews;
  VAR Cnt:INTEGER;
      r,sector:INTEGER;
      q:buffer;
      l:anystr;
      k:CHAR;
  BEGIN
    clearbreak;
    FOR Cnt:=1 TO numnews DO BEGIN
      SEEK (nf,Cnt-1);
      READ (nf,r);
      SEEK (tfile,r);
      READ (tfile,q);
      WRITE (strr(Cnt)+'. ');
      r:=1;
      k:=' ';
      l:='';
      while (Ord(k)<>13) AND NOT HungUpOn DO BEGIN
        k:=q[r];
        r:=r+1;
        IF (k=#0) OR (r>sectorsize) THEN k:=chr(13);
        l:=l+k
      END;
      WRITELN (l);
      IF Break THEN Exit
    END;
    WRITELN
  END;

  PROCEDURE viewnews;
  VAR r:INTEGER;
  BEGIN
    IF nn=0 THEN getnn ('view');
    IF nn<>0 THEN BEGIN
      SEEK (nf,nn-1);
      READ (nf,r); che;
      printtext (r)
    END
  END;

  PROCEDURE adddnews;
  BEGIN
    CLOSE (nf);
    addnews;
    ASSIGN (nf,'News');
    RESET (nf)
  END;

VAR q:INTEGER;
BEGIN
  ASSIGN (nf,'News');
  RESET (nf);
  IF IOResult<>0 THEN WriteStr ('No news!  Use [A] TO add some!') ELSE BEGIN
    REPEAT
      numnews:=FileSize(nf);
      WRITE (^B^M'News entries: ',numnews);
      q:=Menu ('News edit','NEWS','ADLVQ');
      nn:=valu(copy(Input,2,255));
      IF (nn<1) OR (nn>numnews) THEN nn:=0;
      CASE q OF
        1:adddnews;
        2:delnews;
        3:listnews;
        4:viewnews
      END;
      IF numnews=0 THEN BEGIN
        CLOSE (nf);
        erase (nf);
        WriteStr ('No more news!  Use [A] TO add some.');
        q:=5
      END
    UNTIL (q=5) OR HungUpOn
  END;
  CLOSE (nf)
END;

PROCEDURE yourstatus;
BEGIN
  writehdr ('Your Status');
  WRITELN ('Name:   '^S,unam,
         ^M'Level:  '^S,ulvl,
         ^M'Calls:  '^S,urec.numon,
         ^M'Posted: '^S,urec.nbu,
       ^M^M'Ascii',
         ^M'  Uploads:     '^S,urec.nup,
         ^M'  Downloads:   '^S,urec.ndn,
         ^M'XMODEM',
         ^M'  Uploads:     '^S,urec.uploads,
         ^M'  Downloads:   '^S,urec.downloads,
       ^M^M'Total time on: '^S,urec.totaltime:0:0,
         ^M'Time left:     '^S,timeleft)
END;

PROCEDURE delerrlog;
VAR e:text;
    i:INTEGER;
BEGIN
  WriteStr ('Kill error log:  Confirm:');
  IF NOT yes THEN Exit;
  ASSIGN (e,'errlog');
  RESET (e);
  i:=IOResult;
  IF IOResult=1
    THEN WRITELN (^M'Sorry, No error log! TO Kill.')
    ELSE BEGIN
      textclose (e);
      erase (e);
      WriteStr ('Error log Killed.');
      IF IOResult>1
        THEN WRITELN ('I/O error ',i,' Killing error log!');
      writelog (2,2,'')
    END
END;

PROCEDURE feedback;
VAR m:MailRec;
    me:message;
BEGIN
  WriteStr ('Leave Wraveth P. Windrose a Note? *');
  IF NOT yes THEN Exit;
  m.line:=editor(me,True);
  IF m.line<0 THEN Exit;
  m.Title:=me.Title;
  m.sentby:=unam;
  m.anon:=False;
  m.when:=now;
  addfeedback (m);
  WriteStr ('saving.........Saved')
END;

PROCEDURE settime;
VAR t:INTEGER;
    n:longint;
    r:registers;
    d:datetime;
BEGIN
  WriteStr ('Current time: '+timestr(now));
  WriteStr ('Current date: '+datestr(now));
  WriteStr ('Enter new time:');
  IF Length(Input)<>0
    THEN BEGIN
      t:=timeleft;
      unpacktime (timeval(Input),d);
      r.ch:=d.hour;
      r.cl:=d.min;
      r.dh:=0;
      r.dl:=0;
      r.ah:=$2d;
      intr ($21,r);
      IF r.al=$ff THEN WriteStr ('Invalid time!');
      settimeleft (t)
    END;
  WriteStr ('Enter new date:');
  IF Length(Input)<>0
    THEN BEGIN
      unpacktime (dateval(Input),d);
      r.dl:=d.day;
      r.dh:=d.month;
      r.cx:=d.year;
      r.ah:=$2b;
      intr ($21,r);
      IF r.al=$ff THEN WriteStr ('Invalid date!')
    END;
  writelog (2,4,'')
END;

PROCEDURE changepwd;
VAR t:SStr;
BEGIN
  writehdr ('Password Change');
  dots:=True;
  buflen:=15;
  WRITE ('Enter new password: ');
  IF getpassword
    THEN BEGIN
      writeurec;
      WriteStr ('Password changed.');
      writelog (1,1,'')
    END ELSE
      WriteStr ('No change.')
END;

PROCEDURE requestraise;
VAR t:text;
    q:LStr;
    p,l1,l2:INTEGER;
    s1,s2:SStr;
    me:message;
    m:MailRec;
LABEL nope,found;
BEGIN
  ASSIGN (t,textfiledir+'RAISEREQ');
  RESET (t);
  IF IOResult<>0 THEN GOTO nope;
  printtexttopoint (t);
  while NOT eof(t) DO BEGIN
    readln (t,q);
    p:=Pos('-',q);
    IF p>0
      THEN
        BEGIN
          s1:=copy(q,1,p-1);
          s2:=copy(q,p+1,255)
        END
      ELSE
        BEGIN
          s1:=copy(q,1,15);
          s2:=s1
        END;
    val (s1,l1,p);
    IF p=0 THEN val (s2,l2,p);
    IF p<>0 THEN BEGIN
      textclose (t);
      error ('Invalid range in RAISEREQ: %1','',q);
      Exit
    END;
    IF (ulvl>=l1) AND (ulvl<=l2) THEN GOTO found;
    skiptopoint (t)
  END;
  nope:
  error ('No text FOR level %1','',strr(ulvl));
  textclose (t);
  p:=IOResult;
  Exit;
  found:
  printtexttopoint (t);
  textclose (t);
  IF HungUpOn THEN Exit;
  m.line:=editor (me,False);
  IF m.line<0 THEN Exit;
  m.anon:=False;
  m.Title:='Raise request; now lvl='+strr(ulvl);
  m.sentby:=unam;
  m.when:=now;
  addfeedback (m);
END;

PROCEDURE makeuser;
VAR u:UserRec;
    un,ln:INTEGER;
BEGIN
  writehdr ('Add a user');
  WriteStr ('Name:');
  IF Length(Input)=0 THEN Exit;
  IF lookupuser(Input)<>0 THEN BEGIN
    WriteStr ('Sorry!  Already exists!');
    Exit
  END;
  u.handle:=Input;
  WriteStr ('Password:');
  u.password:=Input;
  WriteStr ('Level:');
  IF Length(Input)=0 THEN Exit;
  u.level:=valu(Input);
  un:=adduser(u);
  IF un=-1 THEN BEGIN
    WriteStr ('Sorry, no room FOR new users!');
    Exit
  END;
  ln:=u.level;
  IF ln<1 THEN ln:=1;
  IF ln>100 THEN ln:=100;
  u.timetoday:=usertime[ln];
  writeufile (u,un);
  WriteStr ('User added as #'+strr(un)+'.');
  writelog (2,8,u.handle)
END;

PROCEDURE infoformhunt;
BEGIN
  WriteStr ('User TO search FOR [CR=all users]:');
  WRITELN (^M);
  showinfoforms (Input)
END;

PROCEDURE donations;
VAR fn:LStr;
BEGIN
  fn:=textfiledir+'Donation';
  IF Exist (fn)
    THEN printfile (fn)
    ELSE BEGIN
      WriteStr ('I''m sorry, no information is currently available.');
      IF issysop
        THEN WriteStr (
'Sysop:  TO create donation information text, make a FILE called '+fn)
    END
END;

PROCEDURE viewsyslog;
VAR n:INTEGER;
    l:logrec;

  FUNCTION lookupsyslogdat (m,s:INTEGER):INTEGER;
  VAR Cnt:INTEGER;
  BEGIN
    FOR Cnt:=1 TO numsyslogdat DO with syslogdat[Cnt] DO
      IF (Menu=m) AND (subcommand=s) THEN BEGIN
        lookupsyslogdat:=Cnt;
        Exit
      END;
    lookupsyslogdat:=0
  END;

  FUNCTION firstentry:BOOLEAN;
  BEGIN
    firstentry:=(l.Menu=0) AND (l.subcommand in [1..2])
  END;

  PROCEDURE backup;
  BEGIN
    while n<>0 DO BEGIN
      n:=n-1;
      SEEK (logfile,n);
      READ (logfile,l);
      IF firstentry THEN Exit
    END;
    n:=-1
  END;

  PROCEDURE showentry (includedate:BOOLEAN);
  VAR q:LStr;
      p:INTEGER;
  BEGIN
    q:=syslogdat[lookupsyslogdat(l.Menu,l.subcommand)].text;
    p:=Pos('%',q);
    IF p<>0 THEN q:=copy(q,1,p-1)+l.param+copy(q,p+1,255);
    IF includedate THEN q:=q+' on '+datestr(l.when);
    q:=q+' at '+timestr(l.when);
    WRITELN (q)
  END;

VAR b:BOOLEAN;
BEGIN
  writehdr ('View system log');
  WRITELN ('Press space TO advance TO the previous caller, X TO abort.');
  WRITELN;
  writelog (2,6,'');
  n:=FileSize(logfile);
  REPEAT
    clearbreak;
    WRITELN (^M);
    backup;
    IF n=-1 THEN Exit;
    SEEK (logfile,n);
    READ (logfile,l);
    showentry (True);
    b:=False;
    while NOT (eof(logfile) OR Break OR xpressed OR b) DO BEGIN
      READ (logfile,l);
      b:=firstentry;
      IF NOT b THEN showentry (False);
    END
  UNTIL xpressed
END;

PROCEDURE delsyslog;
BEGIN
  WriteStr ('Kill system log: Confirm:');
  IF NOT yes THEN Exit;
  CLOSE (logfile);
  REWRITE (logfile);
  WRITELN (^M'System log Killed.');
  writelog (2,7,unam)
END;

PROCEDURE showsystemstatus;
VAR totalused,totalidle,totalup,totaldown,totalmins,callsday:real;

  PROCEDURE percent (prompt:mstr; top,bot:real);
  VAR p:real;
  BEGIN
    WRITE (prompt);
    IF bot<1 THEN BEGIN
      WRITELN ('N/A');
      Exit
    END;
    p:=round(1000*top/bot)/10;
    WRITELN (p:0:1,'%')
  END;

BEGIN
  totalused:=numminsused.total+elapsedtime(numminsused);
  totalidle:=numminsidle.total;
  totalup:=totalidle+numminsused.total;
  totalmins:=1440.0*(numdaysup-1.0)+timer;
  totaldown:=totalmins-totalup;
  callsday:=round(10*numcallers/numdaysup)/10;
  writehdr ('System Status');
  WRITELN ('Time & date:       '^S,timestr(now),', ',datestr(now),
       ^M^J'Calls today:       '^S,callstoday,
       ^M^J'Total callers:     '^S,numcallers:0:0,
       ^M^J'Total days up:     '^S,numdaysup,
       ^M^J'Calls per day:     '^S,callsday:0:1,
       ^M^J'Total mins in use: '^S,numminsused.total:0:0,
       ^M^J'Total mins idle:   '^S,totalidle:0:0,
       ^M^J'Mins FILE xfer:    '^S,numminsxfer.total:0:0,
       ^M^J'Total mins up:     '^S,totalup:0:0,
       ^M^J'Total mins down:   '^S,totaldown:0:0);
  percent ('Percent in use:    '^S,totalused,totalmins);
  percent ('Percent idle:      '^S,totalidle,totalmins);
  percent ('Percent up:        '^S,totalup,totalmins);
  percent ('Percent down:      '^S,totaldown,totalmins);
END;

PROCEDURE showallforms;
BEGIN
  showinfoforms ('')
END;

PROCEDURE showallsysops;
VAR n:INTEGER;
    u:UserRec;
    q:set OF configtype;
    s:configtype;

  PROCEDURE showuser;
  const sectionnames:array [udsysop..databasesysop] OF string[20]=
         ('FILE transfer','Bulletin section','Voting booths',
          'E-mail section','Doors','Main Menu','Databases');
  VAR s:configtype;
  BEGIN
    WRITELN (^B^M'Name:  '^S,u.handle,
               ^M'Level: '^S,u.level,^M);
    FOR s:=udsysop TO databasesysop DO
      IF s in u.config THEN
        WRITELN ('Sysop OF the ',sectionnames[s]);
    WriteStr (^M'Edit user? *');
    IF yes THEN edituser (n)
  END;

BEGIN
  q:=[];
  FOR s:=udsysop TO databasesysop DO q:=q+[s];
  FOR n:=1 TO numusers DO BEGIN
    SEEK (ufile,n);
    READ (ufile,u);
    IF (u.level>=sysoplevel) OR (q*u.config<>[]) THEN showuser
  END
END;

PROCEDURE mainhelp;
BEGIN
  help ('Mainmenu.hlp')
END;

PROCEDURE otherbbs;
BEGIN
  printfile (textfiledir+'Otherbbs')
END;

PROCEDURE readerrlog;
BEGIN
  IF Exist ('Errlog')
    THEN printfile ('Errlog')
    ELSE WriteStr ('No error FILE!')
END;

PROCEDURE showad;
VAR fn:LStr;
BEGIN
  fn:=textfiledir+'slick.AD';
  IF Exist (fn) THEN printfile (fn)
END;

PROCEDURE setlastcall;

  FUNCTION Digit (k:CHAR):BOOLEAN;
  BEGIN
    Digit:=Ord(k) in [48..57]
  END;

  FUNCTION ValidTime (Inp:SStr):BOOLEAN;
  VAR c,s,l:INTEGER;
      d1,d2,d3,d4:CHAR;
      ap,m:CHAR;
  BEGIN
    ValidTime:=False;
    l:=Length(Inp);
    IF (l<7) OR (l>8) THEN Exit;
    c:=Pos(':',Inp);
    IF c<>l-5 THEN Exit;
    s:=Pos(' ',Inp);
    IF s<>l-2 THEN Exit;
    d2:=Inp[c-1];
    IF l=7
      THEN d1:='0'
      ELSE d1:=Inp[1];
    d3:=Inp[c+1];
    d4:=Inp[c+2];
    ap:=UpCase(Inp[s+1]);
    m:=UpCase(Inp[s+2]);
    IF d1='1' THEN IF d2>'2' THEN d2:='!';
    IF (d1>='0') AND (d1<='1') AND Digit(d2) AND (d3>='0') AND (d3<='5')
       AND Digit(d4) AND ((ap='A') OR (ap='P')) AND (m='M')
         THEN ValidTime:=True
  END;

  FUNCTION ValidDate (Inp:SStr):BOOLEAN;
  VAR k,l:CHAR;

    FUNCTION gChar:CHAR;
    BEGIN
      IF Length(Inp)=0 THEN BEGIN
        gChar:='?';
        Exit
      END;
      gChar:=Inp[1];
      delete (Inp,1,1)
    END;

  BEGIN
    ValidDate:=False;
    k:=gChar;
    l:=gChar;
    IF NOT Digit(k) THEN Exit;
    IF l='/'
      THEN IF k='0'
        THEN Exit
        ELSE
      ELSE BEGIN
        IF k>'1' THEN Exit;
        IF NOT Digit(l) THEN Exit;
        IF (l>'2') AND (k='1') THEN Exit;
        l:=gChar;
        IF l<>'/' THEN Exit
      END;
    k:=gChar;
    l:=gChar;
    IF l='/'
      THEN IF k='0'
        THEN Exit
        ELSE
      ELSE BEGIN
        IF k>'3' THEN Exit;
        IF NOT Digit(l) THEN Exit;
        IF (k='3') AND (l>'1') THEN Exit;
        l:=gChar;
        IF l<>'/' THEN Exit
      END;
    IF Digit(gChar) AND Digit(gChar) THEN ValidDate:=True
  END;

BEGIN
  WRITELN (^M'Your last call was: '^S,datestr(LastOn),' at ',timestr(LastOn));
  WriteStr (^M'Enter new date (mm/dd/yy):');
  IF Length(Input)>0
    THEN IF ValidDate (Input)
      THEN LastOn:=dateval(Input)+TimePart(LastOn)
      ELSE WriteStr ('Invalid date!');
  WriteStr (^M'Enter new time (hh:mm am/pm):');
  IF Length(Input)>0
    THEN IF ValidTime(Input)
      THEN LastOn:=timeval(Input)+datepart(LastOn)
      ELSE WriteStr ('Invalid time!')
END;

PROCEDURE removeallforms;
VAR Cnt,ndel:INTEGER;
    u:UserRec;
BEGIN
  WriteStr ('Erase ALL info-forms:  Are you sure? *');
  IF NOT yes THEN Exit;
  writeurec;
  WriteStr (^M'Erasing... please stand by...');
  ndel:=0;
  FOR Cnt:=1 TO numusers DO BEGIN
    IF (Cnt mod 10)=0 THEN WRITE (Cnt,', ');
    SEEK (ufile,Cnt);
    READ (ufile,u);
    IF u.infoform>=0 THEN BEGIN
      deletetext (u.infoform);
      u.infoform:=-1;
      SEEK (ufile,Cnt);
      WRITE (ufile,u);
      Inc (ndel)
    END
  END;
  WRITELN ('done.');
  WriteStr (^M'All '+strr(ndel)+' forms erased.');
  readurec
END;

PROCEDURE readfeedback;
VAR ffile:FILE OF MailRec;
    m:MailRec;
    me:message;
    Cur:INTEGER;

  FUNCTION NumMessages:INTEGER;
  BEGIN
    NumMessages:=FileSize(ffile)
  END;

  FUNCTION CheckCur:BOOLEAN;
  BEGIN
    IF Length(Input)>1 THEN Cur:=valu(copy(Input,2,255));
    IF (Cur<1) OR (Cur>NumMessages) THEN BEGIN
      WriteStr (^M'Message out OF range!');
      Cur:=0;
      CheckCur:=True
    END ELSE BEGIN
      CheckCur:=False;
      SEEK (ffile,Cur-1);
      READ (ffile,m)
    END
  END;

  PROCEDURE ReadNum (n:INTEGER);
  BEGIN
    Cur:=n;
    Input:='';
    IF CheckCur THEN Exit;
    WRITELN (^B^M'Message: '^S,Cur,
               ^M'Title:   '^S,m.Title,
               ^M'Sent by: '^S,m.sentby,
               ^M'Sent on: '^S,datestr(m.when),' at ',timestr(m.when),^M);
    IF Break THEN Exit;
    printtext (m.line)
  END;

  PROCEDURE writecurmsg;
  BEGIN
    IF (Cur<1) OR (Cur>NumMessages) THEN Cur:=0;
    WRITE (^B^M'Current msg: '^S);
    IF Cur=0 THEN WRITE ('None') ELSE BEGIN
      SEEK (ffile,Cur-1);
      READ (ffile,m);
      WRITE (m.Title,' by ',m.sentby)
    END
  END;

  PROCEDURE delfeedback;
  VAR Cnt:INTEGER;
  BEGIN
    IF CheckCur THEN Exit;
    deletetext (m.line);
    FOR Cnt:=Cur TO NumMessages-1 DO BEGIN
      SEEK (ffile,Cnt);
      READ (ffile,m);
      SEEK (ffile,Cnt-1);
      WRITE (ffile,m)
    END;
    SEEK (ffile,NumMessages-1);
    truncate (ffile);
    Dec (Cur)
  END;

  PROCEDURE editusr;
  VAR n:INTEGER;
  BEGIN
    IF CheckCur THEN Exit;
    n:=lookupuser (m.sentby);
    IF n=0
      THEN WriteStr ('User disappeared!')
      ELSE edituser (n)
  END;

  PROCEDURE infoform;
  BEGIN
    IF CheckCur THEN Exit;
    showinfoforms (m.sentby)
  END;

  PROCEDURE nextfeedback;
  BEGIN
    Cur:=Cur+1;
    IF Cur>NumMessages THEN BEGIN
      WriteStr (^M'Sorry, no more feedback!');
      Cur:=0;
      Exit
    END;
    ReadNum (Cur)
  END;

  PROCEDURE readagain;
  BEGIN
    IF CheckCur THEN Exit;
    ReadNum (Cur)
  END;

  PROCEDURE replyfeedback;
  BEGIN
    IF CheckCur THEN Exit;
    sendmailto (m.sentby,False)
  END;

  PROCEDURE listfeedback;
  VAR Cnt:INTEGER;
  BEGIN
    IF NumMessages=0 THEN Exit;
    thereare (NumMessages,'piece of feedback','pieces of feedback');
    IF Break THEN Exit;
    WRITELN (^M'Num Title                          Left by'^M);
    SEEK (ffile,0);
    FOR Cnt:=1 TO NumMessages DO BEGIN
      READ (ffile,m);
      Tab (strr(Cnt),4);
      IF Break THEN Exit;
      Tab (m.Title,31);
      WRITELN (m.sentby);
      IF Break THEN Exit
    END
  END;

VAR q:INTEGER;
LABEL Exit;
BEGIN
  ASSIGN (ffile,'Feedback');
  RESET (ffile);
  IF IOResult<>0 THEN REWRITE (ffile);
  Cur:=0;
  REPEAT
    IF NumMessages=0 THEN BEGIN
      WriteStr ('Sorry, no feedback!');
      GOTO Exit
    END;
    writecurmsg;
    q:=Menu ('Feedback','FEED','Q#DEIR_AL');
    IF q<0
      THEN ReadNum (-q)
      ELSE CASE q OF
        3:delfeedback;
        4:editusr;
        5:infoform;
        6:replyfeedback;
        7:nextfeedback;
        8:readagain;
        9:listfeedback;
      END
  UNTIL (q=1) OR HungUpOn;
  Exit:
  CLOSE (ffile)
END;

BEGIN
END.
