
{$R-,S-,I-,D-,T-,F-,V-,B-,N-,L+ }
{$M 65500,0,0 }

{$ifdef testansieditor}
{*}
{*} {*} indicates test code
{*}
{*}uses crt,modem;
{*}
{*}const MaxMessageSize=100;
{*}      HungUpOn=False;
{*}
{*}type AnyStr=STRING[255];
{*}     LStr=STRING[80];
{*}     mstr=STRING[30];
{*}     sstr=STRING[15];
{*}
{*}     Message=record
{*}       Text:array [1..MaxMessageSize] OF LStr;
{*}       title:mstr;
{*}       anon:BOOLEAN;
{*}       NumLines:INTEGER
{*}     END;
{*}
{*}     regs=record
{*}       CASE BYTE OF
{*}         0:(ax,bx,Cx,dx,bp,si,di,ds,es,flags:INTEGER);
{*}         1:(al,ah,bl,bh,cl,ch,dl,dh:BYTE)
{*}     END;
{*}
{*}type configtype=(MorePrompts,EightyCols,ANSIGraphics);
{*}
{*}VAR Input:AnyStr;
{*}    NoBreak:BOOLEAN;
{*}    urec:record
{*}      DisplayLen:INTEGER;
{*}      Config:set OF configtype
{*}    END;
{*}    Winds:array [0..0] OF record y2:INTEGER END;
{*}
{*}
{*}FUNCTION Strr (n:INTEGER):mstr;
{*}VAR q:mstr;
{*}BEGIN
{*}  str (n,q);
{*}  Strr:=q
{*}END;
{*}
{*}FUNCTION WaitForChar:CHAR;
{*}VAR k:CHAR;
{*}BEGIN
{*}  REPEAT UNTIL keypressed OR (NumChars>0);
{*}  read (kbd,k);
{*}  WaitForChar:=k
{*}END;
{*}
{*}PROCEDURE ClearBreak;
{*}BEGIN
{*}END;
{*}
{*}FUNCTION Yes:BOOLEAN;
{*}BEGIN
{*}  Yes:=False;
{*}  IF Length(Input)>0
{*}    THEN IF UpCase(Input[1])='Y'
{*}      THEN Yes:=True
{*}END;
{*}
{*}FUNCTION readchar:CHAR;
{*}VAR r:regs;
{*}BEGIN
{*}  IF keypressed THEN BEGIN
{*}    r.ah:=0;
{*}    Intr ($16,r);
{*}    readchar:=Chr(r.al);
{*}    IF r.al=29 THEN Halt;
{*}    IF r.al=0 THEN CASE r.ah OF
{*}      72:readchar:=^E;
{*}      75:readchar:=^S;
{*}      77:readchar:=^D;
{*}      80:readchar:=^X;
{*}      115:readchar:=^A;
{*}      116:readchar:=^F;
{*}      73:readchar:=^R;
{*}      81:readchar:=^C;
{*}      71:readchar:=^Q;
{*}      79:readchar:=^W;
{*}      83:readchar:=^G;
{*}      82:readchar:=^V;
{*}      117:readchar:=^P;
{*}    END;
{*}    Exit
{*}  END;
{*}  IF (NumChars>0) AND Carrier
{*}    THEN readchar:=GetChar
{*}    ELSE readchar:=#0
{*}END;
{*}
{*}PROCEDURE writeturbo (k:CHAR);
{*}BEGIN
{*}  inline ($8A/$86/k/$50/$ff/$16/usroutptr)
{*}END;
{*}
{*}PROCEDURE writechar (k:CHAR);
{*}VAR r:regs;
{*}BEGIN
{*}  IF k=^J THEN writeturbo (k) ELSE BEGIN
{*}    r.dl:=Ord(k);
{*}    r.ah:=2;
{*}    Intr ($21,r)
{*}  END;
{*}  IF Carrier THEN SendChar (k)
{*}END;
{*}
{*}PROCEDURE GetStr;
{*}BEGIN
{*}  readln (Input)
{*}END;
{*}
{*}PROCEDURE printfile (l:LStr);
{*}BEGIN
{*}END;
{*}
{*}PROCEDURE WholeScreen;
{*}BEGIN
{*}  window (1,1,80,Winds[0].y2)
{*}END;
{*}
{*}PROCEDURE Bottom;
{*}BEGIN
{*}END;
{*}
{*}PROCEDURE BottomLine;
{*}BEGIN
{*}END;
{*}
{*}PROCEDURE UnSplit;
{*}BEGIN
{*}END;
{*}
{*}FUNCTION ANSIReEdit (VAR m:Message; gettitle:BOOLEAN):BOOLEAN;
{*}
{$ELSE}

unit ansiedit;

INTERFACE

USES Crt,
     GenTypes, Modem,
     Configrt, Windows,
     GenSubs, Subs1, Subs2;

FUNCTION ANSIReEdit (VAR m    : Message;
                     GetTitle : BOOLEAN ) : BOOLEAN;

IMPLEMENTATION

FUNCTION ANSIReEdit (VAR m    : Message;
                     GetTitle : BOOLEAN ) : BOOLEAN;

{$endif}

VAR
     TopLine, CurLine, Cx,
     Cy, Cols, ScrnSize,
     Lines, RightMargin,
     SaveDX, SaveDY,
     TopScrn               : INTEGER;
     InsertMode, MsgDone,
     ANSIMode              : BOOLEAN;

FUNCTION CurX : INTEGER;

BEGIN
     CurX := WhereX
END;

FUNCTION CurY : INTEGER;

BEGIN
     CurY := WhereY - TopScrn + 1
END;

PROCEDURE WriteVT52 (q : LStr);

VAR
     Cnt : INTEGER;

BEGIN
     IF NOT Carrier
     THEN Exit;
     FOR Cnt := 1 TO Length (q) DO SendChar (q[Cnt])
END;

PROCEDURE MoveTo (x, y : INTEGER);

BEGIN
     Inc (y, (TopScrn - 1));
     IF ANSIMode
     THEN BEGIN
          WRITE (Direct, #27'[');
          IF y <> 1
          THEN WRITE (Direct, Strr (y));
          IF x <> 1
          THEN WRITE (Direct, ';', Strr (x));
          WRITE ('H')
     END
     ELSE BEGIN
          GotoXY (x, y);
          WriteVT52 (#27'Y' + Chr (y + 31) + Chr (x + 31))
     END
END;

PROCEDURE ClearScr;

BEGIN
     IF ANSIMode
     THEN WRITE (Direct, #27'[2J')
     ELSE BEGIN
          WriteVT52 (#27'H'#27'J');
          ClrScr
     END
END;

PROCEDURE ClearEOL;

BEGIN
     IF ANSIMode
     THEN WRITE (Direct, #27'[K')
     ELSE BEGIN
          WriteVT52 (#27'K');
          ClrEOL
     END
END;

PROCEDURE SaveCSR;

BEGIN
     IF ANSIMode
     THEN WRITE (Direct, #27'[s')
     ELSE BEGIN
          SaveDX := CurX;
          SaveDY := CurY
     END
END;

PROCEDURE RestoreCSR;

BEGIN
     IF ANSIMode
     THEN WRITE (Direct, #27'[u')
     ELSE MoveTo (SaveDX, SaveDY)
END;

PROCEDURE cMove (k         : CHAR;
                 n, dx, dy : INTEGER);

VAR
     Cnt : INTEGER;

BEGIN
     IF n < 1
     THEN Exit;
     IF ANSIMode
     THEN BEGIN
          WRITE (Direct, #27'[');
          IF n <> 1
          THEN WRITE (Direct, Strr (n));
          WRITE (Direct, k)
     END
     ELSE FOR Cnt := 1 TO n DO BEGIN
          WriteVT52 (#27+k);
          GotoXY (WhereX + dx, WhereY + dy)
     END
END;

PROCEDURE Cup (n : INTEGER);

BEGIN
     cMove ('A', n, 0, -1)
END;

PROCEDURE cdn (n : INTEGER);

BEGIN
     cMove ('B', n, 0, 1)
END;

PROCEDURE clf (n : INTEGER);

VAR
     Cnt : INTEGER;

BEGIN
     cMove ('D', n, -1, 0)
END;

PROCEDURE crg (n : INTEGER);

BEGIN
     cMove ('C', n, 1, 0)
END;

PROCEDURE CheckSpaces;

VAR
     q : ^LStr;

BEGIN
     q := Addr (m.Text[CurLine]);
     WHILE q^[Length (q^)] = ' ' DO q^[0] := Pred (q^[0])
END;

PROCEDURE CheckCx;

VAR
     n : INTEGER;

BEGIN
     n := Length (m.Text[CurLine]) + 1;
     IF Cx > n
     THEN Cx := n
END;

PROCEDURE ComputeCy;

BEGIN
     Cy := CurLine - TopLine + 1
END;

PROCEDURE UpdateCPos;

BEGIN
     ComputeCy;
     MoveTo (Cx, Cy)
END;

PROCEDURE InsertAbove;

VAR
     Cnt : INTEGER;

BEGIN
     IF m.NumLines = MaxMessageSize
     THEN Exit;
     FOR Cnt := m.NumLines DOWNTO CurLine DO m.Text[Cnt + 1] := m.Text[Cnt];
     m.Text[CurLine] := '';
     Inc (m.NumLines)
END;

PROCEDURE DeleteThis;

VAR
     Cnt : INTEGER;

BEGIN
     IF m.NumLines = 1
     THEN BEGIN
          m.Text[1] := '';
          Exit
     END;
     FOR Cnt := CurLine + 1 TO m.NumLines DO m.Text[Cnt - 1] := m.Text[Cnt];
     m.Text[m.NumLines] := '';
     Dec (m.NumLines);
     CheckCx
END;

PROCEDURE FullReFresh;

VAR
     Cnt, n : INTEGER;

BEGIN
     ClearScr;
     IF TopLine < 1
     THEN TopLine := 1;
     ComputeCy;
     MoveTo (1, 1);
     FOR Cnt := 1 TO Lines DO BEGIN
          n := Cnt + TopLine - 1;
          IF n <= m.NumLines
          THEN BEGIN
               WRITE (m.Text[n]);
               IF Cnt <> Lines
               THEN WRITELN
          END
     END;
     UpdateCPos
END;

PROCEDURE RePos (DoReFresh : BOOLEAN);

VAR
     cl, tl : INTEGER;

BEGIN
     CheckSpaces;
     cl := CurLine;
     tl := TopLine;
     IF CurLine < 1
     THEN CurLine := 1;
     IF CurLine > m.NumLines
     THEN CurLine := m.NumLines;
     IF TopLine > CurLine
     THEN TopLine := CurLine;
     IF TopLine + Lines < CurLine
     THEN TopLine := CurLine - Lines;
     IF TopLine < 1
     THEN TopLine := 1;
     CheckCx;
     ComputeCy;
     IF (cl = CurLine) AND
        (tl = TopLine) AND
        (NOT DoReFresh)
     THEN UpdateCPos
     ELSE FullReFresh
END;

PROCEDURE PartReFresh;  { Refreshes from Cy }

VAR
     Cnt, n : INTEGER;

BEGIN
     IF TopLine < 1
     THEN RePos(True)
     ELSE BEGIN
          MoveTo (1, Cy);
          FOR Cnt := Cy TO Lines DO BEGIN
               n := Cnt + TopLine - 1;
               IF n <= m.NumLines
               THEN WRITE (m.Text[n]);
               ClearEOL;
               IF Cnt <> Lines
               THEN WRITELN
          END;
          UpdateCPos
     END
END;

PROCEDURE PageUp;

BEGIN
     CheckSpaces;
     IF CurLine = 1
     THEN Exit;
     Dec (CurLine, (Lines + 4));
     Dec (TopLine, (Lines + 4));
     RePos (True)
END;

PROCEDURE PageDn;

BEGIN
     CheckSpaces;
     IF CurLine = m.NumLines
     THEN Exit;
     Inc (CurLine, (Lines - 4));
     Inc (TopLine, (Lines - 4));
     RePos (True)
END;

PROCEDURE ToggleIns;

BEGIN
     InsertMode := NOT InsertMode
END;

PROCEDURE ScrollDown;

BEGIN
     TopLine := CurLine - Lines + 2;
     RePos (True)
END;

PROCEDURE ScrollUp;

BEGIN
     IF TopLine < 1
     THEN BEGIN
          Inc (TopLine);
          MoveTo (1, Lines);
          ComputeCy;
          WRITELN
     END
     ELSE BEGIN
          TopLine := CurLine - 1;
          RePos (True)
     END
END;

PROCEDURE TopOfMsg;

BEGIN
     CheckSpaces;
     Cx := 1;
     Cy := 1;
     CurLine := 1;
     IF TopLine = 1
     THEN UpdateCPos
     ELSE BEGIN
          TopLine := 1;
          FullReFresh
     END
END;

PROCEDURE UpdateToEOL;

VAR
     Cnt : INTEGER;

BEGIN
     SaveCSR;
     WRITE (Copy (m.Text[CurLine], Cx, 255));
     ClearEOL;
     RestoreCSR
END;

PROCEDURE LetterKey (k : CHAR);

VAR
     l         : ^LStr;
     w         : LStr;
     n, ox     : INTEGER;
     q         : CHAR;
     Inserted,
     refr      : BOOLEAN;

  PROCEDURE ScrollWWrap;

  BEGIN
       IF TopLine > 0
       THEN BEGIN
            ScrollUp;
            Exit
       END;
       Dec (Cy);
       MoveTo (Length (m.Text[CurLine - 1]) + 1, Cy);
       ClearEOL;
       WRITELN;
       WRITE (m.Text[CurLine]);
       Inc (TopLine);
       Cx := CurX
  END;

BEGIN
     l := Addr (m.Text[CurLine]);
     IF Length (l^) >= RightMargin
     THEN BEGIN
          IF CurLine = MaxMessageSize
          THEN Exit;
          IF Cx <= Length (l^)
          THEN Exit;
          l^ := l^ + k;
          w := '';
          Cx := Length (l^);
          REPEAT
               q := l^[Cx];
               IF q <> ' '
               THEN Insert (q, w, 1);
               Dec (Cx)
          UNTIL (q = ' ') OR
                (Cx < 1);
          IF Cx < 1
          THEN BEGIN
               Cx := Length (l^) - 1;
               w := k
          END;
          l^[0] := Chr (Cx);
          CheckSpaces;
          Inc (CurLine);
          IF CurLine > m.NumLines
          THEN m.NumLines := CurLine;
          Inserted := m.Text[CurLine] <> '';
          IF Inserted
          THEN InsertAbove;
          m.Text[CurLine] := w;
          Inc (Cy);
          ox := Cx;
          Cx := Length (w) + 1;
          refr := Cy > Lines;
          IF refr
          THEN ScrollWWrap
          ELSE BEGIN
               IF Length (w) > 0
               THEN BEGIN
                    MoveTo (ox + 1, Cy - 1);
                    FOR n := 1 TO Length (w) DO WRITE (' ')
               END;
               IF Inserted AND
                  (m.NumLines > CurLine)
               THEN PartReFresh
               ELSE BEGIN
                    MoveTo (1, Cy);
                    WRITE (m.Text[CurLine]);
               END
          END;
          Exit
     END;
     IF InsertMode
     THEN Insert (k, l^, Cx)
     ELSE BEGIN
          WHILE Length (l^) < Cx DO l^ := l^ + ' ';
          l^[Cx] := k
     END;
     WRITE (k);
     Inc (Cx);
     IF InsertMode AND
        (Cx <= Length (l^))
     THEN UpdateToEOL
END;

PROCEDURE Back;

BEGIN
     IF Cx = 1
     THEN BEGIN
          IF CurLine = 1
          THEN Exit;
          CheckSpaces;
          Dec (CurLine);
          Dec (Cy);
          Cx := Length (m.Text[CurLine]) + 1;
          IF Cy < 1
          THEN ScrollDown
          ELSE UpdateCPos;
     END
     ELSE BEGIN
          Dec (Cx);
          clf (1)
     END
END;

PROCEDURE Fowrd;

BEGIN
     IF Cx > Length (m.Text[CurLine])
     THEN BEGIN
          IF CurLine = MaxMessageSize
          THEN Exit;
          CheckSpaces;
          Inc (CurLine);
          IF CurLine > m.NumLines
          THEN m.NumLines := CurLine;
          Inc (Cy);
          Cx := 1;
          IF Cy > Lines
          THEN ScrollUp
          ELSE UpdateCPos
     END
     ELSE BEGIN
          Inc (Cx);
          crg (1)
     END
END;

PROCEDURE Del;

BEGIN
     IF Length (m.Text[CurLine]) = 0
     THEN BEGIN
          DeleteThis;
          PartReFresh;
          Exit
     END;
     Delete (m.Text[CurLine], Cx, 1);
     IF Cx > Length (m.Text[CurLine])
     THEN WRITE (' '^H)
     ELSE UpdateToEOL
END;

PROCEDURE BKSpace;

BEGIN
     IF Length (m.Text[CurLine]) = 0
     THEN BEGIN
          IF CurLine = 1
          THEN Exit;
          DeleteThis;
          CheckSpaces;
          Dec (CurLine);
          Dec (Cy);
          Cx := Length (m.Text[CurLine]) + 1;
          IF Cy < 1
          THEN ScrollDown
          ELSE PartReFresh;
          Exit
     END;
     IF Cx = 1
     THEN Exit;
     Dec (Cx);
     WRITE (^H);
     Del
END;

PROCEDURE BeginLine;

BEGIN
     IF Cx = 1
     THEN Exit;
     Cx := 1;
     UpdateCPos
END;

PROCEDURE EndLine;

VAR dx : INTEGER;

BEGIN
     dx := Length(m.Text[CurLine])+1;
     IF Cx = dx
     THEN Exit;
     Cx := dx;
     UpdateCPos
END;

PROCEDURE UpLine;

VAR
     chx : BOOLEAN;
     l   : INTEGER;

BEGIN
     CheckSpaces;
     IF CurLine = 1
     THEN Exit;
     Dec (CurLine);
     l := Length (m.Text[CurLine]);
     chx := (Cx > l);
     IF chx
     THEN Cx := l + 1;
     Dec (Cy);
     IF Cy > 0
     THEN IF chx
          THEN UpdateCPos
          ELSE Cup (1)
     ELSE ScrollDown
END;

PROCEDURE DownLine;

VAR
     chx : BOOLEAN;
     l   : INTEGER;

BEGIN
     CheckSpaces;
     IF CurLine = MaxMessageSize
     THEN Exit;
     Inc (CurLine);
     IF CurLine > m.NumLines
     THEN m.NumLines := CurLine;
     l := Length (m.Text[CurLine]);
     chx := (Cx > l);
     IF chx
     THEN Cx := l + 1;
     Inc (Cy);
     IF Cy <= Lines
     THEN IF chx
          THEN UpdateCPos
          ELSE cdn (1)
     ELSE ScrollUp
END;

PROCEDURE CRLF;

VAR k:CHAR;

BEGIN
     IF (Length (m.Text[CurLine]) = 2) AND
        (m.Text[CurLine][1] = '/')
     THEN BEGIN
          k := UpCase (m.Text[CurLine][2]);
          CASE k OF
               'S' : BEGIN
                          DeleteThis;
                          MsgDone := True;
                          ANSIReEdit := True;
                          Exit
                     END
          END
     END;
     BeginLine;
     DownLine
END;

FUNCTION ConWord : BOOLEAN;

VAR
     l : ^LStr;

BEGIN
     l := Addr (m.Text[CurLine]);
     ConWord := False;
     IF (Cx > Length (l^)) OR
        (Cx = 0)
     THEN Exit;
     ConWord := True;
     IF Cx = 1
     THEN Exit;
     IF (l^[Cx - 1] = ' ') AND
        (l^[Cx] <> ' ')
     THEN Exit;
     ConWord := False
END;

PROCEDURE WordLeft;

BEGIN
     REPEAT
          Dec (Cx);
          IF Cx < 1
          THEN BEGIN
               IF CurLine = 1
               THEN BEGIN
                    Cx := 1;
                    RePos (False);
                    Exit
               END;
               CheckSpaces;
               Dec (CurLine);
               Dec (Cy);
               Cx := Length (m.Text[CurLine])
          END;
     UNTIL ConWord;
     IF Cx = 0
     THEN Cx := 1;
     IF Cy < 1
     THEN RePos (True)
     ELSE UpdateCPos
END;

PROCEDURE WordRight;

BEGIN
     REPEAT
          Inc (Cx);
          IF Cx > Length (m.Text[CurLine])
          THEN BEGIN
               IF CurLine = m.NumLines
               THEN BEGIN
                    RePos (False);
                    Exit
               END;
               CheckSpaces;
               Inc (CurLine);
               Inc (Cy);
               Cx := 1
          END;
     UNTIL ConWord;
     IF Cy > Lines
     THEN RePos (True)
     ELSE UpdateCPos
END;

PROCEDURE WordDel;

VAR
     l    : ^LStr;
     b    : BYTE;
     s, n : INTEGER;

BEGIN
     l := Addr (m.Text[CurLine]);
     b := Length (l^);
     IF Cx > b
     THEN Exit;
     s := Cx;
     REPEAT
          Inc (Cx)
     UNTIL ConWord OR
           (Cx > b);
     n := Cx - s;
     Delete (l^, s, n);
     Cx := s;
     UpdateToEOL
END;

PROCEDURE DeleteLine;

BEGIN
     DeleteThis;
     PartReFresh
END;

PROCEDURE InsertLine;

BEGIN
     IF m.NumLines >= MaxMessageSize
     THEN Exit;
     InsertAbove;
     CheckCx;
     PartReFresh
END;

PROCEDURE Help;

VAR
     k : CHAR;

BEGIN
     ClearScr;
     PrintFile (TextFileDir + 'EditHelp.ans');
     WRITE (^B^M'Press any key...');
     k := WaitForChar;
     FullReFresh
END;

PROCEDURE BreakLine;

BEGIN
     IF (m.NumLines >= MaxMessageSize) OR
        (Cy = Lines) OR
        (Cx = 1) OR
        (Cx > Length (m.Text[CurLine]))
     THEN Exit;
     InsertAbove;
     m.Text[CurLine] := Copy (m.Text[CurLine+1], 1, Cx - 1);
     Delete (m.Text[CurLine + 1], 1, Cx - 1);
     PartReFresh
END;

PROCEDURE JoinLines;

VAR
     n : INTEGER;

BEGIN
     IF CurLine = m.NumLines
     THEN Exit;
     IF Length (m.Text[CurLine]) + Length (m.Text[CurLine + 1]) > RightMargin
     THEN Exit;
     m.Text[CurLine] := m.Text[CurLine] + m.Text[CurLine + 1];
     n := Cx;
     Inc (CurLine);
     DeleteThis;
     Dec (CurLine);
     Cx := n;
     PartReFresh
END;

PROCEDURE UserEscape;

VAR
     k:CHAR;

BEGIN
     REPEAT
     k := WaitForChar;
     CASE k OF
          'A' : UpLine;
          'B' : DownLine;
          'C' : Fowrd;
          'D' : Back
     END
     UNTIL (k <> '[') OR
           HungUpOn
END;

PROCEDURE DeleteEOL;

BEGIN
     ClearEOL;
     m.Text[CurLine][0] := Chr (Cx - 1)
END;

PROCEDURE Tab;

VAR
     nx, n, Cnt : INTEGER;

BEGIN
     nx := ((Cx + 8) AND 248) + 1;
     n := nx - Cx;
     IF (n + Length (m.Text[CurLine]) >= Cols) OR
        (nx >= Cols)
     THEN Exit;
     FOR Cnt := 1 TO n DO Insert (' ', m.Text[CurLine], Cx);
     UpdateToEOL;
     Inc (Cx, n);
     UpdateCPos
END;

PROCEDURE Commands;

  FUNCTION YouAreSure : BOOLEAN;

  VAR q : STRING[1];

  BEGIN
       YouAreSure := False;
       MoveTo (1, 0);
       WRITE ('Are you sure? ');
       BufLen := 1;
       GetStr;
       Cup (1);
       WRITE ('               ');
       YouAreSure := Yes;
       ClearBreak;
       NoBreak := True
  END;

  PROCEDURE SaveMes;

  BEGIN
       MsgDone := True;
       ANSIReEdit := True
  END;

  PROCEDURE AbortMes;

  BEGIN
       IF YouAreSure
       THEN BEGIN
            m.NumLines := 0;
            MsgDone := True
       END
  END;

  PROCEDURE FormatText;

  VAR
       ol, il, c    : INTEGER;
       oln, wd, iln : LStr;
       k            : CHAR;

    PROCEDURE PutWord;

    VAR
         Cnt : INTEGER;
         b   : BOOLEAN;

    BEGIN
         b := True;
         FOR Cnt := 1 TO Length (wd) DO
              IF wd[Cnt] <> ' '
              THEN b := False;
         IF b
         THEN Exit;
         WHILE wd[Length (wd)] = ' ' DO wd[0] := Pred (wd[0]);
         IF Length (wd) = 0
         THEN Exit;
         IF Length (wd) + Length (oln) > RightMargin
         THEN BEGIN
              m.Text[ol] := oln;
              Inc (ol);
              WHILE (wd[1] = ' ') AND
                    (Length (wd) > 0) DO Delete (wd, 1, 1);
              oln := wd
         END
         ELSE oln := oln + wd;
         IF wd[Length (wd)] IN ['.', '?', '!']
         THEN wd := '  '
         ELSE wd := ' '
    END;

  BEGIN
    il := CurLine;
    ol := il;
    c := 1;
    oln := '';
    wd := '';
    iln := m.Text[il];
    REPEAT
      IF Length (iln) = 0
      THEN BEGIN
        PutWord;
        m.Text[ol] := oln;
        PartReFresh;
        CheckCx;
        UpdateCPos;
        Exit
      END;
      IF c > Length (iln)
      THEN BEGIN
        Inc (il);
        IF il > m.NumLines
          THEN iln := ''
          ELSE BEGIN
            iln := m.Text[il];
            m.Text[il] := ''
          END;
        c := 0;
        k := ' '
      END ELSE k := iln[c];
      Inc (c);
      IF k ='  '
        THEN PutWord
        ELSE wd := wd + k
    UNTIL 0 = 1
  END;

VAR
     cmd : STRING[1];
     k   : CHAR;

BEGIN
  ClearBreak;
  NoBreak := True;
  MoveTo (1, 0);
  WRITE ('Cmd: ');
  BufLen := 1;
  GetStr;
  ClearBreak;
  NoBreak := True;
  Cup (1);
  WRITE ('      ');
  IF Length (Input) = 0
  THEN BEGIN
    UpdateCPos;
    Exit
  END;
  k := UpCase (Input[1]);
  CASE k OF
    'S' : SaveMes;
    'A' : AbortMes;
    'F' : FormatText;
    '?' : Help
  END;
  UpdateCPos
END;

PROCEDURE ProcessKey;

VAR
     k : CHAR;

BEGIN
     ClearBreak;
     NoBreak := True;
     k := WaitForChar;
     CASE k OF
          ' '..'~' : LetterKey (k);
          ^S : Back;
          ^D : Fowrd;
          ^H : BKSpace;
          ^M : CRLF;
          ^V : ToggleIns;
          ^E : UpLine;
          ^X : DownLine;
          ^U : Help;
          ^K : Commands;
          ^R : PageUp;
          ^C : PageDn;
          ^G : Del;
          ^A : WordLeft;
          ^F : WordRight;
          ^T : WordDel;
          ^Q : BeginLine;
          ^W : EndLine;
          ^L : FullReFresh;
          ^Y : DeleteLine;
          ^N : InsertLine;
          ^I : Tab;
          ^B : BreakLine;
          ^P : DeleteEOL;
          ^J : JoinLines;
         #27 : UserEscape
     END
END;

VAR
     Cnt : INTEGER;
     mp  : BOOLEAN;

BEGIN
  ClearBreak;
  NoBreak := True;
  ANSIReEdit := False;
  FOR Cnt := m.NumLines + 1 TO MaxMessageSize DO m.Text[Cnt] := '';
  ScrnSize := urec.DisplayLen;
  Winds[0].y2 := ScrnSize;
  UnSplit;
  WholeScreen;
  GotoXY (1,25);
  ClrEOL;
  IF EightyCols IN urec.Config
    THEN Cols := 80
    ELSE Cols := 40;
  ANSIMode := ANSIGraphics IN urec.Config;
  mp := MorePrompts IN urec.Config;
  IF mp
  THEN urec.Config := urec.Config - [MorePrompts];
  Lines := 15;
  TopScrn := ScrnSize - Lines + 1;
  InsertMode := False;
  RightMargin := Cols - 1;
  MsgDone := False;
  Cx := 1;
  CurLine := 1;
  TopLine := 2 - Lines;
  ComputeCy;
  UpdateCPos;
  IF m.NumLines > 0
    THEN FullReFresh
    ELSE
      BEGIN
        WRITELN (^M'Press ^U for Help.'^M);
        m.NumLines := 1
      END;
  REPEAT
    ProcessKey
  UNTIL MsgDone OR
        HungUpOn;
  MoveTo (1, Lines);
  ClearEOL;
  WRITELN (^M^M^M^M);
  IF mp
  THEN urec.Config := urec.Config + [MorePrompts];
  Winds[0].y2 := 25;
  Bottom;
  BottomLine
END;


{$ifdef testansieditor}
{*}
{*}PROCEDURE termmode;
{*}VAR k:CHAR;
{*}BEGIN
{*}  setparam (1,1200,False);
{*}  WRITELN ('Press ^D when connected.');
{*}  REPEAT
{*}    IF keypressed THEN BEGIN
{*}      read (kbd,k);
{*}      IF k=#4 THEN Exit;
{*}      IF k=#3 THEN Halt;
{*}      SendChar (k)
{*}    END;
{*}    WHILE NumChars>0 DO WRITE (GetChar)
{*}  UNTIL 0=1
{*}END;
{*}
{*}VAR m:Message;
{*}    Cnt:INTEGER;
{*}BEGIN
{*}  CheckBreak:=False;
{*}  urec.DisplayLen:=22;
{*}  urec.Config:=[EightyCols]; { ,ANSIGraphics]; }
{*}  IF NOT driverpresent THEN BEGIN
{*}    WRITELN ('You fool.');
{*}    Halt
{*}  END;
{*}  termmode;
{*}  coninptr:=ofs(readchar);
{*}  conoutptr:=ofs(writechar);
{*}  m.NumLines:=0;
{*}  FOR Cnt:=1 TO 100 DO m.Text[Cnt]:='Hello line '+Chr(Cnt+64);
{*}  WRITELN (ANSIReEdit(m,False))
{*}
{$endif}

END.


