{$R-,S-,I-,D-,F+,V-,B-,N-,L-,O+}

  unit doors;

  Interface

  uses crt,dos,gentypes,modem,configrt,statret,gensubs,subs1,subs2,
  userret,textret,overret1,mainr1,mainr2,mainmenu,others;

  Procedure doorsmenu;

  Implementation

Procedure doorsmenu;

Function numdoors:Integer;
Begin
  numdoors:=FileSize(dofile)
End;

Procedure seekdofile(n:Integer);
Begin
  Seek(dofile,n-1)
End;

Procedure OpenDoFile;
Begin
   Assign(DoFile,'DOORS.DAT');
   Reset(DoFile);
   If IOResult<>0 Then
   Begin
	Close(DoFile);
	Rewrite(DoFile)
   End;
End;

Procedure MaybeMakeBatch(Filen:anystr);
Var TxtFile:Text;
    YN,D:Boolean;
Begin
  If Not issysop Then exit;
  YN:=YeaNa('Make new batch file '+FileN+':',True);
  If (Not YN) And Exist(FileN) Then exit;
  Begin
    If Not Exist(FileN) then writeln('Batch File not found!');
    Assign(TxtFile,FileN);
    Rewrite(TxtFile);
    Writeln('Enter text, blank line to end.'^M);
    Repeat
	 writestr('=> *');
	 D:=Length(Input)=0;
	 If Not D Then Writeln(TxtFile,Input)
    Until D;
    TextClose(TxtFile);
  End;
  Writeln(^M'Batch file created!');
  writelog(10,4,FileN)
End;

Procedure getdoorinfo(Var D:DoorRec);
Var M:Message;
Begin
  Writeln(^B^M'Enter information about this door:'^M);
  D.Info:=editor(M,False,False,'0','0')
End;

Procedure dorinfo1;
Var U:Userrec;
    FileN:text;
Begin
  Assign(FileN,'DORINFO1.DEF');
  Rewrite(FileN);
  Writeln (FileN,configset.LongNam);		{BBS name}
  Writeln(FileN,configset.SysOpNam);		{sysop first name}
  Writeln(FileN,' ');             		     {sysop last name}
{ if local then Writeln(FileN,'LOCAL')  }    {COMM port}
{ else}
   Writeln(FileN,configset.useco);
   if local then Writeln(FileN,'0 BAUD,N,8,1')
   else Writeln(FileN,baudrate,' BAUD,N,8,1');     {baudrate BAUD,N,n,x}
   Writeln(FileN,'0');                             {network type }
   Writeln(FileN,unam);                            {user first name}
   Writeln(FileN,' ');                             {user last name}
   Writeln(FileN,'ShockWavE Land');                {user city,state}
   if (ansigraphics in urec.config)                {0=No, 1=Ascii, 2=Ansi}
   then Writeln(FileN,'2')                         {0=No, 1=Ascii, 2=Ansi}
   else Writeln(FileN,'0'); 		                {0=No, 1=Ascii, 2=Ansi}
   Writeln(FileN,urec.level);                            {user level}
   Writeln(FileN,timeleft);                        {time remaining}
   TextClose(FileN);
End;

Function CheckBatchName(Var qq):Boolean;
Var I:lstr Absolute qq;
    P:Integer;
Begin
  P:=Pos('.',I);
  If P<>0 Then I[0]:=Chr(P-1);
  I:=I+'.BAT';
  CheckBatchName:=ValidFName(I)
End;

Procedure MaybeMakeDoor;
Var N:Integer;
    D:doorrec;
    YN:Boolean;
Begin
  If (Not configset.remotedoor) And carrier Then
  Begin
	Writeln('Sorry, remote door maintenance is not allowed!');
	Writeln(usr,'(Please re-configure to change this setting)');
	Exit;
  End;

  If Not issysop Then exit;

  N:=FileSize(DoFile)+1;
  YN:=YeaNa('Make new door #'+strr(n)+':',true);
  If Not YN Then exit;
  Writestr(^M'Door Name:');
  If Length(Input)=0 Then Exit;
  D.Name:=Input;
  Writestr('Access level:');
  If Length(Input)=0 Then exit;
  D.level:=Valu(Input);
  Writestr('Name of batch file:');
  If Length(Input)=0 Then Exit;
  If Not CheckBatchName(Input) Then
  Begin
    Writeln('Invalid filename: '^S,Input);
    Exit;
  End;
  D.BatchName:=ConfigSet.DoorDi+Input;
  YN:=YeaNa('Ask for opening parameters:',False);
  D.GetParams:=YN;
  GetDoorInfo(D);
  If D.Info<0 Then exit;
  D.NumUsed:=0;
  SeekDoFile(N);
  Write(Dofile,D);
  If Not Exist(D.BatchName) Then
  Begin
    Writeln(^B'Can''t open batch file ',d.batchname);
    MaybeMakeBatch(D.BatchName)
  End;
   Writeln(^B^M'Door created!');
   WriteLog(10,3,D.Name)
End;

Function HaveAccess(I:Integer):Boolean;
Var D:doorrec;
Begin
  HaveAccess:=False;
  seekdofile(I);
  Read(DoFile,D);
  If urec.Level>=D.Level Then HaveAccess:=True
  Else ReqLevel(D.Level)
End;

Procedure ListDoors;
Var D:doorrec;
    Cnt:Integer;
Begin
  Writehdr('Online Doors Available');
  SeekDoFile(1);
  Writeln ('Ŀ');
  Writeln (' Door Name/Number          Level Required  Times Used ');
  Writeln ('Ĵ');
  For Cnt:=1 To NumDoors Do
  Begin
    Read(DoFile,D);
    If Urec.Level>=D.Level Then
    Begin
	 tab(' '+strr(cnt)+'.  '+D.Name,27);
	 tab('       '+strr(D.Level),17);
	 tab('    '+strr(D.Numused),13);
	 Writeln ('');
	 If break Then
	 Begin
	   Writeln ('');
	   Exit;
	 End;
    End;
  End;
  Writeln('');
End;

Function GetDoorNum(Txt:Mstr):Integer;
Var Z:Boolean;
    I:Integer;
Begin
  GetDoorNum:=0;
  Z:=False;
  Repeat
    {ListDoors;}
    Writestr('Door number to '+txt+' [?=list]:');
    Writeln;
    If Input='?' Then Listdoors Else Z:=True
  Until Z;
  If Length(Input)=0 Then exit;
  I:=Valu(Input);
  If (I<1) Or (I>NumDoors) Then Writeln('Door number out of range!')
  Else If HaveAccess(I) Then GetDoorNum:=I
End;

Procedure OpenDoor;
Var I,BD,P:Integer;
    D:doorrec;
    BatchF,Outf:Text;
    Z:Boolean;
    Tmp,Params:lstr;
Begin
	 I:=GetDoorNum('open');
	 If I=0 Then exit;
	 SeekDoFile(I);
	 Read(DoFile,D);
	 Printtext(D.Info);
	 If D.GetParams Then writestr('Parameters:') Else Input:='';
	 Params:=Input;
	 P:=Pos('>',Input);
	 If P=0 Then P:=Pos('>',Input);
	 If P=0 Then P:=Pos('<',Input);
	 If P=0 Then P:=Pos('|',Input);

	 If P<>0 Then
	 Begin
	   Writeln('You may not specify pipes in door parameters.');
	   Exit;
	 End;

      Params:=strr(baudrate)+' '+Strr(timeleft)+' '+Strr(unum)+' '+Unam+' ';

	 If Ansigraphics In Urec.Config Then Params:=Params+'1 1' Else Params:=Params+'0 0';
	 Writestr(^M'Press [Space] to continue, or [X] to abort');
	 If UpCase(waitforchar)='X' Then exit;
	 Writeln('Executing door: ',D.Name);
	 Z:=True;

	 Repeat
	   Assign(BatchF,D.BatchName);
	   Reset(BatchF);
	   If IOResult<>0 Then
	   Begin
		Z:=False;
		Close(BatchF);
		IOcode:=IOResult;

		If Not issysop Then
		Begin
		  FileError('Opendoor',D.BatchName);
		  Exit;
		End
	   Else
		Begin
		  MaybeMakeBatch(D.BatchName);
		  If Not exist(D.BatchName) Then exit
		End
        End
	 Until Z;

  Assign(OutF,'DOOR.BAT');
  Rewrite(OutF);
  {Writeln(OutF,'TEMPDOOR ',Params);}
  Writeln(OutF,'TEMPDOOR');
  TextClose(OutF);

  Assign(OutF,'TEMPDOOR.BAT');
  Rewrite(OutF);

  While Not EoF(BatchF) Do
  Begin
    ReadLn(BatchF,Tmp);
    Writeln(OutF,Tmp)
  End;

  If online Then BD:=BaudRate Else BD:=0;
  GetDir(0,Tmp);
  Writeln(outf,'cd '+tmp);
  Writeln(outf,'main ',unum,' ',bd,' ',Ord(parity),' D');
  textclose(batchf);
  textclose(outf);
  d.numused:=d.numused+1;
  seekdofile(I);
  Write(dofile,d);
  writelog(9,1,d.name);
  updateuserstats(False);
  writeurec;
  writestatus;
  ensureclosed;
  Halt(3);
End;

  Procedure getinfo;
    Var n:Integer;
      d:doorrec;
    Begin
      n:=getdoornum('get information on');
      If n=0 Then exit;
      seekdofile(n);
      Read(dofile,d);
	 Writeln;
      printtext(d.info)
    End;

  Procedure changedoor;
    Var n:Integer;
      d:doorrec;
    Begin
      n:=getdoornum('Change');
      If n=0 Then exit;
      seekdofile(n);
      Read(dofile,d);
	 Writeln('Name: ',d.name);
      writestr('New name:');
      If Length(Input)>0 Then d.name:=Input;
	 Writeln(^M'Level: ',d.level);
      writestr('New level:');
      If Length(Input)>0 Then d.level:=valu(Input);
	 Writeln(^M'Batch file name: ',d.batchname);
      writestr('New batch file name:');
      If Length(Input)>0 Then
        If checkbatchname(Input)
        Then d.batchname:=Input
	   Else Writeln('Invalid filename: '^S,Input);
      maybemakebatch(d.batchname);
	 Writeln;
      printtext(d.info);
      writestr(^M'Replace text [y/n]:');
      If yes Then
        Repeat
          deletetext(d.info);
          getdoorinfo(d);
		If d.info<0 Then Writeln(^M'You must enter some information.')
        Until d.info>=0;
      seekdofile(n);
      Write(dofile,d);
      writelog(10,1,d.name)
    End;

  Procedure deletedoor;
    Var n,cnt:Integer;
      td,d:doorrec;
      f:File;
    Begin
      n:=getdoornum('delete');
      If n=0 Then exit;
      seekdofile(n);
      Read(dofile,d);
      writestr('Delete '+d.name+': Confirm:');
      If Not yes Then exit;
	 Writeln('Deleting...');
      seekdofile(n+1);
      For cnt:=n To FileSize(dofile)-1 Do Begin
        Read(dofile,td);
        seekdofile(cnt);
        Write(dofile,td)
      End;
      Seek(dofile,FileSize(dofile)-1);
      Truncate(dofile);
      deletetext(d.info);
      writestr(^M'Erase disk file '+d.batchname+'? *');
      If yes Then Begin
        Assign(f,d.batchname);
        Erase(f);
	   If IOResult<>0 Then Writeln('(File not found)')
      End;
      writelog(10,2,d.name)
    End;

  Procedure sysopdoors;
    Var q:Integer;
    Begin
	 If (Not configset.remotedoor) And carrier Then Begin
        writestr('Sorry, remote door maintenance is not allowed!');
        writestr('(Please re-configure to change this setting)');
        exit
      End;
      Repeat
	   q:=menu('Door SysOp','DOOR','QCAD@');
        Case q Of
          2:changedoor;
          3:maybemakedoor;
          4:deletedoor
        End
      Until hungupon Or (q=1) Or (FileSize(dofile)=0)
    End;

  Var q:Integer;
  Begin
    If Not configset.allowdoor Then Begin
      writestr('No doors open! ');
      If issysop Then writestr('(Please re-configure to change this setting)');
      exit
    End;
    If fromdoor Then Begin
      fromdoor:=False;
	 If returnto='D' Then Writeln(^M^M^M'[System Return Successful]')
    End;

    cursection:=doorssysop;
    opendofile;
    If numdoors=0 Then Begin
      writestr('No doors exist!');
      maybemakedoor;
      If numdoors=0 Then Begin
        Close(dofile);
        exit
      End
    End;

    	if not postcall then
	begin
     writeln('Your Post/Call Ratio is out of line. Go to the message bases and POST');
     writeln('some messages in order to correct this!');
     WRiteln(^M^M^M);
     exit;
     end;

    DorInfo1;
    Writehdr('Doors available: '+strr(numdoors));
    Repeat
	 q:=menu('OnLine Doors','DOOR','QLOIH%G');
      Case q Of
        2:listdoors;
        3:opendoor;
        4:getinfo;
{	   5:Help; }
	   6:sysopdoors;
	   7:offtheforum;
      End
    Until hungupon Or (q=1) Or (FileSize(dofile)=0);
    Close(dofile)
  End;

Begin
End.
