uses crt,dos,doors,
	gentypes,modem,configrt,statret,gensubs,subs1,subs2,
  userret,textret,overret1,mainr1,mainr2;

procedure write_dorinfo1_def(rname:boolean);     { RBBS-PC DORINFO1.DEF }
procedure write_door_sys(rname:boolean);         { GAP DOOR.SYS }
procedure write_chain_txt;                       { WWIV CHAIN.TXT }
procedure write_callinfo_bbs(rname:boolean);     { Wildcat! CALLINFO.BBS }
procedure write_sfdoors_dat(rname:boolean);      { Spitfire SFDOORS.DAT }

function upcasestr(s:string):string;
var i,j:integer;

	Begin
		J:=ord(s[0]);
		for i:=1 to j do
		s[i]:=upcase(s[i]);
		upcasestr:=s;
	end;


procedure write_dorinfo1_def(rname:boolean);  (* RBBS-PC's DORINFO1.DEF *)
var fp:text;
   first:lstr;
    last:lstr;
    s:lstr;
begin
  assign(fp,'dorinfo1.def');
	rewrite(fp);
	writeln(fp,configset.longnam);
first:=copy(configset.sysopnam,1,pos(' ',configset.sysopnam)-1);
	last:=copy(configset.sysopnam,length(first)+2,length(configset.sysopnam));
  writeln(fp,first);
  writeln(fp,last);
  if local then writeln(fp,'Local') else writeln(fp,configset.useco);
if local then writeln (fp,'0 BAUD,N,8,1') else
  writeln(fp,baudrate,' BAUD,N,8,1');
  if (rname) then begin
    if pos(urec.realname,'')=0 then begin
	 first:=urec.realname;
      last:='';
    end else begin
	 first:=copy(urec.realname,1,pos(' ',urec.realname)-1);
      last:=copy(urec.realname,length(first)+2,length(urec.realname));
    end;
    first:=upcasestr(first);
    last:=upcasestr(last);
  end else begin
    if pos(unam,'')=0 then begin
	 first:=unam;
      last:='';
    end else begin
	 first:=copy(unam,1,pos(' ',unam)-1);
	 last:=copy(unam,length(first)+2,length(unam));
    end;
  end;
  writeln(fp,upcasestr(first));
  writeln(fp,upcasestr(last));
  writeln(fp,'Nowhere');
  if (ansigraphics in urec.config) then writeln(fp,'1') else writeln(fp,'0');
  writeln(fp,ulvl);
  writeln(fp,timeleft);
  close(fp);
end;

{procedure write_door_sys(rname:boolean);    (* GAP's DOOR.SYS *)
var fp:text;
    i:integer;
    s:lstr;
begin
  assign(fp,'door.sys');
  rewrite(fp);
  if local then writeln(fp,'COM0:') else writeln(fp,'COM:',+configset.useco);
  if local then writeln(fp,LOCAL) else writeln(fp,baudrate);
	writeln(fp,' 8');
	writeln(fp,' 1');
	writeln(fp,' N');
	writeln(fp,' Y');
	writeln(fp,' Y');
	if issysop then writeln(fp,' Y') else writeln(fp,' N');
	if wanted in urec.config then writeln(fp,' Y') else writeln(fp,' N');
  if (rname) then writeln(fp,urec.realname) else writeln(fp,unam);
  writeln(fp,'Nowhere');
  writeln(fp,copy(urec.phone)+' '+copy(thisuser.ph,5,8));
  writeln(fp,copy(thisuser.ph,1,3)+' '+copy(thisuser.ph,5,8));
  writeln(fp,thisuser.pw);
  writeln(fp,cstr(thisuser.sl));
  writeln(fp,cstr(thisuser.loggedon));
  writeln(fp,thisuser.laston);
  writeln(fp,cstrl(trunc(nsl)));
  writeln(fp,cstr(trunc(nsl) div 60));
  if okansi then writeln(fp,'GR') else writeln(fp,'NG');
  writeln(fp,cstr(thisuser.pagelen));
	if novice in thisuser.ac then writeln(fp,' N') else writeln(fp,' Y');
  s:='';
  for i:=1 to 7 do
    if chr(i+64) in thisuser.ar then s:=s+cstr(i);
  writeln(fp,s);
  writeln(fp,'7');
	writeln(fp,'12/31/99');
	writeln(fp,' '+cstr(usernum));
	writeln(fp,' X');
	writeln(fp,' '+cstr(thisuser.uploads));
	writeln(fp,' '+cstr(thisuser.downloads));
	writeln(fp,' '+cstr(trunc(thisuser.dk)));
	writeln(fp,' 999999');
  close(fp);
end;        }

procedure write_chain_txt;
var fp:text;
    ton,tused:real;
    s:string[20];

  function bo(b:boolean):lstr;
  begin
    if b then bo:='1' else bo:='0';
  end;

begin
  assign(fp,'chain.txt');
  rewrite(fp);
  with urec do begin
    writeln(fp,unum);                      { user number        }
    writeln(fp,unam);                         { user name          }
    writeln(fp,realname);                     { real name          }
    writeln(fp,'');                           { "call sign" ?      }
    writeln(fp,'');                           { age                }
    writeln(fp,'');                           { sex                }
    writeln(fp,'');                           { credit             }
    writeln(fp,laston);                       { laston date        }
    writeln(fp,eightycols in urec.config);    { # screen columns   }
    writeln(fp,urec.displaylen);    { # screen rows      }
    writeln(fp,ulvl);                           { Security Level     }
    writeln(fp,bo(issysop));                       { is he a SysOp?     }
    writeln(fp,bo(issysop));                      { is he a CoSysOp?   }
    writeln(fp,bo(ansigraphics in urec.config));                   { is graphics on?    }
    writeln(fp,bo(not local));                    { is remote?         }
    s:=(timeleft * 60);
    writeln(fp,s);           { time left (sec)    }
    writeln(fp,configset.gfilepath);          { gfiles path        }
    writeln(fp,configset.gfilepath);          { data path          }
    writeln(fp,'SYSOP.LOG');                  { SysOp log filespec }
    s:=spd; if (s='KB') then s:='0';          { baud rate          }
    writeln(fp,s);
    writeln(fp,modemr.comport);               { COM port           }
    writeln(fp,stripcolor(configset.bbsname));{ system name        }
    writeln(fp,configset.sysopname);          { SysOp's name       }
    with timeon do begin
      ton:=hour*3600.0+min*60.0+sec;
      tused:=timer-ton;
      if (tused<0) then tused:=tused+3600.0*24.0;
    end;
    writeln(fp,trunc(ton));                   { secs on f/midnight }
    writeln(fp,trunc(tused));                 { time used (sec)    }
    writeln(fp,uk);                           { upload K           }
    writeln(fp,uploads);                      { uploads            }
    writeln(fp,dk);                           { download K         }
    writeln(fp,downloads);                    { downloads          }
    writeln(fp,'8N1');                        { COM parameters     }
  end;
  close(fp);
end;

procedure write_callinfo_bbs(rname:boolean);
var fp:text;
		s:astr;

  function bo(b:boolean):astr;
  begin
    if b then bo:='1' else bo:='0';
  end;

begin
  assign(fp,'callinfo.bbs');
  rewrite(fp);
  with thisuser do begin
    if (rname) then writeln(fp,upcasestr(urec.realname)) else writeln(fp,allcaps(unam));
    if spd='300' then s:='1' else
      if spd='1200' then s:='2' else
      if spd='2400' then s:='0' else
      if spd='9600' then s:='3' else
      if spd='KB' then s:='5' else
      s:='4';
    writeln(fp,s);
    writeln(fp,allcaps('Nowhere'));
    writeln(fp,cstr(thisuser.sl));
    writeln(fp,timestr);
    if okansi then writeln(fp,'COLOR') else writeln(fp,'MONO');
    writeln(fp,thisuser.pw);
    writeln(fp,cstr(usernum));
    writeln(fp,'0');
    writeln(fp,copy(time,1,5));
    writeln(fp,copy(time,1,5)+' '+date);
    writeln(fp,'A');
    writeln(fp,'0');
    writeln(fp,'999999');
    writeln(fp,'0');
    writeln(fp,'999999');
    writeln(fp,thisuser.ph);
    writeln(fp,thisuser.laston+' 00:00');
    if (novice in thisuser.ac) then writeln(fp,'NOVICE') else writeln(fp,'EXPERT');
    writeln(fp,'All');
    writeln(fp,'01/01/80');
    writeln(fp,cstr(thisuser.loggedon));
    writeln(fp,cstr(thisuser.pagelen));
    writeln(fp,'0');
    writeln(fp,cstr(thisuser.uploads));
    writeln(fp,cstr(thisuser.downloads));
    writeln(fp,'8  { Databits }');
    if ((incom) or (outcom)) then writeln(fp,'REMOTE') else writeln(fp,'LOCAL');
    if ((incom) or (outcom)) then writeln(fp,'COM'+cstr(modemr.comport)) else writeln(fp,'COM0');
    writeln(fp,thisuser.bday);
    if spd='KB' then writeln(fp,cstr(modemr.waitbaud)) else writeln(fp,spd);
    if ((incom) or (outcom)) then writeln(fp,'TRUE') else writeln(fp,'FALSE');
    if (spdarq) then write(fp,'MNP/ARQ') else write(fp,'Normal');
    writeln(fp,' Connection');
    writeln(fp,'12/31/99 23:59');
    writeln(fp,'1');
    writeln(fp,'1');
  end;
  close(fp);
end;

procedure write_sfdoors_dat(rname:boolean);   { Spitfire SFDOORS.DAT }
var fp:text;
    s:astr;
begin
  assign(fp,'SFDOORS.DAT');
  rewrite(fp);
  writeln(fp,cstr(usernum));
  if (rname) then writeln(fp,allcaps(urec.realname)) else writeln(fp,allcaps(unam));
  writeln(fp,thisuser.pw);
  if (rname) then begin
    if (pos(' ',urec.realname)=0) then s:=urec.realname
    else s:=copy(urec.realname,1,pos(' ',urec.realname)-1);
  end else begin
    if (pos(' ',unam)=0) then s:=unam
    else s:=copy(unam,1,pos(' ',unam)-1);
  end;
  writeln(fp,s);
  if (spd='KB') then writeln(fp,'0') else writeln(fp,cstr(modemr.comport));
  writeln(fp,timestr);
  writeln(fp,'0');   { seconds since midnight }
  writeln(fp,start_dir);
  if okansi then writeln(fp,'TRUE') else writeln(fp,'FALSE');
  writeln(fp,cstr(thisuser.sl));
  writeln(fp,cstr(thisuser.uploads));
  writeln(fp,cstr(thisuser.downloads));
  writeln(fp,cstr(configset.timeallow[thisuser.sl]));
  writeln(fp,'0');   { time on (seconds) }
  writeln(fp,'0');   { extra time (seconds) }
  writeln(fp,'FALSE');
  writeln(fp,'FALSE');
  writeln(fp,'FALSE');
  if (spd='KB') then writeln(fp,'0') else writeln(fp,spd);
  close(fp);
end;


  case kind of
    'C':begin
          commandline('Outputting CHAIN.TXT (WWIV) ...');
          write_chain_txt;
        end;
    'D':begin
          commandline('Outputting DORINFO1.DEF (RBBS-PC) ...');
          write_dorinfo1_def(realname);
        end;
    'G':begin
          commandline('Outputting DOOR.SYS (GAP) ...');
          write_door_sys(realname);
        end;
    'S':begin
          commandline('Outputting SFDOORS.DAT (Spitfire) ...');
          write_sfdoors_dat(realname);
        end;
    'W':begin
          commandline('Outputting CALLINFO.BBS (Wildcat!) ...');
          write_callinfo_bbs(realname);
        end;
  end;
  commandline('Now running "'+s+'"');
