(*****************************************************************************)
(*>                                                                         <*)
(*>  WFCMENU .PAS -  Written by Eric Oman                                   <*)
(*>                                                                         <*)
(*>  Waiting For Caller menu.  Allows SysOp to use SysOp functions, see     <*)
(*>  various status reports, and log on locally.                            <*)
(*>                                                                         <*)
(*****************************************************************************)
{$A+,B+,D-,E+,F+,I+,L+,N-,O+,R-,S+,V-}
unit wfcmenu;

interface

uses
  OPcrt, dos, overlay,
  MsgEdit,

  file0, file1, file2, file4, file5, file6,
  file7, file8, file9, file10, file11, file12,

  EventCfg,FBaseDit,TextCfg,ShowMnu,TextEdit,SysMain,UserEdit,
  ProtoCfg,MenuEdit,

  archive1, archive2,

  misc1, misc2, misc3, miscX,

  cuser, doors,  tmpcom,  mmodem,  menus2,
  myio,  common, logon1, logon2, newusers;

procedure wfcmdefine;
procedure hangupphone;
procedure wfcmenus(wanthangup:boolean);

implementation

Uses
  WinTTT5,MenuTTT5,FilesAcc;

var
  lactive:real;
  blankmenunow:boolean;
  lastkeypress:datetimerec;

procedure showlogo;
  var i:integer;
Begin
    gotoxy(1,1);
    textattr:=14; write(centre(verline(1)));
    gotoxy(1,2);
    textattr:=11; write(centre(verline(2)));
End;

procedure wfcmdefine;
var macrf:file of macrorec;
    i:integer;
begin
  etoday:=0; ptoday:=0; chatt:=0; shutupchatcall:=FALSE;
  flistverb:=TRUE; badfpath:=FALSE;

  cwindowon:=FALSE;
  telluserevent:=0;
  fastlogon:=FALSE;
  fileboard:=1;
  board:=1;
  HotKeyHit := #0;
  readuboard:=-1;
  inwfcmenu:=TRUE;
  wantfilename:=FALSE;
  nopfile:=FALSE; doitt:=FALSE; enddayf:=FALSE;
  smread:=FALSE; checkit:=FALSE;
  outcom:=FALSE; useron:=FALSE; ll:=''; chatr:=''; buf:='';
  hangup:=FALSE; usernum:=1; chatcall:=FALSE; hungup:=FALSE;
  msgon:=1;textbackground(0); clrscr; pap:=0;
  lactive:=timer;
  reset(uf);
  if (filesize(uf)>1) then
  begin
    seek(uf,1); read(uf,thisuser);
    close(uf);
    newcomptables;
    usernum:=1;
    readinmacros;
    readinzscan;
  end else
  begin
    close(uf);
    with thisuser do begin
      linelen:=80; pagelen:=25;
      ac:=[onekey,pause,novice,ansi,color];
      ac:=ac-[avatar];
    End;
  End;
End;

procedure getcallera(var c:char; var chkcom:boolean);
var rl,rl1:real;
    s:astr;

  procedure getresultcode(rs:astr);
  var i,j:integer;
  begin
    with systat do
      for i:=1 to 2 do
      begin
        spdarq:=(i=2);
        for j:=0 to 4 do
          if (systat.resultcode[i][j]<>0) and
             (value(rs)=systat.resultcode[i][j]) then begin
            case j of
              0:spd:='300';
              1:spd:='1200';
              2:spd:='2400';
              3:spd:='4800';
              4:begin
                  if (not spdarq) then spd:='9600'
                    else spd:=cstrl(systat.LockedPortBaud);
                End;
            End;
            ChkCom:=TRUE;
            exit;
          End;
      End;
  End;

  procedure wmb(s:astr);
  begin
    textcolor(14); write(s[1]);
    textcolor(12); write(copy(s,2,length(s)-1));
  End;

begin
  if (ChkCom) then
  begin
    if (recom1(c)) then ;
    cwr(1); cwr(2); wr(2,c);
    if (c='2') then begin
      ChkCom:=TRUE; rl:=timer;
      while (c<>#13) and (abs(rl-timer)<0.2) do begin
        c:=ccinkey1;
        wr(2,c);
      End;
    End;
    if (ChkCom) then
    begin
      if (sysopon) then cursoron(TRUE);
      gotoxy(1,24); tc(12); clreol;
      write(' Answering phone...');
      if (sysopon) then begin
        write(' Force- ');
        wmb('300 '); wmb('1200 '); wmb('2400 '); wmb('4800 ');
        wmb('9600 '); wmb('A19200 '); wmb('B38400 '); wmb('Hang up');
      End;
      gotoxy(1,24); tc(3);
      delay(50); com_flush_rx; rl1:=timer; s:=''; rl:=0.0;
      repeat
        ChkCom:=FALSE;
        if (answerbaud>2) then
        begin
          spd:=cstr(answerbaud);
          ChkCom:=TRUE;
          answerbaud:=0;
        End;
        if (keypressed) then
        begin
          c:=upcase(readkey);
          if (c='H') then begin
            cwr(1); wr(1,'A');
            ChkCom:=TRUE;
            pr('A');
            delay(200);
            com_flush_rx;
          End;
          case c of
            '3':spd:='300';
            '1':spd:='1200';
            '2':spd:='2400';
            '4':spd:='4800';
            '9':spd:='9600';
            'A':spd:='19200';
            'B':spd:='38400';
          End;
          ChkCom:=TRUE;
        End;
        c:=ccinkey1;
        if (rl<>0.0) and (abs(rl-timer)>2.0) and (c=#0) then c:=#13;
        if (c<#32) and (c<>#13) then c:=#0;
        if c<>#0 then
          if c<>#13 then begin
            cwr(2);
            s:=s+c;
            wrs(2,s);
            rl:=timer;
          end else begin
            if (s=cstr(systat.nocarrier)) then ChkCom:=TRUE;
            getresultcode(s);
            rl:=0.0;
          End;
        if (c=#13) then s:='';
        if (abs(timer-rl1)>45.0) then ChkCom:=TRUE;
      until ChkCom;
      if (abs(timer-rl1)>45.0) then begin c:='X'; End;
      clrscr;
    End;
    if (spd<>'KB') then incom:=TRUE;
  End;
End;

Procedure ShowWaitMenu;
Const
 ForeColor= Yellow;
 BColor   = Blue;
Var
 I : Longint;
 Str : String;
Begin
if (SysOpOn) then
 Begin
   ShowLogo;
   Mkwin(1,3,80,17,ForeColor,BColor,1);
   for I := 1 to 11 do
    Begin
     gotoxy(15,i+4);
     Case I of
       1:Str :='C) aller List';
       2:Str :='L) Sysop Logs';
       3:Str :='S) ystem Stats';
       4:Str :='Z) Usage Log';
       5:Str :='A) nswer Modem';
       6:Str :='H) ang UP Modem';
       7:Str :='O) ff Hook';
       8:Str :='+) Init Modem';
       9:Str :='';
      10:Str :='';
      11:Str :='';
    End; { Case }
    TextColor(Forecolor);
    TextBackGround(BColor);
    write(Str);
  End; { For }

  for I := 1 to 10 do
    Begin
     gotoxy(45,i+4);
     Case I of
      1:Str :='V) System Configuration';
      2:Str :='B) MsgBase Config';
      3:Str :='F) ileBase Config';
      4:Str :='E) vent Edit';
      5:Str :='G) TextFileBase Edit';
      6:Str :='P) System Misc Config';
      7:Str :='U) ser Edit';
      8:Str :='X) Protocol Edit';
      9:Str :='#) Menu Edit';
      10:Str:='Q) uit';
    End;  { Case }
    TextColor(Forecolor);
    TextBackGround(BColor);
    write(Str);
  End; { For }
 End else { IF }
  printf('LocalSec');
End;


procedure wfcmenu1(Var c: Char);


  procedure dot(x,y:integer);
  begin
    gotoxy(x,y);
    write('');
  End;

begin
  window(1,1,80,25); cursoron(FALSE);  clrscr;
  if (Not BlankMenuNow) then
   begin
     ShowWaitMenu;
    if (KeyPressed) then
        C := UpCase(ReadKey) else
        C:=#0;
   End;
End;

procedure hangupphone;
begin
  dophonehangup(TRUE);
End;

procedure optimize_mail;
var x:smr;
    s,d:integer;
begin
  if (smread) then begin
    {$I-} reset(smf); {$I+}
    if (ioresult=0) then begin
      if (filesize(smf)>1) then begin
        s:=0; d:=0;
        while (s<filesize(smf)) do begin
          seek(smf,s); read(smf,x);
          if (x.destin<>-1) then
            if (s=d) then inc(d) else begin
              seek(smf,d); write(smf,x);
              inc(d);
            End;
          inc(s);
        End;
        seek(smf,d);
        truncate(smf);
      End;
      close(smf);
    End;
  End;
End;

procedure wfcmenus(wanthangup:boolean);
var
    u:userrec;
    x:smr;
    lcallf:file of lcallers;
    lcall:lcallers;
    dt,ddt:datetimerec;
    ltime,s,wfcmessage,lcaller:astr;
    rr,rl,rl1,rl2,lastinit:real;
    duh,duh2,txt,txt1,txt2,i,j,k,sk,rcode:integer;
    c,c1:char;
    nogoodcmd,wfcm,phoneoffhook,ChkCom,tdoneafternext,oldphoneoffhook:boolean;
    sysopfo:boolean;

  procedure i1;
  var s:astr;
      rl,rl1:real;
      try:integer;
      c,isc:char;
      done:boolean;
  begin
    if ((systat.init<>'') and (answerbaud=0) and (not localioonly)) then
    begin
      ChkCom := False;
      TextColor(Red);  TextBackGround(Black);
      gotoxy(1,24); tc(12); clreol; write('Initializing modem...');
      if (not keypressed) then
      begin
        c:=#0; s:=''; done:=FALSE; try:=0;
        rl:=timer;
        while (keypressed) do c:=readkey;
        repeat
          cwr(1); cwr(2);
          InitFossil(systat.comport,Systat.WaitBaud);
          outmodemstring1(systat.init);
          com_flush_rx;
          rl1:=timer;
          repeat
            if (recom1(c)) then
            begin
              if (c in ['0',^M]) then done:=TRUE;
              if (c in [#32..#255]) then wr(2,c);
            End;
          until ((abs(timer-rl1)>2.5) or (done)) or (keypressed);
          if (done) then delay(100);
          inc(try);
          if (try>10) then done:=TRUE;
        until ((done) or (keypressed));
      End;
      while (keypressed) do isc:=readkey;
      delay(100); com_flush_rx;
      rl1:=timer; repeat c:=ccinkey1 until (abs(timer-rl1)>0.1);

      tc(11);
      gotoxy(1,24); clreol;
      gotoxy(1,25); clreol;
    End;
    phoneoffhook:=FALSE;
    wfcmessage:='';
    lastinit:=timer;
    while (keypressed) do c:=readkey;
    com_flush_rx;
  End;


  function cpw:boolean;
  var i:astr;
  begin
    if (not sysopon) then begin
      tc(8); write('Sysop PW? '); tc(1);
      echo:=FALSE;
      input(i,20);
      echo:=TRUE;
      clrscr;
      cpw:=(i=systat.sysoppw);
    end
    else cpw:=TRUE;
  End;

  procedure takeoffhook;
  begin
    if (not localioonly) then begin
      dophoneoffhook(TRUE);
      phoneoffhook:=TRUE;
      wfcmessage:='Phone off hook';
    End;
  End;

  procedure beephim;
  var rl,rl1:real; ch:char;
  begin
    takeoffhook;
    beepend:=FALSE;
    rl:=timer;
    repeat
      sound(1500); delay(20);
      sound(1000); delay(20);
      sound(800); delay(20);
      nosound;
      rl1:=timer;
      while (abs(rl1-timer)<0.9) and (not keypressed) do;
    until (abs(rl-timer)>30.0) or (keypressed);
    if keypressed then ch:=readkey;
    i1;
  End;

  procedure chkevents;
  var i,rcode:integer;
  begin
    if (checkevents(0)<>0) then
      for i:=0 to numevents do begin
        if (checkpreeventtime(i,0)) then
          if (not phoneoffhook) then begin
            takeoffhook;
            wfcmessage:='Phone off hook in preparation for event at '+
                        copy(ctim(events[i]^.exectime),4,5)+':00';
          End;
        if (checkeventtime(i,0)) then
          with events[i]^ do begin
            i1;
            if (busyduring) then takeoffhook;
            clrscr; write('<<< '+copy(ctim(exectime),4,5)+':00 >>> - Event: ');
            writeln('"'+description+'"');
            sl1('');
            sl1('[> Ran Event "'+description+'" on '+date+' '+time);
            case Etype of

              'D':begin
                    sysopfo:=(textrec(sysopf).mode<>fmclosed);
                    if (sysopfo) then close(sysopf);
                    cursoron(TRUE);
                    shelldos(FALSE,execdata,rcode);
                    cursoron(FALSE);
                    if (sysopfo) then append(sysopf);
                    sl1('[> Returned from "'+description+'" on '+date+' '+time);
                    clrscr;
                    delay(1000);
                    outmodemstring1(systat.hangup);
                    delay(300);
                    i1;
                    wfcm:=FALSE;
                  End;
              'E':begin
                    cursoron(TRUE);
                    doneday:=TRUE;
                    elevel:=value(execdata);
                  End;
            End;
          End;
      End;
  End;

  procedure closemenu;
  begin
    printf('localsec');
    if (systat.localscreensec) then wantout:=FALSE;
    sysopon:=FALSE; sk:=0;
    wfcm:=FALSE;
  End;

  procedure showstats;
  var dfree:array[1..26] of longint;
      s:astr;
      i,ll,x,y:longint;
      abort,next:boolean;

    procedure wl(s1,s2:astr);
    begin
      printacr(#3#3+mln(s1,20)+':'+#3#5+s2,abort,next);
    End;

  begin
    for i:=1 to 26 do dfree[i]:=-1;
    reset(ulf); seek(ulf,0);
    for i:=0 to filesize(ulf)-1 do begin
      read(ulf,memuboard);
      x:=exdrv(memuboard.dlpath);
      dfree[x]:=1;
    End;
    close(ulf);
    x:=0;
    for i:=3 to 26 do if (dfree[i]<>-1) then inc(x);
    if (x<>0) then for i:=1 to 2 do dfree[i]:=-1;
    for i:=1 to 26 do
      if (dfree[i]=1) then dfree[i]:=freek(i);

    abort:=FALSE; next:=FALSE;

    with systat do begin
      wl('System is',aonoff(closedsystem,
                     'Rejecting new users','Accepting new users'));
      wl('                                                    ',' ');
      s:='';
      if (localsec) then s:='Local security';
      if (localscreensec) then
        if (s='') then s:='Local screen security' else s:=s+' + Screen security';
      if (s='') then s:='None';
      wl('Security features',s);
      wl('Global trapping',aonoff(globaltrap,#3#0+'*ON*','Off'));
      wl('Number of callers',cstr(callernum));
      wl('Number of users',cstr(numusers-1));
      wl('Active today',sqoutsp(ctp(todayzlog.active,1440))+' ('+cstr(todayzlog.calls)+' calls)');
      s:='';
      if (todayzlog.pubpost<>0) then begin
        s:=cstr(todayzlog.pubpost)+' public post';
        if (todayzlog.pubpost<>1) then s:=s+'s';
      End;
      if (todayzlog.privpost<>0) then begin
        if (s<>'') then s:=s+', ';
        s:=s+cstr(todayzlog.privpost)+' private mail';
      End;
      if (todayzlog.fback<>0) then begin
        if (s<>'') then s:=s+', ';
        s:=s+cstr(todayzlog.fback)+' feedback';
      End;
      wl('Mail activity',s);
      wl('New users today',cstr(todayzlog.newusers));
      wl('SysOp is',aonoff(sysop,'Available','Not here'));
      wl('Space req. for ULs',cstr(minspaceforupload)+'k');
      wl('Space req. for posts',cstr(minspaceforpost)+'k');
      for i:=1 to 26 do
        if (dfree[i]<>-1) then begin
          x:=dfree[i]; y:=disksize(i); y:=y div 1024;
          s:=cstrl(x)+'k of '+cstrl(y)+'k';
          if (x<minspaceforupload) then s:=#3#8+s;
          if (x<minspaceforpost) then s:=#3#8+'*** '+s;
          wl('Disk space on '+chr(i+64),s);
        End;
      wl('Overlay read from',aonoff(overlayinems,'EMS','Disk'));
      nl;
    End;
  End;

  procedure Mbat(i:integer);
  var
   wind:windowrec;
   s:string;
   t:real;
  xx,yy,z,ret:integer;

  begin
    xx:=wherex; yy:=wherey; z:=textattr;
    getdir(0,s);
    chdir(start_dir);
    MyIo.savescreen(wind,1,1,80,25);
    t:=timer;
    shelldos(FALSE,'Mbat'+chr(i+48),ret);
    getdatetime(tim);
    com_flush_rx;
    freetime:=freetime+timer-t;
    removewindow(wind);
    chdir(s);
    gotoxy(xx,yy); textattr:=z;
  End;

begin
  ChkCom := False;
  if (not systat.localsec) then sysopon:=TRUE;
  getdatetime(lastkeypress); blankmenunow:=FALSE;
  wantout:=not systat.localscreensec;
  sk:=0; duh:=0; duh2:=0; txt:=0; txt1:=0; txt2:=0;
  nogoodcmd:=FALSE;
  optimize_mail;
  wfcmdefine;
  wfcmenu1(C);
  wfcm:=TRUE;
  iport;
    if (wanthangup) and (Not LocalIOOnly) then
  begin
    hangupphone;
    wanthangup:=FALSE;
  End;
  term_ready(TRUE);
  i1;
  assign(lcallf,systat.gfilepath+'laston.dat');
  {$I-} reset(lcallf); {$I+}
  if (ioresult=0) then begin
    lcall.callernum:=-1; i:=0;
    seek(lcallf,0);
    while ((i<10) and (lcall.callernum=-1)) do begin
      read(lcallf,lcall);
      inc(i);
    End;
    lcaller:=lcall.name+' #'+cstr(lcall.number);
    close(lcallf);
  end else
    lcaller:='No one.';

  tdoneafternext:=doneafternext;
  if (not systat.localsec) then sysopon:=TRUE;
  repeat
    if (beepend) then wfcmessage:='Phone off hook - paging System Operator';
    if (tdoneafternext) then wfcmessage:='Not answering any more calls.';
    if (not wfcm) then
    begin
      wfcmenu1(c);
      wfcm:=TRUE;
    End;
    if (daynum(date)<>ldate) then
      if (daynum(date)-ldate)=1 then inc(ldate)
      else begin
        clrscr;
        star('Date corrupted.');
        halt(1);
      End;
    randomize;
    incom:=FALSE; outcom:=FALSE;fastlogon:=FALSE;
    hangup:=FALSE; hungup:=FALSE; macok:=TRUE; cfo:=FALSE;
    spd:='KB'; c:=#0; ChkCom:=FALSE; freetime:=0.0; extratime:=0.0; choptime:=0.0;
    sdc;
    lil:=0; cursoron(FALSE);
    textbackground(0);    tc(3);

    if ((not blankmenunow) and (systat.wfcblanktime>0)) then
    begin
      getdatetime(dt);                { This is were we check the screen }
      timediff(ddt,lastkeypress,dt);  { blanker stuff.... }
      if (ddt.min>=systat.wfcblanktime) then
      begin
        blankmenunow:=TRUE;
        Rmwin;
        ClrScr;
      End;
    End;
    if (ltime<>time) then
    begin
      ltime:=time;
      inc(sk);
      if (timer-lastinit>systat.nocallinittime*60) then begin
        lastinit:=timer;
        if (not phoneoffhook) then i1;
      End;
    End;
    rr:=timer;
    if (rr-lactive<0.0) then rr:=rr+(24.0*60*60);
    rr:=rr-lactive;

    if (sysopon) then
    begin
      if (not blankmenunow) then
   begin
    gotoxy(25,21);
        write('Date        > '+Date);
    gotoXy(25,22);
        write('Time        > '+time);
    gotoxy(25,23);
        write('Last Caller > '+lcaller);
  End else
  Begin
{
     Randomize;
     GrowMkwin(Random(79),Random(24),Random(79),Random(24),
               Random(16),Random(16),Random(9));
     Window(1,1,80,25);
     Clrscr;
}
   End;
  End;

    if (sk=30) and (systat.localsec) then closemenu;
    if (nightly) or (numevents>=1) then chkevents;
    gotoxy(2,25); clreol;

    if (wfcmessage<>'') then
    begin
      textcolor(12); write(' '); textcolor(14); write(wfcmessage);
      textcolor(12); write(' ');
    End;
    if (beepend) then beephim;
    if (tdoneafternext) then
    begin
      takeoffhook;
     { elevel:=exitnormal; }
      hangup:=TRUE;
      doneday:=TRUE;
      clrscr;
    End;

    if (answerbaud>2) then
    begin
      c:='A';
      ChkCom:=TRUE;
    End;


    if (answerbaud=0) then c:=inkey;
    if (c<>#0) then
    begin
      if (blankmenunow) then
      begin
        blankmenunow:=FALSE;
        wfcmenu1(c);
        getdatetime(lastkeypress);
      End;

      wfcm:=FALSE;
      cursoron(TRUE); gotoxy(2,24); tc(3);
      c:=upcase(c);

      if (not sysopon) then
        case c of
          'Q':begin
               { elevel:=exitnormal; }
                hangup:=TRUE;
                doneday:=TRUE;
              End;
          ' ':begin
                sysopon:=cpw;
                if (sysopon) then wantout:=TRUE;
                c:=#1;
              End;
          else
              nogoodcmd:=TRUE;
        end else

      begin
       sk:=0;
       textattr:=thisuser.cols[color in thisuser.ac][1];
       curco:=thisuser.cols[color in thisuser.ac][1];
        case c of
          ^C:    Closemenu;
          'H','+':
              begin
                i1;
                nogoodcmd:=TRUE;
              End;
          '!':begin
                clrscr;
                minidos;
              End;
          '0'..'9':MBat(ord(c)-48);
          'A':ChkCom:=TRUE;

          'B':if cpw then MsgEditMenu;

          'C','/':begin clrscr; printfile(systat.gfilepath+'user.log'); pausescr; End;
          'D':SysopShell(FALSE);
          'E':if cpw then eventedit;
          'F':if cpw then dlboardedit;
          'G':if cpw then tfileedit;
          'K':begin
                clrscr;
                if (pynq('Do you REALLY want to pack the message bases? '))
                  then
                  { *********************** }
                  prompt(#3#14+'Not implemented yet...');
                  { doshowpackbases;        }
                  { *********************** }

              End;
          'L':begin
                clrscr;
                showlogs;
                nl; pausescr;
              End;
          'N':if cpw then tedit1;
          'O':begin
                if (not phoneoffhook) then takeoffhook else i1;
                nogoodcmd:=TRUE;
              End;
  'P':if cpw then ChangeSystem;

  'V':if Cpw then
          Begin
           if (exist('sConfig.exe')) then
           begin
                clrscr; textcolor(14); write('Running SCONFIG.EXE ....');
                writeln;
                sl1('');
                sl1(' Ran SCONFIG '+date+' '+time);
                shelldos(FALSE,'SCONFIG.EXE',rcode);
                sl1(' Returned from "SCONFIG.EXE" at '+date+' '+time);
                chdir(start_dir);
                clrscr;
                i1;
              End;
           End;
          'Q':begin { elevel:=exitnormal;} hangup:=TRUE; doneday:=TRUE; End;
          'S':begin
                clrscr;
                showstats;
                pausescr;
              End;
          'U':if cpw then begin clrscr; uedit1; End;
          'X':if cpw then exproedit;
          'Z':begin clrscr; zlog; pausescr; End;
          '#':if cpw then menu_edit;
          ' ':begin
                oldphoneoffhook:=phoneoffhook;
                if (systat.offhooklocallogon) then takeoffhook;
                gotoxy(3,24);
              cwrite(#3#3+'Log on? ('+#3#11+'Y'+#3#3+'/'+#3#11+'N'+
                     #3#3+'-'+#3#11+'F'+#3#3+'ast) : ');
                rl2:=timer;
                while (not keypressed) and (abs(timer-rl2)<30.0) do;
                if (keypressed) then c:=readkey else c:='N';
                c:=upcase(c); writeln(c);
                case c of
                  'F':begin
                        fastlogon:=TRUE;
                        c:=' ';
                      End;
                  'Y':c:=' ';
                else
                      c:='@';
                End;
                if (c='@') then
                begin
                  gotoxy(2,24); clreol;
                  if ((systat.offhooklocallogon) and (not oldphoneoffhook)) then
                     i1;
                  nogoodcmd:=TRUE;
                End;
              End;
          else
              nogoodcmd:=TRUE;
        End;
        if (not nogoodcmd) then getdatetime(lastkeypress);
      End;
      if (not nogoodcmd) then
      begin
        if (c<>'A') then begin
          curco:=7; sdc;
          window(1,1,80,25); clrscr;
          com_flush_rx;
        End;
        if ((sysopon) and (c<>#1)) then lactive:=timer;
      end else begin
        nogoodcmd:=FALSE;
        wfcm:=TRUE;
      End;
    End;
    if (c<>' ') then c:=#0;
    if (not com_rx_empty) then ChkCom:=TRUE;
    if ((c<>#0) or (not com_rx_empty) or (ChkCom)) then
    begin
      spdarq:=FALSE;
      if ((not Phoneoffhook) and (not LocalIoOnly)) then
      begin
       if ChkCom then GetCallerA(C1,ChkCom);
        if (not incom) and ((spd='KB') and (c<>' ')) then
        begin
          wfcm:=FALSE;
          i1;
          if (quitafterdone) then
          begin
           { elevel:=exitnormal;}
            hangup:=TRUE;
            doneday:=TRUE;
          End;
        End;
      End;
    End;
  until ((incom) or (c=' ') or (doneday));

  etoday:=0; ptoday:=0; chatt:=0; shutupchatcall:=FALSE;
  flistverb:=TRUE; badfpath:=FALSE;

  if (not doneday) then
  begin
    window(1,1,80,25);
    clrscr;
    if not localIoOnly then write(' Incoming call at '+spd);
    if (spdarq) then writeln(' ARQ') else writeln;
  End;
  curco:=7; sdc;
  if (incom) then
  begin
    com_flush_rx; term_ready(TRUE);
    outcom:=TRUE;
    if (not systat.LockedPort) then
      InitFossil(systat.comport,Value(Spd));
      {com_set_speed(value(spd));}
  end else begin
    term_ready(FALSE);
    incom:=FALSE; outcom:=FALSE;
    wfcm:=FALSE;
  End;
  getdatetime(timeon);
  com_flush_rx;
  lil:=0;
  thisuser.ac:=thisuser.ac-[ansi];
  reset(uf);
  if (filesize(uf)>=2) then begin
    seek(uf,0); read(uf,u);
    thisuser.cols:=u.cols;
  End;
  close(uf);
  curco:=$07;
  checkit:=TRUE;
  beepend:=FALSE;
  inwfcmenu:=FALSE;

  mtcolors:=FALSE;

  if (systat.localscreensec) then wantout:=FALSE;
  if (spd='KB') and (not wantout) then wantout:=TRUE;
  if (wantout) then cursoron(TRUE);

  if (spd<>'KB') then
    case (value(spd) div 100) of
      3:inc(systat.todayzlog.userbaud[0]);
      12:inc(systat.todayzlog.userbaud[1]);
      24:inc(systat.todayzlog.userbaud[2]);
      48:inc(systat.todayzlog.userbaud[3]);
      96:inc(systat.todayzlog.userbaud[4]);
    End;
  SaveSystat(Start_Dir);
  for i:=1 to 4 do macros.macro[i]:='';
End;

end.
