(*****************************************************************************)
(*>                                                                         <*)
(*>  SYSOP2  .PAS -  Written by Eric Oman                                   <*)
(*>                                                                         <*)
(*>  SysOp functions: System Configuration Editor.                          <*)
(*>                                                                         <*)
(*>                                                                         <*)
(*****************************************************************************)
{$A+,B+,D-,E+,F+,I+,L+,N-,O+,R-,S+,V-}
unit sysmain;

interface

uses
  OPcrt, dos, overlay,
  FBasedit,FAreaCfg,NewUCfg,
  SysMisc,StrCfg,SysColor,RatioCfg,XEditor,common;

procedure ChangeSystem;

implementation
Uses FilesAcc;

const
  aresure='Are you sure this is what you wanted [y/N] ';

function wantit:boolean;
begin
  nl; wantit:=pynq(aresure);
end;

procedure ChangeSystem;
var c:char;
    done,abort,next,savepause:boolean;
begin
  repeat
    done:=FALSE;
    cls;
    sprint(#3#5+'System configuration:');
    nl;
    abort:=FALSE; next:=FALSE; savepause:=FALSE;
   nl;nl;
    printacr(#3#5+'F'+#3#3+')ile section configuration',abort,next);
    printacr(#3#5+'N'+#3#3+')ew user and Auto-Validation settings',abort,next);
    printacr(#3#5+'M'+#3#3+')iscellaneous configuration',abort,next);
    printacr(#3#5+'E'+#3#3+')xternal Editor SetUP ',abort,next);
    printacr(#3#5+'S'+#3#3+')tring configuration',abort,next);
    printacr(#3#5+'D'+#3#3+')efault colors',abort,next);
    nl;
    printacr(#3#5+'1'+#3#3+') Time limitations',abort,next);
    printacr(#3#5+'2'+#3#3+') Call allowance/day',abort,next);
    printacr(#3#5+'3'+#3#3+') UL/DL # files ratio',abort,next);
    printacr(#3#5+'4'+#3#3+') UL/DL K-bytes ratio',abort,next);
    printacr(#3#5+'5'+#3#3+') Post/Call ratio',abort,next);
    nl;
    prt('Selection; (Q)uit : ');
    onek(c,'QFNMESD12345'^M);
    case c of
      'F':pofilesconfig;
      'N':ponewauto;
      'M':pomisc1;
      'E':ChangeEditors;
      'S':postring;
      'D':pocolors;
      '1':getsecrange('Time limitations',systat.timeallow);
      '2':getsecrange('Call allowance per day',systat.callallow);
      '3':getsecrange('UL/DL # files ratio (# files can DL per UL)',systat.dlratio);
      '4':getsecrange('UL/DL K-bytes ratio (#k can DL per 1k UL)',systat.dlkratio);
      '5':getsecrange('Post/Call ratio (# 1/10''s of calls per public post to have AR flag)',systat.postratio);
      'Q':done:=TRUE;
    end;
  until ((done) or (hangup));
  Savesystat(Start_Dir);
  if (savepause) then thisuser.ac:=thisuser.ac+[pause];
end;

end.
