
(*****************************************************************************)
(*>                                                                         <*)
(*>  NEWUSERS.PAS -  Written by Eric Oman                                   <*)
(*>                                                                         <*)
(*>Logon functions -- New users.                                          <*)
(*>                                                                         <*)
(*>                                                                         <*)
(*****************************************************************************)
{$A+,B+,D-,E+,F+,I+,L+,N-,O+,R-,S+,V-}
unit newusers;

interface

uses
  OPcrt, dos, overlay, misc2, misc3, misc4,  miscx,
  cuser,  doors,  archive1,  menus, Date_Tim,  common;

procedure newuser;
procedure newuserinit(nam:astr);

implementation

Uses
  Msg1,Msg2;
var
  newusername:astr;

procedure p1;
var c:char;
    tries,i,ii,t:integer;
    s,s1,s2:astr;
    Atype,Pw:astr;
    done,abort,next,choseansi,chosecolor:boolean;

  procedure showstuff;
  begin
    nl; nl; printf('newuser1');

    if (systat.newuserpw<>'') then
    begin
      tries:=0; pw:='';
      while ((pw<>systat.newuserpw) and
            (tries<systat.maxlogontries) and (not hangup)) do begin
        prt('Newuser password : '); echo:=FALSE; input(pw,20); echo:=TRUE;
        if ((systat.newuserpw<>pw) and (pw<>'')) then begin
          sl1(#3#8+'>>'+#3#1+' Illegal newuser password: "'+pw+'"');
          inc(tries);
        end;
      end;
    if (Tries>=Systat.MaxLogonTries) then
      begin
        printf('NoNewUsr');
        hangup:=TRUE;
      end;
    end;
  end;

  procedure doitall;
  type neworderrec=array[1..18] of integer;
  const neworder:neworderrec=(7,10,23,1,4,14,8,12,2,5,6,13,3,26,11,24,9,-1);
  var i:integer;
      c:char;
  begin
    showstuff;
    if (newusername<>'') then
    begin
      thisuser.name:=newusername;
      newusername:='';
      i:=2;
    end else
      i:=1;
    repeat
      cstuff(neworder[i],1,thisuser);
      inc(i);
    until ((neworder[i]=-1) or (hangup));
  end;

  procedure dc(var abort:boolean; c1,c2:char; n1,n2,v1,v2:astr);
  begin
    printacr(#3#9+c1+#3#0+') '+
             #3#4+mln(n1,11)+#3#0+' - '+#3#5+Mln(V1,20)+'  '
             +#3#0+'('#3#9+c2+#3#0+') '+
             #3#4+mln(n2,11)+#3#0+' - '+#3#5+Mln(V2,20),abort,next);
  end;

begin
  t:=0;
  doitall;
  Nl;
  if (not hangup) then
  if not (PynQ('Was all the information entered correctly? [y/N] ')) then
    repeat
      done:=FALSE;
      cls;
      abort:=FALSE; next:=FALSE;
      printacr(#3#5+'Change User Information Menu',abort,next);
      nl;
      if (ansi in thisuser.ac) then
      begin
        atype:='Enabled';
        if (color in thisuser.ac) then atype:=atype+' w/ color'
        else atype:=atype+' w/o color';
      end else
        atype:='Disabled';
      with thisuser do
      begin
        dc(abort,'A','B','Alias name','RealName',name,RealName);
        dc(abort,'C','D','Phone # ','Sex (M/F)',Ph,Sex);
        dc(abort,'E','F','BDay (Age)','City/State',Bday+' ('+cstr(ageuser(bday))+')',CityState);
        dc(abort,'G','H','Address ','ZipCode',Street,ZipCode);
        dc(abort,'I','J','Info1','Info2',info1,Info2);
        dc(abort,'K','L','Ansi Choice','Screen Size',Atype, cstr(linelen)+'x'+cstr(pagelen));
        dc(abort,'M','N','Password ','Ed Choice',pw,Cstr(EditorChoice));
      end;
      nl;
      prt('Select; Q)uit when finished :');
      onek(c,'QABCDEFGHIJKLMN');
      if (c<>'Q') then
      Begin
       Case C of
         'A':II :=7;  {Alias name }
         'B':II :=10; {Real Name }
         'C':II :=8;  {Phone number }
         'D':II :=12; {Sex}
         'E':II :=2;  {Age}
         'F':II :=4;  {Citystate}
         'G':II :=1;  {Address}
         'H':II :=14; {ZipCode}
         'I':II :=6;  {Info1}
         'J':II :=13; {Info2}
         'K':II :=3;  {Ansi Select}
         'L':II :=11; {Screen Size}
         'M':II :=9;  {Password}
         'N':ii:=26;  {External Editor Choice }
        ELSE  II := 32500;
       End;
       if (II <= 50) then
          cstuff(II,1,thisuser);
      end else done:=TRUE;
    until ((done) or (hangup)) else
    Done := TRUE;
end;

procedure p2;
var user:userrec;
    pw:string;
    tries,i,j:integer;
    c:char;
begin
  if (not hangup) then
  begin
    nl; prompt('Saving User Record ... ');

    reset(uf);
    j:=0;
    for i:=1 to filesize(uf)-1 do
    begin
      seek(uf,i); read(uf,user);
      if ((user.deleted) and (j=0)) then j:=i;
    end;
    if (j<>0) then usernum:=j else usernum:=filesize(uf);

    with thisuser do
    begin
      deleted:=FALSE; firston:=date; laston:=date;
      loggedon:=0; msgpost:=0; emailsent:=0; feedback:=0; ontoday:=0;
      illegal:=0; forusr:=0;
      downloads:=0; uploads:=0; dk:=0; uk:=0;
      linelen:=80; pagelen:=25; ttimeon:=0; note:='';
      ClsMsg := 3;
      lastmsg:=1; lastfil:=1; credit:=0; timebank:=0;

      readinzscan; { load old / create new zscan.dat record }

{     Msg Pointers }
     LastReadPtr := 0;
      with zscanr do
      begin
        fzscan:=[];
        for i:=0 to maxuboards do fzscan:=fzscan+[i];
      end;

      savezscanr;
      trapactivity:=FALSE; trapseperate:=FALSE;
      timebankadd:=0;
      mpointer:=-1;
      chatauto:=FALSE; chatseperate:=FALSE;
      slogseperate:=FALSE;

      flistopt:=1;
      avadjust:=0;

      reset(uf); seek(uf,0); read(uf,user); close(uf);
      cols:=user.cols;
      sl:=systat.newsl; dsl:=systat.newdsl; realsl:=sl; realdsl:=dsl;
      filepoints:=systat.newfp;

      ar:=systat.newar;
      tltoday:=systat.timeallow[sl];
    end;

    reset(uf);
    seek(uf,usernum);
    write(uf,thisuser);
    close(uf);

    isr(thisuser.name,usernum);
    inittrapfile;
    sprint(#3#3+'Saved.');
   nl;
    sprint(#3#5+ThisUser.Name+#3#3+', your user number is '+#3#5+Cstr(UserNum)+#3#3+' please remember it');
    sprint(#3#3+'for a faster login.');
   nl;
   pausescr;

    useron:=TRUE;
    window(1,1,80,25);
    clrscr;
    schangewindow(not cwindowon,systat.curwindow);
    cls;

    if ((exist(systat.afilepath+'newuser.inf')) or
        (exist(systat.gfilepath+'newuser.inf'))) then
        readq('newuser',0);
        topscr;
      nl;
  end;
end;

procedure newuser;
var i:integer;
begin
  sl1(#3#8+' ***'+#3#3+' NewUser'+#3#8+' ***');
  if (systat.numusers>=99999) then begin
    sl1(#3#7+' [*] Maximum user count has been reached.');
    hangup:=TRUE;
  end else
  begin

    p1;
    p2;

  if (systat.newapp<>-1) then  { This is the "New User Msg" Stuff }
    begin
      ActualLoadMsgBoard(Brd,Systat.EmailBase,TRUE);
      printf('NewApp');          {    /--- The "|" is required to force  --- }
      EmailUser(Cstr(Systat.NewApp),'|Hello, I am a new User!'); { NO ABORT! }
      sysoplog(#3#5+'Sent new user message to '+#3#0+cstr(systat.newapp)+#3#5+'!');
    end;

    inc(systat.todayzlog.newusers);
    wasnewuser:=TRUE;
  End;
  useron:=TRUE;
end;

procedure newuserinit(nam:astr);
var s:astr;
begin
  newusername:=nam;
  clrscr;

  if (systat.closedsystem) then
  begin
    printf('NoNewUsr');
     hangup:=TRUE;
  end else
  begin
    with thisuser do
    begin
      name:='NEW USER';
      trapactivity:=FALSE;
      trapseperate:=FALSE;
    end;
  end;
end;

end.
