{ MsgEdit.Pas Created by Mike Wilson 6/29/1992 For ShadowBBS                }
{ This unit contains editing routines for the MsgBase                       }
{                                                                           }
{                                                                           }
{                                                                           }
{$A+,B+,D-,E+,F+,I+,L+,N-,O+,R-,S+,V-}
Unit MsgEdit;

Interface

Uses
    Dos,Common,OverLay,Msg1,file0;
Var
 bf : File of MsgBoardsRecord;

Procedure MsgEditMenu;
Function Basetype : String;   { MsgBaseType    }
Function Atypes : String;     { ANonTypes      }
Function NetworkFlags : String;{ NetWork Flags }
Procedure ParseAddress(Str      : String;
                       Var Zone : Integer;
                       Var Net  : Integer;
                       Var Node : Integer;
                       Var Point: Integer;
                       Var Domain : String);

Implementation

Procedure FixMsgScanBasesDel(X: Integer);
Var
 F    : File of LastPtrRecord;
 Last : LastPtrRecord;
 I    : Word;
Begin
 assign(F,systat.gfilepath+'LASTREAD.DAT');
 {$i-} reset(F); {$i+}
   If (IoResult <> 0) then Exit;
   while not Eof(F) do
    Begin
      Read(F,Last);
      Last.Scan[MaxMsgBoards] := TRUE;
      Last.Ptr[MaxMsgBoards]  := -1;
      for i := X to MaxMsgBoards-1 do
       Begin
             Last.Ptr[i] := Last.Ptr[i+1];
             Last.Scan[i]:= Last.Scan[i+1];
       End; {for}
             Seek(F,FilePos(F)-1);
             Write(F,Last);
    End; {while}
    Close(f);
End;

Procedure FixMsgScanBasesIns(X: Integer);
Var
 F    : File of LastPtrRecord;
 Last : LastPtrRecord;
 I    : Word;
Begin
 assign(F,systat.gfilepath+'LASTREAD.DAT');
 {$i-} reset(F); {$i+}
   If (IoResult <> 0) then Exit;
   while not Eof(F) do
    Begin
      Read(F,Last);
         Last.Scan[MaxMsgBoards] := Last.Scan[MaxMsgBoards-1];
         Last.Ptr[MaxMsgBoards]  := Last.Ptr[MaxMsgBoards-1];
      for i := MaxMsgBoards-1 Downto X-1 do {Ins blank}
       Begin
             Last.Ptr[i]  := Last.Ptr[i-1];
             Last.Scan[i] := Last.Scan[i-1];
       End; {for}
         Last.Scan[X] := TRUE;
         Last.Ptr[X]  := -1;
             Seek(F,FilePos(F)-1);
             Write(F,Last);
      End; {while}
    Close(f);
End;

Procedure FixMsgScanBasesMove(Movedbase: Integer;NewLoc: Integer);
Var
 F         : File of LastPtrRecord;
 Last      : LastPtrRecord;
 StoreLast : LastPtrRecord;
 Tmp,
 I         : Word;

Begin
 assign(F,systat.gfilepath+'LASTREAD.DAT');
 {$i-} reset(F); {$i+}
   If (IoResult <> 0) then Exit;
     While Not Eof(F) do
     Begin
       Read(F,Last);
         StoreLast := Last;

      Last.Scan[MaxMsgBoards] := Last.Scan[MaxMsgBoards-1];
      Last.Ptr[MaxMsgBoards]  := Last.Ptr[MaxMsgBoards-1 ];
      for i := MaxMsgBoards-1 Downto NewLoc-1 do {Ins blank}
       Begin
             Last.Ptr[i]  := Last.Ptr[i-1];
             Last.Scan[i] := Last.Scan[i-1];
       End; {for}

      Last.Scan[MaxMsgBoards] := TRUE;   { Delete Old Location }
      Last.Ptr[MaxMsgBoards]  := -1;
    If (MovedBase > Newloc) then
      Tmp := MovedBase +1 else Tmp := MovedBase;

      for i := Tmp to MaxMsgBoards-1 do
       Begin
             Last.Ptr[i] := Last.Ptr[i+1];
             Last.Scan[i]:= Last.Scan[i+1];
       End;


     Last.Ptr[NewLoc] := StoreLast.Ptr[MovedBase];
     Last.Scan[NewLoc]:= StoreLast.Scan[MovedBase];
     Seek(F,FilePos(F)-1);
     Write(F,Last);
    End; {do}
       Close(f);
End;

Procedure DeleteMsgBase(x:integer);     { Delete MsgBase }
  var i,j:integer;
      fn : String;
      L  : File of LastPtrRecord;

  begin
    if ((x>=1) and (x<=Maxboards)) then
  begin
    Fn := systat.gfilepath+'msgbrds.dat';
    assign(bf,fn);
 {$I-}   reset(bf); {$I+}
         If (Ioresult <> 0) and (IoResult <> 162) then
            rewrite(bf);

        Seek(Bf,X);
        Read(Bf,Brd);

        if PynQ('Delete msgbase files in '+Brd.Path+' ? [y/N]') then
           Begin
            Assign(L,brd.path+brd.filename+'.LRP');
            {$I-} reset(L); {$I+}
            If (IoResult = 0) then
             Begin
              Close(L);
              Erase(L);
             End;

            Assign(MsgTxtFile,brd.path+brd.filename+'.TXT');
            {$I-} reset(msgTxtFile); {$I+}
            If (IoResult = 0) then
             Begin
              Close(MsgTxtFile);
              Erase(MsgTxtFile);
             End;
            Assign(MsgHdrFile,brd.path+brd.filename+'.HDR');
            {$I-} reset(MsgHdrFile); {$I+}
            If (IoResult = 0) then
             Begin
              Close(MsgHdrFile);
              Erase(MsgHdrFile);
             End;
            End;

      i:=x;
      if (i>=1) and (i<=filesize(bf)-2) then
        for j:=i to filesize(bf)-2 do
        begin
          seek(bf,j+1);
           read(bf,Brd);
         seek(bf,j);
           write(bf,Brd);
        end;
      seek(bf,filesize(bf)-1);
       truncate(bf);
      dec(MaxBoards);
      Close(Bf);
      FixMsgScanBasesDel(X);     { LASTREAD.DAT is fixed here }
    end;
End;


Procedure InsertMsgBase(x:integer);      { MessageBase Insert }
 Var i,j:integer;
    fn : string;
  begin
    Fn := systat.gfilepath+'msgbrds.dat';
    assign(bf,fn);
 {$I-}   reset(bf); {$I+}
         If (Ioresult <> 0) and (IoResult <> 162) then
            rewrite(bf);
    i:=x;
    if ((i>=1) and (i<=filesize(bf)) and (MaxBoards<MaxMsgBoards)) then
    begin
      for j:=filesize(bf)-1 downto i do
      begin
        seek(bf,j); read(bf,Brd);
        Write(bf,Brd); { ...to next record }
      end;
      with Brd do
      begin
       Name         :='EMPTY ';
       Path         :='';
       FileName     :='NEWBASE';
       TagName      := '';
       Password     := '';
       MsgBaseType  := [MsgUnHidden];
       AnonType     := [];
       Acs          :='s10';
       FirstMsg     := 0;
       LastMsg      := 0;
       TotalMsgs    := 1;
       KillRecieved :=TRUE;
       OldMail      :=90;
       MaxMessages  :=200;
       DlPtr        :=-1;
      With NetWork do
      Begin
      AKA := 1;
    if (fidoR.origin<>'') then
        origin:=fidor.origin else
          origin:=copy(stripcolor(systat.bbsname),1,50);
       text_color:=fidor.text_color;
       quote_color:=fidor.quote_color;
       tear_color:=fidor.tear_color;
       origin_color:=fidor.origin_color;
       skludge:=(fidor.skludge);
       sseenby:=(fidor.sseenby);
      sorigin:=(fidor.sorigin);
      scenter:=False;            {(fidor.scenter);}
      sbox:=False;               {(fidor.sbox);   }
      mcenter:=False;            {(fidor.mcenter);}
      addtear:=(fidor.addtear);
      echopath:='';            { default EchoMail path }
      grouppath:='';           { default GroupMail path }
    End;                       {NetWork Do }
   End;                        {Brd Do }
  seek(bf,i); write(bf,Brd);

   inc(MaxBoards);
   Close(bf);
   FixMsgScanBasesIns(X);
  end;
end;


Procedure MoveBase(x,y:integer);    { Move Base from X TO Y }
  var tempboard:MsgBoardsRecord;
      i,j:integer;
      Fn : String;
  begin
    Fn := systat.gfilepath+'msgbrds.dat';
    assign(bf,fn);
 {$I-}   reset(bf); {$I+}
         If (Ioresult <> 0) and (IoResult <> 162) then
            rewrite(bf);
    seek(bf,x); read(bf,tempboard);

    i:=x;
    if (x>y) then
       j:=-1 else
       j:=1;
    while (i<>y) do
    begin
      if (i+j<filesize(bf)) then
      begin
        seek(bf,i+j);
         read(bf,brd);
        seek(bf,i);
         write(bf,brd);
      end;
      inc(i,j);
    end;
    seek(bf,y);
     write(bf,tempboard);
    Close(bf);
  FixMsgScanBasesMove(X,Y)
End;

Procedure AskMoveBase;
  var i,j:integer;
  begin
    prt('Move which message base? (1-'+cstr(MaxBoards)+') : ');
    inu(i);
    if ((not badini) and (i>=1) and (i<=Maxboards)) then
    begin
      prt('Move to which position? (1-'+cstr(Maxboards)+') : ');
      inu(j);
      if ((not badini) and (j>=1) and (j<=MaxBoards+1) and
          (j<>i)) then
       begin
        nl;
        MoveBase(i,j);
      end;
    end;
End;

Procedure  AskDeleteBase;
var i : integer;

Begin
 prt('Delete which message base? (1-'+Cstrl(MaxBoards)+') : ');
 inu(i);
 if ((not badini) and (i >=1) and (i<=MaxBoards)) then
     DeleteMsgBase(i);
End;

Procedure  AskInsertBase;
var i : integer;

Begin
 prt('Insert MsgBase where? (1-'+Cstrl(MaxBoards+1)+') : ');
 inu(i);
 if ((not badini) and (i >=1) and (i<=MaxBoards+1)) then
     InsertMsgBase(i);
End;


Function BAsetype : String;
Var
 Str : String;
Begin
     Str := '';
  With Brd do
  Begin
     If (EchoBAse in MsgBaseType) then Str    := Str   +'Echo ';
     If (NetBase in MsgBaseType) then    Str  := Str +'Net ';
     if (MsgHidden in MsgBaseType)  then Str  := Str +'Hidden ';
     If (MsgUnHidden in MsgBaseType) then Str := Str +'UnHidden ';
     If (PrivateBAse in MsgBaseType) then Str := Str +'Private ';
     if (PublicBase in MsgBaseType) then Str  := Str  +'Public ';
     if (PubPrivBase in MsgBaseType) then Str := Str +'Pub/Priv ';
  End;               { Do }
 BaseType := Str;
End;

Function Atypes : String;
Var
   Str : String;
Begin
 Str := '';
  With Brd do
  Begin
   If (UseAlias in AnonType) then Str := Str   + 'Users ';
   If (UserSelect in AnonType) then Str := Str + 'UserSelect ';
   If (DearAbby in AnonType) then Str := Str   + 'DearAbby ';
   If (ForceAlias in ANonType) then Str := Str +'ForceAlias ';
   if (RealNameOnly in AnonType) then Str := Str+'RealNameOnly';
  End; {do}
 ATypes := Str;
End;

Procedure getbrdspec(var s:string);
Begin
    with Brd do
      s:=fexpand(systat.msgpath+filename+'.HDR');
End;


Procedure SetHiddenflags;
Begin
     with Brd do
     Begin
     if PynQ('Make MsgBase Hidden ? [y/N] ') then
     Begin
      If (MsgUnHidden in MsgBAseType) then
         MsgBaseType := MsgBaseType-[MsgUnHidden];
         MsgBaseType := MsgBAseType+[MsgHidden]
        end else
      Begin
      If MsgHidden in MsgBaseType then
         MsgBaseType := MsgBaseType-[MsgHidden];
         MsgBaseType := MsgBaseType+[MsgUnHidden];
      End;
     nl;
{     if (Not (NetBase in MsgBaseType)) and
        (Not (EchoBase in MsgBaseType)) then
}

     If PynQ('Is Message Base Private ? [y/N] ') then
     Begin
      If (PublicBase in MsgBaseType) then
         MsgBaseType := MsgBaseType-[PublicBase];
         MsgBaseType := MsgBAseType+[PrivateBase]
     End else
     Begin
      If (PrivateBase in MsgBaseType) then
         MsgBaseType := MsgBaseType-[PrivateBase];
         MsgBaseType := MsgBAseType+[PublicBase]
     End;

   End;
End;

Procedure MakeEcho;
Begin
 With Brd do
 Begin
  If (NetBase in MsgBaseType) then
     MsgBaseType := MsgBaseType-[NetBase];
     MsgBAseType := MsgBaseType+[EchoBase];
     AnonType := [RealNameOnly];      { Keep It clear }
 End;
 SetHiddenFlags;
End;

Procedure MakeNet;
Begin
 With Brd do
 Begin
  If (EchoBase in MsgBaseType) then MsgBaseType := MsgBaseType-[EchoBAse];
     MsgBAseType := MsgBAseType+[NetBAse];
     AnonType := [RealNameOnly];      { Keep It clear }
 End;
 SetHiddenFlags;
End;

Procedure MakeLocal;
Begin
 With Brd do
 Begin
  if (EchoBase in MsgBaseType) then MsgBAseType := MsgBAseType-[EchoBase];
  If (NetBase in MsgBAseType) then MsgBaseType := MsgBaseType-[NetBase];
 End;
 SetHiddenFlags;
End;

Procedure InColor(msg:string; var i:byte);
Var
 s: String;
  begin
    prompt('Enter new '+msg+' color (0-9) : ');
    mpl(1);
    input(s,1);
    if ((s<>'') and (s[1] in ['0'..'9'])) then
     i:=ord(s[1])-48;
  end;


Function NetworkFlags : String;
Var
   Str : String;
Begin
 Str := '';
 With Brd do
   With Network Do
     Begin
      if Skludge then str := str+'K';
      if Sorigin then str := str+'O';
                       {if scenter then str := str+'C';}
                       {if sbox    then str := str+'B';}
                       {if mcenter then str := str+'M';}
      if addtear then str := str+'T';
      if sseenby then str := str+'S';
  end;
 NetWorkFlags := Str;
End;

Function GoodNum(Str : String;MaxSize : Integer) : Boolean;
Begin
 GoodNum := (Value(Str) <= MaxSize) and (Value(Str) >=1);
End;

Procedure ParseAddress(Str      : String;
                       Var Zone : Integer;
                       Var Net  : Integer;
                       Var Node : Integer;
                       Var Point: Integer;
                       Var Domain : String);
Var
 I : Byte;
Begin
  if (Pos(':',Str) <> 0) AND  (Pos('/',Str) <> 0) then
    Begin
      Zone  := Value(Copy(Str,1,Pos(':',Str)-1));
      Net   := Value(Copy(Str,Pos(':',Str)+1,Pos('/',Str)-Pos(':',Str)-1));
      i := Pos('.',Str);
      if (I = 0) then
         I := Length(Str);
      Node  := Value(Copy(Str,Pos('/',Str)+1,I-Pos('/',Str)-1));
      if (Pos('.',Str) <> 0) then
         Point := Value(Copy(Str,Pos('.',Str)+1,Length(Str))) else
         Point :=0;
      Domain := '';
    End else
    print(' Incorrect format for addressing!');
End;

Function GetNum(Say : String;Len : Byte) : integer;
Var
 Str : String;
Begin
  prt(Say); mpl(Len);
  Input(Str,Len);
 GetNum := Value(Str);
End;

Procedure  EditDownlink(Var D: DownLinkRecord;Rec: Byte);
Var
 Str : String;
Begin
    Sprompt('^2Enter Address (Format X:X/X) :');
    mpl(30); Input(Str,30);
    ParseAddress(Str,D.Addr[Rec].Zone,
       D.Addr[Rec].Net,D.Addr[Rec].Node,D.Addr[Rec].Point,D.Addr[Rec].Domain);
{
    prt('Enter Domain :');Input(Str,50);
    D.Addr[Rec].Domain := Str;
}
End;


Procedure AddDownLink(Var D: DownLinkRecord;Rec : Integer);
Begin
  if (Rec = 1) then
      Rec := 0;
  EditDownLink(D,Rec+1);
End;

Procedure DeleteDownLink(Var D: DownLinkRecord;Rec : Byte;RecUsed : Byte);
Var
 I : integer;
Begin
 If (Rec = RecUsed) then
   Begin
    D.Addr[Rec].Zone   := 0;
    D.Addr[REc].net    := 0;
    D.Addr[REc].Node   := 0;
    D.Addr[REc].Point  := 0;
    D.Addr[REc].Domain :='';
   End Else
   Begin
    for I := Rec to RecUsed do
    begin
     D.Addr[I].Zone   :=D.Addr[i+1].Zone;
     D.Addr[I].net    :=D.Addr[i+1].Net;
     D.Addr[I].Node   :=D.Addr[i+1].Node;
     D.Addr[I].Point  :=D.Addr[i+1].Point;
     D.Addr[I].Domain :=D.Addr[i+1].domain;
    End; { for }
   End;
End;

Procedure DoDownlinks;
Var
 D   : DownLinkRecord;
 I   : Integer;
 Str : String;
 Help,
 Changed,
 Done    : Boolean;

Begin
 help := False;
 done := False;
 With Brd do
 Begin
  Repeat
  if (DlPtr <= -1) then
   Begin
    for I := 1 to MaxDownLinks do
     Begin
       D.Addr[i].Zone   := 0;
       D.Addr[i].Net    := 0;
       D.Addr[i].Node   := 0;
       D.Addr[i].Point  := 0;
       D.Addr[i].Domain := '';
     End; { for }
     Save_DownLinks(D,Brd);
   End; { if -1 }
 Until (HangUp) or (Load_Downlinks(D,Brd));

repeat
 With D do
  begin
   Changed := False;
   I := 1;
   Nl;
  while (Addr[i].Zone <> 0) do
   Begin
    print(mln(Cstr(i),2)+'] '+ GetAddress(Addr[i].Zone,Addr[i].Net,Addr[i].Node,
                                       Addr[i].Point));
    Inc(i);
   End; { while }
    if (Addr[1].Zone = 0) then
         print('No Downlinks defined.');

    Nl;
  if (help) then
   begin
    help := False;
    lcmds(15,3,'Delete Entry','Insert Entry');
    lcmds(15,3,'Quit and save','#Number to Edit');
    nl;
   End;
   sprompt('^3Enter Number to Edit or (?)Help,(Q)uit : ');
     GetInput(Str,'QDI?');
       Case Str[1] of
           '0'..'9' :if (GoodNum(Str,I)) then
                        Begin
                         EditDownlink(D,Value(Str));
                         changed := TRUE;
                        End;
           'Q'      :Done := TRUE;
           'D'      : begin
                       sprompt('Number to Delete : ');mpl(3);
                       Input(Str,3);
                       if GoodNum(Str,I) then
                       Begin
                        DeleteDownLink(D,Value(Str),I);
                        Changed := TRUE;
                       End;
                       End;
           'I'      :if (I < MaxDownlinks) then
                        Begin
                         AddDownLink(D,I);
                         Changed := TRUE;
                        End;
           '?'      :Help := TRUE;

        End; {case }
    if (Changed) then
        Save_DownLinks(D,Brd);
    End; { with d do}
Until (Done) or (hangUp);

 End; { with brd }
End;


Procedure MsgBaseEdit;
 Var
  AskedHelp,Err,Done,Changed : Boolean;
  Ch               : Char;
  s,S1,S2,s3       : String;
  TmpBrd,I         : Integer;
  f                : File;
  SavedBoard       : Word;

Begin
    prt('Begin editing at which? (1-'+cstr(Maxboards)+') : ');
    inu(i);
    if (I>=1) and (I <= MaxBoards) then

 Begin
    SavedBoard  := Board;
    Done := False;
    TmpBrd :=i;
    AskedHelp := FaLSE;
  Repeat
    Changed := False;
    ActualLoadMsgBoard(Brd,TmpBrd,TRUE);
  IF (Not AskedHelp) then
    Begin
     Cls;
     with Brd do
     Begin
      print('Message base #'+cstr(TmpBrd)+' of '+cstr(MaxBoards));
     nl;
      sprint     ('1) Name        : '+#3#5+Name);
      print      ('2) FileName    : '+FileName);
      print      ('3) MsgBase Type: '+BaseType);
      print      ('   MsgBase Path: '+path);
      if (EchoBase in Brd.MsgBaseType) then
      print      ('T) ag Name     : '+TAGName);
      print      ('4) Anon Types  : '+ATypes);
      print      ('5) Acs         : '+Acs);
      print      ('6) MaxMessages : '+Cstrl(MaxMessages));
      sprompt    ('7) Kill Recv   : ');
         if (KillRecieved)
            then print('Yes ') else print ('No ');
       print     ('8) Oldest Mail : '+Cstrl(OldMail));
      print      ('9) Password    : '+Password);
  If (Echobase in MsgBaseType) or
     (NetBAse in MsgBAseType) then
      print      ('A) ddress      : '+GetAddress(Systat.Addr[AKA].Zone,Systat.Addr[AKA].Net,
                                              Systat.Addr[AKA].Node,Systat.Addr[AKA].Point));
  If (Echobase in MsgBaseType) then
      print      ('B) Downlink Lst  ');
      prompt     ('C) Colors      :');
     prompt                        (' Text='+cstr(network.text_color)+
                                    ' Quote='+cstr(network.quote_color));
              if (EchoBase in MsgBaseType) then
                              print(' Tear='+cstr(network.tear_color)+
                                    ' Origin='+cstr(network.origin_color)) else nl;
  if (EchoBase in MsgBAseType) then
      print      ('M) Echo Flags  : '+NetWorkFlags);
  if (EchoBase in MsgBAseType) then
      print      ('O) rigin Line  : '+Network.Origin);
  End;
 End;
  AskedHelp := False;
      nl;
    sprompt(#3#4+'MsgEdit Menu (?=Help) :');
    Onek(ch,'123456789ABCFJLMOT?][Q'^M);
    nl;
    With Brd do
      Begin
    Case Ch of
       '1' : Begin
               prt('New name: ');
                cl(5); inputwnwc(Name,40,changed);
             End;

              '2':begin
                    getbrdspec(s1);
                    prt('New filename: '); mpl(8); input(s,8); s:=sqoutsp(s);
                    if (pos('.',s)>0) then filename:=copy(s,1,pos('.',s)-1);
                    if (s<>'') then
                    begin
                      if (s<>filename) then changed:=TRUE;
                      filename:=s;
                      getbrdspec(s2);
                      if ((exist(s1)) and (not exist(s2))) then
                      begin
                        nl;
                        print('Old *.HDR *.LRP *.TXT:           "'+copy(s1,1,pos('.',s1)-1)+'.*"');
                        print('New *.HDR *.LRP *.TXT FileNames: "'+copy(s2,1,pos('.',s2)-1)+'.*"');
                        nl;
                        if pynq('Rename old filenames to new filenames? ') then
                        begin
                          s3:=s1;
                          Err:=FALSE;
                          assign(f,s1);
                          {$I-} rename(f,s2); {$I+}
                          if (ioresult<>0) then begin
                            print('Error renaming *.HDR filename.');
                            err:=TRUE;
                          end;
                          s1:=copy(s3,1,pos('.',s3)-1)+'.TXT';
                          s2:=copy(s2,1,pos('.',s2)-1)+'.TXT';
                          assign(f,s1);
                          {$I-} rename(f,s2); {$I+}
                          if (ioresult<>0) then begin
                            print('Error renaming *.TXT filename.');
                            err:=TRUE;
                          end;
                          s1:=copy(s3,1,pos('.',s3)-1)+'.LRP';
                          s2:=copy(s2,1,pos('.',s2)-1)+'.LRP';
                          assign(f,s1);
                          {$I-} rename (f,s2); {$I+}
                          if (ioresult<>0) then begin
                            print('Error renaming *.LRP filename.');
                            err:=TRUE;
                          end;
                          if err then pausescr;
                        end;
                      end;
                    end;
                  end;
       '3':begin
                    changed:=TRUE;
                    prt('L)ocal E)choMail N)etMail Message base?: ');
                    onek(ch,'ENL'^M);
                    case ch of
                      'L' : MakeLocal;
                      'E' : MakeEcho;
                      'N' : MakeNet;
                    end;
                      nl;
                      prompt('Current message path: ');
                      s:=path;
                      if (path<>'') then print(path) else
                       begin
                        print('*NONE*');
                        s:=systat.msgpath+filename+'\';
                       end;
                      nl; print('Press <CR> to use default path "'+systat.msgpath+filename+'\"');
                      nl; print('Enter new message path:');
                      prt(':'); mpl(40); inputpre(s,40); s:=sqoutsp(s);
                      if (s<>'') then
                      begin
                        while (copy(s,length(s)-1,2)='\\') do s:=copy(s,1,length(s)-1);
                        if (copy(s,length(s),1)<>'\') then s:=s+'\';
                        path:=s;
                      end;
                      if ((s='') and (path='')) then path:=systat.msgpath+filename+'\';
                      if (not existdir(path)) then
                      begin
                        nl; print('"'+path+'" does not exist.');
                        if (pynq('Create message directory now? ')) then begin
                          {$I-} mkdir(bslash(FALSE,path)); {$I+}
                          if (ioresult<>0) then
                          begin
                            print('Errors creating directory.');
                            pausescr;
                          end;
                        end;
                      end else
                      begin
                        nl; print('"'+path+'" ALREADY EXISTS!'); nl;
                        print('Make SURE that this path is the one you REALLY want');
                        print('to use, or messages may be inadvertantly mixed!');
                        nl; pausescr;
                      end;
                   End;
         '4':begin
                    prt('Anonymous types:');
                    nl; nl;
                    lcmds(40,3,'Yes, alias allowed, selectively','');
                    lcmds(40,3,'No, RealName Only','');
                    lcmds(40,3,'Forced Alias','');
                    lcmds(40,3,'Dear Abby','');
                    lcmds(40,3,'Any Name','');
                    nl; prt('New Anon. type (YNFDA) : ');
                    onek(Ch,'QYNFDA'^M);
                    if (pos(ch,'YNFDA')<>0) then begin
                       AnonType := [];
                      case Ch of
                        'Y':Begin
                             AnonType := [UseAlias]
                            End;
                        'N':AnonType := [RealNameOnly];      { Keep It clear }
                        'F':Begin
                             AnonType := [ForceAlias];
                            End;
                        'D':Begin
                             AnonType := [DearAbby];
                            End;
                        'A':Begin
                             AnonType :=[UserSelect];
                            End;
                      end;
                     Changed := True;
                    end;
                  end;
          '5' :begin
                     prt('New ACS: '); mpl(20);
                     inputwn(acs,20,changed);
                   end;
          '6':begin
                    prt('Max messages: '); mpl(5); inu(i);
                    if (not badini) then begin
                      if (i<>maxmessages) then changed:=TRUE;
                      maxmessages:=i;
                    end;
                    if (maxmessages<10) then maxmessages:=10;
                    if (maxmessages> 1000000000) then maxmessages:=1000000000;
                  end;
          '7' : Begin
                 Changed := TRue;
                 KillRecieved := Not KillRecieved;
                End;

          '8':begin
                 prt('Maximum Days to keep Mail: '); mpl(5); inu(i);
                    if (not badini) then
                    begin
                      if (i<>OldMail) then changed:=TRUE;
                      OldMail:=i;
                    end;
                    if (OldMail<0) then OldMail:=0;
                    if (OldMail> 354) then OldMail:=354;
                  end;
       '9' : Begin
               prt('New Password: ');
                 mpl(25); inputwn1(password,25,'u',changed);
             End;

     'A':if (EchoBase in MsgBaseType) then
                begin
                    s:=getaddress(Systat.Addr[1].zone,Systat.Addr[1].net,
                                  Systat.Addr[1].node,Systat.Addr[1].point);
                    if pynq('Use default address ('+s+')? ') then
                       AKA := 1 else
                    begin
                     nl;
                     for I := 1 to MaxAka do
            print(MakeLength(2,Cstr(i))+'] '+getAddress(Systat.Addr[i].Zone,
                Systat.Addr[i].Net,Systat.Addr[i].Node,Systat.Addr[i].Point)
                +Systat.Addr[i].Domain);
                       nl;nl;
                      prt('Enter New AKA # : '); inu(i);
                      if (not badini) then AKA:=i;
                    end;
                    changed:=TRUE;
                  end;
      'B':if (EchoBase in MsgBaseType) then   DoDownlinks;
              'C': With NetWork Do
                  begin
                    if (EchoBase in MsgBaseType) then
                     begin
                      incolor('Tear Line',tear_color);
                      incolor('Origin Line',origin_color);
                     end;
                     incolor('Standard Text',text_color);
                     incolor('Quoted Text',quote_color);
                     Changed := True;
                  End;
            'M':begin
                    if (EchoBase in MsgBaseType) then
                   repeat
                    with Network do
                    Begin
                    nl;
{  sprint(#3#5+NetWorkflags); }
                     sprompt(#3#3+'Flags (?)Help (Q)uit :');
                      onek(CH,'KSOT?Q'^M);
                      case Ch of
                        ^M,'Q': ;
                        '?':begin
                              nl;
                              lcmds(22,3,'Kludge line strip','Tear/Origin ADD');
                              lcmds(22,3,'SEEN-BY line strip','');
                              lcmds(22,3,'Origin line strip','');
                              nl;
                            end;
                        'K': skludge := not skludge;
                        'S': sseenby := not sseenby;
                        'O': sorigin := not sorigin;
                           {'C': scenter := not scenter;}
                           {'B': sbox    := not sbox;   }
                           {'M': mcenter := not mcenter;}
                        'T': addtear := not addtear;
                      end;
                   End; { Do }
                    until ((Ch in [^M,'Q']) or (hangup));
                    if (EchoBase in MsgBaseType)
                         then changed:=TRUE;
                   end;
           'O':if (EchoBase in MsgBAseType) then
                 begin
                    print('Enter new origin line');
                    prt(':'); mpl(50); inputwn1(Network.origin,50,'',changed);
                  end;
              '[':if (TmpBrd>1) then dec(TmpBrd);
              ']':if (TmpBrd<Maxboards) then inc(TmpBrd);
              'F':if (TmpBrd<>1) then TmpBrd:=1;
              'J':begin
                    prt('Jump to entry: ');
                    input(s,3);
                    if (value(s)>=1) and (value(s)<=MaxBoards) then
                       TmpBrd:=value(s);
                  end;
              'L':if (TmpBrd<>Maxboards) then TmpBrd:=MaxBoards;
              '?':begin
                    AskedHelp := True;
                    sprint(' #:Modify item   <CR>Redisplay screen');
                    lcmds(15,3,'[Back entry',']Forward entry');
                    lcmds(15,3,'Jump to entry','First entry in list');
                    lcmds(15,3,'Quit and save','Last entry in list');
                    nl;
                  end;
             'T': Begin
                  print('Tagname for this echo is '+TagName);
                   S := TagName;
                   prt('New : '); mpl(45);
                   InputPre(TagName,45);
                   TagName := AllCaps(TagName);
                   If (S <> TagName)
                      then  Changed := TRUE;
                  End;

             'Q' : Done := TRue;

           End; { Case }
           If (Changed) then
             Begin
                 Save_BrdFile(Brd,TmpBrd);
             End;
      End; {Do }
   Until (Done) or (Hangup);
   End;
   ActualLoadMsgBoard(Brd,SavedBoard,TRUE);
End;


Procedure MsgEditMenu;
Var
 Abort,Next,Done : Boolean;
 Ch   : Char;
 Str  : String;
 I    : integer;
 AskedHelp      : Boolean;
 ii             : Integer;
 SavedBoard  : MsgBoardsREcord;

 Begin
      SavedBoard :=Brd;
      Done := False;
      AskedHelp := False;
      repeat
       Abort := False;
       Next := False;
    if (Not AskedHelp) then
       Begin
          cls;
       printacr(#3#3+' Num      Board Type           Board Name',abort,next);
       printacr(#3#4+'',abort,next);
    ii := 0;
    While (II < MaxBoards) and (NOT ABORT) do
     Begin
     Inc(ii);
      ActualLoadMsgBoard(Brd,ii,False);
      with Brd do
      Begin
       Str := #3#5+' ';
       Str := Str + Cstrl(ii);
       Str := MakeLength(12,Str);
       Str := Str + BaseType;
       Str := MakeLength(33,Str);
       Str := Str + Name;
       Str := MakeLength(59,Str);
      printacr(Str,abort,done);
     End; { For }
   End; { Do }
 End;
     If (AskedHelp) then
        AskedHelp := False;
     nl;
    sprompt(#3#4+'MsgEdit Menu (?=Help) :');
     onek(ch,'SIMDQ?'^M);
     nl;
     Case Ch of
      ^M  : ;
      'S' : AskMoveBase;
      'I' : AskInsertBase;
      'M' : MsgBaseEdit;
      'D' : AskDeleteBase;
      'Q' : Done := True;
      '?' : Begin
             AskedHelp := True;
             sprint(' <CR>Redisplay screen');
             lcmds(15,3,'SSwitch/Move Base','Modify Base');
             lcmds(15,3,'Delete Base','Insert Base');
             lcmds(15,3,'Quit',' ');
             nl;
            End;

    End; { Case }

  Until (Done) or (HangUp);
   Brd := SavedBoard;
End;


End.
