(*****************************************************************************)
(*>                                                                         <*)
(*>  MISC1   .PAS -  Written by Eric Oman                                   <*)
(*>                                                                         <*)
(*>  Various miscellaneous functions used by the BBS.                       <*)
(*>                                                                         <*)
(*>                                                                         <*)
(*****************************************************************************)
{$A+,B+,D-,E+,F+,I+,L+,N-,O+,R-,S+,V-}
unit misc1;

interface

uses
  OPcrt, dos, overlay,
  common;

procedure reqchat(x:astr);
procedure TimeBank(s:astr);
function ctp(t,b:longint):astr;

implementation
Uses
 Msg1,Msg2;

procedure reqchat(x:astr);
var c,ii,i:integer;
    r:char;
    chatted:boolean;
    s,why:astr;
begin
  why:='';

  if (pos(';',x)<>0) then why:=copy(x,pos(';',x)+1,length(x));
  if (why='') then why:='^3Why do you want to chat?';
  nl;
  if ((chatt<systat.maxchat) or (cso)) then begin
    sprint(why);
    chatted:=FALSE;

    prt(':'); mpl(70); inputl(s,70);

    if (s<>'') then begin
      inc(chatt);
      if ((not sysop) or (rchat in thisuser.ac)) then
        if (length(s)<64) then
          sysoplog(#3#4+'Chat attempt: "'+#3#5+s+#3#4+'"')
        else begin
          sysoplog(#3#4+'Chat attempt:');
          sl1(#3#4+' "'+#3#5+s+#3#4+'"');
        end
      else begin
        sl1(#3#4+'Chat: "'+#3#5+s+#3#4+'"');
        commandline('Press <SPACE> to chat or <ENTER> to SHUT UP for rest of call');
        nl;
        sprint(fstring.chatcall1);
        nl;
        ii:=0; c:=0;
        repeat
          inc(ii);
          if (outcom) then sendcom1(^G);
          sprompt(fstring.chatcall2);
          if (outcom) then sendcom1(^G);
          if (shutupchatcall) then delay(1500)
          else
            for i:=1 to 5 do
            begin
             sound(1100); delay(10);
             sound(1200); delay(20);
             sound(1300); delay(30);
             sound(1400);   delay(40);
             sound(1500);   delay(50);
             sound(1500);   delay(10);
             sound(1400);   delay(20);
             sound(1300);   delay(30);
             sound(1200);   delay(40);
             sound(1100);   delay(50);
            end;
       nosound;
          if (keypressed) then begin
            r:=readkey;
            case r of
              #32:begin
                    commandline('');
                    chatted:=TRUE; chatt:=0;
                    pap:=0;
                    chat;
                  end;
               ^M:shutupchatcall:=TRUE;
            end;
          end;
        until ((chatted) or (ii=9) or (hangup));
        commandline('');
      end;
      if (not chatted) then
      begin
        chatr:=s;
        printf('nosysop');
        Emailuser(Cstr(Systat.SysopMessage),'');
      end else
        chatr:='';
      tleft;
    end;
  end else

  begin
    printf('goaway');
    sysoplog('Tried chatting more than '+cstr(systat.maxchat)+' times');
    Emailuser(Cstr(Systat.SysopMessage),'ChatReq #'+Cstr(Systat.MaxChat));
  end;
end;

procedure TimeBank(s:astr);
var lng,maxperday,maxever:longint;
    zz:integer;
    oc:astr;
    c:char;

  function cantdeposit:boolean;
  begin
    cantdeposit:=TRUE;
    if ((thisuser.timebankadd>=maxperday) and (maxperday<>0)) then exit;
    if ((thisuser.timebank>=maxever) and (maxever<>0)) then exit;
    cantdeposit:=FALSE;
  end;

begin
  maxperday:=value(s); maxever:=0;
  if (pos(';',s)<>0) then maxever:=value(copy(s,pos(';',s)+1,length(s)));
  if ((maxever<>0) and (thisuser.timebank>maxever)) then
    thisuser.timebank:=maxever;
  nl; nl;
  sprint('^5'+softwarename+' Time Bank v'+ver);
  nl;
  if (not cantdeposit) then
    sprint('^3A^1)dd time to your account.');
  sprint('^3G^1)oodbye, log off now.');
  sprint('^3Q^1)uit to BBS.');
  if (choptime=0.0) then
    sprint('^3W^1)ithdraw time from your account.');
  nl;
  if (choptime<>0.0) then
    sprint(#3#7+'You cannot withdraw time during this call.');
  if (cantdeposit) then begin
    if ((thisuser.timebankadd>=maxperday) and (maxperday<>0)) then
      sprint(#3#7+'You cannot add any more time to your account today.');
    if ((thisuser.timebank>=maxever) and (maxever<>0)) then
      sprint(#3#7+'You cannot add any more time to your account!');
  end;
  nl;
  sprompt(#3#5+'In your account: '+#3#3+cstr(thisuser.timebank)+
          #3#5+'   Time left online: '+#3#3+cstr(trunc(nsl) div 60));
  if (thisuser.timebankadd<>0) then
    sprompt('   ^5Deposited today: ^3'+cstr(thisuser.timebankadd));
  nl;
  sprompt(#3#5+'Account limits: '+#3#3);
  if (maxever<>0) then sprompt(cstr(maxever)+' max')
    else sprompt('No max limit');
  if (maxperday<>0) then sprompt(' / '+cstr(maxperday)+' per day');
  nl; nl;
  prt('Time Bank :');
  oc:='QG';
  if (choptime=0.0) then oc:=oc+'W';
  if (not cantdeposit) then oc:=oc+'A';
  onek(c,oc);
  case c of
    'A':begin
          prt('Add how many minutes? '); inu(zz); lng:=zz;
          nl;
          if (not badini) then
            if (lng>0) then
              if (lng>trunc(nsl) div 60) then
                sprint(#3#7+'You don''t have that much time left to deposit!')
              else
                if (lng+thisuser.timebankadd>maxperday) and (maxperday<>0) then
                  sprint(#3#7+'You can only add '+cstr(maxperday)+' minutes to your account per day!')
                else
                  if (lng+thisuser.timebank>maxever) and (maxever<>0) then
                    sprint(#3#7+'Your account deposit limit is '+cstr(maxever)+' minutes!')
                  else begin
                    inc(thisuser.timebankadd,lng);
                    inc(thisuser.timebank,lng);
                    dec(thisuser.tltoday,lng);
                    sprint('^5In your account: ^3'+cstr(thisuser.timebank)+
                           '^5   Time left online: ^3'+cstr(trunc(nsl) div 60));
                    sysoplog('TimeBank: Deposited '+cstr(lng)+' minutes.');
                  end;
              end;
          'G':hangup:=TRUE;
          'W':begin
                prt('Withdraw how many minutes? '); inu(zz); lng:=zz;
                nl;
                if (not badini) then
                  if (lng>thisuser.timebank) then
                    sprint(#3#7+'You don''t have that much time left in your account!')
                  else
                    if (lng>0) then begin
                      dec(thisuser.timebankadd,lng);
                      if (thisuser.timebankadd<0) then thisuser.timebankadd:=0;
                      dec(thisuser.timebank,lng);
                      inc(thisuser.tltoday,lng);
                      sprint('^5In your account: ^3'+cstr(thisuser.timebank)+
                             '^5   Time left online: ^3'+cstr(trunc(nsl) div 60));
                      sysoplog('TimeBank: Withdrew '+cstr(lng)+' minutes.');
                    end;
                  end;
  end;
end;

function ctp(t,b:longint):astr;
var s,s1:astr;
    n:real;
begin
  if ((t=0) or (b=0)) then begin
    ctp:='  0.0%';
    exit;
  end;
  n:=(t*100)/b;
  str(n:5:1,s);
  s:=s+'%';
  ctp:=s;
end;


end.
